/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.browser.typehierarchy;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.browser.TypeUtil;
import org.eclipse.cdt.core.browser.typehierarchy.ITypeHierarchy;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.internal.ui.browser.typehierarchy.TypeHierarchyLifeCycle;
import org.eclipse.cdt.ui.CElementContentProvider;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;

public class MethodsContentProvider
extends CElementContentProvider {
    private static final Object[] NO_ELEMENTS = new Object[0];
    private boolean fShowInheritedMethods;
    private TypeHierarchyLifeCycle fHierarchyLifeCycle;
    private TableViewer fViewer;

    public MethodsContentProvider(TypeHierarchyLifeCycle lifecycle) {
        this.fHierarchyLifeCycle = lifecycle;
        this.fShowInheritedMethods = false;
        this.fViewer = null;
    }

    public void showInheritedMethods(boolean show) {
        if (show != this.fShowInheritedMethods) {
            this.fShowInheritedMethods = show;
            if (this.fViewer != null) {
                this.fViewer.refresh();
            }
        }
    }

    public boolean providesWorkingCopies() {
        return true;
    }

    public boolean isShowInheritedMethods() {
        return this.fShowInheritedMethods;
    }

    private void addAll(Object[] arr, List res) {
        if (arr != null) {
            int j = 0;
            while (j < arr.length) {
                res.add(arr[j]);
                ++j;
            }
        }
    }

    public Object[] getElements(Object element) {
        if (element instanceof ICElement) {
            ICElement type = (ICElement)element;
            ArrayList res = new ArrayList();
            ITypeHierarchy hierarchy = this.fHierarchyLifeCycle.getHierarchy();
            if (this.fShowInheritedMethods && hierarchy != null) {
                ICElement[] allSupertypes = hierarchy.getAllSupertypes(type);
                int i = allSupertypes.length - 1;
                while (i >= 0) {
                    ICElement superType = allSupertypes[i];
                    if (superType.exists()) {
                        this.addAll(TypeUtil.getMethods((ICElement)superType), res);
                        this.addAll(TypeUtil.getFields((ICElement)superType), res);
                    }
                    --i;
                }
            }
            if (type.exists()) {
                this.addAll(TypeUtil.getMethods((ICElement)type), res);
                this.addAll(TypeUtil.getFields((ICElement)type), res);
            }
            return res.toArray();
        }
        return NO_ELEMENTS;
    }

    public void inputChanged(Viewer input, Object oldInput, Object newInput) {
        Assert.isTrue((boolean)(input instanceof TableViewer));
        this.fViewer = (TableViewer)input;
    }

    public void dispose() {
    }
}

