/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text;

import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultIndentLineAutoEditStrategy;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;

public class CAutoIndentStrategy
extends DefaultIndentLineAutoEditStrategy {
    protected int findMatchingOpenBracket(IDocument d, int line, int end, int closingBracketIncrease) throws BadLocationException {
        int start = d.getLineOffset(line);
        int brackcount = this.getBracketCount(d, start, end, false) - closingBracketIncrease;
        while (brackcount < 0) {
            if (--line < 0) {
                return -1;
            }
            start = d.getLineOffset(line);
            end = start + d.getLineLength(line) - 1;
            brackcount += this.getBracketCount(d, start, end, false);
        }
        return line;
    }

    private int getBracketCount(IDocument d, int start, int end, boolean ignoreCloseBrackets) throws BadLocationException {
        int bracketcount = 0;
        block7: while (start < end) {
            char curr = d.getChar(start);
            ++start;
            switch (curr) {
                case '/': {
                    if (start >= end) break;
                    char next = d.getChar(start);
                    if (next == '*') {
                        start = this.getCommentEnd(d, start + 1, end);
                        break;
                    }
                    if (next != '/') break;
                    start = end;
                    break;
                }
                case '*': {
                    char next;
                    if (start >= end || (next = d.getChar(start)) != '/') continue block7;
                    bracketcount = 0;
                    ++start;
                    break;
                }
                case '{': {
                    ++bracketcount;
                    ignoreCloseBrackets = false;
                    break;
                }
                case '}': {
                    if (ignoreCloseBrackets) break;
                    --bracketcount;
                    break;
                }
                case '\"': 
                case '\'': {
                    start = this.getStringEnd(d, start, end, curr);
                }
            }
        }
        return bracketcount;
    }

    private int getCommentEnd(IDocument d, int pos, int end) throws BadLocationException {
        while (pos < end) {
            char curr = d.getChar(pos);
            if (curr != '*' || ++pos >= end || d.getChar(pos) != '/') continue;
            return pos + 1;
        }
        return end;
    }

    protected String getIndentOfLine(IDocument d, int line) throws BadLocationException {
        if (line > -1) {
            int start = d.getLineOffset(line);
            int end = start + d.getLineLength(line) - 1;
            int whiteend = this.findEndOfWhiteSpace(d, start, end);
            return d.get(start, whiteend - start);
        }
        return "";
    }

    private int getStringEnd(IDocument d, int pos, int end, char ch) throws BadLocationException {
        while (pos < end) {
            char curr = d.getChar(pos);
            ++pos;
            if (curr == '\\') {
                ++pos;
                continue;
            }
            if (curr != ch) continue;
            return pos;
        }
        return end;
    }

    protected void smartInsertAfterBracket(IDocument d, DocumentCommand c) {
        if (c.offset == -1 || d.getLength() == 0) {
            return;
        }
        try {
            int indLine;
            int p = c.offset == d.getLength() ? c.offset - 1 : c.offset;
            int line = d.getLineOfOffset(p);
            int start = d.getLineOffset(line);
            int whiteend = this.findEndOfWhiteSpace(d, start, c.offset);
            if (whiteend == c.offset && (indLine = this.findMatchingOpenBracket(d, line, c.offset, 1)) != -1 && indLine != line) {
                StringBuffer replaceText = new StringBuffer(this.getIndentOfLine(d, indLine));
                replaceText.append(d.get(whiteend, c.offset - whiteend));
                replaceText.append(c.text);
                c.length = c.offset - start;
                c.offset = start;
                c.text = replaceText.toString();
            }
        }
        catch (BadLocationException excp) {
            CUIPlugin.getDefault().log(excp);
        }
    }

    protected void smartIndentAfterNewLine(IDocument d, DocumentCommand c) {
        int docLength = d.getLength();
        if (c.offset == -1 || docLength == 0) {
            return;
        }
        try {
            int p = c.offset == docLength ? c.offset - 1 : c.offset;
            int line = d.getLineOfOffset(p);
            StringBuffer buf = new StringBuffer(c.text);
            if (c.offset < docLength && d.getChar(c.offset) == '}') {
                int indLine = this.findMatchingOpenBracket(d, line, c.offset, 0);
                if (indLine == -1) {
                    indLine = line;
                }
                buf.append(this.getIndentOfLine(d, indLine));
            } else {
                int start = d.getLineOffset(line);
                int whiteend = this.findEndOfWhiteSpace(d, start, c.offset);
                buf.append(d.get(start, whiteend - start));
                if (this.getBracketCount(d, start, c.offset, true) > 0) {
                    buf.append('\t');
                }
            }
            c.text = buf.toString();
        }
        catch (BadLocationException excp) {
            CUIPlugin.getDefault().log(excp);
        }
    }

    private boolean endsWithDelimiter(IDocument d, String txt) {
        String[] delimiters = d.getLegalLineDelimiters();
        int i = 0;
        while (i < delimiters.length) {
            if (txt.endsWith(delimiters[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void customizeDocumentCommand(IDocument d, DocumentCommand c) {
        if (c.length == 0 && c.text != null && this.endsWithDelimiter(d, c.text)) {
            this.smartIndentAfterNewLine(d, c);
        } else if ("}".equals(c.text)) {
            this.smartInsertAfterBracket(d, c);
        }
    }
}

