/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core.scannerconfig;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IPathEntryContainer;
import org.eclipse.cdt.core.model.IPathEntryContainerExtension;
import org.eclipse.cdt.core.model.PathEntryContainerChanged;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.core.scannerconfig.IDiscoveredPathManager;
import org.eclipse.cdt.make.core.scannerconfig.IScannerConfigBuilderInfo2;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoCollector;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoCollector2;
import org.eclipse.cdt.make.core.scannerconfig.ScannerConfigScope;
import org.eclipse.cdt.make.internal.core.MakeMessages;
import org.eclipse.cdt.make.internal.core.scannerconfig.DiscoveredPathContainer;
import org.eclipse.cdt.make.internal.core.scannerconfig.DiscoveredPathInfo;
import org.eclipse.cdt.make.internal.core.scannerconfig.DiscoveredScannerInfoStore;
import org.eclipse.cdt.make.internal.core.scannerconfig.PerFileDiscoveredPathContainer;
import org.eclipse.cdt.make.internal.core.scannerconfig2.SCProfileInstance;
import org.eclipse.cdt.make.internal.core.scannerconfig2.ScannerConfigProfileManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;

public class DiscoveredPathManager
implements IDiscoveredPathManager,
IResourceChangeListener {
    private Map fDiscoveredMap = new HashMap();
    private List listeners = Collections.synchronizedList(new ArrayList());
    private static final int INFO_CHANGED = 1;
    private static final int INFO_REMOVED = 2;

    public void startup() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    public void shutdown() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getSource() instanceof IWorkspace) {
            IResource resource = event.getResource();
            switch (event.getType()) {
                case 1: {
                    DiscoveredScannerInfoStore.getInstance().updateScannerConfigStore(event.getDelta());
                    break;
                }
                case 2: 
                case 4: {
                    if (resource.getType() != 4) break;
                    this.fDiscoveredMap.remove(resource);
                }
            }
        }
    }

    public IDiscoveredPathManager.IDiscoveredPathInfo getDiscoveredInfo(IProject project) throws CoreException {
        IDiscoveredPathManager.IDiscoveredPathInfo info = (IDiscoveredPathManager.IDiscoveredPathInfo)this.fDiscoveredMap.get(project);
        if (info == null) {
            info = this.loadPathInfo(project);
            this.fDiscoveredMap.put(project, info);
        }
        return info;
    }

    private IDiscoveredPathManager.IDiscoveredPathInfo loadPathInfo(IProject project) throws CoreException {
        IDiscoveredPathManager.IDiscoveredPathInfo pathInfo = null;
        IScannerConfigBuilderInfo2 buildInfo = ScannerConfigProfileManager.createScannerConfigBuildInfo2(project);
        String profileId = buildInfo.getSelectedProfileId();
        SCProfileInstance profileInstance = ScannerConfigProfileManager.getInstance().getSCProfileInstance(project, profileId);
        IScannerInfoCollector collector = profileInstance.getScannerInfoCollector();
        if (collector instanceof IScannerInfoCollector2) {
            IScannerInfoCollector2 collector2 = (IScannerInfoCollector2)collector;
            pathInfo = collector2.createPathInfoObject();
        } else {
            pathInfo = new DiscoveredPathInfo(project);
        }
        return pathInfo;
    }

    public void removeDiscoveredInfo(IProject project) {
        IDiscoveredPathManager.IDiscoveredPathInfo info = (IDiscoveredPathManager.IDiscoveredPathInfo)this.fDiscoveredMap.remove(project);
        if (info != null) {
            this.fireUpdate(2, info);
        }
    }

    public void updateDiscoveredInfo(IDiscoveredPathManager.IDiscoveredPathInfo info, List changedResources) throws CoreException {
        if (this.fDiscoveredMap.get(info.getProject()) != null) {
            IDiscoveredPathManager.IDiscoveredScannerInfoSerializable serializable = info.getSerializable();
            if (serializable != null) {
                IProject project = info.getProject();
                DiscoveredScannerInfoStore.getInstance().saveDiscoveredScannerInfoToState(project, serializable);
                this.fireUpdate(1, info);
                IScannerConfigBuilderInfo2 buildInfo = ScannerConfigProfileManager.createScannerConfigBuildInfo2(project);
                String profileId = buildInfo.getSelectedProfileId();
                ScannerConfigScope profileScope = ScannerConfigProfileManager.getInstance().getSCProfileConfiguration(profileId).getProfileScope();
                this.changeDiscoveredContainer(project, profileScope, changedResources);
            } else {
                throw new CoreException((IStatus)new Status(4, MakeCorePlugin.getUniqueIdentifier(), -1, MakeMessages.getString("DiscoveredPathManager.Info_Not_Serializable"), null));
            }
        }
    }

    public void changeDiscoveredContainer(final IProject project, final ScannerConfigScope profileScope, final List changedResources) {
        IDiscoveredPathManager.IDiscoveredPathInfo oldInfo = (IDiscoveredPathManager.IDiscoveredPathInfo)this.fDiscoveredMap.remove(project);
        try {
            IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    ICProject cProject = CoreModel.getDefault().create(project);
                    if (ScannerConfigScope.PROJECT_SCOPE.equals(profileScope)) {
                        CoreModel.setPathEntryContainer((ICProject[])new ICProject[]{cProject}, (IPathEntryContainer)new DiscoveredPathContainer(project), null);
                    } else if (ScannerConfigScope.FILE_SCOPE.equals(profileScope)) {
                        PerFileDiscoveredPathContainer container = new PerFileDiscoveredPathContainer(project);
                        CoreModel.setPathEntryContainer((ICProject[])new ICProject[]{cProject}, (IPathEntryContainer)container, null);
                        if (changedResources != null) {
                            ArrayList<PathEntryContainerChanged> changeDelta = new ArrayList<PathEntryContainerChanged>(changedResources.size());
                            Iterator i = changedResources.iterator();
                            while (i.hasNext()) {
                                IResource resource = (IResource)i.next();
                                IPath path = resource.getFullPath();
                                changeDelta.add(new PathEntryContainerChanged(path, 3));
                            }
                            CoreModel.pathEntryContainerUpdates((IPathEntryContainerExtension)container, (PathEntryContainerChanged[])changeDelta.toArray(new PathEntryContainerChanged[changeDelta.size()]), null);
                        }
                    } else {
                        MakeCorePlugin.log((IStatus)new Status(4, MakeCorePlugin.getUniqueIdentifier(), 1, MakeMessages.getString("DiscoveredContainer.ScopeErrorMessage"), null));
                    }
                }
            };
            CoreModel.run((IWorkspaceRunnable)runnable, null);
        }
        catch (CoreException e) {
            MakeCorePlugin.log(e);
        }
        if (oldInfo != null) {
            this.fireUpdate(2, oldInfo);
        }
    }

    private void fireUpdate(final int type, final IDiscoveredPathManager.IDiscoveredPathInfo info) {
        Object[] list = this.listeners.toArray();
        int i = 0;
        while (i < list.length) {
            final IDiscoveredPathManager.IDiscoveredInfoListener listener = (IDiscoveredPathManager.IDiscoveredInfoListener)list[i];
            if (listener != null) {
                Platform.run((ISafeRunnable)new ISafeRunnable(){

                    public void handleException(Throwable exception) {
                        Status status = new Status(4, "org.eclipse.cdt.core", -1, CCorePlugin.getResourceString((String)"CDescriptorManager.exception.listenerError"), exception);
                        CCorePlugin.log((IStatus)status);
                    }

                    public void run() throws Exception {
                        switch (type) {
                            case 1: {
                                listener.infoChanged(info);
                                break;
                            }
                            case 2: {
                                listener.infoRemoved(info);
                            }
                        }
                    }
                });
            }
            ++i;
        }
    }

    public void addDiscoveredInfoListener(IDiscoveredPathManager.IDiscoveredInfoListener listener) {
        this.listeners.add(listener);
    }

    public void removeDiscoveredInfoListener(IDiscoveredPathManager.IDiscoveredInfoListener listener) {
        this.listeners.remove(listener);
    }
}

