/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.cview;

import org.eclipse.cdt.internal.ui.actions.SelectionConverter;
import org.eclipse.cdt.internal.ui.cview.CView;
import org.eclipse.cdt.internal.ui.cview.CViewActionGroup;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.views.framelist.BackAction;
import org.eclipse.ui.views.framelist.ForwardAction;
import org.eclipse.ui.views.framelist.FrameList;
import org.eclipse.ui.views.framelist.GoIntoAction;
import org.eclipse.ui.views.framelist.UpAction;

public class GotoActionGroup
extends CViewActionGroup {
    private BackAction backAction;
    private ForwardAction forwardAction;
    private GoIntoAction goIntoAction;
    private UpAction upAction;
    static /* synthetic */ Class class$0;

    public GotoActionGroup(CView cview) {
        super(cview);
    }

    public void fillContextMenu(IMenuManager menu) {
        IStructuredSelection celements = (IStructuredSelection)this.getContext().getSelection();
        IStructuredSelection selection = SelectionConverter.convertSelectionToResources((ISelection)celements);
        if (selection.size() == 1) {
            if (SelectionConverter.allResourcesAreOfType(selection, 2)) {
                menu.add((IAction)this.goIntoAction);
            } else {
                IProject project;
                IStructuredSelection resourceSelection = SelectionConverter.allResources(selection, 4);
                if (resourceSelection != null && !resourceSelection.isEmpty() && (project = (IProject)resourceSelection.getFirstElement()).isOpen()) {
                    menu.add((IAction)this.goIntoAction);
                }
            }
        }
    }

    public void fillActionBars(IActionBars actionBars) {
        actionBars.setGlobalActionHandler("goInto", (IAction)this.goIntoAction);
        actionBars.setGlobalActionHandler(ActionFactory.BACK.getId(), (IAction)this.backAction);
        actionBars.setGlobalActionHandler(ActionFactory.FORWARD.getId(), (IAction)this.forwardAction);
        actionBars.setGlobalActionHandler("up", (IAction)this.upAction);
        IToolBarManager toolBar = actionBars.getToolBarManager();
        toolBar.add((IAction)this.backAction);
        toolBar.add((IAction)this.forwardAction);
        toolBar.add((IAction)this.upAction);
    }

    protected void makeActions() {
        FrameList frameList = this.getCView().getFrameList();
        this.goIntoAction = new GoIntoAction(frameList);
        this.backAction = new BackAction(frameList);
        this.forwardAction = new ForwardAction(frameList);
        this.upAction = new UpAction(frameList);
    }

    public void updateActionBars() {
        Object object;
        IStructuredSelection selection;
        ActionContext context = this.getContext();
        boolean enable = false;
        if (context != null && (selection = (IStructuredSelection)this.getContext().getSelection()).size() == 1 && (object = selection.getFirstElement()) instanceof IAdaptable) {
            IResource resource;
            IAdaptable iAdaptable = (IAdaptable)object;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((resource = (IResource)iAdaptable.getAdapter((Class)clazz)) instanceof IProject) {
                enable = ((IProject)resource).isOpen();
            } else if (resource instanceof IFolder) {
                enable = true;
            }
        }
        this.goIntoAction.setEnabled(enable);
    }
}

