/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.ui.text.makefile;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.make.internal.ui.MakeUIPlugin;
import org.eclipse.cdt.make.internal.ui.text.ColorManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

public abstract class AbstractMakefileCodeScanner
extends RuleBasedScanner {
    private Map fTokenMap = new HashMap();
    private String[] fPropertyNamesColor;
    private String[] fPropertyNamesBold;
    private String[] fPropertyNamesItalic;

    protected abstract String[] getTokenProperties();

    protected abstract List createRules();

    public final void initialize() {
        this.fPropertyNamesColor = this.getTokenProperties();
        int length = this.fPropertyNamesColor.length;
        this.fPropertyNamesBold = new String[length];
        this.fPropertyNamesItalic = new String[length];
        int i = 0;
        while (i < length) {
            this.fPropertyNamesBold[i] = String.valueOf(this.fPropertyNamesColor[i]) + "_bold";
            this.fPropertyNamesItalic[i] = String.valueOf(this.fPropertyNamesColor[i]) + "_italic";
            this.addToken(this.fPropertyNamesColor[i], this.fPropertyNamesBold[i], this.fPropertyNamesItalic[i]);
            ++i;
        }
        this.initializeRules();
    }

    private void initializeRules() {
        List rules = this.createRules();
        if (rules != null) {
            IRule[] result = new IRule[rules.size()];
            rules.toArray(result);
            this.setRules(result);
        }
    }

    protected Token getToken(String key) {
        return (Token)this.fTokenMap.get(key);
    }

    private void addToken(String colorKey, String boldKey, String italicKey) {
        this.fTokenMap.put(colorKey, new Token((Object)this.createTextAttribute(colorKey, boldKey, italicKey)));
    }

    private int indexOf(String property) {
        if (property != null) {
            int length = this.fPropertyNamesColor.length;
            int i = 0;
            while (i < length) {
                if (property.equals(this.fPropertyNamesColor[i]) || property.equals(this.fPropertyNamesBold[i]) || property.equals(this.fPropertyNamesItalic[i])) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public boolean affectsBehavior(PropertyChangeEvent event) {
        return this.indexOf(event.getProperty()) >= 0;
    }

    public void adaptToPreferenceChange(PropertyChangeEvent event) {
        String p = event.getProperty();
        int index = this.indexOf(p);
        Token token = this.getToken(this.fPropertyNamesColor[index]);
        if (this.fPropertyNamesColor[index].equals(p)) {
            this.adaptToColorChange(event, token);
        } else if (this.fPropertyNamesBold[index].equals(p)) {
            this.adaptToStyleChange(event, token, 1);
        } else if (this.fPropertyNamesItalic[index].equals(p)) {
            this.adaptToStyleChange(event, token, 2);
        }
    }

    protected void adaptToColorChange(PropertyChangeEvent event, Token token) {
        RGB rgb = null;
        Object value = event.getNewValue();
        if (value instanceof RGB) {
            rgb = (RGB)value;
        } else if (value instanceof String) {
            rgb = StringConverter.asRGB((String)((String)value));
        }
        if (rgb != null) {
            TextAttribute attr = (TextAttribute)token.getData();
            token.setData((Object)new TextAttribute(ColorManager.getDefault().getColor(rgb), attr.getBackground(), attr.getStyle()));
        }
    }

    protected void adaptToStyleChange(PropertyChangeEvent event, Token token, int styleAttribute) {
        boolean activeValue;
        if (token == null) {
            return;
        }
        boolean eventValue = false;
        Object value = event.getNewValue();
        if (value instanceof Boolean) {
            eventValue = (Boolean)value;
        } else if ("true".equals(value)) {
            eventValue = true;
        }
        TextAttribute attr = (TextAttribute)token.getData();
        boolean bl = activeValue = (attr.getStyle() & styleAttribute) == styleAttribute;
        if (activeValue != eventValue) {
            token.setData((Object)new TextAttribute(attr.getForeground(), attr.getBackground(), eventValue ? attr.getStyle() | styleAttribute : attr.getStyle() & ~styleAttribute));
        }
    }

    protected TextAttribute createTextAttribute(String colorID, String boldKey, String italicKey) {
        IPreferenceStore store;
        int style;
        Color color = null;
        if (colorID != null) {
            color = MakeUIPlugin.getPreferenceColor(colorID);
        }
        int n = style = (store = MakeUIPlugin.getDefault().getPreferenceStore()).getBoolean(boldKey) ? 1 : 0;
        if (store.getBoolean(italicKey)) {
            style |= 2;
        }
        return new TextAttribute(color, null, style);
    }
}

