/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.CommandLauncher;
import org.eclipse.cdt.core.ConsoleOutputStream;
import org.eclipse.cdt.core.ErrorParserManager;
import org.eclipse.cdt.core.IMarkerGenerator;
import org.eclipse.cdt.core.resources.ACBuilder;
import org.eclipse.cdt.core.resources.IConsole;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.envvar.IBuildEnvironmentVariable;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedMakeMessages;
import org.eclipse.cdt.managedbuilder.macros.BuildMacroException;
import org.eclipse.cdt.managedbuilder.makegen.IManagedBuilderMakefileGenerator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;

public class GeneratedMakefileBuilder
extends ACBuilder {
    private static final String BUILD_ERROR = "ManagedMakeBuilder.message.error";
    private static final String BUILD_FINISHED = "ManagedMakeBuilder.message.finished";
    private static final String CONSOLE_HEADER = "ManagedMakeBuilder.message.console.header";
    private static final String ERROR_HEADER = "GeneratedmakefileBuilder error [";
    private static final String MAKE = "ManagedMakeBuilder.message.make";
    private static final String MARKERS = "ManagedMakeBuilder.message.creating.markers";
    private static final String NEWLINE = System.getProperty("line.separator");
    private static final String NOTHING_BUILT = "ManagedMakeBuilder.message.no.build";
    private static final String REFRESH = "ManagedMakeBuilder.message.updating";
    private static final String REFRESH_ERROR = "ManagedMakeBuilder.message.error.refresh";
    private static final String TRACE_FOOTER = "]: ";
    private static final String TRACE_HEADER = "GeneratedmakefileBuilder trace [";
    private static final String TYPE_CLEAN = "ManagedMakeBuilder.type.clean";
    private static final String TYPE_FULL = "ManagedMakeBuilder.type.full";
    private static final String TYPE_INC = "ManagedMakeBuider.type.incremental";
    private static final String WARNING_UNSUPPORTED_CONFIGURATION = "ManagedMakeBuilder.warning.unsupported.configuration";
    public static boolean VERBOSE = false;
    protected Vector generationProblems;
    protected IProject[] referencedProjects;
    protected List resourcesToBuild;

    public static void outputTrace(String resourceName, String message) {
        if (VERBOSE) {
            System.out.println(TRACE_HEADER + resourceName + TRACE_FOOTER + message + NEWLINE);
        }
    }

    public static void outputError(String resourceName, String message) {
        if (VERBOSE) {
            System.err.println(ERROR_HEADER + resourceName + TRACE_FOOTER + message + NEWLINE);
        }
    }

    private void addBuilderMarkers(ErrorParserManager epm) {
        IWorkspaceRoot root = CCorePlugin.getWorkspace().getRoot();
        Iterator iter = this.getGenerationProblems().iterator();
        while (iter.hasNext()) {
            IStatus stat = (IStatus)iter.next();
            IResource location = root.findMember(stat.getMessage());
            if (stat.getCode() != 0) continue;
            epm.generateMarker(location, -1, ManagedMakeMessages.getResourceString("MakefileGenerator.error.spaces"), 1, null);
        }
    }

    private void emitNoSourceMessage(int buildType, IStatus status, String configName) throws CoreException {
        try {
            StringBuffer buf = new StringBuffer();
            IConsole console = CCorePlugin.getDefault().getConsole();
            console.start(this.getProject());
            ConsoleOutputStream consoleOutStream = console.getOutputStream();
            String[] consoleHeader = new String[3];
            if (buildType == 6) {
                consoleHeader[0] = ManagedMakeMessages.getResourceString(TYPE_FULL);
            } else if (buildType == 10) {
                consoleHeader[0] = ManagedMakeMessages.getResourceString(TYPE_INC);
            } else {
                consoleHeader[0] = new String();
                GeneratedMakefileBuilder.outputError(this.getProject().getName(), "The given build type is not supported in this context");
            }
            consoleHeader[1] = configName;
            consoleHeader[2] = this.getProject().getName();
            buf.append(System.getProperty("line.separator", "\n"));
            buf.append(ManagedMakeMessages.getFormattedString(CONSOLE_HEADER, consoleHeader));
            buf.append(System.getProperty("line.separator", "\n"));
            buf.append(System.getProperty("line.separator", "\n"));
            buf.append(status.getMessage());
            buf.append(System.getProperty("line.separator", "\n"));
            consoleOutStream.write(buf.toString().getBytes());
            consoleOutStream.flush();
            consoleOutStream.close();
        }
        catch (CoreException e) {
            throw e;
        }
        catch (IOException iOException) {}
    }

    protected IManagedBuildInfo getBuildInfo() {
        return ManagedBuildManager.getBuildInfo((IResource)this.getProject());
    }

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        this.referencedProjects = this.getProject().getReferencedProjects();
        IManagedBuildInfo info = this.getBuildInfo();
        if (info == null) {
            GeneratedMakefileBuilder.outputError(this.getProject().getName(), "Build information was not found");
            return this.referencedProjects;
        }
        if (!info.isValid()) {
            GeneratedMakefileBuilder.outputError(this.getProject().getName(), "Build information is not valid");
            return this.referencedProjects;
        }
        IManagedBuilderMakefileGenerator generator = ManagedBuildManager.getBuildfileGenerator(info.getDefaultConfiguration());
        generator.initialize(this.getProject(), info, monitor);
        if (kind == 6 || info.needsRebuild()) {
            GeneratedMakefileBuilder.outputTrace(this.getProject().getName(), "Full build needed/requested");
            this.fullBuild(info, generator, monitor);
        } else if (kind == 9 && info.needsRebuild()) {
            GeneratedMakefileBuilder.outputTrace(this.getProject().getName(), "Autobuild requested, full build needed");
            this.fullBuild(info, generator, monitor);
        } else {
            ResourceDeltaVisitor visitor = new ResourceDeltaVisitor(info);
            IResourceDelta delta = this.getDelta(this.getProject());
            if (delta == null) {
                GeneratedMakefileBuilder.outputTrace(this.getProject().getName(), "Incremental build requested, full build needed");
                this.fullBuild(info, generator, monitor);
            } else {
                delta.accept((IResourceDeltaVisitor)visitor);
                if (visitor.shouldBuildFull()) {
                    GeneratedMakefileBuilder.outputTrace(this.getProject().getName(), "Incremental build requested, full build needed");
                    this.fullBuild(info, generator, monitor);
                } else if (visitor.shouldBuildIncr()) {
                    GeneratedMakefileBuilder.outputTrace(this.getProject().getName(), "Incremental build requested");
                    this.incrementalBuild(delta, info, generator, monitor);
                } else if (this.referencedProjects != null) {
                    int i = 0;
                    while (i < this.referencedProjects.length) {
                        IProject ref = this.referencedProjects[i];
                        IResourceDelta refDelta = this.getDelta(ref);
                        if (refDelta == null) {
                            GeneratedMakefileBuilder.outputTrace(this.getProject().getName(), "Incremental build because of changed referenced project");
                            this.incrementalBuild(delta, info, generator, monitor);
                            break;
                        }
                        int refKind = refDelta.getKind();
                        if (refKind != 0) {
                            int refFlags = refDelta.getFlags();
                            if (refKind != 4 || refFlags != 16384) {
                                GeneratedMakefileBuilder.outputTrace(this.getProject().getName(), "Incremental build because of changed referenced project");
                                this.incrementalBuild(delta, info, generator, monitor);
                                break;
                            }
                        }
                        ++i;
                    }
                }
            }
        }
        info.setRebuildState(false);
        return this.referencedProjects;
    }

    public void checkCancel(IProgressMonitor monitor) {
        if (monitor != null && monitor.isCanceled()) {
            GeneratedMakefileBuilder.outputTrace(this.getProject().getName(), "Build cancelled");
            this.forgetLastBuiltState();
            throw new OperationCanceledException();
        }
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        this.referencedProjects = this.getProject().getReferencedProjects();
        GeneratedMakefileBuilder.outputTrace(this.getProject().getName(), "Clean build requested");
        IManagedBuildInfo info = this.getBuildInfo();
        if (info == null) {
            GeneratedMakefileBuilder.outputError(this.getProject().getName(), "Build information was not found");
            return;
        }
        if (!info.isValid()) {
            GeneratedMakefileBuilder.outputError(this.getProject().getName(), "Build information is not valid");
            return;
        }
        IPath buildDirPath = this.getProject().getLocation().append(info.getConfigurationName());
        IWorkspace workspace = CCorePlugin.getWorkspace();
        IContainer buildDir = workspace.getRoot().getContainerForLocation(buildDirPath);
        if (buildDir == null || !buildDir.isAccessible()) {
            GeneratedMakefileBuilder.outputError(buildDir.getName(), "Could not delete the build directory");
            return;
        }
        try {
            String status = ManagedMakeMessages.getFormattedString("ManagedMakeBuilder.message.clean.deleting.output", buildDir.getName());
            monitor.subTask(status);
            workspace.delete(new IResource[]{buildDir}, true, monitor);
            StringBuffer buf = new StringBuffer();
            IConsole console = CCorePlugin.getDefault().getConsole();
            console.start(this.getProject());
            ConsoleOutputStream consoleOutStream = console.getOutputStream();
            String[] consoleHeader = new String[]{ManagedMakeMessages.getResourceString(TYPE_CLEAN), info.getConfigurationName(), this.getProject().getName()};
            buf.append(System.getProperty("line.separator", "\n"));
            buf.append(ManagedMakeMessages.getFormattedString(CONSOLE_HEADER, consoleHeader));
            buf.append(System.getProperty("line.separator", "\n"));
            consoleOutStream.write(buf.toString().getBytes());
            consoleOutStream.flush();
            buf = new StringBuffer();
            String successMsg = ManagedMakeMessages.getFormattedString(BUILD_FINISHED, this.getProject().getName());
            buf.append(successMsg);
            buf.append(System.getProperty("line.separator", "\n"));
            consoleOutStream.write(buf.toString().getBytes());
            consoleOutStream.flush();
            consoleOutStream.close();
        }
        catch (CoreException coreException) {
            String status = ManagedMakeMessages.getFormattedString("ManagedMakeBuilder.message.clean.build.clean", buildDir.getName());
            monitor.subTask(status);
            IManagedBuilderMakefileGenerator generator = ManagedBuildManager.getBuildfileGenerator(info.getDefaultConfiguration());
            generator.initialize(this.getProject(), info, monitor);
            this.cleanBuild(info, generator, monitor);
        }
        catch (IOException iOException) {}
    }

    protected void cleanBuild(IManagedBuildInfo info, IManagedBuilderMakefileGenerator generator, IProgressMonitor monitor) {
        IPath buildDir = generator.getBuildWorkingDir();
        if (buildDir == null) {
            buildDir = new Path(info.getConfigurationName());
        }
        IPath makefilePath = this.getProject().getLocation().append(buildDir.append(generator.getMakefileName()));
        IWorkspaceRoot root = CCorePlugin.getWorkspace().getRoot();
        IFile makefile = root.getFileForLocation(makefilePath);
        if (buildDir != null && makefile != null && makefile.isAccessible()) {
            String statusMsg = ManagedMakeMessages.getFormattedString("ManagedMakeBuilder.message.starting", this.getProject().getName());
            monitor.subTask(statusMsg);
            this.checkCancel(monitor);
            this.invokeMake(15, buildDir, info, generator, monitor);
        }
    }

    protected void fullBuild(IManagedBuildInfo info, IManagedBuilderMakefileGenerator generator, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        this.checkCancel(monitor);
        this.clean((IProgressMonitor)new SubProgressMonitor(monitor, -1));
        this.checkCancel(monitor);
        String statusMsg = ManagedMakeMessages.getFormattedString("ManagedMakeBuilder.message.rebuild.makefiles", this.getProject().getName());
        monitor.subTask(statusMsg);
        generator.initialize(this.getProject(), info, monitor);
        MultiStatus result = generator.regenerateMakefiles();
        if (result.getCode() == 2 || result.getCode() == 1) {
            IStatus[] kids = result.getChildren();
            int index = 0;
            while (index < kids.length) {
                IStatus status = kids[index];
                if (status.getCode() == 1) {
                    this.emitNoSourceMessage(6, status, info.getConfigurationName());
                    return;
                }
                this.getGenerationProblems().add(status);
                ++index;
            }
        }
        this.checkCancel(monitor);
        statusMsg = ManagedMakeMessages.getFormattedString("ManagedMakeBuilder.message.starting", this.getProject().getName());
        monitor.subTask(statusMsg);
        IPath topBuildDir = generator.getBuildWorkingDir();
        if (topBuildDir == null) {
            statusMsg = ManagedMakeMessages.getFormattedString(NOTHING_BUILT, this.getProject().getName());
            monitor.subTask(statusMsg);
            return;
        }
        this.invokeMake(6, topBuildDir, info, generator, monitor);
        this.checkCancel(monitor);
        statusMsg = ManagedMakeMessages.getFormattedString("ManagedMakeBuilder.message.regen.deps", this.getProject().getName());
        monitor.subTask(statusMsg);
        generator.regenerateDependencies(false);
        statusMsg = ManagedMakeMessages.getFormattedString(BUILD_FINISHED, this.getProject().getName());
        monitor.subTask(statusMsg);
    }

    private Vector getGenerationProblems() {
        if (this.generationProblems == null) {
            this.generationProblems = new Vector();
        }
        return this.generationProblems;
    }

    protected String[] getMakeTargets(int buildType) {
        ArrayList<String> args = new ArrayList<String>();
        switch (buildType) {
            case 15: {
                args.add("clean");
                break;
            }
            case 6: {
                args.add("clean");
            }
            case 10: {
                args.add("all");
            }
        }
        return args.toArray(new String[args.size()]);
    }

    protected List getResourcesToBuild() {
        if (this.resourcesToBuild == null) {
            this.resourcesToBuild = new ArrayList();
        }
        return this.resourcesToBuild;
    }

    public IPath getWorkingDirectory() {
        return this.getProject().getLocation();
    }

    protected void incrementalBuild(IResourceDelta delta, IManagedBuildInfo info, IManagedBuilderMakefileGenerator generator, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        this.checkCancel(monitor);
        String statusMsg = ManagedMakeMessages.getFormattedString("ManagedMakeBuilder.message.update.makefiles", this.getProject().getName());
        monitor.subTask(statusMsg);
        MultiStatus result = generator.generateMakefiles(delta);
        if (result.getCode() == 2 || result.getCode() == 1) {
            IStatus[] kids = result.getChildren();
            int index = 0;
            while (index < kids.length) {
                IStatus status = kids[index];
                if (status.getCode() == 1) {
                    this.emitNoSourceMessage(10, status, info.getConfigurationName());
                    return;
                }
                this.getGenerationProblems().add(status);
                ++index;
            }
        }
        this.checkCancel(monitor);
        statusMsg = ManagedMakeMessages.getFormattedString("ManagedMakeBuilder.message.starting", this.getProject().getName());
        monitor.subTask(statusMsg);
        IPath buildDir = generator.getBuildWorkingDir();
        if (buildDir == null) {
            statusMsg = ManagedMakeMessages.getFormattedString(NOTHING_BUILT, this.getProject().getName());
            monitor.subTask(statusMsg);
            return;
        }
        this.invokeMake(10, buildDir, info, generator, monitor);
        this.checkCancel(monitor);
        statusMsg = ManagedMakeMessages.getFormattedString("ManagedMakeBuilder.message.updating.deps", this.getProject().getName());
        monitor.subTask(statusMsg);
        generator.generateDependencies();
        statusMsg = ManagedMakeMessages.getFormattedString(BUILD_FINISHED, this.getProject().getName());
        monitor.subTask(statusMsg);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void invokeMake(int buildType, IPath buildDir, IManagedBuildInfo info, IManagedBuilderMakefileGenerator generator, IProgressMonitor monitor) {
        block50: {
            block49: {
                block48: {
                    IProject currentProject = this.getProject();
                    if (monitor == null) {
                        monitor = new NullProgressMonitor();
                    }
                    try {
                        try {
                            Path makeCommand;
                            IPath workingDirectory = this.getWorkingDirectory().append(buildDir);
                            IWorkspace workspace = currentProject.getWorkspace();
                            if (workspace == null) {
                                Object var37_9 = null;
                                this.getGenerationProblems().clear();
                                return;
                            }
                            IWorkspaceRoot root = workspace.getRoot();
                            if (root == null) {
                                break block48;
                            }
                            IPath makefile = workingDirectory.append(generator.getMakefileName());
                            if (root.getFileForLocation(makefile) == null) {
                                break block49;
                            }
                            String makeCmd = info.getBuildCommand();
                            try {
                                String resolved = ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(makeCmd, "", " ", 3, info.getDefaultConfiguration());
                                resolved = resolved.trim();
                                if (resolved.length() > 0) {
                                    makeCmd = resolved;
                                }
                            }
                            catch (BuildMacroException buildMacroException) {}
                            if ((makeCommand = new Path(makeCmd)) == null) break block50;
                            String[] msgs = new String[]{makeCommand.toString(), currentProject.getName()};
                            monitor.subTask(ManagedMakeMessages.getFormattedString(MAKE, msgs));
                            StringBuffer buf = new StringBuffer();
                            IConsole console = CCorePlugin.getDefault().getConsole();
                            console.start(currentProject);
                            ConsoleOutputStream consoleOutStream = console.getOutputStream();
                            String[] consoleHeader = new String[3];
                            switch (buildType) {
                                case 6: {
                                    consoleHeader[0] = ManagedMakeMessages.getResourceString(TYPE_FULL);
                                    break;
                                }
                                case 10: {
                                    consoleHeader[0] = ManagedMakeMessages.getResourceString(TYPE_INC);
                                    break;
                                }
                                case 15: {
                                    consoleHeader[0] = ManagedMakeMessages.getResourceString(TYPE_CLEAN);
                                    break;
                                }
                            }
                            consoleHeader[1] = info.getConfigurationName();
                            consoleHeader[2] = currentProject.getName();
                            buf.append(System.getProperty("line.separator", "\n"));
                            buf.append(ManagedMakeMessages.getFormattedString(CONSOLE_HEADER, consoleHeader));
                            buf.append(System.getProperty("line.separator", "\n"));
                            buf.append(System.getProperty("line.separator", "\n"));
                            IConfiguration cfg = info.getDefaultConfiguration();
                            if (!cfg.isSupported()) {
                                buf.append(ManagedMakeMessages.getFormattedString(WARNING_UNSUPPORTED_CONFIGURATION, new String[]{cfg.getName(), cfg.getToolChain().getName()}));
                                buf.append(System.getProperty("line.separator", "\n"));
                                buf.append(System.getProperty("line.separator", "\n"));
                            }
                            consoleOutStream.write(buf.toString().getBytes());
                            consoleOutStream.flush();
                            this.removeAllMarkers(currentProject);
                            String errMsg = null;
                            CommandLauncher launcher = new CommandLauncher();
                            launcher.showCommand(true);
                            IBuildEnvironmentVariable[] variables = ManagedBuildManager.getEnvironmentVariableProvider().getVariables(cfg, true, true);
                            String[] env = null;
                            ArrayList<String> envList = new ArrayList<String>();
                            if (variables != null) {
                                int i = 0;
                                while (true) {
                                    if (i >= variables.length) {
                                        env = envList.toArray(new String[envList.size()]);
                                        break;
                                    }
                                    envList.add(String.valueOf(variables[i].getName()) + "=" + variables[i].getValue());
                                    ++i;
                                }
                            }
                            String[] errorParsers = info.getDefaultConfiguration().getErrorParserList();
                            ErrorParserManager epm = new ErrorParserManager(this.getProject(), workingDirectory, (IMarkerGenerator)this, errorParsers);
                            epm.setOutputStream((OutputStream)consoleOutStream);
                            OutputStream epmOutputStream = epm.getOutputStream();
                            ArrayList<String> makeArgs = new ArrayList<String>();
                            String arg = info.getBuildArguments();
                            if (arg.length() > 0) {
                                String[] args = arg.split("\\s");
                                int i = 0;
                                while (i < args.length) {
                                    makeArgs.add(args[i]);
                                    ++i;
                                }
                            }
                            String prebuildStep = info.getPrebuildStep();
                            try {
                                prebuildStep = ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(prebuildStep, "", " ", 3, cfg);
                            }
                            catch (BuildMacroException buildMacroException) {}
                            boolean prebuildStepPresent = prebuildStep.length() > 0;
                            Process proc = null;
                            boolean isuptodate = false;
                            if (prebuildStepPresent) {
                                ArrayList premakeArgs = (ArrayList)makeArgs.clone();
                                switch (buildType) {
                                    case 10: {
                                        premakeArgs.add("-q");
                                        premakeArgs.add("main-build");
                                        String[] premakeTargets = premakeArgs.toArray(new String[premakeArgs.size()]);
                                        proc = launcher.execute((IPath)makeCommand, premakeTargets, env, workingDirectory);
                                        if (proc != null) {
                                            try {
                                                proc.getOutputStream().close();
                                            }
                                            catch (IOException iOException) {}
                                            if (launcher.waitAndRead(epm.getOutputStream(), epm.getOutputStream(), (IProgressMonitor)new SubProgressMonitor(monitor, -1)) != 0) {
                                                errMsg = launcher.getErrorMessage();
                                            }
                                        } else {
                                            errMsg = launcher.getErrorMessage();
                                        }
                                        if (errMsg != null && errMsg.length() > 0 || proc == null) {
                                            makeArgs.add("pre-build");
                                            makeArgs.add("main-build");
                                            break;
                                        }
                                        if (proc.exitValue() == 0) {
                                            isuptodate = true;
                                            String uptodateMsg = ManagedMakeMessages.getFormattedString(NOTHING_BUILT, currentProject.getName());
                                            buf = new StringBuffer();
                                            buf.append(System.getProperty("line.separator", "\n"));
                                            buf.append(uptodateMsg);
                                            buf.append(System.getProperty("line.separator", "\n"));
                                            consoleOutStream.write(buf.toString().getBytes());
                                            consoleOutStream.flush();
                                            epmOutputStream.close();
                                            consoleOutStream.close();
                                            break;
                                        }
                                        makeArgs.add("pre-build");
                                        makeArgs.add("main-build");
                                        break;
                                    }
                                    case 6: {
                                        makeArgs.add("clean");
                                        makeArgs.add("pre-build");
                                        makeArgs.add("main-build");
                                        break;
                                    }
                                    case 15: {
                                        makeArgs.add("clean");
                                    }
                                }
                            } else {
                                makeArgs.addAll(Arrays.asList(this.getMakeTargets(buildType)));
                            }
                            String[] makeTargets = makeArgs.toArray(new String[makeArgs.size()]);
                            if (isuptodate) break block50;
                            proc = launcher.execute((IPath)makeCommand, makeTargets, env, workingDirectory);
                            if (proc != null) {
                                try {
                                    proc.getOutputStream().close();
                                }
                                catch (IOException iOException) {}
                                if (launcher.waitAndRead(epm.getOutputStream(), epm.getOutputStream(), (IProgressMonitor)new SubProgressMonitor(monitor, -1)) != 0) {
                                    errMsg = launcher.getErrorMessage();
                                }
                                monitor.subTask(ManagedMakeMessages.getResourceString(REFRESH));
                                try {
                                    currentProject.refreshLocal(2, null);
                                }
                                catch (CoreException coreException) {
                                    monitor.subTask(ManagedMakeMessages.getResourceString(REFRESH_ERROR));
                                }
                            } else {
                                errMsg = launcher.getErrorMessage();
                            }
                            buf = new StringBuffer();
                            if (errMsg != null && errMsg.length() > 0) {
                                String errorDesc = ManagedMakeMessages.getResourceString(BUILD_ERROR);
                                buf.append(errorDesc);
                                buf.append(System.getProperty("line.separator", "\n"));
                                buf.append("(").append(errMsg).append(")");
                            } else {
                                String successMsg = ManagedMakeMessages.getFormattedString(BUILD_FINISHED, currentProject.getName());
                                buf.append(successMsg);
                                buf.append(System.getProperty("line.separator", "\n"));
                            }
                            consoleOutStream.write(buf.toString().getBytes());
                            consoleOutStream.flush();
                            epmOutputStream.close();
                            monitor.subTask(ManagedMakeMessages.getResourceString(MARKERS));
                            this.addBuilderMarkers(epm);
                            epm.reportProblems();
                            consoleOutStream.close();
                        }
                        catch (Exception exception) {
                            this.forgetLastBuiltState();
                        }
                        break block50;
                    }
                    catch (Throwable throwable) {
                        Object var37_12 = null;
                        this.getGenerationProblems().clear();
                        throw throwable;
                    }
                }
                Object var37_10 = null;
                this.getGenerationProblems().clear();
                return;
            }
            Object var37_11 = null;
            this.getGenerationProblems().clear();
            return;
        }
        Object var37_13 = null;
        this.getGenerationProblems().clear();
    }

    private void removeAllMarkers(IProject project) {
        IMarker[] markers;
        if (project == null || !project.isAccessible()) {
            return;
        }
        IWorkspace workspace = project.getWorkspace();
        try {
            markers = project.findMarkers("org.eclipse.cdt.core.problem", true, 2);
        }
        catch (CoreException coreException) {
            return;
        }
        if (markers != null) {
            try {
                workspace.deleteMarkers(markers);
            }
            catch (CoreException coreException) {
                return;
            }
        }
    }

    public class ResourceDeltaVisitor
    implements IResourceDeltaVisitor {
        private String buildGoalName;
        private IManagedBuildInfo buildInfo;
        private boolean incrBuildNeeded = false;
        private boolean fullBuildNeeded = false;
        private List reservedNames;

        public ResourceDeltaVisitor(IManagedBuildInfo info) {
            this.buildInfo = info;
            String ext = this.buildInfo.getBuildArtifactExtension();
            try {
                ext = ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(ext, "", " ", 3, info.getDefaultConfiguration());
            }
            catch (BuildMacroException buildMacroException) {}
            String name = this.buildInfo.getBuildArtifactName();
            try {
                String resolved = ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(name, "", " ", 3, info.getDefaultConfiguration());
                resolved = resolved.trim();
                if (resolved.length() > 0) {
                    name = resolved;
                }
            }
            catch (BuildMacroException buildMacroException) {}
            this.buildGoalName = ext.length() > 0 ? String.valueOf(this.buildInfo.getOutputPrefix(ext)) + name + "." + ext : name;
            this.reservedNames = Arrays.asList(".cdtbuild", ".cdtproject", ".project");
        }

        private boolean isGeneratedResource(IResource resource) {
            IPath path = resource.getProjectRelativePath();
            String[] configNames = this.buildInfo.getConfigurationNames();
            int i = 0;
            while (i < configNames.length) {
                String name = configNames[i];
                Path root = new Path(name);
                if (root.isPrefixOf(path)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        private boolean isProjectFile(IResource resource) {
            return this.reservedNames.contains(resource.getName());
        }

        public boolean shouldBuildIncr() {
            return this.incrBuildNeeded;
        }

        public boolean shouldBuildFull() {
            return this.fullBuildNeeded;
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            if (resource != null && resource.getProject() == GeneratedMakefileBuilder.this.getProject()) {
                IResourceDelta[] kids = delta.getAffectedChildren();
                int index = kids.length - 1;
                while (index >= 0) {
                    IResource changedResource = kids[index].getResource();
                    if (changedResource instanceof IFolder) {
                        return true;
                    }
                    String name = changedResource.getName();
                    if (name.equals(this.buildGoalName) || !changedResource.isDerived() && !this.isProjectFile(changedResource) && !this.isGeneratedResource(changedResource)) {
                        this.incrBuildNeeded = true;
                        if (kids[index].getKind() == 2) {
                            this.fullBuildNeeded = true;
                            break;
                        }
                    }
                    --index;
                }
                return false;
            }
            return true;
        }
    }
}

