/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.ui;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IProjectType;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.ui.properties.BuildPropertyPage;
import org.eclipse.cdt.managedbuilder.ui.wizards.NewManagedProjectOptionPage;
import org.eclipse.cdt.managedbuilder.ui.wizards.NewManagedProjectWizard;
import org.eclipse.cdt.ui.dialogs.AbstractErrorParserBlock;
import org.eclipse.cdt.ui.dialogs.ICOptionContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;

public class ErrorParserBlock
extends AbstractErrorParserBlock {
    private BuildPropertyPage parent;
    private String[] errorParsers;

    public ErrorParserBlock(BuildPropertyPage parent) {
        this.parent = parent;
    }

    protected String[] getErrorParserIDs(IConfiguration config) {
        String[] errorParsers = config.getErrorParserList();
        if (errorParsers != null) {
            return errorParsers;
        }
        return CCorePlugin.getDefault().getAllErrorParsersIDs();
    }

    protected String[] getErrorParserIDs(IProject project) {
        IConfiguration config = null;
        if (this.parent != null) {
            config = this.parent.getSelectedConfigurationClone();
        } else {
            config = ManagedBuildManager.getSelectedConfiguration((IProject)project);
            if (config == null) {
                IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
                config = info.getDefaultConfiguration();
            }
        }
        if (config != null) {
            return this.getErrorParserIDs(config);
        }
        return CCorePlugin.getDefault().getAllErrorParsersIDs();
    }

    protected String[] getErrorParserIDs() {
        if (this.parent != null) {
            return this.getErrorParserIDs(this.parent.getSelectedConfigurationClone());
        }
        ICOptionContainer container = this.getContainer();
        if (container instanceof NewManagedProjectOptionPage) {
            NewManagedProjectOptionPage parent = (NewManagedProjectOptionPage)this.getContainer();
            NewManagedProjectWizard wizard = (NewManagedProjectWizard)parent.getWizard();
            IProjectType proj = wizard.getSelectedProjectType();
            IConfiguration[] configs = proj.getConfigurations();
            if (configs.length > 0) {
                return this.getErrorParserIDs(configs[0]);
            }
            return new String[0];
        }
        return CCorePlugin.getDefault().getAllErrorParsersIDs();
    }

    public void saveErrorParsers(IProject project, String[] parsers) {
        IConfiguration config = null;
        config = this.parent != null ? this.parent.getSelectedConfigurationClone() : ManagedBuildManager.getSelectedConfiguration((IProject)project);
        if (config != null) {
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (i < parsers.length) {
                if (i > 0) {
                    buf.append(';');
                }
                buf.append(parsers[i]);
                ++i;
            }
            config.setErrorParserIds(buf.toString());
        }
    }

    public IPreferenceStore getPreferenceStore() {
        return null;
    }

    protected boolean checkIds(String[] ids1, String[] ids2) {
        if (ids1.length != ids2.length) {
            return true;
        }
        int i = 0;
        while (i < ids1.length) {
            String id = ids1[i];
            int j = 0;
            while (j < ids2.length) {
                if (id.equals(ids2[j])) break;
                ++j;
            }
            if (j == ids2.length) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void setValues() {
        super.setValues();
        if (this.parent != null && this.parent.getSelectedConfigurationClone() != null) {
            this.errorParsers = this.getErrorParserIDs(this.parent.getSelectedConfigurationClone());
        }
        this.listDirty = false;
    }

    public void performApply(IProgressMonitor monitor) throws CoreException {
        super.performApply(monitor);
        if (this.parent != null) {
            IConfiguration realConfig = ManagedBuildManager.getSelectedConfiguration((IProject)this.parent.getProject());
            realConfig.setErrorParserIds(this.parent.getSelectedConfigurationClone().getErrorParserIds());
            this.errorParsers = this.getErrorParserIDs(this.parent.getSelectedConfigurationClone());
        }
        this.listDirty = false;
    }

    public void setDirty(boolean b) {
        this.listDirty = b;
    }

    public boolean isDirty() {
        return this.listDirty;
    }

    public void setVisible(boolean visible) {
        if (this.parent != null) {
            if (visible) {
                boolean dirtyState = this.listDirty;
                this.updateListControl(this.parent.getSelectedConfigurationClone().getErrorParserList());
                if (dirtyState != this.listDirty) {
                    this.listDirty = this.checkIds(this.parent.getSelectedConfigurationClone().getErrorParserList(), this.errorParsers);
                }
            } else {
                try {
                    super.performApply(null);
                }
                catch (CoreException coreException) {}
            }
        }
        super.setVisible(visible);
    }

    protected void setDefaults() {
        if (this.parent != null) {
            IConfiguration cfg = this.parent.getSelectedConfigurationClone();
            cfg.setErrorParserIds(null);
            this.updateListControl(cfg.getErrorParserList());
            this.listDirty = true;
        } else {
            super.setDefaults();
        }
    }
}

