/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.cdt.core.CommandLauncher;
import org.eclipse.cdt.debug.mi.core.command.MIEnvironmentCD;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class CygwinMIEnvironmentCD
extends MIEnvironmentCD {
    public CygwinMIEnvironmentCD(String miVersion, String path) {
        super(miVersion, path);
        CommandLauncher launcher = new CommandLauncher();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayOutputStream err = new ByteArrayOutputStream();
        String newPath = null;
        launcher.execute((IPath)new Path("cygpath"), new String[]{"-u", path}, new String[0], (IPath)new Path("."));
        if (launcher.waitAndRead((OutputStream)out, (OutputStream)err) == 0 && (newPath = out.toString()) != null && (newPath = newPath.trim()).length() > 0) {
            path = newPath;
        }
        try {
            out.close();
            err.close();
        }
        catch (IOException iOException) {}
        this.setParameters(new String[]{path});
    }

    protected String parametersToString() {
        String[] params = this.getParameters();
        if (params != null && params.length == 1) {
            StringBuffer sb = new StringBuffer();
            String param = params[0];
            int j = 0;
            while (j < param.length()) {
                char c = param.charAt(j);
                if (c == '\"' || c == '\\') {
                    sb.append('\\');
                }
                sb.append(c);
                ++j;
            }
            if (this.containsWhitespace(param)) {
                sb.insert(0, '\"');
                sb.append('\"');
            }
            return sb.toString().trim();
        }
        return super.parametersToString();
    }
}

