/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.ui.sourcelookup;

import java.io.IOException;
import java.io.StringReader;
import java.text.MessageFormat;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocator;
import org.eclipse.cdt.debug.core.sourcelookup.SourceLookupFactory;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.cdt.debug.ui.sourcelookup.SourceLookupMessages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IPersistableSourceLocator;
import org.eclipse.debug.core.model.IStackFrame;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class OldDefaultSourceLocator
implements IPersistableSourceLocator,
IAdaptable {
    public static final String ID_DEFAULT_SOURCE_LOCATOR = String.valueOf(CDebugUIPlugin.getUniqueIdentifier()) + ".DefaultSourceLocator";
    public static final String ID_OLD_DEFAULT_SOURCE_LOCATOR = "org.eclipse.cdt.launch.DefaultSourceLocator";
    protected static final String ELEMENT_NAME = "PromptingSourceLocator";
    private static final String ATTR_PROJECT = "project";
    private static final String ATTR_MEMENTO = "memento";
    private ICSourceLocator fSourceLocator;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public String getMemento() throws CoreException {
        if (this.getCSourceLocator() != null) {
            Document document = null;
            Exception ex = null;
            try {
                document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
                Element element = document.createElement(ELEMENT_NAME);
                document.appendChild(element);
                element.setAttribute(ATTR_PROJECT, this.getCSourceLocator().getProject().getName());
                IPersistableSourceLocator psl = this.getPersistableSourceLocator();
                if (psl != null) {
                    element.setAttribute(ATTR_MEMENTO, psl.getMemento());
                }
                return CDebugUtils.serializeDocument((Document)document);
            }
            catch (ParserConfigurationException e) {
                ex = e;
            }
            catch (IOException e) {
                ex = e;
            }
            catch (TransformerException e) {
                ex = e;
            }
            this.abort(SourceLookupMessages.getString("OldDefaultSourceLocator.1"), ex);
        }
        return null;
    }

    public void initializeFromMemento(String memento) throws CoreException {
        Exception ex = null;
        try {
            IPersistableSourceLocator psl;
            Element root = null;
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            StringReader reader = new StringReader(memento);
            InputSource source = new InputSource(reader);
            root = parser.parse(source).getDocumentElement();
            if (!root.getNodeName().equalsIgnoreCase(ELEMENT_NAME)) {
                this.abort(SourceLookupMessages.getString("OldDefaultSourceLocator.2"), null);
            }
            String projectName = root.getAttribute(ATTR_PROJECT);
            String data = root.getAttribute(ATTR_MEMENTO);
            if (this.isEmpty(projectName)) {
                this.abort(SourceLookupMessages.getString("OldDefaultSourceLocator.3"), null);
            }
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            if (this.getCSourceLocator() == null) {
                this.setCSourceLocator(SourceLookupFactory.createSourceLocator((IProject)project));
            }
            if (this.getCSourceLocator().getProject() != null && !this.getCSourceLocator().getProject().equals((Object)project)) {
                return;
            }
            if (project == null || !project.exists() || !project.isOpen()) {
                this.abort(MessageFormat.format(SourceLookupMessages.getString("OldDefaultSourceLocator.4"), projectName), null);
            }
            if ((psl = this.getPersistableSourceLocator()) != null) {
                psl.initializeFromMemento(data);
            } else {
                this.abort(SourceLookupMessages.getString("OldDefaultSourceLocator.5"), null);
            }
            return;
        }
        catch (ParserConfigurationException e) {
            ex = e;
        }
        catch (SAXException e) {
            ex = e;
        }
        catch (IOException e) {
            ex = e;
        }
        this.abort(SourceLookupMessages.getString("OldDefaultSourceLocator.6"), ex);
    }

    public void initializeDefaults(ILaunchConfiguration configuration) throws CoreException {
        this.setCSourceLocator(SourceLookupFactory.createSourceLocator((IProject)this.getProject(configuration)));
        String memento = configuration.getAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_MEMENTO, "");
        if (!this.isEmpty(memento)) {
            this.initializeFromMemento(memento);
        }
    }

    public Object getAdapter(Class adapter) {
        if (this.getCSourceLocator() instanceof IAdaptable) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocator");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (adapter.equals(clazz)) {
                return ((IAdaptable)this.getCSourceLocator()).getAdapter(adapter);
            }
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.core.resources.IResourceChangeListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (adapter.equals(clazz2)) {
                return ((IAdaptable)this.getCSourceLocator()).getAdapter(adapter);
            }
        }
        return null;
    }

    public Object getSourceElement(IStackFrame stackFrame) {
        return null;
    }

    private ICSourceLocator getCSourceLocator() {
        return this.fSourceLocator;
    }

    private void setCSourceLocator(ICSourceLocator locator) {
        this.fSourceLocator = locator;
    }

    private IPersistableSourceLocator getPersistableSourceLocator() {
        ICSourceLocator sl = this.getCSourceLocator();
        return sl instanceof IPersistableSourceLocator ? (IPersistableSourceLocator)sl : null;
    }

    private void abort(String message, Throwable e) throws CoreException {
        Status s = new Status(4, CDebugUIPlugin.getUniqueIdentifier(), 0, message, e);
        throw new CoreException((IStatus)s);
    }

    private boolean isEmpty(String string) {
        return string == null || string.trim().length() == 0;
    }

    private IProject getProject(ILaunchConfiguration configuration) throws CoreException {
        IProject project;
        String projectName = configuration.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", null);
        if (!this.isEmpty(projectName) && (project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName)).exists()) {
            return project;
        }
        this.abort(MessageFormat.format(SourceLookupMessages.getString("OldDefaultSourceLocator.9"), projectName), null);
        return null;
    }
}

