/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.browser.typehierarchy;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.cdt.core.browser.AllTypesCache;
import org.eclipse.cdt.core.browser.ITypeInfo;
import org.eclipse.cdt.core.browser.ITypeSearchScope;
import org.eclipse.cdt.core.browser.TypeSearchScope;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.internal.ui.browser.opentype.OpenTypeMessages;
import org.eclipse.cdt.internal.ui.browser.typehierarchy.FocusOnTypeDialog;
import org.eclipse.cdt.internal.ui.browser.typehierarchy.TypeHierarchyMessages;
import org.eclipse.cdt.internal.ui.browser.typehierarchy.TypeHierarchyViewPart;
import org.eclipse.cdt.internal.ui.util.ExceptionHandler;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.progress.IProgressService;

public class FocusOnTypeAction
extends Action {
    private TypeHierarchyViewPart fViewPart;

    public FocusOnTypeAction(TypeHierarchyViewPart part) {
        super(TypeHierarchyMessages.getString("FocusOnTypeAction.label"));
        this.setDescription(TypeHierarchyMessages.getString("FocusOnTypeAction.description"));
        this.setToolTipText(TypeHierarchyMessages.getString("FocusOnTypeAction.tooltip"));
        this.fViewPart = part;
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.cdt.ui.focus_on_type_action");
    }

    public void run() {
        int[] kinds;
        Object[] elements;
        TypeSearchScope fScope = new TypeSearchScope(true);
        if (!AllTypesCache.isCacheUpToDate((ITypeSearchScope)fScope)) {
            IRunnableWithProgress runnable = new IRunnableWithProgress((ITypeSearchScope)fScope){
                private final /* synthetic */ ITypeSearchScope val$fScope;
                {
                    this.val$fScope = iTypeSearchScope;
                }

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    AllTypesCache.updateCache((ITypeSearchScope)this.val$fScope, (IProgressMonitor)monitor);
                    if (monitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                }
            };
            IProgressService service = PlatformUI.getWorkbench().getProgressService();
            try {
                service.busyCursorWhile(runnable);
            }
            catch (InvocationTargetException e) {
                String title = OpenTypeMessages.getString("OpenTypeAction.exception.title");
                String message = OpenTypeMessages.getString("OpenTypeAction.exception.message");
                ExceptionHandler.handle(e, title, message);
                return;
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
        if ((elements = AllTypesCache.getTypes((ITypeSearchScope)fScope, (int[])(kinds = new int[]{65, 67}))).length == 0) {
            String title = OpenTypeMessages.getString("OpenTypeAction.notypes.title");
            String message = OpenTypeMessages.getString("OpenTypeAction.notypes.message");
            MessageDialog.openInformation((Shell)this.getShell(), (String)title, (String)message);
            return;
        }
        FocusOnTypeDialog dialog = new FocusOnTypeDialog(this.getShell());
        dialog.setElements(elements);
        int result = dialog.open();
        if (result != 0) {
            return;
        }
        ITypeInfo info = (ITypeInfo)dialog.getFirstResult();
        if (info == null) {
            return;
        }
        final ITypeInfo[] typesToResolve = new ITypeInfo[]{info};
        final ICElement[] foundElement = new ICElement[1];
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                foundElement[0] = AllTypesCache.getElementForType((ITypeInfo)typesToResolve[0], (boolean)true, (boolean)true, (IProgressMonitor)monitor);
            }
        };
        IProgressService service = PlatformUI.getWorkbench().getProgressService();
        try {
            service.busyCursorWhile(runnable);
        }
        catch (InvocationTargetException e) {
            String title = OpenTypeMessages.getString("OpenTypeAction.exception.title");
            String message = OpenTypeMessages.getString("OpenTypeAction.exception.message");
            ExceptionHandler.handle(e, title, message);
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        if (foundElement[0] == null) {
            String title = OpenTypeMessages.getString("OpenTypeAction.errorTitle");
            String message = OpenTypeMessages.getFormattedString("OpenTypeAction.errorTypeNotFound", info.getQualifiedTypeName().toString());
            MessageDialog.openError((Shell)this.getShell(), (String)title, (String)message);
        } else {
            this.fViewPart.setInputElement(foundElement[0]);
        }
    }

    protected Shell getShell() {
        return CUIPlugin.getActiveWorkbenchShell();
    }
}

