/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.core.parser.util.HashTable;

public class CharTable
extends HashTable {
    protected char[][] keyTable = new char[this.capacity()][];

    protected CharTable(int initialSize) {
        super(initialSize);
    }

    protected void resize(int size) {
        char[][] oldKeyTable = this.keyTable;
        this.keyTable = new char[size][];
        System.arraycopy(oldKeyTable, 0, this.keyTable, 0, oldKeyTable.length);
        super.resize(size);
    }

    public void clear() {
        super.clear();
        int i = 0;
        while (i < this.capacity()) {
            this.keyTable[i] = null;
            ++i;
        }
    }

    public Object clone() {
        CharTable newTable = (CharTable)super.clone();
        int size = this.capacity();
        newTable.keyTable = new char[size][];
        System.arraycopy(this.keyTable, 0, newTable.keyTable, 0, this.keyTable.length);
        return newTable;
    }

    protected final int hash(char[] source, int start, int length) {
        return CharArrayUtils.hash(source, start, length) & this.keyTable.length * 2 - 1;
    }

    protected final int hash(int pos) {
        return this.hash(this.keyTable[pos], 0, this.keyTable[pos].length);
    }

    protected final int hash(char[] obj) {
        return this.hash(obj, 0, obj.length);
    }

    protected final int addIndex(char[] buffer) {
        return this.addIndex(buffer, 0, buffer.length);
    }

    protected final int addIndex(char[] buffer, int start, int len) {
        if (this.hashTable != null) {
            int hash = this.hash(buffer, start, len);
            int pos = this.lookup(buffer, start, len, hash);
            if (pos != -1) {
                return pos;
            }
            if (this.currEntry + 1 >= this.capacity()) {
                this.resize();
                hash = this.hash(buffer, start, len);
            }
            ++this.currEntry;
            this.keyTable[this.currEntry] = CharArrayUtils.extract(buffer, start, len);
            this.linkIntoHashTable(this.currEntry, hash);
        } else {
            int pos = this.lookup(buffer, start, len);
            if (pos != -1) {
                return pos;
            }
            if (this.currEntry + 1 >= this.capacity()) {
                this.resize();
                if (this.capacity() > 2) {
                    return this.addIndex(buffer, start, len);
                }
            }
            ++this.currEntry;
            this.keyTable[this.currEntry] = CharArrayUtils.extract(buffer, start, len);
        }
        return this.currEntry;
    }

    protected void removeEntry(int i) {
        int hash = this.hash(this.keyTable[i]);
        if (i < this.currEntry) {
            System.arraycopy(this.keyTable, i + 1, this.keyTable, i, this.currEntry - i);
        }
        this.keyTable[this.currEntry] = null;
        this.removeEntry(i, hash);
    }

    public List toList() {
        ArrayList<char[]> list = new ArrayList<char[]>(this.size());
        int size = this.size();
        int i = 0;
        while (i < size) {
            list.add(this.keyAt(i));
            ++i;
        }
        return list;
    }

    public final char[] keyAt(int i) {
        if (i < 0 || i > this.currEntry) {
            return null;
        }
        return this.keyTable[i];
    }

    public final boolean containsKey(char[] key) {
        return this.lookup(key) != -1;
    }

    public final char[] findKey(char[] buffer, int start, int len) {
        int idx = this.lookup(buffer, start, len);
        if (idx == -1) {
            return null;
        }
        return this.keyTable[idx];
    }

    public int lookup(char[] buffer) {
        return this.lookup(buffer, 0, buffer.length);
    }

    protected final int lookup(char[] buffer, int start, int len) {
        if (this.hashTable != null) {
            return this.lookup(buffer, start, len, this.hash(buffer, start, len));
        }
        int i = 0;
        while (i <= this.currEntry) {
            if (CharArrayUtils.equals(buffer, start, len, this.keyTable[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected final int lookup(char[] buffer, int start, int len, int hash) {
        if (this.hashTable[hash] == 0) {
            return -1;
        }
        int i = this.hashTable[hash] - 1;
        if (CharArrayUtils.equals(buffer, start, len, this.keyTable[i])) {
            return i;
        }
        i = this.nextTable[i] - 1;
        while (i >= 0) {
            if (CharArrayUtils.equals(buffer, start, len, this.keyTable[i])) {
                return i;
            }
            i = this.nextTable[i] - 1;
        }
        return -1;
    }

    public Object[] keyArray() {
        Object[] keys = new Object[this.size()];
        System.arraycopy(this.keyTable, 0, keys, 0, keys.length);
        return keys;
    }
}

