/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.search.actions;

import java.util.Iterator;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.search.CSearchMessages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchSite;

public class AddToIndexAction
extends Action {
    protected IWorkbenchSite fSite;
    protected CEditor fEditor;

    public AddToIndexAction(CEditor editor, String label, String tooltip) {
        this.fEditor = editor;
        this.setText(label);
        this.setToolTipText(tooltip);
    }

    public AddToIndexAction(CEditor editor) {
        this(editor, CSearchMessages.getString("ActionDefinition.addToIndex.name"), CSearchMessages.getString("ActionDefinition.addToIndex.description"));
    }

    public AddToIndexAction(IWorkbenchSite site) {
        this(site, CSearchMessages.getString("ActionDefinition.addToIndex.name"), CSearchMessages.getString("ActionDefinition.addToIndex.description"));
    }

    public AddToIndexAction(IWorkbenchSite site, String label, String tooltip) {
        this.fSite = site;
        this.setText(label);
        this.setToolTipText(tooltip);
    }

    public void run() {
        if (this.fEditor != null) {
            IProject project;
            ICElement celement = this.fEditor.getInputCElement();
            IResource resource = celement.getUnderlyingResource();
            if (resource != null && (project = resource.getProject()) != null) {
                CCorePlugin.getDefault().getCoreModel().getIndexManager().addResource(project, resource);
            }
        } else if (this.fSite != null && this.fSite.getSelectionProvider() != null) {
            IStructuredSelection sel = (IStructuredSelection)this.fSite.getSelectionProvider().getSelection();
            Iterator iter = sel.iterator();
            while (iter.hasNext()) {
                Object element = iter.next();
                if (!(element instanceof ICElement)) continue;
                ICElement cel = (ICElement)element;
                IProject proj = cel.getCProject().getProject();
                IResource resource = cel.getResource();
                if (proj == null || resource == null) continue;
                CCorePlugin.getDefault().getCoreModel().getIndexManager().addResource(proj, resource);
            }
        }
    }
}

