/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.views.modules;

import java.util.HashMap;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.IParent;
import org.eclipse.cdt.debug.core.model.ICDebugTarget;
import org.eclipse.cdt.debug.core.model.ICModule;
import org.eclipse.cdt.debug.internal.ui.views.IDebugExceptionHandler;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.debug.core.DebugException;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class ModulesViewContentProvider
implements ITreeContentProvider {
    private HashMap fParentCache;
    private IDebugExceptionHandler fExceptionHandler;
    static /* synthetic */ Class class$0;

    public ModulesViewContentProvider() {
        this.setParentCache(new HashMap(10));
    }

    public Object[] getChildren(Object parent) {
        block18: {
            if (parent instanceof ICDebugTarget) {
                Object[] children = null;
                ICDebugTarget target = (ICDebugTarget)parent;
                try {
                    if (target != null) {
                        children = target.getModules();
                    }
                    if (children != null) {
                        this.cache(parent, children);
                        return children;
                    }
                }
                catch (DebugException e) {
                    if (this.getExceptionHandler() != null) {
                        this.getExceptionHandler().handleException(e);
                        break block18;
                    }
                    CDebugUIPlugin.log(e);
                }
            } else if (parent instanceof ICModule) {
                IBinary binary;
                ICModule iCModule = (ICModule)parent;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.cdt.core.model.IBinary");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((binary = (IBinary)iCModule.getAdapter((Class)clazz)) != null) {
                    try {
                        return binary.getChildren();
                    }
                    catch (CModelException cModelException) {}
                }
            } else if (parent instanceof IParent) {
                try {
                    return ((IParent)parent).getChildren();
                }
                catch (CModelException cModelException) {}
            }
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        return this.getParentCache().get(element);
    }

    public boolean hasChildren(Object parent) {
        if (parent instanceof ICDebugTarget) {
            try {
                ICDebugTarget target = (ICDebugTarget)parent;
                return target.hasModules();
            }
            catch (DebugException e) {
                CDebugUIPlugin.log(e);
            }
        } else if (parent instanceof ICModule) {
            IBinary binary;
            ICModule iCModule = (ICModule)parent;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.cdt.core.model.IBinary");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((binary = (IBinary)iCModule.getAdapter((Class)clazz)) != null) {
                return binary.hasChildren();
            }
        } else if (parent instanceof IParent) {
            return ((IParent)parent).hasChildren();
        }
        return false;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void dispose() {
        this.setParentCache(null);
        this.setExceptionHandler(null);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.clearCache();
    }

    protected void setExceptionHandler(IDebugExceptionHandler handler) {
        this.fExceptionHandler = handler;
    }

    protected IDebugExceptionHandler getExceptionHandler() {
        return this.fExceptionHandler;
    }

    private HashMap getParentCache() {
        return this.fParentCache;
    }

    private void setParentCache(HashMap parentCache) {
        this.fParentCache = parentCache;
    }

    protected void cache(Object parent, Object[] children) {
        int i = 0;
        while (i < children.length) {
            this.getParentCache().put(children[i], parent);
            ++i;
        }
    }

    protected void clearCache() {
        if (this.getParentCache() != null) {
            this.getParentCache().clear();
        }
    }
}

