/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.launch.ui;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.launch.internal.ui.LaunchUIPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;

public abstract class CLaunchConfigurationTab
extends AbstractLaunchConfigurationTab {
    static /* synthetic */ Class class$0;

    protected ICElement getContext(ILaunchConfiguration config, String platform) {
        IEditorPart part;
        ICElement ce;
        IStructuredSelection ss;
        ISelection selection;
        String projectName = null;
        String programName = null;
        IWorkbenchPage page = LaunchUIPlugin.getActivePage();
        Object obj = null;
        try {
            projectName = config.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", null);
            programName = config.getAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", null);
        }
        catch (CoreException coreException) {}
        if (projectName != null && !projectName.equals("")) {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            ICProject cProject = CCorePlugin.getDefault().getCoreModel().create(project);
            if (cProject != null && cProject.exists()) {
                obj = cProject;
            }
        } else if (page != null && (selection = page.getSelection()) instanceof IStructuredSelection && !(ss = (IStructuredSelection)selection).isEmpty()) {
            obj = ss.getFirstElement();
        }
        if (obj instanceof IResource) {
            ce = CoreModel.getDefault().create((IResource)obj);
            if (ce == null) {
                IProject pro = ((IResource)obj).getProject();
                ce = CoreModel.getDefault().create(pro);
            }
            obj = ce;
        }
        if (obj instanceof ICElement) {
            if (platform != null && !platform.equals("*")) {
                try {
                    String projectPlatform;
                    ICDescriptor descriptor = CCorePlugin.getDefault().getCProjectDescription(obj.getCProject().getProject(), false);
                    if (descriptor != null && !(projectPlatform = descriptor.getPlatform()).equals(platform) && !projectPlatform.equals("*")) {
                        obj = null;
                    }
                }
                catch (CoreException coreException) {}
            }
            if (obj != null) {
                if (programName == null || programName.equals("")) {
                    return obj;
                }
                ce = obj;
                IProject project = (IProject)ce.getCProject().getResource();
                IPath programFile = project.getFile(programName).getLocation();
                ce = CCorePlugin.getDefault().getCoreModel().create(programFile);
                if (ce != null && ce.exists()) {
                    return ce;
                }
                return obj;
            }
        }
        if ((part = page.getActiveEditor()) != null) {
            IEditorInput input = part.getEditorInput();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.cdt.core.model.ICElement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (ICElement)input.getAdapter((Class)clazz);
        }
        return null;
    }

    protected void initializeCProject(ICElement cElement, ILaunchConfigurationWorkingCopy config) {
        ICProject cProject = cElement.getCProject();
        String name = null;
        if (cProject != null && cProject.exists()) {
            name = cProject.getElementName();
        }
        config.setAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", name);
    }

    protected String getPlatform(ILaunchConfiguration config) {
        String platform = Platform.getOS();
        try {
            return config.getAttribute("org.eclipse.cdt.launch.PLATFFORM", platform);
        }
        catch (CoreException coreException) {
            return platform;
        }
    }
}

