/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring;

import org.eclipse.cdt.internal.corext.refactoring.base.IChange;
import org.eclipse.cdt.internal.corext.refactoring.changes.TextChange;
import org.eclipse.cdt.internal.ui.refactoring.ChangeElement;
import org.eclipse.cdt.internal.ui.refactoring.DefaultChangeElement;
import org.eclipse.cdt.internal.ui.refactoring.IChangePreviewViewer;
import org.eclipse.cdt.internal.ui.refactoring.PseudoCChangeElement;
import org.eclipse.cdt.internal.ui.refactoring.TextChangePreviewViewer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.util.Assert;

class TextEditChangeElement
extends ChangeElement {
    private static final ChangeElement[] fgChildren = new ChangeElement[0];
    private TextChange.EditChange fChange;

    public TextEditChangeElement(ChangeElement parent, TextChange.EditChange change) {
        super(parent);
        this.fChange = change;
        Assert.isNotNull((Object)this.fChange);
    }

    public TextChange.EditChange getTextEditChange() {
        return this.fChange;
    }

    public void feedInput(IChangePreviewViewer viewer) throws CoreException {
        DefaultChangeElement element = this.getStandardChangeElement();
        if (element != null) {
            IChange change = element.getChange();
            if (change instanceof TextChange) {
                IRegion range = TextEditChangeElement.getTextRange(this);
                Object input = null;
                input = range != null ? TextChangePreviewViewer.createInput(new TextChange.EditChange[]{this.fChange}, range) : TextChangePreviewViewer.createInput(this.fChange, 2);
                viewer.setInput(input);
            }
        } else {
            viewer.setInput(null);
        }
    }

    public void setActive(boolean active) {
        this.fChange.setActive(active);
    }

    public int getActive() {
        return this.fChange.isActive() ? 2 : 0;
    }

    public ChangeElement[] getChildren() {
        return fgChildren;
    }

    private DefaultChangeElement getStandardChangeElement() {
        ChangeElement element = this.getParent();
        while (!(element instanceof DefaultChangeElement) && element != null) {
            element = element.getParent();
        }
        return (DefaultChangeElement)element;
    }

    private static IRegion getTextRange(ChangeElement element) throws CoreException {
        if (element == null) {
            return null;
        }
        if (element instanceof PseudoCChangeElement) {
            return ((PseudoCChangeElement)element).getTextRange();
        }
        if (element instanceof DefaultChangeElement) {
            return null;
        }
        return TextEditChangeElement.getTextRange(element.getParent());
    }
}

