/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.resources.IPathEntryVariableChangeListener;
import org.eclipse.cdt.core.resources.IPathEntryVariableManager;
import org.eclipse.cdt.core.resources.PathEntryVariableChangeEvent;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;

public class PathEntryVariableManager
implements IPathEntryVariableManager {
    private Set listeners = Collections.synchronizedSet(new HashSet());
    private Preferences preferences = CCorePlugin.getDefault().getPluginPreferences();
    static final String VARIABLE_PREFIX = "pathEntryVariable.";

    public IPath getValue(String varName) {
        String key = this.getKeyForName(varName);
        String value = this.preferences.getString(key);
        return value.length() == 0 ? null : Path.fromPortableString((String)value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(String varName, IPath newValue) throws CoreException {
        int eventType;
        if (newValue != null && newValue.isAbsolute() && newValue.getDevice() == null) {
            newValue = new Path(newValue.toFile().getAbsolutePath());
        }
        PathEntryVariableManager pathEntryVariableManager = this;
        synchronized (pathEntryVariableManager) {
            boolean variableExists;
            IPath currentValue = this.getValue(varName);
            boolean bl = variableExists = currentValue != null;
            if (!variableExists && newValue == null) {
                return;
            }
            if (variableExists && currentValue.equals((Object)newValue)) {
                return;
            }
            if (newValue == null) {
                this.preferences.setToDefault(this.getKeyForName(varName));
                eventType = 3;
            } else {
                this.preferences.setValue(this.getKeyForName(varName), newValue.toPortableString());
                eventType = variableExists ? 1 : 2;
            }
        }
        this.fireVariableChangeEvent(varName, newValue, eventType);
    }

    private String getKeyForName(String varName) {
        return VARIABLE_PREFIX + varName;
    }

    public IPath resolvePath(IPath path) {
        if (path == null || path.segmentCount() == 0) {
            return path;
        }
        String variable = path.toPortableString();
        if (variable.indexOf(36) == -1) {
            return path;
        }
        String value = this.expandVariable(variable);
        return value == null || value.length() == 0 ? Path.EMPTY : new Path(value);
    }

    private void fireVariableChangeEvent(String name, IPath value, int type) {
        if (this.listeners.size() == 0) {
            return;
        }
        Object[] listenerArray = this.listeners.toArray();
        final PathEntryVariableChangeEvent pve = new PathEntryVariableChangeEvent(this, name, value, type);
        int i = 0;
        while (i < listenerArray.length) {
            final IPathEntryVariableChangeListener l = (IPathEntryVariableChangeListener)listenerArray[i];
            ISafeRunnable job = new ISafeRunnable(){

                public void handleException(Throwable exception) {
                }

                public void run() throws Exception {
                    l.pathVariableChanged(pve);
                }
            };
            Platform.run((ISafeRunnable)job);
            ++i;
        }
    }

    public String[] getVariableNames() {
        LinkedList<String> result = new LinkedList<String>();
        String[] names = this.preferences.propertyNames();
        int i = 0;
        while (i < names.length) {
            if (names[i].startsWith(VARIABLE_PREFIX)) {
                String key = names[i].substring(VARIABLE_PREFIX.length());
                result.add(key);
            }
            ++i;
        }
        return result.toArray(new String[result.size()]);
    }

    public void addChangeListener(IPathEntryVariableChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeChangeListener(IPathEntryVariableChangeListener listener) {
        this.listeners.remove(listener);
    }

    public boolean isDefined(String varName) {
        return this.getValue(varName) != null;
    }

    public void startup() {
    }

    public void shutdown() {
    }

    /*
     * Enabled aggressive block sorting
     */
    protected String expandVariable(String variable) {
        int prev;
        StringBuffer sb = new StringBuffer();
        StringBuffer param = new StringBuffer();
        int ch = prev = 10;
        boolean inMacro = false;
        boolean inSingleQuote = false;
        int i = 0;
        while (i < variable.length()) {
            block10: {
                ch = variable.charAt(i);
                switch (ch) {
                    case 39: {
                        if (prev == 92) break;
                        inSingleQuote = !inSingleQuote;
                        break;
                    }
                    case 36: {
                        char c;
                        if (inSingleQuote || prev == 92 || i >= variable.length() || variable.indexOf(125, i) <= 0 || (c = variable.charAt(i + 1)) != '{') break;
                        param.setLength(0);
                        inMacro = true;
                        prev = ch;
                        break block10;
                    }
                    case 125: {
                        String v;
                        if (!inMacro) break;
                        inMacro = false;
                        String p = param.toString();
                        IPath path = this.getValue(p);
                        if (path != null && (v = path.toPortableString()) != null) {
                            sb.append(v);
                        }
                        param.setLength(0);
                        prev = ch;
                        break block10;
                    }
                }
                if (!inMacro) {
                    sb.append((char)ch);
                } else if (ch != 123 || prev != 36) {
                    param.append((char)ch);
                }
                prev = ch == 92 && prev == 92 ? 10 : ch;
            }
            ++i;
        }
        return sb.toString();
    }
}

