/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.ui.properties;

import java.util.ArrayList;
import java.util.ListIterator;
import org.eclipse.cdt.internal.ui.dialogs.StatusDialog;
import org.eclipse.cdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IProjectType;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.ui.ManagedBuilderUIMessages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NewConfigurationDialog
extends StatusDialog {
    private static final String PREFIX = "NewConfiguration";
    private static final String LABEL = "NewConfiguration.label";
    private static final String ERROR = "NewConfiguration.error";
    private static final String NAME = "NewConfiguration.label.name";
    private static final String GROUP = "NewConfiguration.label.group";
    private static final String COPY = "NewConfiguration.label.copy";
    private static final String CLONE = "NewConfiguration.label.clone";
    private static final String SHOWALL = "NewConfiguration.label.showall";
    private static final String DUPLICATE = "NewConfiguration.error.duplicateName";
    private static final String CASE = "NewConfiguration.error.caseName";
    private static final String INVALID = "NewConfiguration.error.invalidName";
    private static final String DESCRIPTION = "NewConfiguration.label.description";
    private static final String ID_SEPARATOR = ".";
    private Button btnClone;
    private Button btnCopy;
    private Text configName;
    private Text configDescription;
    private Combo copyConfigSelector;
    private Combo cloneConfigSelector;
    private Button btnShowAll;
    private boolean clone;
    private IConfiguration[] defaultConfigs;
    private IConfiguration[] definedConfigs;
    private IConfiguration parentConfig;
    private IManagedProject managedProject;
    private String newName;
    private String newDescription;
    private final ArrayList reservedNames;
    private final String title;

    protected NewConfigurationDialog(Shell parentShell, IManagedProject managedProject, String title) {
        super(parentShell);
        this.title = title;
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.newName = new String();
        this.newDescription = new String();
        this.parentConfig = null;
        this.managedProject = managedProject;
        this.reservedNames = new ArrayList();
        this.clone = true;
        this.definedConfigs = managedProject.getConfigurations();
        IProjectType projectType = managedProject.getProjectType();
        this.defaultConfigs = projectType.getConfigurations();
        int i = 0;
        while (i < this.definedConfigs.length) {
            this.reservedNames.add(this.definedConfigs[i].getName());
            ++i;
        }
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            String description = new String();
            String nameAndDescription = new String();
            String baseConfigNameAndDescription = new String();
            this.newName = this.configName.getText().trim();
            this.newDescription = this.configDescription.getText().trim();
            if (this.clone) {
                baseConfigNameAndDescription = this.cloneConfigSelector.getItem(this.cloneConfigSelector.getSelectionIndex());
                int i = 0;
                while (i < this.definedConfigs.length) {
                    IConfiguration config = this.definedConfigs[i];
                    description = config.getDescription();
                    nameAndDescription = description == null || description.equals("") ? config.getName() : String.valueOf(config.getName()) + "( " + description + " )";
                    if (nameAndDescription.equals(baseConfigNameAndDescription)) {
                        this.parentConfig = config;
                        break;
                    }
                    ++i;
                }
            } else {
                baseConfigNameAndDescription = this.copyConfigSelector.getItem(this.copyConfigSelector.getSelectionIndex());
                int i = 0;
                while (i < this.defaultConfigs.length) {
                    IConfiguration config = this.defaultConfigs[i];
                    description = config.getDescription();
                    nameAndDescription = description == null || description.equals("") ? config.getName() : String.valueOf(config.getName()) + "( " + description + " )";
                    if (nameAndDescription.equals(baseConfigNameAndDescription)) {
                        this.parentConfig = config;
                        break;
                    }
                    ++i;
                }
            }
        } else {
            this.newName = null;
            this.newDescription = null;
            this.parentConfig = null;
        }
        super.buttonPressed(buttonId);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.configName.setFocus();
        if (this.configName != null) {
            this.configName.setText(this.newName);
        }
        this.validateState();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayout((Layout)new GridLayout(3, false));
        composite.setLayoutData((Object)new GridData(768));
        Group group1 = new Group(composite, 0);
        group1.setFont(composite.getFont());
        GridLayout layout1 = new GridLayout(3, false);
        group1.setLayout((Layout)layout1);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 3;
        group1.setLayoutData((Object)gd);
        Label nameLabel = new Label((Composite)group1, 16384);
        nameLabel.setFont(parent.getFont());
        nameLabel.setText(ManagedBuilderUIMessages.getResourceString(NAME));
        gd = new GridData(768);
        gd.horizontalSpan = 1;
        gd.grabExcessHorizontalSpace = false;
        nameLabel.setLayoutData((Object)gd);
        this.configName = new Text((Composite)group1, 2052);
        this.configName.setFont(group1.getFont());
        this.configName.setText(this.getNewName());
        this.configName.setFocus();
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.widthHint = 200;
        this.configName.setLayoutData((Object)gd);
        this.configName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewConfigurationDialog.this.validateState();
            }
        });
        Label descriptionLabel = new Label((Composite)group1, 16384);
        descriptionLabel.setFont(parent.getFont());
        descriptionLabel.setText(ManagedBuilderUIMessages.getResourceString(DESCRIPTION));
        gd = new GridData(768);
        gd.horizontalSpan = 1;
        gd.grabExcessHorizontalSpace = false;
        descriptionLabel.setLayoutData((Object)gd);
        this.configDescription = new Text((Composite)group1, 2052);
        this.configDescription.setFont(group1.getFont());
        this.configDescription.setText(this.getNewDescription());
        this.configDescription.setFocus();
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.widthHint = 200;
        this.configDescription.setLayoutData((Object)gd);
        Group group = new Group(composite, 0);
        group.setFont(composite.getFont());
        group.setText(ManagedBuilderUIMessages.getResourceString(GROUP));
        GridLayout layout = new GridLayout(3, false);
        group.setLayout((Layout)layout);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        group.setLayoutData((Object)gd);
        SelectionAdapter radioListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                NewConfigurationDialog.this.clone = NewConfigurationDialog.this.btnClone.getSelection();
                NewConfigurationDialog.this.updateComboState();
            }
        };
        this.btnCopy = new Button((Composite)group, 16);
        this.btnCopy.setFont(group.getFont());
        this.btnCopy.setText(ManagedBuilderUIMessages.getResourceString(COPY));
        this.setButtonLayoutData(this.btnCopy);
        this.btnCopy.addSelectionListener((SelectionListener)radioListener);
        this.copyConfigSelector = new Combo((Composite)group, 2060);
        this.copyConfigSelector.setFont(group.getFont());
        int index = this.copyConfigSelector.indexOf(this.newName);
        this.copyConfigSelector.select(index < 0 ? 0 : index);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.widthHint = 200;
        this.copyConfigSelector.setLayoutData((Object)gd);
        this.copyConfigSelector.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewConfigurationDialog.this.validateState();
            }
        });
        this.copyConfigSelector.setEnabled(false);
        this.btnClone = new Button((Composite)group, 16);
        this.btnClone.setFont(group.getFont());
        this.btnClone.setText(ManagedBuilderUIMessages.getResourceString(CLONE));
        this.setButtonLayoutData(this.btnClone);
        this.btnClone.addSelectionListener((SelectionListener)radioListener);
        this.btnClone.setSelection(true);
        this.cloneConfigSelector = new Combo((Composite)group, 2060);
        this.cloneConfigSelector.setFont(group.getFont());
        this.cloneConfigSelector.setItems(this.getDefinedConfigNamesAndDescriptions());
        index = this.cloneConfigSelector.indexOf(this.newName);
        this.cloneConfigSelector.select(index < 0 ? 0 : index);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.widthHint = 200;
        this.cloneConfigSelector.setLayoutData((Object)gd);
        this.cloneConfigSelector.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewConfigurationDialog.this.validateState();
            }
        });
        this.btnShowAll = new Button(composite, 32);
        this.btnShowAll.setFont(composite.getFont());
        this.btnShowAll.setText(ManagedBuilderUIMessages.getResourceString(SHOWALL));
        gd = new GridData(768);
        gd.horizontalSpan = 1;
        this.btnShowAll.setLayoutData((Object)gd);
        this.btnShowAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewConfigurationDialog.this.updateDefaultConfigs();
            }
        });
        this.updateComboState();
        this.updateDefaultConfigs();
        return composite;
    }

    public IConfiguration getParentConfiguration() {
        return this.parentConfig;
    }

    private void updateDefaultConfigs() {
        int i;
        boolean showAll;
        IConfiguration[] cfgs = this.managedProject.getProjectType().getConfigurations();
        boolean bl = showAll = this.btnShowAll != null ? this.btnShowAll.getSelection() : false;
        if (showAll) {
            this.defaultConfigs = cfgs;
        } else {
            ArrayList<IConfiguration> list = new ArrayList<IConfiguration>();
            i = 0;
            while (i < cfgs.length) {
                IToolChain tc;
                if (cfgs[i].isSupported() && (tc = cfgs[i].getToolChain()).getConvertToId().equals("")) {
                    list.add(cfgs[i]);
                }
                ++i;
            }
            this.defaultConfigs = list.toArray(new IConfiguration[list.size()]);
        }
        if (this.defaultConfigs.length != 0) {
            String[] namesAndDescriptions = new String[this.defaultConfigs.length];
            i = 0;
            while (i < this.defaultConfigs.length) {
                namesAndDescriptions[i] = this.defaultConfigs[i].getDescription() == null || this.defaultConfigs[i].getDescription().equals("") ? this.defaultConfigs[i].getName() : String.valueOf(this.defaultConfigs[i].getName()) + "( " + this.defaultConfigs[i].getDescription() + " )";
                ++i;
            }
            int selectionIndex = this.copyConfigSelector.getSelectionIndex();
            String oldSelection = null;
            if (selectionIndex != -1) {
                oldSelection = this.copyConfigSelector.getItem(selectionIndex);
            }
            this.copyConfigSelector.setItems(namesAndDescriptions);
            if (oldSelection != null) {
                selectionIndex = this.copyConfigSelector.indexOf(oldSelection);
            }
            if (selectionIndex == -1) {
                selectionIndex = 0;
            }
            this.copyConfigSelector.select(selectionIndex);
        } else {
            this.copyConfigSelector.removeAll();
        }
        this.validateState();
    }

    private String[] getDefinedConfigNamesAndDescriptions() {
        String[] namesAndDescriptions = new String[this.definedConfigs.length];
        int index = 0;
        while (index < this.definedConfigs.length) {
            IConfiguration config = this.definedConfigs[index];
            namesAndDescriptions[index] = config.getDescription() == null || config.getDescription().equals("") ? config.getName() : String.valueOf(config.getName()) + "( " + config.getDescription() + " )";
            ++index;
        }
        return namesAndDescriptions;
    }

    public String getNewName() {
        return this.newName;
    }

    protected boolean isDuplicateName(String newName) {
        int index = 0;
        while (index < this.definedConfigs.length) {
            IConfiguration configuration = this.definedConfigs[index];
            if (configuration.getName().equals(newName)) {
                return true;
            }
            ++index;
        }
        return this.reservedNames.contains(newName);
    }

    protected boolean isSimilarName(String newName) {
        int index = 0;
        while (index < this.definedConfigs.length) {
            IConfiguration configuration = this.definedConfigs[index];
            if (configuration.getName().equalsIgnoreCase(newName)) {
                return true;
            }
            ++index;
        }
        ListIterator iter = this.reservedNames.listIterator();
        while (iter.hasNext()) {
            if (!((String)iter.next()).equalsIgnoreCase(newName)) continue;
            return true;
        }
        return false;
    }

    protected void updateComboState() {
        this.cloneConfigSelector.setEnabled(this.clone);
        this.copyConfigSelector.setEnabled(!this.clone);
        this.btnShowAll.setVisible(!this.clone);
        this.validateState();
    }

    private boolean validateName(String name) {
        if (name.trim().length() == 0) {
            return false;
        }
        char[] chars = name.toCharArray();
        if (Character.isWhitespace(chars[0])) {
            return false;
        }
        int index = 0;
        while (index < chars.length) {
            if (!Character.isLetterOrDigit(chars[index])) {
                switch (chars[index]) {
                    case '\"': 
                    case '*': 
                    case '/': 
                    case ':': 
                    case '<': 
                    case '>': 
                    case '?': 
                    case '\\': {
                        return false;
                    }
                }
            }
            ++index;
        }
        return true;
    }

    private void validateState() {
        StatusInfo status = new StatusInfo();
        String currentName = this.configName.getText();
        while (currentName.length() > 0 && Character.isWhitespace(currentName.charAt(currentName.length() - 1))) {
            currentName = currentName.substring(0, currentName.length() - 1);
        }
        if (currentName.length() == 0) {
            status.setError("");
        } else if (this.clone ? this.definedConfigs.length == 0 : this.defaultConfigs.length == 0) {
            status.setError("");
        } else if (this.isDuplicateName(currentName)) {
            status.setError(ManagedBuilderUIMessages.getFormattedString(DUPLICATE, currentName));
        } else if (this.isSimilarName(currentName)) {
            status.setError(ManagedBuilderUIMessages.getFormattedString(CASE, currentName));
        } else if (!this.validateName(currentName)) {
            status.setError(ManagedBuilderUIMessages.getFormattedString(INVALID, currentName));
        }
        this.updateStatus((IStatus)status);
    }

    public String getNewDescription() {
        return this.newDescription;
    }

    public IConfiguration newConfiguration(IManagedBuildInfo info) {
        String lastComponent;
        int id = ManagedBuildManager.getRandomNumber();
        String newId = this.parentConfig.getId();
        int index = newId.lastIndexOf(ID_SEPARATOR);
        if (index > 0 && Character.isDigit((lastComponent = newId.substring(index + 1, newId.length())).charAt(0))) {
            newId = newId.substring(0, index);
        }
        newId = String.valueOf(newId) + ID_SEPARATOR + id;
        IConfiguration newConfig = this.parentConfig.isExtensionElement() ? info.getManagedProject().createConfiguration(this.parentConfig, newId) : info.getManagedProject().createConfigurationClone(this.parentConfig, newId);
        newConfig.setName(this.newName);
        newConfig.setDescription(this.newDescription);
        newConfig.setArtifactName(info.getManagedProject().getDefaultArtifactName());
        return newConfig;
    }
}

