/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.ui.properties;

import java.util.ArrayList;
import java.util.ListIterator;
import org.eclipse.cdt.internal.ui.dialogs.StatusDialog;
import org.eclipse.cdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.internal.ui.ManagedBuilderUIMessages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class RenameConfigurationDialog
extends StatusDialog {
    private static final String PREFIX = "RenameConfiguration";
    private static final String LABEL = "RenameConfiguration.label";
    private static final String ERROR = "RenameConfiguration.error";
    private static final String NAME = "RenameConfiguration.label.name";
    private static final String DUPLICATE = "RenameConfiguration.error.duplicateName";
    private static final String CASE = "RenameConfiguration.error.caseName";
    private static final String INVALID = "RenameConfiguration.error.invalidName";
    private static final String DESCRIPTION = "RenameConfiguration.label.description";
    private Text configName;
    private Text configDescription;
    private IConfiguration[] definedConfigs;
    private IConfiguration renameConfig;
    private IManagedProject managedProject;
    private String newName;
    private String newDescription;
    private String originalName;
    private final ArrayList reservedNames;
    private final String title;

    protected RenameConfigurationDialog(Shell parentShell, IManagedProject managedProject, IConfiguration renameConfig, String title) {
        super(parentShell);
        this.title = title;
        this.renameConfig = renameConfig;
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.newName = renameConfig.getName();
        this.newDescription = renameConfig.getDescription();
        if (this.newDescription == null) {
            this.newDescription = new String();
        }
        this.setOriginalName(renameConfig.getName());
        this.managedProject = managedProject;
        this.reservedNames = new ArrayList();
        this.definedConfigs = managedProject.getConfigurations();
        int i = 0;
        while (i < this.definedConfigs.length) {
            this.reservedNames.add(this.definedConfigs[i].getName());
            ++i;
        }
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.newName = this.configName.getText().trim();
            this.newDescription = this.configDescription.getText().trim();
        }
        super.buttonPressed(buttonId);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.configName.setFocus();
        if (this.configName != null) {
            this.configName.setText(this.newName);
        }
        this.validateState();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayout((Layout)new GridLayout(3, false));
        composite.setLayoutData((Object)new GridData(768));
        Group group1 = new Group(composite, 0);
        group1.setFont(composite.getFont());
        GridLayout layout1 = new GridLayout(3, false);
        group1.setLayout((Layout)layout1);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 3;
        group1.setLayoutData((Object)gd);
        Label nameLabel = new Label((Composite)group1, 16384);
        nameLabel.setFont(parent.getFont());
        nameLabel.setText(ManagedBuilderUIMessages.getResourceString(NAME));
        gd = new GridData(768);
        gd.horizontalSpan = 1;
        gd.grabExcessHorizontalSpace = false;
        nameLabel.setLayoutData((Object)gd);
        this.configName = new Text((Composite)group1, 2052);
        this.configName.setFont(group1.getFont());
        this.configName.setText(this.getNewName());
        this.configName.setFocus();
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.widthHint = 200;
        this.configName.setLayoutData((Object)gd);
        this.configName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RenameConfigurationDialog.this.validateState();
            }
        });
        Label descriptionLabel = new Label((Composite)group1, 16384);
        descriptionLabel.setFont(parent.getFont());
        descriptionLabel.setText(ManagedBuilderUIMessages.getResourceString(DESCRIPTION));
        gd = new GridData(768);
        gd.horizontalSpan = 1;
        gd.grabExcessHorizontalSpace = false;
        descriptionLabel.setLayoutData((Object)gd);
        this.configDescription = new Text((Composite)group1, 2052);
        this.configDescription.setFont(group1.getFont());
        this.configDescription.setText(this.getNewDescription());
        this.configDescription.setFocus();
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.widthHint = 200;
        this.configDescription.setLayoutData((Object)gd);
        return composite;
    }

    protected boolean isDuplicateName(String newName) {
        if (newName.equals(this.getOriginalName())) {
            return false;
        }
        int index = 0;
        while (index < this.definedConfigs.length) {
            IConfiguration configuration = this.definedConfigs[index];
            if (configuration.getName().equals(newName)) {
                return true;
            }
            ++index;
        }
        return this.reservedNames.contains(newName);
    }

    protected boolean isSimilarName(String newName) {
        if (newName.equalsIgnoreCase(this.getOriginalName())) {
            return false;
        }
        int index = 0;
        while (index < this.definedConfigs.length) {
            IConfiguration configuration = this.definedConfigs[index];
            if (configuration.getName().equalsIgnoreCase(newName)) {
                return true;
            }
            ++index;
        }
        ListIterator iter = this.reservedNames.listIterator();
        while (iter.hasNext()) {
            if (!((String)iter.next()).equalsIgnoreCase(newName)) continue;
            return true;
        }
        return false;
    }

    private boolean validateName(String name) {
        if (name.trim().length() == 0) {
            return false;
        }
        char[] chars = name.toCharArray();
        if (Character.isWhitespace(chars[0])) {
            return false;
        }
        int index = 0;
        while (index < chars.length) {
            if (!Character.isLetterOrDigit(chars[index])) {
                switch (chars[index]) {
                    case '\"': 
                    case '*': 
                    case '/': 
                    case ':': 
                    case '<': 
                    case '>': 
                    case '?': 
                    case '\\': {
                        return false;
                    }
                }
            }
            ++index;
        }
        return true;
    }

    private void validateState() {
        StatusInfo status = new StatusInfo();
        String currentName = this.configName.getText();
        while (currentName.length() > 0 && Character.isWhitespace(currentName.charAt(currentName.length() - 1))) {
            currentName = currentName.substring(0, currentName.length() - 1);
        }
        if (currentName.length() == 0) {
            status.setError("");
        } else if (this.isDuplicateName(currentName)) {
            status.setError(ManagedBuilderUIMessages.getFormattedString(DUPLICATE, currentName));
        } else if (this.isSimilarName(currentName)) {
            status.setError(ManagedBuilderUIMessages.getFormattedString(CASE, currentName));
        } else if (!this.validateName(currentName)) {
            status.setError(ManagedBuilderUIMessages.getFormattedString(INVALID, currentName));
        }
        this.updateStatus((IStatus)status);
    }

    public String getNewName() {
        return this.newName;
    }

    public String getNewDescription() {
        return this.newDescription;
    }

    public void setNewDescription(String newDescription) {
        this.newDescription = newDescription;
    }

    public void setNewName(String newName) {
        this.newName = newName;
    }

    public String getOriginalName() {
        return this.originalName;
    }

    public void setOriginalName(String originalName) {
        this.originalName = originalName;
    }
}

