/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.macros;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.internal.macros.BuildfileMacroSubstitutor;
import org.eclipse.cdt.managedbuilder.internal.macros.CdtPathEntryMacroSupplier;
import org.eclipse.cdt.managedbuilder.internal.macros.DefaultMacroContextInfo;
import org.eclipse.cdt.managedbuilder.internal.macros.DefaultMacroSubstitutor;
import org.eclipse.cdt.managedbuilder.internal.macros.EclipseVariablesMacroSupplier;
import org.eclipse.cdt.managedbuilder.internal.macros.EnvironmentMacroSupplier;
import org.eclipse.cdt.managedbuilder.internal.macros.ExternalExtensionMacroSupplier;
import org.eclipse.cdt.managedbuilder.internal.macros.IMacroContextInfo;
import org.eclipse.cdt.managedbuilder.internal.macros.IMacroSubstitutor;
import org.eclipse.cdt.managedbuilder.internal.macros.MacroResolver;
import org.eclipse.cdt.managedbuilder.internal.macros.MbsMacroSupplier;
import org.eclipse.cdt.managedbuilder.internal.macros.UserDefinedMacroSupplier;
import org.eclipse.cdt.managedbuilder.macros.BuildMacroException;
import org.eclipse.cdt.managedbuilder.macros.IBuildMacro;
import org.eclipse.cdt.managedbuilder.macros.IBuildMacroProvider;
import org.eclipse.cdt.managedbuilder.macros.IBuildMacroSupplier;

public class BuildMacroProvider
implements IBuildMacroProvider {
    private static BuildMacroProvider fDefault;
    public static UserDefinedMacroSupplier fUserDefinedMacroSupplier;
    public static ExternalExtensionMacroSupplier fExternalExtensionMacroSupplier;
    public static EnvironmentMacroSupplier fEnvironmentMacroSupplier;
    public static MbsMacroSupplier fMbsMacroSupplier;
    public static CdtPathEntryMacroSupplier fCdtPathEntryMacroSupplier;
    public static EclipseVariablesMacroSupplier fEclipseVariablesMacroSupplier;

    static {
        fUserDefinedMacroSupplier = UserDefinedMacroSupplier.getInstance();
        fExternalExtensionMacroSupplier = ExternalExtensionMacroSupplier.getInstance();
        fEnvironmentMacroSupplier = EnvironmentMacroSupplier.getInstance();
        fMbsMacroSupplier = MbsMacroSupplier.getInstance();
        fCdtPathEntryMacroSupplier = CdtPathEntryMacroSupplier.getInstance();
        fEclipseVariablesMacroSupplier = EclipseVariablesMacroSupplier.getInstance();
    }

    protected BuildMacroProvider() {
    }

    public static BuildMacroProvider getDefault() {
        if (fDefault == null) {
            fDefault = new BuildMacroProvider();
        }
        return fDefault;
    }

    public IBuildMacro getMacro(String macroName, int contextType, Object contextData, boolean includeParentContexts) {
        return BuildMacroProvider.getMacro(macroName, this.getMacroContextInfo(contextType, contextData), includeParentContexts);
    }

    public static IBuildMacro getMacro(String macroName, IMacroContextInfo contextInfo, boolean includeParentContexts) {
        if (contextInfo == null || macroName == null) {
            return null;
        }
        do {
            IBuildMacroSupplier[] suppliers;
            if ((suppliers = contextInfo.getSuppliers()) == null) continue;
            int i = 0;
            while (i < suppliers.length) {
                IBuildMacro macro = suppliers[i].getMacro(macroName, contextInfo.getContextType(), contextInfo.getContextData());
                if (macro != null) {
                    return macro;
                }
                ++i;
            }
        } while (includeParentContexts && (contextInfo = contextInfo.getNext()) != null);
        return null;
    }

    public IBuildMacro[] getMacros(int contextType, Object contextData, boolean includeParentContexts) {
        return BuildMacroProvider.getMacros(this.getMacroContextInfo(contextType, contextData), includeParentContexts);
    }

    public static IBuildMacro[] getMacros(IMacroContextInfo contextInfo, boolean includeParentContexts) {
        IMacroContextInfo[] iMacroContextInfoArray;
        if (contextInfo == null) {
            return null;
        }
        HashMap<String, IBuildMacro> map = new HashMap<String, IBuildMacro>();
        if (includeParentContexts) {
            iMacroContextInfoArray = BuildMacroProvider.getAllMacroContextInfos(contextInfo);
        } else {
            IMacroContextInfo[] iMacroContextInfoArray2 = new IMacroContextInfo[1];
            iMacroContextInfoArray = iMacroContextInfoArray2;
            iMacroContextInfoArray2[0] = contextInfo;
        }
        IMacroContextInfo[] infos = iMacroContextInfoArray;
        int k = infos.length - 1;
        while (k >= 0) {
            contextInfo = infos[k];
            IBuildMacroSupplier[] suppliers = contextInfo.getSuppliers();
            if (suppliers != null) {
                int i = suppliers.length - 1;
                while (i >= 0) {
                    IBuildMacro[] macros = suppliers[i].getMacros(contextInfo.getContextType(), contextInfo.getContextData());
                    if (macros != null) {
                        int j = 0;
                        while (j < macros.length) {
                            map.put(macros[j].getName(), macros[j]);
                            ++j;
                        }
                    }
                    --i;
                }
            }
            --k;
        }
        Collection values = map.values();
        return values.toArray(new IBuildMacro[values.size()]);
    }

    private static IMacroContextInfo[] getAllMacroContextInfos(IMacroContextInfo contextInfo) {
        if (contextInfo == null) {
            return null;
        }
        ArrayList<IMacroContextInfo> list = new ArrayList<IMacroContextInfo>();
        list.add(contextInfo);
        while ((contextInfo = contextInfo.getNext()) != null) {
            list.add(contextInfo);
        }
        return list.toArray(new IMacroContextInfo[list.size()]);
    }

    public IBuildMacroSupplier[] getSuppliers(int contextType, Object contextData) {
        IMacroContextInfo info = this.getMacroContextInfo(contextType, contextData);
        if (info != null) {
            return info.getSuppliers();
        }
        return null;
    }

    public IMacroContextInfo getMacroContextInfo(int contextType, Object contextData) {
        DefaultMacroContextInfo info = new DefaultMacroContextInfo(contextType, contextData);
        if (info.getSuppliers() != null) {
            return info;
        }
        return null;
    }

    public String convertStringListToString(String[] value, String listDelimiter) {
        return MacroResolver.convertStringListToString(value, listDelimiter);
    }

    public String resolveValue(String value, String nonexistentMacrosValue, String listDelimiter, int contextType, Object contextData) throws BuildMacroException {
        IMacroContextInfo info = this.getMacroContextInfo(contextType, contextData);
        if (info != null) {
            return MacroResolver.resolveToString(value, this.getMacroSubstitutor(info, nonexistentMacrosValue, listDelimiter));
        }
        return null;
    }

    public String[] resolveStringListValue(String value, String nonexistentMacrosValue, String listDelimiter, int contextType, Object contextData) throws BuildMacroException {
        IMacroContextInfo info = this.getMacroContextInfo(contextType, contextData);
        if (info != null) {
            return MacroResolver.resolveToStringList(value, this.getMacroSubstitutor(info, nonexistentMacrosValue, listDelimiter));
        }
        return null;
    }

    public String resolveValueToMakefileFormat(String value, String nonexistentMacrosValue, String listDelimiter, int contextType, Object contextData) throws BuildMacroException {
        IMacroContextInfo info = this.getMacroContextInfo(contextType, contextData);
        if (info != null) {
            return MacroResolver.resolveToString(value, this.getBuildfileMacroSubstitutor(info, nonexistentMacrosValue, listDelimiter));
        }
        return null;
    }

    public String[] resolveStringListValueToMakefileFormat(String value, String nonexistentMacrosValue, String listDelimiter, int contextType, Object contextData) throws BuildMacroException {
        IMacroContextInfo info = this.getMacroContextInfo(contextType, contextData);
        if (info != null) {
            return MacroResolver.resolveToStringList(value, this.getBuildfileMacroSubstitutor(info, nonexistentMacrosValue, listDelimiter));
        }
        return null;
    }

    public boolean isStringListValue(String value, int contextType, Object contextData) throws BuildMacroException {
        try {
            MacroResolver.resolveToStringList(value, this.getMacroSubstitutor(this.getMacroContextInfo(contextType, contextData), " ", null));
        }
        catch (BuildMacroException buildMacroException) {
            return false;
        }
        return true;
    }

    public void checkIntegrity(int contextType, Object contextData) throws BuildMacroException {
        IMacroContextInfo info = this.getMacroContextInfo(contextType, contextData);
        DefaultMacroSubstitutor subst = new DefaultMacroSubstitutor(info, null, ""){

            protected DefaultMacroSubstitutor.ResolvedMacro resolveMacro(IBuildMacro macro) throws BuildMacroException {
                if (macro instanceof EclipseVariablesMacroSupplier.EclipseVarMacro) {
                    return new DefaultMacroSubstitutor.ResolvedMacro((DefaultMacroSubstitutor)this, macro.getName(), "");
                }
                return super.resolveMacro(macro);
            }
        };
        if (info != null) {
            MacroResolver.checkIntegrity(info, subst);
        }
    }

    public IMacroSubstitutor getMacroSubstitutor(IMacroContextInfo info, String inexistentMacroValue, String listDelimiter) {
        return new DefaultMacroSubstitutor(info, inexistentMacroValue, listDelimiter);
    }

    public IMacroSubstitutor getBuildfileMacroSubstitutor(IMacroContextInfo info, String inexistentMacroValue, String listDelimiter) {
        return new BuildfileMacroSubstitutor(info, inexistentMacroValue, listDelimiter);
    }

    public boolean checkParentContextRelation(IMacroContextInfo child, IMacroContextInfo parent) {
        if (child == null || parent == null) {
            return false;
        }
        IMacroContextInfo enumInfo = child;
        do {
            if (parent.getContextType() != enumInfo.getContextType() || parent.getContextData() != enumInfo.getContextData()) continue;
            return true;
        } while ((enumInfo = enumInfo.getNext()) != null);
        return false;
    }

    public boolean areMacrosExpandedInBuildfile(IConfiguration cfg) {
        boolean expanded = fUserDefinedMacroSupplier.areMacrosExpanded(cfg);
        if (expanded || this.canKeepMacrosInBuildfile(cfg)) {
            return expanded;
        }
        return true;
    }

    public boolean expandMacrosInBuildfile(IConfiguration cfg, boolean expand) {
        if (expand || this.canKeepMacrosInBuildfile(cfg)) {
            fUserDefinedMacroSupplier.setMacrosExpanded(cfg, expand);
            return expand;
        }
        return true;
    }

    public boolean canKeepMacrosInBuildfile(IConfiguration cfg) {
        return MacroResolver.canKeepMacrosInBuildfile(cfg);
    }

    public boolean canKeepMacrosInBuildfile(IBuilder builder) {
        return MacroResolver.canKeepMacrosInBuildfile(builder);
    }
}

