/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.makegen.gnu;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.internal.core.model.Util;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IInputType;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedCommandLineGenerator;
import org.eclipse.cdt.managedbuilder.core.IManagedCommandLineInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedOutputNameProvider;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IOutputType;
import org.eclipse.cdt.managedbuilder.core.IResourceConfiguration;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedMakeMessages;
import org.eclipse.cdt.managedbuilder.internal.macros.FileContextData;
import org.eclipse.cdt.managedbuilder.internal.macros.MacroResolver;
import org.eclipse.cdt.managedbuilder.macros.BuildMacroException;
import org.eclipse.cdt.managedbuilder.makegen.IManagedBuilderMakefileGenerator;
import org.eclipse.cdt.managedbuilder.makegen.IManagedDependencyGenerator;
import org.eclipse.cdt.managedbuilder.makegen.gnu.IManagedBuildGnuToolInfo;
import org.eclipse.cdt.managedbuilder.makegen.gnu.ManagedBuildGnuToolInfo;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;

public class GnuMakefileGenerator
implements IManagedBuilderMakefileGenerator {
    private static final String COMMENT = "MakefileGenerator.comment";
    private static final String HEADER = "MakefileGenerator.comment.header";
    protected static final String MESSAGE_FINISH_BUILD = ManagedMakeMessages.getResourceString("MakefileGenerator.message.finish.build");
    protected static final String MESSAGE_FINISH_FILE = ManagedMakeMessages.getResourceString("MakefileGenerator.message.finish.file");
    protected static final String MESSAGE_START_BUILD = ManagedMakeMessages.getResourceString("MakefileGenerator.message.start.build");
    protected static final String MESSAGE_START_FILE = ManagedMakeMessages.getResourceString("MakefileGenerator.message.start.file");
    protected static final String MESSAGE_NO_TARGET_TOOL = ManagedMakeMessages.getResourceString("MakefileGenerator.message.no.target");
    private static final String MOD_LIST = "MakefileGenerator.comment.module.list";
    private static final String MOD_VARS = "MakefileGenerator.comment.module.variables";
    private static final String MOD_RULES = "MakefileGenerator.comment.build.rule";
    private static final String BUILD_TOP = "MakefileGenerator.comment.build.toprules";
    private static final String ALL_TARGET = "MakefileGenerator.comment.build.alltarget";
    private static final String MAINBUILD_TARGET = "MakefileGenerator.comment.build.mainbuildtarget";
    private static final String BUILD_TARGETS = "MakefileGenerator.comment.build.toptargets";
    private static final String SRC_LISTS = "MakefileGenerator.comment.source.list";
    private static final String EMPTY_STRING = new String();
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final String OBJS_MACRO = "OBJS";
    private static final String DEPS_MACRO = "DEPS";
    private static final String MACRO_ADDITION_ADDPREFIX_HEADER = "${addprefix ";
    private static final String MACRO_ADDITION_ADDPREFIX_SUFFIX = ", \\\n";
    private static final String MACRO_ADDITION_PREFIX_SUFFIX = "+= \\\n";
    private static final String PREBUILD = "pre-build";
    private static final String MAINBUILD = "main-build";
    private static final String POSTBUILD = "post-build";
    private static final String SECONDARY_OUTPUTS = "secondary-outputs";
    public static final int PROJECT_RELATIVE = 1;
    public static final int PROJECT_SUBDIR_RELATIVE = 2;
    public static final int ABSOLUTE = 3;
    private String buildTargetName;
    private String buildTargetExt;
    private IConfiguration config;
    private ITool[] buildTools;
    private boolean[] buildToolsUsed;
    private ManagedBuildGnuToolInfo[] gnuToolInfos;
    private Vector deletedFileList;
    private Vector deletedDirList;
    private Vector dependencyMakefiles;
    private IManagedBuildInfo info;
    private Vector invalidDirList;
    private Vector modifiedList;
    private IProgressMonitor monitor;
    private IProject project;
    private IResource[] projectResources;
    private Vector ruleList;
    private Vector depLineList;
    private Vector subdirList;
    private IPath topBuildDir;
    private Set outputExtensionsSet;
    private HashMap buildSrcVars = new HashMap();
    private HashMap buildOutVars = new HashMap();
    private LinkedHashMap topBuildOutVars = new LinkedHashMap();

    public void initialize(IProject project, IManagedBuildInfo info, IProgressMonitor monitor) {
        this.project = project;
        try {
            this.projectResources = project.members();
        }
        catch (CoreException coreException) {
            this.projectResources = null;
        }
        this.monitor = monitor;
        this.info = info;
        this.buildTargetName = info.getBuildArtifactName();
        this.buildTargetExt = info.getBuildArtifactExtension();
        try {
            this.buildTargetExt = ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(this.buildTargetExt, "", " ", 3, info.getDefaultConfiguration());
        }
        catch (BuildMacroException buildMacroException) {}
        try {
            String resolved = ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(this.buildTargetName, "", " ", 3, info.getDefaultConfiguration());
            resolved = resolved.trim();
            if (resolved.length() > 0) {
                this.buildTargetName = resolved;
            }
        }
        catch (BuildMacroException buildMacroException) {}
        if (this.buildTargetExt == null) {
            this.buildTargetExt = new String();
        }
        this.config = info.getDefaultConfiguration();
        this.buildTools = this.config.getFilteredTools();
        this.buildToolsUsed = new boolean[this.buildTools.length];
        int i = 0;
        while (i < this.buildTools.length) {
            this.buildToolsUsed[i] = false;
            ++i;
        }
        this.gnuToolInfos = new ManagedBuildGnuToolInfo[this.buildTools.length];
        this.topBuildDir = project.getFolder(info.getConfigurationName()).getFullPath();
    }

    public void generateDependencies() throws CoreException {
        IWorkspaceRoot root = CCorePlugin.getWorkspace().getRoot();
        ListIterator subDirs = this.getSubdirList().listIterator();
        while (subDirs.hasNext()) {
            IContainer subDir = (IContainer)subDirs.next();
            IPath projectRelativePath = subDir.getProjectRelativePath();
            IPath buildRelativePath = this.topBuildDir.append(projectRelativePath);
            IFolder buildFolder = root.getFolder(buildRelativePath);
            if (buildFolder == null) continue;
            IResource[] files = buildFolder.members();
            int index = 0;
            while (index < files.length) {
                IFile depFile;
                IResource file = files[index];
                if ("d".equals(file.getFileExtension()) && (depFile = root.getFile(file.getFullPath())) != null) {
                    try {
                        this.updateMonitor(ManagedMakeMessages.getFormattedString("GnuMakefileGenerator.message.postproc.dep.file", depFile.getName()));
                        this.populateDummyTargets(depFile, false);
                    }
                    catch (CoreException e) {
                        throw e;
                    }
                    catch (IOException iOException) {}
                }
                ++index;
            }
        }
    }

    public MultiStatus generateMakefiles(IResourceDelta delta) throws CoreException {
        MultiStatus status;
        IContainer subDir;
        IFolder folder = this.project.getFolder(this.info.getConfigurationName());
        if (!folder.exists()) {
            return this.regenerateMakefiles();
        }
        this.updateMonitor(ManagedMakeMessages.getFormattedString("MakefileGenerator.message.calc.delta", this.project.getName()));
        ResourceDeltaVisitor visitor = new ResourceDeltaVisitor(this, this.info);
        delta.accept((IResourceDeltaVisitor)visitor);
        this.checkCancel();
        this.updateMonitor(ManagedMakeMessages.getFormattedString("MakefileGenerator.message.finding.sources", this.project.getName()));
        ResourceProxyVisitor resourceVisitor = new ResourceProxyVisitor(this, this.info);
        this.project.accept((IResourceProxyVisitor)resourceVisitor, 0);
        this.checkCancel();
        if (this.getSubdirList().isEmpty()) {
            String info = ManagedMakeMessages.getFormattedString("MakefileGenerator.warning.no.source", this.project.getName());
            this.updateMonitor(info);
            MultiStatus status2 = new MultiStatus(ManagedBuilderCorePlugin.getUniqueIdentifier(), 1, new String(), null);
            status2.add((IStatus)new Status(1, ManagedBuilderCorePlugin.getUniqueIdentifier(), 1, info, null));
            return status2;
        }
        this.topBuildDir = this.createDirectory(this.info.getConfigurationName());
        this.checkCancel();
        IPath srcsFilePath = this.topBuildDir.append("sources.mk");
        IFile srcsFileHandle = this.createFile(srcsFilePath);
        this.buildSrcVars.clear();
        this.buildOutVars.clear();
        this.topBuildOutVars.clear();
        this.populateSourcesMakefile(srcsFileHandle);
        this.checkCancel();
        Iterator iter = this.getSubdirList().listIterator();
        while (iter.hasNext()) {
            IContainer subdirectory = (IContainer)iter.next();
            if (this.getModifiedList().contains(subdirectory)) continue;
            if (!subdirectory.exists()) {
                this.appendDeletedSubdirectory(subdirectory);
                continue;
            }
            IPath fragmentPath = this.getBuildWorkingDir().append(subdirectory.getProjectRelativePath()).append("subdir.mk");
            IFile makeFragment = this.project.getFile(fragmentPath);
            if (makeFragment.exists()) continue;
            this.getModifiedList().add(subdirectory);
        }
        iter = this.getDeletedFileList().listIterator();
        while (iter.hasNext()) {
            IResource deletedFile = (IResource)iter.next();
            this.deleteDepFile(deletedFile);
            this.deleteBuildTarget(deletedFile);
        }
        iter = this.getModifiedList().listIterator();
        while (iter.hasNext()) {
            subDir = (IContainer)iter.next();
            if (!subDir.exists()) {
                this.appendDeletedSubdirectory(subDir);
                continue;
            }
            this.checkCancel();
        }
        iter = this.getSubdirList().listIterator();
        while (iter.hasNext()) {
            subDir = (IContainer)iter.next();
            try {
                this.populateFragmentMakefile(subDir);
            }
            catch (CoreException coreException) {
                this.checkCancel();
                continue;
            }
            this.checkCancel();
        }
        this.calculateToolInputsOutputs();
        this.checkCancel();
        IPath makefilePath = this.topBuildDir.append("makefile");
        IFile makefileHandle = this.createFile(makefilePath);
        this.populateTopMakefile(makefileHandle, false);
        this.checkCancel();
        iter = this.getDeletedDirList().listIterator();
        while (iter.hasNext()) {
            IContainer subDir2 = (IContainer)iter.next();
            this.removeGeneratedDirectory(subDir2);
            this.checkCancel();
        }
        if (!this.getInvalidDirList().isEmpty()) {
            status = new MultiStatus(ManagedBuilderCorePlugin.getUniqueIdentifier(), 2, new String(), null);
            iter = this.getInvalidDirList().iterator();
            while (iter.hasNext()) {
                status.add((IStatus)new Status(2, ManagedBuilderCorePlugin.getUniqueIdentifier(), 0, ((IContainer)iter.next()).getFullPath().toString(), null));
            }
        } else {
            status = new MultiStatus(ManagedBuilderCorePlugin.getUniqueIdentifier(), 0, new String(), null);
        }
        return status;
    }

    public IPath getBuildWorkingDir() {
        if (this.topBuildDir != null) {
            return this.topBuildDir.removeFirstSegments(1);
        }
        return null;
    }

    public String getMakefileName() {
        return new String("makefile");
    }

    public boolean isGeneratedResource(IResource resource) {
        IPath path = resource.getProjectRelativePath();
        String[] configNames = this.info.getConfigurationNames();
        int i = 0;
        while (i < configNames.length) {
            String name = configNames[i];
            Path root = new Path(name);
            if (root.isPrefixOf(path)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void regenerateDependencies(boolean force) throws CoreException {
        IWorkspaceRoot root = CCorePlugin.getWorkspace().getRoot();
        ListIterator iter = this.getDependencyMakefiles().listIterator();
        while (iter.hasNext()) {
            IPath relDepFilePath = this.topBuildDir.append((IPath)new Path((String)iter.next()));
            IFile depFile = root.getFile(relDepFilePath);
            if (depFile == null || !depFile.isAccessible()) continue;
            try {
                this.updateMonitor(ManagedMakeMessages.getFormattedString("GnuMakefileGenerator.message.postproc.dep.file", depFile.getName()));
                this.populateDummyTargets(depFile, true);
            }
            catch (CoreException e) {
                throw e;
            }
            catch (IOException iOException) {}
        }
    }

    public MultiStatus regenerateMakefiles() throws CoreException {
        MultiStatus status;
        ResourceProxyVisitor visitor = new ResourceProxyVisitor(this, this.info);
        this.project.accept((IResourceProxyVisitor)visitor, 0);
        this.checkCancel();
        if (this.getSubdirList().isEmpty()) {
            String info = ManagedMakeMessages.getFormattedString("MakefileGenerator.warning.no.source", this.project.getName());
            this.updateMonitor(info);
            MultiStatus status2 = new MultiStatus(ManagedBuilderCorePlugin.getUniqueIdentifier(), 1, new String(), null);
            status2.add((IStatus)new Status(1, ManagedBuilderCorePlugin.getUniqueIdentifier(), 1, info, null));
            return status2;
        }
        this.topBuildDir = this.createDirectory(this.info.getConfigurationName());
        this.checkCancel();
        IPath srcsFilePath = this.topBuildDir.append("sources.mk");
        IFile srcsFileHandle = this.createFile(srcsFilePath);
        this.buildSrcVars.clear();
        this.buildOutVars.clear();
        this.topBuildOutVars.clear();
        this.populateSourcesMakefile(srcsFileHandle);
        this.checkCancel();
        Iterator iter = this.getSubdirList().listIterator();
        while (iter.hasNext()) {
            IContainer subDir = (IContainer)iter.next();
            try {
                this.populateFragmentMakefile(subDir);
            }
            catch (CoreException coreException) {
                this.checkCancel();
                continue;
            }
            this.checkCancel();
        }
        this.calculateToolInputsOutputs();
        this.checkCancel();
        IPath makefilePath = this.topBuildDir.append("makefile");
        IFile makefileHandle = this.createFile(makefilePath);
        this.populateTopMakefile(makefileHandle, true);
        this.checkCancel();
        IPath objFilePath = this.topBuildDir.append("objects.mk");
        IFile objsFileHandle = this.createFile(objFilePath);
        this.populateObjectsMakefile(objsFileHandle);
        this.checkCancel();
        if (!this.getInvalidDirList().isEmpty()) {
            status = new MultiStatus(ManagedBuilderCorePlugin.getUniqueIdentifier(), 2, new String(), null);
            iter = this.getInvalidDirList().iterator();
            while (iter.hasNext()) {
                status.add((IStatus)new Status(2, ManagedBuilderCorePlugin.getUniqueIdentifier(), 0, ((IContainer)iter.next()).getFullPath().toString(), null));
            }
        } else {
            status = new MultiStatus(ManagedBuilderCorePlugin.getUniqueIdentifier(), 0, new String(), null);
        }
        return status;
    }

    protected void populateDummyTargets(IFile makefile, boolean force) throws CoreException, IOException {
        String firstToken;
        if (makefile == null || !makefile.exists()) {
            return;
        }
        InputStream contentStream = makefile.getContents(false);
        InputStreamReader in = new InputStreamReader(contentStream);
        StringBuffer inBuffer = null;
        int chunkSize = contentStream.available();
        inBuffer = new StringBuffer(chunkSize);
        char[] readBuffer = new char[chunkSize];
        int n = in.read(readBuffer);
        while (n > 0) {
            inBuffer.append(readBuffer);
            n = in.read(readBuffer);
        }
        contentStream.close();
        if (inBuffer == null) {
            return;
        }
        String inBufferString = inBuffer.toString();
        if (!force && inBufferString.startsWith("#")) {
            return;
        }
        String[] bufferLines = inBufferString.split("[\\r\\n]");
        int i = 0;
        while (i < bufferLines.length) {
            String bufferLine = bufferLines[i];
            if (bufferLine.endsWith(":")) {
                StringBuffer outBuffer = this.addDefaultHeader();
                outBuffer.append(inBuffer);
                Util.save((StringBuffer)outBuffer, (IFile)makefile);
                return;
            }
            ++i;
        }
        Vector<String> bufferTokens = new Vector<String>(Arrays.asList(inBufferString.split("\\s")));
        Vector<String> deps = new Vector<String>(bufferTokens.size());
        Iterator<String> tokenIter = bufferTokens.iterator();
        while (tokenIter.hasNext()) {
            String token = tokenIter.next();
            if (token.lastIndexOf("\\") == token.length() - 1 && token.length() > 1) {
                while (tokenIter.hasNext()) {
                    String nextToken = tokenIter.next();
                    token = String.valueOf(token) + " " + nextToken;
                    if (!nextToken.endsWith("\\")) break;
                }
            }
            deps.add(token);
        }
        deps.trimToSize();
        boolean save = false;
        StringBuffer outBuffer = null;
        try {
            firstToken = (String)deps.get(0);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return;
        }
        outBuffer = !firstToken.startsWith("#") ? this.addDefaultHeader() : new StringBuffer();
        if (firstToken.startsWith("-n")) {
            String fourthToken;
            String thirdToken;
            String secondToken;
            try {
                secondToken = (String)deps.get(1);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                secondToken = new String();
            }
            if (secondToken.startsWith("'")) {
                outBuffer.append(String.valueOf(secondToken.substring(1)) + " ");
            } else {
                outBuffer.append(String.valueOf(secondToken) + " ");
            }
            try {
                thirdToken = (String)deps.get(2);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                thirdToken = new String();
            }
            int lastIndex = thirdToken.lastIndexOf("'");
            if (lastIndex != -1) {
                if (lastIndex == 0) {
                    outBuffer.append(" ");
                } else {
                    outBuffer.append(thirdToken.substring(0, lastIndex - 1));
                }
            } else {
                outBuffer.append(thirdToken);
            }
            int nToken = 3;
            try {
                while ((fourthToken = (String)deps.get(nToken++)).length() == 0) {
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                fourthToken = new String();
            }
            outBuffer.append(String.valueOf(fourthToken) + " ");
            try {
                ListIterator iter = deps.listIterator(nToken);
                while (iter.hasNext()) {
                    String nextElement = (String)iter.next();
                    if (nextElement.endsWith("\\")) {
                        outBuffer.append(String.valueOf(nextElement) + IManagedBuilderMakefileGenerator.NEWLINE + " ");
                        continue;
                    }
                    outBuffer.append(String.valueOf(nextElement) + " ");
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        } else {
            outBuffer.append(inBuffer);
        }
        outBuffer.append(IManagedBuilderMakefileGenerator.NEWLINE);
        save = true;
        Iterator dummyIter = deps.iterator();
        while (dummyIter.hasNext()) {
            String dummy = (String)dummyIter.next();
            Path dep = new Path(dummy);
            String extension = dep.getFileExtension();
            if (!this.info.isHeaderFile(extension)) continue;
            outBuffer.append(String.valueOf(dummy) + ":" + IManagedBuilderMakefileGenerator.NEWLINE + IManagedBuilderMakefileGenerator.NEWLINE);
        }
        if (save) {
            Util.save((StringBuffer)outBuffer, (IFile)makefile);
        }
    }

    protected void populateFragmentMakefile(IContainer module) throws CoreException {
        IPath moduleRelativePath = module.getProjectRelativePath();
        IPath buildRoot = this.getBuildWorkingDir();
        if (buildRoot == null) {
            return;
        }
        IPath moduleOutputPath = buildRoot.append(moduleRelativePath);
        this.updateMonitor(ManagedMakeMessages.getFormattedString("MakefileGenerator.message.gen.source.makefile", moduleOutputPath.toString()));
        IPath moduleOutputDir = this.createDirectory(moduleOutputPath.toString());
        IFile modMakefile = this.createFile(moduleOutputDir.append("subdir.mk"));
        StringBuffer makeBuf = new StringBuffer();
        makeBuf.append(this.addFragmentMakefileHeader());
        makeBuf.append(this.addSources(module));
        Util.save((StringBuffer)makeBuf, (IFile)modMakefile);
    }

    protected void populateObjectsMakefile(IFile fileHandle) throws CoreException {
        StringBuffer macroBuffer = new StringBuffer();
        macroBuffer.append(this.addDefaultHeader());
        HashMap outputMacros = new HashMap();
        List valueList = new ArrayList<String>();
        String[] libs = this.info.getLibsForConfiguration(this.buildTargetExt);
        int i = 0;
        while (i < libs.length) {
            String string = libs[i];
            valueList.add(string);
            ++i;
        }
        outputMacros.put("LIBS", valueList);
        valueList = new ArrayList();
        String[] userObjs = this.info.getUserObjectsForConfiguration(this.buildTargetExt);
        int i2 = 0;
        while (i2 < userObjs.length) {
            String string = userObjs[i2];
            valueList.add(string);
            ++i2;
        }
        outputMacros.put("USER_OBJS", valueList);
        Iterator iterator = outputMacros.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            macroBuffer.append(String.valueOf((String)entry.getKey()) + " :=");
            valueList = (List)entry.getValue();
            Iterator valueIter = valueList.iterator();
            while (valueIter.hasNext()) {
                macroBuffer.append(" " + (String)valueIter.next());
            }
            if (!iterator.hasNext()) continue;
            macroBuffer.append(String.valueOf(IManagedBuilderMakefileGenerator.NEWLINE) + IManagedBuilderMakefileGenerator.NEWLINE);
        }
        Util.save((StringBuffer)macroBuffer, (IFile)fileHandle);
    }

    protected void populateSourcesMakefile(IFile fileHandle) throws CoreException {
        String macroName;
        Map.Entry entry;
        StringBuffer buffer = this.addDefaultHeader();
        HashSet<String> handledInputExtensions = new HashSet<String>();
        int i = 0;
        while (i < this.buildTools.length) {
            String buildMacro;
            String[] extensionsList = this.buildTools[i].getAllInputExtensions();
            int j = 0;
            while (j < extensionsList.length) {
                String extensionName = extensionsList[j];
                if (!handledInputExtensions.contains(extensionName)) {
                    handledInputExtensions.add(extensionName);
                    buildMacro = this.getSourceMacroName(extensionName).toString();
                    if (!this.buildSrcVars.containsKey(buildMacro)) {
                        this.buildSrcVars.put(buildMacro, new ArrayList());
                    }
                }
                ++j;
            }
            IOutputType[] outTypes = this.buildTools[i].getOutputTypes();
            if (outTypes != null && outTypes.length > 0) {
                int j2 = 0;
                while (j2 < outTypes.length) {
                    buildMacro = outTypes[j2].getBuildVariable();
                    if (!this.buildOutVars.containsKey(buildMacro)) {
                        this.buildOutVars.put(buildMacro, new ArrayList());
                    }
                    ++j2;
                }
            } else {
                buildMacro = OBJS_MACRO;
                if (!this.buildOutVars.containsKey(buildMacro)) {
                    this.buildOutVars.put(buildMacro, new ArrayList());
                }
            }
            buildMacro = DEPS_MACRO;
            if (!this.buildOutVars.containsKey(buildMacro)) {
                this.buildOutVars.put(buildMacro, new ArrayList());
            }
            ++i;
        }
        Iterator iterator = this.buildSrcVars.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            macroName = (String)entry.getKey();
            buffer.append(String.valueOf(macroName) + " " + ":=" + " " + IManagedBuilderMakefileGenerator.NEWLINE);
        }
        iterator = this.buildOutVars.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            macroName = (String)entry.getKey();
            buffer.append(String.valueOf(macroName) + " " + ":=" + " " + IManagedBuilderMakefileGenerator.NEWLINE);
        }
        buffer.append(String.valueOf(IManagedBuilderMakefileGenerator.NEWLINE) + this.addSubdirectories());
        Util.save((StringBuffer)buffer, (IFile)fileHandle);
    }

    protected void populateTopMakefile(IFile fileHandle, boolean rebuild) throws CoreException {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.addTopHeader());
        buffer.append(this.addMacros());
        ArrayList outputVarsAdditionsList = new ArrayList();
        StringBuffer targetRules = this.addTargets(outputVarsAdditionsList, rebuild);
        buffer.append(this.writeTopAdditionMacros(outputVarsAdditionsList, this.getTopBuildOutputVars()));
        buffer.append(targetRules);
        Util.save((StringBuffer)buffer, (IFile)fileHandle);
    }

    protected StringBuffer addTopHeader() {
        return this.addDefaultHeader();
    }

    private StringBuffer addMacros() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("ROOT := .." + IManagedBuilderMakefileGenerator.NEWLINE);
        buffer.append(IManagedBuilderMakefileGenerator.NEWLINE);
        buffer.append("-include $(ROOT)/makefile.init" + IManagedBuilderMakefileGenerator.NEWLINE);
        buffer.append(IManagedBuilderMakefileGenerator.NEWLINE);
        buffer.append("RM := ");
        String cleanCommand = this.info.getCleanCommand();
        try {
            cleanCommand = ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(this.info.getCleanCommand(), EMPTY_STRING, " ", 3, this.config);
        }
        catch (BuildMacroException buildMacroException) {}
        buffer.append(String.valueOf(cleanCommand) + IManagedBuilderMakefileGenerator.NEWLINE);
        buffer.append(IManagedBuilderMakefileGenerator.NEWLINE);
        buffer.append("# " + ManagedMakeMessages.getResourceString(SRC_LISTS) + IManagedBuilderMakefileGenerator.NEWLINE);
        buffer.append("-include sources.mk" + IManagedBuilderMakefileGenerator.NEWLINE);
        buffer.append("-include $(SUBDIRS:%=%/subdir.mk)" + IManagedBuilderMakefileGenerator.NEWLINE);
        buffer.append("-include objects.mk" + IManagedBuilderMakefileGenerator.NEWLINE);
        buffer.append("ifneq ($(strip $(DEPS)),)" + IManagedBuilderMakefileGenerator.NEWLINE);
        buffer.append("-include $(DEPS)" + IManagedBuilderMakefileGenerator.NEWLINE);
        buffer.append("endif" + IManagedBuilderMakefileGenerator.NEWLINE + IManagedBuilderMakefileGenerator.NEWLINE);
        buffer.append("-include $(ROOT)/makefile.defs" + IManagedBuilderMakefileGenerator.NEWLINE);
        return buffer.append(IManagedBuilderMakefileGenerator.NEWLINE);
    }

    private StringBuffer addTargets(List outputVarsAdditionsList, boolean rebuild) {
        int i;
        IOutputType[] secondaryOutputs;
        StringBuffer buffer = new StringBuffer();
        IConfiguration config = this.info.getDefaultConfiguration();
        String prebuildStep = this.info.getPrebuildStep();
        try {
            prebuildStep = ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(prebuildStep, EMPTY_STRING, " ", 3, config);
        }
        catch (BuildMacroException buildMacroException) {}
        prebuildStep = prebuildStep.trim();
        String postbuildStep = this.info.getPostbuildStep();
        try {
            postbuildStep = ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(postbuildStep, EMPTY_STRING, " ", 3, config);
        }
        catch (BuildMacroException buildMacroException) {}
        postbuildStep = postbuildStep.trim();
        String preannouncebuildStep = this.info.getPreannouncebuildStep();
        String postannouncebuildStep = this.info.getPostannouncebuildStep();
        String targets = rebuild ? "clean all" : "all";
        ITool targetTool = config.getTargetTool();
        if (targetTool == null) {
            targetTool = this.info.getToolFromOutputExtension(this.buildTargetExt);
        }
        IProject[] refdProjects = null;
        try {
            refdProjects = this.project.getReferencedProjects();
        }
        catch (CoreException coreException) {}
        String defaultTarget = "all:";
        if (prebuildStep.length() > 0) {
            buffer.append("# " + ManagedMakeMessages.getResourceString(ALL_TARGET) + IManagedBuilderMakefileGenerator.NEWLINE);
            buffer.append(String.valueOf(defaultTarget) + " ");
            buffer.append("pre-build ");
            defaultTarget = MAINBUILD;
            buffer.append(defaultTarget);
            defaultTarget = defaultTarget.concat(":");
            buffer.append(String.valueOf(IManagedBuilderMakefileGenerator.NEWLINE) + IManagedBuilderMakefileGenerator.NEWLINE);
            buffer.append("# " + ManagedMakeMessages.getResourceString(MAINBUILD_TARGET) + IManagedBuilderMakefileGenerator.NEWLINE);
        } else {
            buffer.append("# " + ManagedMakeMessages.getResourceString(ALL_TARGET) + IManagedBuilderMakefileGenerator.NEWLINE);
        }
        String outputPrefix = EMPTY_STRING;
        if (targetTool != null) {
            outputPrefix = targetTool.getOutputPrefix();
        }
        buffer.append(String.valueOf(defaultTarget) + " " + outputPrefix + this.buildTargetName);
        if (this.buildTargetExt.length() > 0) {
            buffer.append("." + this.buildTargetExt);
        }
        if ((secondaryOutputs = config.getToolChain().getSecondaryOutputs()).length > 0) {
            buffer.append(" secondary-outputs");
        }
        buffer.append(String.valueOf(IManagedBuilderMakefileGenerator.NEWLINE) + IManagedBuilderMakefileGenerator.NEWLINE);
        Vector<String> managedProjectOutputs = new Vector<String>(refdProjects.length);
        if (refdProjects.length > 0) {
            boolean addDeps = true;
            if (refdProjects != null) {
                i = 0;
                while (i < refdProjects.length) {
                    IProject dep = refdProjects[i];
                    if (dep.exists()) {
                        if (addDeps) {
                            buffer.append("dependents:" + IManagedBuilderMakefileGenerator.NEWLINE);
                            addDeps = false;
                        }
                        String buildDir = dep.getLocation().toString();
                        String depTargets = targets;
                        if (ManagedBuildManager.manages((IResource)dep)) {
                            IManagedBuildInfo depInfo = ManagedBuildManager.getBuildInfo((IResource)dep);
                            buildDir = String.valueOf(buildDir) + "/" + depInfo.getConfigurationName();
                            String depTarget = depInfo.getBuildArtifactName();
                            String depExt = depInfo.getBuildArtifactExtension();
                            try {
                                depExt = ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(depExt, "", " ", 3, this.info.getDefaultConfiguration());
                            }
                            catch (BuildMacroException buildMacroException) {}
                            try {
                                String resolved = ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(depTarget, "", " ", 3, this.info.getDefaultConfiguration());
                                resolved = resolved.trim();
                                if (resolved.length() > 0) {
                                    depTarget = resolved;
                                }
                            }
                            catch (BuildMacroException buildMacroException) {}
                            String depPrefix = depInfo.getOutputPrefix(depExt);
                            if (depInfo.needsRebuild()) {
                                depTargets = "clean all";
                            }
                            String dependency = String.valueOf(buildDir) + "/" + depPrefix + depTarget;
                            if (depExt.length() > 0) {
                                dependency = String.valueOf(dependency) + "." + depExt;
                            }
                            dependency = this.escapeWhitespaces(dependency);
                            managedProjectOutputs.add(dependency);
                        }
                        buffer.append("\t-cd " + this.escapeWhitespaces(buildDir) + " " + "&&" + " " + "$(MAKE) " + depTargets + IManagedBuilderMakefileGenerator.NEWLINE);
                    }
                    ++i;
                }
            }
            buffer.append(IManagedBuilderMakefileGenerator.NEWLINE);
        }
        buffer.append(this.addTargetsRules(targetTool, outputVarsAdditionsList, managedProjectOutputs, postbuildStep.length() > 0));
        if (prebuildStep.length() > 0) {
            buffer.append("pre-build:" + IManagedBuilderMakefileGenerator.NEWLINE);
            if (preannouncebuildStep.length() > 0) {
                buffer.append("\t-@echo '" + preannouncebuildStep + "'" + IManagedBuilderMakefileGenerator.NEWLINE);
            }
            buffer.append("\t-" + prebuildStep + IManagedBuilderMakefileGenerator.NEWLINE);
            buffer.append("\t-@echo ' '" + IManagedBuilderMakefileGenerator.NEWLINE + IManagedBuilderMakefileGenerator.NEWLINE);
        }
        if (postbuildStep.length() > 0) {
            buffer.append("post-build:" + IManagedBuilderMakefileGenerator.NEWLINE);
            if (postannouncebuildStep.length() > 0) {
                buffer.append("\t-@echo '" + postannouncebuildStep + "'" + IManagedBuilderMakefileGenerator.NEWLINE);
            }
            buffer.append("\t-" + postbuildStep + IManagedBuilderMakefileGenerator.NEWLINE);
            buffer.append("\t-@echo ' '" + IManagedBuilderMakefileGenerator.NEWLINE + IManagedBuilderMakefileGenerator.NEWLINE);
        }
        if (secondaryOutputs.length > 0) {
            buffer.append("secondary-outputs:");
            Vector outs2 = this.calculateSecondaryOutputs(secondaryOutputs);
            i = 0;
            while (i < outs2.size()) {
                buffer.append(" $(" + (String)outs2.get(i) + ")");
                ++i;
            }
            buffer.append(String.valueOf(IManagedBuilderMakefileGenerator.NEWLINE) + IManagedBuilderMakefileGenerator.NEWLINE);
        }
        buffer.append(".PHONY: all clean dependents" + IManagedBuilderMakefileGenerator.NEWLINE);
        buffer.append(".SECONDARY:");
        if (prebuildStep.length() > 0) {
            buffer.append(" main-build pre-build");
        }
        if (postbuildStep.length() > 0) {
            buffer.append(" post-build");
        }
        buffer.append(IManagedBuilderMakefileGenerator.NEWLINE);
        ListIterator refIter = managedProjectOutputs.listIterator();
        while (refIter.hasNext()) {
            buffer.append(String.valueOf((String)refIter.next()) + ":" + IManagedBuilderMakefileGenerator.NEWLINE);
        }
        buffer.append(IManagedBuilderMakefileGenerator.NEWLINE);
        buffer.append("-include $(ROOT)/makefile.targets" + IManagedBuilderMakefileGenerator.NEWLINE);
        return buffer;
    }

    private StringBuffer addTargetsRules(ITool targetTool, List outputVarsAdditionsList, Vector managedProjectOutputs, boolean postbuildStep) {
        int i;
        StringBuffer buffer = new StringBuffer();
        buffer.append("# " + ManagedMakeMessages.getResourceString(BUILD_TOP) + IManagedBuilderMakefileGenerator.NEWLINE);
        if (targetTool != null) {
            if (this.addRuleForTool(targetTool, buffer, true, this.buildTargetName, this.buildTargetExt, outputVarsAdditionsList, managedProjectOutputs, postbuildStep)) {
                i = 0;
                while (i < this.buildTools.length) {
                    if (targetTool == this.buildTools[i]) {
                        this.buildToolsUsed[i] = true;
                    }
                    ++i;
                }
            }
        } else {
            buffer.append("\t@echo '" + MESSAGE_NO_TARGET_TOOL + " " + "$@" + "'" + IManagedBuilderMakefileGenerator.NEWLINE);
        }
        i = 0;
        while (i < this.buildTools.length) {
            ITool tool = this.buildTools[i];
            IInputType type = tool.getPrimaryInputType();
            if (type != null && type.getMultipleOfType() && !this.buildToolsUsed[i]) {
                this.addRuleForTool(tool, buffer, false, null, null, outputVarsAdditionsList, null, false);
                this.buildToolsUsed[i] = true;
                this.generateRulesForConsumers(tool, outputVarsAdditionsList, buffer);
            }
            ++i;
        }
        buffer.append("# " + ManagedMakeMessages.getResourceString(BUILD_TARGETS) + IManagedBuilderMakefileGenerator.NEWLINE);
        buffer.append("clean:" + IManagedBuilderMakefileGenerator.NEWLINE);
        buffer.append("\t-$(RM) ");
        Iterator iterator = this.buildOutVars.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String macroName = (String)entry.getKey();
            buffer.append("$(" + macroName + ")");
        }
        String outputPrefix = EMPTY_STRING;
        if (targetTool != null) {
            outputPrefix = targetTool.getOutputPrefix();
        }
        buffer.append(" " + outputPrefix + this.buildTargetName);
        if (this.buildTargetExt.length() > 0) {
            buffer.append("." + this.buildTargetExt);
        }
        buffer.append(IManagedBuilderMakefileGenerator.NEWLINE);
        buffer.append("\t-@echo ' '" + IManagedBuilderMakefileGenerator.NEWLINE + IManagedBuilderMakefileGenerator.NEWLINE);
        return buffer;
    }

    protected boolean addRuleForTool(ITool tool, StringBuffer buffer, boolean bTargetTool, String targetName, String targetExt, List outputVarsAdditionsList, Vector managedProjectOutputs, boolean bEmitPostBuildStepCall) {
        Vector inputs = new Vector();
        Vector dependencies = new Vector();
        Vector outputs = new Vector();
        Vector enumeratedPrimaryOutputs = new Vector();
        Vector enumeratedSecondaryOutputs = new Vector();
        Vector outputVariables = new Vector();
        String outputPrefix = EMPTY_STRING;
        if (!this.getToolInputsOutputs(tool, inputs, dependencies, outputs, enumeratedPrimaryOutputs, enumeratedSecondaryOutputs, outputVariables, bTargetTool, managedProjectOutputs)) {
            return false;
        }
        if (enumeratedPrimaryOutputs.size() == 0) {
            enumeratedPrimaryOutputs = enumeratedSecondaryOutputs;
            enumeratedSecondaryOutputs.clear();
        }
        outputVarsAdditionsList.addAll(outputVariables);
        String buildRule = EMPTY_STRING;
        String outflag = tool.getOutputFlag();
        String primaryOutputs = EMPTY_STRING;
        boolean first = true;
        int i = 0;
        while (i < enumeratedPrimaryOutputs.size()) {
            String output = (String)enumeratedPrimaryOutputs.get(i);
            if (!first) {
                primaryOutputs = String.valueOf(primaryOutputs) + " ";
            }
            first = false;
            primaryOutputs = String.valueOf(primaryOutputs) + output;
            ++i;
        }
        buildRule = String.valueOf(buildRule) + primaryOutputs + ":" + " ";
        first = true;
        i = 0;
        while (i < dependencies.size()) {
            String input = (String)dependencies.get(i);
            if (!first) {
                buildRule = String.valueOf(buildRule) + " ";
            }
            first = false;
            buildRule = String.valueOf(buildRule) + input;
            ++i;
        }
        if (!this.getRuleList().contains(buildRule)) {
            String[] flags;
            this.getRuleList().add(buildRule);
            buffer.append(String.valueOf(buildRule) + IManagedBuilderMakefileGenerator.NEWLINE);
            if (bTargetTool) {
                buffer.append("\t@echo '" + MESSAGE_START_BUILD + " " + "$@" + "'" + IManagedBuilderMakefileGenerator.NEWLINE);
            }
            buffer.append("\t@echo '" + tool.getAnnouncement() + "'" + IManagedBuilderMakefileGenerator.NEWLINE);
            try {
                flags = tool.getToolCommandFlags(null, null);
            }
            catch (BuildException buildException) {
                flags = EMPTY_STRING_ARRAY;
            }
            String command = tool.getToolCommand();
            try {
                String resolvedCommand = ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(command, EMPTY_STRING, " ", 1, new FileContextData(null, null, null, tool));
                resolvedCommand = resolvedCommand.trim();
                if (resolvedCommand.length() > 0) {
                    command = resolvedCommand;
                }
            }
            catch (BuildMacroException buildMacroException) {}
            String[] cmdInputs = inputs.toArray(new String[inputs.size()]);
            IManagedCommandLineGenerator gen = tool.getCommandLineGenerator();
            IManagedCommandLineInfo cmdLInfo = gen.generateCommandLineInfo(tool, command, flags, outflag, outputPrefix, primaryOutputs, cmdInputs, tool.getCommandLinePattern());
            String buildCmd = null;
            if (cmdLInfo == null) {
                String toolFlags;
                try {
                    toolFlags = tool.getToolCommandFlagsString(null, null);
                }
                catch (BuildException buildException) {
                    toolFlags = EMPTY_STRING;
                }
                buildCmd = String.valueOf(command) + " " + toolFlags + " " + outflag + " " + outputPrefix + primaryOutputs + " " + "$<";
            } else {
                buildCmd = cmdLInfo.getCommandLine();
            }
            try {
                String resolvedCommand = ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(buildCmd, EMPTY_STRING, " ", 1, new FileContextData(null, null, null, tool));
                resolvedCommand = resolvedCommand.trim();
                if (resolvedCommand.length() > 0) {
                    buildCmd = resolvedCommand;
                }
            }
            catch (BuildMacroException buildMacroException) {}
            buffer.append("\t@echo " + buildCmd + IManagedBuilderMakefileGenerator.NEWLINE);
            buffer.append("\t@" + buildCmd);
            buffer.append(IManagedBuilderMakefileGenerator.NEWLINE);
            if (bTargetTool) {
                buffer.append("\t@echo '" + MESSAGE_FINISH_BUILD + " " + "$@" + "'" + IManagedBuilderMakefileGenerator.NEWLINE);
            } else {
                buffer.append("\t@echo '" + MESSAGE_FINISH_FILE + " " + "$@" + "'" + IManagedBuilderMakefileGenerator.NEWLINE);
            }
            buffer.append("\t@echo ' '" + IManagedBuilderMakefileGenerator.NEWLINE);
            if (bEmitPostBuildStepCall) {
                buffer.append("\t$(MAKE) --no-print-directory post-build" + IManagedBuilderMakefileGenerator.NEWLINE + IManagedBuilderMakefileGenerator.NEWLINE);
            } else {
                buffer.append(IManagedBuilderMakefileGenerator.NEWLINE);
            }
        }
        if (enumeratedSecondaryOutputs.size() > 0) {
            String primaryOutput = (String)enumeratedPrimaryOutputs.get(0);
            int i2 = 0;
            while (i2 < enumeratedSecondaryOutputs.size()) {
                String output = (String)enumeratedSecondaryOutputs.get(0);
                String depLine = String.valueOf(output) + ":" + " " + primaryOutput + IManagedBuilderMakefileGenerator.NEWLINE;
                if (!this.getDepLineList().contains(depLine)) {
                    this.getDepLineList().add(depLine);
                    buffer.append(depLine);
                }
                ++i2;
            }
            buffer.append(IManagedBuilderMakefileGenerator.NEWLINE);
        }
        return true;
    }

    private void generateRulesForConsumers(ITool generatingTool, List outputVarsAdditionsList, StringBuffer buffer) {
        IOutputType[] outTypes = generatingTool.getOutputTypes();
        int i = 0;
        while (i < outTypes.length) {
            String[] outExts = outTypes[i].getOutputExtensions(generatingTool);
            String outVariable = outTypes[i].getBuildVariable();
            if (outExts != null) {
                int j = 0;
                while (j < outExts.length) {
                    int k = 0;
                    while (k < this.buildTools.length) {
                        IInputType inType;
                        ITool tool = this.buildTools[k];
                        if (!this.buildToolsUsed[k] && (inType = tool.getInputType(outExts[j])) != null) {
                            String inVariable = inType.getBuildVariable();
                            if ((outVariable == null && inVariable == null || outVariable != null && inVariable != null && outVariable.equals(inVariable)) && this.addRuleForTool(this.buildTools[k], buffer, false, null, null, outputVarsAdditionsList, null, false)) {
                                this.buildToolsUsed[k] = true;
                                this.generateRulesForConsumers(this.buildTools[k], outputVarsAdditionsList, buffer);
                            }
                        }
                        ++k;
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    protected boolean getToolInputsOutputs(ITool tool, Vector inputs, Vector dependencies, Vector outputs, Vector enumeratedPrimaryOutputs, Vector enumeratedSecondaryOutputs, Vector outputVariables, boolean bTargetTool, Vector managedProjectOutputs) {
        IManagedBuildGnuToolInfo toolInfo = null;
        int i = 0;
        while (i < this.buildTools.length) {
            if (tool == this.buildTools[i]) {
                toolInfo = this.gnuToolInfos[i];
                break;
            }
            ++i;
        }
        if (toolInfo == null) {
            return false;
        }
        inputs.addAll(toolInfo.getCommandInputs());
        outputs.addAll(toolInfo.getCommandOutputs());
        enumeratedPrimaryOutputs.addAll(toolInfo.getEnumeratedPrimaryOutputs());
        enumeratedSecondaryOutputs.addAll(toolInfo.getEnumeratedSecondaryOutputs());
        outputVariables.addAll(toolInfo.getOutputVariables());
        dependencies.addAll(toolInfo.getCommandDependencies());
        if (bTargetTool && managedProjectOutputs != null) {
            ListIterator refIter = managedProjectOutputs.listIterator();
            while (refIter.hasNext()) {
                dependencies.add((String)refIter.next());
            }
        }
        return true;
    }

    protected Vector calculateSecondaryOutputs(IOutputType[] secondaryOutputs) {
        Vector<String> buildVars = new Vector<String>();
        int i = 0;
        while (i < this.buildTools.length) {
            IOutputType[] outTypes = this.buildTools[i].getOutputTypes();
            if (outTypes != null && outTypes.length > 0) {
                int j = 0;
                while (j < outTypes.length) {
                    IOutputType outType = outTypes[j];
                    int k = 0;
                    block2: while (k < secondaryOutputs.length) {
                        IOutputType matchType = outType;
                        do {
                            if (!matchType.getId().equals(secondaryOutputs[k].getId())) continue;
                            buildVars.add(outType.getBuildVariable());
                            break block2;
                        } while ((matchType = matchType.getSuperClass()) != null);
                        ++k;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return buildVars;
    }

    protected boolean isSecondaryOutputVar(IOutputType[] secondaryOutputs, String varName) {
        int i = 0;
        while (i < this.buildTools.length) {
            IOutputType[] outTypes = this.buildTools[i].getOutputTypes();
            if (outTypes != null && outTypes.length > 0) {
                int j = 0;
                while (j < outTypes.length) {
                    IOutputType outType = outTypes[j];
                    int k = 0;
                    while (k < secondaryOutputs.length) {
                        IOutputType matchType = outType;
                        do {
                            if (!matchType.getId().equals(secondaryOutputs[k].getId()) || !outType.getBuildVariable().equals(varName)) continue;
                            return true;
                        } while ((matchType = matchType.getSuperClass()) != null);
                        ++k;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return false;
    }

    private StringBuffer addSubdirectories() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("# " + ManagedMakeMessages.getResourceString(MOD_LIST) + IManagedBuilderMakefileGenerator.NEWLINE);
        buffer.append("SUBDIRS := \\\n");
        ListIterator iter = this.getSubdirList().listIterator();
        while (iter.hasNext()) {
            IContainer container = (IContainer)iter.next();
            this.updateMonitor(ManagedMakeMessages.getFormattedString("MakefileGenerator.message.adding.source.folder", container.getFullPath().toString()));
            if (container.getFullPath() == this.project.getFullPath()) {
                buffer.append(". \\\n");
                continue;
            }
            IPath path = container.getProjectRelativePath();
            buffer.append(String.valueOf(path.toString()) + " " + "\\\n");
        }
        buffer.append(IManagedBuilderMakefileGenerator.NEWLINE);
        return buffer;
    }

    protected StringBuffer addFragmentMakefileHeader() {
        return this.addDefaultHeader();
    }

    protected StringBuffer addSources(IContainer module) throws CoreException {
        String macroName;
        Map.Entry entry;
        IPath moduleRelativePath = module.getProjectRelativePath();
        String relativePath = moduleRelativePath.toString();
        relativePath = String.valueOf(relativePath) + (relativePath.length() == 0 ? "" : "/");
        relativePath = this.escapeWhitespaces(relativePath);
        LinkedHashMap buildVarToRuleStringMap = new LinkedHashMap();
        Iterator iterator = this.buildSrcVars.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            macroName = (String)entry.getKey();
            this.addMacroAdditionPrefix(buildVarToRuleStringMap, macroName, null, false);
        }
        iterator = this.buildOutVars.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            macroName = (String)entry.getKey();
            this.addMacroAdditionPrefix(buildVarToRuleStringMap, macroName, "./" + relativePath, false);
        }
        this.addMacroAdditionPrefix(buildVarToRuleStringMap, DEPS_MACRO, "./" + relativePath, true);
        StringBuffer buffer = new StringBuffer();
        StringBuffer ruleBuffer = new StringBuffer("# " + ManagedMakeMessages.getResourceString(MOD_RULES) + IManagedBuilderMakefileGenerator.NEWLINE);
        IResource[] resources = module.members();
        IFolder folder = this.project.getFolder(this.info.getConfigurationName());
        int i = 0;
        while (i < resources.length) {
            IResourceConfiguration resConfig;
            IResource resource = resources[i];
            if (!(resource.getType() != 1 || (resConfig = this.config.getResourceConfiguration(resource.getFullPath().toString())) != null && resConfig.isExcluded())) {
                this.addFragmentMakefileEntriesForSource(buildVarToRuleStringMap, ruleBuffer, folder, relativePath, resource, resource.getLocation(), resConfig, null, false);
            }
            ++i;
        }
        buffer.append(this.writeAdditionMacros(buildVarToRuleStringMap));
        return buffer.append(ruleBuffer + IManagedBuilderMakefileGenerator.NEWLINE);
    }

    protected void addFragmentMakefileEntriesForSource(LinkedHashMap buildVarToRuleStringMap, StringBuffer ruleBuffer, IFolder folder, String relativePath, IResource resource, IPath sourceLocation, IResourceConfiguration resConfig, String varName, boolean generatedSource) {
        ITool[] tools;
        String ext = sourceLocation.getFileExtension();
        ITool tool = null;
        if (resConfig != null && (tools = resConfig.getToolsToInvoke()) != null && tools.length > 0) {
            tool = tools[0];
        }
        int j = 0;
        while (j < this.buildTools.length) {
            if (this.buildTools[j].buildsFileType(ext)) {
                if (tool == null) {
                    tool = this.buildTools[j];
                }
                this.addToBuildVar(buildVarToRuleStringMap, ext, varName, relativePath, sourceLocation, generatedSource);
                break;
            }
            ++j;
        }
        if (tool != null) {
            IInputType primaryInputType = tool.getPrimaryInputType();
            IInputType inputType = tool.getInputType(ext);
            if (primaryInputType != null && !primaryInputType.getMultipleOfType() || inputType == null && tool != this.info.getToolFromOutputExtension(this.buildTargetExt)) {
                StringBuffer generatedDepFile = new StringBuffer();
                Vector generatedOutputs = new Vector();
                this.addRuleForSource(relativePath, ruleBuffer, resource, sourceLocation, resConfig, generatedSource, generatedDepFile, generatedOutputs);
                if (generatedDepFile.length() > 0) {
                    this.addMacroAdditionFile(buildVarToRuleStringMap, DEPS_MACRO, generatedDepFile.toString());
                }
                IOutputType outType = tool.getPrimaryOutputType();
                String buildVariable = null;
                if (outType != null) {
                    if (tool.getCustomBuildStep()) {
                        if (generatedOutputs.size() > 0) {
                            IPath firstOutput = (IPath)generatedOutputs.get(0);
                            String firstExt = firstOutput.getFileExtension();
                            int j2 = 0;
                            while (j2 < this.buildTools.length) {
                                String bV;
                                if (this.buildTools[j2].buildsFileType(firstExt) && (bV = this.buildTools[j2].getPrimaryInputType().getBuildVariable()).length() > 0) {
                                    buildVariable = bV;
                                    break;
                                }
                                ++j2;
                            }
                        }
                    } else {
                        buildVariable = outType.getBuildVariable();
                    }
                } else {
                    buildVariable = OBJS_MACRO;
                }
                int k = 0;
                while (k < generatedOutputs.size()) {
                    IPath generatedOutput = ((IPath)generatedOutputs.get(k)).isAbsolute() ? (IPath)generatedOutputs.get(k) : this.project.getLocation().append(this.getBuildWorkingDir()).append((IPath)generatedOutputs.get(k));
                    IFile generateOutputResource = this.project.getFile(generatedOutput);
                    this.addFragmentMakefileEntriesForSource(buildVarToRuleStringMap, ruleBuffer, folder, relativePath, (IResource)generateOutputResource, generatedOutput, null, buildVariable, true);
                    ++k;
                }
            }
        } else if (varName == null) {
            j = 0;
            while (j < this.buildTools.length) {
                if (this.buildTools[j].isInputFileType(ext)) {
                    this.addToBuildVar(buildVarToRuleStringMap, ext, varName, relativePath, sourceLocation, generatedSource);
                    break;
                }
                ++j;
            }
        } else {
            IOutputType[] secondaryOutputs = this.config.getToolChain().getSecondaryOutputs();
            if (secondaryOutputs.length > 0 && this.isSecondaryOutputVar(secondaryOutputs, varName)) {
                this.addMacroAdditionFile(buildVarToRuleStringMap, varName, relativePath, sourceLocation, generatedSource);
            }
        }
    }

    protected void addToBuildVar(LinkedHashMap buildVarToRuleStringMap, String ext, String varName, String relativePath, IPath sourceLocation, boolean generatedSource) {
        List varList = null;
        if (varName == null) {
            varName = this.getSourceMacroName(ext).toString();
            varList = (List)this.buildSrcVars.get(varName);
        } else {
            varList = (List)this.buildOutVars.get(varName);
        }
        if (varList != null && !varList.contains(sourceLocation)) {
            varList.add(sourceLocation);
            if (buildVarToRuleStringMap.containsKey(varName)) {
                this.addMacroAdditionFile(buildVarToRuleStringMap, varName, relativePath, sourceLocation, generatedSource);
            }
        }
    }

    protected void addRuleForSource(String relativePath, StringBuffer buffer, IResource resource, IPath sourceLocation, IResourceConfiguration resConfig, boolean generatedSource, StringBuffer generatedDepFile, Vector enumeratedOutputs) {
        String depLine;
        Vector addlDepsVector;
        int i;
        IManagedDependencyGenerator depGen;
        boolean doDepGen;
        ITool[] tools;
        String fileName = sourceLocation.removeFileExtension().lastSegment();
        String inputExtension = sourceLocation.getFileExtension();
        String outputExtension = this.info.getOutputExtension(inputExtension);
        ITool tool = null;
        if (resConfig != null && (tools = resConfig.getToolsToInvoke()) != null && tools.length > 0) {
            tool = tools[0];
        }
        if (tool == null) {
            tool = this.info.getToolFromInputExtension(inputExtension);
        }
        boolean bl = doDepGen = (depGen = tool.getDependencyGeneratorForExtension(inputExtension)) != null && depGen.getCalculatorType() == 1;
        if (doDepGen) {
            String depFile = String.valueOf(relativePath) + fileName + "." + "d";
            this.getDependencyMakefiles().add(depFile);
            generatedDepFile.append(String.valueOf(fileName) + "." + "d");
        }
        String OptDotExt = EMPTY_STRING;
        if (outputExtension != null && outputExtension.length() > 0) {
            OptDotExt = "." + outputExtension;
        }
        Vector ruleOutputs = new Vector();
        Vector enumeratedPrimaryOutputs = new Vector();
        Vector enumeratedSecondaryOutputs = new Vector();
        this.calculateOutputsForSource(tool, relativePath, resource, sourceLocation, ruleOutputs, enumeratedPrimaryOutputs, enumeratedSecondaryOutputs);
        enumeratedOutputs.addAll(enumeratedPrimaryOutputs);
        enumeratedOutputs.addAll(enumeratedSecondaryOutputs);
        String primaryOutputName = null;
        primaryOutputName = enumeratedPrimaryOutputs.size() > 0 ? ((IPath)enumeratedPrimaryOutputs.get(0)).toString() : String.valueOf(relativePath) + fileName + OptDotExt;
        String otherPrimaryOutputs = EMPTY_STRING;
        int i2 = 1;
        while (i2 < enumeratedPrimaryOutputs.size()) {
            otherPrimaryOutputs = String.valueOf(otherPrimaryOutputs) + " " + ((IPath)enumeratedPrimaryOutputs.get(i2)).toString();
            ++i2;
        }
        String projectLocation = this.project.getLocation().toString();
        IPath outputLocation = Path.fromOSString((String)primaryOutputName);
        if (!outputLocation.isAbsolute()) {
            outputLocation = this.project.getLocation().append(this.getBuildWorkingDir()).append(primaryOutputName);
        }
        boolean fileExplicitMacrosReferenced = MacroResolver.getReferencedExplitFileMacros(tool).length > 0 || MacroResolver.getReferencedExplitFileMacros(tool.getToolCommand(), 1, new FileContextData(sourceLocation, outputLocation, null, tool)).length > 0;
        String cmd = tool.getToolCommand();
        try {
            String resolvedCommand = ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(cmd, EMPTY_STRING, " ", 1, new FileContextData(sourceLocation, outputLocation, null, tool));
            resolvedCommand = resolvedCommand.trim();
            if (resolvedCommand.length() > 0) {
                cmd = resolvedCommand;
            }
        }
        catch (BuildMacroException buildMacroException) {}
        String defaultOutputName = EMPTY_STRING;
        String primaryDependencyName = EMPTY_STRING;
        String home = generatedSource ? "." : "$(ROOT)";
        String resourcePath = null;
        boolean patternRule = true;
        if (!sourceLocation.toString().startsWith(projectLocation)) {
            resourcePath = sourceLocation.toString();
            defaultOutputName = String.valueOf(relativePath) + fileName + OptDotExt;
            primaryDependencyName = resourcePath;
            patternRule = false;
        } else {
            resourcePath = relativePath;
            if (resConfig != null || fileExplicitMacrosReferenced) {
                defaultOutputName = String.valueOf(resourcePath) + fileName + OptDotExt;
                primaryDependencyName = String.valueOf(home) + "/" + resourcePath + fileName + "." + inputExtension;
                patternRule = false;
            } else {
                defaultOutputName = String.valueOf(relativePath) + "%" + OptDotExt;
                primaryDependencyName = String.valueOf(home) + "/" + resourcePath + "%" + "." + inputExtension;
            }
        }
        if (patternRule) {
            patternRule = false;
            int i3 = 0;
            while (i3 < ruleOutputs.size()) {
                String ruleOutput = ((IPath)ruleOutputs.get(i3)).toString();
                if (ruleOutput.indexOf(37) >= 0) {
                    patternRule = true;
                    break;
                }
                ++i3;
            }
            if (!patternRule) {
                primaryDependencyName = String.valueOf(home) + "/" + resourcePath + fileName + "." + inputExtension;
            }
        }
        String buildRule = EMPTY_STRING;
        if (patternRule) {
            if (ruleOutputs.size() == 0) {
                buildRule = defaultOutputName;
            } else {
                boolean first = true;
                i = 0;
                while (i < ruleOutputs.size()) {
                    String ruleOutput = ((IPath)ruleOutputs.get(i)).toString();
                    if (ruleOutput.indexOf(37) >= 0) {
                        if (first) {
                            first = false;
                        } else {
                            buildRule = String.valueOf(buildRule) + " ";
                        }
                        buildRule = String.valueOf(buildRule) + ruleOutput;
                    }
                    ++i;
                }
            }
        } else {
            buildRule = String.valueOf(buildRule) + primaryOutputName;
        }
        buildRule = String.valueOf(buildRule) + ": " + primaryDependencyName;
        IPath[] addlDepPaths = tool.getAdditionalDependencies();
        i = 0;
        while (i < addlDepPaths.length) {
            IPath tempPath;
            IPath addlPath = addlDepPaths[i];
            if (!addlPath.toString().startsWith("$(") && !addlPath.isAbsolute() && (tempPath = this.project.getLocation().append(addlPath)) != null) {
                addlPath = ManagedBuildManager.calculateRelativePath(this.getTopBuildDir(), tempPath);
            }
            buildRule = String.valueOf(buildRule) + " " + addlPath.toString();
            ++i;
        }
        if (!this.getRuleList().contains(buildRule)) {
            String resolvedCommand;
            String buildCmd;
            IPath tempPath;
            IPath addlPath;
            IPath[] addlInputPaths;
            this.getRuleList().add(buildRule);
            buffer.append(String.valueOf(buildRule) + IManagedBuilderMakefileGenerator.NEWLINE);
            buffer.append("\t@echo '" + MESSAGE_START_FILE + " " + "$<" + "'" + IManagedBuilderMakefileGenerator.NEWLINE);
            IManagedCommandLineInfo cmdLInfo = null;
            Vector<String> inputs = new Vector<String>();
            inputs.add("$<");
            String outflag = null;
            String outputPrefix = null;
            if (resConfig != null || fileExplicitMacrosReferenced) {
                buffer.append("\t@echo '" + tool.getAnnouncement() + "'" + IManagedBuilderMakefileGenerator.NEWLINE);
                outflag = tool.getOutputFlag();
                outputPrefix = tool.getOutputPrefix();
                addlInputPaths = this.getAdditionalResourcesForSource(tool);
                int i4 = 0;
                while (i4 < addlInputPaths.length) {
                    addlPath = addlInputPaths[i4];
                    if (!addlPath.toString().startsWith("$(") && !addlPath.isAbsolute() && (tempPath = this.project.getLocation().append(addlPath)) != null) {
                        addlPath = ManagedBuildManager.calculateRelativePath(this.getTopBuildDir(), tempPath);
                    }
                    inputs.add(addlPath.toString());
                    ++i4;
                }
                String[] flags = null;
                try {
                    flags = tool.getToolCommandFlags(sourceLocation, outputLocation);
                }
                catch (BuildException buildException) {
                    flags = EMPTY_STRING_ARRAY;
                }
                IManagedCommandLineGenerator cmdLGen = tool.getCommandLineGenerator();
                cmdLInfo = cmdLGen.generateCommandLineInfo(tool, cmd, flags, outflag, outputPrefix, "$@" + otherPrimaryOutputs, inputs.toArray(new String[inputs.size()]), tool.getCommandLinePattern());
                buildCmd = cmdLInfo.getCommandLine();
                try {
                    resolvedCommand = ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(buildCmd, EMPTY_STRING, " ", 1, new FileContextData(sourceLocation, outputLocation, null, tool));
                    resolvedCommand = resolvedCommand.trim();
                    if (resolvedCommand.length() > 0) {
                        buildCmd = resolvedCommand;
                    }
                }
                catch (BuildMacroException buildMacroException) {}
                buffer.append("\t@echo " + buildCmd + IManagedBuilderMakefileGenerator.NEWLINE);
                buffer.append("\t@" + buildCmd);
            } else {
                buffer.append("\t@echo '" + tool.getAnnouncement() + "'" + IManagedBuilderMakefileGenerator.NEWLINE);
                outflag = this.info.getOutputFlag(outputExtension);
                outputPrefix = this.info.getOutputPrefix(outputExtension);
                addlInputPaths = this.getAdditionalResourcesForSource(tool);
                int i5 = 0;
                while (i5 < addlInputPaths.length) {
                    addlPath = addlInputPaths[i5];
                    if (!addlPath.toString().startsWith("$(") && !addlPath.isAbsolute() && (tempPath = this.project.getLocation().append(addlPath)) != null) {
                        addlPath = ManagedBuildManager.calculateRelativePath(this.getTopBuildDir(), tempPath);
                    }
                    inputs.add(addlPath.toString());
                    ++i5;
                }
                String buildFlags = EMPTY_STRING;
                try {
                    buildFlags = tool.getToolCommandFlagsString(sourceLocation, outputLocation);
                }
                catch (BuildException buildException) {}
                String[] flags = buildFlags.split("\\s");
                cmdLInfo = this.info.generateToolCommandLineInfo(inputExtension, flags, outflag, outputPrefix, "$@" + otherPrimaryOutputs, inputs.toArray(new String[inputs.size()]), sourceLocation, outputLocation);
                buildCmd = null;
                buildCmd = cmdLInfo == null ? String.valueOf(cmd) + " " + buildFlags + " " + outflag + " " + outputPrefix + "$@" + otherPrimaryOutputs + " " + "$<" : cmdLInfo.getCommandLine();
                try {
                    resolvedCommand = ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(buildCmd, EMPTY_STRING, " ", 1, new FileContextData(sourceLocation, outputLocation, null, tool));
                    resolvedCommand = resolvedCommand.trim();
                    if (resolvedCommand.length() > 0) {
                        buildCmd = resolvedCommand;
                    }
                }
                catch (BuildMacroException buildMacroException) {}
                buffer.append("\t@echo " + buildCmd + IManagedBuilderMakefileGenerator.NEWLINE);
                buffer.append("\t@" + buildCmd);
            }
            if (doDepGen && depGen.getCalculatorType() == 1) {
                buffer.append(" && \\\n");
                String depCmd = depGen.getDependencyCommand(resource, this.info);
                try {
                    depCmd = ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(depCmd, EMPTY_STRING, " ", 1, new FileContextData(sourceLocation, outputLocation, null, tool));
                }
                catch (BuildMacroException buildMacroException) {}
                buffer.append(depCmd);
            }
            buffer.append(IManagedBuilderMakefileGenerator.NEWLINE);
            buffer.append("\t@echo '" + MESSAGE_FINISH_FILE + " " + "$<" + "'" + IManagedBuilderMakefileGenerator.NEWLINE);
            buffer.append("\t@echo ' '" + IManagedBuilderMakefileGenerator.NEWLINE + IManagedBuilderMakefileGenerator.NEWLINE);
        }
        String calculatedDependencies = null;
        boolean addedDepLines = false;
        if (depGen != null && depGen.getCalculatorType() != 1 && (addlDepsVector = this.calculateDependenciesForSource(depGen, tool, relativePath, resource)) != null && addlDepsVector.size() > 0) {
            calculatedDependencies = new String();
            int i6 = 0;
            while (i6 < addlDepsVector.size()) {
                calculatedDependencies = String.valueOf(calculatedDependencies) + " " + addlDepsVector.get(i6).toString();
                ++i6;
            }
        }
        if (calculatedDependencies != null) {
            depLine = String.valueOf(primaryOutputName) + ":" + calculatedDependencies + IManagedBuilderMakefileGenerator.NEWLINE;
            if (!this.getDepLineList().contains(depLine)) {
                this.getDepLineList().add(depLine);
                addedDepLines = true;
                buffer.append(depLine);
            }
        }
        int i7 = 1;
        while (i7 < enumeratedPrimaryOutputs.size()) {
            depLine = String.valueOf(((IPath)enumeratedPrimaryOutputs.get(i7)).toString()) + ":" + " " + primaryOutputName;
            if (calculatedDependencies != null) {
                depLine = String.valueOf(depLine) + calculatedDependencies;
            }
            depLine = String.valueOf(depLine) + IManagedBuilderMakefileGenerator.NEWLINE;
            if (!this.getDepLineList().contains(depLine)) {
                this.getDepLineList().add(depLine);
                addedDepLines = true;
                buffer.append(depLine);
            }
            ++i7;
        }
        i7 = 0;
        while (i7 < enumeratedSecondaryOutputs.size()) {
            depLine = String.valueOf(((IPath)enumeratedSecondaryOutputs.get(i7)).toString()) + ":" + " " + primaryOutputName;
            if (calculatedDependencies != null) {
                depLine = String.valueOf(depLine) + calculatedDependencies;
            }
            depLine = String.valueOf(depLine) + IManagedBuilderMakefileGenerator.NEWLINE;
            if (!this.getDepLineList().contains(depLine)) {
                this.getDepLineList().add(depLine);
                addedDepLines = true;
                buffer.append(depLine);
            }
            ++i7;
        }
        if (addedDepLines) {
            buffer.append(IManagedBuilderMakefileGenerator.NEWLINE);
        }
    }

    protected IPath[] getAdditionalResourcesForSource(ITool tool) {
        ArrayList<IPath> allRes = new ArrayList<IPath>();
        IInputType[] types = tool.getInputTypes();
        int i = 0;
        while (i < types.length) {
            IInputType type = types[i];
            IPath[] res = type.getAdditionalResources();
            int j = 0;
            while (j < res.length) {
                allRes.add(res[j]);
                ++j;
            }
            if (type != tool.getPrimaryInputType()) {
                String var = type.getBuildVariable();
                if (var != null && var.length() > 0) {
                    allRes.add(Path.fromOSString((String)("$(" + type.getBuildVariable() + ")")));
                } else {
                    String[] typeExts = type.getSourceExtensions(tool);
                    int j2 = 0;
                    while (j2 < this.projectResources.length) {
                        if (this.projectResources[j2].getType() == 1) {
                            String fileExt = this.projectResources[j2].getFileExtension();
                            if (fileExt == null) {
                                fileExt = "";
                            }
                            int k = 0;
                            while (k < typeExts.length) {
                                if (fileExt.equals(typeExts[k])) {
                                    allRes.add(this.projectResources[j2].getProjectRelativePath());
                                    break;
                                }
                                ++k;
                            }
                        }
                        ++j2;
                    }
                }
                IOption assignToOption = tool.getOptionBySuperClassId(type.getAssignToOptionId());
                IOption option = tool.getOptionBySuperClassId(type.getOptionId());
                if (assignToOption != null && option == null) {
                    try {
                        int optType = assignToOption.getValueType();
                        IBuildObject toolParent = tool.getParent();
                        if (toolParent != null) {
                            if (optType == 2) {
                                String optVal = "";
                                int j3 = 0;
                                while (j3 < allRes.size()) {
                                    IPath addlPath;
                                    IFile addlResource;
                                    String resPath;
                                    if (j3 != 0) {
                                        optVal = String.valueOf(optVal) + " ";
                                    }
                                    if (!(resPath = allRes.get(j3).toString()).startsWith("$(") && (addlResource = this.project.getFile(resPath)) != null && (addlPath = addlResource.getLocation()) != null) {
                                        resPath = ManagedBuildManager.calculateRelativePath(this.getTopBuildDir(), addlPath).toString();
                                    }
                                    optVal = String.valueOf(optVal) + ManagedBuildManager.calculateRelativePath(this.getTopBuildDir(), Path.fromOSString((String)resPath)).toString();
                                    ++j3;
                                }
                                if (toolParent instanceof IToolChain) {
                                    IConfiguration config = ((IToolChain)toolParent).getParent();
                                    if (config != null) {
                                        ManagedBuildManager.setOption(config, (IHoldsOptions)tool, assignToOption, optVal);
                                    }
                                } else if (toolParent instanceof IResourceConfiguration) {
                                    ManagedBuildManager.setOption((IResourceConfiguration)toolParent, (IHoldsOptions)tool, assignToOption, optVal);
                                }
                            } else if (optType == 3 || optType == 6 || optType == 7) {
                                String[] paths = new String[allRes.size()];
                                int j4 = 0;
                                while (j4 < allRes.size()) {
                                    IPath addlPath;
                                    IFile addlResource;
                                    paths[j4] = allRes.get(j4).toString();
                                    if (!paths[j4].startsWith("$(") && (addlResource = this.project.getFile(paths[j4])) != null && (addlPath = addlResource.getLocation()) != null) {
                                        paths[j4] = ManagedBuildManager.calculateRelativePath(this.getTopBuildDir(), addlPath).toString();
                                    }
                                    ++j4;
                                }
                                if (toolParent instanceof IToolChain) {
                                    IConfiguration config = ((IToolChain)toolParent).getParent();
                                    if (config != null) {
                                        ManagedBuildManager.setOption(config, (IHoldsOptions)tool, assignToOption, paths);
                                    }
                                } else if (toolParent instanceof IResourceConfiguration) {
                                    ManagedBuildManager.setOption((IResourceConfiguration)toolParent, (IHoldsOptions)tool, assignToOption, paths);
                                }
                            } else if (optType == 0) {
                                boolean b = false;
                                if (allRes.size() > 0) {
                                    b = true;
                                }
                                if (toolParent instanceof IToolChain) {
                                    IConfiguration config = ((IToolChain)toolParent).getParent();
                                    if (config != null) {
                                        ManagedBuildManager.setOption(config, (IHoldsOptions)tool, assignToOption, b);
                                    }
                                } else if (toolParent instanceof IResourceConfiguration) {
                                    ManagedBuildManager.setOption((IResourceConfiguration)toolParent, (IHoldsOptions)tool, assignToOption, b);
                                }
                            } else if (optType == 1 && allRes.size() > 0) {
                                String s = allRes.get(0).toString();
                                if (toolParent instanceof IToolChain) {
                                    IConfiguration config = ((IToolChain)toolParent).getParent();
                                    if (config != null) {
                                        ManagedBuildManager.setOption(config, (IHoldsOptions)tool, assignToOption, s);
                                    }
                                } else if (toolParent instanceof IResourceConfiguration) {
                                    ManagedBuildManager.setOption((IResourceConfiguration)toolParent, (IHoldsOptions)tool, assignToOption, s);
                                }
                            }
                            allRes.clear();
                        }
                    }
                    catch (BuildException buildException) {}
                }
            }
            ++i;
        }
        return allRes.toArray(new IPath[allRes.size()]);
    }

    protected void calculateOutputsForSource(ITool tool, String relativePath, IResource resource, IPath sourceLocation, Vector ruleOutputs, Vector enumeratedPrimaryOutputs, Vector enumeratedSecondaryOutputs) {
        String inExt = sourceLocation.getFileExtension();
        String outExt = tool.getOutputExtension(inExt);
        IOutputType[] outTypes = tool.getOutputTypes();
        if (outTypes != null && outTypes.length > 0) {
            int i = 0;
            while (i < outTypes.length) {
                IOutputType type = outTypes[i];
                boolean primaryOutput = type == tool.getPrimaryOutputType();
                String outputPrefix = type.getOutputPrefix();
                IBuildObject toolParent = tool.getParent();
                IConfiguration config = null;
                if (toolParent instanceof IConfiguration) {
                    config = (IConfiguration)toolParent;
                } else if (toolParent instanceof IToolChain) {
                    config = ((IToolChain)toolParent).getParent();
                } else if (toolParent instanceof IResourceConfiguration) {
                    config = ((IResourceConfiguration)toolParent).getParent();
                } else {
                    throw new AssertionError((Object)"tool parent must be one of configuration, toolchain, or resource configuration");
                }
                if (config != null) {
                    try {
                        outputPrefix = ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(outputPrefix, "", " ", 3, config);
                    }
                    catch (BuildMacroException buildMacroException) {}
                }
                boolean multOfType = type.getMultipleOfType();
                IOption option = tool.getOptionBySuperClassId(type.getOptionId());
                IManagedOutputNameProvider nameProvider = type.getNameProvider();
                String[] outputNames = type.getOutputNames();
                if (option != null) {
                    try {
                        int j;
                        List<String> outputList = new ArrayList<String>();
                        int optType = option.getValueType();
                        if (optType == 2) {
                            outputList.add(String.valueOf(outputPrefix) + option.getStringValue());
                        } else if (optType == 3 || optType == 6 || optType == 7) {
                            outputList = (List)option.getValue();
                            if (outputPrefix.length() > 0) {
                                j = 0;
                                while (j < outputList.size()) {
                                    outputList.set(j, String.valueOf(outputPrefix) + outputList.get(j));
                                    ++j;
                                }
                            }
                        }
                        j = 0;
                        while (j < outputList.size()) {
                            IPath outPath;
                            String outputName = (String)outputList.get(j);
                            try {
                                String resolved = ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(outputName, "", " ", 1, new FileContextData(sourceLocation, null, option, tool));
                                resolved = resolved.trim();
                                if (resolved.length() > 0) {
                                    outputName = resolved;
                                }
                            }
                            catch (BuildMacroException buildMacroException) {}
                            if ((outPath = Path.fromOSString((String)outputName)).segmentCount() == 1) {
                                outPath = Path.fromOSString((String)(String.valueOf(relativePath) + (String)outputList.get(j)));
                            }
                            if (primaryOutput) {
                                ruleOutputs.add(j, outPath);
                                enumeratedPrimaryOutputs.add(j, this.resolvePercent(outPath, sourceLocation));
                            } else {
                                ruleOutputs.add(outPath);
                                enumeratedSecondaryOutputs.add(this.resolvePercent(outPath, sourceLocation));
                            }
                            ++j;
                        }
                    }
                    catch (BuildException buildException) {}
                } else if (nameProvider != null) {
                    IPath[] inPaths = new IPath[]{sourceLocation};
                    IPath[] outPaths = nameProvider.getOutputNames(tool, inPaths);
                    int j = 0;
                    while (j < outPaths.length) {
                        IPath outPath = outPaths[j];
                        String outputName = outPaths[j].toString();
                        try {
                            String resolved = ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(outputName, "", " ", 1, new FileContextData(sourceLocation, null, option, tool));
                            resolved = resolved.trim();
                            if (resolved.length() > 0) {
                                outPath = Path.fromOSString((String)resolved);
                            }
                        }
                        catch (BuildMacroException buildMacroException) {}
                        if (outPath.segmentCount() == 1) {
                            outPath = Path.fromOSString((String)(String.valueOf(relativePath) + outPath.toString()));
                        }
                        if (primaryOutput) {
                            ruleOutputs.add(j, outPath);
                            enumeratedPrimaryOutputs.add(j, this.resolvePercent(outPath, sourceLocation));
                        } else {
                            ruleOutputs.add(outPath);
                            enumeratedSecondaryOutputs.add(this.resolvePercent(outPath, sourceLocation));
                        }
                        ++j;
                    }
                } else if (outputNames != null) {
                    int j = 0;
                    while (j < outputNames.length) {
                        IPath outPath;
                        String outputName = outputNames[j];
                        try {
                            String resolved = ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(outputName, "", " ", 1, new FileContextData(sourceLocation, null, option, tool));
                            resolved = resolved.trim();
                            if (resolved.length() > 0) {
                                outputName = resolved;
                            }
                        }
                        catch (BuildMacroException buildMacroException) {}
                        if ((outPath = Path.fromOSString((String)outputName)).segmentCount() == 1) {
                            outPath = Path.fromOSString((String)(String.valueOf(relativePath) + outPath.toString()));
                        }
                        if (primaryOutput) {
                            ruleOutputs.add(j, outPath);
                            enumeratedPrimaryOutputs.add(j, this.resolvePercent(outPath, sourceLocation));
                        } else {
                            ruleOutputs.add(outPath);
                            enumeratedSecondaryOutputs.add(this.resolvePercent(outPath, sourceLocation));
                        }
                        ++j;
                    }
                } else if (!multOfType) {
                    String namePattern = type.getNamePattern();
                    IPath namePatternPath = null;
                    if (namePattern == null || namePattern.length() == 0) {
                        namePattern = String.valueOf(relativePath) + outputPrefix + "%";
                        if (outExt != null && outExt.length() > 0) {
                            namePattern = String.valueOf(namePattern) + "." + outExt;
                        }
                        namePatternPath = Path.fromOSString((String)namePattern);
                    } else {
                        if (outputPrefix.length() > 0) {
                            namePattern = String.valueOf(outputPrefix) + namePattern;
                        }
                        if ((namePatternPath = Path.fromOSString((String)namePattern)).segmentCount() == 1) {
                            namePatternPath = Path.fromOSString((String)(String.valueOf(relativePath) + namePatternPath.toString()));
                        }
                    }
                    if (primaryOutput) {
                        ruleOutputs.add(0, namePatternPath);
                        enumeratedPrimaryOutputs.add(0, this.resolvePercent(namePatternPath, sourceLocation));
                    } else {
                        ruleOutputs.add(namePatternPath);
                        enumeratedSecondaryOutputs.add(this.resolvePercent(namePatternPath, sourceLocation));
                    }
                }
                ++i;
            }
        } else {
            String outPrefix = tool.getOutputPrefix();
            IPath outPath = Path.fromOSString((String)(String.valueOf(relativePath) + outPrefix + "%"));
            outPath = outPath.addFileExtension(outExt);
            ruleOutputs.add(0, outPath);
            enumeratedPrimaryOutputs.add(0, this.resolvePercent(outPath, sourceLocation));
        }
    }

    protected IPath resolvePercent(IPath outPath, IPath sourceLocation) {
        String fileName = sourceLocation.removeFileExtension().lastSegment();
        String outName = outPath.toOSString().replaceAll("%", fileName);
        return Path.fromOSString((String)outName);
    }

    protected Vector calculateDependenciesForSource(IManagedDependencyGenerator depGen, ITool tool, String relativePath, IResource resource) {
        Vector<IPath> deps = new Vector<IPath>();
        int type = depGen.getCalculatorType();
        switch (type) {
            case 2: 
            case 3: {
                IResource[] res = depGen.findDependencies(resource, this.project);
                if (res == null) break;
                int i = 0;
                while (i < res.length) {
                    IPath addlPath;
                    IPath dep = null;
                    if (res[i] != null && (addlPath = res[i].getLocation()) != null) {
                        dep = ManagedBuildManager.calculateRelativePath(this.getTopBuildDir(), addlPath);
                    }
                    if (dep != null) {
                        deps.add(dep);
                    }
                    ++i;
                }
                break;
            }
        }
        return deps;
    }

    public StringBuffer getSourceMacroName(String extensionName) {
        StringBuffer macroName = new StringBuffer();
        if (extensionName.equals(extensionName.toUpperCase())) {
            macroName.append(String.valueOf(extensionName.toUpperCase()) + "_UPPER");
        } else {
            macroName.append(extensionName.toUpperCase());
        }
        macroName.append("_SRCS");
        return macroName;
    }

    public Set getOutputExtensions() {
        if (this.outputExtensionsSet == null) {
            this.outputExtensionsSet = new HashSet();
            int i = 0;
            while (i < this.buildTools.length) {
                ITool tool = this.buildTools[i];
                String[] outputs = tool.getAllOutputExtensions();
                if (outputs != null) {
                    this.outputExtensionsSet.addAll(Arrays.asList(outputs));
                }
                ++i;
            }
        }
        return this.outputExtensionsSet;
    }

    protected StringBuffer addDefaultHeader() {
        StringBuffer buffer = new StringBuffer();
        this.outputCommentLine(buffer);
        buffer.append("# " + ManagedMakeMessages.getResourceString(HEADER) + IManagedBuilderMakefileGenerator.NEWLINE);
        this.outputCommentLine(buffer);
        buffer.append(IManagedBuilderMakefileGenerator.NEWLINE);
        return buffer;
    }

    protected void outputCommentLine(StringBuffer buffer) {
        int i = 0;
        while (i < 80) {
            buffer.append("#");
            ++i;
        }
        buffer.append(IManagedBuilderMakefileGenerator.NEWLINE);
    }

    protected String escapeWhitespaces(String path) {
        String[] segments = path.split("\\s");
        if (segments.length > 1) {
            StringBuffer escapedPath = new StringBuffer();
            int index = 0;
            while (index < segments.length) {
                escapedPath.append(segments[index]);
                if (index + 1 < segments.length) {
                    escapedPath.append("\\ ");
                }
                ++index;
            }
            return escapedPath.toString().trim();
        }
        return path;
    }

    protected void addMacroAdditionPrefix(LinkedHashMap map, String macroName, String relativePath, boolean addPrefix) {
        StringBuffer tempBuffer = new StringBuffer();
        tempBuffer.append(String.valueOf(macroName) + " " + MACRO_ADDITION_PREFIX_SUFFIX);
        if (addPrefix) {
            tempBuffer.append(MACRO_ADDITION_ADDPREFIX_HEADER + relativePath + MACRO_ADDITION_ADDPREFIX_SUFFIX);
        }
        map.put(macroName, tempBuffer.toString());
    }

    protected void addMacroAdditionFile(HashMap map, String macroName, String filename) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(map.get(macroName));
        buffer.append(String.valueOf(filename) + " " + "\\\n");
        map.put(macroName, buffer.toString());
    }

    protected void addMacroAdditionFile(HashMap map, String macroName, String relativePath, IPath sourceLocation, boolean generatedSource) {
        String srcName;
        IPath projectLocation;
        IPath dirLocation = projectLocation = this.project.getLocation();
        if (generatedSource) {
            dirLocation = dirLocation.append(this.getBuildWorkingDir());
        }
        if (dirLocation.isPrefixOf(sourceLocation)) {
            IPath srcPath = sourceLocation.removeFirstSegments(dirLocation.segmentCount()).setDevice(null);
            srcName = generatedSource ? "./" + srcPath.toString() : "$(ROOT)/" + srcPath.toString();
        } else {
            srcName = generatedSource && !sourceLocation.isAbsolute() ? "./" + relativePath + sourceLocation.lastSegment().toString() : sourceLocation.toString();
        }
        this.addMacroAdditionFile(map, macroName, srcName);
    }

    public void addMacroAdditionFiles(HashMap map, String macroName, Vector filenames) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(map.get(macroName));
        int i = 0;
        while (i < filenames.size()) {
            String filename = (String)filenames.get(i);
            if (filename.length() > 0) {
                buffer.append(String.valueOf(filename) + " " + "\\\n");
            }
            ++i;
        }
        map.put(macroName, buffer.toString());
    }

    protected StringBuffer writeAdditionMacros(LinkedHashMap map) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("# " + ManagedMakeMessages.getResourceString(MOD_VARS) + IManagedBuilderMakefileGenerator.NEWLINE);
        Collection bufferCollection = map.values();
        Iterator collectionIterator = bufferCollection.iterator();
        while (collectionIterator.hasNext()) {
            String macroString = collectionIterator.next().toString();
            if (macroString.endsWith(MACRO_ADDITION_PREFIX_SUFFIX) || macroString.endsWith(MACRO_ADDITION_ADDPREFIX_SUFFIX)) continue;
            StringBuffer currentBuffer = new StringBuffer();
            if (macroString.indexOf(MACRO_ADDITION_ADDPREFIX_HEADER) >= 0) {
                currentBuffer.append(String.valueOf(macroString) + "}" + IManagedBuilderMakefileGenerator.NEWLINE);
            } else {
                if (macroString.endsWith("\\\n")) {
                    macroString = String.valueOf(macroString.substring(0, macroString.length() - 2)) + IManagedBuilderMakefileGenerator.NEWLINE;
                }
                currentBuffer.append(macroString);
            }
            currentBuffer.append(IManagedBuilderMakefileGenerator.NEWLINE);
            buffer.append(currentBuffer);
        }
        return buffer.append(IManagedBuilderMakefileGenerator.NEWLINE);
    }

    protected StringBuffer writeTopAdditionMacros(List varList, HashMap varMap) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("# " + ManagedMakeMessages.getResourceString(MOD_VARS) + IManagedBuilderMakefileGenerator.NEWLINE);
        int i = 0;
        while (i < varList.size()) {
            String addition = (String)varMap.get((String)varList.get(i));
            StringBuffer currentBuffer = new StringBuffer();
            currentBuffer.append(addition);
            currentBuffer.append(IManagedBuilderMakefileGenerator.NEWLINE);
            buffer.append(currentBuffer);
            ++i;
        }
        return buffer.append(IManagedBuilderMakefileGenerator.NEWLINE);
    }

    protected void calculateToolInputsOutputs() {
        boolean done = false;
        boolean lastChance = false;
        int[] doneState = new int[this.buildTools.length];
        ITool targetTool = this.config.getTargetTool();
        if (targetTool == null) {
            targetTool = this.info.getToolFromOutputExtension(this.buildTargetExt);
        }
        int i = 0;
        while (i < this.buildTools.length) {
            if (this.buildTools[i] == targetTool) {
                String ext = this.info.getBuildArtifactExtension();
                try {
                    ext = ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(ext, "", " ", 3, this.info.getDefaultConfiguration());
                }
                catch (BuildMacroException buildMacroException) {}
                String name = this.info.getBuildArtifactName();
                try {
                    String resolved = ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(name, "", " ", 3, this.info.getDefaultConfiguration());
                    resolved = resolved.trim();
                    if (resolved.length() > 0) {
                        name = resolved;
                    }
                }
                catch (BuildMacroException buildMacroException) {}
                this.gnuToolInfos[i] = new ManagedBuildGnuToolInfo(this.project, this.buildTools[i], true, name, ext);
            } else {
                this.gnuToolInfos[i] = new ManagedBuildGnuToolInfo(this.project, this.buildTools[i], false, null, null);
            }
            doneState[i] = 0;
            ++i;
        }
        LinkedHashMap map = this.getTopBuildOutputVars();
        Iterator iterator = this.buildOutVars.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String macroName = (String)entry.getKey();
            this.addMacroAdditionPrefix(map, macroName, "", false);
        }
        HashSet handledDepsInputExtensions = new HashSet();
        HashSet handledOutsInputExtensions = new HashSet();
        while (!done) {
            int[] testState = new int[doneState.length];
            int i2 = 0;
            while (i2 < testState.length) {
                testState[i2] = 0;
                ++i2;
            }
            i2 = 0;
            while (i2 < this.gnuToolInfos.length) {
                if (this.gnuToolInfos[i2].areInputsCalculated()) {
                    int n = i2;
                    testState[n] = testState[n] + 1;
                } else if (this.gnuToolInfos[i2].calculateInputs(this, this.info.getDefaultConfiguration(), this.projectResources, lastChance)) {
                    int n = i2;
                    testState[n] = testState[n] + 1;
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < this.gnuToolInfos.length) {
                if (this.gnuToolInfos[i2].areDependenciesCalculated()) {
                    int n = i2;
                    testState[n] = testState[n] + 1;
                } else if (this.gnuToolInfos[i2].calculateDependencies(this, handledDepsInputExtensions, lastChance)) {
                    int n = i2;
                    testState[n] = testState[n] + 1;
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < this.gnuToolInfos.length) {
                if (this.gnuToolInfos[i2].areOutputsCalculated()) {
                    int n = i2;
                    testState[n] = testState[n] + 1;
                } else if (this.gnuToolInfos[i2].calculateOutputs(this, this.info.getDefaultConfiguration(), handledOutsInputExtensions, lastChance)) {
                    int n = i2;
                    testState[n] = testState[n] + 1;
                }
                ++i2;
            }
            done = true;
            i2 = 0;
            while (i2 < testState.length) {
                if (testState[i2] != 3) {
                    done = false;
                    break;
                }
                ++i2;
            }
            if (!done) {
                done = true;
                i2 = 0;
                while (i2 < testState.length) {
                    if (testState[i2] != doneState[i2]) {
                        done = false;
                        break;
                    }
                    ++i2;
                }
            }
            if (done && !lastChance) {
                lastChance = true;
                done = false;
            }
            if (done) continue;
            doneState = testState;
        }
    }

    public List getBuildVariableList(String variable, int locationType, IPath directory, boolean getAll) {
        boolean done = true;
        int i = 0;
        while (i < this.gnuToolInfos.length) {
            if (!this.gnuToolInfos[i].areOutputVariablesCalculated()) {
                done = false;
            }
            ++i;
        }
        if (!done && getAll) {
            return null;
        }
        List list = (List)this.buildSrcVars.get(variable);
        if (list == null) {
            list = (List)this.buildOutVars.get(variable);
        }
        List fileList = null;
        if (list != null) {
            IPath dirLocation = null;
            if (locationType != 3) {
                dirLocation = this.project.getLocation();
                if (locationType == 2) {
                    dirLocation = dirLocation.append(directory);
                }
            }
            int i2 = 0;
            while (i2 < list.size()) {
                IPath path = (IPath)list.get(i2);
                if (locationType != 3 && dirLocation.isPrefixOf(path)) {
                    path = path.removeFirstSegments(dirLocation.segmentCount()).setDevice(null);
                }
                fileList.add(path.toString());
                ++i2;
            }
        }
        return fileList;
    }

    public List getTopBuildVariableList(String variable) {
        return (List)this.topBuildOutVars.get(variable);
    }

    public HashMap getBuildOutputVars() {
        return this.buildOutVars;
    }

    public LinkedHashMap getTopBuildOutputVars() {
        return this.topBuildOutVars;
    }

    protected Vector getRuleList() {
        if (this.ruleList == null) {
            this.ruleList = new Vector();
        }
        return this.ruleList;
    }

    protected Vector getDepLineList() {
        if (this.depLineList == null) {
            this.depLineList = new Vector();
        }
        return this.depLineList;
    }

    protected void appendBuildSubdirectory(IResource resource) {
        IContainer container = resource.getParent();
        if (resource.getProjectRelativePath().toString().indexOf(" ") != -1) {
            if (!this.getInvalidDirList().contains(container)) {
                this.getInvalidDirList().add(container);
            }
        } else if (!this.getSubdirList().contains(container)) {
            this.getSubdirList().add(container);
        }
    }

    protected void appendDeletedSubdirectory(IContainer container) {
        IContainer parent = container.getParent();
        if (!this.getDeletedDirList().contains(container) && !this.getDeletedDirList().contains(parent)) {
            this.getDeletedDirList().add(container);
        }
    }

    protected void appendDeletedFile(IResource resource) {
        this.getDeletedFileList().add(resource);
    }

    protected void appendModifiedSubdirectory(IResource resource) {
        IContainer container = resource.getParent();
        if (resource.getProjectRelativePath().toString().indexOf(" ") != -1) {
            if (!this.getInvalidDirList().contains(container)) {
                this.getInvalidDirList().add(container);
            }
        } else if (!this.getModifiedList().contains(container)) {
            this.getModifiedList().add(container);
        }
    }

    protected void cancel(String message) {
        if (this.monitor != null && !this.monitor.isCanceled()) {
            throw new OperationCanceledException(message);
        }
    }

    protected void checkCancel() {
        if (this.monitor != null && this.monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    private IPath createDirectory(String dirName) throws CoreException {
        IFolder folder = this.project.getFolder(dirName);
        if (!folder.exists()) {
            IFolder parent;
            IPath parentPath = new Path(dirName).removeLastSegments(1);
            if (!parentPath.isEmpty() && !(parent = this.project.getFolder(parentPath)).exists()) {
                this.createDirectory(parentPath.toString());
            }
            try {
                folder.create(true, true, null);
            }
            catch (CoreException e) {
                if (e.getStatus().getCode() == 374) {
                    folder.refreshLocal(0, null);
                }
                throw e;
            }
            if (!folder.isDerived()) {
                folder.setDerived(true);
            }
        }
        return folder.getFullPath();
    }

    private IFile createFile(IPath makefilePath) throws CoreException {
        IWorkspaceRoot root = CCorePlugin.getWorkspace().getRoot();
        IFile newFile = root.getFileForLocation(makefilePath);
        if (newFile == null) {
            newFile = root.getFile(makefilePath);
        }
        ByteArrayInputStream contents = new ByteArrayInputStream(new byte[0]);
        try {
            newFile.create((InputStream)contents, false, (IProgressMonitor)new SubProgressMonitor(this.monitor, 1));
            if (!newFile.isDerived()) {
                newFile.setDerived(true);
            }
        }
        catch (CoreException e) {
            if (e.getStatus().getCode() == 374) {
                newFile.refreshLocal(0, null);
            }
            throw e;
        }
        return newFile;
    }

    private void deleteBuildTarget(IResource deletedFile) {
        String fileName = this.getFileName(deletedFile);
        String srcExtension = deletedFile.getFileExtension();
        String targetExtension = this.info.getOutputExtension(srcExtension);
        if (targetExtension != "") {
            fileName = String.valueOf(fileName) + "." + targetExtension;
        }
        IPath projectRelativePath = deletedFile.getProjectRelativePath().removeLastSegments(1);
        IPath targetFilePath = this.getBuildWorkingDir().append(projectRelativePath).append(fileName);
        IResource depFile = this.project.findMember(targetFilePath);
        if (depFile != null && depFile.exists()) {
            try {
                depFile.delete(true, (IProgressMonitor)new SubProgressMonitor(this.monitor, 1));
            }
            catch (CoreException coreException) {}
        }
    }

    private void deleteDepFile(IResource deletedFile) {
        String fileName = this.getFileName(deletedFile);
        fileName = String.valueOf(fileName) + ".d";
        IPath projectRelativePath = deletedFile.getProjectRelativePath().removeLastSegments(1);
        IPath depFilePath = this.getBuildWorkingDir().append(projectRelativePath).append(fileName);
        IResource depFile = this.project.findMember(depFilePath);
        if (depFile != null && depFile.exists()) {
            try {
                depFile.delete(true, (IProgressMonitor)new SubProgressMonitor(this.monitor, 1));
            }
            catch (CoreException coreException) {}
        }
    }

    private Vector getDeletedDirList() {
        if (this.deletedDirList == null) {
            this.deletedDirList = new Vector();
        }
        return this.deletedDirList;
    }

    private Vector getDeletedFileList() {
        if (this.deletedFileList == null) {
            this.deletedFileList = new Vector();
        }
        return this.deletedFileList;
    }

    private Vector getDependencyMakefiles() {
        if (this.dependencyMakefiles == null) {
            this.dependencyMakefiles = new Vector();
        }
        return this.dependencyMakefiles;
    }

    private String getFileName(IResource file) {
        String answer = new String();
        String lastSegment = file.getName();
        int extensionSeparator = lastSegment.lastIndexOf(".");
        if (extensionSeparator != -1) {
            answer = lastSegment.substring(0, extensionSeparator);
        }
        return answer;
    }

    private Vector getInvalidDirList() {
        if (this.invalidDirList == null) {
            this.invalidDirList = new Vector();
        }
        return this.invalidDirList;
    }

    private Vector getModifiedList() {
        if (this.modifiedList == null) {
            this.modifiedList = new Vector();
        }
        return this.modifiedList;
    }

    private Vector getSubdirList() {
        if (this.subdirList == null) {
            this.subdirList = new Vector();
        }
        return this.subdirList;
    }

    private void removeGeneratedDirectory(IContainer subDir) {
        try {
            if (subDir.exists() && subDir.members().length > 0) {
                return;
            }
        }
        catch (CoreException coreException) {}
        IPath moduleRelativePath = subDir.getProjectRelativePath();
        IPath buildRoot = this.getBuildWorkingDir();
        if (buildRoot == null) {
            return;
        }
        IPath moduleOutputPath = buildRoot.append(moduleRelativePath);
        IFolder folder = this.project.getFolder(moduleOutputPath);
        if (folder.exists()) {
            try {
                folder.delete(true, (IProgressMonitor)new SubProgressMonitor(this.monitor, 1));
            }
            catch (CoreException coreException) {}
        }
    }

    protected void updateMonitor(String msg) {
        if (this.monitor != null && !this.monitor.isCanceled()) {
            this.monitor.subTask(msg);
            this.monitor.worked(1);
        }
    }

    public IPath getTopBuildDir() {
        return this.project.getLocation().append(this.getBuildWorkingDir());
    }

    public class ResourceDeltaVisitor
    implements IResourceDeltaVisitor {
        private GnuMakefileGenerator generator;
        private IManagedBuildInfo info;

        public ResourceDeltaVisitor(GnuMakefileGenerator generator, IManagedBuildInfo info) {
            this.generator = generator;
            this.info = info;
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            boolean keepLooking = false;
            IResource resource = delta.getResource();
            if (resource.getType() == 1) {
                String ext = resource.getFileExtension();
                switch (delta.getKind()) {
                    case 1: {
                        if (this.generator.isGeneratedResource(resource) || !this.info.buildsFileType(ext)) break;
                        this.generator.appendModifiedSubdirectory(resource);
                        break;
                    }
                    case 2: {
                        if (this.generator.isGeneratedResource(resource) || !this.info.buildsFileType(ext)) break;
                        this.generator.appendDeletedFile(resource);
                        this.generator.appendModifiedSubdirectory(resource);
                        break;
                    }
                    default: {
                        keepLooking = true;
                    }
                }
            }
            if (resource.getType() == 2) {
                switch (delta.getKind()) {
                    case 2: {
                        if (this.generator.isGeneratedResource(resource)) break;
                        this.generator.appendDeletedSubdirectory((IContainer)resource);
                    }
                }
            }
            if (resource.getType() == 4) {
                IResourceDelta[] children = delta.getAffectedChildren();
                if (children != null && children.length > 0) {
                    keepLooking = true;
                }
            } else if (!this.generator.isGeneratedResource(resource)) {
                keepLooking = true;
            }
            return keepLooking;
        }
    }

    protected class ResourceProxyVisitor
    implements IResourceProxyVisitor {
        private GnuMakefileGenerator generator;
        private IManagedBuildInfo info;

        public ResourceProxyVisitor(GnuMakefileGenerator generator, IManagedBuildInfo info) {
            this.generator = generator;
            this.info = info;
        }

        public boolean visit(IResourceProxy proxy) throws CoreException {
            if (this.generator == null) {
                return false;
            }
            if (proxy.getType() == 1) {
                String ext;
                IResource resource = proxy.requestResource();
                boolean willBuild = false;
                IResourceConfiguration resConfig = GnuMakefileGenerator.this.config.getResourceConfiguration(resource.getFullPath().toString());
                if (resConfig != null) {
                    willBuild = true;
                }
                if (!willBuild && this.info.buildsFileType(ext = resource.getFileExtension()) && !this.generator.isGeneratedResource(resource)) {
                    willBuild = true;
                }
                if (willBuild && (resConfig == null || !resConfig.isExcluded())) {
                    this.generator.appendBuildSubdirectory(resource);
                }
                return false;
            }
            return true;
        }
    }
}

