/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.breakpoints;

import java.util.Map;
import org.eclipse.cdt.debug.core.model.ICLineBreakpoint;
import org.eclipse.cdt.debug.internal.core.breakpoints.CBreakpoint;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;

public abstract class AbstractLineBreakpoint
extends CBreakpoint
implements ICLineBreakpoint {
    public AbstractLineBreakpoint() {
    }

    public AbstractLineBreakpoint(IResource resource, String markerType, Map attributes, boolean add) throws CoreException {
        super(resource, markerType, attributes, add);
    }

    public int getLineNumber() throws CoreException {
        return this.ensureMarker().getAttribute("lineNumber", -1);
    }

    public int getCharStart() throws CoreException {
        return this.ensureMarker().getAttribute("charStart", -1);
    }

    public int getCharEnd() throws CoreException {
        return this.ensureMarker().getAttribute("charEnd", -1);
    }

    public String getAddress() throws CoreException {
        return this.ensureMarker().getAttribute("org.eclipse.cdt.debug.core.address", "");
    }

    public String getFileName() throws CoreException {
        String fileName = this.ensureMarker().getAttribute("org.eclipse.cdt.debug.core.sourceHandle", "");
        Path path = new Path(fileName);
        return path.isValidPath(fileName) ? path.lastSegment() : null;
    }

    public String getFunction() throws CoreException {
        return this.ensureMarker().getAttribute("org.eclipse.cdt.debug.core.function", "");
    }

    public void setAddress(String address) throws CoreException {
        this.setAttribute("org.eclipse.cdt.debug.core.address", address);
    }

    public void setFunction(String function) throws CoreException {
        this.setAttribute("org.eclipse.cdt.debug.core.function", function);
    }
}

