/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.index.cindexstorage.io;

import java.io.UTFDataFormatException;
import org.eclipse.cdt.internal.core.index.cindexstorage.IncludeEntry;
import org.eclipse.cdt.internal.core.index.cindexstorage.Util;
import org.eclipse.cdt.internal.core.index.cindexstorage.WordEntry;
import org.eclipse.cdt.internal.core.index.cindexstorage.io.CodeByteStream;
import org.eclipse.cdt.internal.core.index.cindexstorage.io.IndexBlock;

public class GammaCompressedIndexBlock
extends IndexBlock {
    CodeByteStream writeCodeStream = new CodeByteStream();
    CodeByteStream readCodeStream = new CodeByteStream(this.field.buffer());
    char[] prevWord = null;
    int offset = 0;

    public GammaCompressedIndexBlock(int blockSize) {
        super(blockSize);
    }

    public boolean addEntry(WordEntry entry) {
        this.writeCodeStream.reset();
        this.encodeEntry(entry, this.prevWord, this.writeCodeStream);
        if (this.offset + this.writeCodeStream.byteLength() > this.blockSize - 2) {
            return false;
        }
        byte[] bytes = this.writeCodeStream.toByteArray();
        this.field.put(this.offset, bytes);
        this.offset += bytes.length;
        this.prevWord = entry.getWord();
        return true;
    }

    protected void encodeEntry(WordEntry entry, char[] prevWord, CodeByteStream codeStream) {
        int ref;
        int j;
        int ref2;
        char[] word = entry.getWord();
        int prefixLen = prevWord == null ? 0 : Util.prefixLength(prevWord, word);
        codeStream.writeByte(prefixLen);
        codeStream.writeUTF(word, prefixLen, word.length);
        int n = entry.getNumRefs();
        codeStream.writeGamma(n);
        int prevRef = 0;
        int i = 0;
        while (i < n) {
            ref2 = entry.getRef(i);
            if (ref2 <= prevRef) {
                throw new IllegalArgumentException();
            }
            codeStream.writeGamma(ref2 - prevRef);
            prevRef = ref2;
            ++i;
        }
        i = 0;
        while (i < n) {
            int[] offsetArray = entry.getOffsets(i);
            codeStream.writeGamma(offsetArray.length);
            prevRef = 0;
            j = 0;
            while (j < offsetArray.length) {
                ref = offsetArray[j];
                if (ref <= prevRef) {
                    throw new IllegalArgumentException();
                }
                codeStream.writeGamma(ref - prevRef);
                prevRef = ref;
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < n) {
            int[] offsetLengthArray = entry.getOffsetLengths(i);
            codeStream.writeGamma(offsetLengthArray.length);
            j = 0;
            while (j < offsetLengthArray.length) {
                ref = offsetLengthArray[j];
                codeStream.writeGamma(ref);
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < n) {
            ref2 = entry.getModifiers(i);
            if (ref2 <= 0) {
                throw new IllegalArgumentException();
            }
            codeStream.writeGamma(ref2);
            ++i;
        }
    }

    public boolean addIncludeEntry(IncludeEntry entry) {
        this.writeCodeStream.reset();
        this.encodeEntry(entry, this.prevWord, this.writeCodeStream);
        if (this.offset + this.writeCodeStream.byteLength() > this.blockSize - 2) {
            return false;
        }
        byte[] bytes = this.writeCodeStream.toByteArray();
        this.field.put(this.offset, bytes);
        this.offset += bytes.length;
        this.prevWord = entry.getFile();
        return true;
    }

    protected void encodeEntry(IncludeEntry entry, char[] prevWord, CodeByteStream codeStream) {
        char[] file = entry.getFile();
        int prefixLen = prevWord == null ? 0 : Util.prefixLength(prevWord, file);
        codeStream.writeByte(prefixLen);
        codeStream.writeUTF(file, prefixLen, file.length);
        int n = entry.getNumRefs();
        codeStream.writeGamma(n);
        int prevRef = 0;
        int i = 0;
        while (i < n) {
            int ref = entry.getRef(i);
            if (ref <= prevRef) {
                throw new IllegalArgumentException();
            }
            codeStream.writeGamma(ref - prevRef);
            prevRef = ref;
            ++i;
        }
    }

    public void flush() {
        if (this.offset > 0) {
            this.field.putInt2(this.offset, 0);
            this.offset = 0;
            this.prevWord = null;
        }
    }

    public boolean isEmpty() {
        return this.offset == 0;
    }

    public boolean nextEntry(WordEntry entry) {
        try {
            int ref;
            int j;
            int ref2;
            this.readCodeStream.reset(this.field.buffer(), this.offset);
            int prefixLength = this.readCodeStream.readByte();
            char[] word = this.readCodeStream.readUTF();
            if (this.prevWord != null && prefixLength > 0) {
                char[] temp = new char[prefixLength + word.length];
                System.arraycopy(this.prevWord, 0, temp, 0, prefixLength);
                System.arraycopy(word, 0, temp, prefixLength, word.length);
                word = temp;
            }
            if (word.length == 0) {
                return false;
            }
            entry.reset(word);
            int n = this.readCodeStream.readGamma();
            int prevRef = 0;
            int i = 0;
            while (i < n) {
                ref2 = prevRef + this.readCodeStream.readGamma();
                if (ref2 < prevRef) {
                    throw new InternalError();
                }
                entry.addRef(ref2);
                prevRef = ref2;
                ++i;
            }
            i = 0;
            while (i < n) {
                int offsetArrayLength = this.readCodeStream.readGamma();
                int[] tempOffsetArray = new int[offsetArrayLength];
                prevRef = 0;
                j = 0;
                while (j < offsetArrayLength) {
                    ref = prevRef + this.readCodeStream.readGamma();
                    if (ref < prevRef) {
                        throw new InternalError();
                    }
                    tempOffsetArray[j] = ref;
                    prevRef = ref;
                    ++j;
                }
                entry.setOffsets(i, tempOffsetArray);
                ++i;
            }
            i = 0;
            while (i < n) {
                int offsetLengthArrayLength = this.readCodeStream.readGamma();
                int[] tempOffsetLengthArray = new int[offsetLengthArrayLength];
                j = 0;
                while (j < offsetLengthArrayLength) {
                    tempOffsetLengthArray[j] = ref = this.readCodeStream.readGamma();
                    ++j;
                }
                entry.setOffsetLengths(i, tempOffsetLengthArray);
                ++i;
            }
            i = 0;
            while (i < n) {
                ref2 = this.readCodeStream.readGamma();
                entry.setModifier(i, ref2);
                ++i;
            }
            this.offset = this.readCodeStream.byteLength();
            this.prevWord = word;
            return true;
        }
        catch (UTFDataFormatException uTFDataFormatException) {
            return false;
        }
    }

    public boolean nextEntry(IncludeEntry entry) {
        try {
            this.readCodeStream.reset(this.field.buffer(), this.offset);
            int prefixLength = this.readCodeStream.readByte();
            char[] file = this.readCodeStream.readUTF();
            if (this.prevWord != null && prefixLength > 0) {
                char[] temp = new char[prefixLength + file.length];
                System.arraycopy(this.prevWord, 0, temp, 0, prefixLength);
                System.arraycopy(file, 0, temp, prefixLength, file.length);
                file = temp;
            }
            if (file.length == 0) {
                return false;
            }
            entry.reset(file);
            int n = this.readCodeStream.readGamma();
            int prevRef = 0;
            int i = 0;
            while (i < n) {
                int ref = prevRef + this.readCodeStream.readGamma();
                if (ref < prevRef) {
                    throw new InternalError();
                }
                entry.addRef(ref);
                prevRef = ref;
                ++i;
            }
            this.offset = this.readCodeStream.byteLength();
            this.prevWord = file;
            return true;
        }
        catch (UTFDataFormatException uTFDataFormatException) {
            return false;
        }
    }

    public void reset() {
        super.reset();
        this.offset = 0;
        this.prevWord = null;
    }
}

