/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.corext.refactoring;

import java.util.ArrayList;
import org.eclipse.cdt.core.CConventions;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.cdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.cdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.cdt.internal.ui.util.Resources;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;

public class Checks {
    public static final int IS_RVALUE = 0;
    public static final int NOT_RVALUE_MISC = 1;
    public static final int NOT_RVALUE_VOID = 2;

    private Checks() {
    }

    public static RefactoringStatus checkFieldName(String name) {
        return Checks.checkName(name, CConventions.validateFieldName((String)name));
    }

    public static RefactoringStatus checkIdentifier(String name) {
        return Checks.checkName(name, CConventions.validateIdentifier((String)name));
    }

    public static RefactoringStatus checkMethodName(String name) {
        RefactoringStatus status = Checks.checkName(name, CConventions.validateMethodName((String)name));
        if (status.isOK() && Checks.startsWithUpperCase(name)) {
            return RefactoringStatus.createWarningStatus(RefactoringCoreMessages.getString("Checks.method_names_lowercase"));
        }
        return status;
    }

    public static RefactoringStatus checkClassName(String name) {
        if (name.indexOf(".") != -1) {
            return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("Checks.no_dot"));
        }
        RefactoringStatus status = Checks.checkName(name, CConventions.validateClassName((String)name));
        if (status.hasFatalError()) {
            String msg = RefactoringCoreMessages.getFormattedString("Checks.error.InvalidClassName", status.getFirstMessage(4));
            return RefactoringStatus.createFatalErrorStatus(msg);
        }
        if (status.hasError()) {
            String msg = RefactoringCoreMessages.getFormattedString("Checks.error.InvalidClassName", status.getFirstMessage(3));
            return RefactoringStatus.createErrorStatus(msg);
        }
        if (status.hasWarning()) {
            String msg = RefactoringCoreMessages.getFormattedString("Checks.warning.ClassNameDiscouraged", status.getFirstMessage(1));
            return RefactoringStatus.createWarningStatus(msg);
        }
        return status;
    }

    private static boolean startsWithUpperCase(String s) {
        if (s == null) {
            return false;
        }
        if ("".equals(s)) {
            return false;
        }
        return s.charAt(0) == Character.toUpperCase(s.charAt(0));
    }

    public static boolean startsWithLowerCase(String s) {
        if (s == null) {
            return false;
        }
        if ("".equals(s)) {
            return false;
        }
        return s.charAt(0) == Character.toLowerCase(s.charAt(0));
    }

    public static boolean resourceExists(IPath resourcePath) {
        return ResourcesPlugin.getWorkspace().getRoot().findMember(resourcePath) != null;
    }

    public static boolean isAlreadyNamed(ICElement element, String name) {
        return name.equals(element.getElementName());
    }

    private static RefactoringStatus checkName(String name, IStatus status) {
        RefactoringStatus result = new RefactoringStatus();
        if ("".equals(name)) {
            return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("Checks.Choose_name"));
        }
        if (status.isOK()) {
            return result;
        }
        switch (status.getSeverity()) {
            case 4: {
                return RefactoringStatus.createFatalErrorStatus(status.getMessage());
            }
            case 2: {
                return RefactoringStatus.createWarningStatus(status.getMessage());
            }
            case 1: {
                return RefactoringStatus.createInfoStatus(status.getMessage());
            }
        }
        return new RefactoringStatus();
    }

    public static RefactoringStatus checkIfTuBroken(ICElement element) throws CModelException {
        ITranslationUnit tu = (ITranslationUnit)CoreModel.getDefault().create(element.getUnderlyingResource());
        if (tu == null) {
            return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("Checks.cu_not_created"));
        }
        if (!tu.isStructureKnown()) {
            return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("Checks.cu_not_parsed"));
        }
        return new RefactoringStatus();
    }

    public static RefactoringStatus validateModifiesFiles(IFile[] filesToModify) {
        RefactoringStatus result = new RefactoringStatus();
        IStatus status = Resources.checkInSync((IResource[])filesToModify);
        if (!status.isOK()) {
            result.merge(RefactoringStatus.create(status));
        }
        if (!(status = Resources.makeCommittable((IResource[])filesToModify, null)).isOK()) {
            result.merge(RefactoringStatus.create(status));
        }
        return result;
    }

    public static boolean isAvailable(ICElement cElement) throws CModelException {
        if (cElement == null) {
            return false;
        }
        if (!cElement.exists()) {
            return false;
        }
        return !cElement.isReadOnly();
    }

    public static SearchResultGroup[] excludeTranslationUnits(SearchResultGroup[] grouped, RefactoringStatus status) throws CModelException {
        ArrayList<SearchResultGroup> result = new ArrayList<SearchResultGroup>();
        boolean wasEmpty = grouped.length == 0;
        int i = 0;
        while (i < grouped.length) {
            IResource resource = grouped[i].getResource();
            ICElement element = CoreModel.getDefault().create(resource);
            if (element instanceof ITranslationUnit) {
                ITranslationUnit cu = (ITranslationUnit)CoreModel.getDefault().create(resource);
                if (!cu.isStructureKnown()) {
                    String path = cu.getResource().getFullPath().toOSString();
                    status.addError(RefactoringCoreMessages.getFormattedString("Checks.cannot_be_parsed", path));
                } else {
                    result.add(grouped[i]);
                }
            }
            ++i;
        }
        if (!wasEmpty && result.isEmpty()) {
            status.addFatalError(RefactoringCoreMessages.getString("Checks.all_excluded"));
        } else if (result.isEmpty()) {
            status.addFatalError(RefactoringCoreMessages.getString("Checks.no_files"));
        }
        return result.toArray(new SearchResultGroup[result.size()]);
    }

    public static RefactoringStatus checkCompileErrorsInAffectedFiles(SearchResultGroup[] grouped) throws CModelException {
        RefactoringStatus result = new RefactoringStatus();
        int i = 0;
        while (i < grouped.length) {
            IResource resource = grouped[i].getResource();
            if (Checks.hasCompileErrors(resource)) {
                result.addFatalError(RefactoringCoreMessages.getFormattedString("Checks.cu_has_compile_errors", resource.getFullPath().makeRelative()));
            }
            ++i;
        }
        return result;
    }

    private static boolean hasCompileErrors(IResource resource) throws CModelException {
        try {
            IMarker[] problemMarkers = resource.findMarkers("org.eclipse.cdt.core.problem", true, 2);
            int i = 0;
            while (i < problemMarkers.length) {
                if (problemMarkers[i].getAttribute("severity", -1) == 2) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        catch (CModelException e) {
            throw e;
        }
        catch (CoreException e) {
            throw new CModelException(e);
        }
    }
}

