/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.search.matching;

import java.io.IOException;
import org.eclipse.cdt.core.browser.PathUtil;
import org.eclipse.cdt.core.parser.ISourceElementCallbackDelegate;
import org.eclipse.cdt.core.parser.ast.IASTNamespaceDefinition;
import org.eclipse.cdt.core.search.BasicSearchMatch;
import org.eclipse.cdt.core.search.ICSearchConstants;
import org.eclipse.cdt.core.search.ICSearchScope;
import org.eclipse.cdt.internal.core.index.IEntryResult;
import org.eclipse.cdt.internal.core.index.cindexstorage.Index;
import org.eclipse.cdt.internal.core.index.cindexstorage.IndexedFileEntry;
import org.eclipse.cdt.internal.core.index.cindexstorage.io.IndexInput;
import org.eclipse.cdt.internal.core.search.IIndexSearchRequestor;
import org.eclipse.cdt.internal.core.search.matching.CSearchPattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class NamespaceDeclarationPattern
extends CSearchPattern {
    private char[][] decodedContainingTypes;
    private char[] decodedSimpleName;
    private char[][] qualifications;
    private char[] simpleName;

    public NamespaceDeclarationPattern(char[] name, char[][] quals, int matchMode, ICSearchConstants.LimitTo limitTo, boolean caseSensitive) {
        super(matchMode, caseSensitive, limitTo);
        this.simpleName = name;
        this.qualifications = quals;
    }

    public int matchLevel(ISourceElementCallbackDelegate node, ICSearchConstants.LimitTo limit) {
        if (!(node instanceof IASTNamespaceDefinition) || !this.canAccept(limit)) {
            return 0;
        }
        IASTNamespaceDefinition namespace = (IASTNamespaceDefinition)node;
        if (this.simpleName != null && !this.matchesName(this.simpleName, namespace.getNameCharArray())) {
            return 0;
        }
        char[][] qualName = namespace.getFullyQualifiedNameCharArrays();
        if (!this.matchQualifications(this.qualifications, qualName, true)) {
            return 0;
        }
        return 2;
    }

    public void feedIndexRequestor(IIndexSearchRequestor requestor, int detailLevel, int[] fileRefs, int[][] offsets, int[][] offsetLengths, IndexInput input, ICSearchScope scope) throws IOException {
        int i = 0;
        int max = fileRefs.length;
        while (i < max) {
            IndexedFileEntry file = input.getIndexedFile(fileRefs[i]);
            String path = null;
            if (file != null && scope.encloses(path = file.getPath())) {
                int j = 0;
                while (j < offsets[i].length) {
                    BasicSearchMatch match = new BasicSearchMatch();
                    match.setName(new String(this.decodedSimpleName));
                    match.setLocatable(CSearchPattern.getMatchLocatable(offsets[i][j], offsetLengths[i][j]));
                    match.setParentName("");
                    match.setType(61);
                    IFile tempFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(path));
                    if (tempFile != null && tempFile.exists()) {
                        match.setResource((IResource)tempFile);
                    } else {
                        IPath tempPath = PathUtil.getWorkspaceRelativePath(file.getPath());
                        match.setPath(tempPath);
                        match.setReferringElement(tempPath);
                    }
                    requestor.acceptSearchMatch(match);
                    ++j;
                }
            }
            ++i;
        }
    }

    protected void resetIndexInfo() {
        this.decodedSimpleName = null;
        this.decodedContainingTypes = null;
    }

    protected void decodeIndexEntry(IEntryResult entryResult) {
        this.decodedSimpleName = entryResult.extractSimpleName().toCharArray();
        String[] missmatch = entryResult.getEnclosingNames();
        if (missmatch != null) {
            this.decodedContainingTypes = new char[missmatch.length][];
            int i = 0;
            while (i < missmatch.length) {
                this.decodedContainingTypes[i] = missmatch[i].toCharArray();
                ++i;
            }
        }
    }

    public char[] indexEntryPrefix() {
        return Index.bestNamespacePrefix(this._limitTo, this.simpleName, this.qualifications, this._matchMode, this._caseSensitive);
    }

    protected boolean matchIndexEntry() {
        if (this.simpleName != null && !this.matchesName(this.simpleName, this.decodedSimpleName)) {
            return false;
        }
        return this.matchQualifications(this.qualifications, this.decodedContainingTypes);
    }
}

