/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core;

import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDISession;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.mi.core.CygwinCommandFactory;
import org.eclipse.cdt.debug.mi.core.GDBDebugger;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MIPlugin;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.model.Target;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MIGDBSet;
import org.eclipse.cdt.debug.mi.core.output.MIInfo;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.ILaunchConfiguration;

public class CygwinGDBDebugger
extends GDBDebugger {
    protected void initializeLibraries(ILaunchConfiguration config, Session session) throws CDIException {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ICDISession createLaunchSession(ILaunchConfiguration config, IFile exe) throws CDIException {
        Session session2;
        Session session = null;
        boolean failed = false;
        try {
            try {
                session = (Session)super.createLaunchSession(config, exe);
                ICDITarget[] targets = session.getTargets();
                int i = 0;
                while (true) {
                    if (i >= targets.length) {
                        session2 = session;
                        Object var13_15 = null;
                        if (!failed) return session2;
                        if (session == null) return session2;
                        break;
                    }
                    Target target = (Target)targets[i];
                    MISession miSession = target.getMISession();
                    String miVersion = miSession.getCommandFactory().getMIVersion();
                    miSession.setCommandFactory(new CygwinCommandFactory(miVersion));
                    try {
                        CommandFactory factory = miSession.getCommandFactory();
                        MIGDBSet set = factory.createMIGDBSet(new String[]{"new-console"});
                        miSession.postCommand(set);
                        MIInfo info = set.getMIInfo();
                        if (info == null) {
                            throw new MIException(MIPlugin.getResourceString("src.common.No_answer"));
                        }
                    }
                    catch (MIException mIException) {}
                    ++i;
                }
            }
            catch (CDIException e) {
                failed = true;
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var13_16 = null;
            if (!failed) throw throwable;
            if (session == null) throw throwable;
            try {
                session.terminate();
                throw throwable;
            }
            catch (Exception exception) {
                throw throwable;
            }
        }
        try {}
        catch (Exception exception) {}
        session.terminate();
        return session2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ICDISession createAttachSession(ILaunchConfiguration config, IFile exe, int pid) throws CDIException {
        Session session2;
        Session session = null;
        boolean failed = false;
        try {
            try {
                session = (Session)super.createAttachSession(config, exe, pid);
                ICDITarget[] targets = session.getTargets();
                int i = 0;
                while (true) {
                    if (i >= targets.length) {
                        this.initializeLibraries(config, session);
                        session2 = session;
                        Object var11_13 = null;
                        if (!failed) return session2;
                        if (session == null) return session2;
                        break;
                    }
                    Target target = (Target)targets[i];
                    MISession miSession = target.getMISession();
                    String miVersion = miSession.getCommandFactory().getMIVersion();
                    miSession.setCommandFactory(new CygwinCommandFactory(miVersion));
                    ++i;
                }
            }
            catch (CDIException e) {
                failed = true;
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            if (!failed) throw throwable;
            if (session == null) throw throwable;
            try {
                session.terminate();
                throw throwable;
            }
            catch (Exception exception) {
                throw throwable;
            }
        }
        try {}
        catch (Exception exception) {}
        session.terminate();
        return session2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ICDISession createCoreSession(ILaunchConfiguration config, IFile exe, IPath corefile) throws CDIException {
        Session session2;
        Session session = null;
        boolean failed = false;
        try {
            try {
                session = (Session)super.createCoreSession(config, exe, corefile);
                ICDITarget[] targets = session.getTargets();
                int i = 0;
                while (true) {
                    if (i >= targets.length) {
                        this.initializeLibraries(config, session);
                        session2 = session;
                        Object var11_13 = null;
                        if (!failed) return session2;
                        if (session == null) return session2;
                        break;
                    }
                    Target target = (Target)targets[i];
                    MISession miSession = target.getMISession();
                    String miVersion = miSession.getCommandFactory().getMIVersion();
                    miSession.setCommandFactory(new CygwinCommandFactory(miVersion));
                    ++i;
                }
            }
            catch (CDIException e) {
                failed = true;
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            if (!failed) throw throwable;
            if (session == null) throw throwable;
            try {
                session.terminate();
                throw throwable;
            }
            catch (Exception exception) {
                throw throwable;
            }
        }
        try {}
        catch (Exception exception) {}
        session.terminate();
        return session2;
    }
}

