/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.util;

import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.util.CHelpDisplayContext;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;

public class CUIHelp {
    public static void setHelp(CEditor editor, StyledText text, String contextId) {
        CUIHelpListener listener = new CUIHelpListener(editor, contextId);
        text.addHelpListener((HelpListener)listener);
    }

    private static class CUIHelpListener
    implements HelpListener {
        private String fContextId;
        private CEditor fEditor;

        public CUIHelpListener(CEditor editor, String contextId) {
            this.fContextId = contextId;
            this.fEditor = editor;
        }

        public void helpRequested(HelpEvent e) {
            try {
                CHelpDisplayContext.displayHelp(this.fContextId, this.fEditor);
            }
            catch (CoreException x) {
                CUIPlugin.getDefault().log(x);
            }
        }
    }
}

