/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.browser.cache;

import java.io.IOException;
import org.eclipse.cdt.core.browser.ITypeInfo;
import org.eclipse.cdt.core.browser.ITypeSearchScope;
import org.eclipse.cdt.core.browser.PathUtil;
import org.eclipse.cdt.core.browser.QualifiedTypeName;
import org.eclipse.cdt.core.browser.TypeInfo;
import org.eclipse.cdt.core.browser.TypeReference;
import org.eclipse.cdt.internal.core.browser.cache.ITypeCache;
import org.eclipse.cdt.internal.core.browser.cache.IndexerJob2;
import org.eclipse.cdt.internal.core.index.IEntryResult;
import org.eclipse.cdt.internal.core.index.IQueryResult;
import org.eclipse.cdt.internal.core.index.cindexstorage.io.BlocksIndexInput;
import org.eclipse.cdt.internal.core.index.cindexstorage.io.IndexInput;
import org.eclipse.cdt.internal.core.search.indexing.IndexManager;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public class IndexerTypesJob2
extends IndexerJob2 {
    private ITypeCache fTypeCache;

    public IndexerTypesJob2(IndexManager indexManager, ITypeCache typeCache, ITypeSearchScope scope) {
        super(indexManager, typeCache.getProject());
        this.fTypeCache = typeCache;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean processIndex(IProgressMonitor progressMonitor) throws InterruptedException {
        BlocksIndexInput input = null;
        try {
            try {
                input = new BlocksIndexInput(this.fProjectIndex.getIndexFile());
                ((IndexInput)input).open();
                this.updateNamespaces(input, progressMonitor);
                this.updateTypes(input, progressMonitor);
                Object var3_3 = null;
                if (input == null) return true;
            }
            catch (IOException iOException) {
                Object var3_4 = null;
                if (input == null) return false;
                try {
                    ((IndexInput)input).close();
                    return false;
                }
                catch (IOException iOException2) {}
                return false;
            }
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            if (input == null) throw throwable;
            try {}
            catch (IOException iOException) {
                throw throwable;
            }
            ((IndexInput)input).close();
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        ((IndexInput)input).close();
        return true;
    }

    private void updateNamespaces(IndexInput input, IProgressMonitor monitor) throws InterruptedException, IOException {
        if (monitor.isCanceled()) {
            throw new InterruptedException();
        }
        IEntryResult[] namespaceEntries = this.fProjectIndex.getEntries(6, 0, 3);
        IQueryResult[] namespacePaths = this.fProjectIndex.getPrefix(6, 0, 3);
        if (namespaceEntries != null) {
            int i = 0;
            while (i < namespaceEntries.length) {
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
                IEntryResult entry = namespaceEntries[i];
                String name = entry.getName();
                if (name.length() != 0) {
                    String[] enclosingNames = entry.getEnclosingNames();
                    this.addType(input, entry, namespacePaths[i].getPath(), 61, name, enclosingNames, monitor);
                }
                ++i;
            }
        }
    }

    private void updateTypes(IndexInput input, IProgressMonitor monitor) throws InterruptedException, IOException {
        if (monitor.isCanceled()) {
            throw new InterruptedException();
        }
        int counter = 0;
        while (counter < 2) {
            IEntryResult[] typeEntries = this.fProjectIndex.getEntries(1, 0, counter == 0 ? 1 : 3);
            if (typeEntries != null) {
                int i = 0;
                while (i < typeEntries.length) {
                    if (monitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                    IEntryResult entry = typeEntries[i];
                    String name = entry.extractSimpleName();
                    switch (entry.getKind()) {
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: {
                            if (counter == 0 || name.length() == 0) break;
                            this.addType(input, entry, null, this.index2ICElement(entry.getKind()), name, entry.getEnclosingNames(), monitor);
                            break;
                        }
                    }
                    ++i;
                }
            }
            ++counter;
        }
        IEntryResult[] typeEntries = this.fProjectIndex.getEntries(1, 6, 0);
        if (typeEntries != null) {
            int j = 0;
            while (j < typeEntries.length) {
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
                IEntryResult entry = typeEntries[j];
                String name = entry.extractSimpleName();
                switch (entry.getKind()) {
                    case 6: {
                        if (name.length() == 0) break;
                        this.addSuperTypeReference(input, entry, name, entry.getEnclosingNames(), monitor);
                        break;
                    }
                }
                ++j;
            }
        }
    }

    private void addType(IndexInput input, IEntryResult entry, String pth, int type, String name, String[] enclosingNames, IProgressMonitor monitor) throws InterruptedException, IOException {
        int[] references;
        QualifiedTypeName qualifiedName = new QualifiedTypeName(name, enclosingNames);
        ITypeInfo info = this.fTypeCache.getType(type, qualifiedName);
        if ((info == null || info.isUndefinedType()) && (references = entry.getFileReferences()) != null && references.length > 0) {
            int offset;
            if (info != null) {
                info.setCElementType(type);
            } else {
                info = new TypeInfo(type, qualifiedName);
                this.fTypeCache.insert(info);
            }
            if (pth == null) {
                pth = input.getIndexedFile(references[0]).getPath();
            }
            IPath workspaceRelativePath = PathUtil.getWorkspaceRelativePath(pth);
            int offsetType = offset = entry.getOffsets()[0][0];
            int m = 1;
            while (offsetType >= 10) {
                offsetType /= 10;
                m *= 10;
            }
            int value = offset - offsetType * m;
            TypeReference typeReference = null;
            if (offsetType == 1) {
                typeReference = new TypeReference(workspaceRelativePath, this.fProject, value, 0);
                typeReference.offsetIsLineNumber = true;
            } else if (offsetType == 2) {
                typeReference = new TypeReference(workspaceRelativePath, this.fProject, value, entry.getOffsetLengths()[0][0]);
            }
            if (typeReference != null) {
                info.addReference(typeReference);
            }
        }
    }

    private void addSuperTypeReference(IndexInput input, IEntryResult entry, String name, String[] enclosingNames, IProgressMonitor monitor) throws InterruptedException, IOException {
        int[] references;
        QualifiedTypeName qualifiedName = new QualifiedTypeName(name, enclosingNames);
        ITypeInfo info = this.fTypeCache.getType(65, qualifiedName);
        if (info == null) {
            info = this.fTypeCache.getType(67, qualifiedName);
        }
        if (info == null) {
            info = new TypeInfo(0, qualifiedName);
            this.fTypeCache.insert(info);
        }
        if ((references = entry.getFileReferences()) != null && references.length > 0) {
            int i = 0;
            while (i < references.length) {
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
                String pth = input.getIndexedFile(references[i]).getPath();
                IPath path = PathUtil.getWorkspaceRelativePath(pth);
                info.addDerivedReference(new TypeReference(path, this.fProject));
                ++i;
            }
        }
    }
}

