/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IOptionCategory;
import org.eclipse.cdt.managedbuilder.core.IResourceConfiguration;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.macros.BuildMacroProvider;
import org.eclipse.cdt.managedbuilder.internal.ui.MacrosSetBlock;
import org.eclipse.cdt.managedbuilder.internal.ui.ManagedBuildOptionBlock;
import org.eclipse.cdt.managedbuilder.internal.ui.ManagedBuilderUIMessages;
import org.eclipse.cdt.managedbuilder.ui.properties.AbstractBuildPropertyPage;
import org.eclipse.cdt.managedbuilder.ui.properties.BuildOptionSettingsPage;
import org.eclipse.cdt.managedbuilder.ui.properties.BuildPreferencePage;
import org.eclipse.cdt.managedbuilder.ui.properties.BuildPropertyPage;
import org.eclipse.cdt.managedbuilder.ui.properties.BuildSettingsPage;
import org.eclipse.cdt.managedbuilder.ui.properties.BuildToolSettingsPage;
import org.eclipse.cdt.managedbuilder.ui.properties.BuildToolSettingsPreferenceStore;
import org.eclipse.cdt.managedbuilder.ui.properties.ResourceBuildPropertyPage;
import org.eclipse.cdt.managedbuilder.ui.properties.ToolListContentProvider;
import org.eclipse.cdt.managedbuilder.ui.properties.ToolListLabelProvider;
import org.eclipse.cdt.ui.dialogs.AbstractCOptionPage;
import org.eclipse.cdt.ui.dialogs.ICOptionContainer;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class ToolsSettingsBlock
extends AbstractCOptionPage {
    private static final String PREFIX = "ToolsSettingsBlock";
    private static final String LABEL = "ToolsSettingsBlock.label";
    private static final String SETTINGS_LABEL = "ToolsSettingsBlock.label.Settings";
    private static final int[] DEFAULT_SASH_WEIGHTS = new int[]{20, 30};
    private static final String EMPTY_STRING = new String();
    private TreeViewer optionList;
    private SashForm sashForm;
    private Composite settingsPageContainer;
    private ScrolledComposite containerSC;
    private Map configToPageListMap;
    private BuildToolSettingsPreferenceStore settingsStore;
    private BuildPropertyPage parent;
    private ResourceBuildPropertyPage resParent;
    private BuildSettingsPage currentSettingsPage;
    private IOptionCategory selectedCategory;
    private ToolListContentProvider provider;
    private ITool selectedTool;
    private Object element;
    private boolean defaultNeeded;
    private Point minimumPageSize = new Point(200, 200);

    public ToolsSettingsBlock(BuildPropertyPage parent, Object element) {
        super(ManagedBuilderUIMessages.getResourceString(SETTINGS_LABEL));
        super.setContainer((ICOptionContainer)parent);
        this.parent = parent;
        this.configToPageListMap = new HashMap();
        this.element = element;
        this.settingsStore = new BuildToolSettingsPreferenceStore(this);
    }

    public ToolsSettingsBlock(ResourceBuildPropertyPage resParent, Object element) {
        super(ManagedBuilderUIMessages.getResourceString(SETTINGS_LABEL));
        super.setContainer((ICOptionContainer)resParent);
        this.resParent = resParent;
        this.configToPageListMap = new HashMap();
        this.element = element;
        this.settingsStore = new BuildToolSettingsPreferenceStore(this);
    }

    public void createControl(Composite parent) {
        this.sashForm = new SashForm(parent, 0);
        this.sashForm.setOrientation(256);
        this.sashForm.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        this.sashForm.setLayout((Layout)layout);
        this.setControl((Control)this.sashForm);
        this.createSelectionArea((Composite)this.sashForm);
        this.createEditArea((Composite)this.sashForm);
        this.initializeSashForm();
    }

    protected void createSelectionArea(Composite parent) {
        Composite composite = ControlFactory.createComposite((Composite)parent, (int)1);
        this.optionList = new TreeViewer(composite, 2820);
        this.optionList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ToolsSettingsBlock.this.handleOptionSelection();
            }
        });
        this.optionList.getControl().setLayoutData((Object)new GridData(1808));
        this.optionList.setLabelProvider((IBaseLabelProvider)new ToolListLabelProvider());
        this.optionList.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parent, Object element) {
                if (parent instanceof IResourceConfiguration && element instanceof ITool) {
                    return !((ITool)element).getCustomBuildStep();
                }
                return true;
            }
        });
    }

    private void displayOptionsForCategory(IOptionCategory category) {
        this.selectedTool = null;
        this.selectedCategory = category;
        BuildSettingsPage oldPage = this.currentSettingsPage;
        this.currentSettingsPage = null;
        List pages = this.getPagesForConfig();
        ListIterator iter = pages.listIterator();
        while (iter.hasNext()) {
            BuildSettingsPage page = (BuildSettingsPage)((Object)iter.next());
            if (!(page instanceof BuildOptionSettingsPage) || !((BuildOptionSettingsPage)page).isForCategory(category)) continue;
            this.currentSettingsPage = page;
            break;
        }
        if (this.currentSettingsPage == null) {
            if (this.element instanceof IProject) {
                this.currentSettingsPage = new BuildOptionSettingsPage((AbstractBuildPropertyPage)this.parent, this.parent.getSelectedConfigurationClone(), category);
                pages.add(this.currentSettingsPage);
                this.currentSettingsPage.setContainer(this.parent);
            } else if (this.element instanceof IFile) {
                this.currentSettingsPage = new BuildOptionSettingsPage((AbstractBuildPropertyPage)this.resParent, this.resParent.getCurrentResourceConfigClone(), category);
                pages.add(this.currentSettingsPage);
                this.currentSettingsPage.setContainer(this.resParent);
            }
            if (this.currentSettingsPage.getControl() == null) {
                this.currentSettingsPage.createControl(this.settingsPageContainer);
            }
        }
        Control[] children = this.settingsPageContainer.getChildren();
        Control currentControl = this.currentSettingsPage.getControl();
        int i = 0;
        while (i < children.length) {
            if (children[i] != currentControl) {
                children[i].setVisible(false);
            }
            ++i;
        }
        this.currentSettingsPage.setVisible(true);
        if (this.currentSettingsPage instanceof BuildOptionSettingsPage) {
            ((BuildOptionSettingsPage)this.currentSettingsPage).updateFields();
        }
        if (oldPage != null && oldPage != this.currentSettingsPage) {
            oldPage.setVisible(false);
        }
        this.containerSC.setMinSize(this.currentSettingsPage.computeSize());
        this.settingsPageContainer.layout();
    }

    private void displayOptionsForTool(ITool tool) {
        this.selectedCategory = null;
        this.selectedTool = tool;
        BuildSettingsPage oldPage = this.currentSettingsPage;
        this.currentSettingsPage = null;
        List pages = this.getPagesForConfig();
        ListIterator iter = pages.listIterator();
        while (iter.hasNext()) {
            BuildSettingsPage page = (BuildSettingsPage)((Object)iter.next());
            if (!(page instanceof BuildToolSettingsPage) || !((BuildToolSettingsPage)page).isForTool(tool)) continue;
            this.currentSettingsPage = page;
            break;
        }
        if (this.currentSettingsPage == null) {
            if (this.element instanceof IProject) {
                this.currentSettingsPage = new BuildToolSettingsPage((AbstractBuildPropertyPage)this.parent, this.parent.getSelectedConfigurationClone(), tool);
                pages.add(this.currentSettingsPage);
                this.currentSettingsPage.setContainer(this.parent);
            } else if (this.element instanceof IFile) {
                this.currentSettingsPage = new BuildToolSettingsPage((AbstractBuildPropertyPage)this.resParent, this.resParent.getCurrentResourceConfigClone(), tool);
                pages.add(this.currentSettingsPage);
                this.currentSettingsPage.setContainer(this.resParent);
            }
            if (this.currentSettingsPage.getControl() == null) {
                this.currentSettingsPage.createControl(this.settingsPageContainer);
            }
        }
        Control[] children = this.settingsPageContainer.getChildren();
        Control currentControl = this.currentSettingsPage.getControl();
        int i = 0;
        while (i < children.length) {
            if (children[i] != currentControl) {
                children[i].setVisible(false);
            }
            ++i;
        }
        this.currentSettingsPage.setVisible(true);
        if (oldPage != null && oldPage != this.currentSettingsPage) {
            if (oldPage instanceof BuildOptionSettingsPage) {
                ((BuildOptionSettingsPage)oldPage).storeSettings();
            } else if (oldPage instanceof BuildToolSettingsPage) {
                ((BuildToolSettingsPage)oldPage).storeSettings();
            }
        }
        if (this.currentSettingsPage instanceof BuildToolSettingsPage) {
            ((BuildToolSettingsPage)this.currentSettingsPage).setValues();
        }
        if (oldPage != null && oldPage != this.currentSettingsPage) {
            oldPage.setVisible(false);
        }
        this.containerSC.setMinSize(this.currentSettingsPage.computeSize());
        this.settingsPageContainer.layout();
    }

    protected void createEditArea(Composite parent) {
        this.containerSC = new ScrolledComposite(parent, 768);
        this.containerSC.setExpandHorizontal(true);
        this.containerSC.setExpandVertical(true);
        this.settingsPageContainer = new Composite((Composite)this.containerSC, 0);
        this.settingsPageContainer.setLayout((Layout)new PageLayout());
        this.containerSC.setContent((Control)this.settingsPageContainer);
        this.containerSC.setMinSize(this.settingsPageContainer.computeSize(-1, -1));
        this.settingsPageContainer.layout();
    }

    protected void initializeSashForm() {
        this.sashForm.setWeights(DEFAULT_SASH_WEIGHTS);
    }

    protected void initializeValues() {
        this.setValues();
    }

    public void updateValues() {
        this.setValues();
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.selectedCategory = null;
            this.selectedTool = null;
            this.handleOptionSelection();
        }
        super.setVisible(visible);
    }

    protected void setValues() {
        ITool[] tools;
        IConfiguration config = null;
        IResourceConfiguration resConfig = null;
        if (this.provider == null) {
            IResource resource = (IResource)this.element;
            this.provider = new ToolListContentProvider(resource.getType());
            this.optionList.setContentProvider((IContentProvider)this.provider);
        }
        if (this.element instanceof IProject) {
            config = this.parent.getSelectedConfigurationClone();
            this.optionList.setInput((Object)config);
        } else if (this.element instanceof IFile) {
            resConfig = this.resParent.getCurrentResourceConfigClone();
            this.optionList.setInput((Object)resConfig);
        }
        this.optionList.expandAll();
        Object primary = null;
        if (this.selectedTool != null) {
            tools = null;
            if (this.element instanceof IProject) {
                tools = config.getFilteredTools();
            } else if (this.element instanceof IFile) {
                tools = resConfig.getTools();
            }
            String matchName = this.selectedTool.getName();
            int i = 0;
            while (i < tools.length) {
                ITool tool = tools[i];
                if (tool.getName().equals(matchName)) {
                    primary = tool;
                    break;
                }
                ++i;
            }
        } else if (this.selectedCategory != null) {
            tools = null;
            IToolChain toolChain = null;
            if (this.element instanceof IProject) {
                tools = config.getFilteredTools();
                toolChain = config.getToolChain();
            } else if (this.element instanceof IFile) {
                tools = resConfig.getTools();
            }
            IOptionCategory catOrTool = this.selectedCategory;
            String matchName = this.makeMatchName((IBuildObject)catOrTool);
            if (toolChain != null) {
                primary = this.findOptionCategoryByMatchName(matchName, toolChain.getChildCategories());
            }
            if (primary == null) {
                int i = 0;
                while (i < tools.length && primary == null) {
                    primary = this.findOptionCategoryByMatchName(matchName, tools[i].getChildCategories());
                    ++i;
                }
            }
        }
        if (primary == null) {
            Object[] elements = null;
            if (this.element instanceof IProject) {
                elements = this.provider.getElements(this.parent.getSelectedConfigurationClone());
            } else if (this.element instanceof IFile) {
                elements = this.provider.getElements(this.resParent.getCurrentResourceConfigClone());
            }
            Object object = primary = elements.length > 0 ? elements[0] : null;
        }
        if (primary != null) {
            if (primary instanceof IOptionCategory) {
                if (resConfig != null) {
                    this.settingsStore.setSelection(resConfig, (IOptionCategory)primary);
                } else {
                    this.settingsStore.setSelection(config, (IOptionCategory)primary);
                }
            }
            this.optionList.setSelection((ISelection)new StructuredSelection(primary), true);
        }
    }

    public void removeValues(String id) {
    }

    private void handleOptionSelection() {
        IStructuredSelection selection = (IStructuredSelection)this.optionList.getSelection();
        Object element = selection.getFirstElement();
        if (element instanceof IOptionCategory) {
            if (this.resParent != null) {
                this.settingsStore.setSelection(this.resParent.getCurrentResourceConfigClone(), (IOptionCategory)element);
            } else {
                this.settingsStore.setSelection(this.parent.getSelectedConfigurationClone(), (IOptionCategory)element);
            }
        }
        if (element instanceof ITool) {
            this.displayOptionsForTool((ITool)element);
        } else if (element instanceof IOptionCategory) {
            this.displayOptionsForCategory((IOptionCategory)element);
        }
    }

    public void performDefaults() {
        if (this.element instanceof IProject) {
            this.performDefaults((IProject)this.element);
        } else if (this.element instanceof IFile) {
            this.performDefaults((IFile)this.element);
        }
        this.defaultNeeded = true;
    }

    public void performDefaults(IProject project) {
        ManagedBuildManager.resetConfiguration((IProject)this.parent.getProject(), (IConfiguration)this.parent.getSelectedConfigurationClone());
        ITool[] tools = this.parent.getSelectedConfigurationClone().getFilteredTools();
        int i = 0;
        while (i < tools.length) {
            if (!tools[i].getCustomBuildStep()) {
                tools[i].setToolCommand(null);
                tools[i].setCommandLinePattern(null);
            }
            ++i;
        }
        this.selectedCategory = null;
        this.selectedTool = null;
        this.handleOptionSelection();
        this.setDirty(true);
    }

    public void performDefaults(IFile file) {
        ManagedBuildManager.resetResourceConfiguration((IProject)this.resParent.getProject(), (IResourceConfiguration)this.resParent.getCurrentResourceConfigClone());
        ITool[] tools = this.resParent.getCurrentResourceConfigClone().getTools();
        int i = 0;
        while (i < tools.length) {
            if (!tools[i].getCustomBuildStep()) {
                tools[i].setToolCommand(null);
                tools[i].setCommandLinePattern(null);
            }
            ++i;
        }
        this.selectedCategory = null;
        this.selectedTool = null;
        this.handleOptionSelection();
        this.setDirty(true);
    }

    public void performApply(IProgressMonitor monitor) throws CoreException {
        if (this.element instanceof IFile) {
            this.resParent.getCurrentResourceConfig(true);
        }
        if (this.defaultNeeded) {
            if (this.element instanceof IFile) {
                ManagedBuildManager.resetResourceConfiguration((IProject)this.resParent.getProject(), (IResourceConfiguration)this.resParent.getCurrentResourceConfig(true));
            } else {
                ManagedBuildManager.resetConfiguration((IProject)this.parent.getProject(), (IConfiguration)this.parent.getSelectedConfiguration());
            }
            this.defaultNeeded = false;
        }
        this.saveAll();
        this.setDirty(false);
    }

    private void saveAll() {
        if (this.resParent != null) {
            this.saveResourceConfig();
        } else {
            this.saveConfig();
        }
    }

    private void saveResourceConfig() {
        IResourceConfiguration cloneRcCfg = this.resParent.getCurrentResourceConfigClone();
        ITool[] tools = cloneRcCfg.getTools();
        int i = 0;
        while (i < tools.length) {
            this.saveHoldsOptions((IHoldsOptions)tools[i]);
            ++i;
        }
    }

    private void saveHoldsOptions(IHoldsOptions holder) {
        if (holder instanceof ITool && ((ITool)holder).getCustomBuildStep()) {
            return;
        }
        AbstractBuildPropertyPage page = this.resParent != null ? this.resParent : this.parent;
        IHoldsOptions realHo = page.getRealHoldsOptions(holder);
        if (realHo != null) {
            IHoldsOptions realHolder;
            IConfiguration realCfg = null;
            IResourceConfiguration realRcCfg = null;
            if (this.resParent != null) {
                realHolder = this.resParent.getRealHoldsOptions(holder);
                realRcCfg = (IResourceConfiguration)((ITool)realHolder).getParent();
                realCfg = realRcCfg.getParent();
            } else {
                realHolder = this.parent.getRealHoldsOptions(holder);
                realCfg = this.parent.getConfigurationFromHoldsOptions(realHolder);
            }
            if (holder instanceof ITool) {
                String currentValue = ((ITool)realHo).getToolCommand();
                if (!currentValue.equals(((ITool)holder).getToolCommand())) {
                    ((ITool)realHo).setToolCommand(((ITool)holder).getToolCommand());
                    realCfg.setRebuildState(true);
                }
                if (!(currentValue = ((ITool)realHo).getCommandLinePattern()).equals(((ITool)holder).getCommandLinePattern())) {
                    ((ITool)realHo).setCommandLinePattern(((ITool)holder).getCommandLinePattern());
                    realCfg.setRebuildState(true);
                }
            }
            IOption[] options = holder.getOptions();
            int i = 0;
            while (i < options.length) {
                this.saveOption(options[i], holder, realHolder, realCfg, realRcCfg);
                ++i;
            }
        }
    }

    private void saveOption(IOption clonedOption, IHoldsOptions cloneHolder, IHoldsOptions realHolder, IConfiguration realCfg, IResourceConfiguration realRcCfg) {
        IOption realOption = this.resParent != null ? this.resParent.getRealOption(clonedOption, cloneHolder) : this.parent.getRealOption(clonedOption, cloneHolder);
        try {
            IOption setOption = null;
            switch (clonedOption.getValueType()) {
                case 0: {
                    boolean boolVal = clonedOption.getBooleanValue();
                    if (realRcCfg != null) {
                        setOption = ManagedBuildManager.setOption((IResourceConfiguration)realRcCfg, (IHoldsOptions)realHolder, (IOption)realOption, (boolean)boolVal);
                        break;
                    }
                    setOption = ManagedBuildManager.setOption((IConfiguration)realCfg, (IHoldsOptions)realHolder, (IOption)realOption, (boolean)boolVal);
                    break;
                }
                case 1: {
                    String enumVal = clonedOption.getStringValue();
                    String enumId = clonedOption.getEnumeratedId(enumVal);
                    if (realRcCfg != null) {
                        setOption = ManagedBuildManager.setOption((IResourceConfiguration)realRcCfg, (IHoldsOptions)realHolder, (IOption)realOption, (String)(enumId != null && enumId.length() > 0 ? enumId : enumVal));
                        break;
                    }
                    setOption = ManagedBuildManager.setOption((IConfiguration)realCfg, (IHoldsOptions)realHolder, (IOption)realOption, (String)(enumId != null && enumId.length() > 0 ? enumId : enumVal));
                    break;
                }
                case 2: {
                    String strVal = clonedOption.getStringValue();
                    if (realRcCfg != null) {
                        setOption = ManagedBuildManager.setOption((IResourceConfiguration)realRcCfg, (IHoldsOptions)realHolder, (IOption)realOption, (String)strVal);
                        break;
                    }
                    setOption = ManagedBuildManager.setOption((IConfiguration)realCfg, (IHoldsOptions)realHolder, (IOption)realOption, (String)strVal);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    String[] listVal = ((List)clonedOption.getValue()).toArray(new String[0]);
                    if (realRcCfg != null) {
                        setOption = ManagedBuildManager.setOption((IResourceConfiguration)realRcCfg, (IHoldsOptions)realHolder, (IOption)realOption, (String[])listVal);
                        break;
                    }
                    setOption = ManagedBuildManager.setOption((IConfiguration)realCfg, (IHoldsOptions)realHolder, (IOption)realOption, (String[])listVal);
                    break;
                }
            }
            if (setOption == null) {
                setOption = realOption;
            }
        }
        catch (BuildException buildException) {
        }
        catch (ClassCastException classCastException) {}
    }

    private void saveConfig() {
        IConfiguration cfg = this.parent.getSelectedConfigurationClone();
        IToolChain tc = cfg.getToolChain();
        this.saveHoldsOptions((IHoldsOptions)tc);
        ITool[] tools = cfg.getFilteredTools();
        int i = 0;
        while (i < tools.length) {
            this.saveHoldsOptions((IHoldsOptions)tools[i]);
            ++i;
        }
    }

    public boolean containsDefaults() {
        if (this.resParent == null) {
            return false;
        }
        return this.containsDefaults(this.resParent.getCurrentResourceConfigClone());
    }

    protected boolean containsDefaults(IResourceConfiguration rcCfg) {
        IConfiguration cfg = rcCfg.getParent();
        ITool[] tools = rcCfg.getTools();
        int i = 0;
        while (i < tools.length) {
            ITool tool = tools[i];
            if (!tool.getCustomBuildStep()) {
                ITool cfgTool = cfg.getToolChain().getTool(tool.getSuperClass().getId());
                if (cfgTool != null) {
                    if (!tool.getToolCommand().equals(cfgTool.getToolCommand())) {
                        return false;
                    }
                    if (!tool.getCommandLinePattern().equals(cfgTool.getCommandLinePattern())) {
                        return false;
                    }
                }
                IOption[] options = tool.getOptions();
                int j = 0;
                while (j < options.length) {
                    IOption option = options[j];
                    if (option.getParent() == tool) {
                        block11: {
                            IOption ext = option;
                            while (!ext.isExtensionElement() && (ext = ext.getSuperClass()) != null) {
                            }
                            if (ext != null && cfgTool != null) {
                                IOption defaultOpt = cfgTool.getOptionBySuperClassId(ext.getId());
                                try {
                                    Object defaultVal;
                                    Object value;
                                    if (defaultOpt == null || defaultOpt.getValueType() != option.getValueType() || !(value = option.getValue()).equals(defaultVal = defaultOpt.getValue())) break block11;
                                }
                                catch (BuildException buildException) {}
                            }
                        }
                        return false;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return true;
    }

    private List getPagesForConfig() {
        List pages = null;
        if (this.element instanceof IProject) {
            if (this.parent.getSelectedConfigurationClone() == null) {
                return null;
            }
            pages = (List)this.configToPageListMap.get(this.parent.getSelectedConfigurationClone().getId());
        } else if (this.element instanceof IFile) {
            if (this.resParent.getCurrentResourceConfigClone() == null) {
                return null;
            }
            pages = (List)this.configToPageListMap.get(this.resParent.getCurrentResourceConfigClone().getId());
        }
        if (pages == null) {
            pages = new ArrayList();
            if (this.element instanceof IProject) {
                this.configToPageListMap.put(this.parent.getSelectedConfigurationClone().getId(), pages);
            } else if (this.element instanceof IFile) {
                this.configToPageListMap.put(this.resParent.getCurrentResourceConfigClone().getId(), pages);
            }
        }
        return pages;
    }

    public BuildToolSettingsPreferenceStore getPreferenceStore() {
        return this.settingsStore;
    }

    public void setDirty(boolean b) {
        List pages = this.getPagesForConfig();
        if (pages == null) {
            return;
        }
        ListIterator iter = pages.listIterator();
        while (iter.hasNext()) {
            BuildSettingsPage page = (BuildSettingsPage)((Object)iter.next());
            if (page == null) continue;
            page.setDirty(b);
        }
    }

    public boolean isDirty() {
        List pages = this.getPagesForConfig();
        if (pages == null) {
            return false;
        }
        ListIterator iter = pages.listIterator();
        while (iter.hasNext()) {
            BuildSettingsPage page = (BuildSettingsPage)((Object)iter.next());
            if (page == null || !page.isDirty()) continue;
            return true;
        }
        return false;
    }

    public BuildMacroProvider obtainMacroProvider() {
        MacrosSetBlock block;
        ICOptionContainer page;
        ICOptionContainer container = this.getContainer();
        ManagedBuildOptionBlock optionBlock = null;
        if (container instanceof BuildPropertyPage) {
            page = (BuildPropertyPage)container;
            optionBlock = page.getOptionBlock();
        } else if (container instanceof BuildPreferencePage) {
            page = (BuildPreferencePage)container;
            optionBlock = page.getOptionBlock();
        }
        if (optionBlock != null && (block = optionBlock.getMacrosBlock()) != null) {
            return block.getBuildMacroProvider();
        }
        return (BuildMacroProvider)ManagedBuildManager.getBuildMacroProvider();
    }

    private String makeMatchName(IBuildObject catOrTool) {
        String catName = EMPTY_STRING;
        do {
            catName = String.valueOf(catOrTool.getName()) + "|" + catName;
        } while (!(catOrTool instanceof ITool) && catOrTool instanceof IOptionCategory && (catOrTool = ((IOptionCategory)catOrTool).getOwner()) != null);
        return catName;
    }

    private Object findOptionCategoryByMatchName(String matchName, IOptionCategory[] cats) {
        Object primary = null;
        int j = 0;
        while (j < cats.length) {
            IOptionCategory catOrTool = cats[j];
            String catName = this.makeMatchName((IBuildObject)catOrTool);
            if (catName.equals(matchName)) {
                primary = cats[j];
                break;
            }
            if (matchName.startsWith(catName) && (primary = this.findOptionCategoryByMatchName(matchName, cats[j].getChildCategories())) != null) break;
            ++j;
        }
        return primary;
    }

    private class PageLayout
    extends Layout {
        PageLayout() {
        }

        public void layout(Composite composite, boolean force) {
            Rectangle rect = composite.getClientArea();
            Control[] children = composite.getChildren();
            int i = 0;
            while (i < children.length) {
                children[i].setSize(rect.width, rect.height);
                ++i;
            }
        }

        public Point computeSize(Composite composite, int wHint, int hHint, boolean force) {
            if (wHint != -1 && hHint != -1) {
                return new Point(wHint, hHint);
            }
            int x = ((ToolsSettingsBlock)ToolsSettingsBlock.this).minimumPageSize.x;
            int y = ((ToolsSettingsBlock)ToolsSettingsBlock.this).minimumPageSize.y;
            Control[] children = composite.getChildren();
            int i = 0;
            while (i < children.length) {
                Point size = children[i].computeSize(-1, -1, force);
                x = Math.max(x, size.x);
                y = Math.max(y, size.y);
                ++i;
            }
            if (wHint != -1) {
                x = wHint;
            }
            if (hHint != -1) {
                y = hHint;
            }
            return new Point(x, y);
        }
    }
}

