/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.refactoring.tests;

import java.io.StringWriter;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.tests.FailingTest;
import org.eclipse.cdt.refactoring.tests.RenameFunctionTests;
import org.eclipse.cdt.refactoring.tests.RenameMacroTests;
import org.eclipse.cdt.refactoring.tests.RenameTemplatesTests;
import org.eclipse.cdt.refactoring.tests.RenameTests;
import org.eclipse.cdt.refactoring.tests.RenameTypeTests;
import org.eclipse.cdt.refactoring.tests.RenameVariableTests;
import org.eclipse.cdt.refactoring.tests.TestRenameParticipant;
import org.eclipse.core.resources.IFile;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;

public class RenameRegressionTests
extends RenameTests {
    static /* synthetic */ Class class$0;

    public RenameRegressionTests() {
    }

    public RenameRegressionTests(String string) {
        super(string);
    }

    public static Test suite() {
        return RenameRegressionTests.suite(true);
    }

    public static Test suite(boolean bl) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.refactoring.tests.RenameRegressionTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite testSuite = new TestSuite((Class)clazz);
        testSuite.addTest((Test)new FailingTest((Test)new RenameRegressionTests("failing_testMethod_35_72726"), 72726));
        TestSuite testSuite2 = new TestSuite("RenameRegressionTests");
        testSuite2.addTest((Test)new RenameRegressionTests("disableIndexer"));
        testSuite2.addTest((Test)testSuite);
        testSuite2.addTest(RenameVariableTests.suite(false));
        testSuite2.addTest(RenameFunctionTests.suite(false));
        testSuite2.addTest(RenameTypeTests.suite(false));
        testSuite2.addTest(RenameMacroTests.suite(false));
        testSuite2.addTest(RenameTemplatesTests.suite(false));
        if (bl) {
            testSuite2.addTest((Test)new RenameRegressionTests("cleanupProject"));
        }
        return testSuite2;
    }

    public void disableIndexer() throws Exception {
        this.disableIndexing();
    }

    public void testSimpleRename() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("int boo;    // boo  \n");
        stringWriter.write("#ifdef 0            \n");
        stringWriter.write("boo                 \n");
        stringWriter.write("#endif              \n");
        stringWriter.write("void f() {          \n");
        stringWriter.write("   boo++;           \n");
        stringWriter.write("}                   \n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("t.cpp", string);
        Change change = this.getRefactorChanges(iFile, string.indexOf("boo"), "ooga");
        this.assertTotalChanges(2, 1, 1, change);
        this.assertChange(change, iFile, string.indexOf("boo"), 3, "ooga");
        this.assertChange(change, iFile, string.indexOf("boo++"), 3, "ooga");
    }

    public void testLocalVar() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("void f() {          \n");
        stringWriter.write("   int boo;         \n");
        stringWriter.write("   boo++;           \n");
        stringWriter.write("   {                \n");
        stringWriter.write("     int boo;       \n");
        stringWriter.write("     boo++;         \n");
        stringWriter.write("   }                \n");
        stringWriter.write("   boo++;           \n");
        stringWriter.write("}                   \n");
        String string = stringWriter.toString();
        int n = string.indexOf("boo");
        IFile iFile = this.importFile("t.cpp", string);
        Change change = this.getRefactorChanges(iFile, n, "ooga");
        this.assertTotalChanges(3, change);
        this.assertChange(change, iFile, n, 3, "ooga");
        n = string.indexOf("boo", n + 1);
        this.assertChange(change, iFile, n, 3, "ooga");
        n = string.lastIndexOf("boo");
        this.assertChange(change, iFile, n, 3, "ooga");
    }

    public void testParameter() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("void f(int boo) {   \n");
        stringWriter.write("   boo++;           \n");
        stringWriter.write("   {                \n");
        stringWriter.write("     int boo;       \n");
        stringWriter.write("     boo++;         \n");
        stringWriter.write("   }                \n");
        stringWriter.write("   boo++;           \n");
        stringWriter.write("}                   \n");
        String string = stringWriter.toString();
        int n = string.indexOf("boo");
        IFile iFile = this.importFile("t.cpp", string);
        Change change = this.getRefactorChanges(iFile, n, "ooga");
        this.assertTotalChanges(3, change);
        this.assertChange(change, iFile, n, 3, "ooga");
        n = string.indexOf("boo", n + 1);
        this.assertChange(change, iFile, n, 3, "ooga");
        n = string.lastIndexOf("boo");
        this.assertChange(change, iFile, n, 3, "ooga");
    }

    public void testFileStaticVar() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("static int boo;     \n");
        stringWriter.write("void f() {          \n");
        stringWriter.write("   boo++;           \n");
        stringWriter.write("}                   \n");
        stringWriter.write("void g(int boo) {   \n");
        stringWriter.write("   boo++;           \n");
        stringWriter.write("}                   \n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("t.cpp", string);
        this.importFile("t2.cpp", string);
        int n = string.indexOf("boo");
        Change change = this.getRefactorChanges(iFile, n, "ooga");
        this.assertTotalChanges(2, change);
        this.assertChange(change, iFile, n, 3, "ooga");
        n = string.indexOf("boo", n + 1);
        this.assertChange(change, iFile, n, 3, "ooga");
    }

    public void testClass_1() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("class Boo/*vp1*/{}; \n");
        stringWriter.write("void f() {          \n");
        stringWriter.write("   Boo a;           \n");
        stringWriter.write("}                   \n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("t.cpp", string);
        int n = string.indexOf("Boo/*vp1*/");
        Change change = this.getRefactorChanges(iFile, n, "Ooga");
        this.assertTotalChanges(2, change);
        this.assertChange(change, iFile, string.indexOf("Boo/*vp1*/"), 3, "Ooga");
        this.assertChange(change, iFile, string.indexOf("Boo a"), 3, "Ooga");
    }

    public void testAttribute_2() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("class Boo{          \n");
        stringWriter.write("  int att1;//vp1,res1   \n");
        stringWriter.write("};                  \n");
        stringWriter.write("void f() {          \n");
        stringWriter.write("   Boo a;           \n");
        stringWriter.write("   a.att1;//res2     \n");
        stringWriter.write("}                   \n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("t.cpp", string);
        int n = string.indexOf("att1;//vp1");
        Change change = this.getRefactorChanges(iFile, n, "ooga");
        this.assertTotalChanges(2, change);
        this.assertChange(change, iFile, string.indexOf("att1;//vp1,res1"), 4, "ooga");
        this.assertChange(change, iFile, string.indexOf("att1;//res2"), 4, "ooga");
    }

    public void testMethod_1() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("class Foo{                                \n");
        stringWriter.write("public:                                   \n");
        stringWriter.write("  const void* method1(const char*);       \n");
        stringWriter.write("};                                        \n");
        stringWriter.write("const void* Foo::method1(const char* x) { \n");
        stringWriter.write("   return (void*) x;                      \n");
        stringWriter.write("}                                         \n");
        stringWriter.write("void test() {                             \n");
        stringWriter.write("     Foo d;                               \n");
        stringWriter.write("     d.method1(\"hello\");                \n");
        stringWriter.write("}                                         \n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("t.cpp", string);
        int n = string.indexOf("method1");
        Change change = this.getRefactorChanges(iFile, n, "m1");
        this.assertTotalChanges(3, change);
        this.assertChange(change, iFile, string.indexOf("method1"), 7, "m1");
        this.assertChange(change, iFile, string.indexOf("method1(const"), 7, "m1");
        this.assertChange(change, iFile, string.indexOf("method1(\"hello"), 7, "m1");
    }

    public void testMethod_3() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("class Boo{                   \n");
        stringWriter.write("  int method1(){}//vp1,res1  \n");
        stringWriter.write("};                           \n");
        stringWriter.write("void f() {                   \n");
        stringWriter.write("   Boo a;                    \n");
        stringWriter.write("   a.method1();//res2        \n");
        stringWriter.write("}                            \n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("t.cpp", string);
        int n = string.indexOf("method1(){}//vp1");
        Change change = this.getRefactorChanges(iFile, n, "ooga");
        this.assertTotalChanges(2, change);
        this.assertChange(change, iFile, string.indexOf("method1(){}//vp1,res1"), 7, "ooga");
        this.assertChange(change, iFile, string.indexOf("method1();//res2"), 7, "ooga");
    }

    public void testConstructor_26() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("class Boo{                   \n");
        stringWriter.write("  Boo(){}//vp1,res1  \n");
        stringWriter.write("};                           \n");
        stringWriter.write("void f() {                   \n");
        stringWriter.write("   Boo a = new Boo();                    \n");
        stringWriter.write("}                            \n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("t.cpp", string);
        int n = string.indexOf("Boo(){}");
        try {
            this.getRefactorChanges(iFile, n, "ooga");
        }
        catch (AssertionFailedError assertionFailedError) {
            Assert.assertTrue((boolean)assertionFailedError.getMessage().startsWith("Input check on ooga failed."));
            return;
        }
        Assert.fail((String)"An error should have occurred in the input check.");
    }

    public void testConstructor_27() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("class Boo{           \n");
        stringWriter.write("  int foo(){}//vp1   \n");
        stringWriter.write("};                   \n");
        stringWriter.write("void f() {           \n");
        stringWriter.write("   Boo a;            \n");
        stringWriter.write("   a.foo();          \n");
        stringWriter.write("}                    \n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("t.cpp", string);
        int n = string.indexOf("foo(){}");
        try {
            this.getRefactorChanges(iFile, n, "Boo");
        }
        catch (AssertionFailedError assertionFailedError) {
            Assert.assertTrue((boolean)assertionFailedError.getMessage().startsWith("Input check on Boo failed."));
            return;
        }
        Assert.fail((String)"An error should have occurred in the input check.");
    }

    public void testDestructor_28() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("class Boo{           \n");
        stringWriter.write("  ~Boo(){}//vp1      \n");
        stringWriter.write("};                   \n");
        stringWriter.write("void f() {           \n");
        stringWriter.write("   Boo a ;           \n");
        stringWriter.write("   a.~Boo();         \n");
        stringWriter.write("}                    \n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("t.cpp", string);
        int n = string.indexOf("~Boo(){}");
        try {
            this.getRefactorChanges(iFile, n, "ooga");
        }
        catch (AssertionFailedError assertionFailedError) {
            Assert.assertTrue((boolean)assertionFailedError.getMessage().startsWith("Input check on ooga failed."));
            return;
        }
        Assert.fail((String)"An error should have occurred in the input check.");
    }

    public void testDestructor_29_72612() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("class Boo{           \n");
        stringWriter.write("  int foo(){}//vp1   \n");
        stringWriter.write("};                   \n");
        stringWriter.write("void f() {           \n");
        stringWriter.write("   Boo a;            \n");
        stringWriter.write("   a.foo();          \n");
        stringWriter.write("}                    \n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("t.cpp", string);
        int n = string.indexOf("foo(){}");
        try {
            this.getRefactorChanges(iFile, n, "~Boo");
        }
        catch (AssertionFailedError assertionFailedError) {
            Assert.assertTrue((boolean)assertionFailedError.getMessage().startsWith("Input check on ~Boo failed."));
            return;
        }
        Assert.fail((String)"An error should have occurred in the input check.");
    }

    public void testFunction_31() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("void foo(){}             \n");
        stringWriter.write("void foo/*vp1*/(int i){} \n");
        stringWriter.write("class Foo{               \n");
        stringWriter.write("   int method1(){        \n");
        stringWriter.write("    foo(3);              \n");
        stringWriter.write("    foo();               \n");
        stringWriter.write("   }                     \n");
        stringWriter.write("};                       \n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("t.cpp", string);
        int n = string.indexOf("foo/*vp1*/");
        Change change = this.getRefactorChanges(iFile, n, "ooga");
        this.assertTotalChanges(2, change);
        this.assertChange(change, iFile, string.indexOf("foo/*vp1*/"), 3, "ooga");
        this.assertChange(change, iFile, string.indexOf("foo(3)"), 3, "ooga");
    }

    public void testMethod_32_72717() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("class Base {                 \n");
        stringWriter.write(" virtual void foo()=0;       \n");
        stringWriter.write("};                           \n");
        stringWriter.write("class Derived: public Base { \n");
        stringWriter.write(" virtual void foo();         \n");
        stringWriter.write(" void foo(char i);           \n");
        stringWriter.write(" void moon/*vp1*/(int i);    \n");
        stringWriter.write("};                           \n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("t.cpp", string);
        int n = string.indexOf("moon/*vp1*/");
        Change change = this.getRefactorChanges(iFile, n, "foo");
        this.assertTotalChanges(1, change);
        this.assertChange(change, iFile, string.indexOf("moon/*vp1*/"), 4, "foo");
        RefactoringStatus refactoringStatus = this.checkConditions(iFile, n, "foo");
        this.assertRefactoringWarning(refactoringStatus, "'foo' will overload a method.");
    }

    public void testMethod_33_72605() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("class Foo {                  \n");
        stringWriter.write(" void aMethod/*vp1*/(int x=0);       \n");
        stringWriter.write("};                           \n");
        stringWriter.write("void Foo::aMethod(int x){}   \n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("t.cpp", string);
        int n = string.indexOf("aMethod/*vp1*/");
        Change change = this.getRefactorChanges(iFile, n, "ooga");
        this.assertTotalChanges(2, change);
        this.assertChange(change, iFile, string.indexOf("aMethod/*vp1*/"), 7, "ooga");
        this.assertChange(change, iFile, string.indexOf("aMethod(int x)"), 7, "ooga");
    }

    public void testMethod_33b_72605() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("class Foo {                  \n");
        stringWriter.write(" void aMethod/*vp1*/(int x=0);       \n");
        stringWriter.write("};                           \n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("t.hh", string);
        stringWriter = new StringWriter();
        stringWriter.write("#include \"t.hh\"            \n");
        stringWriter.write("void Foo::aMethod(int x){}   \n");
        String string2 = stringWriter.toString();
        IFile iFile2 = this.importFile("t.cpp", string2);
        int n = string.indexOf("aMethod");
        int n2 = string2.indexOf("aMethod");
        Change change = this.getRefactorChanges(iFile, n, "ooga");
        this.assertTotalChanges(2, change);
        this.assertChange(change, iFile, n, 7, "ooga");
        this.assertChange(change, iFile2, n2, 7, "ooga");
        change = this.getRefactorChanges(iFile2, n2, "ooga");
        this.assertTotalChanges(2, change);
        this.assertChange(change, iFile, n, 7, "ooga");
        this.assertChange(change, iFile2, n2, 7, "ooga");
    }

    public void testMethod_34() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("class Base{              \n");
        stringWriter.write("  virtual void v/*vp1*/()=0;     \n");
        stringWriter.write("};                       \n");
        stringWriter.write("class Derived: Base {    \n");
        stringWriter.write("  void v(){};            \n");
        stringWriter.write("};                       \n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("t.cpp", string);
        int n = string.indexOf("v/*vp1*/");
        Change change = this.getRefactorChanges(iFile, n, "ooga");
        this.assertTotalChanges(1, change);
        this.assertChange(change, iFile, string.indexOf("v/*vp1*/"), 1, "ooga");
    }

    public void failing_testMethod_35_72726() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("class Foo{                               \n");
        stringWriter.write("  Foo& operator *=/*vp1*/(const Foo &rhs);\n");
        stringWriter.write("  Foo& operator==/*vp2*/(const Foo &rhs);\n");
        stringWriter.write("};                                       \n");
        stringWriter.write("Foo& Foo::operator *=(const Foo &rhs){   \n");
        stringWriter.write("  return *this;                          \n");
        stringWriter.write("};                                       \n");
        stringWriter.write("Foo& Foo::operator==(const Foo &rhs){    \n");
        stringWriter.write("  return *this;                          \n");
        stringWriter.write("};                                       \n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("t.cpp", string);
        int n = string.indexOf("operator *=/*vp1*/");
        Change change = this.getRefactorChanges(iFile, n, "operator +=");
        this.assertTotalChanges(2, change);
        this.assertChange(change, iFile, string.indexOf("operator *=/*vp1*/"), 11, "operator +=");
        this.assertChange(change, iFile, string.indexOf("operator *=(const"), 11, "operator +=");
        n = string.indexOf("operator==/*vp2*/");
        change = this.getRefactorChanges(iFile, n, "operator=");
        this.assertTotalChanges(2, change);
        this.assertChange(change, iFile, string.indexOf("operator==/*vp2*/"), 11, "operator=");
        this.assertChange(change, iFile, string.indexOf("operator==(const"), 11, "operator=");
    }

    public void testMethod_39() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("class Foo{                              \n");
        stringWriter.write("  const void*   method1(const char*);   \n");
        stringWriter.write("  const int   method2(int j);           \n");
        stringWriter.write("};                                      \n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("t.hh", string);
        stringWriter = new StringWriter();
        stringWriter.write("#include \"t.hh\"                                             \n");
        stringWriter.write("const void* Foo::method1(const char* x){return (void*) x;}    \n");
        stringWriter.write("const int Foo::method2(int){return 5;}             \n");
        stringWriter.write("void test() {                                      \n");
        stringWriter.write("     Foo d;                                        \n");
        stringWriter.write("     d.method1(\"hello\");                         \n");
        stringWriter.write("     int i =d.method2(3);                          \n");
        stringWriter.write("}                                                  \n");
        String string2 = stringWriter.toString();
        IFile iFile2 = this.importFile("t.cpp", string2);
        int n = string.indexOf("method1");
        Change change = this.getRefactorChanges(iFile, n, "m1");
        this.assertTotalChanges(3, change);
        this.assertChange(change, iFile, string.indexOf("method1"), 7, "m1");
        this.assertChange(change, iFile2, string2.indexOf("method1(const"), 7, "m1");
        this.assertChange(change, iFile2, string2.indexOf("method1(\"hello"), 7, "m1");
        n = string2.indexOf("method2(int");
        change = this.getRefactorChanges(iFile2, n, "m2");
        this.assertTotalChanges(3, change);
        this.assertChange(change, iFile, string.indexOf("method2"), 7, "m2");
        this.assertChange(change, iFile2, string2.indexOf("method2(int"), 7, "m2");
        this.assertChange(change, iFile2, string2.indexOf("method2(3"), 7, "m2");
    }

    public void testMethod_40() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("class Foo{                                   \n");
        stringWriter.write("  static int method1/*vp1*/(const char* x);  \n");
        stringWriter.write("  static int method2/*vp2*/(int);            \n");
        stringWriter.write("};                                           \n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("t.hh", string);
        stringWriter = new StringWriter();
        stringWriter.write("#include \"t.hh\"                             \n");
        stringWriter.write("static int Foo::method1(const char* x){return 5;}  \n");
        stringWriter.write("static int Foo::method2(int x){return (2);}; \n");
        stringWriter.write("void test() {                                \n");
        stringWriter.write("     Foo::method1(\"hello\");                \n");
        stringWriter.write("     int i =Foo::method2(3);                 \n");
        stringWriter.write("}                                            \n");
        String string2 = stringWriter.toString();
        IFile iFile2 = this.importFile("t.cpp", string2);
        int n = string.indexOf("method1/*vp1*/");
        Change change = this.getRefactorChanges(iFile, n, "m1");
        this.assertTotalChanges(3, change);
        this.assertChange(change, iFile, string.indexOf("method1/*vp1*/"), 7, "m1");
        this.assertChange(change, iFile2, string2.indexOf("method1(const"), 7, "m1");
        this.assertChange(change, iFile2, string2.indexOf("method1(\"hello"), 7, "m1");
        n = string2.indexOf("Foo::method2") + 5;
        change = this.getRefactorChanges(iFile2, n, "m2");
        this.assertTotalChanges(3, change);
        this.assertChange(change, iFile, string.indexOf("method2/*vp2*/"), 7, "m2");
        this.assertChange(change, iFile2, string2.indexOf("method2(int x"), 7, "m2");
        this.assertChange(change, iFile2, string2.indexOf("method2(3"), 7, "m2");
    }

    public void testMethod_41() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("class Foo{                                   \n");
        stringWriter.write("public:                                      \n");
        stringWriter.write("  volatile int  method1/*vp1*/(int);         \n");
        stringWriter.write("private:                                     \n");
        stringWriter.write("  int b;                                     \n");
        stringWriter.write("};                                           \n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("t.hh", string);
        stringWriter = new StringWriter();
        stringWriter.write("#include \"t.hh\"                            \n");
        stringWriter.write("volatile int Foo::method1(int x){return (2);};               \n");
        stringWriter.write("void test() {                                \n");
        stringWriter.write("  Foo d;                             \n");
        stringWriter.write("  int i =d.method1(1);                       \n");
        stringWriter.write("}                                            \n");
        String string2 = stringWriter.toString();
        IFile iFile2 = this.importFile("t.cpp", string2);
        int n = string.indexOf("method1/*vp1*/");
        Change change = this.getRefactorChanges(iFile, n, "m1");
        this.assertTotalChanges(3, change);
        this.assertChange(change, iFile, string.indexOf("method1/*vp1*/"), 7, "m1");
        this.assertChange(change, iFile2, string2.indexOf("method1(int x"), 7, "m1");
        this.assertChange(change, iFile2, string2.indexOf("method1(1"), 7, "m1");
    }

    public void testMethod_43() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("class Foo{                                   \n");
        stringWriter.write("public:                                      \n");
        stringWriter.write("  inline void  method1/*vp1*/(int i) {b=i;}  \n");
        stringWriter.write("private:                                     \n");
        stringWriter.write("  int b;                                     \n");
        stringWriter.write("};                                           \n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("t.hh", string);
        stringWriter = new StringWriter();
        stringWriter.write("#include \"t.hh\"                            \n");
        stringWriter.write("void test() {                                \n");
        stringWriter.write("  Foo d;                                    \n");
        stringWriter.write("  d->method1(1);                             \n");
        stringWriter.write("}                                            \n");
        String string2 = stringWriter.toString();
        IFile iFile2 = this.importFile("t.cpp", string2);
        int n = string.indexOf("method1/*vp1*/");
        Change change = this.getRefactorChanges(iFile, n, "m1");
        this.assertTotalChanges(2, change);
        this.assertChange(change, iFile, string.indexOf("method1/*vp1*/"), 7, "m1");
        this.assertChange(change, iFile2, string2.indexOf("method1(1"), 7, "m1");
    }

    public void testMethod_44() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("class Base{              \n");
        stringWriter.write("  virtual void v();      \n");
        stringWriter.write("  int i;                 \n");
        stringWriter.write("};                       \n");
        stringWriter.write("void Base::v(){}         \n");
        stringWriter.write("class Derived: Base {    \n");
        stringWriter.write("  virtual void v/*vp1*/(){}//explicitly virtual          \n");
        stringWriter.write("};                       \n");
        stringWriter.write("class Derived2: Derived {\n");
        stringWriter.write("  void v(){i++;}         \n");
        stringWriter.write("};                       \n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("t.cpp", string);
        int n = string.indexOf("v/*vp1*/");
        String[] stringArray = this.getRefactorMessages(iFile, n, "v2");
        Assert.assertEquals((int)1, (int)stringArray.length);
        Assert.assertEquals((String)"Renaming a virtual method. Consider renaming the base and derived class methods (if any).", (String)stringArray[0]);
    }

    public void testMethod_45() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("class Base{              \n");
        stringWriter.write("  virtual void v();      \n");
        stringWriter.write("  int i;                 \n");
        stringWriter.write("};                       \n");
        stringWriter.write("void Base::v(){}         \n");
        stringWriter.write("class Derived: Base {    \n");
        stringWriter.write("  void v/*vp1*/(){}//implicitly virtual          \n");
        stringWriter.write("};                       \n");
        stringWriter.write("class Derived2: Derived {\n");
        stringWriter.write("  void v(){i++;}         \n");
        stringWriter.write("};                       \n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("t.cpp", string);
        int n = string.indexOf("v/*vp1*/");
        String[] stringArray = this.getRefactorMessages(iFile, n, "v2");
        Assert.assertEquals((int)1, (int)stringArray.length);
        Assert.assertEquals((String)"Renaming a virtual method. Consider renaming the base and derived class methods (if any).", (String)stringArray[0]);
    }

    public void testStruct_46() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("struct st1/*vp1*/{};             \n");
        stringWriter.write("class c1/*vp1*/{                 \n");
        stringWriter.write("  public: struct st2/*vp2*/{} s; \n");
        stringWriter.write("};                               \n");
        stringWriter.write("namespace N{                     \n");
        stringWriter.write(" struct st3/*vp3*/{};            \n");
        stringWriter.write(" class c2/*vp1*/{                \n");
        stringWriter.write("   st1 s;                        \n");
        stringWriter.write("   st3 ss;                       \n");
        stringWriter.write("   c2() {                        \n");
        stringWriter.write("     c1::st2 s;                  \n");
        stringWriter.write("   }                             \n");
        stringWriter.write(" };                              \n");
        stringWriter.write("}                                \n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("t.cpp", string);
        int n = string.indexOf("st1/*vp1*/");
        Change change = this.getRefactorChanges(iFile, n, "Ooga1");
        this.assertTotalChanges(2, change);
        this.assertChange(change, iFile, string.indexOf("st1/*vp1*/"), 3, "Ooga1");
        this.assertChange(change, iFile, string.indexOf("st1 s"), 3, "Ooga1");
        n = string.indexOf("st2/*vp2*/");
        change = this.getRefactorChanges(iFile, n, "Ooga2");
        this.assertTotalChanges(2, change);
        this.assertChange(change, iFile, string.indexOf("st2/*vp2*/"), 3, "Ooga2");
        this.assertChange(change, iFile, string.indexOf("st2 s"), 3, "Ooga2");
        n = string.indexOf("st3/*vp3*/");
        change = this.getRefactorChanges(iFile, n, "Ooga3");
        this.assertTotalChanges(2, change);
        this.assertChange(change, iFile, string.indexOf("st3/*vp3*/"), 3, "Ooga3");
        this.assertChange(change, iFile, string.indexOf("st3 ss"), 3, "Ooga3");
    }

    public void testUnion_47() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("union st1/*vp1*/{};              \n");
        stringWriter.write("class c1/*vp1*/{                 \n");
        stringWriter.write("  public: union st2/*vp2*/{} s;  \n");
        stringWriter.write("};                               \n");
        stringWriter.write("namespace N{                     \n");
        stringWriter.write(" union st3/*vp3*/{};             \n");
        stringWriter.write(" class c2/*vp1*/{                \n");
        stringWriter.write("   st1 s;                        \n");
        stringWriter.write("   st3 ss;                       \n");
        stringWriter.write("   c2() {                        \n");
        stringWriter.write("     c1::st2 s;                  \n");
        stringWriter.write("   }                             \n");
        stringWriter.write(" };                              \n");
        stringWriter.write("}                                \n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("t.cpp", string);
        int n = string.indexOf("st1/*vp1*/");
        Change change = this.getRefactorChanges(iFile, n, "Ooga1");
        this.assertTotalChanges(2, change);
        this.assertChange(change, iFile, string.indexOf("st1/*vp1*/"), 3, "Ooga1");
        this.assertChange(change, iFile, string.indexOf("st1 s"), 3, "Ooga1");
        n = string.indexOf("st2/*vp2*/");
        change = this.getRefactorChanges(iFile, n, "Ooga2");
        this.assertTotalChanges(2, change);
        this.assertChange(change, iFile, string.indexOf("st2/*vp2*/"), 3, "Ooga2");
        this.assertChange(change, iFile, string.indexOf("st2 s"), 3, "Ooga2");
        n = string.indexOf("st3/*vp3*/");
        change = this.getRefactorChanges(iFile, n, "Ooga3");
        this.assertTotalChanges(2, change);
        this.assertChange(change, iFile, string.indexOf("st3/*vp3*/"), 3, "Ooga3");
        this.assertChange(change, iFile, string.indexOf("st3 ss"), 3, "Ooga3");
    }

    public void testEnumeration_48() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("enum e1/*vp1*/{E0};              \n");
        stringWriter.write("class c1 {                       \n");
        stringWriter.write("  public: enum e2/*vp2*/{E1} s;  \n");
        stringWriter.write("};                               \n");
        stringWriter.write("namespace N{                     \n");
        stringWriter.write(" enum e3/*vp3*/{};               \n");
        stringWriter.write(" class c2/*vp1*/{                \n");
        stringWriter.write("   e1 s;                         \n");
        stringWriter.write("   e3 ss;                        \n");
        stringWriter.write("   c2() {                        \n");
        stringWriter.write("     c1::e2 s;                   \n");
        stringWriter.write("   }                             \n");
        stringWriter.write(" };                              \n");
        stringWriter.write("}                                \n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("t.cpp", string);
        int n = string.indexOf("e1/*vp1*/");
        Change change = this.getRefactorChanges(iFile, n, "Ooga1");
        this.assertTotalChanges(2, change);
        this.assertChange(change, iFile, string.indexOf("e1/*vp1*/"), 2, "Ooga1");
        this.assertChange(change, iFile, string.indexOf("e1 s"), 2, "Ooga1");
        n = string.indexOf("e2/*vp2*/");
        change = this.getRefactorChanges(iFile, n, "Ooga2");
        this.assertTotalChanges(2, change);
        this.assertChange(change, iFile, string.indexOf("e2/*vp2*/"), 2, "Ooga2");
        this.assertChange(change, iFile, string.indexOf("e2 s"), 2, "Ooga2");
        n = string.indexOf("e3/*vp3*/");
        change = this.getRefactorChanges(iFile, n, "Ooga3");
        this.assertTotalChanges(2, change);
        this.assertChange(change, iFile, string.indexOf("e3/*vp3*/"), 2, "Ooga3");
        this.assertChange(change, iFile, string.indexOf("e3 ss"), 2, "Ooga3");
    }

    public void testTemplate_49_72626() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("template <class Type>            \n");
        stringWriter.write("class Array/*vp1*/   {           \n");
        stringWriter.write("  public:    Array(){            \n");
        stringWriter.write("   a=new Type[10];               \n");
        stringWriter.write("  }                              \n");
        stringWriter.write("  virtual Type& operator[](int i){return a[i];}  \n");
        stringWriter.write("  protected: Type *a;            \n");
        stringWriter.write("};                               \n");
        stringWriter.write("void f(){                        \n");
        stringWriter.write("   Array <int> a;                 \n");
        stringWriter.write("}                                \n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("t.cpp", string);
        int n = string.indexOf("Array");
        Change change = this.getRefactorChanges(iFile, n, "Arr2");
        this.assertTotalChanges(3, change);
        this.assertChange(change, iFile, n, 5, "Arr2");
        n = string.indexOf("Array", n + 1);
        this.assertChange(change, iFile, n, 5, "Arr2");
        n = string.indexOf("Array", n + 1);
        this.assertChange(change, iFile, n, 5, "Arr2");
    }

    public void testClass_52() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("namespace N1 {           \n");
        stringWriter.write("class Boo{};             \n");
        stringWriter.write("}                        \n");
        stringWriter.write("namespace N2  {          \n");
        stringWriter.write("class Boo/*vp1*/{};      \n");
        stringWriter.write("}                        \n");
        stringWriter.write("void f() {               \n");
        stringWriter.write("   N1::Boo c1;           \n");
        stringWriter.write("   N2::Boo c2;           \n");
        stringWriter.write("}                        \n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("t.cpp", string);
        int n = string.indexOf("Boo/*vp1*/");
        Change change = this.getRefactorChanges(iFile, n, "Ooga");
        this.assertTotalChanges(2, change);
        this.assertChange(change, iFile, string.indexOf("Boo/*vp1*/"), 3, "Ooga");
        this.assertChange(change, iFile, string.indexOf("Boo c2"), 3, "Ooga");
    }

    public void testClass_53() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("class Foo/*vp1*/ {//ren1     \n");
        stringWriter.write("  Foo();//ren2               \n");
        stringWriter.write("  virtual ~Foo();//ren3      \n");
        stringWriter.write("};                           \n");
        stringWriter.write("Foo::Foo() {}//ren4,5        \n");
        stringWriter.write("Foo::~Foo() {}//ren6,7       \n");
        stringWriter.write("void f() {                   \n");
        stringWriter.write("   Foo *f=new Foo();//ren8,9 \n");
        stringWriter.write("   f->~Foo();//ren10         \n");
        stringWriter.write("}                            \n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("t.cpp", string);
        int n = string.indexOf("Foo/*vp1*/");
        Change change = this.getRefactorChanges(iFile, n, "Ooga");
        this.assertTotalChanges(10, change);
        this.assertChange(change, iFile, string.indexOf("Foo/*vp1*/"), 3, "Ooga");
        this.assertChange(change, iFile, string.indexOf("Foo();//ren2"), 3, "Ooga");
        this.assertChange(change, iFile, string.indexOf("Foo();//ren3"), 3, "Ooga");
        this.assertChange(change, iFile, string.indexOf("Foo::Foo() {}//ren4,5"), 3, "Ooga");
        this.assertChange(change, iFile, string.indexOf("Foo() {}//ren4,5"), 3, "Ooga");
        this.assertChange(change, iFile, string.indexOf("Foo::~Foo() {}//ren6,7"), 3, "Ooga");
        this.assertChange(change, iFile, string.indexOf("Foo() {}//ren6,7"), 3, "Ooga");
        this.assertChange(change, iFile, string.indexOf("Foo *f=new Foo();//ren8,9"), 3, "Ooga");
        this.assertChange(change, iFile, string.indexOf("Foo();//ren8,9"), 3, "Ooga");
        this.assertChange(change, iFile, string.indexOf("Foo();//ren10"), 3, "Ooga");
    }

    public void testAttribute_54() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("class Boo{                   \n");
        stringWriter.write("  static int att;//vp1,rn1   \n");
        stringWriter.write("};                           \n");
        stringWriter.write("void f() {                   \n");
        stringWriter.write("   Boo a;                    \n");
        stringWriter.write("   a.att;//rn2               \n");
        stringWriter.write("   Boo::att;//rn3            \n");
        stringWriter.write("}                            \n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("t.cpp", string);
        int n = string.indexOf("att;//vp1");
        Change change = this.getRefactorChanges(iFile, n, "ooga");
        this.assertTotalChanges(3, change);
        this.assertChange(change, iFile, string.indexOf("att;//vp1"), 3, "ooga");
        this.assertChange(change, iFile, string.indexOf("att;//rn2"), 3, "ooga");
        this.assertChange(change, iFile, string.indexOf("att;//rn3"), 3, "ooga");
    }

    public void testClass_55() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("class Foo{           \n");
        stringWriter.write("  class Hoo{//vp1    \n");
        stringWriter.write("     public: Hoo();  \n");
        stringWriter.write("  };                 \n");
        stringWriter.write("  Foo(){             \n");
        stringWriter.write("     Foo::Hoo h;     \n");
        stringWriter.write("  }                  \n");
        stringWriter.write("};                   \n");
        stringWriter.write("Foo::Hoo::Hoo(){}    \n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("t.cpp", string);
        int n = string.indexOf("Hoo{");
        Change change = this.getRefactorChanges(iFile, n, "ooga");
        this.assertTotalChanges(5, change);
        this.assertChange(change, iFile, string.indexOf("Hoo{//vp1"), 3, "ooga");
        this.assertChange(change, iFile, string.indexOf("Hoo();"), 3, "ooga");
        this.assertChange(change, iFile, string.indexOf("Hoo h;"), 3, "ooga");
        this.assertChange(change, iFile, string.indexOf("Hoo::Hoo(){}"), 3, "ooga");
        this.assertChange(change, iFile, string.indexOf("Hoo(){}"), 3, "ooga");
    }

    public void testClass_55_79231() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("class Boo{};//vp1            \n");
        stringWriter.write("class Foo{               \n");
        stringWriter.write("   Foo() {               \n");
        stringWriter.write("     class Boo{};        \n");
        stringWriter.write("     Boo t;              \n");
        stringWriter.write("     }                   \n");
        stringWriter.write("};                       \n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("t.cpp", string);
        int n = string.indexOf("Boo{};//vp1");
        Change change = this.getRefactorChanges(iFile, n, "Ooga");
        this.assertTotalChanges(1, change);
        this.assertChange(change, iFile, string.indexOf("Boo{};//vp1"), 3, "Ooga");
    }

    public void testClass_55_72748() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("class Foo{};//vp1            \n");
        stringWriter.write("void f(){                \n");
        stringWriter.write("  Foo *somePtr;                  \n");
        stringWriter.write("  if (somePtr == reinterpret_cast<Foo*>(0)){}                \n");
        stringWriter.write("}                        \n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("t.cpp", string);
        int n = string.indexOf("Foo{};//vp1");
        Change change = this.getRefactorChanges(iFile, n, "Ooga");
        this.assertTotalChanges(3, change);
        this.assertChange(change, iFile, string.indexOf("Foo{};//vp1"), 3, "Ooga");
        this.assertChange(change, iFile, string.indexOf("Foo *somePtr"), 3, "Ooga");
        this.assertChange(change, iFile, string.indexOf("Foo*>(0)"), 3, "Ooga");
    }

    public void testClass_56() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("class Foo{};//vp1,rn1            \n");
        stringWriter.write("class Derived: public Foo{//rn2  \n");
        stringWriter.write("  Derived():Foo(){}//rn3         \n");
        stringWriter.write("};                               \n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("t.cpp", string);
        int n = string.indexOf("Foo{};//vp1");
        Change change = this.getRefactorChanges(iFile, n, "Ooga");
        this.assertTotalChanges(3, change);
        this.assertChange(change, iFile, string.indexOf("Foo{};//vp1"), 3, "Ooga");
        this.assertChange(change, iFile, string.indexOf("Foo{//rn2"), 3, "Ooga");
        this.assertChange(change, iFile, string.indexOf("Foo(){}//rn3"), 3, "Ooga");
    }

    public void testAttribute_61() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("class Foo{       \n");
        stringWriter.write(" private: static int count;//vp1     \n");
        stringWriter.write("};       \n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("Foo.hh", string);
        stringWriter = new StringWriter();
        stringWriter.write("#include \"Foo.hh\"                   \n");
        stringWriter.write("int Foo::count=10;                           \n");
        String string2 = stringWriter.toString();
        IFile iFile2 = this.importFile("Foo.cpp", string2);
        int n = string.indexOf("count");
        Change change = this.getRefactorChanges(iFile, n, "ooga");
        this.assertTotalChanges(2, change);
        this.assertChange(change, iFile, string.indexOf("count"), 5, "ooga");
        this.assertChange(change, iFile2, string2.indexOf("count"), 5, "ooga");
    }

    public void testEnumerator_62() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("enum Foo{E0, E1};//vp1       \n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("Foo.hh", string);
        stringWriter = new StringWriter();
        stringWriter.write("#include \"Foo.hh\"                   \n");
        stringWriter.write("void f() {                           \n");
        stringWriter.write(" int i=E1;                   \n");
        stringWriter.write("}                            \n");
        String string2 = stringWriter.toString();
        IFile iFile2 = this.importFile("Foo.cpp", string2);
        int n = string.indexOf("E1");
        this.getRefactorChanges(iFile, n, "Ooga");
        Change change = this.getRefactorChanges(iFile, n, "ooga");
        this.assertTotalChanges(2, change);
        this.assertChange(change, iFile, string.indexOf("E1"), 2, "ooga");
        this.assertChange(change, iFile2, string2.indexOf("E1"), 2, "ooga");
    }

    public void testAttribute_63() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("class Foo{       \n");
        stringWriter.write(" int att;        \n");
        stringWriter.write(" Foo(int i);     \n");
        stringWriter.write("};       \n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("Foo.hh", string);
        stringWriter = new StringWriter();
        stringWriter.write("#include \"Foo.hh\"                   \n");
        stringWriter.write("Foo::Foo(int i): att(i) {}                           \n");
        String string2 = stringWriter.toString();
        IFile iFile2 = this.importFile("Foo.cpp", string2);
        int n = string.indexOf("att");
        Change change = this.getRefactorChanges(iFile, n, "ooga");
        this.assertTotalChanges(2, change);
        this.assertChange(change, iFile, string.indexOf("att"), 3, "ooga");
        this.assertChange(change, iFile2, string2.indexOf("att"), 3, "ooga");
    }

    public void testAttribute_64() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("class Foo{               \n");
        stringWriter.write("   private:              \n");
        stringWriter.write("   int b;//vp1,rn1       \n");
        stringWriter.write("   int m(int b) {        \n");
        stringWriter.write("         return b;       \n");
        stringWriter.write("   }                     \n");
        stringWriter.write("   int n() {             \n");
        stringWriter.write("         return b;//rn2  \n");
        stringWriter.write("   }                     \n");
        stringWriter.write("   int o() {             \n");
        stringWriter.write("         int b=2;        \n");
        stringWriter.write("   return b;             \n");
        stringWriter.write(" }                       \n");
        stringWriter.write("};                       \n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("Foo.hh", string);
        int n = string.indexOf("b;//vp1");
        Change change = this.getRefactorChanges(iFile, n, "ooga");
        this.assertTotalChanges(2, change);
        this.assertChange(change, iFile, string.indexOf("b;//vp1"), 1, "ooga");
        this.assertChange(change, iFile, string.indexOf("b;//rn2"), 1, "ooga");
    }

    public void testAttribute_65() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("class A{             \n");
        stringWriter.write("    int x();         \n");
        stringWriter.write("};                   \n");
        stringWriter.write("class B{             \n");
        stringWriter.write("    friend class A;  \n");
        stringWriter.write("    private:         \n");
        stringWriter.write("    int att;         \n");
        stringWriter.write("};                   \n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("Foo.hh", string);
        stringWriter = new StringWriter();
        stringWriter.write("#include \"Foo.hh\"   \n");
        stringWriter.write("int A::x() {         \n");
        stringWriter.write(" B b;                \n");
        stringWriter.write(" int att=b.att;      \n");
        stringWriter.write("}                    \n");
        String string2 = stringWriter.toString();
        IFile iFile2 = this.importFile("Foo.cpp", string2);
        int n = string.indexOf("att");
        Change change = this.getRefactorChanges(iFile, n, "ooga");
        this.assertTotalChanges(2, change);
        this.assertChange(change, iFile, string.indexOf("att"), 3, "ooga");
        this.assertChange(change, iFile2, string2.indexOf("att;"), 3, "ooga");
    }

    public void testNamespace_66() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("namespace Foo/*vp1*/{            \n");
        stringWriter.write(" namespace Baz/*vp2*/ {          \n");
        stringWriter.write("   int i;                \n");
        stringWriter.write(" }                       \n");
        stringWriter.write(" using namespace Baz;    \n");
        stringWriter.write("}                        \n");
        stringWriter.write("void f() {               \n");
        stringWriter.write("  Foo::i = 1;            \n");
        stringWriter.write("}                        \n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("t.cpp", string);
        int n = string.indexOf("Foo/*vp1*/");
        Change change = this.getRefactorChanges(iFile, n, "Ooga");
        this.assertTotalChanges(2, change);
        this.assertChange(change, iFile, string.indexOf("Foo/*vp1*/"), 3, "Ooga");
        this.assertChange(change, iFile, string.indexOf("Foo::"), 3, "Ooga");
        n = string.indexOf("Baz/*vp2*/");
        change = this.getRefactorChanges(iFile, n, "Wooga");
        this.assertTotalChanges(2, change);
        this.assertChange(change, iFile, string.indexOf("Baz/*vp2*/"), 3, "Wooga");
        this.assertChange(change, iFile, string.indexOf("Baz;"), 3, "Wooga");
    }

    public void testNamespace_66_79281() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("namespace Foo{           \n");
        stringWriter.write(" int i;                  \n");
        stringWriter.write("}                        \n");
        stringWriter.write("namespace Bar/*vp1*/ = Foo;      \n");
        stringWriter.write("void f() {               \n");
        stringWriter.write("  Bar::i = 1;            \n");
        stringWriter.write("}                        \n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("t.cpp", string);
        int n = string.indexOf("Bar/*vp1*/");
        Change change = this.getRefactorChanges(iFile, n, "Ooga");
        this.assertTotalChanges(2, change);
        this.assertChange(change, iFile, string.indexOf("Bar/*vp1*/"), 3, "Ooga");
        this.assertChange(change, iFile, string.indexOf("Bar::"), 3, "Ooga");
    }

    public void testNamespace_66_79282() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("namespace Foo/*vp1*/{}           \n");
        stringWriter.write("namespace Bar = Foo;     \n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("t.cpp", string);
        int n = string.indexOf("Foo/*vp1*/");
        Change change = this.getRefactorChanges(iFile, n, "Ooga");
        this.assertTotalChanges(2, change);
        this.assertChange(change, iFile, string.indexOf("Foo/*vp1*/"), 3, "Ooga");
        this.assertChange(change, iFile, string.indexOf("Foo;"), 3, "Ooga");
    }

    public void testFunction_67() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("void foo/*vp1*/(){}//rn1     \n");
        stringWriter.write("void bar(){                  \n");
        stringWriter.write("  foo();//rn2                \n");
        stringWriter.write("}                            \n");
        stringWriter.write("namespace N{                 \n");
        stringWriter.write("  class A{                   \n");
        stringWriter.write("  A() {foo();}//rn3          \n");
        stringWriter.write("  };                         \n");
        stringWriter.write("}                            \n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("t.cpp", string);
        int n = string.indexOf("foo/*vp1*/");
        Change change = this.getRefactorChanges(iFile, n, "ooga");
        this.assertTotalChanges(3, change);
        this.assertChange(change, iFile, string.indexOf("foo/*vp1*/"), 3, "ooga");
        this.assertChange(change, iFile, string.indexOf("foo();//rn2"), 3, "ooga");
        this.assertChange(change, iFile, string.indexOf("foo();}//rn3"), 3, "ooga");
    }

    public void testVariable_68() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("class A{                 \n");
        stringWriter.write("  public: int i;         \n");
        stringWriter.write("};                       \n");
        stringWriter.write("A var;//vp1,rn1          \n");
        stringWriter.write("void f(){                \n");
        stringWriter.write("  int j = ::var.i;//rn2  \n");
        stringWriter.write("}                        \n");
        stringWriter.write("class B{                 \n");
        stringWriter.write("  void g(){              \n");
        stringWriter.write("    var.i=3;//rn3        \n");
        stringWriter.write("  }                      \n");
        stringWriter.write("};                       \n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("t.cpp", string);
        int n = string.indexOf("var;//vp1");
        Change change = this.getRefactorChanges(iFile, n, "ooga");
        this.assertTotalChanges(3, change);
        this.assertChange(change, iFile, string.indexOf("var;//vp1"), 3, "ooga");
        this.assertChange(change, iFile, string.indexOf("var.i;//rn2"), 3, "ooga");
        this.assertChange(change, iFile, string.indexOf("var.i=3;//rn3"), 3, "ooga");
    }

    public void testVariable_68_79295() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("int var;//vp1            \n");
        stringWriter.write("void f(int var){         \n");
        stringWriter.write("  int i = var;           \n");
        stringWriter.write("}                        \n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("t.cpp", string);
        int n = string.indexOf("var;//vp1");
        Change change = this.getRefactorChanges(iFile, n, "ooga");
        this.assertTotalChanges(1, change);
        this.assertChange(change, iFile, string.indexOf("var;//vp1"), 3, "ooga");
    }

    public void testClass_81_72620() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("union u_haul{};      \n");
        stringWriter.write("struct s_haul{};     \n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("t.cpp", string);
        int n = string.indexOf("s_haul");
        try {
            this.getRefactorChanges(iFile, n, "u_haul");
        }
        catch (AssertionFailedError assertionFailedError) {
            Assert.assertTrue((boolean)assertionFailedError.getMessage().startsWith("Input check on u_haul failed."));
            return;
        }
        Assert.fail((String)"An error should have occurred in the input check.");
    }

    public void testVariable_88_72617() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("class A{};               \n");
        stringWriter.write("A a;//vp1                \n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("Foo.hh", string);
        stringWriter = new StringWriter();
        stringWriter.write("#include \"Foo.hh\"   \n");
        stringWriter.write("void f() {           \n");
        stringWriter.write(" A a;                \n");
        stringWriter.write("}                    \n");
        String string2 = stringWriter.toString();
        this.importFile("Foo.cpp", string2);
        int n = string.indexOf("a;//vp1");
        Change change = this.getRefactorChanges(iFile, n, "ooga");
        this.assertTotalChanges(1, change);
        this.assertChange(change, iFile, string.indexOf("a;//vp1"), 1, "ooga");
    }

    public void testClass_92A() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("class Boo{};         \n");
        stringWriter.write("  void f() {}        \n");
        stringWriter.write("};                   \n");
        stringWriter.write("class Foo/*vp1*/{};  \n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("t.cpp", string);
        int n = string.indexOf("Foo/*vp1*/");
        try {
            this.getRefactorChanges(iFile, n, "Boo");
        }
        catch (AssertionFailedError assertionFailedError) {
            Assert.assertTrue((boolean)assertionFailedError.getMessage().startsWith("Input check on Boo failed."));
            return;
        }
        Assert.fail((String)"An error or warning should have occurred in the input check.");
    }

    public void testClass_92B() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("class A{};           \n");
        stringWriter.write("class B{};//vp1      \n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("t.cpp", string);
        int n = string.indexOf("B{};//vp1");
        String[] stringArray = this.getRefactorMessages(iFile, n, "A");
        Assert.assertEquals((int)1, (int)stringArray.length);
        Assert.assertEquals((String)"'A' will redeclare a type.", (String)stringArray[0]);
        int n2 = this.getRefactorSeverity(iFile, n, "A");
        Assert.assertEquals((int)3, (int)n2);
    }

    public void testRenameParticipant() throws Exception {
        TestRenameParticipant.reset();
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("class A{}; ");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("t.cpp", string);
        int n = string.indexOf("A");
        this.getRefactorChanges(iFile, n, "B");
        Assert.assertEquals((int)1, (int)TestRenameParticipant.getConditionCheckCount());
        Assert.assertEquals((int)1, (int)TestRenameParticipant.getCreateChangeCount());
        Object object = TestRenameParticipant.getElement();
        Assert.assertNotNull((Object)object);
        Assert.assertTrue((boolean)(object instanceof IBinding));
        IBinding iBinding = (IBinding)object;
        Assert.assertEquals((String)iBinding.getName(), (String)"A");
        RenameArguments renameArguments = TestRenameParticipant.staticGetArguments();
        Assert.assertNotNull((Object)renameArguments);
        Assert.assertEquals((String)"B", (String)renameArguments.getNewName());
    }
}

