/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.cdescriptor.tests;

import junit.extensions.TestSetup;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.CDescriptorEvent;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.core.ICDescriptorListener;
import org.eclipse.cdt.core.ICExtensionReference;
import org.eclipse.cdt.core.ICOwnerInfo;
import org.eclipse.cdt.core.testplugin.CTestPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class CDescriptorTests
extends TestCase {
    static String projectId = "org.eclipse.cdt.core.tests.TestProject";
    static IProject fProject;
    static CDescriptorListener listener;
    static CDescriptorEvent fLastEvent;
    static /* synthetic */ Class class$0;

    static {
        listener = new CDescriptorListener();
    }

    public CDescriptorTests(String string) {
        super(string);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.core.cdescriptor.tests.CDescriptorTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite testSuite = new TestSuite(clazz.getName());
        testSuite.addTest((Test)new CDescriptorTests("testDescriptorCreation"));
        testSuite.addTest((Test)new CDescriptorTests("testDescriptorOwner"));
        testSuite.addTest((Test)new CDescriptorTests("testExtensionCreation"));
        testSuite.addTest((Test)new CDescriptorTests("testExtensionGet"));
        testSuite.addTest((Test)new CDescriptorTests("testExtensionData"));
        testSuite.addTest((Test)new CDescriptorTests("testExtensionRemove"));
        testSuite.addTest((Test)new CDescriptorTests("testProjectDataCreate"));
        testSuite.addTest((Test)new CDescriptorTests("testProjectDataDelete"));
        TestSetup testSetup = new TestSetup((Test)testSuite){

            protected void setUp() throws Exception {
                CDescriptorTests.oneTimeSetUp();
            }

            protected void tearDown() throws Exception {
                CDescriptorTests.oneTimeTearDown();
            }
        };
        return testSetup;
    }

    private static void addNatureToProject(IProject iProject, String string, IProgressMonitor iProgressMonitor) throws CoreException {
        IProjectDescription iProjectDescription = iProject.getDescription();
        String[] stringArray = iProjectDescription.getNatureIds();
        String[] stringArray2 = new String[stringArray.length + 1];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        stringArray2[stringArray.length] = string;
        iProjectDescription.setNatureIds(stringArray2);
        iProject.setDescription(iProjectDescription, iProgressMonitor);
    }

    static void oneTimeSetUp() throws Exception {
        CTestPlugin.getWorkspace().run(new IWorkspaceRunnable(){

            public void run(IProgressMonitor iProgressMonitor) throws CoreException {
                IWorkspaceRoot iWorkspaceRoot = CTestPlugin.getWorkspace().getRoot();
                IProject iProject = iWorkspaceRoot.getProject("testDescriptorProject");
                if (!iProject.exists()) {
                    iProject.create(null);
                } else {
                    iProject.refreshLocal(2, null);
                }
                if (!iProject.isOpen()) {
                    iProject.open(null);
                }
                CCorePlugin.getDefault().getCDescriptorManager().addDescriptorListener((ICDescriptorListener)listener);
                if (!iProject.hasNature("org.eclipse.cdt.core.cnature")) {
                    CDescriptorTests.addNatureToProject(iProject, "org.eclipse.cdt.core.cnature", null);
                }
                fProject = iProject;
            }
        }, null);
    }

    static void oneTimeTearDown() throws Exception {
        fProject.delete(true, true, null);
    }

    public void testDescriptorCreation() throws Exception {
        CTestPlugin.getWorkspace().run(new IWorkspaceRunnable(){

            public void run(IProgressMonitor iProgressMonitor) throws CoreException {
                CCorePlugin.getDefault().mapCProjectOwner(fProject, projectId, false);
            }
        }, null);
        ICDescriptor iCDescriptor = CCorePlugin.getDefault().getCProjectDescription(fProject, true);
        Assert.assertNotNull((Object)fLastEvent);
        Assert.assertEquals((Object)fLastEvent.getDescriptor(), (Object)iCDescriptor);
        Assert.assertEquals((int)fLastEvent.getType(), (int)2);
        Assert.assertEquals((int)fLastEvent.getFlags(), (int)0);
        fLastEvent = null;
        Assert.assertEquals((Object)fProject, (Object)iCDescriptor.getProject());
        Assert.assertEquals((String)"*", (String)iCDescriptor.getPlatform());
    }

    public void testDescriptorOwner() throws Exception {
        ICDescriptor iCDescriptor = CCorePlugin.getDefault().getCProjectDescription(fProject, true);
        ICOwnerInfo iCOwnerInfo = iCDescriptor.getProjectOwner();
        Assert.assertEquals((String)projectId, (String)iCOwnerInfo.getID());
        Assert.assertEquals((String)"*", (String)iCOwnerInfo.getPlatform());
        Assert.assertEquals((String)"C/C++ Test Project", (String)iCOwnerInfo.getName());
    }

    public void testDescriptorConversion() {
    }

    public void testExtensionCreation() throws Exception {
        ICDescriptor iCDescriptor = CCorePlugin.getDefault().getCProjectDescription(fProject, true);
        ICExtensionReference iCExtensionReference = iCDescriptor.create("org.eclipse.cdt.testextension", "org.eclipse.cdt.testextensionID");
        Assert.assertNotNull((Object)fLastEvent);
        Assert.assertEquals((Object)fLastEvent.getDescriptor(), (Object)iCDescriptor);
        Assert.assertEquals((int)fLastEvent.getType(), (int)1);
        Assert.assertEquals((int)fLastEvent.getFlags(), (int)32);
        fLastEvent = null;
        Assert.assertEquals((String)"org.eclipse.cdt.testextension", (String)iCExtensionReference.getExtension());
        Assert.assertEquals((String)"org.eclipse.cdt.testextensionID", (String)iCExtensionReference.getID());
    }

    public void testExtensionGet() throws Exception {
        ICDescriptor iCDescriptor = CCorePlugin.getDefault().getCProjectDescription(fProject, true);
        ICExtensionReference[] iCExtensionReferenceArray = iCDescriptor.get("org.eclipse.cdt.testextension");
        Assert.assertEquals((String)"org.eclipse.cdt.testextension", (String)iCExtensionReferenceArray[0].getExtension());
        Assert.assertEquals((String)"org.eclipse.cdt.testextensionID", (String)iCExtensionReferenceArray[0].getID());
    }

    public void testExtensionData() throws Exception {
        ICDescriptor iCDescriptor = CCorePlugin.getDefault().getCProjectDescription(fProject, true);
        ICExtensionReference[] iCExtensionReferenceArray = iCDescriptor.get("org.eclipse.cdt.testextension");
        iCExtensionReferenceArray[0].setExtensionData("testKey", "testValue");
        Assert.assertNotNull((Object)fLastEvent);
        Assert.assertEquals((Object)fLastEvent.getDescriptor(), (Object)iCDescriptor);
        Assert.assertEquals((int)fLastEvent.getType(), (int)1);
        Assert.assertEquals((int)fLastEvent.getFlags(), (int)0);
        fLastEvent = null;
        Assert.assertEquals((String)"testValue", (String)iCExtensionReferenceArray[0].getExtensionData("testKey"));
        iCExtensionReferenceArray[0].setExtensionData("testKey", null);
        Assert.assertEquals(null, (String)iCExtensionReferenceArray[0].getExtensionData("testKey"));
    }

    public void testExtensionRemove() throws Exception {
        ICDescriptor iCDescriptor = CCorePlugin.getDefault().getCProjectDescription(fProject, true);
        ICExtensionReference[] iCExtensionReferenceArray = iCDescriptor.get("org.eclipse.cdt.testextension");
        iCDescriptor.remove(iCExtensionReferenceArray[0]);
        Assert.assertNotNull((Object)fLastEvent);
        Assert.assertEquals((Object)fLastEvent.getDescriptor(), (Object)iCDescriptor);
        Assert.assertEquals((int)fLastEvent.getType(), (int)1);
        Assert.assertEquals((int)fLastEvent.getFlags(), (int)32);
        fLastEvent = null;
    }

    public void testProjectDataCreate() throws Exception {
        ICDescriptor iCDescriptor = CCorePlugin.getDefault().getCProjectDescription(fProject, true);
        Element element = iCDescriptor.getProjectData("testElement");
        element.appendChild(element.getOwnerDocument().createElement("test"));
        iCDescriptor.saveProjectData();
        Assert.assertNotNull((Object)fLastEvent);
        Assert.assertEquals((Object)fLastEvent.getDescriptor(), (Object)iCDescriptor);
        Assert.assertEquals((int)fLastEvent.getType(), (int)1);
        Assert.assertEquals((int)fLastEvent.getFlags(), (int)0);
        fLastEvent = null;
    }

    public void testProjectDataDelete() throws Exception {
        ICDescriptor iCDescriptor = CCorePlugin.getDefault().getCProjectDescription(fProject, true);
        Element element = iCDescriptor.getProjectData("testElement");
        NodeList nodeList = element.getElementsByTagName("test");
        Assert.assertEquals((int)1, (int)nodeList.getLength());
        element.removeChild(element.getFirstChild());
        iCDescriptor.saveProjectData();
        Assert.assertNotNull((Object)fLastEvent);
        Assert.assertEquals((Object)fLastEvent.getDescriptor(), (Object)iCDescriptor);
        Assert.assertEquals((int)fLastEvent.getType(), (int)1);
        Assert.assertEquals((int)fLastEvent.getFlags(), (int)0);
        fLastEvent = null;
    }

    public static class CDescriptorListener
    implements ICDescriptorListener {
        public void descriptorChanged(CDescriptorEvent cDescriptorEvent) {
            fLastEvent = cDescriptorEvent;
        }
    }
}

