/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.model.tests;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.core.ICDescriptorOperation;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.testplugin.CProjectHelper;
import org.eclipse.cdt.core.testplugin.CTestPlugin;
import org.eclipse.cdt.core.testplugin.util.ExpectedStrings;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;

public class BinaryTests
extends TestCase {
    IWorkspace workspace;
    IWorkspaceRoot root;
    ICProject testProject;
    IFile cfile;
    IFile exefile;
    IFile libfile;
    IFile archfile;
    IFile objfile;
    IFile bigexe;
    IFile ppcexefile;
    IFile ndexe;
    Path cpath;
    Path exepath;
    Path libpath;
    Path archpath;
    Path objpath;
    NullProgressMonitor monitor;
    static /* synthetic */ Class class$0;

    public BinaryTests(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        this.workspace = ResourcesPlugin.getWorkspace();
        this.root = this.workspace.getRoot();
        this.monitor = new NullProgressMonitor();
        if (this.workspace == null) {
            Assert.fail((String)"Workspace was not setup");
        }
        if (this.root == null) {
            Assert.fail((String)"Workspace root was not setup");
        }
        this.testProject = CProjectHelper.createCProject("filetest", "none");
        ICDescriptorOperation iCDescriptorOperation = new ICDescriptorOperation(){

            public void execute(ICDescriptor iCDescriptor, IProgressMonitor iProgressMonitor) throws CoreException {
                iCDescriptor.remove("org.eclipse.cdt.core.BinaryParser");
                iCDescriptor.create("org.eclipse.cdt.core.BinaryParser", "org.eclipse.cdt.core.GNU_ELF");
            }
        };
        CCorePlugin.getDefault().getCDescriptorManager().runDescriptorOperation(this.testProject.getProject(), iCDescriptorOperation, null);
        if (this.testProject == null) {
            Assert.fail((String)"Unable to create project");
        }
        this.cfile = this.testProject.getProject().getFile("exetest.c");
        if (!this.cfile.exists()) {
            this.cfile.create((InputStream)new FileInputStream(CTestPlugin.getDefault().getFileInPlugin((IPath)new Path("resources/exe/main.c"))), false, (IProgressMonitor)this.monitor);
        }
        this.cpath = new Path(this.workspace.getRoot().getLocation() + "/filetest/main.c");
        this.objfile = this.testProject.getProject().getFile("exetest.o");
        if (!this.objfile.exists()) {
            this.objfile.create((InputStream)new FileInputStream(CTestPlugin.getDefault().getFileInPlugin((IPath)new Path("resources/exe/x86/o.g/main.o"))), false, (IProgressMonitor)this.monitor);
        }
        this.objpath = new Path(this.workspace.getRoot().getLocation() + "/filetest/exetest.o");
        this.exefile = this.testProject.getProject().getFile("test_g");
        if (!this.exefile.exists()) {
            this.exefile.create((InputStream)new FileInputStream(CTestPlugin.getDefault().getFileInPlugin((IPath)new Path("resources/exe/x86/o.g/exe_g"))), false, (IProgressMonitor)this.monitor);
        }
        this.exepath = new Path(this.workspace.getRoot().getLocation() + "/filetest/exe_g");
        this.ppcexefile = this.testProject.getProject().getFile("ppctest_g");
        if (!this.ppcexefile.exists()) {
            this.ppcexefile.create((InputStream)new FileInputStream(CTestPlugin.getDefault().getFileInPlugin((IPath)new Path("resources/exe/ppc/be.g/exe_g"))), false, (IProgressMonitor)this.monitor);
        }
        this.ndexe = this.testProject.getProject().getFile("exetest");
        if (!this.ndexe.exists()) {
            this.ndexe.create((InputStream)new FileInputStream(CTestPlugin.getDefault().getFileInPlugin((IPath)new Path("resources/exe/x86/o/exe"))), false, (IProgressMonitor)this.monitor);
        }
        this.bigexe = this.testProject.getProject().getFile("exebig_g");
        if (!this.bigexe.exists()) {
            this.bigexe.create((InputStream)new FileInputStream(CTestPlugin.getDefault().getFileInPlugin((IPath)new Path("resources/exebig/x86/o.g/exebig_g"))), false, (IProgressMonitor)this.monitor);
        }
        this.archfile = this.testProject.getProject().getFile("libtestlib_g.a");
        if (!this.archfile.exists()) {
            this.archfile.create((InputStream)new FileInputStream(CTestPlugin.getDefault().getFileInPlugin((IPath)new Path("resources/testlib/x86/a.g/libtestlib_g.a"))), false, (IProgressMonitor)this.monitor);
        }
        this.libpath = new Path(this.workspace.getRoot().getLocation() + "/filetest/libtestlib_g.so");
        this.libfile = this.testProject.getProject().getFile("libtestlib_g.so");
        if (!this.libfile.exists()) {
            this.libfile.create((InputStream)new FileInputStream(CTestPlugin.getDefault().getFileInPlugin((IPath)new Path("resources/testlib/x86/so.g/libtestlib_g.so"))), false, (IProgressMonitor)this.monitor);
        }
        this.archpath = new Path(this.workspace.getRoot().getLocation() + "/filetest/libtestlib_g.a");
    }

    protected void tearDown() throws CoreException, InterruptedException {
        System.gc();
        System.runFinalization();
        CProjectHelper.delete(this.testProject);
    }

    public static TestSuite suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.core.model.tests.BinaryTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)BinaryTests.suite());
    }

    public void testGetChildren() throws CoreException, FileNotFoundException {
        String[] stringArray = new String[]{"_init", "_start", "_btext"};
        ExpectedStrings expectedStrings = new ExpectedStrings(stringArray);
        IBinary iBinary = CProjectHelper.findBinary(this.testProject, "test_g");
        ICElement[] iCElementArray = iBinary.getChildren();
        int n = 0;
        while (n < iCElementArray.length) {
            expectedStrings.foundString(iCElementArray[n].getElementName());
            ++n;
        }
        Assert.assertTrue((String)expectedStrings.getMissingString(), (boolean)expectedStrings.gotAll());
    }

    public void testGetBss() throws CModelException {
        IBinary iBinary = CProjectHelper.findBinary(this.testProject, "exebig_g");
        IBinary iBinary2 = CProjectHelper.findBinary(this.testProject, "test_g");
        Assert.assertTrue((String)("Expected 432, Got: " + iBinary.getBSS()), (iBinary.getBSS() == 432L ? 1 : 0) != 0);
        Assert.assertTrue((String)("Expected 4, Got: " + iBinary2.getBSS()), (iBinary2.getBSS() == 4L ? 1 : 0) != 0);
    }

    public void testGetData() throws CModelException {
        IBinary iBinary = CProjectHelper.findBinary(this.testProject, "exebig_g");
        IBinary iBinary2 = CProjectHelper.findBinary(this.testProject, "test_g");
        Assert.assertTrue((String)("Expected 256 Got: " + iBinary.getData()), (iBinary.getData() == 256L ? 1 : 0) != 0);
        Assert.assertTrue((String)("Expected 196, Got: " + iBinary2.getData()), (iBinary2.getData() == 196L ? 1 : 0) != 0);
    }

    public void testGetCpu() throws CModelException {
        IBinary iBinary = CProjectHelper.findBinary(this.testProject, "exebig_g");
        Assert.assertTrue((String)("Expected: x86  Got: " + iBinary.getCPU()), (boolean)iBinary.getCPU().equals("x86"));
        iBinary = CProjectHelper.findBinary(this.testProject, this.ppcexefile.getLocation().lastSegment());
        Assert.assertTrue((String)("Expected: ppc  Got: " + iBinary.getCPU()), (boolean)iBinary.getCPU().equals("ppc"));
    }

    public void testGetNeededSharedLibs() throws CModelException {
        String[] stringArray = new String[]{"libsocket.so.2", "libc.so.2"};
        String[] stringArray2 = new String[]{"libc.so.2"};
        ExpectedStrings expectedStrings = new ExpectedStrings(stringArray);
        IBinary iBinary = CProjectHelper.findBinary(this.testProject, "test_g");
        String[] stringArray3 = iBinary.getNeededSharedLibs();
        int n = 0;
        while (n < stringArray3.length) {
            expectedStrings.foundString(stringArray3[n]);
            ++n;
        }
        Assert.assertTrue((String)expectedStrings.getMissingString(), (boolean)expectedStrings.gotAll());
        Assert.assertTrue((String)expectedStrings.getExtraString(), (!expectedStrings.gotExtra() ? 1 : 0) != 0);
        expectedStrings = new ExpectedStrings(stringArray2);
        iBinary = CProjectHelper.findBinary(this.testProject, "exebig_g");
        stringArray3 = iBinary.getNeededSharedLibs();
        n = 0;
        while (n < stringArray3.length) {
            expectedStrings.foundString(stringArray3[n]);
            ++n;
        }
        Assert.assertTrue((String)expectedStrings.getMissingString(), (boolean)expectedStrings.gotAll());
        Assert.assertTrue((String)expectedStrings.getExtraString(), (!expectedStrings.gotExtra() ? 1 : 0) != 0);
        expectedStrings = new ExpectedStrings(stringArray2);
        iBinary = CProjectHelper.findBinary(this.testProject, "libtestlib_g.so");
        stringArray3 = iBinary.getNeededSharedLibs();
        n = 0;
        while (n < stringArray3.length) {
            expectedStrings.foundString(stringArray3[n]);
            ++n;
        }
        Assert.assertTrue((String)expectedStrings.getMissingString(), (boolean)expectedStrings.gotAll());
        Assert.assertTrue((String)expectedStrings.getExtraString(), (!expectedStrings.gotExtra() ? 1 : 0) != 0);
    }

    public void testGetSoname() throws CModelException {
        IBinary iBinary = CProjectHelper.findBinary(this.testProject, "test_g");
        Assert.assertTrue((boolean)iBinary.getSoname().equals(""));
        iBinary = CProjectHelper.findBinary(this.testProject, "libtestlib_g.so");
        String string = iBinary.getSoname();
        Assert.assertNotNull((Object)string);
        Assert.assertTrue((String)("Expected: libtestlib_g.so.1  Got: " + string), (boolean)string.equals("libtestlib_g.so.1"));
    }

    public void testGetText() throws CModelException {
        IBinary iBinary = CProjectHelper.findBinary(this.testProject, this.bigexe.getLocation().lastSegment());
        IBinary iBinary2 = CProjectHelper.findBinary(this.testProject, this.exefile.getLocation().lastSegment());
        Assert.assertTrue((String)("Expected  886, Got: " + iBinary.getText()), (iBinary.getText() == 886L ? 1 : 0) != 0);
        Assert.assertTrue((String)("Expected 1223, Got: " + iBinary2.getText()), (iBinary2.getText() == 1223L ? 1 : 0) != 0);
    }

    public void testHasDebug() throws CModelException {
        IBinary iBinary = CProjectHelper.findBinary(this.testProject, "test_g");
        Assert.assertTrue((boolean)iBinary.hasDebug());
        iBinary = CProjectHelper.findBinary(this.testProject, "libtestlib_g.so");
        Assert.assertTrue((boolean)iBinary.hasDebug());
        iBinary = CProjectHelper.findBinary(this.testProject, "exetest");
        Assert.assertTrue((!iBinary.hasDebug() ? 1 : 0) != 0);
    }

    public void testisBinRead() throws CModelException {
        IBinary iBinary = CProjectHelper.findBinary(this.testProject, "test_g");
        Assert.assertTrue((iBinary != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)iBinary.isReadOnly());
    }

    public void testIsObject() throws CModelException {
        IBinary iBinary = CProjectHelper.findObject(this.testProject, "exetest.o");
        Assert.assertTrue((boolean)iBinary.isObject());
        iBinary = CProjectHelper.findBinary(this.testProject, "test_g");
        Assert.assertTrue((!iBinary.isObject() ? 1 : 0) != 0);
        iBinary = CProjectHelper.findBinary(this.testProject, "libtestlib_g.so");
        Assert.assertTrue((!iBinary.isObject() ? 1 : 0) != 0);
        iBinary = CProjectHelper.findBinary(this.testProject, "exetest");
        Assert.assertTrue((!iBinary.isObject() ? 1 : 0) != 0);
    }

    public void testIsSharedLib() throws CModelException {
        IBinary iBinary = CProjectHelper.findObject(this.testProject, "exetest.o");
        Assert.assertTrue((!iBinary.isSharedLib() ? 1 : 0) != 0);
        iBinary = CProjectHelper.findBinary(this.testProject, "libtestlib_g.so");
        Assert.assertTrue((boolean)iBinary.isSharedLib());
        iBinary = CProjectHelper.findBinary(this.testProject, "test_g");
        Assert.assertTrue((!iBinary.isSharedLib() ? 1 : 0) != 0);
        iBinary = CProjectHelper.findBinary(this.testProject, "exetest");
        Assert.assertTrue((!iBinary.isSharedLib() ? 1 : 0) != 0);
    }

    public void testIsExecutable() throws InterruptedException, CModelException {
        IBinary iBinary = CProjectHelper.findObject(this.testProject, "exetest.o");
        Assert.assertTrue((!iBinary.isExecutable() ? 1 : 0) != 0);
        iBinary = CProjectHelper.findBinary(this.testProject, "test_g");
        Assert.assertTrue((boolean)iBinary.isExecutable());
        iBinary = CProjectHelper.findBinary(this.testProject, "libtestlib_g.so");
        Assert.assertTrue((!iBinary.isExecutable() ? 1 : 0) != 0);
        iBinary = CProjectHelper.findBinary(this.testProject, "exetest");
        Assert.assertTrue((boolean)iBinary.isExecutable());
    }

    public void testIsBinary() throws CoreException, FileNotFoundException, Exception {
        IBinary iBinary = CProjectHelper.findBinary(this.testProject, "exebig_g");
        Assert.assertTrue((String)"A Binary", (iBinary != null ? 1 : 0) != 0);
    }
}

