/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.model.tests;

import java.io.FileInputStream;
import java.io.InputStream;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.testplugin.CProjectHelper;
import org.eclipse.cdt.core.testplugin.CTestPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;

public class TranslationUnitBaseTest
extends TestCase {
    protected IWorkspace workspace;
    protected IWorkspaceRoot root;
    protected ICProject testProject;
    protected IFile objfile;
    protected IFile archfile;
    protected IFile libfile;
    protected IFile exefile;
    protected IFile cfile;
    protected Path objpath;
    protected Path archpath;
    protected Path libpath;
    protected Path exepath;
    protected Path cpath;
    protected NullProgressMonitor monitor;

    public TranslationUnitBaseTest() {
    }

    public TranslationUnitBaseTest(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        this.workspace = ResourcesPlugin.getWorkspace();
        this.root = this.workspace.getRoot();
        this.monitor = new NullProgressMonitor();
        if (this.workspace == null) {
            Assert.fail((String)"Workspace was not setup");
        }
        if (this.root == null) {
            Assert.fail((String)"Workspace root was not setup");
        }
        IWorkspaceDescription iWorkspaceDescription = this.workspace.getDescription();
        iWorkspaceDescription.setAutoBuilding(false);
        this.workspace.setDescription(iWorkspaceDescription);
        this.testProject = CProjectHelper.createCProject("filetest", "none");
        if (this.testProject == null) {
            Assert.fail((String)"Unable to create project");
        }
        this.cfile = this.testProject.getProject().getFile("exetest.c");
        if (!this.cfile.exists()) {
            this.cfile.create((InputStream)new FileInputStream(CTestPlugin.getDefault().getFileInPlugin((IPath)new Path("resources/cfiles/TranslationUnits.c"))), false, (IProgressMonitor)this.monitor);
        }
        this.cpath = new Path(this.workspace.getRoot().getLocation() + "/filetest/main.c");
        this.objfile = this.testProject.getProject().getFile("exetest.o");
        if (!this.objfile.exists()) {
            this.objfile.create((InputStream)new FileInputStream(CTestPlugin.getDefault().getFileInPlugin((IPath)new Path("resources/exe/x86/o.g/main.o"))), false, (IProgressMonitor)this.monitor);
        }
        this.objpath = new Path(this.workspace.getRoot().getLocation() + "/filetest/main.o");
        this.exefile = this.testProject.getProject().getFile("test_g");
        if (!this.exefile.exists()) {
            this.exefile.create((InputStream)new FileInputStream(CTestPlugin.getDefault().getFileInPlugin((IPath)new Path("resources/exe/x86/o.g/exe_g"))), false, (IProgressMonitor)this.monitor);
        }
        this.exepath = new Path(this.workspace.getRoot().getLocation() + "/filetest/exe_g");
        this.archfile = this.testProject.getProject().getFile("libtestlib_g.a");
        if (!this.archfile.exists()) {
            this.archfile.create((InputStream)new FileInputStream(CTestPlugin.getDefault().getFileInPlugin((IPath)new Path("resources/testlib/x86/a.g/libtestlib_g.a"))), false, (IProgressMonitor)this.monitor);
        }
        this.libpath = new Path(this.workspace.getRoot().getLocation() + "/filetest/libtestlib_g.so");
        this.libfile = this.testProject.getProject().getFile("libtestlib_g.so");
        if (!this.libfile.exists()) {
            this.libfile.create((InputStream)new FileInputStream(CTestPlugin.getDefault().getFileInPlugin((IPath)new Path("resources/testlib/x86/so.g/libtestlib_g.so"))), false, (IProgressMonitor)this.monitor);
        }
        this.archpath = new Path(this.workspace.getRoot().getLocation() + "/filetest/libtestlib_g.a");
    }

    protected void tearDown() {
        try {
            this.testProject.getProject().delete(true, true, (IProgressMonitor)this.monitor);
        }
        catch (CoreException coreException) {}
    }
}

