/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser.tests;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import junit.framework.Assert;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.ast.ASTClassKind;
import org.eclipse.cdt.core.parser.ast.IASTAbstractTypeSpecifierDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTClassSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTField;
import org.eclipse.cdt.core.parser.ast.IASTFunction;
import org.eclipse.cdt.core.parser.ast.IASTVariable;
import org.eclipse.cdt.core.parser.tests.BaseASTTest;

public class GCCQuickParseExtensionsTest
extends BaseASTTest {
    public GCCQuickParseExtensionsTest(String string) {
        super(string);
    }

    public void testBug39694() throws Exception {
        IASTVariable iASTVariable = (IASTVariable)this.parse("int ab$cd = 1;").getDeclarations().next();
        Assert.assertEquals((String)iASTVariable.getName(), (String)"ab$cd");
    }

    public void testBug39704A() throws Exception {
        IASTVariable iASTVariable = (IASTVariable)this.assertSoleDeclaration("__declspec (dllimport) int foo;");
        Assert.assertEquals((String)iASTVariable.getName(), (String)"foo");
    }

    public void testBug39704D() throws Exception {
        IASTFunction iASTFunction = (IASTFunction)this.assertSoleDeclaration("__declspec(dllexport) int func1 (int a) {}");
        Assert.assertEquals((String)iASTFunction.getName(), (String)"func1");
    }

    public void testBug39695() throws Exception {
        this.parse("int a = __alignof__ (int);");
    }

    public void testBug39684() throws Exception {
        this.parse("typeof(foo(1)) bar () { return foo(1); }");
    }

    public void testBug39703() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("/* __extension__ enables GNU C mode for the duration of the declaration.  */\n");
        ((Writer)stringWriter).write("__extension__ struct G {\n");
        ((Writer)stringWriter).write("  struct { char z; };\n");
        ((Writer)stringWriter).write("  char g;\n");
        ((Writer)stringWriter).write("};\n");
        IASTAbstractTypeSpecifierDeclaration iASTAbstractTypeSpecifierDeclaration = (IASTAbstractTypeSpecifierDeclaration)this.assertSoleDeclaration(((Object)stringWriter).toString());
        IASTClassSpecifier iASTClassSpecifier = (IASTClassSpecifier)iASTAbstractTypeSpecifierDeclaration.getTypeSpecifier();
        Assert.assertEquals((String)iASTClassSpecifier.getName(), (String)"G");
        Assert.assertEquals((Object)iASTClassSpecifier.getClassKind(), (Object)ASTClassKind.STRUCT);
        Iterator iterator = iASTClassSpecifier.getDeclarations();
        Assert.assertEquals((String)((IASTClassSpecifier)((IASTAbstractTypeSpecifierDeclaration)iterator.next()).getTypeSpecifier()).getName(), (String)"");
        Assert.assertEquals((String)((IASTField)iterator.next()).getName(), (String)"g");
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    public void testBug39698A() throws Exception {
        this.parse("int c = a <? b;");
    }

    public void testBug39698B() throws Exception {
        this.parse("int c = a >? b;");
    }

    public void testBug39554() throws Exception {
        this.parse("_Pragma(\"foobar\")", true, true, ParserLanguage.C);
    }

    public void testBug39704B() throws Exception {
        IASTVariable iASTVariable = (IASTVariable)this.assertSoleDeclaration("extern int (* import) (void) __attribute__((dllimport));");
        Assert.assertEquals((String)iASTVariable.getName(), (String)"import");
    }

    public void testBug39704C() throws Exception {
        IASTFunction iASTFunction = (IASTFunction)this.assertSoleDeclaration("int func2 (void) __attribute__((dllexport));");
        Assert.assertEquals((String)iASTFunction.getName(), (String)"func2");
    }

    public void testBug39704E() throws Exception {
        IASTVariable iASTVariable = (IASTVariable)this.assertSoleDeclaration("extern int * __attribute__((dllimport)) (* import) (void);");
        Assert.assertEquals((String)iASTVariable.getName(), (String)"import");
    }

    public void testBug39704F() throws Exception {
        IASTVariable iASTVariable = (IASTVariable)this.assertSoleDeclaration("extern int __attribute__((dllimport)) (* import) (void);");
        Assert.assertEquals((String)iASTVariable.getName(), (String)"import");
    }

    public void testBug39704G() throws Exception {
        IASTVariable iASTVariable = (IASTVariable)this.assertSoleDeclaration("int x __attribute__ ((aligned (16))) = 0;");
        Assert.assertEquals((String)iASTVariable.getName(), (String)"x");
    }

    public void testBug39686() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("__complex__ double x; // complex double\n");
        ((Writer)stringWriter).write("__complex__ short int a; // complex short int\n");
        ((Writer)stringWriter).write("__complex__ float y = 2.5fi; // 2.5 imaginary float literal\n");
        ((Writer)stringWriter).write("__complex__ int a = 3i; // imaginary intege r literal\n");
        ((Writer)stringWriter).write("double v = __real__ x; // real part of expression\n");
        ((Writer)stringWriter).write("double w = __imag__ x; // imaginary part of expression\n");
        this.parse(((Object)stringWriter).toString());
    }

    public void testBug39681() throws Exception {
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("double\n");
        ((Writer)stringWriter).write("foo (double a, double b)\n");
        ((Writer)stringWriter).write("{\n");
        ((Writer)stringWriter).write("  double square (double z) { return z * z; }\n");
        ((Writer)stringWriter).write("  return square (a) + square (b);\n");
        ((Writer)stringWriter).write("}\n");
        this.parse(((Object)stringWriter).toString());
    }

    public void testBug39677() throws Exception {
        this.parse("B::B() : a(({ 1; })) {}");
        StringWriter stringWriter = new StringWriter();
        ((Writer)stringWriter).write("B::B() : a(( { int y = foo (); int z;\n");
        ((Writer)stringWriter).write("if (y > 0) z = y;\n");
        ((Writer)stringWriter).write("else z = - y;\n");
        ((Writer)stringWriter).write("z; }))\n");
        this.parse(((Object)stringWriter).toString());
        stringWriter = new StringWriter();
        ((Writer)stringWriter).write("int x = ({ int y = foo (); int z;\n");
        ((Writer)stringWriter).write("if (y > 0) z = y;\n");
        ((Writer)stringWriter).write("else z = - y;\n");
        ((Writer)stringWriter).write("z; });\n");
        stringWriter = new StringWriter();
        ((Writer)stringWriter).write("typeof({ int y = foo (); int z;\n");
        ((Writer)stringWriter).write("if (y > 0) z = y;\n");
        ((Writer)stringWriter).write("else z = - y;\n");
        ((Writer)stringWriter).write("z; }) zoot;\n");
    }

    public void testBug39701A() throws Exception {
        this.parse("extern template int max (int, int);");
    }

    public void testBug39701B() throws Exception {
        this.parse("inline template class Foo<int>;");
    }

    public void testBug39701C() throws Exception {
        this.parse("static template class Foo<int>;");
    }
}

