/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser.tests;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StringWriter;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.IParser;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.core.parser.IScanner;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.NullLogService;
import org.eclipse.cdt.core.parser.ParserFactory;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.ParserMode;
import org.eclipse.cdt.core.parser.ScannerInfo;
import org.eclipse.cdt.core.parser.tests.AutomatedFramework;
import org.eclipse.cdt.core.parser.tests.FractionalAutomatedTest;
import org.eclipse.cdt.core.testplugin.CTestPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class TortureTest
extends FractionalAutomatedTest {
    protected static boolean isEnabled = false;
    protected static boolean quickParse = true;

    public TortureTest() {
    }

    public TortureTest(String string) {
        super(string);
    }

    protected AutomatedFramework newTest(String string) {
        return new TortureTest(string);
    }

    protected void loadProperties() throws Exception {
        String string = CTestPlugin.getDefault().find((IPath)new Path("/")).getFile();
        string = String.valueOf(string) + "resources/parser/TortureTest";
        try {
            FileInputStream fileInputStream = new FileInputStream(String.valueOf(string) + "/TortureTest.properties");
            AutomatedFramework.properties.load(fileInputStream);
            isEnabled = AutomatedFramework.properties.getProperty("enabled", "false").equalsIgnoreCase("true");
            quickParse = AutomatedFramework.properties.getProperty("quickParse", "true").equalsIgnoreCase("true");
            String string2 = AutomatedFramework.properties.getProperty("source", "");
            FractionalAutomatedTest.stepSize = Integer.parseInt(AutomatedFramework.properties.getProperty("stepSize", "25000"));
            AutomatedFramework.outputFile = AutomatedFramework.properties.getProperty("outputFile", "");
            FractionalAutomatedTest.timeOut = Integer.parseInt(AutomatedFramework.properties.getProperty("timeOut", "60000"));
            FractionalAutomatedTest.outputDir = AutomatedFramework.properties.getProperty("outDir", "");
            if (string2.equals("")) {
                throw new FileNotFoundException();
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            String string3 = null;
            String string4 = null;
            try {
                while (stringTokenizer.hasMoreTokens()) {
                    string3 = stringTokenizer.nextToken().trim();
                    string4 = stringTokenizer.nextToken().trim();
                    AutomatedFramework.testSources.put(string3, string4);
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                AutomatedFramework.testSources.put(string3, "cpp");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            AutomatedFramework.testSources.put(string, "cpp");
        }
        if (!isEnabled) {
            AutomatedFramework.testSources.clear();
        }
    }

    public static Test suite() {
        TortureTest tortureTest = new TortureTest();
        return tortureTest.createSuite();
    }

    protected static void reportException(Throwable throwable, String string, IParser iParser) {
        String string2 = null;
        int n = -1;
        n = iParser.getLastErrorLine();
        if (throwable instanceof AssertionFailedError) {
            string2 = String.valueOf(string) + ": Parse failed on line ";
            string2 = String.valueOf(string2) + n + "\n";
        } else {
            string2 = String.valueOf(string) + ": " + throwable.getClass().toString();
            string2 = String.valueOf(string2) + " on line " + n + "\n";
        }
        try {
            if (AutomatedFramework.report != null) {
                AutomatedFramework.report.write(string2.getBytes());
            }
        }
        catch (IOException iOException) {}
        Assert.fail((String)string2);
    }

    protected static boolean isExpectedToPass(String string, File file) {
        String string2 = file.getName();
        if (string2.equals("init-2.c") || string2.equals("init-3.c") || string2.equals("struct-ini-4.c")) {
            return false;
        }
        if (string2.equals("stmtexpr3.C")) {
            return false;
        }
        if (string2.equals("widechar-1.c")) {
            return false;
        }
        if (string2.equals("bf-common.h") || string2.equals("class-tests-1.h") || string2.equals("unclaimed-category-1.h")) {
            return false;
        }
        if (string.indexOf("{ dg-error") >= 0) {
            return false;
        }
        if (string.indexOf("// ERROR") >= 0) {
            return false;
        }
        if (string.indexOf("- ERROR") >= 0) {
            return false;
        }
        if (string.indexOf("// XFAIL") >= 0) {
            return false;
        }
        if (string.indexOf("- XFAIL") >= 0) {
            return false;
        }
        if (string.indexOf("{ xfail") >= 0) {
            return false;
        }
        if (string.indexOf("{ dg-preprocess") >= 0) {
            return false;
        }
        if (string.indexOf("{ dg-do preprocess") >= 0) {
            return false;
        }
        if (string.indexOf("__attribute") >= 0) {
            return false;
        }
        if (string.indexOf("__extension") >= 0) {
            return false;
        }
        if (string.indexOf("__restrict") >= 0) {
            return false;
        }
        if (string.indexOf("__const") >= 0) {
            return false;
        }
        if (string.indexOf("__declspec") >= 0) {
            return false;
        }
        if (string.indexOf("__alignof") >= 0) {
            return false;
        }
        if (string.indexOf("__label") >= 0) {
            return false;
        }
        if (string.indexOf("__real") >= 0) {
            return false;
        }
        if (string.indexOf("__imag") >= 0) {
            return false;
        }
        if (string.indexOf("extern template") >= 0) {
            return false;
        }
        if (string.indexOf("inline template") >= 0) {
            return false;
        }
        if (string.indexOf("static template") >= 0) {
            return false;
        }
        if (string.indexOf("typeof") >= 0) {
            return false;
        }
        if (string.indexOf(" asm") >= 0) {
            return false;
        }
        if (string.indexOf(") return") >= 0) {
            return false;
        }
        if (string.indexOf("#ident") >= 0) {
            return false;
        }
        if (string.indexOf("#include_next") >= 0) {
            return false;
        }
        if (string.indexOf("{ dg-do run") >= 0) {
            return true;
        }
        if (string.indexOf("{ dg-do link") >= 0) {
            return true;
        }
        return true;
    }

    public void doFile() throws Throwable {
        int n = FractionalAutomatedTest.timeOut;
        Assert.assertNotNull((Object)AutomatedFramework.fileList);
        File file = (File)AutomatedFramework.fileList.removeFirst();
        FileInputStream fileInputStream = new FileInputStream(file);
        String string = file.getCanonicalPath();
        String string2 = (String)AutomatedFramework.natures.get(string);
        StringWriter stringWriter = new StringWriter();
        byte[] byArray = new byte[FractionalAutomatedTest.stepSize];
        int n2 = fileInputStream.read(byArray);
        while (n2 != -1) {
            stringWriter.write(new String(byArray));
            n2 = fileInputStream.read(byArray);
        }
        String string3 = stringWriter.toString();
        if (file.getName().equals("concat1.C")) {
            n = 600000;
        }
        if (TortureTest.isExpectedToPass(string3, file)) {
            ParseThread parseThread = new ParseThread();
            parseThread.quickParse = quickParse;
            parseThread.code = string3;
            parseThread.cppNature = string2.equalsIgnoreCase("cpp");
            parseThread.file = string;
            parseThread.start();
            parseThread.join(n);
            if (parseThread.isAlive()) {
                parseThread.stop();
                FractionalAutomatedTest.reportHang(string3, string);
            } else if (parseThread.result != null) {
                TortureTest.reportException(parseThread.result, string, parseThread.parser);
            }
        } else {
            Assert.assertTrue((boolean)true);
        }
    }

    static class ParseThread
    extends Thread {
        public String code;
        public boolean cppNature;
        public String file;
        public Throwable result = null;
        public IParser parser = null;
        public boolean quickParse = true;

        ParseThread() {
        }

        public void run() {
            try {
                ParserMode parserMode = this.quickParse ? ParserMode.QUICK_PARSE : ParserMode.COMPLETE_PARSE;
                ParserLanguage parserLanguage = this.cppNature ? ParserLanguage.CPP : ParserLanguage.C;
                this.parser = ParserFactory.createParser((IScanner)ParserFactory.createScanner((CodeReader)new CodeReader(this.code.toCharArray()), (IScannerInfo)new ScannerInfo(), (ParserMode)parserMode, (ParserLanguage)parserLanguage, (ISourceElementRequestor)AutomatedFramework.nullCallback, (IParserLogService)new NullLogService(), null), (ISourceElementRequestor)AutomatedFramework.nullCallback, (ParserMode)parserMode, (ParserLanguage)parserLanguage, null);
                Assert.assertTrue((boolean)this.parser.parse());
            }
            catch (Throwable throwable) {
                this.result = throwable;
            }
        }
    }
}

