/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser.tests.ast2;

import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.tests.ast2.AST2SpecBaseTest;
import org.eclipse.cdt.internal.core.parser.ParserException;

public class AST2CPPSpecTest
extends AST2SpecBaseTest {
    public void test2_4s5() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int x=x+++++y;\n");
        this.parseCandCPP(stringBuffer.toString(), false, 0);
    }

    public void test2_13_1s1() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int a=12, b=014, c=0XC;\n");
        this.parseCandCPP(stringBuffer.toString(), true, 0);
    }

    public void test3_1s3() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int a; // defines a\n");
        stringBuffer.append("extern const int c = 1; // defines c\n");
        stringBuffer.append("int f(int x) { return x+a; } // defines f and defines x\n");
        stringBuffer.append("struct S { int a; int b; }; // defines S, S::a, and S::b\n");
        stringBuffer.append("struct X { // defines X\n");
        stringBuffer.append("int x; // defines nonstatic data member x\n");
        stringBuffer.append("static int y; // declares static data member y\n");
        stringBuffer.append("X(): x(0) { } // defines a constructor of X\n");
        stringBuffer.append("};\n");
        stringBuffer.append("int X::y = 1; // defines X::y\n");
        stringBuffer.append("enum { up, down }; // defines up and down\n");
        stringBuffer.append("namespace N { int d; } // defines N and N::d\n");
        stringBuffer.append("namespace N1 = N; // defines N1\n");
        stringBuffer.append("X anX; // defines anX\n");
        stringBuffer.append("// whereas these are just declarations:\n");
        stringBuffer.append("extern int a; // declares a\n");
        stringBuffer.append("extern const int c; // declares c\n");
        stringBuffer.append("int f(int); // declares f\n");
        stringBuffer.append("struct S; // declares S\n");
        stringBuffer.append("typedef int Int; // declares Int\n");
        stringBuffer.append("extern X anotherX; // declares anotherX\n");
        stringBuffer.append("using N::d; // declares N::d\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test3_1s4a() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct C {\n");
        stringBuffer.append("string s; // string is the standard library class (clause 21)\n");
        stringBuffer.append("};\n");
        stringBuffer.append("int main()\n");
        stringBuffer.append("{\n");
        stringBuffer.append("C a;\n");
        stringBuffer.append("C b = a;\n");
        stringBuffer.append("b = a;\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, false, 0);
    }

    public void test3_1s4b() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct C {\n");
        stringBuffer.append("string s;\n");
        stringBuffer.append("C(): s() { }\n");
        stringBuffer.append("C(const C& x): s(x.s) { }\n");
        stringBuffer.append("C& operator=(const C& x) { s = x.s; return *this; }\n");
        stringBuffer.append("~C() { }\n");
        stringBuffer.append("};\n");
        stringBuffer.append("\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, false, 0);
    }

    public void test3_2s4() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct X; // declare X as a struct type\n");
        stringBuffer.append("struct X* x1; // use X in pointer formation\n");
        stringBuffer.append("X* x2; // use X in pointer formation\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test3_2s5() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("// translation unit 1:\n");
        stringBuffer.append("struct X {\n");
        stringBuffer.append("X(int);\n");
        stringBuffer.append("X(int, int);\n");
        stringBuffer.append("};\n");
        stringBuffer.append("X::X(int = 0) { }\n");
        stringBuffer.append("class D: public X { };\n");
        stringBuffer.append("D d2; // X(int) called by D()\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
        stringBuffer = new StringBuffer();
        stringBuffer.append("// translation unit 2:\n");
        stringBuffer.append("struct X {\n");
        stringBuffer.append("X(int);\n");
        stringBuffer.append("X(int, int);\n");
        stringBuffer.append("};\n");
        stringBuffer.append("X::X(int = 0, int = 0) { }\n");
        stringBuffer.append("class D: public X { }; // X(int, int) called by D();\n");
        stringBuffer.append("// D()\ufffds implicit definition\n");
        stringBuffer.append("// violates the ODR\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test3_3s2() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int j = 24;\n");
        stringBuffer.append("int main()\n");
        stringBuffer.append("{\n");
        stringBuffer.append("int i = j, j;\n");
        stringBuffer.append("j = 42;\n");
        stringBuffer.append("}\n");
        this.parseCandCPP(stringBuffer.toString(), true, 0);
    }

    public void test3_3_1s1() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int foo() {\n");
        stringBuffer.append("int x = 12;\n");
        stringBuffer.append("{ int x = x; }\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test3_3_1s2() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int foo() {\n");
        stringBuffer.append("const int i = 2;\n");
        stringBuffer.append("{ int i[i]; }\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test3_3_1s3() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int foo() {\n");
        stringBuffer.append("const int x = 12;\n");
        stringBuffer.append("{ enum { x = x }; }\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test3_3_5s1() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("namespace N {\n");
        stringBuffer.append("int i;\n");
        stringBuffer.append("int g(int a) { return a; }\n");
        stringBuffer.append("int j();\n");
        stringBuffer.append("void q();\n");
        stringBuffer.append("}\n");
        stringBuffer.append("namespace { int l=1; }\n");
        stringBuffer.append("// the potential scope of l is from its point of declaration\n");
        stringBuffer.append("// to the end of the translation unit\n");
        stringBuffer.append("namespace N {\n");
        stringBuffer.append("int g(char a) // overloads N::g(int)\n");
        stringBuffer.append("{\n");
        stringBuffer.append("return l+a; // l is from unnamed namespace\n");
        stringBuffer.append("}\n");
        stringBuffer.append("int i; // error: duplicate definition\n");
        stringBuffer.append("int j(); // OK: duplicate function declaration\n");
        stringBuffer.append("int j() // OK: definition of N::j()\n");
        stringBuffer.append("{\n");
        stringBuffer.append("return g(i); // calls N::g(int)\n");
        stringBuffer.append("}\n");
        stringBuffer.append("int q(); // error: different return type\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test3_4_1s6() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("namespace A {\n");
        stringBuffer.append("namespace N {\n");
        stringBuffer.append("void f();\n");
        stringBuffer.append("}\n");
        stringBuffer.append("}\n");
        stringBuffer.append("void A::N::f() {\n");
        stringBuffer.append("int i = 5;\n");
        stringBuffer.append("// The following scopes are searched for a declaration of i:\n");
        stringBuffer.append("// 1) outermost block scope of A::N::f, before the use of i\n");
        stringBuffer.append("// 2) scope of namespace N\n");
        stringBuffer.append("// 3) scope of namespace A\n");
        stringBuffer.append("// 4) global scope, before the definition of A::N::f\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test3_4_1s7() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("namespace M {\n");
        stringBuffer.append("class B { };\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test3_4_1s8() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class B { };\n");
        stringBuffer.append("namespace M {\n");
        stringBuffer.append("namespace N {\n");
        stringBuffer.append("class X : public B {\n");
        stringBuffer.append("void f();\n");
        stringBuffer.append("};\n");
        stringBuffer.append("}\n");
        stringBuffer.append("}\n");
        stringBuffer.append("void M::N::X::f() {\n");
        stringBuffer.append("int i = 16;\n");
        stringBuffer.append("}\n");
        stringBuffer.append("// The following scopes are searched for a declaration of i:\n");
        stringBuffer.append("// 1) outermost block scope of M::N::X::f, before the use of i\n");
        stringBuffer.append("// 2) scope of class M::N::X\n");
        stringBuffer.append("// 3) scope of M::N::X\ufffds base class B\n");
        stringBuffer.append("// 4) scope of namespace M::N\n");
        stringBuffer.append("// 5) scope of namespace M\n");
        stringBuffer.append("// 6) global scope, before the definition of M::N::X::f\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test3_4_1s10() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct A {\n");
        stringBuffer.append("typedef int AT;\n");
        stringBuffer.append("void f1(AT);\n");
        stringBuffer.append("void f2(float);\n");
        stringBuffer.append("};\n");
        stringBuffer.append("struct B {\n");
        stringBuffer.append("typedef float BT;\n");
        stringBuffer.append("friend void A::f1(AT); // parameter type is A::AT\n");
        stringBuffer.append("friend void A::f2(BT); // parameter type is B::BT\n");
        stringBuffer.append("};\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test3_4_2s2() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("namespace NS {\n");
        stringBuffer.append("class T { };\n");
        stringBuffer.append("void f(T);\n");
        stringBuffer.append("}\n");
        stringBuffer.append("NS::T parm;\n");
        stringBuffer.append("int main() {\n");
        stringBuffer.append("f(parm); //OK: calls NS::f\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test3_4_3s1() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test3_4_3s3() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class X { };\n");
        stringBuffer.append("class C {\n");
        stringBuffer.append("class X { };\n");
        stringBuffer.append("static const int number = 50;\n");
        stringBuffer.append("static X arr[number];\n");
        stringBuffer.append("};\n");
        stringBuffer.append("X C::arr[number]; // illformed:\n");
        stringBuffer.append("// equivalent to: ::X C::arr[C::number];\n");
        stringBuffer.append("// not to: C::X C::arr[C::number];\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test3_4_3s5() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct C {\n");
        stringBuffer.append("typedef int I;\n");
        stringBuffer.append("};\n");
        stringBuffer.append("typedef int I1, I2;\n");
        stringBuffer.append("int foo() {\n");
        stringBuffer.append("extern int* p;\n");
        stringBuffer.append("extern int* q;\n");
        stringBuffer.append("p->C::I::~I(); // I is looked up in the scope of C\n");
        stringBuffer.append("q->I1::~I2(); // I2 is looked up in the scope of\n");
        stringBuffer.append("};\n");
        stringBuffer.append("// the postfixexpression\n");
        stringBuffer.append("struct A {\n");
        stringBuffer.append("~A();\n");
        stringBuffer.append("};\n");
        stringBuffer.append("typedef A AB;\n");
        stringBuffer.append("int main()\n");
        stringBuffer.append("{\n");
        stringBuffer.append("AB *p;\n");
        stringBuffer.append("p->AB::~AB(); // explicitly calls the destructor for A\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, false, 0);
    }

    public void test3_4_3_2s2() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int x;\n");
        stringBuffer.append("namespace Y {\n");
        stringBuffer.append("void f(float);\n");
        stringBuffer.append("void h(int);\n");
        stringBuffer.append("}\n");
        stringBuffer.append("namespace Z {\n");
        stringBuffer.append("void h(double);\n");
        stringBuffer.append("}\n");
        stringBuffer.append("namespace A {\n");
        stringBuffer.append("using namespace Y;\n");
        stringBuffer.append("void f(int);\n");
        stringBuffer.append("void g(int);\n");
        stringBuffer.append("int i;\n");
        stringBuffer.append("}\n");
        stringBuffer.append("namespace B {\n");
        stringBuffer.append("using namespace Z;\n");
        stringBuffer.append("void f(char);\n");
        stringBuffer.append("int i;\n");
        stringBuffer.append("}\n");
        stringBuffer.append("namespace AB {\n");
        stringBuffer.append("using namespace A;\n");
        stringBuffer.append("using namespace B;\n");
        stringBuffer.append("void g();\n");
        stringBuffer.append("}\n");
        stringBuffer.append("void h()\n");
        stringBuffer.append("{\n");
        stringBuffer.append("AB::g(); // g is declared directly in AB,\n");
        stringBuffer.append("// therefore S is { AB::g() } and AB::g() is chosen\n");
        stringBuffer.append("AB::f(1); // f is not declared directly in AB so the rules are\n");
        stringBuffer.append("// applied recursively to A and B;\n");
        stringBuffer.append("// namespace Y is not searched and Y::f(float)\n");
        stringBuffer.append("// is not considered;\n");
        stringBuffer.append("// S is { A::f(int), B::f(char) } and overload\n");
        stringBuffer.append("// resolution chooses A::f(int)\n");
        stringBuffer.append("AB::f('c'); //as above but resolution chooses B::f(char)\n");
        stringBuffer.append("AB::x++; // x is not declared directly in AB, and\n");
        stringBuffer.append("// is not declared in A or B, so the rules are\n");
        stringBuffer.append("// applied recursively to Y and Z,\n");
        stringBuffer.append("// S is { } so the program is illformed\n");
        stringBuffer.append("AB::i++; // i is not declared directly in AB so the rules are\n");
        stringBuffer.append("// applied recursively to A and B,\n");
        stringBuffer.append("// S is { A::i, B::i } so the use is ambiguous\n");
        stringBuffer.append("// and the program is illformed\n");
        stringBuffer.append("AB::h(16.8); // h is not declared directly in AB and\n");
        stringBuffer.append("// not declared directly in A or B so the rules are\n");
        stringBuffer.append("// applied recursively to Y and Z,\n");
        stringBuffer.append("// S is { Y::h(int), Z::h(double) } and overload\n");
        stringBuffer.append("// resolution chooses Z::h(double)\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, false, 0);
    }

    public void test3_4_3_2s3() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("namespace A {\n");
        stringBuffer.append("int a;\n");
        stringBuffer.append("}\n");
        stringBuffer.append("namespace B {\n");
        stringBuffer.append("using namespace A;\n");
        stringBuffer.append("}\n");
        stringBuffer.append("namespace C {\n");
        stringBuffer.append("using namespace A;\n");
        stringBuffer.append("}\n");
        stringBuffer.append("namespace BC {\n");
        stringBuffer.append("using namespace B;\n");
        stringBuffer.append("using namespace C;\n");
        stringBuffer.append("}\n");
        stringBuffer.append("void f()\n");
        stringBuffer.append("{\n");
        stringBuffer.append("BC::a++; //OK: S is { A::a, A::a }\n");
        stringBuffer.append("}\n");
        stringBuffer.append("namespace D {\n");
        stringBuffer.append("using A::a;\n");
        stringBuffer.append("}\n");
        stringBuffer.append("namespace BD {\n");
        stringBuffer.append("using namespace B;\n");
        stringBuffer.append("using namespace D;\n");
        stringBuffer.append("}\n");
        stringBuffer.append("void g()\n");
        stringBuffer.append("{\n");
        stringBuffer.append("BD::a++; //OK: S is { A::a, A::a }\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test3_4_3_2s4() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("namespace B {\n");
        stringBuffer.append("int b;\n");
        stringBuffer.append("}\n");
        stringBuffer.append("namespace A {\n");
        stringBuffer.append("using namespace B;\n");
        stringBuffer.append("int a;\n");
        stringBuffer.append("}\n");
        stringBuffer.append("namespace B {\n");
        stringBuffer.append("using namespace A;\n");
        stringBuffer.append("}\n");
        stringBuffer.append("void f()\n");
        stringBuffer.append("{\n");
        stringBuffer.append("A::a++; //OK: a declared directly in A, S is { A::a }\n");
        stringBuffer.append("B::a++; //OK: both A and B searched (once), S is { A::a }\n");
        stringBuffer.append("A::b++; //OK: both A and B searched (once), S is { B::b }\n");
        stringBuffer.append("B::b++; //OK: b declared directly in B, S is { B::b }\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test3_4_3_2s5() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("namespace A {\n");
        stringBuffer.append("struct x { };\n");
        stringBuffer.append("int x;\n");
        stringBuffer.append("int y;\n");
        stringBuffer.append("}\n");
        stringBuffer.append("namespace B {\n");
        stringBuffer.append("struct y {};\n");
        stringBuffer.append("}\n");
        stringBuffer.append("namespace C {\n");
        stringBuffer.append("using namespace A;\n");
        stringBuffer.append("using namespace B;\n");
        stringBuffer.append("int i = C::x; // OK, A::x (of type int)\n");
        stringBuffer.append("int j = C::y; // ambiguous, A::y or B::y\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test3_4_3_2s6a() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("namespace A {\n");
        stringBuffer.append("namespace B {\n");
        stringBuffer.append("void f1(int);\n");
        stringBuffer.append("}\n");
        stringBuffer.append("using namespace B;\n");
        stringBuffer.append("}\n");
        stringBuffer.append("void A::f1(int) { } // illformed,\n");
        stringBuffer.append("// f1 is not a member of A\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test3_4_3_2s6b() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("namespace A {\n");
        stringBuffer.append("namespace B {\n");
        stringBuffer.append("void f1(int);\n");
        stringBuffer.append("}\n");
        stringBuffer.append("}\n");
        stringBuffer.append("namespace C {\n");
        stringBuffer.append("namespace D {\n");
        stringBuffer.append("void f1(int);\n");
        stringBuffer.append("}\n");
        stringBuffer.append("}\n");
        stringBuffer.append("using namespace A;\n");
        stringBuffer.append("using namespace C::D;\n");
        stringBuffer.append("void B::f1(int){} // OK, defines A::B::f1(int)\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test3_4_4s3() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct Node {\n");
        stringBuffer.append("struct Node* Next; // OK: Refers to Node at global scope\n");
        stringBuffer.append("struct Data* Data; // OK: Declares type Data\n");
        stringBuffer.append("// at global scope and member Data\n");
        stringBuffer.append("};\n");
        stringBuffer.append("struct Data {\n");
        stringBuffer.append("struct Node* Node; // OK: Refers to Node at global scope\n");
        stringBuffer.append("friend struct ::Glob; // error: Glob is not declared\n");
        stringBuffer.append("// cannot introduce a qualified type (7.1.5.3)\n");
        stringBuffer.append("friend struct Glob; // OK: Refers to (as yet) undeclared Glob\n");
        stringBuffer.append("// at global scope.\n");
        stringBuffer.append("\n");
        stringBuffer.append("};\n");
        stringBuffer.append("struct Base {\n");
        stringBuffer.append("struct Data; // OK: Declares nested Data\n");
        stringBuffer.append("struct ::Data* thatData; // OK: Refers to ::Data\n");
        stringBuffer.append("struct Base::Data* thisData; // OK: Refers to nested Data\n");
        stringBuffer.append("friend class ::Data; // OK: global Data is a friend\n");
        stringBuffer.append("friend class Data; // OK: nested Data is a friend\n");
        stringBuffer.append("struct Data { //\n");
        stringBuffer.append("}; // Defines nested Data\n");
        stringBuffer.append("struct Data; // OK: Redeclares nested Data\n");
        stringBuffer.append("};\n");
        stringBuffer.append("struct Data; // OK: Redeclares Data at global scope\n");
        stringBuffer.append("struct ::Data; // error: cannot introduce a qualified type (7.1.5.3)\n");
        stringBuffer.append("struct Base::Data; // error: cannot introduce a qualified type (7.1.5.3)\n");
        stringBuffer.append("struct Base::Datum; // error: Datum undefined\n");
        stringBuffer.append("struct Base::Data* pBase; // OK: refers to nested Data\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test3_5s6() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("static void f();\n");
        stringBuffer.append("static int i = 0; //1\n");
        stringBuffer.append("void g() {\n");
        stringBuffer.append("extern void f(); // internal linkage\n");
        stringBuffer.append("int i; //2: i has no linkage\n");
        stringBuffer.append("{\n");
        stringBuffer.append("extern void f(); // internal linkage\n");
        stringBuffer.append("extern int i; //3: external linkage\n");
        stringBuffer.append("}\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test3_5s7() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("namespace X {\n");
        stringBuffer.append("void p()\n");
        stringBuffer.append("{\n");
        stringBuffer.append("q(); //error: q not yet declared\n");
        stringBuffer.append("extern void q(); // q is a member of namespace X\n");
        stringBuffer.append("}\n");
        stringBuffer.append("void middle()\n");
        stringBuffer.append("{\n");
        stringBuffer.append("q(); //error: q not yet declared\n");
        stringBuffer.append("}\n");
        stringBuffer.append("void q() { //\n");
        stringBuffer.append("} // definition of X::q\n");
        stringBuffer.append("}\n");
        stringBuffer.append("void q() { //\n");
        stringBuffer.append("} // some other, unrelated q\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, false, 0);
    }

    public void test3_5s8() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("void f()\n");
        stringBuffer.append("{\n");
        stringBuffer.append("struct A { int x; }; // no linkage\n");
        stringBuffer.append("extern A a; // illformed\n");
        stringBuffer.append("typedef A B;\n");
        stringBuffer.append("extern B b; // illformed\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test3_6_1s2() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int main(int argc, char* argv[]) { //\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test3_8s5() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct B {\n");
        stringBuffer.append("virtual void f();\n");
        stringBuffer.append("void mutate();\n");
        stringBuffer.append("virtual ~B();\n");
        stringBuffer.append("};\n");
        stringBuffer.append("struct D1 : B { void f(); };\n");
        stringBuffer.append("struct D2 : B { void f(); };\n");
        stringBuffer.append("void B::mutate() {\n");
        stringBuffer.append("new (this) D2; // reuses storage \ufffd ends the lifetime of *this\n");
        stringBuffer.append("f(); //undefined behavior\n");
        stringBuffer.append("this; // OK, this points to valid memory\n");
        stringBuffer.append("}\n");
        stringBuffer.append("void g() {\n");
        stringBuffer.append("void* p = malloc(sizeof(D1) + sizeof(D2));\n");
        stringBuffer.append("B* pb = new (p) D1;\n");
        stringBuffer.append("pb->mutate();\n");
        stringBuffer.append("&pb; //OK: pb points to valid memory\n");
        stringBuffer.append("void* q = pb; // OK: pb points to valid memory\n");
        stringBuffer.append("pb->f(); //undefined behavior, lifetime of *pb has ended\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, false, 0);
    }

    public void test3_8s7() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct C {\n");
        stringBuffer.append("int i;\n");
        stringBuffer.append("void f();\n");
        stringBuffer.append("const C& operator=( const C& );\n");
        stringBuffer.append("};\n");
        stringBuffer.append("const C& C::operator=( const C& other)\n");
        stringBuffer.append("{\n");
        stringBuffer.append("if ( this != &other ) {\n");
        stringBuffer.append("this->~C(); //lifetime of *this ends\n");
        stringBuffer.append("new (this) C(other); // new object of type C created\n");
        stringBuffer.append("f(); //welldefined\n");
        stringBuffer.append("}\n");
        stringBuffer.append("return *this;\n");
        stringBuffer.append("}\n");
        stringBuffer.append("int foo() {\n");
        stringBuffer.append("C c1;\n");
        stringBuffer.append("C c2;\n");
        stringBuffer.append("c1 = c2; // welldefined\n");
        stringBuffer.append("c1.f(); //welldefined; c1 refers to a new object of type C\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test3_8s8() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class T { };\n");
        stringBuffer.append("struct B {\n");
        stringBuffer.append("~B();\n");
        stringBuffer.append("};\n");
        stringBuffer.append("void h() {\n");
        stringBuffer.append("B b;\n");
        stringBuffer.append("new (&b) T;\n");
        stringBuffer.append("} //undefined behavior at block exit\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test3_8s9() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct B {\n");
        stringBuffer.append("B();\n");
        stringBuffer.append("~B();\n");
        stringBuffer.append("};\n");
        stringBuffer.append("const B b;\n");
        stringBuffer.append("void h() {\n");
        stringBuffer.append("b.~B();\n");
        stringBuffer.append("new (&b) const B; // undefined behavior\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test3_9s2() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("#define N sizeof(T)\n");
        stringBuffer.append("char buf[N];\n");
        stringBuffer.append("T obj; // obj initialized to its original value\n");
        stringBuffer.append("memcpy(buf, &obj, N); // between these two calls to memcpy,\n");
        stringBuffer.append("// obj might be modified\n");
        stringBuffer.append("memcpy(&obj, buf, N); // at this point, each subobject of obj of scalar type\n");
        stringBuffer.append("// holds its original value\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, false, 0);
    }

    public void test3_9s3() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("T* t1p;\n");
        stringBuffer.append("T* t2p;\n");
        stringBuffer.append("// provided that t2p points to an initialized object ...\n");
        stringBuffer.append("memcpy(t1p, t2p, sizeof(T)); // at this point, every subobject of POD type in *t1p contains\n");
        stringBuffer.append("// the same value as the corresponding subobject in *t2p\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, false, 0);
    }

    public void test3_9s7() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class X; // X is an incomplete type\n");
        stringBuffer.append("extern X* xp; // xp is a pointer to an incomplete type\n");
        stringBuffer.append("extern int arr[]; // the type of arr is incomplete\n");
        stringBuffer.append("typedef int UNKA[]; // UNKA is an incomplete type\n");
        stringBuffer.append("UNKA* arrp; // arrp is a pointer to an incomplete type\n");
        stringBuffer.append("UNKA** arrpp;\n");
        stringBuffer.append("void foo()\n");
        stringBuffer.append("{\n");
        stringBuffer.append("xp++; //illformed: X is incomplete\n");
        stringBuffer.append("arrp++; //illformed: incomplete type\n");
        stringBuffer.append("arrpp++; //OK: sizeof UNKA* is known\n");
        stringBuffer.append("}\n");
        stringBuffer.append("struct X { int i; }; // now X is a complete type\n");
        stringBuffer.append("int arr[10]; // now the type of arr is complete\n");
        stringBuffer.append("X x;\n");
        stringBuffer.append("void bar()\n");
        stringBuffer.append("{\n");
        stringBuffer.append("xp = &x; // OK; type is \ufffd\ufffdpointer to X\ufffd\ufffd\n");
        stringBuffer.append("arrp = &arr; // illformed: different types\n");
        stringBuffer.append("xp++; //OK: X is complete\n");
        stringBuffer.append("arrp++; //illformed: UNKA can\ufffdt be completed\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test3_10s3() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int& f();\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test5s4() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int foo() {\n");
        stringBuffer.append("i = v[i++]; // the behavior is unspecified\n");
        stringBuffer.append("i = 7, i++, i++; // i becomes 9\n");
        stringBuffer.append("i = ++i + 1; // the behavior is unspecified\n");
        stringBuffer.append("i = i + 1; // the value of i is incremented\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, false, 0);
    }

    public void test5_2_7s5() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct B {};\n");
        stringBuffer.append("struct D : B {};\n");
        stringBuffer.append("void foo(D* dp)\n");
        stringBuffer.append("{\n");
        stringBuffer.append("B* bp = dynamic_cast<B*>(dp); // equivalent to B* bp = dp;\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test5_2_7s9() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class A { virtual void f(); };\n");
        stringBuffer.append("class B { virtual void g(); };\n");
        stringBuffer.append("class D : public virtual A, private B {};\n");
        stringBuffer.append("void g()\n");
        stringBuffer.append("{\n");
        stringBuffer.append("D d;\n");
        stringBuffer.append("B* bp = (B*)&d; // cast needed to break protection\n");
        stringBuffer.append("A* ap = &d; // public derivation, no cast needed\n");
        stringBuffer.append("D& dr = dynamic_cast<D&>(*bp); // fails\n");
        stringBuffer.append("ap = dynamic_cast<A*>(bp); // fails\n");
        stringBuffer.append("bp = dynamic_cast<B*>(ap); // fails\n");
        stringBuffer.append("ap = dynamic_cast<A*>(&d); // succeeds\n");
        stringBuffer.append("bp = dynamic_cast<B*>(&d); // fails\n");
        stringBuffer.append("}\n");
        stringBuffer.append("class E : public D, public B {};\n");
        stringBuffer.append("class F : public E, public D {};\n");
        stringBuffer.append("void h()\n");
        stringBuffer.append("{\n");
        stringBuffer.append("F f;\n");
        stringBuffer.append("A* ap = &f; // succeeds: finds unique A\n");
        stringBuffer.append("D* dp = dynamic_cast<D*>(ap); // fails: yields 0\n");
        stringBuffer.append("// f has two D subobjects\n");
        stringBuffer.append("E* ep = (E*)ap; // illformed:\n");
        stringBuffer.append("// cast from virtual base\n");
        stringBuffer.append("E* ep1 = dynamic_cast<E*>(ap); // succeeds\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test5_2_8s5() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class D { // ... \n");
        stringBuffer.append("};\n");
        stringBuffer.append("D d1;\n");
        stringBuffer.append("const D d2;\n");
        stringBuffer.append("int foo() {\n");
        stringBuffer.append("typeid(d1) == typeid(d2); // yields true\n");
        stringBuffer.append("typeid(D) == typeid(const D); // yields true\n");
        stringBuffer.append("typeid(D) == typeid(d2); // yields true\n");
        stringBuffer.append("typeid(D) == typeid(const D&); // yields true\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test5_2_9s5() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct B {};\n");
        stringBuffer.append("struct D : public B {};\n");
        stringBuffer.append("D d;\n");
        stringBuffer.append("B &br = d;\n");
        stringBuffer.append("int foo() {\n");
        stringBuffer.append("static_cast<D&>(br); // produces lvalue to the original d object\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test5_3_1s2() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct A { int i; };\n");
        stringBuffer.append("struct B : A { };\n");
        stringBuffer.append("int foo() {\n");
        stringBuffer.append("&B::i; // has type int A::*\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test5_3_4s6() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int n=2;\n");
        stringBuffer.append("int x=new float[n][5];\n");
        stringBuffer.append("int y=new float[5][n];\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test5_4s5() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct A {};\n");
        stringBuffer.append("struct I1 : A {};\n");
        stringBuffer.append("struct I2 : A {};\n");
        stringBuffer.append("struct D : I1, I2 {};\n");
        stringBuffer.append("A *foo( D *p ) {\n");
        stringBuffer.append("return (A*)( p ); // illformed\n");
        stringBuffer.append("// static_cast interpretation\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test5_5s6() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int foo() {\n");
        stringBuffer.append("(ptr_to_obj->*ptr_to_mfct)(10);\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, false, 0);
    }

    public void test5_9s2() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("void *p;\n");
        stringBuffer.append("const int *q;\n");
        stringBuffer.append("int **pi;\n");
        stringBuffer.append("const int *const *pci;\n");
        stringBuffer.append("void ct()\n");
        stringBuffer.append("{\n");
        stringBuffer.append("p <= q; // Both converted to const void * before comparison\n");
        stringBuffer.append("pi <= pci; // Both converted to const int *const * before comparison\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test5_10s2() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct B {\n");
        stringBuffer.append("int f();\n");
        stringBuffer.append("};\n");
        stringBuffer.append("struct L : B { };\n");
        stringBuffer.append("struct R : B { };\n");
        stringBuffer.append("struct D : L, R { };\n");
        stringBuffer.append("int (B::*pb)() = &B::f;\n");
        stringBuffer.append("int (L::*pl)() = pb;\n");
        stringBuffer.append("int (R::*pr)() = pb;\n");
        stringBuffer.append("int (D::*pdl)() = pl;\n");
        stringBuffer.append("int (D::*pdr)() = pr;\n");
        stringBuffer.append("bool x = (pdl == pdr); // false\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test5_18s2() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int f(int, int, int) {}\n");
        stringBuffer.append("int foo() {\n");
        stringBuffer.append("int a=0, t=1, c=2;\n");
        stringBuffer.append("f(a, (t=3, t+2), c);\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test6_4s1() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int foo() {\n");
        stringBuffer.append("int x=0;\n");
        stringBuffer.append("if (x)\n");
        stringBuffer.append("int i;\n");
        stringBuffer.append("\n");
        stringBuffer.append("if (x) {\n");
        stringBuffer.append("int i;\n");
        stringBuffer.append("}\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test6_5s3() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int foo() {\n");
        stringBuffer.append("int x=5;\n");
        stringBuffer.append("while (--x >= 0)\n");
        stringBuffer.append("int i;\n");
        stringBuffer.append("//can be equivalently rewritten as\n");
        stringBuffer.append("while (--x >= 0) {\n");
        stringBuffer.append("int i;\n");
        stringBuffer.append("}\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test6_5_1s2() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct A {\n");
        stringBuffer.append("int val;\n");
        stringBuffer.append("A(int i) : val(i) { }\n");
        stringBuffer.append("~A() { }\n");
        stringBuffer.append("operator bool() { return val != 0; }\n");
        stringBuffer.append("};\n");
        stringBuffer.append("\n");
        stringBuffer.append("int foo() {\n");
        stringBuffer.append("int i = 1;\n");
        stringBuffer.append("while (A a = i) {\n");
        stringBuffer.append("//...\n");
        stringBuffer.append("i = 0;\n");
        stringBuffer.append("}\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test6_5_3s3() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int foo() {\n");
        stringBuffer.append("int i = 42;\n");
        stringBuffer.append("int a[10];\n");
        stringBuffer.append("for (int i = 0; i < 10; i++)\n");
        stringBuffer.append("a[i] = i;\n");
        stringBuffer.append("int j = i; // j = 42\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test6_7s3() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test6_7s4() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int foo(int i)\n");
        stringBuffer.append("{\n");
        stringBuffer.append("static int s = foo(2*i); // recursive call \ufffd undefined\n");
        stringBuffer.append("return i+1;\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test6_8s1() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int foo() {\n");
        stringBuffer.append("T(a)->m = 7; // expressionstatement\n");
        stringBuffer.append("T(a)++; //expressionstatement\n");
        stringBuffer.append("T(a,5)<<c; //expressionstatement\n");
        stringBuffer.append("T(*d)(int); //declaration\n");
        stringBuffer.append("T(e)[5]; //declaration\n");
        stringBuffer.append("T(f) = { 1, 2 }; // declaration\n");
        stringBuffer.append("T(*g)(double(3)); // declaration\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, false, 0);
    }

    public void test6_8s3() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct T1 {\n");
        stringBuffer.append("T1 operator()(int x) { return T1(x); }\n");
        stringBuffer.append("int operator=(int x) { return x; }\n");
        stringBuffer.append("T1(int) { }\n");
        stringBuffer.append("};\n");
        stringBuffer.append("struct T2 { T2(int){ } };\n");
        stringBuffer.append("int a, (*(*b)(T2))(int), c, d;\n");
        stringBuffer.append("void f() {\n");
        stringBuffer.append("// disambiguation requires this to be parsed\n");
        stringBuffer.append("// as a declaration\n");
        stringBuffer.append("T1(a) = 3,\n");
        stringBuffer.append("T2(4), // T2 will be declared as\n");
        stringBuffer.append("(*(*b)(T2(c)))(int(d)); // a variable of type T1\n");
        stringBuffer.append("// but this will not allow\n");
        stringBuffer.append("// the last part of the\n");
        stringBuffer.append("// declaration to parse\n");
        stringBuffer.append("// properly since it depends\n");
        stringBuffer.append("// on T2 being a typename\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test7_1s2() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("typedef char* Pc;\n");
        stringBuffer.append("void f(const Pc); // void f(char* const) (not const char*)\n");
        stringBuffer.append("void g(const int Pc); // void g(const int)\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test7_1s3() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("void h(unsigned Pc); // void h(unsigned int)\n");
        stringBuffer.append("void k(unsigned int Pc); // void k(unsigned int)\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test7_1_1s7() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("static char* f(); // f() has internal linkage\n");
        stringBuffer.append("char* f() // f() still has internal linkage\n");
        stringBuffer.append("{ //\n");
        stringBuffer.append("}\n");
        stringBuffer.append("char* g(); // g() has external linkage\n");
        stringBuffer.append("static char* g() // error: inconsistent linkage\n");
        stringBuffer.append("{ // \n");
        stringBuffer.append("}\n");
        stringBuffer.append("void h();\n");
        stringBuffer.append("inline void h(); // external linkage\n");
        stringBuffer.append("inline void l();\n");
        stringBuffer.append("void l(); // external linkage\n");
        stringBuffer.append("inline void m();\n");
        stringBuffer.append("extern void m(); // external linkage\n");
        stringBuffer.append("static void n();\n");
        stringBuffer.append("inline void n(); // internal linkage\n");
        stringBuffer.append("static int a; // a has internal linkage\n");
        stringBuffer.append("int a; // error: two definitions\n");
        stringBuffer.append("static int b; // b has internal linkage\n");
        stringBuffer.append("extern int b; // b still has internal linkage\n");
        stringBuffer.append("int c; // c has external linkage\n");
        stringBuffer.append("static int c; // error: inconsistent linkage\n");
        stringBuffer.append("extern int d; // d has external linkage\n");
        stringBuffer.append("static int d; // error: inconsistent linkage\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test7_1_1s8a() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct S;\n");
        stringBuffer.append("extern S a;\n");
        stringBuffer.append("extern S f();\n");
        stringBuffer.append("extern void g(S);\n");
        stringBuffer.append("void h()\n");
        stringBuffer.append("{\n");
        stringBuffer.append("g(a); //error: S is incomplete\n");
        stringBuffer.append("f(); //error: S is incomplete\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test7_1_1s8b() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class X {\n");
        stringBuffer.append("mutable const int* p; // OK\n");
        stringBuffer.append("mutable int* const q; // illformed\n");
        stringBuffer.append("};\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test7_1_3s1() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("typedef int MILES, *KLICKSP;\n");
        stringBuffer.append("MILES distance;\n");
        stringBuffer.append("extern KLICKSP metricp;\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test7_1_3s2() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("typedef struct s { //\n");
        stringBuffer.append("} s;\n");
        stringBuffer.append("typedef int I;\n");
        stringBuffer.append("typedef int I;\n");
        stringBuffer.append("typedef I I;\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test7_1_3s3a() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class complex { // \n");
        stringBuffer.append("};\n");
        stringBuffer.append("typedef int complex; // error: redefinition\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test7_1_3s3b() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("typedef int complex;\n");
        stringBuffer.append("class complex { // \n");
        stringBuffer.append("}; // error: redefinition\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test7_1_3s4() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct S {\n");
        stringBuffer.append("S();\n");
        stringBuffer.append("~S();\n");
        stringBuffer.append("};\n");
        stringBuffer.append("typedef struct S T;\n");
        stringBuffer.append("S a = T(); // OK\n");
        stringBuffer.append("struct T * p; // error\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test7_1_3s5a() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("typedef struct { } *ps, S; // S is the class name for linkage purposes\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test7_1_3s5b() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("typedef struct {\n");
        stringBuffer.append("S(); //error: requires a return type because S is\n");
        stringBuffer.append("// an ordinary member function, not a constructor\n");
        stringBuffer.append("} S;\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test7_1_5_1s5() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int foo() {\n");
        stringBuffer.append("const int ci = 3; // cvqualified (initialized as required)\n");
        stringBuffer.append("ci = 4; // illformed: attempt to modify const\n");
        stringBuffer.append("int i = 2; // not cvqualified\n");
        stringBuffer.append("const int* cip; // pointer to const int\n");
        stringBuffer.append("cip = &i; // OK: cvqualified access path to unqualified\n");
        stringBuffer.append("*cip = 4; // illformed: attempt to modify through ptr to const\n");
        stringBuffer.append("int* ip;\n");
        stringBuffer.append("ip = const_cast<int*>(cip); // cast needed to convert const int* to int*\n");
        stringBuffer.append("*ip = 4; // defined: *ip points to i, a nonconst object\n");
        stringBuffer.append("const int* ciq = new const int (3); // initialized as required\n");
        stringBuffer.append("int* iq = const_cast<int*>(ciq); // cast required\n");
        stringBuffer.append("*iq = 4; // undefined: modifies a const object\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test7_1_5_1s6() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class X {\n");
        stringBuffer.append("public:\n");
        stringBuffer.append("mutable int i;\n");
        stringBuffer.append("int j;\n");
        stringBuffer.append("};\n");
        stringBuffer.append("class Y {\n");
        stringBuffer.append("public:\n");
        stringBuffer.append("X x;\n");
        stringBuffer.append("Y();\n");
        stringBuffer.append("};\n");
        stringBuffer.append("\n");
        stringBuffer.append("int foo() {\n");
        stringBuffer.append("const Y y;\n");
        stringBuffer.append("y.x.i++; //wellformed: mutable member can be modified\n");
        stringBuffer.append("y.x.j++; //illformed: constqualified member modified\n");
        stringBuffer.append("Y* p = const_cast<Y*>(&y); // cast away constness of y\n");
        stringBuffer.append("p->x.i = 99; // wellformed: mutable member can be modified\n");
        stringBuffer.append("p->x.j = 99; // undefined: modifies a const member\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test7_2s2() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("enum { a, b, c=0 };\n");
        stringBuffer.append("enum { d, e, f=e+2 };\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test7_2s3() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int foo() {\n");
        stringBuffer.append("const int x = 12;\n");
        stringBuffer.append("{ enum { x = x }; }\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test7_2s8() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int foo() {\n");
        stringBuffer.append("enum color { red, yellow, green=20, blue };\n");
        stringBuffer.append("color col = red;\n");
        stringBuffer.append("color* cp = &col;\n");
        stringBuffer.append("if (*cp == blue) // ...\n");
        stringBuffer.append("return 0;\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test7_2s10() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class X {\n");
        stringBuffer.append("public:\n");
        stringBuffer.append("enum direction { left='l', right='r' };\n");
        stringBuffer.append("int f(int i)\n");
        stringBuffer.append("{ return i==left ? 0 : i==right ? 1 : 2; }\n");
        stringBuffer.append("};\n");
        stringBuffer.append("void g(X* p)\n");
        stringBuffer.append("{\n");
        stringBuffer.append("direction d; // error: direction not in scope\n");
        stringBuffer.append("int i;\n");
        stringBuffer.append("i = p->f(left); // error: left not in scope\n");
        stringBuffer.append("i = p>\n");
        stringBuffer.append("f(X::right); // OK\n");
        stringBuffer.append("i = p>\n");
        stringBuffer.append("f(p->left); // OK\n");
        stringBuffer.append("// ...\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, false, 0);
    }

    public void test7_3_1s5() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("namespace Outer {\n");
        stringBuffer.append("int i;\n");
        stringBuffer.append("namespace Inner {\n");
        stringBuffer.append("void f() { i++; } // Outer::i\n");
        stringBuffer.append("int i;\n");
        stringBuffer.append("void g() { i++; } // Inner::i\n");
        stringBuffer.append("}\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test7_3_1_1s1() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("namespace { int i; } // unique::i\n");
        stringBuffer.append("void f() { i++; } // unique::i++\n");
        stringBuffer.append("namespace A {\n");
        stringBuffer.append("namespace {\n");
        stringBuffer.append("int i; // A::unique::i\n");
        stringBuffer.append("int j; // A::unique::j\n");
        stringBuffer.append("}\n");
        stringBuffer.append("void g() { i++; } // A::unique::i++\n");
        stringBuffer.append("}\n");
        stringBuffer.append("using namespace A;\n");
        stringBuffer.append("void h() {\n");
        stringBuffer.append("i++; //error: unique::i or A::unique::i\n");
        stringBuffer.append("A::i++; // A::unique::i\n");
        stringBuffer.append("j++; // A::unique::j\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, false, 0);
    }

    public void test7_3_1_2s1() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("namespace X {\n");
        stringBuffer.append("void f() { //\n");
        stringBuffer.append("}\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test7_3_1_2s2() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("namespace Q {\n");
        stringBuffer.append("namespace V {\n");
        stringBuffer.append("void f();\n");
        stringBuffer.append("}\n");
        stringBuffer.append("void V::f() { } // OK\n");
        stringBuffer.append("void V::g() { } // error: g() is not yet a member of V\n");
        stringBuffer.append("namespace V {\n");
        stringBuffer.append("void g();\n");
        stringBuffer.append("}\n");
        stringBuffer.append("}\n");
        stringBuffer.append("namespace R {\n");
        stringBuffer.append("void Q::V::g() {  } // error: R doesn\ufffdt enclose Q\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 2);
    }

    public void test7_3_1_2s3() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("// Assume f and g have not yet been defined.\n");
        stringBuffer.append("void h(int);\n");
        stringBuffer.append("namespace A {\n");
        stringBuffer.append("class X {\n");
        stringBuffer.append("friend void f(X); // A::f is a friend\n");
        stringBuffer.append("class Y {\n");
        stringBuffer.append("friend void g(); // A::g is a friend\n");
        stringBuffer.append("friend void h(int); // A::h is a friend\n");
        stringBuffer.append("// ::h not considered\n");
        stringBuffer.append("};\n");
        stringBuffer.append("};\n");
        stringBuffer.append("// A::f, A::g and A::h are not visible here\n");
        stringBuffer.append("X x;\n");
        stringBuffer.append("void g() { f(x); } // definition of A::g\n");
        stringBuffer.append("void f(X) { } // definition of A::f\n");
        stringBuffer.append("void h(int) { } // definition of A::h\n");
        stringBuffer.append("// A::f, A::g and A::h are visible here and known to be friends\n");
        stringBuffer.append("}\n");
        stringBuffer.append("using A::x;\n");
        stringBuffer.append("void h()\n");
        stringBuffer.append("{\n");
        stringBuffer.append("A::f(x);\n");
        stringBuffer.append("A::X::f(x); //error: f is not a member of A::X\n");
        stringBuffer.append("A::X::Y::g(); // error: g is not a member of A::X::Y\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 4);
    }

    public void test7_3_2s3() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("namespace Company_with_very_long_name {  }\n");
        stringBuffer.append("namespace CWVLN = Company_with_very_long_name;\n");
        stringBuffer.append("namespace CWVLN = Company_with_very_long_name; // OK: duplicate\n");
        stringBuffer.append("namespace CWVLN = CWVLN;\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test7_3_3s3() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct B {\n");
        stringBuffer.append("void f(char);\n");
        stringBuffer.append("void g(char);\n");
        stringBuffer.append("enum E { e };\n");
        stringBuffer.append("union { int x; };\n");
        stringBuffer.append("};\n");
        stringBuffer.append("struct D : B {\n");
        stringBuffer.append("using B::f;\n");
        stringBuffer.append("void f(int) { f('c'); } // calls B::f(char)\n");
        stringBuffer.append("void g(int) { g('c'); } // recursively calls D::g(int)\n");
        stringBuffer.append("};\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test7_3_3s4() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class C {\n");
        stringBuffer.append("int g();\n");
        stringBuffer.append("};\n");
        stringBuffer.append("class D2 : public B {\n");
        stringBuffer.append("using B::f; // OK: B is a base of D2\n");
        stringBuffer.append("using B::e; // OK: e is an enumerator of base B\n");
        stringBuffer.append("using B::x; // OK: x is a union member of base B\n");
        stringBuffer.append("using C::g; // error: C isn\ufffdt a base of D2\n");
        stringBuffer.append("};\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, false, 0);
    }

    public void test7_3_3s5() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class A {\n");
        stringBuffer.append("public:\n");
        stringBuffer.append("template <class T> void f(T);\n");
        stringBuffer.append("template <class T> struct X { };\n");
        stringBuffer.append("};\n");
        stringBuffer.append("class B : public A {\n");
        stringBuffer.append("public:\n");
        stringBuffer.append("using A::f<double>; // illformed\n");
        stringBuffer.append("using A::X<int>; // illformed\n");
        stringBuffer.append("};\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test7_3_3s6() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct X {\n");
        stringBuffer.append("int i;\n");
        stringBuffer.append("static int s;\n");
        stringBuffer.append("};\n");
        stringBuffer.append("void f()\n");
        stringBuffer.append("{\n");
        stringBuffer.append("using X::i; // error: X::i is a class member\n");
        stringBuffer.append("// and this is not a member declaration.\n");
        stringBuffer.append("using X::s; // error: X::s is a class member\n");
        stringBuffer.append("// and this is not a member declaration.\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test7_3_3s7() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("void f();\n");
        stringBuffer.append("namespace A {\n");
        stringBuffer.append("void g();\n");
        stringBuffer.append("}\n");
        stringBuffer.append("namespace X {\n");
        stringBuffer.append("using ::f; // global f\n");
        stringBuffer.append("using A::g; // A\ufffds g\n");
        stringBuffer.append("}\n");
        stringBuffer.append("void h()\n");
        stringBuffer.append("{\n");
        stringBuffer.append("X::f(); //calls ::f\n");
        stringBuffer.append("X::g(); //calls A::g\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test7_3_3s8() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("namespace A {\n");
        stringBuffer.append("int i;\n");
        stringBuffer.append("}\n");
        stringBuffer.append("namespace A1 {\n");
        stringBuffer.append("using A::i;\n");
        stringBuffer.append("using A::i; // OK: double declaration\n");
        stringBuffer.append("}\n");
        stringBuffer.append("void f()\n");
        stringBuffer.append("{\n");
        stringBuffer.append("using A::i;\n");
        stringBuffer.append("using A::i; // error: double declaration\n");
        stringBuffer.append("}\n");
        stringBuffer.append("class B {\n");
        stringBuffer.append("public:\n");
        stringBuffer.append("int i;\n");
        stringBuffer.append("};\n");
        stringBuffer.append("class X : public B {\n");
        stringBuffer.append("using B::i;\n");
        stringBuffer.append("using B::i; // error: double member declaration\n");
        stringBuffer.append("};\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test7_3_3s9() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("namespace A {\n");
        stringBuffer.append("void f(int);\n");
        stringBuffer.append("}\n");
        stringBuffer.append("using A::f; // f is a synonym for A::f;\n");
        stringBuffer.append("// that is, for A::f(int).\n");
        stringBuffer.append("namespace A {\n");
        stringBuffer.append("void f(char);\n");
        stringBuffer.append("}\n");
        stringBuffer.append("void foo()\n");
        stringBuffer.append("{\n");
        stringBuffer.append("f('a'); //calls f(int),\n");
        stringBuffer.append("} //even though f(char) exists.\n");
        stringBuffer.append("void bar()\n");
        stringBuffer.append("{\n");
        stringBuffer.append("using A::f; // f is a synonym for A::f;\n");
        stringBuffer.append("// that is, for A::f(int) and A::f(char).\n");
        stringBuffer.append("f('a'); //calls f(char)\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test7_3_3s10() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("namespace A {\n");
        stringBuffer.append("int x;\n");
        stringBuffer.append("}\n");
        stringBuffer.append("namespace B {\n");
        stringBuffer.append("int i;\n");
        stringBuffer.append("struct g { };\n");
        stringBuffer.append("struct x { };\n");
        stringBuffer.append("void f(int);\n");
        stringBuffer.append("void f(double);\n");
        stringBuffer.append("void g(char); // OK: hides struct g\n");
        stringBuffer.append("}\n");
        stringBuffer.append("void func()\n");
        stringBuffer.append("{\n");
        stringBuffer.append("int i;\n");
        stringBuffer.append("//using B::i; // error: i declared twice\n");
        stringBuffer.append("void f(char);\n");
        stringBuffer.append("using B::f; // OK: each f is a function\n");
        stringBuffer.append("f(3.5); //calls B::f(double)\n");
        stringBuffer.append("using B::g;\n");
        stringBuffer.append("g('a'); //calls B::g(char)\n");
        stringBuffer.append("struct g g1; // g1 has class type B::g\n");
        stringBuffer.append("using B::x;\n");
        stringBuffer.append("using A::x; // OK: hides struct B::x\n");
        stringBuffer.append("x = 99; // assigns to A::x\n");
        stringBuffer.append("struct x x1; // x1 has class type B::x\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test7_3_3s11() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("namespace B {\n");
        stringBuffer.append("void f(int);\n");
        stringBuffer.append("void f(double);\n");
        stringBuffer.append("}\n");
        stringBuffer.append("namespace C {\n");
        stringBuffer.append("void f(int);\n");
        stringBuffer.append("void f(double);\n");
        stringBuffer.append("void f(char);\n");
        stringBuffer.append("}\n");
        stringBuffer.append("void h()\n");
        stringBuffer.append("{\n");
        stringBuffer.append("using B::f; // B::f(int) and B::f(double)\n");
        stringBuffer.append("using C::f; // C::f(int), C::f(double), and C::f(char)\n");
        stringBuffer.append("f('h'); //calls C::f(char)\n");
        stringBuffer.append("f(1); //error: ambiguous: B::f(int) or C::f(int) ?\n");
        stringBuffer.append("void f(int); // error:\n");
        stringBuffer.append("// f(int) conflicts with C::f(int) and B::f(int)\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, false, 0);
    }

    public void test7_3_3s12() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct B {\n");
        stringBuffer.append("virtual void f(int);\n");
        stringBuffer.append("virtual void f(char);\n");
        stringBuffer.append("void g(int);\n");
        stringBuffer.append("void h(int);\n");
        stringBuffer.append("};\n");
        stringBuffer.append("struct D : B {\n");
        stringBuffer.append("using B::f;\n");
        stringBuffer.append("void f(int); // OK: D::f(int) overrides B::f(int);\n");
        stringBuffer.append("using B::g;\n");
        stringBuffer.append("void g(char); // OK\n");
        stringBuffer.append("using B::h;\n");
        stringBuffer.append("void h(int); // OK: D::h(int) hides B::h(int)\n");
        stringBuffer.append("};\n");
        stringBuffer.append("void k(D* p)\n");
        stringBuffer.append("{\n");
        stringBuffer.append("p->f(1); //calls D::f(int)\n");
        stringBuffer.append("p->f('a'); //calls B::f(char)\n");
        stringBuffer.append("p->g(1); //calls B::g(int)\n");
        stringBuffer.append("p->g('a'); //calls D::g(char)\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test7_3_3s14() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct A { int x(); };\n");
        stringBuffer.append("struct B : A { };\n");
        stringBuffer.append("struct C : A {\n");
        stringBuffer.append("using A::x;\n");
        stringBuffer.append("int x(int);\n");
        stringBuffer.append("};\n");
        stringBuffer.append("struct D : B, C {\n");
        stringBuffer.append("using C::x;\n");
        stringBuffer.append("int x(double);\n");
        stringBuffer.append("};\n");
        stringBuffer.append("int f(D* d) {\n");
        stringBuffer.append("return d>\n");
        stringBuffer.append("x(); // ambiguous: B::x or C::x\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, false, 0);
    }

    public void test7_3_3s15() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class A {\n");
        stringBuffer.append("private:\n");
        stringBuffer.append("void f(char);\n");
        stringBuffer.append("public:\n");
        stringBuffer.append("void f(int);\n");
        stringBuffer.append("protected:\n");
        stringBuffer.append("void g();\n");
        stringBuffer.append("};\n");
        stringBuffer.append("class B : public A {\n");
        stringBuffer.append("using A::f; // error: A::f(char) is inaccessible\n");
        stringBuffer.append("public:\n");
        stringBuffer.append("using A::g; // B::g is a public synonym for A::g\n");
        stringBuffer.append("};\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test7_3_4s1() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("namespace A {\n");
        stringBuffer.append("int i;\n");
        stringBuffer.append("namespace B {\n");
        stringBuffer.append("namespace C {\n");
        stringBuffer.append("int i;\n");
        stringBuffer.append("}\n");
        stringBuffer.append("using namespace A::B::C;\n");
        stringBuffer.append("void f1() {\n");
        stringBuffer.append("i = 5; // OK, C::i visible in B and hides A::i\n");
        stringBuffer.append("}\n");
        stringBuffer.append("}\n");
        stringBuffer.append("namespace D {\n");
        stringBuffer.append("using namespace B;\n");
        stringBuffer.append("using namespace C;\n");
        stringBuffer.append("void f2() {\n");
        stringBuffer.append("i = 5; // ambiguous, B::C::i or A::i?\n");
        stringBuffer.append("}\n");
        stringBuffer.append("}\n");
        stringBuffer.append("void f3() {\n");
        stringBuffer.append("i = 5; // uses A::i\n");
        stringBuffer.append("}\n");
        stringBuffer.append("}\n");
        stringBuffer.append("void f4() {\n");
        stringBuffer.append("i = 5; // illformed; neither i is visible\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, false, 0);
    }

    public void test7_3_4s2a() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("namespace M {\n");
        stringBuffer.append("int i;\n");
        stringBuffer.append("}\n");
        stringBuffer.append("namespace N {\n");
        stringBuffer.append("int i;\n");
        stringBuffer.append("using namespace M;\n");
        stringBuffer.append("}\n");
        stringBuffer.append("void f()\n");
        stringBuffer.append("{\n");
        stringBuffer.append("using namespace N;\n");
        stringBuffer.append("i = 7; // error: both M::i and N::i are visible\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test7_3_4s2b() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("namespace A {\n");
        stringBuffer.append("int i;\n");
        stringBuffer.append("}\n");
        stringBuffer.append("namespace B {\n");
        stringBuffer.append("int i;\n");
        stringBuffer.append("int j;\n");
        stringBuffer.append("namespace C {\n");
        stringBuffer.append("namespace D {\n");
        stringBuffer.append("using namespace A;\n");
        stringBuffer.append("int j;\n");
        stringBuffer.append("int k;\n");
        stringBuffer.append("int a = i; // B::i hides A::i\n");
        stringBuffer.append("}\n");
        stringBuffer.append("using namespace D;\n");
        stringBuffer.append("int k = 89; // no problem yet\n");
        stringBuffer.append("int l = k; // ambiguous: C::k or D::k\n");
        stringBuffer.append("int m = i; // B::i hides A::i\n");
        stringBuffer.append("int n = j; // D::j hides B::j\n");
        stringBuffer.append("}\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test7_3_4s5() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("namespace D {\n");
        stringBuffer.append("int d1;\n");
        stringBuffer.append("void f(char);\n");
        stringBuffer.append("}\n");
        stringBuffer.append("using namespace D;\n");
        stringBuffer.append("int d1; // OK: no conflict with D::d1\n");
        stringBuffer.append("namespace E {\n");
        stringBuffer.append("int e;\n");
        stringBuffer.append("void f(int);\n");
        stringBuffer.append("}\n");
        stringBuffer.append("namespace D { // namespace extension\n");
        stringBuffer.append("int d2;\n");
        stringBuffer.append("using namespace E;\n");
        stringBuffer.append("void f(int);\n");
        stringBuffer.append("}\n");
        stringBuffer.append("void f()\n");
        stringBuffer.append("{\n");
        stringBuffer.append("d1++; //error: ambiguous ::d1 or D::d1?\n");
        stringBuffer.append("::d1++; //OK\n");
        stringBuffer.append("D::d1++; //OK\n");
        stringBuffer.append("d2++; //OK: D::d2\n");
        stringBuffer.append("e++; //OK: E::e\n");
        stringBuffer.append("f(1); //error: ambiguous: D::f(int) or E::f(int)?\n");
        stringBuffer.append("f('a'); //OK: D::f(char)\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, false, 0);
    }

    public void test7_5s3() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("complex sqrt(complex); // C++ linkage by default\n");
        stringBuffer.append("extern \"C\" {\n");
        stringBuffer.append("double sqrt(double); // C linkage\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, false, 0);
    }

    public void test7_5s4a() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("extern \"C\" void f1(void(*pf)(int));\n");
        stringBuffer.append("// the name f1 and its function type have C language\n");
        stringBuffer.append("// linkage; pf is a pointer to a C function\n");
        stringBuffer.append("extern \"C\" typedef void FUNC();\n");
        stringBuffer.append("FUNC f2; // the name f2 has C++ language linkage and the\n");
        stringBuffer.append("// function\ufffds type has C language linkage\n");
        stringBuffer.append("extern \"C\" FUNC f3; // the name of function f3 and the function\ufffds type\n");
        stringBuffer.append("// have C language linkage\n");
        stringBuffer.append("void (*pf2)(FUNC*); // the name of the variable pf2 has C++ linkage and\n");
        stringBuffer.append("// the type of pf2 is pointer to C++ function that\n");
        stringBuffer.append("// takes one parameter of type pointer to C function\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test7_5s4b() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("extern \"C\" typedef void FUNC_c();\n");
        stringBuffer.append("class C {\n");
        stringBuffer.append("void mf1(FUNC_c*); // the name of the function mf1 and the member\n");
        stringBuffer.append("// function\ufffds type have C++ language linkage; the\n");
        stringBuffer.append("// parameter has type pointer to C function\n");
        stringBuffer.append("FUNC_c mf2; // the name of the function mf2 and the member\n");
        stringBuffer.append("// function\ufffds type have C++ language linkage\n");
        stringBuffer.append("static FUNC_c* q; // the name of the data member q has C++ language\n");
        stringBuffer.append("// linkage and the data member\ufffds type is pointer to\n");
        stringBuffer.append("// C function\n");
        stringBuffer.append("};\n");
        stringBuffer.append("extern \"C\" {\n");
        stringBuffer.append("class X {\n");
        stringBuffer.append("void mf(); // the name of the function mf and the member\n");
        stringBuffer.append("// function\ufffds type have C++ language linkage\n");
        stringBuffer.append("void mf2(void(*)()); // the name of the function mf2 has C++ language\n");
        stringBuffer.append("// linkage; the parameter has type pointer to\n");
        stringBuffer.append("// C function\n");
        stringBuffer.append("};\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test7_5s6() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("namespace A {\n");
        stringBuffer.append("extern \"C\" int f();\n");
        stringBuffer.append("extern \"C\" int g() { return 1; }\n");
        stringBuffer.append("extern \"C\" int h();\n");
        stringBuffer.append("}\n");
        stringBuffer.append("namespace B {\n");
        stringBuffer.append("extern \"C\" int f(); // A::f and B::f refer\n");
        stringBuffer.append("// to the same function\n");
        stringBuffer.append("extern \"C\" int g() { return 1; } // illformed,\n");
        stringBuffer.append("// the function g\n");
        stringBuffer.append("// with C language linkage\n");
        stringBuffer.append("// has two definitions\n");
        stringBuffer.append("}\n");
        stringBuffer.append("int A::f() { return 98; } // definition for the function f\n");
        stringBuffer.append("// with C language linkage\n");
        stringBuffer.append("extern \"C\" int h() { return 97; }\n");
        stringBuffer.append("// definition for the function h\n");
        stringBuffer.append("// with C language linkage\n");
        stringBuffer.append("// A::h and ::h refer to the same function\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test7_5s7a() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("extern \"C\" double f();\n");
        stringBuffer.append("static double f(); // error\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test7_5s7b() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("extern \"C\" int i; // declaration\n");
        stringBuffer.append("extern \"C\" {\n");
        stringBuffer.append("int i; // definition\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test7_5s7c() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("extern \"C\" static void f(); // error\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test8_1s1() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int i;\n");
        stringBuffer.append("int *pi;\n");
        stringBuffer.append("int *p[3];\n");
        stringBuffer.append("int (*p3i)[3];\n");
        stringBuffer.append("int *f();\n");
        stringBuffer.append("int (*pf)(double);\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test8_2s1() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct S {\n");
        stringBuffer.append("S(int);\n");
        stringBuffer.append("};\n");
        stringBuffer.append("void foo(double a)\n");
        stringBuffer.append("{\n");
        stringBuffer.append("S w(int(a)); // function declaration\n");
        stringBuffer.append("S x(int()); // function declaration\n");
        stringBuffer.append("S y((int)a); // object declaration\n");
        stringBuffer.append("S z = int(a); // object declaration\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test8_2s5() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("void foo()\n");
        stringBuffer.append("{\n");
        stringBuffer.append("sizeof(int(1)); // expression\n");
        stringBuffer.append("// sizeof(int()); // typeid (illformed)\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test8_2s6() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("void foo()\n");
        stringBuffer.append("{\n");
        stringBuffer.append("(int(1)); //expression\n");
        stringBuffer.append("// (int())1; //typeid (illformed)\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test8_2s7b() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class C { };\n");
        stringBuffer.append("void h(int *(C[10])); // void h(int *(*_fp)(C _parm[10]));\n");
        stringBuffer.append("// not: void h(int *C[10]);\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test8_3s1() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("namespace A {\n");
        stringBuffer.append("struct B {\n");
        stringBuffer.append("void f();\n");
        stringBuffer.append("};\n");
        stringBuffer.append("void A::B::f() { } // illformed: the declarator must not be\n");
        stringBuffer.append("// qualified with A::\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test8_3s4() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int unsigned i;\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test8_3_1s2a() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("const int ci = 10, *pc = &ci, *const cpc = pc, **ppc;\n");
        stringBuffer.append("int i, *p, *const cp = &i;\n");
        stringBuffer.append("\n");
        stringBuffer.append("int f() {\n");
        stringBuffer.append("i = ci;\n");
        stringBuffer.append("*cp = ci;\n");
        stringBuffer.append("pc++;\n");
        stringBuffer.append("pc = cpc;\n");
        stringBuffer.append("pc = p;\n");
        stringBuffer.append("ppc = &pc;\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test8_3_1s2b() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("const int ci = 10, *pc = &ci, *const cpc = pc, **ppc;\n");
        stringBuffer.append("int i, *p, *const cp = &i;\n");
        stringBuffer.append("int f() {\n");
        stringBuffer.append("ci = 1; // error\n");
        stringBuffer.append("ci++; //error\n");
        stringBuffer.append("*pc = 2; // error\n");
        stringBuffer.append("cp = &ci; // error\n");
        stringBuffer.append("cpc++; //error\n");
        stringBuffer.append("p = pc; // error\n");
        stringBuffer.append("ppc = &p; // error\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test8_3_1s2c() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("const int ci = 10, *pc = &ci, *const cpc = pc, **ppc;\n");
        stringBuffer.append("int i, *p, *const cp = &i;\n");
        stringBuffer.append("int f() {\n");
        stringBuffer.append("*ppc = &ci; // OK, but would make p point to ci ...\n");
        stringBuffer.append("*p = 5; // clobber ci\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test8_3_2s1() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("typedef int& A;\n");
        stringBuffer.append("const A aref = 3; // illformed;\n");
        stringBuffer.append("// nonconst reference initialized with rvalue\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test8_3_2s2() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("void f(double& a) { a += 3.14; }\n");
        stringBuffer.append("// ...\n");
        stringBuffer.append("int foo() {\n");
        stringBuffer.append("double d = 0;\n");
        stringBuffer.append("f(d);\n");
        stringBuffer.append("int v[20];\n");
        stringBuffer.append("// ...\n");
        stringBuffer.append("int& g(int i) { return v[i]; }\n");
        stringBuffer.append("// ...\n");
        stringBuffer.append("g(3) = 7;\n");
        stringBuffer.append("}\n");
        stringBuffer.append("struct link {\n");
        stringBuffer.append("link* next;\n");
        stringBuffer.append("};\n");
        stringBuffer.append("link* first;\n");
        stringBuffer.append("void h(link*& p) // p is a reference to pointer\n");
        stringBuffer.append("{\n");
        stringBuffer.append("p->next = first;\n");
        stringBuffer.append("first = p;\n");
        stringBuffer.append("p = 0;\n");
        stringBuffer.append("}\n");
        stringBuffer.append("void k()\n");
        stringBuffer.append("{\n");
        stringBuffer.append("link* q = new link;\n");
        stringBuffer.append("h(q);\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test8_3_3s2() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class X {\n");
        stringBuffer.append("public:\n");
        stringBuffer.append("void f(int);\n");
        stringBuffer.append("int a;\n");
        stringBuffer.append("};\n");
        stringBuffer.append("class Y;\n");
        stringBuffer.append("\n");
        stringBuffer.append("void f() {\n");
        stringBuffer.append("int X::* pmi = &X::a;\n");
        stringBuffer.append("void (X::* pmf)(int) = &X::f;\n");
        stringBuffer.append("double X::* pmd;\n");
        stringBuffer.append("char Y::* pmc;\n");
        stringBuffer.append("X obj;\n");
        stringBuffer.append("//...\n");
        stringBuffer.append("obj.*pmi = 7; // assign 7 to an integer\n");
        stringBuffer.append("// member of obj\n");
        stringBuffer.append("(obj.*pmf)(7); //call a function member of obj\n");
        stringBuffer.append("// with the argument 7\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test8_3_4s1() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("typedef int A[5], AA[2][3];\n");
        stringBuffer.append("typedef const A CA; // type is \ufffd\ufffdarray of 5 const int\ufffd\ufffd\n");
        stringBuffer.append("typedef const AA CAA; // type is \ufffd\ufffdarray of 2 array of 3 const int\ufffd\ufffd\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test8_3_4s4() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("float fa[17], *afp[17];\n");
        stringBuffer.append("static int x3d[3][5][7];\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test8_3_4s8() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int x[3][5];\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test8_3_5s2() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int printf(const char*, ...);\n");
        stringBuffer.append("int f() {\n");
        stringBuffer.append("int a=1, b=0;\n");
        stringBuffer.append("printf(\"hello world\");\n");
        stringBuffer.append("printf(\"a=%d b=%d\", a, b);\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test8_3_5s4() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("typedef void F();\n");
        stringBuffer.append("struct S {\n");
        stringBuffer.append("const F f; // illformed:\n");
        stringBuffer.append("// not equivalent to: void f() const;\n");
        stringBuffer.append("};\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test8_3_5s5() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("#define FILE int\n");
        stringBuffer.append("int fseek(FILE*, long, int);\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test8_3_5s7a() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("typedef void F();\n");
        stringBuffer.append("F fv; // OK: equivalent to void fv();\n");
        stringBuffer.append("// F fv { } // illformed\n");
        stringBuffer.append("void fv() { } // OK: definition of fv\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test8_3_5s7b() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("typedef int FIC(int) const;\n");
        stringBuffer.append("FIC f; // illformed:\n");
        stringBuffer.append("//does not declare a member function\n");
        stringBuffer.append("struct S {\n");
        stringBuffer.append("FIC f; // OK\n");
        stringBuffer.append("};\n");
        stringBuffer.append("FIC S::*pm = &S::f; // OK\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test8_3_5s9a() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int i,\n");
        stringBuffer.append("*pi,\n");
        stringBuffer.append("f(),\n");
        stringBuffer.append("*fpi(int),\n");
        stringBuffer.append("(*pif)(const char*, const char*);\n");
        stringBuffer.append("(*fpif(int))(int);\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test8_3_5s9b() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("typedef int IFUNC(int);\n");
        stringBuffer.append("IFUNC* fpif(int);\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test8_3_6s2() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("void point(int = 3, int = 4);\n");
        stringBuffer.append("void f() {\n");
        stringBuffer.append("point(1,2); point(1); point();\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test8_3_6s4() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("void f(int, int);\n");
        stringBuffer.append("void f(int, int = 7);\n");
        stringBuffer.append("void h()\n");
        stringBuffer.append("{\n");
        stringBuffer.append("f(3); //OK, calls f(3, 7)\n");
        stringBuffer.append("void f(int = 1, int); // error: does not use default\n");
        stringBuffer.append("// from surrounding scope\n");
        stringBuffer.append("}\n");
        stringBuffer.append("void m()\n");
        stringBuffer.append("{\n");
        stringBuffer.append("void f(int, int); // has no defaults\n");
        stringBuffer.append("f(4); //error: wrong number of arguments\n");
        stringBuffer.append("void f(int, int = 5); // OK\n");
        stringBuffer.append("f(4); //OK, calls f(4, 5);\n");
        stringBuffer.append("void f(int, int = 5); // error: cannot redefine, even to\n");
        stringBuffer.append("// same value\n");
        stringBuffer.append("}\n");
        stringBuffer.append("void n()\n");
        stringBuffer.append("{\n");
        stringBuffer.append("f(6); //OK, calls f(6, 7)\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, false, 0);
    }

    public void test8_3_6s5() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int a = 1;\n");
        stringBuffer.append("int f(int);\n");
        stringBuffer.append("int g(int x = f(a)); // default argument: f(::a)\n");
        stringBuffer.append("void h() {\n");
        stringBuffer.append("a = 2;\n");
        stringBuffer.append("{\n");
        stringBuffer.append("int a = 3;\n");
        stringBuffer.append("g(); // g(f(::a))\n");
        stringBuffer.append("}\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test8_3_6s6() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class C {\n");
        stringBuffer.append("void f(int i = 3);\n");
        stringBuffer.append("void g(int i, int j = 99);\n");
        stringBuffer.append("};\n");
        stringBuffer.append("void C::f(int i = 3) // error: default argument already\n");
        stringBuffer.append("{ } // specified in class scope\n");
        stringBuffer.append("void C::g(int i = 88, int j) // in this translation unit,\n");
        stringBuffer.append("{ }\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test8_3_6s7() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("void f()\n");
        stringBuffer.append("{\n");
        stringBuffer.append("int i;\n");
        stringBuffer.append("extern void g(int x = i); // error\n");
        stringBuffer.append("// ...\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test8_3_6s8() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class A {\n");
        stringBuffer.append("void f(A* p = this) { } // error\n");
        stringBuffer.append("};\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test8_3_6s9a() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int a;\n");
        stringBuffer.append("int f(int a, int b = a); // error: parameter a\n");
        stringBuffer.append("// used as default argument\n");
        stringBuffer.append("typedef int I;\n");
        stringBuffer.append("int g(float I, int b = I(2)); // error: parameter I found\n");
        stringBuffer.append("int h(int a, int b = sizeof(a)); // error, parameter a used\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, false, 0);
    }

    public void test8_3_6s9b() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int b;\n");
        stringBuffer.append("class X {\n");
        stringBuffer.append("int a;\n");
        stringBuffer.append("int mem1(int i = a); // error: nonstatic member a\n");
        stringBuffer.append("// used as default argument\n");
        stringBuffer.append("int mem2(int i = b); // OK; use X::b\n");
        stringBuffer.append("static int b;\n");
        stringBuffer.append("};\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test8_3_6s9c() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int f(int = 0);\n");
        stringBuffer.append("void h()\n");
        stringBuffer.append("{\n");
        stringBuffer.append("int j = f(1);\n");
        stringBuffer.append("int k = f(); // OK, means f(0)\n");
        stringBuffer.append("}\n");
        stringBuffer.append("int (*p1)(int) = &f;\n");
        stringBuffer.append("int (*p2)() = &f; // error: type mismatch\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test8_3_6s10() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct A {\n");
        stringBuffer.append("virtual void f(int a = 7);\n");
        stringBuffer.append("};\n");
        stringBuffer.append("struct B : public A {\n");
        stringBuffer.append("void f(int a);\n");
        stringBuffer.append("};\n");
        stringBuffer.append("void m()\n");
        stringBuffer.append("{\n");
        stringBuffer.append("B* pb = new B;\n");
        stringBuffer.append("A* pa = pb;\n");
        stringBuffer.append("pa->f(); //OK, calls pa->B::f(7)\n");
        stringBuffer.append("pb->f(); //error: wrong number of arguments for B::f()\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, false, 0);
    }

    public void test8_4s2() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int max(int a, int b, int c)\n");
        stringBuffer.append("{\n");
        stringBuffer.append("int m = (a > b) ? a : b;\n");
        stringBuffer.append("return (m > c) ? m : c;\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test8_5s10() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int a;\n");
        stringBuffer.append("struct X {\n");
        stringBuffer.append("static int a;\n");
        stringBuffer.append("static int b;\n");
        stringBuffer.append("};\n");
        stringBuffer.append("int X::a = 1;\n");
        stringBuffer.append("int X::b = a; // X::b = X::a\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test8_5_1s2() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct A {\n");
        stringBuffer.append("int x;\n");
        stringBuffer.append("struct B {\n");
        stringBuffer.append("int i;\n");
        stringBuffer.append("int j;\n");
        stringBuffer.append("} b;\n");
        stringBuffer.append("} a = { 1, { 2, 3 } };\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test8_5_1s4() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int x[] = { 1, 3, 5 };\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test8_5_1s5() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct A {\n");
        stringBuffer.append("int i;\n");
        stringBuffer.append("static int s;\n");
        stringBuffer.append("int j;\n");
        stringBuffer.append("} a = { 1, 2 };\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test8_5_1s6() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("char cv[4] = { 'a', 's', 'd', 'f', 0 }; // error\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test8_5_1s7() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct S { int a; char* b; int c; };\n");
        stringBuffer.append("S ss = { 1, \"asdf\" };\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test8_5_1s8() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct S { };\n");
        stringBuffer.append("struct A {\n");
        stringBuffer.append("S s;\n");
        stringBuffer.append("int i;\n");
        stringBuffer.append("} a = { { } , 3 };\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test8_5_1s10() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int x[2][2] = { 3, 1, 4, 2 };\n");
        stringBuffer.append("float y[4][3] = {\n");
        stringBuffer.append("{ 1 }, { 2 }, { 3 }, { 4 }\n");
        stringBuffer.append("};\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test8_5_1s11a() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("float y[4][3] = {\n");
        stringBuffer.append("{ 1, 3, 5 },\n");
        stringBuffer.append("{ 2, 4, 6 },\n");
        stringBuffer.append("{ 3, 5, 7 },\n");
        stringBuffer.append("};\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test8_5_1s11b() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("float y[4][3] = {\n");
        stringBuffer.append("1, 3, 5, 2, 4, 6, 3, 5, 7\n");
        stringBuffer.append("};\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test8_5_1s12() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct A {\n");
        stringBuffer.append("int i;\n");
        stringBuffer.append("operator int();\n");
        stringBuffer.append("};\n");
        stringBuffer.append("struct B {\n");
        stringBuffer.append("A a1, a2;\n");
        stringBuffer.append("int z;\n");
        stringBuffer.append("};\n");
        stringBuffer.append("A a;\n");
        stringBuffer.append("B b = { 4, a, a };\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test8_5_1s15() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("union u { int a; char* b; };\n");
        stringBuffer.append("u a = { 1 };\n");
        stringBuffer.append("u b = a;\n");
        stringBuffer.append("u c = 1; // error\n");
        stringBuffer.append("u d = { 0, \"asdf\" }; // error\n");
        stringBuffer.append("u e = { \"asdf\" }; // error\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test8_5_2s2() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\tchar cv[4] = \"asdf\"; // error\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test8_5_3s2() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int& r1; // error: initializer missing\n");
        stringBuffer.append("extern int& r2; // OK\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test8_5_3s5a() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("double d = 2.0;\n");
        stringBuffer.append("double& rd = d; // rd refers to d\n");
        stringBuffer.append("const double& rcd = d; // rcd refers to d\n");
        stringBuffer.append("struct A { };\n");
        stringBuffer.append("struct B : public A { } b;\n");
        stringBuffer.append("A& ra = b; // ra refers to A subobject in b\n");
        stringBuffer.append("const A& rca = b; // rca refers to A subobject in b\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test8_5_3s5b() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("double& rd2 = 2.0; // error: not an lvalue and reference not const\n");
        stringBuffer.append("int i = 2;\n");
        stringBuffer.append("double& rd3 = i; // error: type mismatch and reference not const\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test8_5_3s5c() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct A { };\n");
        stringBuffer.append("struct B : public A { } b;\n");
        stringBuffer.append("extern B f();\n");
        stringBuffer.append("const A& rca = f(); // Either bound to the A subobject of the B rvalue,\n");
        stringBuffer.append("// or the entire B object is copied and the reference\n");
        stringBuffer.append("// is bound to the A subobject of the copy\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test8_5_3s5d() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("const double& rcd2 = 2; // rcd2 refers to temporary with value 2.0\n");
        stringBuffer.append("const volatile int cvi = 1;\n");
        stringBuffer.append("const int& r = cvi; // error: type qualifiers dropped\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test9_1s1() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct X { int a; };\n");
        stringBuffer.append("struct Y { int a; };\n");
        stringBuffer.append("X a1;\n");
        stringBuffer.append("Y a2;\n");
        stringBuffer.append("int a3;\n");
        stringBuffer.append("a1 = a2; // error: Y assigned to X\n");
        stringBuffer.append("a1 = a3; // error: int assigned to X\n");
        stringBuffer.append("int f(X);\n");
        stringBuffer.append("int f(Y);\n");
        stringBuffer.append("struct S { int a; };\n");
        stringBuffer.append("struct S { int a; }; // error, double definition\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, false, 0);
    }

    public void test9_1s2a() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct stat {\n");
        stringBuffer.append("// ...\n");
        stringBuffer.append("};\n");
        stringBuffer.append("stat gstat; // use plain stat to\n");
        stringBuffer.append("// define variable\n");
        stringBuffer.append("int stat(struct stat*); // redeclare stat as function\n");
        stringBuffer.append("void f()\n");
        stringBuffer.append("{\n");
        stringBuffer.append("struct stat* ps; // struct prefix needed\n");
        stringBuffer.append("// to name struct stat\n");
        stringBuffer.append("// ...\n");
        stringBuffer.append("stat(ps); //call stat()\n");
        stringBuffer.append("// ...\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test9_1s2b() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct s { int a; };\n");
        stringBuffer.append("void g()\n");
        stringBuffer.append("{\n");
        stringBuffer.append("struct s; // hide global struct s\n");
        stringBuffer.append("// with a local declaration\n");
        stringBuffer.append("s* p; // refer to local struct s\n");
        stringBuffer.append("struct s { char* p; }; // define local struct s\n");
        stringBuffer.append("struct s; // redeclaration, has no effect\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test9_1s2c() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class Vector;\n");
        stringBuffer.append("class Matrix {\n");
        stringBuffer.append("// ...\n");
        stringBuffer.append("friend Vector operator*(Matrix&, Vector&);\n");
        stringBuffer.append("};\n");
        stringBuffer.append("class Vector {\n");
        stringBuffer.append("// ...\n");
        stringBuffer.append("friend Vector operator*(Matrix&, Vector&);\n");
        stringBuffer.append("};\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test9_1s3() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct s { int a; };\n");
        stringBuffer.append("void g(int s)\n");
        stringBuffer.append("{\n");
        stringBuffer.append("struct s* p = new struct s; // global s\n");
        stringBuffer.append("p->a = s; // local s\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test9_1s4() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class A * A;\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test9_2s11() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct tnode {\n");
        stringBuffer.append("char tword[20];\n");
        stringBuffer.append("int count;\n");
        stringBuffer.append("tnode *left;\n");
        stringBuffer.append("tnode *right;\n");
        stringBuffer.append("};\n");
        stringBuffer.append("tnode s, *sp;\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test9_3s5() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct X {\n");
        stringBuffer.append("typedef int T;\n");
        stringBuffer.append("static T count;\n");
        stringBuffer.append("void f(T);\n");
        stringBuffer.append("};\n");
        stringBuffer.append("void X::f(T t = count) { }\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test9_3s9() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("typedef void fv(void);\n");
        stringBuffer.append("typedef void fvc(void) const;\n");
        stringBuffer.append("struct S {\n");
        stringBuffer.append("fv memfunc1; // equivalent to: void memfunc1(void);\n");
        stringBuffer.append("void memfunc2();\n");
        stringBuffer.append("fvc memfunc3; // equivalent to: void memfunc3(void) const;\n");
        stringBuffer.append("};\n");
        stringBuffer.append("fv S::* pmfv1 = &S::memfunc1;\n");
        stringBuffer.append("fv S::* pmfv2 = &S::memfunc2;\n");
        stringBuffer.append("fvc S::* pmfv3 = &S::memfunc3;\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test9_3_1s2() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct tnode {\n");
        stringBuffer.append("char tword[20];\n");
        stringBuffer.append("int count;\n");
        stringBuffer.append("tnode *left;\n");
        stringBuffer.append("tnode *right;\n");
        stringBuffer.append("void set(char*, tnode* l, tnode* r);\n");
        stringBuffer.append("};\n");
        stringBuffer.append("void tnode::set(char* w, tnode* l, tnode* r)\n");
        stringBuffer.append("{\n");
        stringBuffer.append("count = strlen(w)+1;\n");
        stringBuffer.append("if (sizeof(tword)<=count)\n");
        stringBuffer.append("perror(\"tnode string too long\");\n");
        stringBuffer.append("strcpy(tword,w);\n");
        stringBuffer.append("left = l;\n");
        stringBuffer.append("right = r;\n");
        stringBuffer.append("}\n");
        stringBuffer.append("void f(tnode n1, tnode n2)\n");
        stringBuffer.append("{\n");
        stringBuffer.append("n1.set(\"abc\",&n2,0);\n");
        stringBuffer.append("n2.set(\"def\",0,0);\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, false, 0);
    }

    public void test9_3_1s3() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct X {\n");
        stringBuffer.append("void g() const;\n");
        stringBuffer.append("void h() const volatile;\n");
        stringBuffer.append("};\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test9_3_2s2() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct s {\n");
        stringBuffer.append("int a;\n");
        stringBuffer.append("int f() const;\n");
        stringBuffer.append("int g() { return a++; }\n");
        stringBuffer.append("int h() const { return a++; } // error\n");
        stringBuffer.append("};\n");
        stringBuffer.append("int s::f() const { return a; }\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test9_3_2s4() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct s {\n");
        stringBuffer.append("int a;\n");
        stringBuffer.append("int f() const;\n");
        stringBuffer.append("int g() { return a++; }\n");
        stringBuffer.append("};\n");
        stringBuffer.append("int s::f() const { return a; }\n");
        stringBuffer.append("\n");
        stringBuffer.append("void k(s& x, const s& y)\n");
        stringBuffer.append("{\n");
        stringBuffer.append("x.f();\n");
        stringBuffer.append("x.g();\n");
        stringBuffer.append("y.f();\n");
        stringBuffer.append("y.g(); //error\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test9_4s2a() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class process {\n");
        stringBuffer.append("public:\n");
        stringBuffer.append("static void reschedule();\n");
        stringBuffer.append("};\n");
        stringBuffer.append("process& g();\n");
        stringBuffer.append("void f()\n");
        stringBuffer.append("{\n");
        stringBuffer.append("process::reschedule(); // OK: no object necessary\n");
        stringBuffer.append("g().reschedule(); // g() is called\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test9_4s2b() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int g();\n");
        stringBuffer.append("struct X {\n");
        stringBuffer.append("static int g();\n");
        stringBuffer.append("};\n");
        stringBuffer.append("struct Y : X {\n");
        stringBuffer.append("static int i;\n");
        stringBuffer.append("};\n");
        stringBuffer.append("int Y::i = g(); // equivalent to Y::g();\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test9_4_2s2() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class process {\n");
        stringBuffer.append("static process* run_chain;\n");
        stringBuffer.append("static process* running;\n");
        stringBuffer.append("};\n");
        stringBuffer.append("process* process::running = get_main();\n");
        stringBuffer.append("process* process::run_chain = running;\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, false, 0);
    }

    public void test9_5s2() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("void f()\n");
        stringBuffer.append("{\n");
        stringBuffer.append("union { int a; char* p; };\n");
        stringBuffer.append("a = 1;\n");
        stringBuffer.append("// ...\n");
        stringBuffer.append("p = \"Jennifer\";\n");
        stringBuffer.append("// ...\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test9_5s4() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int foo() {\n");
        stringBuffer.append("union { int aa; char* p; } obj, *ptr = &obj;\n");
        stringBuffer.append("aa = 1; // error\n");
        stringBuffer.append("ptr->aa = 1; // OK\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, false, 0);
    }

    public void test9_6s4() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("enum BOOL { f=0, t=1 };\n");
        stringBuffer.append("struct A {\n");
        stringBuffer.append("BOOL b:1;\n");
        stringBuffer.append("};\n");
        stringBuffer.append("A a;\n");
        stringBuffer.append("void f() {\n");
        stringBuffer.append("a.b = t;\n");
        stringBuffer.append("if (a.b == t) // shall yield true\n");
        stringBuffer.append("{  }\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test9_7s1() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int x;\n");
        stringBuffer.append("int y;\n");
        stringBuffer.append("class enclose {\n");
        stringBuffer.append("public:\n");
        stringBuffer.append("int x;\n");
        stringBuffer.append("static int s;\n");
        stringBuffer.append("class inner {\n");
        stringBuffer.append("void f(int i)\n");
        stringBuffer.append("{\n");
        stringBuffer.append("int a = sizeof(x); // error: refers to enclose::x\n");
        stringBuffer.append("x = i; // error: assign to enclose::x\n");
        stringBuffer.append("s = i; // OK: assign to enclose::s\n");
        stringBuffer.append("::x = i; // OK: assign to global x\n");
        stringBuffer.append("y = i; // OK: assign to global y\n");
        stringBuffer.append("}\n");
        stringBuffer.append("void g(enclose* p, int i)\n");
        stringBuffer.append("{\n");
        stringBuffer.append("p>\n");
        stringBuffer.append("x = i; // OK: assign to enclose::x\n");
        stringBuffer.append("}\n");
        stringBuffer.append("};\n");
        stringBuffer.append("};\n");
        stringBuffer.append("inner* p = 0; // error: inner not in scope\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, false, 0);
    }

    public void test9_7s2() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class enclose {\n");
        stringBuffer.append("public:\n");
        stringBuffer.append("class inner {\n");
        stringBuffer.append("static int x;\n");
        stringBuffer.append("void f(int i);\n");
        stringBuffer.append("};\n");
        stringBuffer.append("};\n");
        stringBuffer.append("int enclose::inner::x = 1;\n");
        stringBuffer.append("void enclose::inner::f(int i) {  }\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test9_7s3() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class E {\n");
        stringBuffer.append("class I1; // forward declaration of nested class\n");
        stringBuffer.append("class I2;\n");
        stringBuffer.append("class I1 {}; // definition of nested class\n");
        stringBuffer.append("};\n");
        stringBuffer.append("class E::I2 {}; // definition of nested class\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test9_8s1() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int x;\n");
        stringBuffer.append("void f()\n");
        stringBuffer.append("{\n");
        stringBuffer.append("static int s ;\n");
        stringBuffer.append("int x;\n");
        stringBuffer.append("extern int g();\n");
        stringBuffer.append("struct local {\n");
        stringBuffer.append("int g() { return x; } // error: x is auto\n");
        stringBuffer.append("int h() { return s; } // OK\n");
        stringBuffer.append("int k() { return ::x; } // OK\n");
        stringBuffer.append("int l() { return g(); } // OK\n");
        stringBuffer.append("};\n");
        stringBuffer.append("// ...\n");
        stringBuffer.append("}\n");
        stringBuffer.append("local* p = 0; // error: local not in scope\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, false, 0);
    }

    public void test9_9s1() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class X {\n");
        stringBuffer.append("public:\n");
        stringBuffer.append("typedef int I;\n");
        stringBuffer.append("class Y { /* ... */ };\n");
        stringBuffer.append("I a;\n");
        stringBuffer.append("};\n");
        stringBuffer.append("I b; // error\n");
        stringBuffer.append("Y c; // error\n");
        stringBuffer.append("X::Y d; // OK\n");
        stringBuffer.append("X::I e; // OK\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, false, 0);
    }

    public void test10s2() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class Base {\n");
        stringBuffer.append("public:\n");
        stringBuffer.append("int a, b, c;\n");
        stringBuffer.append("};\n");
        stringBuffer.append("class Derived : public Base {\n");
        stringBuffer.append("public:\n");
        stringBuffer.append("int b;\n");
        stringBuffer.append("};\n");
        stringBuffer.append("class Derived2 : public Derived {\n");
        stringBuffer.append("public:\n");
        stringBuffer.append("int c;\n");
        stringBuffer.append("};\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test10_1s1() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class A {  };\n");
        stringBuffer.append("class B {  };\n");
        stringBuffer.append("class C {  };\n");
        stringBuffer.append("class D : public A, public B, public C {  };\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test10_1s3a() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class X {  };\n");
        stringBuffer.append("class Y : public X, public X {  }; // illformed\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test10_1s3b() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class L { public: int next;  };\n");
        stringBuffer.append("class A : public L {  };\n");
        stringBuffer.append("class B : public L {  };\n");
        stringBuffer.append("class C : public A, public B { void f();  }; // wellformed\n");
        stringBuffer.append("class D : public A, public L { void f();  }; // wellformed\n");
        stringBuffer.append("\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test10_2s3a() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class A {\n");
        stringBuffer.append("public:\n");
        stringBuffer.append("int a;\n");
        stringBuffer.append("int (*b)();\n");
        stringBuffer.append("int f();\n");
        stringBuffer.append("int f(int);\n");
        stringBuffer.append("int g();\n");
        stringBuffer.append("};\n");
        stringBuffer.append("class B {\n");
        stringBuffer.append("int a;\n");
        stringBuffer.append("int b();\n");
        stringBuffer.append("public:\n");
        stringBuffer.append("int f();\n");
        stringBuffer.append("int g;\n");
        stringBuffer.append("int h();\n");
        stringBuffer.append("int h(int);\n");
        stringBuffer.append("};\n");
        stringBuffer.append("class C : public A, public B {};\n");
        stringBuffer.append("void g(C* pc)\n");
        stringBuffer.append("{\n");
        stringBuffer.append("pc->a = 1; // error: ambiguous: A::a or B::a\n");
        stringBuffer.append("pc->b(); //error: ambiguous: A::b or B::b\n");
        stringBuffer.append("pc->f(); //error: ambiguous: A::f or B::f\n");
        stringBuffer.append("pc->f(1); //error: ambiguous: A::f or B::f\n");
        stringBuffer.append("pc->g(); //error: ambiguous: A::g or B::g\n");
        stringBuffer.append("pc->g = 1; // error: ambiguous: A::g or B::g\n");
        stringBuffer.append("pc->h(); //OK\n");
        stringBuffer.append("pc->h(1); //OK\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, false, 0);
    }

    public void test10_2s3b() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct U { static int i; };\n");
        stringBuffer.append("struct V : U { };\n");
        stringBuffer.append("struct W : U { using U::i; };\n");
        stringBuffer.append("struct X : V, W { void foo(); };\n");
        stringBuffer.append("void X::foo() {\n");
        stringBuffer.append("i; //finds U::i in two ways: as W::i and U::i in V\n");
        stringBuffer.append("// no ambiguity because U::i is static\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test10_2s4() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class A {\n");
        stringBuffer.append("public:\n");
        stringBuffer.append("int f();\n");
        stringBuffer.append("};\n");
        stringBuffer.append("class B {\n");
        stringBuffer.append("public:\n");
        stringBuffer.append("int f();\n");
        stringBuffer.append("};\n");
        stringBuffer.append("class C : public A, public B {\n");
        stringBuffer.append("int f() { return A::f() + B::f(); }\n");
        stringBuffer.append("};\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test10_2s5() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class V { public: int v; };\n");
        stringBuffer.append("class A {\n");
        stringBuffer.append("public:\n");
        stringBuffer.append("int a;\n");
        stringBuffer.append("static int s;\n");
        stringBuffer.append("enum { e };\n");
        stringBuffer.append("};\n");
        stringBuffer.append("class B : public A, public virtual V {};\n");
        stringBuffer.append("class C : public A, public virtual V {};\n");
        stringBuffer.append("class D : public B, public C { };\n");
        stringBuffer.append("void f(D* pd)\n");
        stringBuffer.append("{\n");
        stringBuffer.append("pd->v++; //OK: only one v (virtual)\n");
        stringBuffer.append("pd->s++; //OK: only one s (static)\n");
        stringBuffer.append("int i = pd>\n");
        stringBuffer.append("e; // OK: only one e (enumerator)\n");
        stringBuffer.append("pd->a++; //error, ambiguous: two as in D\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, false, 0);
    }

    public void test10_2s6() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class V { public: int f(); int x; };\n");
        stringBuffer.append("class W { public: int g(); int y; };\n");
        stringBuffer.append("class B : public virtual V, public W\n");
        stringBuffer.append("{\n");
        stringBuffer.append("public:\n");
        stringBuffer.append("int f(); int x;\n");
        stringBuffer.append("int g(); int y;\n");
        stringBuffer.append("};\n");
        stringBuffer.append("class C : public virtual V, public W { };\n");
        stringBuffer.append("class D : public B, public C { void glorp(); };\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test10_2s7() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class V { };\n");
        stringBuffer.append("class A { };\n");
        stringBuffer.append("class B : public A, public virtual V { };\n");
        stringBuffer.append("class C : public A, public virtual V { };\n");
        stringBuffer.append("class D : public B, public C { };\n");
        stringBuffer.append("void g()\n");
        stringBuffer.append("{\n");
        stringBuffer.append("D d;\n");
        stringBuffer.append("B* pb = &d;\n");
        stringBuffer.append("A* pa = &d; // error, ambiguous: C\ufffds A or B\ufffds A?\n");
        stringBuffer.append("V* pv = &d; // OK: only one V subobject\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test10_3s2() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct A {\n");
        stringBuffer.append("virtual void f();\n");
        stringBuffer.append("};\n");
        stringBuffer.append("struct B : virtual A {\n");
        stringBuffer.append("virtual void f();\n");
        stringBuffer.append("};\n");
        stringBuffer.append("struct C : B , virtual A {\n");
        stringBuffer.append("using A::f;\n");
        stringBuffer.append("};\n");
        stringBuffer.append("void foo() {\n");
        stringBuffer.append("C c;\n");
        stringBuffer.append("c.f(); //calls B::f, the final overrider\n");
        stringBuffer.append("c.C::f(); //calls A::f because of the usingdeclaration\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test10_3s5() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class B {};\n");
        stringBuffer.append("class D : private B { friend class Derived; };\n");
        stringBuffer.append("struct Base {\n");
        stringBuffer.append("virtual void vf1();\n");
        stringBuffer.append("virtual void vf2();\n");
        stringBuffer.append("virtual void vf3();\n");
        stringBuffer.append("virtual B* vf4();\n");
        stringBuffer.append("virtual B* vf5();\n");
        stringBuffer.append("void f();\n");
        stringBuffer.append("};\n");
        stringBuffer.append("struct No_good : public Base {\n");
        stringBuffer.append("D* vf4(); // error: B (base class of D) inaccessible\n");
        stringBuffer.append("};\n");
        stringBuffer.append("class A;\n");
        stringBuffer.append("struct Derived : public Base {\n");
        stringBuffer.append("void vf1(); // virtual and overrides Base::vf1()\n");
        stringBuffer.append("void vf2(int); // not virtual, hides Base::vf2()\n");
        stringBuffer.append("char vf3(); // error: invalid difference in return type only\n");
        stringBuffer.append("D* vf4(); // OK: returns pointer to derived class\n");
        stringBuffer.append("A* vf5(); // error: returns pointer to incomplete class\n");
        stringBuffer.append("void f();\n");
        stringBuffer.append("};\n");
        stringBuffer.append("void g()\n");
        stringBuffer.append("{\n");
        stringBuffer.append("Derived d;\n");
        stringBuffer.append("Base* bp = &d; // standard conversion:\n");
        stringBuffer.append("// Derived* to Base*\n");
        stringBuffer.append("bp->vf1(); //calls Derived::vf1()\n");
        stringBuffer.append("bp->vf2(); //calls Base::vf2()\n");
        stringBuffer.append("bp->f(); //calls Base::f() (not virtual)\n");
        stringBuffer.append("B* p = bp->vf4(); // calls Derived::pf() and converts the\n");
        stringBuffer.append("// result to B*\n");
        stringBuffer.append("Derived* dp = &d;\n");
        stringBuffer.append("D* q = dp->vf4(); // calls Derived::pf() and does not\n");
        stringBuffer.append("// convert the result to B*\n");
        stringBuffer.append("dp->vf2(); //illformed: argument mismatch\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, false, 0);
    }

    public void test10_3s9() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct A {\n");
        stringBuffer.append("virtual void f();\n");
        stringBuffer.append("};\n");
        stringBuffer.append("struct B1 : A { // note nonvirtual\n");
        stringBuffer.append("derivation\n");
        stringBuffer.append("void f();\n");
        stringBuffer.append("};\n");
        stringBuffer.append("struct B2 : A {\n");
        stringBuffer.append("void f();\n");
        stringBuffer.append("};\n");
        stringBuffer.append("struct D : B1, B2 { // D has two separate A subobjects\n");
        stringBuffer.append("};\n");
        stringBuffer.append("void foo()\n");
        stringBuffer.append("{\n");
        stringBuffer.append("D d;\n");
        stringBuffer.append("// A* ap = &d; // would be illformed:ambiguous\n");
        stringBuffer.append("B1* b1p = &d;\n");
        stringBuffer.append("A* ap = b1p;\n");
        stringBuffer.append("D* dp = &d;\n");
        stringBuffer.append("ap->f(); //calls D::B1::f\n");
        stringBuffer.append("dp->f(); //illformed: ambiguous\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, false, 0);
    }

    public void test10_3s10() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct A {\n");
        stringBuffer.append("virtual void f();\n");
        stringBuffer.append("};\n");
        stringBuffer.append("struct VB1 : virtual A { // note virtual derivation\n");
        stringBuffer.append("void f();\n");
        stringBuffer.append("};\n");
        stringBuffer.append("struct VB2 : virtual A {\n");
        stringBuffer.append("void f();\n");
        stringBuffer.append("};\n");
        stringBuffer.append("struct Error : VB1, VB2 { // illformed\n");
        stringBuffer.append("};\n");
        stringBuffer.append("struct Okay : VB1, VB2 {\n");
        stringBuffer.append("void f();\n");
        stringBuffer.append("};\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test10_3s11() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct VB1a : virtual A { // does not declare f\n");
        stringBuffer.append("};\n");
        stringBuffer.append("struct Da : VB1a, VB2 {\n");
        stringBuffer.append("};\n");
        stringBuffer.append("void foe()\n");
        stringBuffer.append("{\n");
        stringBuffer.append("VB1a* vb1ap = new Da;\n");
        stringBuffer.append("vb1ap->f(); //calls VB2::f\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, false, 0);
    }

    public void test10_3s12() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class B { public: virtual void f(); };\n");
        stringBuffer.append("class D : public B { public: void f(); };\n");
        stringBuffer.append("void D::f() { B::f(); }\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test10_4s2a() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class point {  };\n");
        stringBuffer.append("class shape { // abstract class\n");
        stringBuffer.append("point center;\n");
        stringBuffer.append("// ...\n");
        stringBuffer.append("public:\n");
        stringBuffer.append("point where() { return center; }\n");
        stringBuffer.append("void move(point p) { center=p; draw(); }\n");
        stringBuffer.append("virtual void rotate(int) = 0; // pure virtual\n");
        stringBuffer.append("virtual void draw() = 0; // pure virtual\n");
        stringBuffer.append("// ...\n");
        stringBuffer.append("};\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test10_4s2b() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct C {\n");
        stringBuffer.append("virtual void f() { }=0; // illformed\n");
        stringBuffer.append("};\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test10_4s3() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("shape x; // error: object of abstract class\n");
        stringBuffer.append("shape* p; // OK\n");
        stringBuffer.append("shape f(); // error\n");
        stringBuffer.append("void g(shape); // error\n");
        stringBuffer.append("shape& h(shape&); // OK\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, false, 0);
    }

    public void test10_4s4a() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class ab_circle : public shape {\n");
        stringBuffer.append("int radius;\n");
        stringBuffer.append("public:\n");
        stringBuffer.append("void rotate(int) {}\n");
        stringBuffer.append("// ab_circle::draw() is a pure virtual\n");
        stringBuffer.append("};\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, false, 0);
    }

    public void test10_4s4b() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class circle : public shape {\n");
        stringBuffer.append("int radius;\n");
        stringBuffer.append("public:\n");
        stringBuffer.append("void rotate(int) {}\n");
        stringBuffer.append("void draw(); // a definition is required somewhere\n");
        stringBuffer.append("};\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, false, 0);
    }

    public void test11s2() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class X {\n");
        stringBuffer.append("int a; // X::a is private by default\n");
        stringBuffer.append("};\n");
        stringBuffer.append("struct S {\n");
        stringBuffer.append("int a; // S::a is public by default\n");
        stringBuffer.append("};\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test11s3() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class A\n");
        stringBuffer.append("{\n");
        stringBuffer.append("class B { };\n");
        stringBuffer.append("public:\n");
        stringBuffer.append("typedef B BB;\n");
        stringBuffer.append("};\n");
        stringBuffer.append("void f()\n");
        stringBuffer.append("{\n");
        stringBuffer.append("A::BB x; // OK, typedef name A::BB is public\n");
        stringBuffer.append("A::B y; // access error, A::B is private\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test11s5() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class A {\n");
        stringBuffer.append("typedef int I; // private member\n");
        stringBuffer.append("I f();\n");
        stringBuffer.append("friend I g(I);\n");
        stringBuffer.append("static I x;\n");
        stringBuffer.append("};\n");
        stringBuffer.append("A::I A::f() { return 0; }\n");
        stringBuffer.append("A::I g(A::I p = A::x);\n");
        stringBuffer.append("A::I g(A::I p) { return 0; }\n");
        stringBuffer.append("A::I A::x = 0;\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test11s6() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class D {\n");
        stringBuffer.append("class E {\n");
        stringBuffer.append("static int m;\n");
        stringBuffer.append("};\n");
        stringBuffer.append("};\n");
        stringBuffer.append("int D::E::m = 1; // OK, no access error on private E\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test11_1s1a() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class X {\n");
        stringBuffer.append("int a; // X::a is private by default: class used\n");
        stringBuffer.append("public:\n");
        stringBuffer.append("int b; // X::b is public\n");
        stringBuffer.append("int c; // X::c is public\n");
        stringBuffer.append("};\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test11s1b() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct S {\n");
        stringBuffer.append("int a; // S::a is public by default: struct used\n");
        stringBuffer.append("protected:\n");
        stringBuffer.append("int b; // S::b is protected\n");
        stringBuffer.append("private:\n");
        stringBuffer.append("int c; // S::c is private\n");
        stringBuffer.append("public:\n");
        stringBuffer.append("int d; // S::d is public\n");
        stringBuffer.append("};\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test11_1s3() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct S {\n");
        stringBuffer.append("class A;\n");
        stringBuffer.append("private:\n");
        stringBuffer.append("class A { }; // error: cannot change access\n");
        stringBuffer.append("};\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test11_2s2() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class B {  };\n");
        stringBuffer.append("class D1 : private B {  };\n");
        stringBuffer.append("class D2 : public B {  };\n");
        stringBuffer.append("class D3 : B {  }; // B private by default\n");
        stringBuffer.append("struct D4 : public B {  };\n");
        stringBuffer.append("struct D5 : private B {  };\n");
        stringBuffer.append("struct D6 : B {  }; // B public by default\n");
        stringBuffer.append("class D7 : protected B {  };\n");
        stringBuffer.append("struct D8 : protected B {  };\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test11_2s3() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class B {\n");
        stringBuffer.append("public:\n");
        stringBuffer.append("int mi; // nonstatic member\n");
        stringBuffer.append("static int si; // static member\n");
        stringBuffer.append("};\n");
        stringBuffer.append("class D : private B {\n");
        stringBuffer.append("};\n");
        stringBuffer.append("class DD : public D {\n");
        stringBuffer.append("void f();\n");
        stringBuffer.append("};\n");
        stringBuffer.append("void DD::f() {\n");
        stringBuffer.append("mi = 3; // error: mi is private in D\n");
        stringBuffer.append("si = 3; // error: si is private in D\n");
        stringBuffer.append("B b;\n");
        stringBuffer.append("b.mi = 3; // OK (b.mi is different from this->mi)\n");
        stringBuffer.append("b.si = 3; // OK (b.si is different from this->si)\n");
        stringBuffer.append("B::si = 3; // OK\n");
        stringBuffer.append("B* bp1 = this; // error: B is a private base class\n");
        stringBuffer.append("B* bp2 = (B*)this; // OK with cast\n");
        stringBuffer.append("bp2->mi = 3; // OK: access through a pointer to B.\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test11_2s4() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class B;\n");
        stringBuffer.append("class A {\n");
        stringBuffer.append("private:\n");
        stringBuffer.append("int i;\n");
        stringBuffer.append("friend void f(B*);\n");
        stringBuffer.append("};\n");
        stringBuffer.append("class B : public A { };\n");
        stringBuffer.append("void f(B* p) {\n");
        stringBuffer.append("p->i = 1; // OK: B* can be implicitly cast to A*,\n");
        stringBuffer.append("// and f has access to i in A\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test11_4s1() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class X {\n");
        stringBuffer.append("int a;\n");
        stringBuffer.append("friend void friend_set(X*, int);\n");
        stringBuffer.append("public:\n");
        stringBuffer.append("void member_set(int);\n");
        stringBuffer.append("};\n");
        stringBuffer.append("void friend_set(X* p, int i) { p->a = i; }\n");
        stringBuffer.append("void X::member_set(int i) { a = i; }\n");
        stringBuffer.append("void f()\n");
        stringBuffer.append("{\n");
        stringBuffer.append("X obj;\n");
        stringBuffer.append("friend_set(&obj,10);\n");
        stringBuffer.append("obj.member_set(10);\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test11_4s2a() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class A {\n");
        stringBuffer.append("class B { };\n");
        stringBuffer.append("friend class X;\n");
        stringBuffer.append("};\n");
        stringBuffer.append("class X : A::B { // illformed:\n");
        stringBuffer.append("//A::B cannot be accessed\n");
        stringBuffer.append("// in the baseclause for X\n");
        stringBuffer.append("A::B mx; // OK: A::B used to declare member of X\n");
        stringBuffer.append("class Y : A::B { // OK: A::B used to declare member of X\n");
        stringBuffer.append("A::B my; // illformed: A::B cannot be accessed\n");
        stringBuffer.append("// to declare members of nested class of X\n");
        stringBuffer.append("};\n");
        stringBuffer.append("};\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test11_4s2b() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class X {\n");
        stringBuffer.append("enum { a=100 };\n");
        stringBuffer.append("friend class Y;\n");
        stringBuffer.append("};\n");
        stringBuffer.append("class Y {\n");
        stringBuffer.append("int v[X::a]; // OK, Y is a friend of X\n");
        stringBuffer.append("};\n");
        stringBuffer.append("class Z {\n");
        stringBuffer.append("int v[X::a]; // error: X::a is private\n");
        stringBuffer.append("};\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test11_4s4() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class Y {\n");
        stringBuffer.append("friend char* X::foo(int);\n");
        stringBuffer.append("// ...\n");
        stringBuffer.append("};\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, false, 0);
    }

    public void test11_4s5() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class M {\n");
        stringBuffer.append("friend void f() { } // definition of global f, a friend of M,\n");
        stringBuffer.append("// not the definition of a member function\n");
        stringBuffer.append("};\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test11_4s8() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class A {\n");
        stringBuffer.append("friend class B;\n");
        stringBuffer.append("int a;\n");
        stringBuffer.append("};\n");
        stringBuffer.append("class B {\n");
        stringBuffer.append("friend class C;\n");
        stringBuffer.append("};\n");
        stringBuffer.append("class C {\n");
        stringBuffer.append("void f(A* p)\n");
        stringBuffer.append("{\n");
        stringBuffer.append("p->a++; //error: C is not a friend of A\n");
        stringBuffer.append("// despite being a friend of a friend\n");
        stringBuffer.append("}\n");
        stringBuffer.append("};\n");
        stringBuffer.append("class D : public B {\n");
        stringBuffer.append("void f(A* p)\n");
        stringBuffer.append("{\n");
        stringBuffer.append("p->a++; //error: D is not a friend of A\n");
        stringBuffer.append("// despite being derived from a friend\n");
        stringBuffer.append("}\n");
        stringBuffer.append("};\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test11_4s9() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class X;\n");
        stringBuffer.append("void a();\n");
        stringBuffer.append("void f() {\n");
        stringBuffer.append("class Y;\n");
        stringBuffer.append("extern void b();\n");
        stringBuffer.append("class A {\n");
        stringBuffer.append("friend class X; // OK, but X is a local class, not ::X\n");
        stringBuffer.append("friend class Y; // OK\n");
        stringBuffer.append("friend class Z; // OK, introduces local class Z\n");
        stringBuffer.append("friend void a(); // error, ::a is not considered\n");
        stringBuffer.append("friend void b(); // OK\n");
        stringBuffer.append("friend void c(); // error\n");
        stringBuffer.append("};\n");
        stringBuffer.append("X *px; // OK, but ::X is found\n");
        stringBuffer.append("Z *pz; // error, no Z is found\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, false, 0);
    }

    public void test11_5s1() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class B {\n");
        stringBuffer.append("protected:\n");
        stringBuffer.append("int i;\n");
        stringBuffer.append("static int j;\n");
        stringBuffer.append("};\n");
        stringBuffer.append("class D1 : public B {\n");
        stringBuffer.append("};\n");
        stringBuffer.append("class D2 : public B {\n");
        stringBuffer.append("friend void fr(B*,D1*,D2*);\n");
        stringBuffer.append("void mem(B*,D1*);\n");
        stringBuffer.append("};\n");
        stringBuffer.append("void fr(B* pb, D1* p1, D2* p2)\n");
        stringBuffer.append("{\n");
        stringBuffer.append("pb->i = 1; // illformed\n");
        stringBuffer.append("p1->i = 2; // illformed\n");
        stringBuffer.append("p2->i = 3; // OK (access through a D2)\n");
        stringBuffer.append("p2->B::i = 4; // OK (access through a D2, even though\n");
        stringBuffer.append("// naming class is B)\n");
        stringBuffer.append("int B::* pmi_B = &B::i; // illformed\n");
        stringBuffer.append("int B::* pmi_B2 = &D2::i; // OK (type of &D2::i is int B::*)\n");
        stringBuffer.append("B::j = 5; // OK (because refers to static member)\n");
        stringBuffer.append("D2::j =6; // OK (because refers to static member)\n");
        stringBuffer.append("}\n");
        stringBuffer.append("void D2::mem(B* pb, D1* p1)\n");
        stringBuffer.append("{\n");
        stringBuffer.append("pb->i = 1; // illformed\n");
        stringBuffer.append("p1->i = 2; // illformed\n");
        stringBuffer.append("i = 3; // OK (access through this)\n");
        stringBuffer.append("B::i = 4; // OK (access through this, qualification ignored)\n");
        stringBuffer.append("int B::* pmi_B = &B::i; // illformed\n");
        stringBuffer.append("int B::* pmi_B2 = &D2::i; // OK\n");
        stringBuffer.append("j = 5; // OK (because j refers to static member)\n");
        stringBuffer.append("B::j = 6; // OK (because B::j refers to static member)\n");
        stringBuffer.append("}\n");
        stringBuffer.append("void g(B* pb, D1* p1, D2* p2)\n");
        stringBuffer.append("{\n");
        stringBuffer.append("pb->i = 1; // illformed\n");
        stringBuffer.append("p1->i = 2; // illformed\n");
        stringBuffer.append("p2->i = 3; // illformed\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test11_6s1() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class B {\n");
        stringBuffer.append("public:\n");
        stringBuffer.append("virtual int f();\n");
        stringBuffer.append("};\n");
        stringBuffer.append("class D : public B {\n");
        stringBuffer.append("private:\n");
        stringBuffer.append("int f();\n");
        stringBuffer.append("};\n");
        stringBuffer.append("void f()\n");
        stringBuffer.append("{\n");
        stringBuffer.append("D d;\n");
        stringBuffer.append("B* pb = &d;\n");
        stringBuffer.append("D* pd = &d;\n");
        stringBuffer.append("pb->f(); //OK: B::f() is public,\n");
        stringBuffer.append("// D::f() is invoked\n");
        stringBuffer.append("pd->f(); //error: D::f() is private\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test11_7s1() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class W { public: void f(); };\n");
        stringBuffer.append("class A : private virtual W { };\n");
        stringBuffer.append("class B : public virtual W { };\n");
        stringBuffer.append("class C : public A, public B {\n");
        stringBuffer.append("void f() { W::f(); } // OK\n");
        stringBuffer.append("};\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test11_8s1() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class E {\n");
        stringBuffer.append("int x;\n");
        stringBuffer.append("class B { };\n");
        stringBuffer.append("class I {\n");
        stringBuffer.append("B b; // error: E::B is private\n");
        stringBuffer.append("int y;\n");
        stringBuffer.append("void f(E* p, int i)\n");
        stringBuffer.append("{\n");
        stringBuffer.append("p->x = i; // error: E::x is private\n");
        stringBuffer.append("}\n");
        stringBuffer.append("};\n");
        stringBuffer.append("int g(I* p)\n");
        stringBuffer.append("{\n");
        stringBuffer.append("return p->y; // error: I::y is private\n");
        stringBuffer.append("}\n");
        stringBuffer.append("};\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test11_8s2() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class C {\n");
        stringBuffer.append("class A { };\n");
        stringBuffer.append("A *p; // OK\n");
        stringBuffer.append("class B : A // OK\n");
        stringBuffer.append("{\n");
        stringBuffer.append("A *q; // OK because of injection of name A in A\n");
        stringBuffer.append("C::A *r; // error, C::A is inaccessible\n");
        stringBuffer.append("B *s; // OK because of injection of name B in B\n");
        stringBuffer.append("C::B *t; // error, C::B is inaccessible\n");
        stringBuffer.append("};\n");
        stringBuffer.append("};\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test12_1s1() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class C {\n");
        stringBuffer.append("public:\n");
        stringBuffer.append("C(); //declares the constructor\n");
        stringBuffer.append("};\n");
        stringBuffer.append("C::C() { } // defines the constructor\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test12_1s15() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct C;\n");
        stringBuffer.append("void no_opt(C*);\n");
        stringBuffer.append("struct C {\n");
        stringBuffer.append("int c;\n");
        stringBuffer.append("C() : c(0) { no_opt(this); }\n");
        stringBuffer.append("};\n");
        stringBuffer.append("const C cobj;\n");
        stringBuffer.append("void no_opt(C* cptr) {\n");
        stringBuffer.append("int i = cobj.c * 100; // value of cobj.c is unspecified\n");
        stringBuffer.append("cptr->c = 1;\n");
        stringBuffer.append("cout << cobj.c * 100 // value of cobj.c is unspecified\n");
        stringBuffer.append("<< '\n';\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, false, 0);
    }

    public void test12_2s2() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class X {\n");
        stringBuffer.append("// ...\n");
        stringBuffer.append("public:\n");
        stringBuffer.append("// ...\n");
        stringBuffer.append("X(int);\n");
        stringBuffer.append("X(const X&);\n");
        stringBuffer.append("~X();\n");
        stringBuffer.append("};\n");
        stringBuffer.append("X f(X);\n");
        stringBuffer.append("void g()\n");
        stringBuffer.append("{\n");
        stringBuffer.append("X a(1);\n");
        stringBuffer.append("X b = f(X(2));\n");
        stringBuffer.append("a = f(a);\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test12_2s5() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class C {\n");
        stringBuffer.append("// ...\n");
        stringBuffer.append("public:\n");
        stringBuffer.append("C();\n");
        stringBuffer.append("C(int);\n");
        stringBuffer.append("friend C operator+(const C&, const C&);\n");
        stringBuffer.append("~C();\n");
        stringBuffer.append("};\n");
        stringBuffer.append("C obj1;\n");
        stringBuffer.append("const C& cr = C(16)+C(23);\n");
        stringBuffer.append("C obj2;\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test12_3s4() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class X {\n");
        stringBuffer.append("// ...\n");
        stringBuffer.append("public:\n");
        stringBuffer.append("operator int();\n");
        stringBuffer.append("};\n");
        stringBuffer.append("class Y {\n");
        stringBuffer.append("// ...\n");
        stringBuffer.append("public:\n");
        stringBuffer.append("operator X();\n");
        stringBuffer.append("};\n");
        stringBuffer.append("Y a;\n");
        stringBuffer.append("int b = a; // error:\n");
        stringBuffer.append("// a.operator X().operator int() not tried\n");
        stringBuffer.append("int c = X(a); // OK: a.operator X().operator int()\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test12_3s5() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class X {\n");
        stringBuffer.append("public:\n");
        stringBuffer.append("// ...\n");
        stringBuffer.append("operator int();\n");
        stringBuffer.append("};\n");
        stringBuffer.append("class Y : public X {\n");
        stringBuffer.append("public:\n");
        stringBuffer.append("// ...\n");
        stringBuffer.append("operator char();\n");
        stringBuffer.append("};\n");
        stringBuffer.append("void f(Y& a)\n");
        stringBuffer.append("{\n");
        stringBuffer.append("if (a) { // illformed:\n");
        stringBuffer.append("// X::operator int() or Y::operator char()\n");
        stringBuffer.append("// ...\n");
        stringBuffer.append("}\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test12_3_1s1() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class X {\n");
        stringBuffer.append("// ...\n");
        stringBuffer.append("public:\n");
        stringBuffer.append("X(int);\n");
        stringBuffer.append("X(const char*, int =0);\n");
        stringBuffer.append("};\n");
        stringBuffer.append("void f(X arg)\n");
        stringBuffer.append("{\n");
        stringBuffer.append("X a = 1; // a = X(1)\n");
        stringBuffer.append("X b = \"Jessie\"; // b = X(\"Jessie\",0)\n");
        stringBuffer.append("a = 2; // a = X(2)\n");
        stringBuffer.append("f(3); // f(X(3))\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test12_3_1s2() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class Z {\n");
        stringBuffer.append("public:\n");
        stringBuffer.append("explicit Z();\n");
        stringBuffer.append("explicit Z(int);\n");
        stringBuffer.append("// ...\n");
        stringBuffer.append("};\n");
        stringBuffer.append("Z a; // OK: defaultinitialization performed\n");
        stringBuffer.append("Z a1 = 1; // error: no implicit conversion\n");
        stringBuffer.append("Z a3 = Z(1); // OK: direct initialization syntax used\n");
        stringBuffer.append("Z a2(1); // OK: direct initialization syntax used\n");
        stringBuffer.append("Z* p = new Z(1); // OK: direct initialization syntax used\n");
        stringBuffer.append("Z a4 = (Z)1; // OK: explicit cast used\n");
        stringBuffer.append("Z a5 = static_cast<Z>(1); // OK: explicit cast used\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test12_3_2s2() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class X {\n");
        stringBuffer.append("// ...\n");
        stringBuffer.append("public:\n");
        stringBuffer.append("operator int();\n");
        stringBuffer.append("};\n");
        stringBuffer.append("void f(X a)\n");
        stringBuffer.append("{\n");
        stringBuffer.append("int i = int(a);\n");
        stringBuffer.append("i = (int)a;\n");
        stringBuffer.append("i = a;\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test12_3_2s3() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("void g(X a, X b)\n");
        stringBuffer.append("{\n");
        stringBuffer.append("int i = (a) ? 1+a : 0;\n");
        stringBuffer.append("int j = (a&&b) ? a+b : i;\n");
        stringBuffer.append("if (a) { // ...\n");
        stringBuffer.append("}\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, false, 0);
    }

    public void test12_4s12() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct B {\n");
        stringBuffer.append("virtual ~B() { }\n");
        stringBuffer.append("};\n");
        stringBuffer.append("struct D : B {\n");
        stringBuffer.append("~D() { }\n");
        stringBuffer.append("};\n");
        stringBuffer.append("D D_object;\n");
        stringBuffer.append("typedef B B_alias;\n");
        stringBuffer.append("B* B_ptr = &D_object;\n");
        stringBuffer.append("void f() {\n");
        stringBuffer.append("D_object.B::~B(); // calls B\ufffds destructor\n");
        stringBuffer.append("B_ptr->~B(); //calls D\ufffds destructor\n");
        stringBuffer.append("B_ptr->~B_alias(); // calls D\ufffds destructor\n");
        stringBuffer.append("B_ptr->B_alias::~B(); // calls B\ufffds destructor\n");
        stringBuffer.append("B_ptr->B_alias::~B_alias(); // error, no B_alias in class B\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, false, 0);
    }

    public void test12_4s13() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("void* operator new(size_t, void* p) { return p; }\n");
        stringBuffer.append("struct X {\n");
        stringBuffer.append("// ...\n");
        stringBuffer.append("X(int);\n");
        stringBuffer.append("~X();\n");
        stringBuffer.append("};\n");
        stringBuffer.append("void f(X* p);\n");
        stringBuffer.append("void g() // rare, specialized use:\n");
        stringBuffer.append("{\n");
        stringBuffer.append("char* buf = new char[sizeof(X)];\n");
        stringBuffer.append("X* p = new(buf) X(222); // use buf[] and initialize\n");
        stringBuffer.append("f(p);\n");
        stringBuffer.append("p->X::~X(); //cleanup\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, false, 0);
    }

    public void test12_5s2() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class Arena;\n");
        stringBuffer.append("struct B {\n");
        stringBuffer.append("void* operator new(size_t, Arena*);\n");
        stringBuffer.append("};\n");
        stringBuffer.append("struct D1 : B {\n");
        stringBuffer.append("};\n");
        stringBuffer.append("Arena* ap;\n");
        stringBuffer.append("void foo(int i)\n");
        stringBuffer.append("{\n");
        stringBuffer.append("new (ap) D1; // calls B::operator new(size_t, Arena*)\n");
        stringBuffer.append("new D1[i]; // calls ::operator new[](size_t)\n");
        stringBuffer.append("new D1; // illformed: ::operator new(size_t) hidden\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, false, 0);
    }

    public void test12_5s6() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class X {\n");
        stringBuffer.append("// ...\n");
        stringBuffer.append("void operator delete(void*);\n");
        stringBuffer.append("void operator delete[](void*, size_t);\n");
        stringBuffer.append("};\n");
        stringBuffer.append("class Y {\n");
        stringBuffer.append("// ...\n");
        stringBuffer.append("void operator delete(void*, size_t);\n");
        stringBuffer.append("void operator delete[](void*);\n");
        stringBuffer.append("};\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, false, 0);
    }

    public void test12_6_1s1() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class complex {\n");
        stringBuffer.append("// ...\n");
        stringBuffer.append("public:\n");
        stringBuffer.append("complex();\n");
        stringBuffer.append("complex(double);\n");
        stringBuffer.append("complex(double,double);\n");
        stringBuffer.append("// ...\n");
        stringBuffer.append("};\n");
        stringBuffer.append("complex sqrt(complex,complex);\n");
        stringBuffer.append("int foo() {\n");
        stringBuffer.append("complex a(1); // initialize by a call of\n");
        stringBuffer.append("// complex(double)\n");
        stringBuffer.append("complex b = a; // initialize by a copy of a\n");
        stringBuffer.append("complex c = complex(1,2); // construct complex(1,2)\n");
        stringBuffer.append("// using complex(double,double)\n");
        stringBuffer.append("// copy it into c\n");
        stringBuffer.append("complex d = sqrt(b,c); // call sqrt(complex,complex)\n");
        stringBuffer.append("// and copy the result into d\n");
        stringBuffer.append("complex e; // initialize by a call of\n");
        stringBuffer.append("// complex()\n");
        stringBuffer.append("complex f = 3; // construct complex(3) using\n");
        stringBuffer.append("// complex(double)\n");
        stringBuffer.append("// copy it into f\n");
        stringBuffer.append("complex g = { 1, 2 }; // error; constructor is required\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test12_6_1s2() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class complex {\n");
        stringBuffer.append("// ...\n");
        stringBuffer.append("public:\n");
        stringBuffer.append("complex();\n");
        stringBuffer.append("complex(double);\n");
        stringBuffer.append("complex(double,double);\n");
        stringBuffer.append("// ...\n");
        stringBuffer.append("};\n");
        stringBuffer.append("complex v[6] = { 1,complex(1,2),complex(),2 };\n");
        stringBuffer.append("class X {\n");
        stringBuffer.append("public:\n");
        stringBuffer.append("int i;\n");
        stringBuffer.append("float f;\n");
        stringBuffer.append("complex c;\n");
        stringBuffer.append("} x = { 99, 88.8, 77.7 };\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test12_6_2s2a() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct A { A(); };\n");
        stringBuffer.append("typedef A global_A;\n");
        stringBuffer.append("struct B { };\n");
        stringBuffer.append("struct C: public A, public B { C(); };\n");
        stringBuffer.append("C::C(): global_A() { } // meminitializer for base A\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test12_6_2s2b() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct A { A(); };\n");
        stringBuffer.append("struct B: public virtual A { };\n");
        stringBuffer.append("struct C: public A, public B { C(); };\n");
        stringBuffer.append("C::C(): A() { } // illformed: which A?\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, false, 0);
    }

    public void test12_6_2s3() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct B1 { B1(int); };\n");
        stringBuffer.append("struct B2 { B2(int); };\n");
        stringBuffer.append("struct D : B1, B2 {\n");
        stringBuffer.append("D(int);\n");
        stringBuffer.append("B1 b;\n");
        stringBuffer.append("const int c;\n");
        stringBuffer.append("};\n");
        stringBuffer.append("D::D(int a) : B2(a+1), B1(a+2), c(a+3), b(a+4)\n");
        stringBuffer.append("{  }\n");
        stringBuffer.append("D d(10);\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test12_6_2s6() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class V {\n");
        stringBuffer.append("public:\n");
        stringBuffer.append("V();\n");
        stringBuffer.append("V(int);\n");
        stringBuffer.append("// ...\n");
        stringBuffer.append("};\n");
        stringBuffer.append("class A : public virtual V {\n");
        stringBuffer.append("public:\n");
        stringBuffer.append("A();\n");
        stringBuffer.append("A(int);\n");
        stringBuffer.append("// ...\n");
        stringBuffer.append("};\n");
        stringBuffer.append("class B : public virtual V {\n");
        stringBuffer.append("public:\n");
        stringBuffer.append("B();\n");
        stringBuffer.append("B(int);\n");
        stringBuffer.append("// ...\n");
        stringBuffer.append("};\n");
        stringBuffer.append("class C : public A, public B, private virtual V {\n");
        stringBuffer.append("public:\n");
        stringBuffer.append("C();\n");
        stringBuffer.append("C(int);\n");
        stringBuffer.append("// ...\n");
        stringBuffer.append("};\n");
        stringBuffer.append("A::A(int i) : V(i) { }\n");
        stringBuffer.append("B::B(int i) { }\n");
        stringBuffer.append("C::C(int i) { }\n");
        stringBuffer.append("V v(1); // use V(int)\n");
        stringBuffer.append("A a(2); // use V(int)\n");
        stringBuffer.append("B b(3); // use V()\n");
        stringBuffer.append("C c(4); // use V()\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test12_6_2s7() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class X {\n");
        stringBuffer.append("int a;\n");
        stringBuffer.append("int b;\n");
        stringBuffer.append("int i;\n");
        stringBuffer.append("int j;\n");
        stringBuffer.append("public:\n");
        stringBuffer.append("const int& r;\n");
        stringBuffer.append("X(int i): r(a), b(i), i(i), j(this->i) {}\n");
        stringBuffer.append("};\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test12_6_2s8() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class A {\n");
        stringBuffer.append("public:\n");
        stringBuffer.append("A(int);\n");
        stringBuffer.append("};\n");
        stringBuffer.append("class B : public A {\n");
        stringBuffer.append("int j;\n");
        stringBuffer.append("public:\n");
        stringBuffer.append("int f();\n");
        stringBuffer.append("B() : A(f()), // undefined: calls member function\n");
        stringBuffer.append("// but base A not yet initialized\n");
        stringBuffer.append("j(f()) { } // welldefined: bases are all initialized\n");
        stringBuffer.append("};\n");
        stringBuffer.append("class C {\n");
        stringBuffer.append("public:\n");
        stringBuffer.append("C(int);\n");
        stringBuffer.append("};\n");
        stringBuffer.append("class D : public B, C {\n");
        stringBuffer.append("int i;\n");
        stringBuffer.append("public:\n");
        stringBuffer.append("D() : C(f()), // undefined: calls member function\n");
        stringBuffer.append("// but base C not yet initialized\n");
        stringBuffer.append("i(f()) {} // welldefined: bases are all initialized\n");
        stringBuffer.append("};\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test12_7s1_a() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct X { int i; };\n");
        stringBuffer.append("struct Y : X { };\n");
        stringBuffer.append("struct A { int a; };\n");
        stringBuffer.append("struct B : public A { int j; Y y; };\n");
        stringBuffer.append("extern B bobj;\n");
        stringBuffer.append("B* pb = &bobj; // OK\n");
        stringBuffer.append("int* p1 = &bobj.a; // undefined, refers to base class member\n");
        stringBuffer.append("int* p2 = &bobj.y.i; // undefined, refers to member\ufffds member\n");
        stringBuffer.append("A* pa = &bobj; // undefined, upcast to a base class type\n");
        stringBuffer.append("B bobj; // definition of bobj\n");
        stringBuffer.append("extern X xobj;\n");
        stringBuffer.append("int* p3 = &xobj.i; // OK, X is a POD class\n");
        stringBuffer.append("X xobj;\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test12_7s1_b() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct W { int j; };\n");
        stringBuffer.append("struct X : public virtual W { };\n");
        stringBuffer.append("struct Y {\n");
        stringBuffer.append("int *p;\n");
        stringBuffer.append("X x;\n");
        stringBuffer.append("Y() : p(&x.j) // undefined, x is not yet constructed\n");
        stringBuffer.append("{ }\n");
        stringBuffer.append("};\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test12_7s3() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class V {\n");
        stringBuffer.append("public:\n");
        stringBuffer.append("virtual void f();\n");
        stringBuffer.append("virtual void g();\n");
        stringBuffer.append("};\n");
        stringBuffer.append("class A : public virtual V {\n");
        stringBuffer.append("public:\n");
        stringBuffer.append("virtual void f();\n");
        stringBuffer.append("};\n");
        stringBuffer.append("class B : public virtual V {\n");
        stringBuffer.append("public:\n");
        stringBuffer.append("virtual void g();\n");
        stringBuffer.append("B(V*, A*);\n");
        stringBuffer.append("};\n");
        stringBuffer.append("class D : public A, B {\n");
        stringBuffer.append("public:\n");
        stringBuffer.append("virtual void f();\n");
        stringBuffer.append("virtual void g();\n");
        stringBuffer.append("D() : B((A*)this, this) { }\n");
        stringBuffer.append("};\n");
        stringBuffer.append("B::B(V* v, A* a) {\n");
        stringBuffer.append("f(); //calls V::f, not A::f\n");
        stringBuffer.append("g(); //calls B::g, not D::g\n");
        stringBuffer.append("v->g(); // v is base of B, the call is welldefined, calls B::g\n");
        stringBuffer.append("a->f(); //undefined behavior, a\ufffds type not a base of B\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test12_7s6() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class V {\n");
        stringBuffer.append("public:\n");
        stringBuffer.append("virtual void f();\n");
        stringBuffer.append("};\n");
        stringBuffer.append("class A : public virtual V { };\n");
        stringBuffer.append("class B : public virtual V {\n");
        stringBuffer.append("public:\n");
        stringBuffer.append("B(V*, A*);\n");
        stringBuffer.append("};\n");
        stringBuffer.append("class D : public A, B {\n");
        stringBuffer.append("public:\n");
        stringBuffer.append("D() : B((A*)this, this) { }\n");
        stringBuffer.append("};\n");
        stringBuffer.append("B::B(V* v, A* a) {\n");
        stringBuffer.append("typeid(*this); // type_info for B\n");
        stringBuffer.append("typeid(*v); //welldefined: *v has type V, a base of B\n");
        stringBuffer.append("// yields type_info for B\n");
        stringBuffer.append("typeid(*a); //undefined behavior: type A not a base of B\n");
        stringBuffer.append("dynamic_cast<B*>(v); // welldefined: v of type V*, V base of B\n");
        stringBuffer.append("// results in B*\n");
        stringBuffer.append("dynamic_cast<B*>(a); // undefined behavior,\n");
        stringBuffer.append("// a has type A*, A not a base of B\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test12_8s2a() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class X {\n");
        stringBuffer.append("// ...\n");
        stringBuffer.append("public:\n");
        stringBuffer.append("X(int);\n");
        stringBuffer.append("X(const X&, int = 1);\n");
        stringBuffer.append("};\n");
        stringBuffer.append("X a(1); // calls X(int);\n");
        stringBuffer.append("X b(a, 0); // calls X(const X&, int);\n");
        stringBuffer.append("X c = b; // calls X(const X&, int);\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test12_8s2b() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class X {\n");
        stringBuffer.append("// ...\n");
        stringBuffer.append("public:\n");
        stringBuffer.append("X(const X&);\n");
        stringBuffer.append("X(X&); //OK\n");
        stringBuffer.append("};\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test12_8s2c() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct X {\n");
        stringBuffer.append("X(); //default constructor\n");
        stringBuffer.append("X(X&); //copy constructor with a nonconst parameter\n");
        stringBuffer.append("};\n");
        stringBuffer.append("const X cx;\n");
        stringBuffer.append("X x = cx; // error - X::X(X&) cannot copy cx into x\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test12_8s3() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct S {\n");
        stringBuffer.append("template<typename T> S(T);\n");
        stringBuffer.append("};\n");
        stringBuffer.append("S f();\n");
        stringBuffer.append("void g() {\n");
        stringBuffer.append("S a( f() ); // does not instantiate member template\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, false, 0);
    }

    public void test12_8s3d() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("void h(int());\n");
        stringBuffer.append("void h(int (*)()); // redeclaration of h(int())\n");
        stringBuffer.append("void h(int x()) { } // definition of h(int())\n");
        stringBuffer.append("void h(int (*x)()) { } // illformed: redefinition of h(int())\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 1);
    }

    public void test12_8s4a() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct X {\n");
        stringBuffer.append("X(const X&, int);\n");
        stringBuffer.append("};\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test12_8s4b() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct X {\n");
        stringBuffer.append("X(const X&, int);\n");
        stringBuffer.append("};\n");
        stringBuffer.append("X::X(const X& x, int i =0) {  }\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test12_8s9() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct X {\n");
        stringBuffer.append("X();\n");
        stringBuffer.append("X& operator=(X&);\n");
        stringBuffer.append("};\n");
        stringBuffer.append("const X cx;\n");
        stringBuffer.append("X x;\n");
        stringBuffer.append("void f() {\n");
        stringBuffer.append("x = cx; // error:\n");
        stringBuffer.append("// X::operator=(X&) cannot assign cx into x\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test12_8s13() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct V { };\n");
        stringBuffer.append("struct A : virtual V { };\n");
        stringBuffer.append("struct B : virtual V { };\n");
        stringBuffer.append("struct C : B, A { };\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test12_8s15() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class Thing {\n");
        stringBuffer.append("public:\n");
        stringBuffer.append("Thing();\n");
        stringBuffer.append("~Thing();\n");
        stringBuffer.append("Thing(const Thing&);\n");
        stringBuffer.append("Thing operator=(const Thing&);\n");
        stringBuffer.append("void fun();\n");
        stringBuffer.append("};\n");
        stringBuffer.append("Thing f() {\n");
        stringBuffer.append("Thing t;\n");
        stringBuffer.append("return t;\n");
        stringBuffer.append("}\n");
        stringBuffer.append("Thing t2 = f();\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test13s2() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("double abs(double);\n");
        stringBuffer.append("int abs(int);\n");
        stringBuffer.append("int foo() {\n");
        stringBuffer.append("abs(1); //call abs(int);\n");
        stringBuffer.append("abs(1.0); //call abs(double);\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test12_1s2() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class X {\n");
        stringBuffer.append("static void f();\n");
        stringBuffer.append("void f(); // illformed\n");
        stringBuffer.append("void f() const; // illformed\n");
        stringBuffer.append("void f() const volatile; // illformed\n");
        stringBuffer.append("void g();\n");
        stringBuffer.append("void g() const; // OK: no static g\n");
        stringBuffer.append("void g() const volatile; // OK: no static g\n");
        stringBuffer.append("};\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test12_1s3a() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("typedef int Int;\n");
        stringBuffer.append("void f(int i);\n");
        stringBuffer.append("void f(Int i); // OK: redeclaration of f(int)\n");
        stringBuffer.append("void f(int i) {  }\n");
        stringBuffer.append("void f(Int i) {  } // error: redefinition of f(int)\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 1);
    }

    public void test12_1s3b() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("enum E { a };\n");
        stringBuffer.append("void f(int i) { }\n");
        stringBuffer.append("void f(E i) {  }\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test12_1s3c() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int f(char*);\n");
        stringBuffer.append("int f(char[]); // same as f(char*);\n");
        stringBuffer.append("int f(char[7]); // same as f(char*);\n");
        stringBuffer.append("int f(char[9]); // same as f(char*);\n");
        stringBuffer.append("int g(char(*)[10]);\n");
        stringBuffer.append("int g(char[5][10]); // same as g(char(*)[10]);\n");
        stringBuffer.append("int g(char[7][10]); // same as g(char(*)[10]);\n");
        stringBuffer.append("int g(char(*)[20]); // different from g(char(*)[10]);\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test12_8s3e() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("typedef const int cInt;\n");
        stringBuffer.append("int f (int);\n");
        stringBuffer.append("int f (const int); // redeclaration of f(int)\n");
        stringBuffer.append("int f (int) {  } // definition of f(int)\n");
        stringBuffer.append("int f (cInt) {  } // error: redefinition of f(int)\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test12_8s3f() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("void f (int i, int j);\n");
        stringBuffer.append("void f (int i, int j = 99); // OK: redeclaration of f(int, int)\n");
        stringBuffer.append("void f (int i = 88, int j); // OK: redeclaration of f(int, int)\n");
        stringBuffer.append("void f (); // OK: overloaded declaration of f\n");
        stringBuffer.append("void prog ()\n");
        stringBuffer.append("{\n");
        stringBuffer.append("f (1, 2); // OK: call f(int, int)\n");
        stringBuffer.append("f (1); // OK: call f(int, int)\n");
        stringBuffer.append("f (); // Error: f(int, int) or f()?\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, false, 0);
    }

    public void test13_2s1a() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class B {\n");
        stringBuffer.append("public:\n");
        stringBuffer.append("int f(int);\n");
        stringBuffer.append("};\n");
        stringBuffer.append("class D : public B {\n");
        stringBuffer.append("public:\n");
        stringBuffer.append("int f(char*);\n");
        stringBuffer.append("};\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test13_2s1b() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class B {\n");
        stringBuffer.append("public:\n");
        stringBuffer.append("int f(int);\n");
        stringBuffer.append("};\n");
        stringBuffer.append("class D : public B {\n");
        stringBuffer.append("public:\n");
        stringBuffer.append("int f(char*);\n");
        stringBuffer.append("};\n");
        stringBuffer.append("void h(D* pd)\n");
        stringBuffer.append("{\n");
        stringBuffer.append("pd->f(1); //error:\n");
        stringBuffer.append("// D::f(char*) hides B::f(int)\n");
        stringBuffer.append("pd->B::f(1); //OK\n");
        stringBuffer.append("pd->f(\"Ben\"); //OK, calls D::f\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, false, 0);
    }

    public void test13_2s2() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int f(char*);\n");
        stringBuffer.append("void g()\n");
        stringBuffer.append("{\n");
        stringBuffer.append("extern f(int);\n");
        stringBuffer.append("f(\"asdf\"); //error: f(int) hides f(char*)\n");
        stringBuffer.append("// so there is no f(char*) in this scope\n");
        stringBuffer.append("}\n");
        stringBuffer.append("void caller ()\n");
        stringBuffer.append("{\n");
        stringBuffer.append("extern void callee(int, int);\n");
        stringBuffer.append("{\n");
        stringBuffer.append("extern void callee(int); // hides callee(int, int)\n");
        stringBuffer.append("callee(88, 99); // error: only callee(int) in scope\n");
        stringBuffer.append("}\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, false, 0);
    }

    public void test13_2s3() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class buffer {\n");
        stringBuffer.append("private:\n");
        stringBuffer.append("char* p;\n");
        stringBuffer.append("int size;\n");
        stringBuffer.append("protected:\n");
        stringBuffer.append("buffer(int s, char* store) { size = s; p = store; }\n");
        stringBuffer.append("// ...\n");
        stringBuffer.append("public:\n");
        stringBuffer.append("buffer(int s) { p = new char[size = s]; }\n");
        stringBuffer.append("// ...\n");
        stringBuffer.append("};\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test13_3_1s6() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class T {\n");
        stringBuffer.append("public:\n");
        stringBuffer.append("T();\n");
        stringBuffer.append("// ...\n");
        stringBuffer.append("};\n");
        stringBuffer.append("class C : T {\n");
        stringBuffer.append("public:\n");
        stringBuffer.append("C(int);\n");
        stringBuffer.append("// ...\n");
        stringBuffer.append("};\n");
        stringBuffer.append("T a = 1; // illformed: T(C(1)) not tried\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test13_3_1_1_2s4() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int f1(int);\n");
        stringBuffer.append("int f2(float);\n");
        stringBuffer.append("typedef int (*fp1)(int);\n");
        stringBuffer.append("typedef int (*fp2)(float);\n");
        stringBuffer.append("struct A {\n");
        stringBuffer.append("operator fp1() { return f1; }\n");
        stringBuffer.append("operator fp2() { return f2; }\n");
        stringBuffer.append("} a;\n");
        stringBuffer.append("int i = a(1); // Calls f1 via pointer returned from\n");
        stringBuffer.append("// conversion function\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test13_3_1_2s1() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class String {\n");
        stringBuffer.append("public:\n");
        stringBuffer.append("String (const String&);\n");
        stringBuffer.append("String (char*);\n");
        stringBuffer.append("operator char* ();\n");
        stringBuffer.append("};\n");
        stringBuffer.append("String operator + (const String&, const String&);\n");
        stringBuffer.append("void f(void)\n");
        stringBuffer.append("{\n");
        stringBuffer.append("char* p= \"one\" + \"two\"; // illformed because neither\n");
        stringBuffer.append("// operand has user defined type\n");
        stringBuffer.append("int I = 1 + 1; // Always evaluates to 2 even if\n");
        stringBuffer.append("// user defined types exist which\n");
        stringBuffer.append("// would perform the operation.\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test13_3_1_2s6() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct A {\n");
        stringBuffer.append("operator int();\n");
        stringBuffer.append("};\n");
        stringBuffer.append("A operator+(const A&, const A&);\n");
        stringBuffer.append("void m() {\n");
        stringBuffer.append("A a, b;\n");
        stringBuffer.append("a + b; // operator+(a,b) chosen over int(a) + int(b)\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test13_3_3s1() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct A {\n");
        stringBuffer.append("A();\n");
        stringBuffer.append("operator int();\n");
        stringBuffer.append("operator double();\n");
        stringBuffer.append("} a;\n");
        stringBuffer.append("int i = a; // a.operator int() followed by no conversion\n");
        stringBuffer.append("// is better than a.operator double() followed by\n");
        stringBuffer.append("// a conversion to int\n");
        stringBuffer.append("float x = a; // ambiguous: both possibilities require conversions,\n");
        stringBuffer.append("// and neither is better than the other\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test13_3_3s3() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("void Fcn(const int*, short);\n");
        stringBuffer.append("void Fcn(int*, int);\n");
        stringBuffer.append("int i;\n");
        stringBuffer.append("short s = 0;\n");
        stringBuffer.append("void f() {\n");
        stringBuffer.append("Fcn(&i, s); // is ambiguous because\n");
        stringBuffer.append("// &i \ufffd int* is better than &i \ufffd const int*\n");
        stringBuffer.append("// but s \ufffd short is also better than s \ufffd int\n");
        stringBuffer.append("Fcn(&i, 1L); // calls Fcn(int*, int), because\n");
        stringBuffer.append("// &i \ufffd int* is better than &i \ufffd const int*\n");
        stringBuffer.append("// and 1L \ufffd short and 1L \ufffd int are indistinguishable\n");
        stringBuffer.append("Fcn(&i,'c'); //callsFcn(int*, int), because\n");
        stringBuffer.append("// &i \ufffd int* is better than &i \ufffd const int*\n");
        stringBuffer.append("// and c \ufffd int is better than c \ufffd short\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, false, 0);
    }

    public void test13_3_3_1_1s2() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class B;\n");
        stringBuffer.append("class A { A (B&); };\n");
        stringBuffer.append("class B { operator A (); };\n");
        stringBuffer.append("class C { C (B&); };\n");
        stringBuffer.append("void f(A) { }\n");
        stringBuffer.append("void f(C) { }\n");
        stringBuffer.append("B b;\n");
        stringBuffer.append("f(b); //ambiguous because b \ufffd> C via constructor and\n");
        stringBuffer.append("// b -> A via constructor or conversion function.\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, false, 0);
    }

    public void test13_3_3_1_4s1() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct A {};\n");
        stringBuffer.append("struct B : public A {} b;\n");
        stringBuffer.append("int f(A&);\n");
        stringBuffer.append("int f(B&);\n");
        stringBuffer.append("int i = f(b); // Calls f(B&), an exact match, rather than\n");
        stringBuffer.append("// f(A&), a conversion\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test13_3_3_2s3a() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int f(const int *);\n");
        stringBuffer.append("int f(int *);\n");
        stringBuffer.append("int i;\n");
        stringBuffer.append("int j = f(&i); // Calls f(int *)\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test13_3_3_2s3b() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int f(const int &);\n");
        stringBuffer.append("int f(int &);\n");
        stringBuffer.append("int g(const int &);\n");
        stringBuffer.append("int g(int);\n");
        stringBuffer.append("int i;\n");
        stringBuffer.append("int j = f(i); // Calls f(int &)\n");
        stringBuffer.append("int k = g(i); // ambiguous\n");
        stringBuffer.append("class X {\n");
        stringBuffer.append("public:\n");
        stringBuffer.append("void f() const;\n");
        stringBuffer.append("void f();\n");
        stringBuffer.append("};\n");
        stringBuffer.append("void g(const X& a, X b)\n");
        stringBuffer.append("{\n");
        stringBuffer.append("a.f(); //CallsX::f() const\n");
        stringBuffer.append("b.f(); //Calls X::f()\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test13_3_3_2s3c() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct A {\n");
        stringBuffer.append("operator short();\n");
        stringBuffer.append("} a;\n");
        stringBuffer.append("int f(int);\n");
        stringBuffer.append("int f(float);\n");
        stringBuffer.append("int i = f(a); // Calls f(int), because short -> int is\n");
        stringBuffer.append("// better than short -> float.\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test13_3_3_2s4() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct A {};\n");
        stringBuffer.append("struct B : public A {};\n");
        stringBuffer.append("struct C : public B {};\n");
        stringBuffer.append("C *pc;\n");
        stringBuffer.append("int f(A *);\n");
        stringBuffer.append("int f(B *);\n");
        stringBuffer.append("int i = f(pc); // Calls f(B *)\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test13_4s5b() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct X {\n");
        stringBuffer.append("int f(int);\n");
        stringBuffer.append("static int f(long);\n");
        stringBuffer.append("};\n");
        stringBuffer.append("int (X::*p1)(int) = &X::f; // OK\n");
        stringBuffer.append("int (*p2)(int) = &X::f; // error: mismatch\n");
        stringBuffer.append("int (*p3)(long) = &X::f; // OK\n");
        stringBuffer.append("int (X::*p4)(long) = &X::f; // error: mismatch\n");
        stringBuffer.append("int (*p6)(long) = &(X::f); // OK\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test13_5s4() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class complex {\n");
        stringBuffer.append("public:\n");
        stringBuffer.append("complex operator+(complex a) {}\n");
        stringBuffer.append("};\n");
        stringBuffer.append("int n;\n");
        stringBuffer.append("int foo(complex &a, complex &b) {\n");
        stringBuffer.append("complex z = a.operator+(b); // complex z = a+b;\n");
        stringBuffer.append("void* p = operator new(sizeof(int)*n);\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, false, 0);
    }

    public void test13_5_3s2() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct B {\n");
        stringBuffer.append("virtual int operator= (int);\n");
        stringBuffer.append("virtual B& operator= (const B&);\n");
        stringBuffer.append("};\n");
        stringBuffer.append("struct D : B {\n");
        stringBuffer.append("virtual int operator= (int);\n");
        stringBuffer.append("virtual D& operator= (const B&);\n");
        stringBuffer.append("};\n");
        stringBuffer.append("D dobj1;\n");
        stringBuffer.append("D dobj2;\n");
        stringBuffer.append("B* bptr = &dobj1;\n");
        stringBuffer.append("void f() {\n");
        stringBuffer.append("bptr->operator=(99); // calls D::operator=(int)\n");
        stringBuffer.append("*bptr = 99; // ditto\n");
        stringBuffer.append("bptr->operator=(dobj2); // calls D::operator=(const B&)\n");
        stringBuffer.append("*bptr = dobj2; // ditto\n");
        stringBuffer.append("dobj1 = dobj2; // calls implicitlydeclared\n");
        stringBuffer.append("// D::operator=(const D&)\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, false, 0);
    }

    public void test13_5_7s1() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class X {\n");
        stringBuffer.append("public:\n");
        stringBuffer.append("X& operator++(); // prefix ++a\n");
        stringBuffer.append("X operator++(int); // postfix a++\n");
        stringBuffer.append("};\n");
        stringBuffer.append("class Y { };\n");
        stringBuffer.append("Y& operator++(Y&); // prefix ++b\n");
        stringBuffer.append("Y operator++(Y&, int); // postfix b++\n");
        stringBuffer.append("void f(X a, Y b) {\n");
        stringBuffer.append("++a; // a.operator++();\n");
        stringBuffer.append("a++; // a.operator++(0);\n");
        stringBuffer.append("++b; // operator++(b);\n");
        stringBuffer.append("b++; // operator++(b, 0);\n");
        stringBuffer.append("a.operator++(); // explicit call: like ++a;\n");
        stringBuffer.append("a.operator++(0); // explicit call: like a++;\n");
        stringBuffer.append("operator++(b); //explicit call: like ++b;\n");
        stringBuffer.append("operator++(b, 0); // explicit call: like b++;\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test14_1s6() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template<const X& x, int i> void f()\n");
        stringBuffer.append("{\n");
        stringBuffer.append("i++; //error: change of template parameter\n");
        stringBuffer.append("value\n");
        stringBuffer.append("&x; //OK\n");
        stringBuffer.append("&i; //error: address of nonreference template parameter\n");
        stringBuffer.append("int& ri = i; // error: nonconst reference bound to temporary\n");
        stringBuffer.append("const int& cri = i; // OK: const reference bound to temporary\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, false, 0);
    }

    public void test14_1s7() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template<double d> class X; // error\n");
        stringBuffer.append("template<double* pd> class Y; // OK\n");
        stringBuffer.append("template<double& rd> class Z; // OK\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test14_1s8() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template<int *a> struct R {  };\n");
        stringBuffer.append("template<int b[5]> struct S {  };\n");
        stringBuffer.append("int *p;\n");
        stringBuffer.append("R<p> w; // OK\n");
        stringBuffer.append("S<p> x; // OK due to parameter adjustment\n");
        stringBuffer.append("int v[5];\n");
        stringBuffer.append("R<v> y; // OK due to implicit argument conversion\n");
        stringBuffer.append("S<v> z; // OK due to both adjustment and conversion\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test14_1s10a() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template<class T1, class T2 = int> class A;\n");
        stringBuffer.append("template<class T1 = int, class T2> class A;\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test14_1s10b() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template<class T1 = int, class T2 = int> class A;\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test14_1s11() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template<class T1 = int, class T2> class B; // error\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test14_1s12() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template<class T = int> class X;\n");
        stringBuffer.append("template<class T = int> class X {  }; // error\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test14_1s13() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template<class T, T* p, class U = T> class X {  };\n");
        stringBuffer.append("template<class T> void f(T* p = new T);\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test14_1s15() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template<int i = (3 > 4) > // OK\n");
        stringBuffer.append("class Y {  };\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test14_2s3() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template<int i> class X {  };\n");
        stringBuffer.append("X<(1>2)> x2; // OK\n");
        stringBuffer.append("template<class T> class Y {  };\n");
        stringBuffer.append("Y< X<1> > x3; // OK\n");
        stringBuffer.append("Y<X<6>> 1> > x4; // OK: Y< X< (6>>1) > >\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test14_2s4() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class X {\n");
        stringBuffer.append("public:\n");
        stringBuffer.append("template<size_t> X* alloc();\n");
        stringBuffer.append("template<size_t> static X* adjust();\n");
        stringBuffer.append("};\n");
        stringBuffer.append("template<class T> void f(T* p)\n");
        stringBuffer.append("{\n");
        stringBuffer.append("T* p1 = p>\n");
        stringBuffer.append("alloc<200>(); // illformed: < means less than\n");
        stringBuffer.append("T* p2 = p->template alloc<200>();\n");
        stringBuffer.append("// OK: < starts template argument list\n");
        stringBuffer.append("T::adjust<100>();\n");
        stringBuffer.append("// illformed: < means less than\n");
        stringBuffer.append("T::template adjust<100>();\n");
        stringBuffer.append("// OK: < starts explicit qualification\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, false, 0);
    }

    public void test14_3s1() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template<class T> class Array {\n");
        stringBuffer.append("T* v;\n");
        stringBuffer.append("int sz;\n");
        stringBuffer.append("public:\n");
        stringBuffer.append("explicit Array(int);\n");
        stringBuffer.append("T& operator[](int);\n");
        stringBuffer.append("T& elem(int i) { return v[i]; }\n");
        stringBuffer.append("// ...\n");
        stringBuffer.append("};\n");
        stringBuffer.append("Array<int> v1(20);\n");
        stringBuffer.append("typedef complex<double> dcomplex; // complex is a standard\n");
        stringBuffer.append("// library template\n");
        stringBuffer.append("Array<dcomplex> v2(30);\n");
        stringBuffer.append("Array<dcomplex> v3(40);\n");
        stringBuffer.append("void bar() {\n");
        stringBuffer.append("v1[3] = 7;\n");
        stringBuffer.append("v2[3] = v3.elem(4) = dcomplex(7,8);\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, false, 0);
    }

    public void test14_3s3() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template<class T> class X {\n");
        stringBuffer.append("static T t;\n");
        stringBuffer.append("};\n");
        stringBuffer.append("class Y {\n");
        stringBuffer.append("private:\n");
        stringBuffer.append("struct S {  };\n");
        stringBuffer.append("X<S> x; // OK: S is accessible\n");
        stringBuffer.append("// X<Y::S> has a static member of type Y::S\n");
        stringBuffer.append("// OK: even though Y::S is private\n");
        stringBuffer.append("};\n");
        stringBuffer.append("X<Y::S> y; // error: S not accessible\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test14_3s5() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template<class T> struct A {\n");
        stringBuffer.append("~A();\n");
        stringBuffer.append("};\n");
        stringBuffer.append("void f(A<int>* p, A<int>* q) {\n");
        stringBuffer.append("p->A<int>::~A(); // OK: destructor call\n");
        stringBuffer.append("q->A<int>::~A<int>(); // OK: destructor call\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test14_3_1s2() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template <class T> class X {  };\n");
        stringBuffer.append("void f()\n");
        stringBuffer.append("{\n");
        stringBuffer.append("struct S {  };\n");
        stringBuffer.append("X<S> x3; // error: local type used as templateargument\n");
        stringBuffer.append("X<S*> x4; // error: pointer to local type used as templateargument\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test14_3_1s3() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template<class T> struct A {\n");
        stringBuffer.append("static T t;\n");
        stringBuffer.append("};\n");
        stringBuffer.append("typedef int function();\n");
        stringBuffer.append("A<function> a; // illformed: would declare A<function>::t\n");
        stringBuffer.append("// as a static member function\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test14_3_3s2() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template<class T> class A { // primary template\n");
        stringBuffer.append("int x;\n");
        stringBuffer.append("};\n");
        stringBuffer.append("template<class T> class A<T*> { // partial specialization\n");
        stringBuffer.append("long x;\n");
        stringBuffer.append("};\n");
        stringBuffer.append("template<template<class U> class V> class C {\n");
        stringBuffer.append("V<int> y;\n");
        stringBuffer.append("V<int*> z;\n");
        stringBuffer.append("};\n");
        stringBuffer.append("C<A> c; // V<int> within C<A> uses the primary template,\n");
        stringBuffer.append("// so c.y.x has type int\n");
        stringBuffer.append("// V<int*> within C<A> uses the partial specialization,\n");
        stringBuffer.append("// so c.z.x has type long\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test14_2s1a() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template<class E, int size> class buffer {  };\n");
        stringBuffer.append("buffer<char,2*512> x;\n");
        stringBuffer.append("buffer<char,1024> y;\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test14_4s1b() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template<class T, void(*err_fct)()> class list {  };\n");
        stringBuffer.append("list<int,&error_handler1> x1;\n");
        stringBuffer.append("list<int,&error_handler2> x2;\n");
        stringBuffer.append("list<int,&error_handler2> x3;\n");
        stringBuffer.append("list<char,&error_handler2> x4;\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, false, 0);
    }

    public void test14_5_1s2() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template<class T> class Array {\n");
        stringBuffer.append("T* v;\n");
        stringBuffer.append("int sz;\n");
        stringBuffer.append("public:\n");
        stringBuffer.append("explicit Array(int);\n");
        stringBuffer.append("T& operator[](int);\n");
        stringBuffer.append("T& elem(int i) { return v[i]; }\n");
        stringBuffer.append("// ...\n");
        stringBuffer.append("};\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test14_5_1s3a() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template<class T1, class T2> struct A {\n");
        stringBuffer.append("void f1();\n");
        stringBuffer.append("void f2();\n");
        stringBuffer.append("};\n");
        stringBuffer.append("template<class T2, class T1> void A<T2,T1>::f1() { } // OK\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test14_5_1_1s1() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template<class T> class Array {\n");
        stringBuffer.append("T* v;\n");
        stringBuffer.append("int sz;\n");
        stringBuffer.append("public:\n");
        stringBuffer.append("explicit Array(int);\n");
        stringBuffer.append("T& operator[](int);\n");
        stringBuffer.append("T& elem(int i) { return v[i]; }\n");
        stringBuffer.append("// ...\n");
        stringBuffer.append("};\n");
        stringBuffer.append("template<class T> T& Array<T>::operator[](int i)\n");
        stringBuffer.append("{\n");
        stringBuffer.append("if (i<0 || sz<=i) error(\"Array: range error\");\n");
        stringBuffer.append("return v[i];\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, false, 0);
    }

    public void test14_5_1_1s2() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Array<int> v1(20);\n");
        stringBuffer.append("Array<dcomplex> v2(30);\n");
        stringBuffer.append("v1[3] = 7; // Array<int>::operator[]()\n");
        stringBuffer.append("v2[3] = dcomplex(7,8); // Array<dcomplex>::operator[]()\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, false, 0);
    }

    public void test14_5_1_2s1() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template<class T> struct A {\n");
        stringBuffer.append("class B;\n");
        stringBuffer.append("};\n");
        stringBuffer.append("A<int>::B* b1; // OK: requires A to be defined but not A::B\n");
        stringBuffer.append("template<class T> class A<T>::B { };\n");
        stringBuffer.append("A<int>::B b2; // OK: requires A::B to be defined\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test14_5_2s1() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template<class T> class string {\n");
        stringBuffer.append("public:\n");
        stringBuffer.append("template<class T2> int compare(const T2&);\n");
        stringBuffer.append("template<class T2> string(const string<T2>& s) {  }\n");
        stringBuffer.append("// ...\n");
        stringBuffer.append("};\n");
        stringBuffer.append("template<class T> template<class T2> int string<T>::compare(const T2& s)\n");
        stringBuffer.append("{\n");
        stringBuffer.append("// ...\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, false, 0);
    }

    public void test14_5_2s4() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class B {\n");
        stringBuffer.append("virtual void f(int);\n");
        stringBuffer.append("};\n");
        stringBuffer.append("class D : public B {\n");
        stringBuffer.append("template <class T> void f(T); // does not override B::f(int)\n");
        stringBuffer.append("void f(int i) { f<>(i); } // overriding function that calls\n");
        stringBuffer.append("// the template instantiation\n");
        stringBuffer.append("};\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test14_5_2s5() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct A {\n");
        stringBuffer.append("template <class T> operator T*();\n");
        stringBuffer.append("};\n");
        stringBuffer.append("template <class T> A::operator T*(){ return 0; }\n");
        stringBuffer.append("template <> A::operator char*(){ return 0; } // specialization\n");
        stringBuffer.append("template A::operator void*(); // explicit instantiation\n");
        stringBuffer.append("int main()\n");
        stringBuffer.append("{\n");
        stringBuffer.append("A a;\n");
        stringBuffer.append("int* ip;\n");
        stringBuffer.append("ip = a.operator int*(); // explicit call to template operator\n");
        stringBuffer.append("// A::operator int*()\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, false, 0);
    }

    public void test14_5_1_3s1() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template<class T> class X {\n");
        stringBuffer.append("static T s;\n");
        stringBuffer.append("};\n");
        stringBuffer.append("template<class T> T X<T>::s = 0;\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test14_5_3s2() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("namespace N {\n");
        stringBuffer.append("template <class T> void f(T);\n");
        stringBuffer.append("void g(int);\n");
        stringBuffer.append("namespace M {\n");
        stringBuffer.append("template <class T> void h(T);\n");
        stringBuffer.append("template <class T> void i(T);\n");
        stringBuffer.append("struct A {\n");
        stringBuffer.append("friend void f<>(int); // illformed- N::f\n");
        stringBuffer.append("friend void h<>(int); // OK - M::h\n");
        stringBuffer.append("friend void g(int); // OK - new decl of M::g\n");
        stringBuffer.append("template <class T> void i(T);\n");
        stringBuffer.append("friend void i<>(int); // illformed- A::i\n");
        stringBuffer.append("};\n");
        stringBuffer.append("}\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, false, 0);
    }

    public void test14_5_3s3() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class A {\n");
        stringBuffer.append("template<class T> friend class B; // OK\n");
        stringBuffer.append("template<class T> friend void f(T){  } // OK\n");
        stringBuffer.append("};\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test14_5_3s4() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class X {\n");
        stringBuffer.append("template<class T> friend struct A;\n");
        stringBuffer.append("class Y { };\n");
        stringBuffer.append("};\n");
        stringBuffer.append("template<class T> struct A { X::Y ab; }; // OK\n");
        stringBuffer.append("template<class T> struct A<T*> { X::Y ab; }; // OK\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test14_5_3s6() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template<class T> struct A {\n");
        stringBuffer.append("struct B { };\n");
        stringBuffer.append("void f();\n");
        stringBuffer.append("};\n");
        stringBuffer.append("class C {\n");
        stringBuffer.append("template<class T> friend struct A<T>::B;\n");
        stringBuffer.append("template<class T> friend void A<T>::f();\n");
        stringBuffer.append("};\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test14_5_4_3s2() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template<class T> struct A {\n");
        stringBuffer.append("template<class T2> struct B {}; // #1\n");
        stringBuffer.append("template<class T2> struct B<T2*> {}; // #2\n");
        stringBuffer.append("};\n");
        stringBuffer.append("template<> template<class T2> struct A<short>::B {}; // #3\n");
        stringBuffer.append("A<char>::B<int*> abcip; // uses #2\n");
        stringBuffer.append("A<short>::B<int*> absip; // uses #3\n");
        stringBuffer.append("A<char>::B<int> abci; // uses #1\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test14_5_4s4() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template<class T1, class T2, int I> class A { }; // #1\n");
        stringBuffer.append("template<class T, int I> class A<T, T*, I> { }; // #2\n");
        stringBuffer.append("template<class T1, class T2, int I> class A<T1*, T2, I> { }; // #3\n");
        stringBuffer.append("template<class T> class A<int, T*, 5> { }; // #4\n");
        stringBuffer.append("template<class T1, class T2, int I> class A<T1, T2*, I> { }; // #5\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test14_5_4s9b() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template <int I, int J> struct B {};\n");
        stringBuffer.append("template <int I> struct B<I, I> {}; // OK\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test14_5_4_1s2a() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template<class T1, class T2, int I> class A { }; // #1\n");
        stringBuffer.append("template<class T, int I> class A<T, T*, I> { }; // #2\n");
        stringBuffer.append("template<class T1, class T2, int I> class A<T1*, T2, I> { }; // #3\n");
        stringBuffer.append("template<class T> class A<int, T*, 5> { }; // #4\n");
        stringBuffer.append("template<class T1, class T2, int I> class A<T1, T2*, I> { }; // #5\n");
        stringBuffer.append("A<int, int, 1> a1; // uses #1\n");
        stringBuffer.append("A<int, int*, 1> a2; // uses #2, T is int, I is 1\n");
        stringBuffer.append("A<int, char*, 5> a3; // uses #4, T is char\n");
        stringBuffer.append("A<int, char*, 1> a4; // uses #5, T1 is int, T2 is char, I is 1\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test14_5_4_1s2b() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template<class T1, class T2, int I> class A { };             // #1\n");
        stringBuffer.append("template<class T, int I>            class A<T, T*, I> { };   // #2\n");
        stringBuffer.append("template<class T1, class T2, int I> class A<T1*, T2, I> { }; // #3\n");
        stringBuffer.append("template<class T>                   class A<int, T*, 5> { }; // #4\n");
        stringBuffer.append("template<class T1, class T2, int I> class A<T1, T2*, I> { }; // #5\n");
        stringBuffer.append("A<int*, int*, 2> a5; // ambiguous: matches #3 and #5 : expect problem \n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 1);
    }

    public void test14_5_4_3s1() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("// primary template\n");
        stringBuffer.append("template<class T, int I> struct A {\n");
        stringBuffer.append("void f();\n");
        stringBuffer.append("};\n");
        stringBuffer.append("template<class T, int I> void A<T,I>::f() { }\n");
        stringBuffer.append("// class template partial specialization\n");
        stringBuffer.append("template<class T> struct A<T,2> {\n");
        stringBuffer.append("void f();\n");
        stringBuffer.append("void g();\n");
        stringBuffer.append("void h();\n");
        stringBuffer.append("};\n");
        stringBuffer.append("// member of class template partial specialization\n");
        stringBuffer.append("template<class T> void A<T,2>::g() { }\n");
        stringBuffer.append("// explicit specialization\n");
        stringBuffer.append("template<> void A<char,2>::h() { }\n");
        stringBuffer.append("int main()\n");
        stringBuffer.append("{\n");
        stringBuffer.append("A<char,0> a0;\n");
        stringBuffer.append("A<char,2> a2;\n");
        stringBuffer.append("a0.f(); //OK, uses definition of primary template\ufffds member\n");
        stringBuffer.append("a2.g(); //OK, uses definition of\n");
        stringBuffer.append("// partial specialization\ufffds member\n");
        stringBuffer.append("a2.h(); //OK, uses definition of\n");
        stringBuffer.append("// explicit specialization\ufffds member\n");
        stringBuffer.append("a2.f(); //illformed, no definition of f for A<T,2>\n");
        stringBuffer.append("// the primary template is not used here\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, false, 0);
    }

    public void test14_5_5s1() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template<class T> class Array { };\n");
        stringBuffer.append("template<class T> void sort(Array<T>&);\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test14_5_5_1s1a() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("// file1.c \n");
        stringBuffer.append("template<class T>\n");
        stringBuffer.append("void f(T*);\n");
        stringBuffer.append("void g(int* p) { \n");
        stringBuffer.append("f(p); // call \n");
        stringBuffer.append("// f<int>(int*) \n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test14_5_5_1s1b() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("// file2.c\n");
        stringBuffer.append("template<class T>\n");
        stringBuffer.append("void f(T);\n");
        stringBuffer.append("void h(int* p) {\n");
        stringBuffer.append("f(p); // call\n");
        stringBuffer.append("// f<int*>(int*)\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test14_5_5_2s5() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template<class T> struct A { A(); };\n");
        stringBuffer.append("template<class T> void f(T);\n");
        stringBuffer.append("template<class T> void f(T*);\n");
        stringBuffer.append("template<class T> void f(const T*);\n");
        stringBuffer.append("template<class T> void g(T);\n");
        stringBuffer.append("template<class T> void g(T&);\n");
        stringBuffer.append("template<class T> void h(const T&);\n");
        stringBuffer.append("template<class T> void h(A<T>&);\n");
        stringBuffer.append("void m() {\n");
        stringBuffer.append("const int *p;\n");
        stringBuffer.append("f(p); // f(const T*) is more specialized than f(T) or f(T*)\n");
        stringBuffer.append("float x;\n");
        stringBuffer.append("g(x); //Ambiguous: g(T) or g(T&)\n");
        stringBuffer.append("A<int> z;\n");
        stringBuffer.append("h(z); //overload resolution selects h(A<T>&)\n");
        stringBuffer.append("const A<int> z2;\n");
        stringBuffer.append("h(z2); // h(const T&) is called because h(A<T>&) is not callable\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, false, 0);
    }

    public void test14_5_5_2s6() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template<class T> void f(T); // #1\n");
        stringBuffer.append("template<class T> void f(T*, int=1); // #2\n");
        stringBuffer.append("template<class T> void g(T); // #3\n");
        stringBuffer.append("template<class T> void g(T*, ...); // #4\n");
        stringBuffer.append("int main() {\n");
        stringBuffer.append("int* ip;\n");
        stringBuffer.append("f(ip); //calls #2\n");
        stringBuffer.append("g(ip); //calls #4\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test14_6s2() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("// no B declared here\n");
        stringBuffer.append("class X;\n");
        stringBuffer.append("template<class T> class Y {\n");
        stringBuffer.append("class Z; // forward declaration of member class\n");
        stringBuffer.append("void f() {\n");
        stringBuffer.append("X* a1; // declare pointer to X\n");
        stringBuffer.append("T* a2; // declare pointer to T\n");
        stringBuffer.append("Y* a3; // declare pointer to Y<T>\n");
        stringBuffer.append("Z* a4; // declare pointer to Z\n");
        stringBuffer.append("typedef typename T::A TA;\n");
        stringBuffer.append("TA* a5; // declare pointer to T\ufffds A\n");
        stringBuffer.append("typename T::A* a6; // declare pointer to T\ufffds A\n");
        stringBuffer.append("T::A* a7; // T::A is not a type name:\n");
        stringBuffer.append("// multiply T::A by a7; illformed,\n");
        stringBuffer.append("// no visible declaration of a7\n");
        stringBuffer.append("B* a8; // B is not a type name:\n");
        stringBuffer.append("// multiply B by a8; illformed,\n");
        stringBuffer.append("// no visible declarations of B and a8\n");
        stringBuffer.append("}\n");
        stringBuffer.append("};\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, false, 0);
    }

    public void test14_6s4() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct A {\n");
        stringBuffer.append("struct X { };\n");
        stringBuffer.append("int X;\n");
        stringBuffer.append("};\n");
        stringBuffer.append("template<class T> void f(T t) {\n");
        stringBuffer.append("typename T::X x; // illformed: finds the data member X\n");
        stringBuffer.append("// not the member type X\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test14_6s6() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template<class T> struct A {\n");
        stringBuffer.append("typedef int B;\n");
        stringBuffer.append("A::B b; // illformed: typename required before A::B\n");
        stringBuffer.append("void f(A<T>::B); // illformed: typename required before A<T>::B\n");
        stringBuffer.append("typename A::B g(); // OK\n");
        stringBuffer.append("};\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, false, 0);
    }

    public void test14_6s7() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int j;\n");
        stringBuffer.append("template<class T> class X {\n");
        stringBuffer.append("// ...\n");
        stringBuffer.append("void f(T t, int i, char* p)\n");
        stringBuffer.append("{\n");
        stringBuffer.append("t = i; // diagnosed if X::f is instantiated\n");
        stringBuffer.append("// and the assignment to t is an error\n");
        stringBuffer.append("p = i; // may be diagnosed even if X::f is\n");
        stringBuffer.append("// not instantiated\n");
        stringBuffer.append("p = j; // may be diagnosed even if X::f is\n");
        stringBuffer.append("// not instantiated\n");
        stringBuffer.append("}\n");
        stringBuffer.append("void g(T t) {\n");
        stringBuffer.append("// +; //may be diagnosed even if X::g is\n");
        stringBuffer.append("// not instantiated\n");
        stringBuffer.append("}\n");
        stringBuffer.append("};\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, false, 0);
    }

    public void test14_6s8() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("//#include <iostream>\n");
        stringBuffer.append("using namespace std;\n");
        stringBuffer.append("template<class T> class Set {\n");
        stringBuffer.append("T* p;\n");
        stringBuffer.append("int cnt;\n");
        stringBuffer.append("public:\n");
        stringBuffer.append("Set();\n");
        stringBuffer.append("Set<T>(const Set<T>&);\n");
        stringBuffer.append("void printall()\n");
        stringBuffer.append("{\n");
        stringBuffer.append("for (int i = 0; i<cnt; i++)\n");
        stringBuffer.append("cout << p[i] << '\n';\n");
        stringBuffer.append("}\n");
        stringBuffer.append("// ...\n");
        stringBuffer.append("};\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, false, 0);
    }

    public void test14_6s9() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("void f(char);\n");
        stringBuffer.append("template<class T> void g(T t)\n");
        stringBuffer.append("{\n");
        stringBuffer.append("f(1); // f(char)\n");
        stringBuffer.append("f(T(1)); //dependent\n");
        stringBuffer.append("f(t); //dependent\n");
        stringBuffer.append("dd++; //not dependent\n");
        stringBuffer.append("// error: declaration for dd not found\n");
        stringBuffer.append("}\n");
        stringBuffer.append("void f(int);\n");
        stringBuffer.append("double dd;\n");
        stringBuffer.append("void h()\n");
        stringBuffer.append("{\n");
        stringBuffer.append("g(2); //will cause one call of f(char) followed\n");
        stringBuffer.append("// by two calls of f(int)\n");
        stringBuffer.append("g('a'); //will cause three calls of f(char)\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, false, 0);
    }

    public void test14_6_1s3a() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template<class T, T* p, class U = T> class X {  };\n");
        stringBuffer.append("template<class T> void f(T* p = new T);\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test14_6_1s1() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template<class T> class X {\n");
        stringBuffer.append("X* p; // meaning X<T>\n");
        stringBuffer.append("X<T>* p2;\n");
        stringBuffer.append("X<int>* p3;\n");
        stringBuffer.append("};\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test14_6_1s2() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template<class T> class Y;\n");
        stringBuffer.append("template<> class Y<int> {\n");
        stringBuffer.append("Y* p; // meaning Y<int>\n");
        stringBuffer.append("Y<char>* q; // meaning Y<char>\n");
        stringBuffer.append("};\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test14_6_1s3b() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template<class T> class X : public Array<T> {  };\n");
        stringBuffer.append("template<class T> class Y : public T { };\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, false, 0);
    }

    public void test14_6_1s4() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template<class T, int i> class Y {\n");
        stringBuffer.append("int T; // error: templateparameter redeclared\n");
        stringBuffer.append("void f() {\n");
        stringBuffer.append("char T; // error: templateparameter redeclared\n");
        stringBuffer.append("}\n");
        stringBuffer.append("};\n");
        stringBuffer.append("template<class X> class X; // error: templateparameter redeclared\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test14_6_1s5() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template<class T> struct A {\n");
        stringBuffer.append("struct B {  };\n");
        stringBuffer.append("void f();\n");
        stringBuffer.append("};\n");
        stringBuffer.append("template<class B> void A<B>::f() {\n");
        stringBuffer.append("B b; // A\ufffds B, not the template parameter\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test14_6_1s6() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("namespace N {\n");
        stringBuffer.append("int C;\n");
        stringBuffer.append("template<class T> class B {\n");
        stringBuffer.append("void f(T);\n");
        stringBuffer.append("};\n");
        stringBuffer.append("}\n");
        stringBuffer.append("template<class C> void N::B<C>::f(C) {\n");
        stringBuffer.append("C b; // C is the template parameter, not N::C\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test14_6_1s7() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct A {\n");
        stringBuffer.append("struct B {  };\n");
        stringBuffer.append("int a;\n");
        stringBuffer.append("int Y;\n");
        stringBuffer.append("};\n");
        stringBuffer.append("template<class B, class a> struct X : A {\n");
        stringBuffer.append("B b; // A\ufffds B\n");
        stringBuffer.append("a b; // error: A\ufffds a isn\ufffdt a type name\n");
        stringBuffer.append("};\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, false, 0);
    }

    public void test14_6_2s2() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template<class T> struct X : B<T> {\n");
        stringBuffer.append("typename T::A* pa;\n");
        stringBuffer.append("void f(B<T>* pb) {\n");
        stringBuffer.append("static int i = B<T>::i;\n");
        stringBuffer.append("pb->j++;\n");
        stringBuffer.append("}\n");
        stringBuffer.append("};\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, false, 0);
    }

    public void test14_6_2s4() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct A {\n");
        stringBuffer.append("struct B {  };\n");
        stringBuffer.append("int a;\n");
        stringBuffer.append("int Y;\n");
        stringBuffer.append("};\n");
        stringBuffer.append("int a;\n");
        stringBuffer.append("template<class T> struct Y : T {\n");
        stringBuffer.append("struct B {  };\n");
        stringBuffer.append("B b; // The B defined in Y\n");
        stringBuffer.append("void f(int i) { a = i; } // ::a\n");
        stringBuffer.append("Y* p; // Y<T>\n");
        stringBuffer.append("};\n");
        stringBuffer.append("Y<A> ya;\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test14_6_3s1() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("void g(double);\n");
        stringBuffer.append("void h();\n");
        stringBuffer.append("template<class T> class Z {\n");
        stringBuffer.append("public:\n");
        stringBuffer.append("void f() {\n");
        stringBuffer.append("g(1); //calls g(double)\n");
        stringBuffer.append("h++; //illformed:\n");
        stringBuffer.append("// cannot increment function;\n");
        stringBuffer.append("// this could be diagnosed either here or\n");
        stringBuffer.append("// at the point of instantiation\n");
        stringBuffer.append("}\n");
        stringBuffer.append("};\n");
        stringBuffer.append("void g(int); // not in scope at the point of the template\n");
        stringBuffer.append("// definition, not considered for the call g(1)\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, false, 0);
    }

    public void test14_6_5s2() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template<typename T> class number {\n");
        stringBuffer.append("number(int);\n");
        stringBuffer.append("//...\n");
        stringBuffer.append("friend number gcd(number& x, number& y) {  }\n");
        stringBuffer.append("//...\n");
        stringBuffer.append("};\n");
        stringBuffer.append("void g()\n");
        stringBuffer.append("{\n");
        stringBuffer.append("number<double> a(3), b(4);\n");
        stringBuffer.append("//...\n");
        stringBuffer.append("a = gcd(a,b); // finds gcd because number<double> is an\n");
        stringBuffer.append("// associated class, making gcd visible\n");
        stringBuffer.append("// in its namespace (global scope)\n");
        stringBuffer.append("b = gcd(3,4); // illformed; gcd is not visible\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, false, 0);
    }

    public void test14_7s6() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template<class T> class X {\n");
        stringBuffer.append("static T s;\n");
        stringBuffer.append("// ...\n");
        stringBuffer.append("};\n");
        stringBuffer.append("template<class T> T X<T>::s = 0;\n");
        stringBuffer.append("X<int> aa;\n");
        stringBuffer.append("X<char*> bb;\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test14_7_1s3() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template<class T> class Z {\n");
        stringBuffer.append("public:\n");
        stringBuffer.append("void f();\n");
        stringBuffer.append("void g();\n");
        stringBuffer.append("};\n");
        stringBuffer.append("void h()\n");
        stringBuffer.append("{\n");
        stringBuffer.append("Z<int> a; // instantiation of class Z<int> required\n");
        stringBuffer.append("Z<char>* p; // instantiation of class Z<char> not\n");
        stringBuffer.append("// required\n");
        stringBuffer.append("Z<double>* q; // instantiation of class Z<double>\n");
        stringBuffer.append("// not required\n");
        stringBuffer.append("a.f(); //instantiation of Z<int>::f() required\n");
        stringBuffer.append("p->g(); //instantiation of class Z<char> required, and\n");
        stringBuffer.append("// instantiation of Z<char>::g() required\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test14_7_1s4() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template<class T> class B {  };\n");
        stringBuffer.append("template<class T> class D : public B<T> {  };\n");
        stringBuffer.append("void f(void*);\n");
        stringBuffer.append("void f(B<int>*);\n");
        stringBuffer.append("void g(D<int>* p, D<char>* pp, D<double> ppp)\n");
        stringBuffer.append("{\n");
        stringBuffer.append("f(p); //instantiation of D<int> required: call f(B<int>*)\n");
        stringBuffer.append("B<char>* q = pp; // instantiation of D<char> required:\n");
        stringBuffer.append("// convert D<char>* to B<char>*\n");
        stringBuffer.append("delete ppp; // instantiation of D<double> required\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test14_7_1s6() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template<class T> class X;\n");
        stringBuffer.append("X<char> ch; // error: definition of X required\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test14_7s3() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template<class T = int> struct A {\n");
        stringBuffer.append("static int x;\n");
        stringBuffer.append("};\n");
        stringBuffer.append("template<class U> void g(U) { }\n");
        stringBuffer.append("template<> struct A<double> { }; // specialize for T == double\n");
        stringBuffer.append("template<> struct A<> { }; // specialize for T == int\n");
        stringBuffer.append("template<> void g(char) { } // specialize for U == char\n");
        stringBuffer.append("// U is deduced from the parameter type\n");
        stringBuffer.append("template<> void g<int>(int) { } // specialize for U == int\n");
        stringBuffer.append("template<> int A<char>::x = 0; // specialize for T == char\n");
        stringBuffer.append("template<class T = int> struct B {\n");
        stringBuffer.append("static int x;\n");
        stringBuffer.append("};\n");
        stringBuffer.append("template<> int B<>::x = 1; // specialize for T == int\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test14_7_1s5() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template <class T> struct S {\n");
        stringBuffer.append("operator int();\n");
        stringBuffer.append("};\n");
        stringBuffer.append("void f(int);\n");
        stringBuffer.append("void f(S<int>&);\n");
        stringBuffer.append("void f(S<float>);\n");
        stringBuffer.append("void g(S<int>& sr) {\n");
        stringBuffer.append("f(sr); //instantiation of S<int> allowed but not required\n");
        stringBuffer.append("// instantiation of S<float> allowed but not required\n");
        stringBuffer.append("};\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test14_7_1s10() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("namespace N {\n");
        stringBuffer.append("template<class T> class List {\n");
        stringBuffer.append("public:\n");
        stringBuffer.append("T* get();\n");
        stringBuffer.append("// ...\n");
        stringBuffer.append("};\n");
        stringBuffer.append("}\n");
        stringBuffer.append("template<class K, class V> class Map {\n");
        stringBuffer.append("N::List<V> lt;\n");
        stringBuffer.append("V get(K);\n");
        stringBuffer.append("// ...\n");
        stringBuffer.append("};\n");
        stringBuffer.append("void g(Map<char*,int>& m)\n");
        stringBuffer.append("{\n");
        stringBuffer.append("int i = m.get(\"Nicholas\");\n");
        stringBuffer.append("// ...\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test14_7_1s12() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template<class T> void f(T x, T y = ydef(T()), T z = zdef(T()));\n");
        stringBuffer.append("class A { };\n");
        stringBuffer.append("A zdef(A);\n");
        stringBuffer.append("void g(A a, A b, A c) {\n");
        stringBuffer.append("f(a, b, c); // no default argument instantiation\n");
        stringBuffer.append("f(a, b); // default argument z = zdef(T()) instantiated\n");
        stringBuffer.append("f(a); //illformed; ydef is not declared\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, false, 0);
    }

    public void test14_7_1s14() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template<class T> class X {\n");
        stringBuffer.append("X<T>* p; // OK\n");
        stringBuffer.append("X<T*> a; // implicit generation of X<T> requires\n");
        stringBuffer.append("// the implicit instantiation of X<T*> which requires\n");
        stringBuffer.append("// the implicit instantiation of X<T**> which ...\n");
        stringBuffer.append("};\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test14_7_2s2() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template<class T> class Array { void mf(); };\n");
        stringBuffer.append("template class Array<char>;\n");
        stringBuffer.append("template void Array<int>::mf();\n");
        stringBuffer.append("template<class T> void sort(Array<T>& v) {  }\n");
        stringBuffer.append("template void sort(Array<char>&); // argument is deduced here\n");
        stringBuffer.append("namespace N {\n");
        stringBuffer.append("template<class T> void f(T&) { }\n");
        stringBuffer.append("}\n");
        stringBuffer.append("template void N::f<int>(int&);\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test14_7_2s5() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("namespace N {\n");
        stringBuffer.append("template<class T> class Y { void mf() { } };\n");
        stringBuffer.append("}\n");
        stringBuffer.append("template class Y<int>; // error: class template Y not visible\n");
        stringBuffer.append("// in the global namespace\n");
        stringBuffer.append("using N::Y;\n");
        stringBuffer.append("template class Y<int>; // OK: explicit instantiation in namespace N\n");
        stringBuffer.append("template class N::Y<char*>; // OK: explicit instantiation in namespace N\n");
        stringBuffer.append("template void N::Y<double>::mf(); // OK: explicit instantiation\n");
        stringBuffer.append("// in namespace N\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, false, 0);
    }

    public void test14_7_2s6() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template<class T> class Array {  };\n");
        stringBuffer.append("template<class T> void sort(Array<T>& v);\n");
        stringBuffer.append("// instantiate sort(Array<int>&) - templateargument deduced\n");
        stringBuffer.append("template void sort<>(Array<int>&);\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test14_7_2s9() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("char* p = 0;\n");
        stringBuffer.append("template<class T> T g(T = &p);\n");
        stringBuffer.append("template int g<int>(int); // OK even though &p isn\ufffdt an int.\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test14_7_3s1() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template<class T> class stream;\n");
        stringBuffer.append("template<> class stream<char> {  };\n");
        stringBuffer.append("template<class T> class Array {  };\n");
        stringBuffer.append("template<class T> void sort(Array<T>& v) {  }\n");
        stringBuffer.append("template<> void sort<char*>(Array<char*>&) ;\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test14_7_3s3() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template<> class X<int> {  }; // error: X not a template\n");
        stringBuffer.append("template<class T> class X;\n");
        stringBuffer.append("template<> class X<char*> {  }; // OK: X is a template\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, false, 0);
    }

    public void test14_7_3s5() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template<class T> struct A {\n");
        stringBuffer.append("void f(T) {  }\n");
        stringBuffer.append("};\n");
        stringBuffer.append("template<> struct A<int> {\n");
        stringBuffer.append("void f(int);\n");
        stringBuffer.append("};\n");
        stringBuffer.append("void h()\n");
        stringBuffer.append("{\n");
        stringBuffer.append("A<int> a;\n");
        stringBuffer.append("a.f(16); // A<int>::f must be defined somewhere\n");
        stringBuffer.append("}\n");
        stringBuffer.append("// explicit specialization syntax not used for a member of\n");
        stringBuffer.append("// explicitly specialized class template specialization\n");
        stringBuffer.append("void A<int>::f(int) {  }\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test14_7_3s6() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template<class T> class Array {  };\n");
        stringBuffer.append("template<class T> void sort(Array<T>& v) {  }\n");
        stringBuffer.append("void f(Array<String>& v)\n");
        stringBuffer.append("{\n");
        stringBuffer.append("sort(v); //use primary template\n");
        stringBuffer.append("// sort(Array<T>&), T is String\n");
        stringBuffer.append("}\n");
        stringBuffer.append("template<> void sort<String>(Array<String>& v); // error: specialization\n");
        stringBuffer.append("// after use of primary template\n");
        stringBuffer.append("template<> void sort<>(Array<char*>& v); // OK: sort<char*> not yet used\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, false, 0);
    }

    public void test14_7_3s9() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("namespace N {\n");
        stringBuffer.append("template<class T> class X {  };\n");
        stringBuffer.append("template<class T> class Y {  };\n");
        stringBuffer.append("template<> class X<int> {  }; // OK: specialization\n");
        stringBuffer.append("// in same namespace\n");
        stringBuffer.append("template<> class Y<double>; // forward declare intent to\n");
        stringBuffer.append("// specialize for double\n");
        stringBuffer.append("}\n");
        stringBuffer.append("template<> class N::Y<double> {  }; // OK: specialization\n");
        stringBuffer.append("// in same namespace\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test14_7_3s11() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template<class T> class Array {  };\n");
        stringBuffer.append("template<class T> void sort(Array<T>& v);\n");
        stringBuffer.append("// explicit specialization for sort(Array<int>&)\n");
        stringBuffer.append("// with deduces templateargument of type int\n");
        stringBuffer.append("template<> void sort(Array<int>&);\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test14_7_3s17() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template<class T1> class A {\n");
        stringBuffer.append("template<class T2> class B {\n");
        stringBuffer.append("void mf();\n");
        stringBuffer.append("};\n");
        stringBuffer.append("};\n");
        stringBuffer.append("template<> template<> class A<int>::B<double> { };\n");
        stringBuffer.append("template<> template<> void A<char>::B<char>::mf() { };\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test14_7_3s10() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template<class T> class X; // X is a class template\n");
        stringBuffer.append("template<> class X<int>;\n");
        stringBuffer.append("X<int>* p; // OK: pointer to declared class X<int>\n");
        stringBuffer.append("X<int> x; // error: object of incomplete class X<int>\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test14_7_3s12() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template <class T> void f(T);\n");
        stringBuffer.append("template <class T> void f(T*);\n");
        stringBuffer.append("template <> void f(int*); // Ambiguous\n");
        stringBuffer.append("template <> void f<int>(int*); // OK\n");
        stringBuffer.append("template <> void f(int); // OK\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 1);
    }

    public void test14_7_3s14() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template<class T> void f(T) {  }\n");
        stringBuffer.append("template<class T> inline T g(T) {  }\n");
        stringBuffer.append("template<> inline void f<>(int) {  } // OK: inline\n");
        stringBuffer.append("template<> int g<>(int) {  } // OK: not inline\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test14_7_3s16() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template<class T> struct A {\n");
        stringBuffer.append("void f(T);\n");
        stringBuffer.append("template<class X> void g(T,X);\n");
        stringBuffer.append("void h(T) { }\n");
        stringBuffer.append("};\n");
        stringBuffer.append("// specialization\n");
        stringBuffer.append("template<> void A<int>::f(int);\n");
        stringBuffer.append("// out of class member template definition\n");
        stringBuffer.append("template<class T> template<class X> void A<T>::g(T,X) { }\n");
        stringBuffer.append("// member template partial specialization\n");
        stringBuffer.append("template<> template<class X> void A<int>::g(int,X);\n");
        stringBuffer.append("// member template specialization\n");
        stringBuffer.append("template<> template<>\n");
        stringBuffer.append("void A<int>::g(int,char); // X deduced as char\n");
        stringBuffer.append("template<> template<>\n");
        stringBuffer.append("void A<int>::g<char>(int,char); // X specified as char\n");
        stringBuffer.append("// member specialization even if defined in class definition\n");
        stringBuffer.append("template<> void A<int>::h(int) { }\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test14_7_3s18() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template<class T1> class A {\n");
        stringBuffer.append("template<class T2> class B {\n");
        stringBuffer.append("template<class T3> void mf1(T3);\n");
        stringBuffer.append("void mf2();\n");
        stringBuffer.append("};\n");
        stringBuffer.append("};\n");
        stringBuffer.append("template<> template<class X>\n");
        stringBuffer.append("class A<int>::B { };\n");
        stringBuffer.append("template<> template<> template<class T>\n");
        stringBuffer.append("void A<int>::B<double>::mf1(T t) { };\n");
        stringBuffer.append("template<class Y> template<>\n");
        stringBuffer.append("void A<Y>::B<double>::mf2() { }; // illformed; B<double> is specialized but\n");
        stringBuffer.append("// its enclosing class template A is not\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, false, 0);
    }

    public void test14_8s2() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template<class T> void f(T* p)\n");
        stringBuffer.append("{\n");
        stringBuffer.append("static T s;\n");
        stringBuffer.append("// ...\n");
        stringBuffer.append("};\n");
        stringBuffer.append("void g(int a, char* b)\n");
        stringBuffer.append("{\n");
        stringBuffer.append("f(&a); //call f<int>(int*)\n");
        stringBuffer.append("f(&b); //call f<char*>(char**)\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test14_8_1s1() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template<class T> void sort(Array<T>& v);\n");
        stringBuffer.append("void f(Array<dcomplex>& cv, Array<int>& ci)\n");
        stringBuffer.append("{\n");
        stringBuffer.append("sort<dcomplex>(cv); // sort(Array<dcomplex>&)\n");
        stringBuffer.append("sort<int>(ci); // sort(Array<int>&)\n");
        stringBuffer.append("}\n");
        stringBuffer.append("template<class U, class V> U convert(V v);\n");
        stringBuffer.append("void g(double d)\n");
        stringBuffer.append("{\n");
        stringBuffer.append("int i = convert<int,double>(d); // int convert(double)\n");
        stringBuffer.append("char c = convert<char,double>(d); // char convert(double)\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, false, 0);
    }

    public void test14_8_1s2() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template<class X, class Y> X f(Y);\n");
        stringBuffer.append("void g()\n");
        stringBuffer.append("{\n");
        stringBuffer.append("int i = f<int>(5.6); // Y is deduced to be double\n");
        stringBuffer.append("int j = f(5.6); // illformed: X cannot be deduced\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, false, 0);
    }

    public void test14_8_1s3() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template<class X, class Y, class Z> X f(Y,Z);\n");
        stringBuffer.append("void g()\n");
        stringBuffer.append("{\n");
        stringBuffer.append("f<int,char*,double>(\"aa\",3.0);\n");
        stringBuffer.append("f<int,char*>(\"aa\",3.0); // Z is deduced to be double\n");
        stringBuffer.append("f<int>(\"aa\",3.0); // Y is deduced to be char*, and\n");
        stringBuffer.append("// Z is deduced to be double\n");
        stringBuffer.append("f(\"aa\",3.0); //error: X cannot be deduced\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, false, 0);
    }

    public void test14_8_1s6() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("namespace A {\n");
        stringBuffer.append("struct B { };\n");
        stringBuffer.append("template<int X> void f();\n");
        stringBuffer.append("}\n");
        stringBuffer.append("namespace C {\n");
        stringBuffer.append("template<class T> void f(T t);\n");
        stringBuffer.append("}\n");
        stringBuffer.append("void g(A::B b) {\n");
        stringBuffer.append("f<3>(b); //illformed: not a function call\n");
        stringBuffer.append("A::f<3>(b); //wellformed\n");
        stringBuffer.append("C::f<3>(b); //illformed; argument dependent lookup\n");
        stringBuffer.append("// only applies to unqualified names\n");
        stringBuffer.append("using C::f;\n");
        stringBuffer.append("f<3>(b); //wellformed because C::f is visible; then\n");
        stringBuffer.append("// A::f is found by argument dependent lookup\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, false, 0);
    }

    public void test14_8_2s1() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("void f(Array<dcomplex>& cv, Array<int>& ci)\n");
        stringBuffer.append("{\n");
        stringBuffer.append("sort(cv); //call sort(Array<dcomplex>&)\n");
        stringBuffer.append("sort(ci); //call sort(Array<int>&)\n");
        stringBuffer.append("}\n");
        stringBuffer.append("void g(double d)\n");
        stringBuffer.append("{\n");
        stringBuffer.append("int i = convert<int>(d); // call convert<int,double>(double)\n");
        stringBuffer.append("int c = convert<char>(d); // call convert<char,double>(double)\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, false, 0);
    }

    public void test14_8_2s2a() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template <class T> int f(T[5]);\n");
        stringBuffer.append("int I = f<int>(0);\n");
        stringBuffer.append("int j = f<void>(0); // invalid array\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, false, 0);
    }

    public void test14_8_2s2d() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template <class T> int f(int T::*);\n");
        stringBuffer.append("int i = f<int>(0);\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 2);
    }

    public void test14_8_2s2e() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template <class T, T*> int f(int);\n");
        stringBuffer.append("int i2 = f<int,1>(0); // can\ufffdt conv 1 to int*\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, false, 1);
    }

    public void test14_8_2s5() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template <int> int f(int);\n");
        stringBuffer.append("template <signed char> int f(int);\n");
        stringBuffer.append("int i1 = f<1>(0); // ambiguous\n");
        stringBuffer.append("int i2 = f<1000>(0); // ambiguous\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test14_8_2_4s5() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template<class T> void f(T x, T y) {  }\n");
        stringBuffer.append("struct A {  };\n");
        stringBuffer.append("struct B : A { };\n");
        stringBuffer.append("int g(A a, B b)\n");
        stringBuffer.append("{\n");
        stringBuffer.append("f(a,b); //error: T could be A or B\n");
        stringBuffer.append("f(b,a); //error: T could be A or B\n");
        stringBuffer.append("f(a,a); //OK: T is A\n");
        stringBuffer.append("f(b,b); //OK: T is B\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, false, 0);
    }

    public void test14_8_2_4s6() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template <class T, class U> void f( T (*)( T, U, U ) );\n");
        stringBuffer.append("int g1( int, float, float);\n");
        stringBuffer.append("char g2( int, float, float);\n");
        stringBuffer.append("int g3( int, char, float);\n");
        stringBuffer.append("void r()\n");
        stringBuffer.append("{\n");
        stringBuffer.append("f(g1); //OK: T is int and U is float\n");
        stringBuffer.append("f(g2); //error: T could be char or int\n");
        stringBuffer.append("f(g3); //error: U could be char or float\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, false, 0);
    }

    public void test14_8_2_4s12() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template<class T, T i> void f(double a[10][i]);\n");
        stringBuffer.append("int v[10][20];\n");
        stringBuffer.append("int foo() {\n");
        stringBuffer.append("f(v); //error: argument for templateparameter\n");
        stringBuffer.append("//T cannot be deduced\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, false, 0);
    }

    public void test14_8_2_4s13() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template<int i> void f1(int a[10][i]);\n");
        stringBuffer.append("template<int i> void f2(int a[i][20]);\n");
        stringBuffer.append("template<int i> void f3(int (&a)[i][20]);\n");
        stringBuffer.append("void g()\n");
        stringBuffer.append("{\n");
        stringBuffer.append("int v[10][20];\n");
        stringBuffer.append("f1(v); //OK: i deduced to be 20\n");
        stringBuffer.append("f1<20>(v); //OK\n");
        stringBuffer.append("f2(v); //error: cannot deduce templateargument i\n");
        stringBuffer.append("f2<10>(v); //OK\n");
        stringBuffer.append("f3(v); //OK: i deduced to be 10\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, false, 0);
    }

    public void test14_8_2_4s15() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template<int i> class A { /* ... */ };\n");
        stringBuffer.append("template<short s> void f(A<s>);\n");
        stringBuffer.append("void k1() {\n");
        stringBuffer.append("A<1> a;\n");
        stringBuffer.append("f(a); //error: deduction fails for conversion from int to short\n");
        stringBuffer.append("f<1>(a); //OK\n");
        stringBuffer.append("}\n");
        stringBuffer.append("template<const short cs> class B { };\n");
        stringBuffer.append("template<short s> void h(B<s>);\n");
        stringBuffer.append("void k2() {\n");
        stringBuffer.append("B<1> b;\n");
        stringBuffer.append("g(b); //OK: cvqualifiers are ignored on template parameter types\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, false, 0);
    }

    public void test14_8_2_4s16() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template<class T> void f(void(*)(T,int));\n");
        stringBuffer.append("template<class T> void foo(T,int);\n");
        stringBuffer.append("void g(int,int);\n");
        stringBuffer.append("void g(char,int);\n");
        stringBuffer.append("void h(int,int,int);\n");
        stringBuffer.append("void h(char,int);\n");
        stringBuffer.append("int m()\n");
        stringBuffer.append("{\n");
        stringBuffer.append("f(&g); //error: ambiguous\n");
        stringBuffer.append("f(&h); //OK: void h(char,int) is a unique match\n");
        stringBuffer.append("f(&foo); //error: type deduction fails because foo is a template\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, false, 0);
    }

    public void test14_8_2_4s17() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template <class T> void f(T = 5, T = 7);\n");
        stringBuffer.append("void g()\n");
        stringBuffer.append("{\n");
        stringBuffer.append("f(1); //OK: call f<int>(1,7)\n");
        stringBuffer.append("f(); //error: cannot deduce T\n");
        stringBuffer.append("f<int>(); //OK: call f<int>(5,7)\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, false, 0);
    }

    public void test14_8_3s2() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template<class T> T max(T a, T b) { return a>b?a:b; }\n");
        stringBuffer.append("void f(int a, int b, char c, char d)\n");
        stringBuffer.append("{\n");
        stringBuffer.append("int m1 = max(a,b); // max(int a, int b)\n");
        stringBuffer.append("char m2 = max(c,d); // max(char a, char b)\n");
        stringBuffer.append("int m3 = max(a,c); // error: cannot generate max(int,char)\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, false, 0);
    }

    public void test14_8_3s3() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template<class T> T max(T a, T b) { return a>b?a:b; }\n");
        stringBuffer.append("int max(int,int);\n");
        stringBuffer.append("void f(int a, int b, char c, char d)\n");
        stringBuffer.append("{\n");
        stringBuffer.append("int m1 = max(a,b); // max(int a, int b)\n");
        stringBuffer.append("char m2 = max(c,d); // max(char a, char b)\n");
        stringBuffer.append("int m3 = max(a,c); // resolved\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test14_8_3s4() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template<class T> struct B {  };\n");
        stringBuffer.append("template<class T> struct D : public B<T> {  };\n");
        stringBuffer.append("template<class T> void f(B<T>&);\n");
        stringBuffer.append("void g(B<int>& bi, D<int>& di)\n");
        stringBuffer.append("{\n");
        stringBuffer.append("f(bi); // f(bi)\n");
        stringBuffer.append("f(di); // f( (B<int>&)di )\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test14_8_3s6() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template<class T> void f(T); // declaration    \n");
        stringBuffer.append("void g() {                                     \n");
        stringBuffer.append("   f(\"Annemarie\"); // call of f<const char*> \n");
        stringBuffer.append("}                                              \n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test15s2() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int foo() {\n");
        stringBuffer.append("lab: try {\n");
        stringBuffer.append("int t1;\n");
        stringBuffer.append("try {\n");
        stringBuffer.append("int t2;\n");
        stringBuffer.append("if (1)\n");
        stringBuffer.append("goto lab;\n");
        stringBuffer.append("} catch(...) { // handler 2 \n");
        stringBuffer.append("}\n");
        stringBuffer.append("} catch(...) { // handler 1\n");
        stringBuffer.append("}\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test15s3() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int f(int);\n");
        stringBuffer.append("class C {\n");
        stringBuffer.append("int i;\n");
        stringBuffer.append("double d;\n");
        stringBuffer.append("public:\n");
        stringBuffer.append("C(int, double);\n");
        stringBuffer.append("};\n");
        stringBuffer.append("C::C(int ii, double id)\n");
        stringBuffer.append("try\n");
        stringBuffer.append(": i(f(ii)), d(id)\n");
        stringBuffer.append("{\n");
        stringBuffer.append("// constructor function body\n");
        stringBuffer.append("}\n");
        stringBuffer.append("catch (...)\n");
        stringBuffer.append("{\n");
        stringBuffer.append("// handles exceptions thrown from the ctorinitializer\n");
        stringBuffer.append("// and from the constructor function body\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test15_1s1() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class Overflow {\n");
        stringBuffer.append("// ...\n");
        stringBuffer.append("public:\n");
        stringBuffer.append("Overflow(char,double,double);\n");
        stringBuffer.append("};\n");
        stringBuffer.append("void f(double x)\n");
        stringBuffer.append("{\n");
        stringBuffer.append("// ...\n");
        stringBuffer.append("throw Overflow('+',x,3.45e107);\n");
        stringBuffer.append("}\n");
        stringBuffer.append("int foo() {\n");
        stringBuffer.append("try {\n");
        stringBuffer.append("// ...\n");
        stringBuffer.append("f(1.2);\n");
        stringBuffer.append("// ...\n");
        stringBuffer.append("}\n");
        stringBuffer.append("catch(Overflow& oo) {\n");
        stringBuffer.append("// handle exceptions of type Overflow here\n");
        stringBuffer.append("}\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test15_1s6() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int foo() {\n");
        stringBuffer.append("try {\n");
        stringBuffer.append("// ...\n");
        stringBuffer.append("}\n");
        stringBuffer.append("catch (...) { // catch all exceptions\n");
        stringBuffer.append("// respond (partially) to exception\n");
        stringBuffer.append("throw; //pass the exception to some\n");
        stringBuffer.append("// other handler\n");
        stringBuffer.append("}\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test15_3s4() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class Matherr {  virtual vf(); };\n");
        stringBuffer.append("class Overflow: public Matherr {  };\n");
        stringBuffer.append("class Underflow: public Matherr {  };\n");
        stringBuffer.append("class Zerodivide: public Matherr {  };\n");
        stringBuffer.append("void f()\n");
        stringBuffer.append("{\n");
        stringBuffer.append("try {\n");
        stringBuffer.append("}\n");
        stringBuffer.append("catch (Overflow oo) {\n");
        stringBuffer.append("// ...\n");
        stringBuffer.append("}\n");
        stringBuffer.append("catch (Matherr mm) {\n");
        stringBuffer.append("// ...\n");
        stringBuffer.append("}\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test15_4s1a() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("void f() throw(int); // OK\n");
        stringBuffer.append("void (*fp)() throw (int); // OK\n");
        stringBuffer.append("void g(void pfa() throw(int)); // OK\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test15_4s1b() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("typedef int (*pf)() throw(int); // illformed\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test15_4s3a() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct B {\n");
        stringBuffer.append("virtual void f() throw (int, double);\n");
        stringBuffer.append("virtual void g();\n");
        stringBuffer.append("};\n");
        stringBuffer.append("struct D: B {\n");
        stringBuffer.append("void f(); // illformed\n");
        stringBuffer.append("void g() throw (int); // OK\n");
        stringBuffer.append("};\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test15_4s3b() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class A {  };\n");
        stringBuffer.append("void (*pf1)(); // no exception specification\n");
        stringBuffer.append("void (*pf2)() throw(A);\n");
        stringBuffer.append("void f()\n");
        stringBuffer.append("{\n");
        stringBuffer.append("pf1 = pf2; // OK: pf1 is less restrictive\n");
        stringBuffer.append("pf2 = pf1; // error: pf2 is more restrictive\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test15_4s8() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class X { };\n");
        stringBuffer.append("class Y { };\n");
        stringBuffer.append("class Z: public X { };\n");
        stringBuffer.append("class W { };\n");
        stringBuffer.append("void f() throw (X, Y)\n");
        stringBuffer.append("{\n");
        stringBuffer.append("int n = 0;\n");
        stringBuffer.append("if (n) throw X(); // OK\n");
        stringBuffer.append("if (n) throw Z(); // also OK\n");
        stringBuffer.append("throw W(); // will call unexpected()\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test15_4s10() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("extern void f() throw(X, Y);\n");
        stringBuffer.append("void g() throw(X)\n");
        stringBuffer.append("{\n");
        stringBuffer.append("// f(); //OK\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, false, 0);
    }

    public void test15_4s13() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct A {\n");
        stringBuffer.append("A();\n");
        stringBuffer.append("A(const A&) throw();\n");
        stringBuffer.append("~A() throw(X);\n");
        stringBuffer.append("};\n");
        stringBuffer.append("struct B {\n");
        stringBuffer.append("B() throw();\n");
        stringBuffer.append("B(const B&) throw();\n");
        stringBuffer.append("~B() throw(Y);\n");
        stringBuffer.append("};\n");
        stringBuffer.append("struct D : public A, public B {\n");
        stringBuffer.append("// Implicit declaration of D::D();\n");
        stringBuffer.append("// Implicit declaration of D::D(const D&) throw();\n");
        stringBuffer.append("// Implicit declaration of D::~D() throw (X,Y);\n");
        stringBuffer.append("};\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, false, 0);
    }

    public void test16_2s8() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("#if VERSION = = 1\n");
        stringBuffer.append("#define INCFILE \"vers1.h\"\n");
        stringBuffer.append("#elif VERSION = = 2\n");
        stringBuffer.append("#define INCFILE \"vers2.h\" // and so on\n");
        stringBuffer.append("#else\n");
        stringBuffer.append("#define INCFILE \"versN.h\"\n");
        stringBuffer.append("#endif\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test18_2_1_5s2() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int f() {\n");
        stringBuffer.append("int a, b;\n");
        stringBuffer.append("/*...*/\n");
        stringBuffer.append("a = a + 32760 + b + 5;\n");
        stringBuffer.append("a = (((a + 32760) + b) + 5);\n");
        stringBuffer.append("a = ((a + b) + 32765);\n");
        stringBuffer.append("a = ((a + 32765) + b);\n");
        stringBuffer.append("a = (a + (b + 32765));\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test3_3_1s4() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct X {\n");
        stringBuffer.append("enum E { z = 16 };\n");
        stringBuffer.append("int b[X::z]; // OK\n");
        stringBuffer.append("};\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test3_4_1s3() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("typedef int f;\n");
        stringBuffer.append("struct A {\n");
        stringBuffer.append("friend void f(A &);\n");
        stringBuffer.append("operator int();\n");
        stringBuffer.append("void g(A a) {\n");
        stringBuffer.append("f(a);\n");
        stringBuffer.append("}\n");
        stringBuffer.append("};\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test3_4_5s4() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct A {\n");
        stringBuffer.append("int a;\n");
        stringBuffer.append("};\n");
        stringBuffer.append("struct B: virtual A { };\n");
        stringBuffer.append("struct C: B { };\n");
        stringBuffer.append("struct D: B { };\n");
        stringBuffer.append("struct E: public C, public D { };\n");
        stringBuffer.append("struct F: public A { };\n");
        stringBuffer.append("void f() {\n");
        stringBuffer.append("E e;\n");
        stringBuffer.append("e.B::a = 0; // OK, only one A::a in E\n");
        stringBuffer.append("F f;\n");
        stringBuffer.append("f.A::a = 1; // OK, A::a is a member of F\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test3_6_2s2() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("inline double fd() { return 1.0; }\n");
        stringBuffer.append("extern double d1;\n");
        stringBuffer.append("double d2 = d1; // unspecified:\n");
        stringBuffer.append("// may be statically initialized to 0.0 or\n");
        stringBuffer.append("// dynamically initialized to 1.0\n");
        stringBuffer.append("double d1 = fd(); // may be initialized statically to 1.0\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test4_4s4() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int main() {\n");
        stringBuffer.append("const char c = 'c';\n");
        stringBuffer.append("char* pc;\n");
        stringBuffer.append("const char** pcc = &pc; //1: not allowed\n");
        stringBuffer.append("*pcc = &c;\n");
        stringBuffer.append("*pc = 'C'; //2: modifies a const object\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test5_5s5() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct S {\n");
        stringBuffer.append("mutable int i;\n");
        stringBuffer.append("};\n");
        stringBuffer.append("int f() {\n");
        stringBuffer.append("const S cs;\n");
        stringBuffer.append("int S::* pm = &S::i; // pm refers to mutable member S::i\n");
        stringBuffer.append("cs.*pm = 88; // illformed: cs is a const object\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test7_3_4s4() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("namespace A {\n");
        stringBuffer.append("class X { };\n");
        stringBuffer.append("extern \"C\" int g();\n");
        stringBuffer.append("extern \"C++\" int h();\n");
        stringBuffer.append("}\n");
        stringBuffer.append("namespace B {\n");
        stringBuffer.append("void X(int);\n");
        stringBuffer.append("extern \"C\" int g();\n");
        stringBuffer.append("extern \"C++\" int h();\n");
        stringBuffer.append("}\n");
        stringBuffer.append("using namespace A;\n");
        stringBuffer.append("using namespace B;\n");
        stringBuffer.append("void f() {\n");
        stringBuffer.append("X(1); //error: name X found in two namespaces\n");
        stringBuffer.append("g(); //okay: name g refers to the same entity\n");
        stringBuffer.append("h(); //error: name h found in two namespaces\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, false, 0);
    }

    public void test8_4s5() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("void print(int a, int)\n");
        stringBuffer.append("{\n");
        stringBuffer.append("//printf(\"a = %d\",a);\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test8_5s14() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int a;\n");
        stringBuffer.append("const int b = a;\n");
        stringBuffer.append("int c = b;\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test10_3s3() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct B {\n");
        stringBuffer.append("virtual void f();\n");
        stringBuffer.append("};\n");
        stringBuffer.append("struct D : B {\n");
        stringBuffer.append("void f(int);\n");
        stringBuffer.append("};\n");
        stringBuffer.append("struct D2 : D {\n");
        stringBuffer.append("void f();\n");
        stringBuffer.append("};\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test12_5s7a() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct B {\n");
        stringBuffer.append("virtual ~B();\n");
        stringBuffer.append("void operator delete(void*, size_t);\n");
        stringBuffer.append("};\n");
        stringBuffer.append("struct D : B {\n");
        stringBuffer.append("void operator delete(void*);\n");
        stringBuffer.append("};\n");
        stringBuffer.append("void f()\n");
        stringBuffer.append("{\n");
        stringBuffer.append("B* bp = new D;\n");
        stringBuffer.append("delete bp; //1: uses D::operator delete(void*)\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, false, 0);
    }

    public void test12_5s7b() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct B {\n");
        stringBuffer.append("virtual ~B();\n");
        stringBuffer.append("void operator delete[](void*, size_t);\n");
        stringBuffer.append("};\n");
        stringBuffer.append("struct D : B {\n");
        stringBuffer.append("void operator delete[](void*, size_t);\n");
        stringBuffer.append("};\n");
        stringBuffer.append("void f(int i)\n");
        stringBuffer.append("{\n");
        stringBuffer.append("D* dp = new D[i];\n");
        stringBuffer.append("delete [] dp; // uses D::operator delete[](void*, size_t)\n");
        stringBuffer.append("B* bp = new D[i];\n");
        stringBuffer.append("delete[] bp; // undefined behavior\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, false, 0);
    }

    public void test13_3_1_2s10() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct A { };\n");
        stringBuffer.append("void operator + (A, A);\n");
        stringBuffer.append("struct B {\n");
        stringBuffer.append("void operator + (B);\n");
        stringBuffer.append("void f ();\n");
        stringBuffer.append("};\n");
        stringBuffer.append("A a;\n");
        stringBuffer.append("void B::f() {\n");
        stringBuffer.append("operator+ (a,a); // ERROR - global operator hidden by member\n");
        stringBuffer.append("a + a; // OK - calls global operator+\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test14_1s2() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template<class T> class myarray {  };\n");
        stringBuffer.append("template<class K, class V, template<class T> class C = myarray>\n");
        stringBuffer.append("class Map {\n");
        stringBuffer.append("C<K> key;\n");
        stringBuffer.append("C<V> value;\n");
        stringBuffer.append("// ...\n");
        stringBuffer.append("};\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test14_1s3() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class T {  };\n");
        stringBuffer.append("int i;\n");
        stringBuffer.append("template<class T, T i> void f(T t)\n");
        stringBuffer.append("{\n");
        stringBuffer.append("T t1 = i; // templateparameters T and i\n");
        stringBuffer.append("::T t2 = ::i; // global namespace members T and i\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test14_3_2s3() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template<int* p> class X { };\n");
        stringBuffer.append("int a[10];\n");
        stringBuffer.append("struct S { int m; static int s; } s;\n");
        stringBuffer.append("X<&a[2]> x3; // error: address of array element\n");
        stringBuffer.append("X<&s.m> x4; // error: address of nonstatic member\n");
        stringBuffer.append("X<&s.s> x5; // error: &S::s must be used\n");
        stringBuffer.append("X<&S::s> x6; // OK: address of static member\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test14_3_2s2() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template<class T, char* p> class X {\n");
        stringBuffer.append("// ...\n");
        stringBuffer.append("X();\n");
        stringBuffer.append("X(const char* q) {  }\n");
        stringBuffer.append("};\n");
        stringBuffer.append("X<int,\"Studebaker\"> x1; // error: string literal as template argument\n");
        stringBuffer.append("char p[] = \"Vivisectionist\";\n");
        stringBuffer.append("X<int,p> x2; // OK\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, false, 0);
    }

    public void test14_3_2s4() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template<const int& CRI> struct B { /* ... */ };\n");
        stringBuffer.append("B<1> b2; // error: temporary would be required for template argument\n");
        stringBuffer.append("int c = 1;\n");
        stringBuffer.append("B<c> b1; // OK\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, false, 0);
    }

    public void test14_3_2s5() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template<const int* pci> struct X {  };\n");
        stringBuffer.append("int ai[10];\n");
        stringBuffer.append("X<ai> xi; // array to pointer and qualification conversions\n");
        stringBuffer.append("struct Y {  };\n");
        stringBuffer.append("template<const Y& b> struct Z {  };\n");
        stringBuffer.append("Y y;\n");
        stringBuffer.append("Z<y> z; // no conversion, but note extra cvqualification\n");
        stringBuffer.append("template<int (&pa)[5]> struct W {  };\n");
        stringBuffer.append("int b[5];\n");
        stringBuffer.append("W<b> w; // no conversion\n");
        stringBuffer.append("void f(char);\n");
        stringBuffer.append("void f(int);\n");
        stringBuffer.append("template<void (*pf)(int)> struct A {  };\n");
        stringBuffer.append("A<&f> a; // selects f(int)\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test14_5_2s2() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template <class T> struct A {\n");
        stringBuffer.append("void f(int);\n");
        stringBuffer.append("template <class T2> void f(T2);\n");
        stringBuffer.append("};\n");
        stringBuffer.append("template <> void A<int>::f(int) { } // nontemplate member\n");
        stringBuffer.append("template <> template <> void A<int>::f<>(int) { } // template member\n");
        stringBuffer.append("int main()\n");
        stringBuffer.append("{\n");
        stringBuffer.append("A<char> ac;\n");
        stringBuffer.append("ac.f(1); //nontemplate\n");
        stringBuffer.append("ac.f('c'); //template\n");
        stringBuffer.append("ac.f<>(1); //template\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test14_5_4s5() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template<class T1, class T2, int I> class A<T1, T2, I> { }; // error\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, false, 0);
    }

    public void test14_5_4s6() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template<class T> struct A {\n");
        stringBuffer.append("class C {\n");
        stringBuffer.append("template<class T2> struct B { };\n");
        stringBuffer.append("};\n");
        stringBuffer.append("};\n");
        stringBuffer.append("// partial specialization of A<T>::C::B<T2>\n");
        stringBuffer.append("template<class T> template<class T2>\n");
        stringBuffer.append("struct A<T>::C::B<T2*> { };\n");
        stringBuffer.append("A<short>::C::B<int*> absip; // uses partial specialization\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test14_5_4s7() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("namespace N {\n");
        stringBuffer.append("template<class T1, class T2> class A { }; // primary template\n");
        stringBuffer.append("}\n");
        stringBuffer.append("using N::A; // refers to the primary template\n");
        stringBuffer.append("namespace N {\n");
        stringBuffer.append("template<class T> class A<T, T*> { }; // partial specialization\n");
        stringBuffer.append("}\n");
        stringBuffer.append("A<int,int*> a; // uses the partial specialization, which is found through\n");
        stringBuffer.append("// the using declaration which refers to the primary template\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test14_5_5_1s4() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template<class T> void f();\n");
        stringBuffer.append("template<int I> void f(); // OK: overloads the first template\n");
        stringBuffer.append("// distinguishable with an explicit template argument list\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test14_8_1s2b() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template <class T> int f(T); // #1\n");
        stringBuffer.append("int f(int); // #2\n");
        stringBuffer.append("int k = f(1); // uses #2\n");
        stringBuffer.append("int l = f<>(1); // uses #1\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test15_3_5s3() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("#define TABSIZE 100\n");
        stringBuffer.append("int table[TABSIZE];\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test8_5_3s1() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int g(int);\n");
        stringBuffer.append("void f()\n");
        stringBuffer.append("{\n");
        stringBuffer.append("int i;\n");
        stringBuffer.append("int& r = i; // r refers to i\n");
        stringBuffer.append("r = 1; // the value of i becomes 1\n");
        stringBuffer.append("int* p = &r; // p points to i\n");
        stringBuffer.append("int& rr = r; // rr refers to what r refers to, that is, to i\n");
        stringBuffer.append("int (&rg)(int) = g; // rg refers to the function g\n");
        stringBuffer.append("rg(i); //calls function g\n");
        stringBuffer.append("int a[3];\n");
        stringBuffer.append("int (&ra)[3] = a; // ra refers to the array a\n");
        stringBuffer.append("ra[1] = i; // modifies a[1]\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test12s1() throws ParserException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct A { }; // implicitlydeclared A::operator=\n");
        stringBuffer.append("struct B : A {\n");
        stringBuffer.append("B& operator=(const B &);\n");
        stringBuffer.append("};\n");
        stringBuffer.append("B& B::operator=(const B& s) {\n");
        stringBuffer.append("this->A::operator=(s); // wellformed\n");
        stringBuffer.append("return *this;\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test12_7s2() throws ParserException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("struct A { };\n");
        stringBuffer.append("struct B : virtual A { };\n");
        stringBuffer.append("struct C : B { };\n");
        stringBuffer.append("struct D : virtual A { D(A*); };\n");
        stringBuffer.append("struct X { X(A*); };\n");
        stringBuffer.append("struct E : C, D, X {\n");
        stringBuffer.append("E() : D(this), // undefined: upcast from E* to A*\n");
        stringBuffer.append("// might use path E* \ufffd D* \ufffd A*\n");
        stringBuffer.append("// but D is not constructed\n");
        stringBuffer.append("// D((C*)this), // defined:\n");
        stringBuffer.append("// E* \ufffd C* defined because E() has started\n");
        stringBuffer.append("// and C* \ufffd A* defined because\n");
        stringBuffer.append("// C fully constructed\n");
        stringBuffer.append("X(this) //defined: upon construction of X,\n");
        stringBuffer.append("// C/B/D/A sublattice is fully constructed\n");
        stringBuffer.append("{ }\n");
        stringBuffer.append("};\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test3_3_6s5() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("typedef int c;\n");
        stringBuffer.append("enum { i = 1 };\n");
        stringBuffer.append("class X {\n");
        stringBuffer.append("int i=3;\n");
        stringBuffer.append("char v[i];\n");
        stringBuffer.append("int f() { return sizeof(c); } // OK: X::c\n");
        stringBuffer.append("char c;\n");
        stringBuffer.append("enum { i = 2 };\n");
        stringBuffer.append("};\n");
        stringBuffer.append("typedef char* T;\n");
        stringBuffer.append("struct Y {\n");
        stringBuffer.append("typedef long T;\n");
        stringBuffer.append("T b;\n");
        stringBuffer.append("};\n");
        stringBuffer.append("typedef int I;\n");
        stringBuffer.append("class D {\n");
        stringBuffer.append("typedef I I; // error, even though no reordering involved\n");
        stringBuffer.append("};\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test13_4s5a() throws ParserException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int f(double);\n");
        stringBuffer.append("int f(int);\n");
        stringBuffer.append("int (*pfd)(double) = &f; // selects f(double)\n");
        stringBuffer.append("int (*pfi)(int) = &f; // selects f(int)\n");
        stringBuffer.append("int (*pfe)(...) = &f; // error: type mismatch\n");
        stringBuffer.append("int (&rfi)(int) = f; // selects f(int)\n");
        stringBuffer.append("int (&rfd)(double) = f; // selects f(double)\n");
        stringBuffer.append("void g() {\n");
        stringBuffer.append("(int (*)(int))&f; // cast expression as selector\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, false, 0);
    }

    public void test11_3s2() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class A {\n");
        stringBuffer.append("public:\n");
        stringBuffer.append("int z;\n");
        stringBuffer.append("int z1;\n");
        stringBuffer.append("};\n");
        stringBuffer.append("class B : public A {\n");
        stringBuffer.append("int a;\n");
        stringBuffer.append("public:\n");
        stringBuffer.append("int b, c;\n");
        stringBuffer.append("int bf();\n");
        stringBuffer.append("protected:\n");
        stringBuffer.append("int x;\n");
        stringBuffer.append("int y;\n");
        stringBuffer.append("};\n");
        stringBuffer.append("class D : private B {\n");
        stringBuffer.append("int d;\n");
        stringBuffer.append("public:\n");
        stringBuffer.append("B::c; //adjust access to B::c\n");
        stringBuffer.append("B::z; //adjust access to A::z\n");
        stringBuffer.append("A::z1; //adjust access to A::z1\n");
        stringBuffer.append("int e;\n");
        stringBuffer.append("int df();\n");
        stringBuffer.append("protected:\n");
        stringBuffer.append("B::x; //adjust access to B::x\n");
        stringBuffer.append("int g;\n");
        stringBuffer.append("};\n");
        stringBuffer.append("class X : public D {\n");
        stringBuffer.append("int xf();\n");
        stringBuffer.append("};\n");
        stringBuffer.append("int ef(D&);\n");
        stringBuffer.append("int ff(X&);\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test8_5s2() throws ParserException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int z() { ");
        stringBuffer.append("int f(int);\n");
        stringBuffer.append("int a = 2;\n");
        stringBuffer.append("int b = f(a);\n");
        stringBuffer.append("int c(b);\n");
        stringBuffer.append("}");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }

    public void test8_2s3() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("// #include <cstddef>\n");
        stringBuffer.append("char *p;\n");
        stringBuffer.append("void *operator new(size_t, int);\n");
        stringBuffer.append("void foo() {\n");
        stringBuffer.append("const int x = 63;\n");
        stringBuffer.append("new (int(*p)) int; // newplacement expression\n");
        stringBuffer.append("new (int(*[x])); // new typeid\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, false, 0);
    }

    public void test14_3s2() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("template<class T> void f();\n");
        stringBuffer.append("template<int I> void f();\n");
        stringBuffer.append("void g()\n");
        stringBuffer.append("{\n");
        stringBuffer.append("f<int()>(); // int() is a typeid:call the first f()\n");
        stringBuffer.append("}\n");
        this.parse(stringBuffer.toString(), ParserLanguage.CPP, true, 0);
    }
}

