/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser.tests.ast2;

import junit.framework.Assert;
import org.eclipse.cdt.core.dom.ast.ASTSignatureUtil;
import org.eclipse.cdt.core.dom.ast.IASTCastExpression;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTInitializerExpression;
import org.eclipse.cdt.core.dom.ast.IASTReturnStatement;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IASTTypeIdExpression;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.tests.ast2.AST2BaseTest;

public class AST2UtilTests
extends AST2BaseTest {
    public void testSimpleSignature() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int l, m, n=0;\n");
        stringBuffer.append("int j = l ? m : n;\n");
        stringBuffer.append("int i = l^m;\n");
        stringBuffer.append("int g = i<<=j;\n");
        stringBuffer.append("int f = sizeof( int );\n");
        stringBuffer.append("int e = ~f;\n");
        stringBuffer.append("int d = ++e;\n");
        stringBuffer.append("int b = d++;\n");
        stringBuffer.append("int c = sizeof b;\n");
        stringBuffer.append("int a = b + c;\n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.C);
        IASTDeclaration[] iASTDeclarationArray = iASTTranslationUnit.getDeclarations();
        this.isExpressionStringEqual(((IASTInitializerExpression)((IASTSimpleDeclaration)iASTDeclarationArray[0]).getDeclarators()[2].getInitializer()).getExpression(), "0");
        this.isExpressionStringEqual(((IASTInitializerExpression)((IASTSimpleDeclaration)iASTDeclarationArray[1]).getDeclarators()[0].getInitializer()).getExpression(), "l ? m : n");
        this.isExpressionStringEqual(((IASTInitializerExpression)((IASTSimpleDeclaration)iASTDeclarationArray[2]).getDeclarators()[0].getInitializer()).getExpression(), "l ^ m");
        this.isExpressionStringEqual(((IASTInitializerExpression)((IASTSimpleDeclaration)iASTDeclarationArray[3]).getDeclarators()[0].getInitializer()).getExpression(), "i <<= j");
        this.isExpressionStringEqual(((IASTInitializerExpression)((IASTSimpleDeclaration)iASTDeclarationArray[4]).getDeclarators()[0].getInitializer()).getExpression(), "sizeof (int)");
        this.isExpressionStringEqual(((IASTInitializerExpression)((IASTSimpleDeclaration)iASTDeclarationArray[5]).getDeclarators()[0].getInitializer()).getExpression(), "~f");
        this.isExpressionStringEqual(((IASTInitializerExpression)((IASTSimpleDeclaration)iASTDeclarationArray[6]).getDeclarators()[0].getInitializer()).getExpression(), "++e");
        this.isExpressionStringEqual(((IASTInitializerExpression)((IASTSimpleDeclaration)iASTDeclarationArray[7]).getDeclarators()[0].getInitializer()).getExpression(), "d++");
        this.isExpressionStringEqual(((IASTInitializerExpression)((IASTSimpleDeclaration)iASTDeclarationArray[8]).getDeclarators()[0].getInitializer()).getExpression(), "sizeof b");
        this.isExpressionStringEqual(((IASTInitializerExpression)((IASTSimpleDeclaration)iASTDeclarationArray[9]).getDeclarators()[0].getInitializer()).getExpression(), "b + c");
    }

    public void testSimpleParameter() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int a(int x);\n");
        stringBuffer.append("int * b(char y, int x);\n");
        stringBuffer.append("void c(int * z, float **b);\n");
        stringBuffer.append("static int d(int a[restrict]);\n");
        stringBuffer.append("void e(const char* const);\n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.C);
        IASTDeclaration[] iASTDeclarationArray = iASTTranslationUnit.getDeclarations();
        this.isParameterSignatureEqual(((IASTSimpleDeclaration)iASTDeclarationArray[0]).getDeclarators()[0], "(int)");
        this.isParameterSignatureEqual(((IASTSimpleDeclaration)iASTDeclarationArray[1]).getDeclarators()[0], "(char, int)");
        this.isParameterSignatureEqual(((IASTSimpleDeclaration)iASTDeclarationArray[2]).getDeclarators()[0], "(int *, float * *)");
        this.isParameterSignatureEqual(((IASTSimpleDeclaration)iASTDeclarationArray[3]).getDeclarators()[0], "(int [restrict])");
        this.isParameterSignatureEqual(((IASTSimpleDeclaration)iASTDeclarationArray[4]).getDeclarators()[0], "(const char * const)");
        this.isSignatureEqual(((IASTSimpleDeclaration)iASTDeclarationArray[0]).getDeclarators()[0], "int (int)");
        this.isSignatureEqual(((IASTSimpleDeclaration)iASTDeclarationArray[1]).getDeclarators()[0], "int *(char, int)");
        this.isSignatureEqual(((IASTSimpleDeclaration)iASTDeclarationArray[2]).getDeclarators()[0], "void (int *, float * *)");
        this.isSignatureEqual(((IASTSimpleDeclaration)iASTDeclarationArray[3]).getDeclarators()[0], "static int (int [restrict])");
        this.isSignatureEqual(((IASTSimpleDeclaration)iASTDeclarationArray[4]).getDeclarators()[0], "void (const char * const)");
        this.isSignatureEqual(((IASTSimpleDeclaration)iASTDeclarationArray[0]).getDeclSpecifier(), "int");
        this.isSignatureEqual(((IASTSimpleDeclaration)iASTDeclarationArray[1]).getDeclSpecifier(), "int");
        this.isSignatureEqual(((IASTSimpleDeclaration)iASTDeclarationArray[2]).getDeclSpecifier(), "void");
        this.isSignatureEqual(((IASTSimpleDeclaration)iASTDeclarationArray[3]).getDeclSpecifier(), "static int");
        this.isSignatureEqual(((IASTSimpleDeclaration)iASTDeclarationArray[4]).getDeclSpecifier(), "void");
        this.isTypeEqual(((IASTSimpleDeclaration)iASTDeclarationArray[0]).getDeclarators()[0], "int (int)");
        this.isTypeEqual(((IASTSimpleDeclaration)iASTDeclarationArray[1]).getDeclarators()[0], "int * (char, int)");
        this.isTypeEqual(((IASTSimpleDeclaration)iASTDeclarationArray[2]).getDeclarators()[0], "void (int *, float * *)");
        this.isTypeEqual(((IASTSimpleDeclaration)iASTDeclarationArray[3]).getDeclarators()[0], "int (int * restrict)");
        this.isTypeEqual(((IASTSimpleDeclaration)iASTDeclarationArray[4]).getDeclarators()[0], "void (const char * const)");
        this.isTypeEqual((IType)((IFunction)((IASTSimpleDeclaration)iASTDeclarationArray[0]).getDeclarators()[0].getName().resolveBinding()).getType(), "int (int)");
        this.isTypeEqual((IType)((IFunction)((IASTSimpleDeclaration)iASTDeclarationArray[1]).getDeclarators()[0].getName().resolveBinding()).getType(), "int * (char, int)");
        this.isTypeEqual((IType)((IFunction)((IASTSimpleDeclaration)iASTDeclarationArray[2]).getDeclarators()[0].getName().resolveBinding()).getType(), "void (int *, float * *)");
        this.isTypeEqual((IType)((IFunction)((IASTSimpleDeclaration)iASTDeclarationArray[3]).getDeclarators()[0].getName().resolveBinding()).getType(), "int (int * restrict)");
        this.isTypeEqual((IType)((IFunction)((IASTSimpleDeclaration)iASTDeclarationArray[4]).getDeclarators()[0].getName().resolveBinding()).getType(), "void (const char * const)");
        this.isParameterTypeEqual(((IFunction)((IASTSimpleDeclaration)iASTDeclarationArray[0]).getDeclarators()[0].getName().resolveBinding()).getType(), "(int)");
        this.isParameterTypeEqual(((IFunction)((IASTSimpleDeclaration)iASTDeclarationArray[1]).getDeclarators()[0].getName().resolveBinding()).getType(), "(char, int)");
        this.isParameterTypeEqual(((IFunction)((IASTSimpleDeclaration)iASTDeclarationArray[2]).getDeclarators()[0].getName().resolveBinding()).getType(), "(int *, float * *)");
        this.isParameterTypeEqual(((IFunction)((IASTSimpleDeclaration)iASTDeclarationArray[3]).getDeclarators()[0].getName().resolveBinding()).getType(), "(int * restrict)");
        this.isParameterTypeEqual(((IFunction)((IASTSimpleDeclaration)iASTDeclarationArray[4]).getDeclarators()[0].getName().resolveBinding()).getType(), "(const char * const)");
    }

    public void testSimpleCParameterSignature() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int a(int x);\n");
        stringBuffer.append("int * b(char y, int x);\n");
        stringBuffer.append("void c(int * z, float **b);\n");
        stringBuffer.append("static int d(int a[restrict]);\n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.C);
        IASTDeclaration[] iASTDeclarationArray = iASTTranslationUnit.getDeclarations();
        this.isParameterSignatureEqual(((IASTSimpleDeclaration)iASTDeclarationArray[0]).getDeclarators()[0], "(int)");
        this.isParameterSignatureEqual(((IASTSimpleDeclaration)iASTDeclarationArray[1]).getDeclarators()[0], "(char, int)");
        this.isParameterSignatureEqual(((IASTSimpleDeclaration)iASTDeclarationArray[2]).getDeclarators()[0], "(int *, float * *)");
        this.isParameterSignatureEqual(((IASTSimpleDeclaration)iASTDeclarationArray[3]).getDeclarators()[0], "(int [restrict])");
    }

    public void testSimpleTypeId() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int x = sizeof( int );\n");
        stringBuffer.append("union Squaw { int x; double u; };\n");
        stringBuffer.append("int main(int argc, char **argv) {\n");
        stringBuffer.append("return sizeof( union Squaw );\n}\n");
        stringBuffer.append("typedef short Z; typedef Z jc;\n");
        stringBuffer.append("int y = 4;\n");
        stringBuffer.append("jc myJc = (jc)y;\n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.C);
        IASTDeclaration[] iASTDeclarationArray = iASTTranslationUnit.getDeclarations();
        this.isSignatureEqual(((IASTTypeIdExpression)((IASTInitializerExpression)((IASTSimpleDeclaration)iASTDeclarationArray[0]).getDeclarators()[0].getInitializer()).getExpression()).getTypeId(), "int");
        this.isSignatureEqual(((IASTTypeIdExpression)((IASTReturnStatement)((IASTCompoundStatement)((IASTFunctionDefinition)iASTDeclarationArray[2]).getBody()).getStatements()[0]).getReturnValue()).getTypeId(), "Squaw");
        this.isSignatureEqual(((IASTCastExpression)((IASTInitializerExpression)((IASTSimpleDeclaration)iASTDeclarationArray[6]).getDeclarators()[0].getInitializer()).getExpression()).getTypeId(), "jc");
        this.isTypeEqual(((IASTTypeIdExpression)((IASTInitializerExpression)((IASTSimpleDeclaration)iASTDeclarationArray[0]).getDeclarators()[0].getInitializer()).getExpression()).getTypeId(), "int");
        this.isTypeEqual(((IASTTypeIdExpression)((IASTReturnStatement)((IASTCompoundStatement)((IASTFunctionDefinition)iASTDeclarationArray[2]).getBody()).getStatements()[0]).getReturnValue()).getTypeId(), "Squaw");
        this.isTypeEqual(((IASTCastExpression)((IASTInitializerExpression)((IASTSimpleDeclaration)iASTDeclarationArray[6]).getDeclarators()[0].getInitializer()).getExpression()).getTypeId(), "short int");
    }

    public void testKnRC() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("int foo(x, y) char x; int y; {}\n");
        stringBuffer.append("int foo2(char x, int y) {}\n");
        IASTTranslationUnit iASTTranslationUnit = this.parse(stringBuffer.toString(), ParserLanguage.C, true);
        IASTDeclaration[] iASTDeclarationArray = iASTTranslationUnit.getDeclarations();
        String string = ASTSignatureUtil.getSignature((IASTDeclarator)((IASTFunctionDefinition)iASTDeclarationArray[0]).getDeclarator());
        String string2 = ASTSignatureUtil.getSignature((IASTDeclarator)((IASTFunctionDefinition)iASTDeclarationArray[1]).getDeclarator());
        Assert.assertEquals((String)string, (String)string2);
    }
}

