/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser.tests.scanner2;

import java.util.List;
import junit.framework.Assert;
import junit.framework.ComparisonFailure;
import junit.framework.TestCase;
import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.EndOfFileException;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.core.parser.IScanner;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.IToken;
import org.eclipse.cdt.core.parser.NullSourceElementRequestor;
import org.eclipse.cdt.core.parser.ParserFactory;
import org.eclipse.cdt.core.parser.ParserFactoryError;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.ParserMode;
import org.eclipse.cdt.core.parser.ScannerInfo;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.parser.scanner2.GCCScannerExtensionConfiguration;
import org.eclipse.cdt.internal.core.parser.scanner2.GPPScannerExtensionConfiguration;
import org.eclipse.cdt.internal.core.parser.scanner2.IScannerExtensionConfiguration;
import org.eclipse.cdt.internal.core.parser.scanner2.ObjectStyleMacro;
import org.eclipse.cdt.internal.core.parser.scanner2.Scanner2;

public class BaseScanner2Test
extends TestCase {
    protected IScanner scanner;
    public static final String EXCEPTION_THROWN = "Exception thrown ";
    public static final String EXPECTED_FAILURE = "This statement should not be reached as we sent in bad preprocessor input to the scanner";
    public static final boolean verbose = false;

    public BaseScanner2Test(String string) {
        super(string);
    }

    protected void initializeScanner(String string, ParserMode parserMode) throws ParserFactoryError {
        this.initializeScanner(string, parserMode, (ISourceElementRequestor)new NullSourceElementRequestor(parserMode));
    }

    protected void initializeScanner(String string, ParserMode parserMode, ISourceElementRequestor iSourceElementRequestor) throws ParserFactoryError {
        this.scanner = BaseScanner2Test.createScanner(new CodeReader(string.toCharArray()), (IScannerInfo)new ScannerInfo(), parserMode, ParserLanguage.CPP, iSourceElementRequestor, null, null);
    }

    protected void initializeScanner(String string, ParserLanguage parserLanguage) throws ParserFactoryError {
        this.scanner = BaseScanner2Test.createScanner(new CodeReader(string.toCharArray()), (IScannerInfo)new ScannerInfo(), ParserMode.COMPLETE_PARSE, parserLanguage, (ISourceElementRequestor)new NullSourceElementRequestor(ParserMode.COMPLETE_PARSE), null, null);
    }

    protected void initializeScanner(String string) throws ParserFactoryError {
        this.initializeScanner(string, ParserMode.COMPLETE_PARSE);
    }

    public static Scanner2 createScanner(CodeReader codeReader, IScannerInfo iScannerInfo, ParserMode parserMode, ParserLanguage parserLanguage, ISourceElementRequestor iSourceElementRequestor, IParserLogService iParserLogService, List list) throws ParserFactoryError {
        if (iScannerInfo == null) {
            throw new ParserFactoryError(ParserFactoryError.Kind.NULL_CONFIG);
        }
        if (parserLanguage == null) {
            throw new ParserFactoryError(ParserFactoryError.Kind.NULL_LANGUAGE);
        }
        IParserLogService iParserLogService2 = iParserLogService == null ? ParserFactory.createDefaultLogService() : iParserLogService;
        ParserMode parserMode2 = parserMode == null ? ParserMode.COMPLETE_PARSE : parserMode;
        ISourceElementRequestor iSourceElementRequestor2 = iSourceElementRequestor == null ? new NullSourceElementRequestor() : iSourceElementRequestor;
        Object object = null;
        object = parserLanguage == ParserLanguage.C ? new GCCScannerExtensionConfiguration() : new GPPScannerExtensionConfiguration();
        return new Scanner2(codeReader, iScannerInfo, iSourceElementRequestor2, parserMode2, parserLanguage, iParserLogService2, list, (IScannerExtensionConfiguration)object);
    }

    public int fullyTokenize() throws Exception {
        try {
            IToken iToken = this.scanner.nextToken();
            while (iToken != null) {
                if (iToken.getType() > 141) {
                    System.out.println("Unknown type for token " + iToken);
                }
                iToken = this.scanner.nextToken();
            }
        }
        catch (EndOfFileException endOfFileException) {}
        return this.scanner.getCount();
    }

    public void validateIdentifier(String string) throws Exception {
        try {
            IToken iToken = this.scanner.nextToken();
            Assert.assertEquals((int)iToken.getType(), (int)1);
            Assert.assertEquals((String)iToken.getImage(), (String)string);
        }
        catch (EndOfFileException endOfFileException) {
            Assert.assertTrue((boolean)false);
        }
    }

    public void validateInteger(String string) throws Exception {
        try {
            IToken iToken = this.scanner.nextToken();
            Assert.assertTrue((iToken.getType() == 2 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)iToken.getImage().equals(string));
        }
        catch (EndOfFileException endOfFileException) {
            Assert.assertTrue((boolean)false);
        }
    }

    public void validateFloatingPointLiteral(String string) throws Exception {
        try {
            IToken iToken = this.scanner.nextToken();
            Assert.assertTrue((iToken.getType() == 129 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)iToken.getImage().equals(string));
        }
        catch (EndOfFileException endOfFileException) {
            Assert.assertTrue((boolean)false);
        }
    }

    public void validateChar(char c) throws Exception {
        try {
            IToken iToken = this.scanner.nextToken();
            Assert.assertTrue((iToken.getType() == 132 ? 1 : 0) != 0);
            Character c2 = new Character(c);
            Assert.assertEquals((String)iToken.getImage(), (String)(String.valueOf('\'') + c2.toString() + '\''));
        }
        catch (EndOfFileException endOfFileException) {
            Assert.assertTrue((boolean)false);
        }
    }

    public void validateChar(String string) throws Exception {
        try {
            IToken iToken = this.scanner.nextToken();
            Assert.assertTrue((iToken.getType() == 132 ? 1 : 0) != 0);
            Assert.assertEquals((String)iToken.getImage(), (String)(String.valueOf('\'') + string + '\''));
        }
        catch (EndOfFileException endOfFileException) {
            Assert.assertTrue((boolean)false);
        }
    }

    public void validateString(String string) throws Exception {
        this.validateString(string, false);
    }

    public void validateString(String string, boolean bl) throws Exception {
        try {
            IToken iToken = this.scanner.nextToken();
            if (bl) {
                Assert.assertEquals((int)131, (int)iToken.getType());
            } else {
                Assert.assertEquals((int)130, (int)iToken.getType());
            }
            Assert.assertEquals((String)string, (String)iToken.getImage());
        }
        catch (EndOfFileException endOfFileException) {
            Assert.fail((String)"EOF received");
        }
    }

    public void validateToken(int n) throws Exception {
        try {
            IToken iToken = this.scanner.nextToken();
            Assert.assertEquals((int)n, (int)iToken.getType());
        }
        catch (EndOfFileException endOfFileException) {
            Assert.assertTrue((boolean)false);
        }
    }

    public void validateBalance(int n) {
    }

    public void validateEOF() throws Exception {
        try {
            Assert.assertNull((Object)this.scanner.nextToken());
        }
        catch (EndOfFileException endOfFileException) {}
    }

    public static void assertCharArrayEquals(char[] cArray, char[] cArray2) {
        if (!CharArrayUtils.equals((char[])cArray, (char[])cArray2)) {
            throw new ComparisonFailure(null, new String(cArray), new String(cArray2));
        }
    }

    public void validateDefinition(String string, String string2) {
        Object object = this.scanner.getRealDefinitions().get(string.toCharArray());
        Assert.assertNotNull((Object)object);
        Assert.assertTrue((boolean)(object instanceof ObjectStyleMacro));
        BaseScanner2Test.assertCharArrayEquals(string2.toCharArray(), ((ObjectStyleMacro)object).expansion);
    }

    public void validateDefinition(String string, int n) {
        this.validateDefinition(string, String.valueOf(n));
    }

    public void validateAsUndefined(String string) {
        Assert.assertNull(this.scanner.getDefinitions().get(string.toCharArray()));
    }

    protected void validateWideChar(String string) throws Exception {
        try {
            IToken iToken = this.scanner.nextToken();
            Assert.assertEquals((int)133, (int)iToken.getType());
            Assert.assertEquals((String)iToken.getImage(), (String)("L'" + string + "'"));
        }
        catch (EndOfFileException endOfFileException) {
            Assert.assertTrue((boolean)false);
        }
    }
}

