/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser.tests.scanner2;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.core.parser.util.ObjectMap;

public class ObjectMapTest
extends TestCase {
    public void insertContents(ObjectMap objectMap, Object[][] objectArray) throws Exception {
        int n = 0;
        while (n < objectArray.length) {
            objectMap.put(objectArray[n][0], objectArray[n][1]);
            ++n;
        }
    }

    public void assertContents(ObjectMap objectMap, Object[][] objectArray) throws Exception {
        int n = 0;
        while (n < objectArray.length) {
            Assert.assertEquals((Object)objectMap.keyAt(n), (Object)objectArray[n][0]);
            Assert.assertEquals((Object)objectMap.getAt(n), (Object)objectArray[n][1]);
            Assert.assertEquals((Object)objectMap.get(objectArray[n][0]), (Object)objectArray[n][1]);
            ++n;
        }
        Assert.assertEquals((int)objectMap.size(), (int)objectArray.length);
    }

    public void testSimpleAdd() throws Exception {
        ObjectMap objectMap = new ObjectMap(2);
        Object[][] objectArray = new Object[][]{{"1", "ob"}};
        this.insertContents(objectMap, objectArray);
        this.assertContents(objectMap, objectArray);
        Assert.assertEquals((int)objectMap.size(), (int)1);
        Assert.assertEquals((int)objectMap.capacity(), (int)2);
    }

    public void testSimpleCollision() throws Exception {
        ObjectMap objectMap = new ObjectMap(2);
        HashObject hashObject = new HashObject(1);
        HashObject hashObject2 = new HashObject(1);
        Object[][] objectArray = new Object[][]{{hashObject, "1"}, {hashObject2, "2"}};
        this.insertContents(objectMap, objectArray);
        Assert.assertEquals((int)objectMap.size(), (int)2);
        Assert.assertEquals((int)objectMap.capacity(), (int)2);
        this.assertContents(objectMap, objectArray);
    }

    public void testResize() throws Exception {
        ObjectMap objectMap = new ObjectMap(1);
        Assert.assertEquals((int)objectMap.size(), (int)0);
        Assert.assertEquals((int)objectMap.capacity(), (int)2);
        Object[][] objectArray = new Object[][]{{"0", "o0"}, {"1", "o1"}, {"2", "o2"}, {"3", "o3"}, {"4", "o4"}};
        this.insertContents(objectMap, objectArray);
        Assert.assertEquals((int)objectMap.capacity(), (int)8);
        this.assertContents(objectMap, objectArray);
    }

    public void testCollisionResize() throws Exception {
        ObjectMap objectMap = new ObjectMap(1);
        Assert.assertEquals((int)objectMap.size(), (int)0);
        Assert.assertEquals((int)objectMap.capacity(), (int)2);
        Object[][] objectArray = new Object[][]{{new HashObject(0), "o0"}, {new HashObject(1), "o1"}, {new HashObject(0), "o2"}, {new HashObject(1), "o3"}, {new HashObject(0), "o4"}};
        this.insertContents(objectMap, objectArray);
        Assert.assertEquals((int)objectMap.capacity(), (int)8);
        this.assertContents(objectMap, objectArray);
    }

    public void testReAdd() throws Exception {
        ObjectMap objectMap = new ObjectMap(1);
        Assert.assertEquals((int)objectMap.size(), (int)0);
        Assert.assertEquals((int)objectMap.capacity(), (int)2);
        Object[][] objectArray = new Object[][]{{"0", "o0"}, {"1", "o1"}};
        this.insertContents(objectMap, objectArray);
        Assert.assertEquals((int)objectMap.capacity(), (int)2);
        this.assertContents(objectMap, objectArray);
        objectArray = new Object[][]{{"0", "o00"}, {"1", "o01"}, {"10", "o10"}, {"11", "o11"}};
        this.insertContents(objectMap, objectArray);
        this.assertContents(objectMap, objectArray);
    }

    public void testResizeResolvesCollision() throws Exception {
        ObjectMap objectMap = new ObjectMap(2);
        HashObject hashObject = new HashObject(0);
        HashObject hashObject2 = new HashObject(1);
        HashObject hashObject3 = new HashObject(4);
        Object[][] objectArray = new Object[][]{{hashObject, "1"}, {hashObject2, "2"}, {hashObject3, "3"}};
        this.insertContents(objectMap, objectArray);
        this.assertContents(objectMap, objectArray);
    }

    public void testCharArrayUtils() throws Exception {
        char[] cArray = "A::B::C".toCharArray();
        Assert.assertEquals((int)CharArrayUtils.lastIndexOf((char[])"::".toCharArray(), (char[])cArray), (int)4);
        Assert.assertTrue((boolean)CharArrayUtils.equals((char[])CharArrayUtils.lastSegment((char[])cArray, (char[])"::".toCharArray()), (char[])"C".toCharArray()));
        cArray = "A::B::C:foo".toCharArray();
        Assert.assertEquals((int)CharArrayUtils.lastIndexOf((char[])"::".toCharArray(), (char[])cArray), (int)4);
        Assert.assertTrue((boolean)CharArrayUtils.equals((char[])CharArrayUtils.lastSegment((char[])cArray, (char[])"::".toCharArray()), (char[])"C:foo".toCharArray()));
    }

    public static class HashObject {
        public final int hash;

        HashObject(int n) {
            this.hash = n;
        }

        public int hashCode() {
            return this.hash;
        }
    }
}

