/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.suite;

import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.eclipse.cdt.core.testplugin.CTestPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;

public class ProjectCreator
extends TestCase {
    private static final byte[] buffer = new byte[512];
    private static final IProgressMonitor monitor = new NullProgressMonitor();

    public static IProject createProject(IPath iPath, String string) throws Exception {
        Object object;
        ZipFile zipFile = new ZipFile(CTestPlugin.getDefault().getFileInPlugin(iPath));
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot iWorkspaceRoot = iWorkspace.getRoot();
        IPath iPath2 = iWorkspaceRoot.getLocation();
        String string2 = null;
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            if (((ZipEntry)object).isDirectory()) continue;
            IPath iPath3 = iPath2.append(((ZipEntry)object).getName());
            IPath iPath4 = iPath3.removeLastSegments(1);
            iPath4.toFile().mkdirs();
            InputStream inputStream = zipFile.getInputStream((ZipEntry)object);
            FileOutputStream fileOutputStream = new FileOutputStream(iPath3.toFile());
            int n = inputStream.read(buffer);
            while (n >= 0) {
                ((OutputStream)fileOutputStream).write(buffer, 0, n);
                n = inputStream.read(buffer);
            }
            inputStream.close();
            ((OutputStream)fileOutputStream).close();
            if (!".project".equals(iPath3.lastSegment())) continue;
            IProjectDescription iProjectDescription = iWorkspace.loadProjectDescription(iPath3);
            string2 = iProjectDescription.getName();
        }
        object = iWorkspaceRoot.getProject(string2);
        object.create(monitor);
        object.open(monitor);
        object.move((IPath)new Path(string), true, monitor);
        return object;
    }

    public static IProject createCManagedProject(String string) throws Exception {
        return ProjectCreator.createProject((IPath)new Path("resources/zips/CManaged.zip"), string);
    }

    public static IProject createCPPManagedProject(String string) throws Exception {
        return ProjectCreator.createProject((IPath)new Path("resources/zips/CPPManaged.zip"), string);
    }

    public static IProject createCStandardProject(String string) throws Exception {
        return ProjectCreator.createProject((IPath)new Path("resources/zips/CStandard.zip"), string);
    }

    public static IProject createCPPStandardProject(String string) throws Exception {
        return ProjectCreator.createProject((IPath)new Path("resources/zips/CPPStandard.zip"), string);
    }

    public void test() throws Exception {
        IProject iProject = ProjectCreator.createCPPManagedProject("TestProject");
        Assert.assertNotNull((Object)iProject);
    }
}

