/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.tests.DOMAST;

import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNodeLocation;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIncludeStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.util.ExternalEditorInput;
import org.eclipse.cdt.ui.testplugin.CTestPlugin;
import org.eclipse.cdt.ui.tests.DOMAST.DOMAST;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionDelegate;

public class ShowInDOMViewAction
extends ActionDelegate
implements IEditorActionDelegate {
    private static final String FIND_NODE_IN_AST_DOM_VIEW = "Find Node in AST DOM View";
    CEditor editor = null;
    IASTTranslationUnit tu = null;
    IViewPart view = null;
    String file = null;

    public void setActiveEditor(IAction iAction, IEditorPart iEditorPart) {
        if (iEditorPart instanceof CEditor) {
            this.editor = (CEditor)iEditorPart;
        }
    }

    public void runWithEvent(IAction iAction, Event event) {
        TextSelection textSelection = null;
        if (this.editor != null && this.editor.getSelectionProvider().getSelection() instanceof TextSelection) {
            textSelection = (TextSelection)this.editor.getSelectionProvider().getSelection();
        }
        if (textSelection != null) {
            if (!this.isFileInView()) {
                this.view = DOMAST.openDOMASTViewRunAction((IEditorPart)this.editor, new FindDisplayNode(textSelection.getOffset(), textSelection.getLength()), FIND_NODE_IN_AST_DOM_VIEW);
            } else {
                new FindDisplayNode(textSelection.getOffset(), textSelection.getLength()).run();
            }
        }
    }

    protected void showMessage(String string) {
        MessageDialog.openInformation((Shell)CTestPlugin.getStandardDisplay().getActiveShell(), (String)"DOM View", (String)string);
    }

    private boolean isFileInView() {
        IContentProvider iContentProvider;
        if (this.editor.getInputFile() != null) {
            this.file = this.editor.getInputFile().getLocation().toOSString();
        } else if (this.editor.getEditorInput() instanceof ExternalEditorInput) {
            this.file = ((ExternalEditorInput)this.editor.getEditorInput()).getStorage().getFullPath().toOSString();
        }
        if (this.file == null) {
            return false;
        }
        try {
            this.view = this.editor.getSite().getPage().showView("org.eclipse.cdt.ui.tests.DOMAST.DOMAST");
        }
        catch (PartInitException partInitException) {}
        if (this.view instanceof DOMAST && (iContentProvider = ((DOMAST)this.view).getContentProvider()) != null && iContentProvider instanceof DOMAST.ViewContentProvider) {
            this.tu = ((DOMAST.ViewContentProvider)iContentProvider).getTU();
            if (this.tu != null) {
                String string = null;
                IASTNodeLocation[] iASTNodeLocationArray = this.tu.getNodeLocations();
                int n = 0;
                while (n < iASTNodeLocationArray.length) {
                    if (iASTNodeLocationArray[n] instanceof IASTFileLocation) {
                        string = ((IASTFileLocation)iASTNodeLocationArray[n]).getFileName();
                    }
                    ++n;
                }
                if (string != null && string.equals(this.file)) {
                    return true;
                }
                IASTPreprocessorIncludeStatement[] iASTPreprocessorIncludeStatementArray = this.tu.getIncludeDirectives();
                int n2 = 0;
                while (n2 < iASTPreprocessorIncludeStatementArray.length) {
                    if (iASTPreprocessorIncludeStatementArray[n2].getPath().equals(this.file)) {
                        return true;
                    }
                    ++n2;
                }
            }
        }
        return false;
    }

    private class FindDisplayNode
    implements Runnable {
        private static final String IAST_NODE_NOT_FOUND = "IASTNode not found for the selection. ";
        private static final String IASTNode_NOT_FOUND = "IASTNode not found for the selection. ";
        int offset = 0;
        int length = 0;

        public FindDisplayNode(int n, int n2) {
            this.offset = n;
            this.length = n2;
        }

        public void run() {
            IContentProvider iContentProvider;
            if (ShowInDOMViewAction.this.view instanceof DOMAST && (iContentProvider = ((DOMAST)ShowInDOMViewAction.this.view).getContentProvider()) != null && iContentProvider instanceof DOMAST.ViewContentProvider) {
                ShowInDOMViewAction.this.tu = ((DOMAST.ViewContentProvider)iContentProvider).getTU();
                if (ShowInDOMViewAction.this.editor.getInputFile() != null) {
                    ShowInDOMViewAction.this.file = ShowInDOMViewAction.this.editor.getInputFile().getLocation().toOSString();
                } else if (ShowInDOMViewAction.this.editor.getEditorInput() instanceof ExternalEditorInput) {
                    ShowInDOMViewAction.this.file = ((ExternalEditorInput)ShowInDOMViewAction.this.editor.getEditorInput()).getStorage().getFullPath().toOSString();
                }
            }
            if (ShowInDOMViewAction.this.tu != null && ShowInDOMViewAction.this.file != null && ShowInDOMViewAction.this.view instanceof DOMAST) {
                iContentProvider = ShowInDOMViewAction.this.tu.selectNodeForLocation(ShowInDOMViewAction.this.file, this.offset, this.length);
                if (iContentProvider != null && ((DOMAST)ShowInDOMViewAction.this.view).getContentProvider() instanceof DOMAST.ViewContentProvider) {
                    boolean bl = ((DOMAST.ViewContentProvider)((DOMAST)ShowInDOMViewAction.this.view).getContentProvider()).findAndSelect((IASTNode)iContentProvider, true);
                    if (!bl) {
                        ShowInDOMViewAction.this.showMessage("IASTNode not found for the selection. ");
                    }
                } else {
                    ShowInDOMViewAction.this.showMessage("IASTNode not found for the selection. ");
                }
            }
        }
    }
}

