/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.tests.IndexerView;

import org.eclipse.cdt.core.browser.PathUtil;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.core.search.BasicSearchMatch;
import org.eclipse.cdt.core.search.IMatch;
import org.eclipse.cdt.core.search.IMatchLocatable;
import org.eclipse.cdt.core.search.LineLocatable;
import org.eclipse.cdt.core.search.OffsetLocatable;
import org.eclipse.cdt.internal.core.index.IEntryResult;
import org.eclipse.cdt.internal.ui.search.CSearchQuery;
import org.eclipse.cdt.internal.ui.search.CSearchResult;
import org.eclipse.cdt.internal.ui.search.NewSearchResultCollector;
import org.eclipse.cdt.ui.testplugin.CTestPlugin;
import org.eclipse.cdt.ui.tests.IndexerView.IndexerNodeLeaf;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;

public class IndexerQuery
extends CSearchQuery
implements ISearchQuery {
    private static final int DEFAULT_MATCH_INFO_SIZE = 4;
    private static final String BLANK_STRING = "";
    private CSearchResult _result;
    private IndexerNodeLeaf leaf = null;
    private String queryLabel = null;
    static /* synthetic */ Class class$0;

    public IndexerQuery(IndexerNodeLeaf indexerNodeLeaf, String string, String string2) {
        super(CTestPlugin.getWorkspace(), string2, false, null, null, null, string);
        this.leaf = indexerNodeLeaf;
        this.queryLabel = string;
    }

    public IStatus run(IProgressMonitor iProgressMonitor) throws OperationCanceledException {
        CSearchResult cSearchResult = (CSearchResult)this.getSearchResult();
        SubProgressMonitor subProgressMonitor = new SubProgressMonitor(iProgressMonitor, 1000);
        NewSearchResultCollector newSearchResultCollector = new NewSearchResultCollector(cSearchResult, (IProgressMonitor)subProgressMonitor);
        newSearchResultCollector.aboutToStart();
        MatchInfo[] matchInfoArray = this.generateMatchInfo();
        int n = 0;
        while (n < matchInfoArray.length) {
            try {
                if (matchInfoArray[n] != null) {
                    Object object = null;
                    IResource iResource = matchInfoArray[n].getResource();
                    IPath iPath = matchInfoArray[n].getPath();
                    object = iResource != null ? iResource : iPath;
                    newSearchResultCollector.acceptMatch(this.createMatch(object, matchInfoArray[n].getOffsetType(), matchInfoArray[n].getStart(), matchInfoArray[n].getEnd(), matchInfoArray[n].getName(), matchInfoArray[n].getPath()));
                }
            }
            catch (CoreException coreException) {}
            ++n;
        }
        subProgressMonitor.done();
        newSearchResultCollector.done();
        return new Status(0, CTestPlugin.getPluginId(), 0, BLANK_STRING, null);
    }

    private MatchInfo[] generateMatchInfo() {
        String[] stringArray = this.leaf.getFileMap();
        IEntryResult iEntryResult = this.leaf.getResult();
        Object[] objectArray = new MatchInfo[4];
        int[] nArray = iEntryResult.getFileReferences();
        int[][] nArray2 = iEntryResult.getOffsets();
        int[][] nArray3 = iEntryResult.getOffsetLengths();
        if (nArray2 != null) {
            int n = 0;
            while (n < nArray2.length) {
                int n2 = 0;
                while (n2 < nArray2[n].length) {
                    String string;
                    MatchInfo matchInfo = new MatchInfo();
                    if (nArray.length > n - 1 && (string = stringArray[nArray[n]]) != null) {
                        Path path = new Path(string);
                        IFile iFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
                        if (iFile != null && iFile.exists()) {
                            matchInfo.setResource((IResource)iFile);
                        } else {
                            matchInfo.setPath(PathUtil.getWorkspaceRelativePath((String)string));
                        }
                    }
                    int n3 = 0;
                    int n4 = 0;
                    int n5 = 0;
                    try {
                        n3 = Integer.valueOf(String.valueOf(nArray2[n][n2]).substring(0, 1));
                        n4 = Integer.valueOf(String.valueOf(nArray2[n][n2]).substring(1));
                        n5 = n4 + nArray3[n][n2];
                    }
                    catch (NumberFormatException numberFormatException) {}
                    matchInfo.setOffsetType(n3);
                    matchInfo.setStart(n4);
                    matchInfo.setEnd(n5);
                    matchInfo.setName(this.leaf.getName());
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.cdt.ui.tests.IndexerView.IndexerQuery$MatchInfo");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    objectArray = (MatchInfo[])ArrayUtil.append((Class)clazz, (Object[])objectArray, (Object)matchInfo);
                    ++n2;
                }
                ++n;
            }
        }
        return objectArray;
    }

    public IMatch createMatch(Object object, int n, int n2, int n3, String string, IPath iPath) {
        BasicSearchMatch basicSearchMatch = new BasicSearchMatch();
        if (object instanceof IResource) {
            basicSearchMatch.setResource((IResource)object);
        } else if (object instanceof IPath) {
            basicSearchMatch.setPath((IPath)object);
        }
        LineLocatable lineLocatable = null;
        if (n == 1) {
            lineLocatable = new LineLocatable(n2, n3);
        } else if (n == 2) {
            lineLocatable = new OffsetLocatable(n2, n3);
        }
        basicSearchMatch.setLocatable((IMatchLocatable)lineLocatable);
        basicSearchMatch.setParentName(BLANK_STRING);
        basicSearchMatch.setReferringElement(iPath);
        basicSearchMatch.setName(string);
        basicSearchMatch.setType(72);
        basicSearchMatch.setVisibility(8192);
        basicSearchMatch.setReturnType(BLANK_STRING);
        return basicSearchMatch;
    }

    public String getLabel() {
        return this.queryLabel;
    }

    public boolean canRerun() {
        return false;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public ISearchResult getSearchResult() {
        if (this._result == null) {
            this._result = new CSearchResult((CSearchQuery)this);
        }
        return this._result;
    }

    private class MatchInfo {
        private IPath path = null;
        private int offsetType = 0;
        private int start = 0;
        private int end = 0;
        private String name = null;
        private IResource resource = null;

        MatchInfo() {
        }

        public IPath getPath() {
            return this.path;
        }

        public void setOffsetType(int n) {
            this.offsetType = n;
        }

        public int getOffsetType() {
            return this.offsetType;
        }

        public void setPath(IPath iPath) {
            this.path = iPath;
        }

        public int getEnd() {
            return this.end;
        }

        public void setEnd(int n) {
            this.end = n;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public int getStart() {
            return this.start;
        }

        public void setStart(int n) {
            this.start = n;
        }

        public IResource getResource() {
            return this.resource;
        }

        public void setResource(IResource iResource) {
            this.resource = iResource;
        }
    }
}

