/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.tests.chelp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import junit.framework.Assert;
import org.eclipse.cdt.internal.ui.CHelpProviderManager;
import org.eclipse.cdt.internal.ui.text.CHelpBookDescriptor;
import org.eclipse.cdt.ui.ICHelpBook;
import org.eclipse.cdt.ui.ICHelpResourceDescriptor;
import org.eclipse.cdt.ui.IFunctionSummary;
import org.eclipse.cdt.ui.IRequiredInclude;
import org.eclipse.cdt.ui.text.ICHelpInvocationContext;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.IHelpResource;

public class CHelpProviderTester {
    private static final String KEY_PROVIDER_ID = "providerID";
    private static final String KEY_REQUESTED_NAME = "requestedName";
    private static final String KEY_BOOK_TITLE = "bookTitle";
    private static final String KEY_BOOK_TYPE = "bookType";
    private Properties fProperties;
    private static CHelpProviderTester fDefaultInstance = null;

    private CHelpProviderTester() {
    }

    public static CHelpProviderTester getDefault() {
        if (fDefaultInstance == null) {
            fDefaultInstance = new CHelpProviderTester();
        }
        return fDefaultInstance;
    }

    private static String generateHelpString(ICHelpBook iCHelpBook, String string, String string2) {
        Properties properties = new Properties();
        properties.setProperty(KEY_PROVIDER_ID, string2);
        properties.setProperty(KEY_REQUESTED_NAME, string);
        properties.setProperty(KEY_BOOK_TITLE, iCHelpBook.getTitle());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            properties.store(byteArrayOutputStream, null);
        }
        catch (Exception exception) {}
        return byteArrayOutputStream.toString();
    }

    private static String generateBookTitle(String string, int n) {
        Properties properties = new Properties();
        properties.setProperty(KEY_PROVIDER_ID, string);
        properties.setProperty(KEY_BOOK_TYPE, String.valueOf(n));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            properties.store(byteArrayOutputStream, null);
        }
        catch (Exception exception) {}
        return byteArrayOutputStream.toString();
    }

    private CHelpProviderTester(String string) throws IOException {
        this.fProperties = new Properties();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        this.fProperties.load(byteArrayInputStream);
    }

    private String getValueByKey(String string) {
        String string2 = this.fProperties.getProperty(string);
        if (string2 == null) {
            string2 = new String();
        }
        return string2;
    }

    private String getHelpProviderID() {
        return this.getValueByKey(KEY_PROVIDER_ID);
    }

    private String getRequestedName() {
        return this.getValueByKey(KEY_REQUESTED_NAME);
    }

    private String getBookTitle() {
        return this.getValueByKey(KEY_BOOK_TITLE);
    }

    public boolean onlyTestInfoProvidersAvailable() {
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.cdt.ui", "CHelpProvider");
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            String string = iConfigurationElementArray[n].getAttribute("id");
            if (!string.startsWith("org.eclipse.cdt.ui.tests.chelp.extension")) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public ICHelpResourceDescriptor[] generateHelpResources(ICHelpBook[] iCHelpBookArray, String string, String string2) {
        ICHelpResourceDescriptor[] iCHelpResourceDescriptorArray = new ICHelpResourceDescriptor[iCHelpBookArray.length];
        int n = 0;
        while (n < iCHelpBookArray.length) {
            iCHelpResourceDescriptorArray[n] = new CHelpResourceDescriptor(iCHelpBookArray[n], string, string2);
            ++n;
        }
        return iCHelpResourceDescriptorArray;
    }

    public IFunctionSummary generateFunctionInfo(ICHelpBook[] iCHelpBookArray, String string, String string2) {
        if (iCHelpBookArray.length == 0) {
            return null;
        }
        return new FunctionSummary(iCHelpBookArray[0], string, string2);
    }

    public IFunctionSummary[] generateMatchingFunctions(ICHelpBook[] iCHelpBookArray, String string, String string2) {
        IFunctionSummary[] iFunctionSummaryArray = new IFunctionSummary[iCHelpBookArray.length];
        int n = 0;
        while (n < iCHelpBookArray.length) {
            iFunctionSummaryArray[n] = new FunctionSummary(iCHelpBookArray[n], string, string2);
            ++n;
        }
        return iFunctionSummaryArray;
    }

    public ICHelpBook[] generateCHelpBooks(String string) {
        ICHelpBook[] iCHelpBookArray = new ICHelpBook[]{new CHelpBook(string, 1), new CHelpBook(string, 2), new CHelpBook(string, 3)};
        return iCHelpBookArray;
    }

    private void checkResponse(CHelpProviderTester[] cHelpProviderTesterArray, ICHelpInvocationContext iCHelpInvocationContext, String string, boolean bl) {
        Object object;
        CHelpBookDescriptor[] cHelpBookDescriptorArray = CHelpProviderManager.getDefault().getCHelpBookDescriptors(iCHelpInvocationContext);
        int n = 0;
        while (n < cHelpProviderTesterArray.length) {
            object = cHelpProviderTesterArray[n];
            Assert.assertTrue((String)("the name passed to CHelpProvider (" + ((CHelpProviderTester)object).getRequestedName() + ") differs prom tha name passed to manager (" + string + ")"), (boolean)string.equals(super.getRequestedName()));
            String string2 = super.getBookTitle();
            int n2 = 0;
            while (n2 < cHelpBookDescriptorArray.length) {
                if (string2.equals(cHelpBookDescriptorArray[n2].getCHelpBook().getTitle())) {
                    Assert.assertTrue((String)"provider was requested for help in disabled book", (boolean)cHelpBookDescriptorArray[n2].isEnabled());
                    break;
                }
                ++n2;
            }
            Assert.assertFalse((String)"provider was requested for help in non-existent book", (n2 == cHelpBookDescriptorArray.length ? 1 : 0) != 0);
            ++n;
        }
        if (bl) {
            n = 0;
            while (n < cHelpBookDescriptorArray.length) {
                if (cHelpBookDescriptorArray[n].isEnabled()) {
                    object = cHelpBookDescriptorArray[n].getCHelpBook().getTitle();
                    int n3 = 0;
                    while (n3 < cHelpProviderTesterArray.length) {
                        if (((String)object).equals(cHelpProviderTesterArray[n3].getBookTitle())) break;
                        ++n3;
                    }
                    Assert.assertFalse((String)"provider was not requested for help in enabled book", (n3 == cHelpBookDescriptorArray.length ? 1 : 0) != 0);
                }
                ++n;
            }
        }
    }

    public void checkHelpResources(ICHelpResourceDescriptor[] iCHelpResourceDescriptorArray, ICHelpInvocationContext iCHelpInvocationContext, String string) {
        if (iCHelpResourceDescriptorArray == null || iCHelpResourceDescriptorArray.length == 0) {
            return;
        }
        ArrayList<CHelpProviderTester> arrayList = new ArrayList<CHelpProviderTester>(iCHelpResourceDescriptorArray.length);
        int n = 0;
        while (n < iCHelpResourceDescriptorArray.length) {
            try {
                arrayList.add(new CHelpProviderTester(iCHelpResourceDescriptorArray[n].getHelpResources()[0].getLabel()));
            }
            catch (IOException iOException) {
                Assert.fail((String)("checkHelpResources failed to instantiate CHelpProviderTester, IOException occured: " + iOException.getMessage()));
            }
            ++n;
        }
        if (arrayList.size() > 0) {
            this.checkResponse(arrayList.toArray(new CHelpProviderTester[arrayList.size()]), iCHelpInvocationContext, string, true);
        }
    }

    public void checkMatchingFunctions(IFunctionSummary[] iFunctionSummaryArray, ICHelpInvocationContext iCHelpInvocationContext, String string) {
        if (iFunctionSummaryArray == null || iFunctionSummaryArray.length == 0) {
            return;
        }
        ArrayList<CHelpProviderTester> arrayList = new ArrayList<CHelpProviderTester>(iFunctionSummaryArray.length);
        int n = 0;
        while (n < iFunctionSummaryArray.length) {
            try {
                arrayList.add(new CHelpProviderTester(iFunctionSummaryArray[n].getDescription()));
            }
            catch (IOException iOException) {
                Assert.fail((String)("checkMatchingFunctions failed to instantiate CHelpProviderTester, IOException occured: " + iOException.getMessage()));
            }
            ++n;
        }
        if (arrayList.size() > 0) {
            this.checkResponse(arrayList.toArray(new CHelpProviderTester[arrayList.size()]), iCHelpInvocationContext, string, true);
        }
    }

    public void checkFunctionInfo(IFunctionSummary iFunctionSummary, ICHelpInvocationContext iCHelpInvocationContext, String string) {
        if (iFunctionSummary == null) {
            return;
        }
        CHelpProviderTester[] cHelpProviderTesterArray = new CHelpProviderTester[1];
        try {
            cHelpProviderTesterArray[0] = new CHelpProviderTester(iFunctionSummary.getDescription());
            this.checkResponse(cHelpProviderTesterArray, iCHelpInvocationContext, string, false);
        }
        catch (IOException iOException) {
            Assert.fail((String)("checkFunctionInfo failed to instantiate CHelpProviderTester, IOException occured: " + iOException.getMessage()));
        }
    }

    private class CHelpBook
    implements ICHelpBook {
        private int fCHelpType;
        private String fTitle;

        public CHelpBook(String string, int n) {
            this.fCHelpType = n;
            this.fTitle = CHelpProviderTester.generateBookTitle(string, n);
        }

        public String getTitle() {
            return this.fTitle;
        }

        public int getCHelpType() {
            return this.fCHelpType;
        }
    }

    private class CHelpResourceDescriptor
    implements ICHelpResourceDescriptor {
        ICHelpBook fBook;
        String fString;
        String fLabel;
        String fHref;
        IHelpResource[] fResources;

        public CHelpResourceDescriptor(ICHelpBook iCHelpBook, String string, String string2) {
            this.fBook = iCHelpBook;
            this.fString = string;
            this.fHref = String.valueOf(string) + iCHelpBook.getTitle() + ".html";
            this.fLabel = CHelpProviderTester.generateHelpString(iCHelpBook, string, string2);
            this.fResources = new IHelpResource[1];
            this.fResources[0] = new IHelpResource(this){
                final /* synthetic */ CHelpResourceDescriptor this$1;
                {
                    this.this$1 = cHelpResourceDescriptor;
                }

                public String getHref() {
                    return this.this$1.fHref;
                }

                public String getLabel() {
                    return this.this$1.fLabel;
                }
            };
        }

        public ICHelpBook getCHelpBook() {
            return this.fBook;
        }

        public IHelpResource[] getHelpResources() {
            return this.fResources;
        }
    }

    private class FunctionSummary
    implements IFunctionSummary {
        private String fName = "Name";
        private String fReturnType = "ReturnType";
        private String fPrototype = "Prototype";
        private String fSummary = "Summary";
        private String fSynopsis = "Synopsis";

        public FunctionSummary(ICHelpBook iCHelpBook, String string, String string2) {
            this.fName = string;
            this.fSummary = CHelpProviderTester.generateHelpString(iCHelpBook, string, string2);
        }

        public String getName() {
            return this.fName;
        }

        public String getNamespace() {
            return "dummy namespace";
        }

        public String getDescription() {
            return this.fSummary;
        }

        public IFunctionSummary.IFunctionPrototypeSummary getPrototype() {
            return new FunctionPrototypeSummary();
        }

        public IRequiredInclude[] getIncludes() {
            return null;
        }

        private class RequiredInclude
        implements IRequiredInclude {
            private String include;

            public RequiredInclude(String string) {
                this.include = string;
            }

            public String getIncludeName() {
                return this.include;
            }

            public boolean isStandard() {
                return true;
            }
        }

        public class FunctionPrototypeSummary
        implements IFunctionSummary.IFunctionPrototypeSummary {
            public String getName() {
                return FunctionSummary.this.fName;
            }

            public String getReturnType() {
                return FunctionSummary.this.fReturnType;
            }

            public String getArguments() {
                return FunctionSummary.this.fPrototype;
            }

            public String getPrototypeString(boolean bl) {
                if (bl) {
                    return String.valueOf(FunctionSummary.this.fName) + " (" + FunctionSummary.this.fPrototype + ") " + FunctionSummary.this.fReturnType;
                }
                return String.valueOf(FunctionSummary.this.fReturnType) + " " + FunctionSummary.this.fName + " (" + FunctionSummary.this.fPrototype + ")";
            }
        }
    }
}

