/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.tests.regression;

import java.io.StringWriter;
import java.util.List;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.tests.BaseTestFramework;
import org.eclipse.cdt.core.tests.FailingTest;
import org.eclipse.cdt.core.tests.SearchRegressionTests;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.model.TranslationUnit;
import org.eclipse.cdt.internal.corext.refactoring.RenameRefactoring;
import org.eclipse.cdt.internal.corext.refactoring.base.IChange;
import org.eclipse.cdt.internal.corext.refactoring.base.ICompositeChange;
import org.eclipse.cdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.cdt.internal.corext.refactoring.base.RefactoringStatusEntry;
import org.eclipse.cdt.internal.corext.refactoring.changes.TranslationUnitChange;
import org.eclipse.cdt.internal.corext.refactoring.rename.RenameElementProcessor;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class RefactoringRegressionTests
extends SearchRegressionTests {
    public RefactoringRegressionTests() {
    }

    public RefactoringRegressionTests(String string) {
        super(string);
    }

    public IChange getRefactorChanges(ISourceReference iSourceReference, String string) throws Exception {
        RenameRefactoring renameRefactoring = new RenameRefactoring((Object)iSourceReference);
        RenameElementProcessor renameElementProcessor = (RenameElementProcessor)renameRefactoring.getProcessor();
        renameElementProcessor.setNewElementName(string);
        RefactoringStatus refactoringStatus = renameRefactoring.checkInput((IProgressMonitor)new NullProgressMonitor());
        if (!refactoringStatus.hasError()) {
            IChange iChange = renameRefactoring.createChange((IProgressMonitor)new NullProgressMonitor());
            return iChange;
        }
        Assert.fail((String)("Input check on " + string + " failed. " + refactoringStatus.getFirstMessage(3)));
        return null;
    }

    public String[] getRefactorMessages(ISourceReference iSourceReference, String string) throws Exception {
        RenameRefactoring renameRefactoring = new RenameRefactoring((Object)iSourceReference);
        RenameElementProcessor renameElementProcessor = (RenameElementProcessor)renameRefactoring.getProcessor();
        renameElementProcessor.setNewElementName(string);
        RefactoringStatus refactoringStatus = renameRefactoring.checkInput((IProgressMonitor)new NullProgressMonitor());
        if (!refactoringStatus.hasWarning()) {
            Assert.fail((String)("Input check on " + string + " passed. There should have been warnings or errors. "));
            return null;
        }
        List list = refactoringStatus.getEntries();
        String[] stringArray = new String[list.size()];
        int n = 0;
        while (n < list.size()) {
            RefactoringStatusEntry refactoringStatusEntry = (RefactoringStatusEntry)list.get(n);
            stringArray[n] = refactoringStatusEntry.getMessage();
            ++n;
        }
        return stringArray;
    }

    public int getRefactorSeverity(ISourceReference iSourceReference, String string) throws Exception {
        RenameRefactoring renameRefactoring = new RenameRefactoring((Object)iSourceReference);
        RenameElementProcessor renameElementProcessor = (RenameElementProcessor)renameRefactoring.getProcessor();
        renameElementProcessor.setNewElementName(string);
        RefactoringStatus refactoringStatus = renameRefactoring.checkInput((IProgressMonitor)new NullProgressMonitor());
        return refactoringStatus.getSeverity();
    }

    protected ISourceReference findElementAtOffset(IFile iFile, int n) throws CModelException {
        CModelManager cModelManager = CModelManager.getDefault();
        TranslationUnit translationUnit = (TranslationUnit)cModelManager.create(iFile, BaseTestFramework.cproject);
        ICElement iCElement = translationUnit.getElementAtOffset(n);
        return (ISourceReference)(iCElement instanceof ISourceReference ? iCElement : null);
    }

    public static Test suite() {
        return RefactoringRegressionTests.suite(true);
    }

    public static Test suite(boolean bl) {
        TestSuite testSuite = new TestSuite("RefactoringRegressionTests");
        testSuite.addTest((Test)new RefactoringRegressionTests("testSimpleRename"));
        testSuite.addTest((Test)new RefactoringRegressionTests("testClass_1"));
        testSuite.addTest((Test)new RefactoringRegressionTests("testAttribute_2"));
        testSuite.addTest((Test)new RefactoringRegressionTests("testMethod_3"));
        testSuite.addTest((Test)new RefactoringRegressionTests("testConstructor_26"));
        testSuite.addTest((Test)new RefactoringRegressionTests("testConstructor_27"));
        testSuite.addTest((Test)new RefactoringRegressionTests("testDestructor_28"));
        testSuite.addTest((Test)new FailingTest((Test)new RefactoringRegressionTests("testDestructor_29_72612"), 72612));
        testSuite.addTest((Test)new FailingTest((Test)new RefactoringRegressionTests("testMethod_32_72717"), 72717));
        testSuite.addTest((Test)new RefactoringRegressionTests("testMethod_33_72605"));
        testSuite.addTest((Test)new RefactoringRegressionTests("testMethod_34"));
        testSuite.addTest((Test)new FailingTest((Test)new RefactoringRegressionTests("testMethod_35_72726"), 72726));
        testSuite.addTest((Test)new RefactoringRegressionTests("testMethod_39"));
        testSuite.addTest((Test)new RefactoringRegressionTests("testMethod_40"));
        testSuite.addTest((Test)new RefactoringRegressionTests("testMethod_41"));
        testSuite.addTest((Test)new RefactoringRegressionTests("testMethod_43"));
        testSuite.addTest((Test)new RefactoringRegressionTests("testMethod_44"));
        testSuite.addTest((Test)new FailingTest((Test)new RefactoringRegressionTests("testMethod_45_72723"), 72723));
        testSuite.addTest((Test)new RefactoringRegressionTests("testStruct_46"));
        testSuite.addTest((Test)new RefactoringRegressionTests("testUnion_47"));
        testSuite.addTest((Test)new RefactoringRegressionTests("testEnumeration_48"));
        testSuite.addTest((Test)new FailingTest((Test)new RefactoringRegressionTests("testTemplate_49_72626"), 72626));
        testSuite.addTest((Test)new RefactoringRegressionTests("testClass_52"));
        testSuite.addTest((Test)new RefactoringRegressionTests("testClass_53"));
        testSuite.addTest((Test)new RefactoringRegressionTests("testAttribute_54"));
        testSuite.addTest((Test)new FailingTest((Test)new RefactoringRegressionTests("testClass_55_79231"), 79231));
        testSuite.addTest((Test)new RefactoringRegressionTests("testClass_55"));
        testSuite.addTest((Test)new RefactoringRegressionTests("testClass_55_72748"));
        testSuite.addTest((Test)new RefactoringRegressionTests("testClass_56"));
        testSuite.addTest((Test)new RefactoringRegressionTests("testClass_60"));
        testSuite.addTest((Test)new RefactoringRegressionTests("testAttribute_61"));
        testSuite.addTest((Test)new RefactoringRegressionTests("testEnumerator_62"));
        testSuite.addTest((Test)new RefactoringRegressionTests("testAttribute_63"));
        testSuite.addTest((Test)new RefactoringRegressionTests("testAttribute_64"));
        testSuite.addTest((Test)new RefactoringRegressionTests("testAttribute_65"));
        testSuite.addTest((Test)new RefactoringRegressionTests("testNamespace_66"));
        testSuite.addTest((Test)new FailingTest((Test)new RefactoringRegressionTests("testNamespace_66_79281"), 79281));
        testSuite.addTest((Test)new FailingTest((Test)new RefactoringRegressionTests("testNamespace_66_79282"), 79282));
        testSuite.addTest((Test)new RefactoringRegressionTests("testFunction_67"));
        testSuite.addTest((Test)new RefactoringRegressionTests("testVariable_68"));
        testSuite.addTest((Test)new FailingTest((Test)new RefactoringRegressionTests("testVariable_68_79295"), 79295));
        testSuite.addTest((Test)new FailingTest((Test)new RefactoringRegressionTests("testClass_81_72620"), 72620));
        testSuite.addTest((Test)new FailingTest((Test)new RefactoringRegressionTests("testVariable_88_72617"), 72617));
        testSuite.addTest((Test)new RefactoringRegressionTests("testClass_92A"));
        testSuite.addTest((Test)new RefactoringRegressionTests("testClass_92B"));
        if (bl) {
            testSuite.addTest((Test)new RefactoringRegressionTests("cleanupProject"));
        }
        return testSuite;
    }

    protected void assertTotalChanges(int n, IChange iChange) throws Exception {
        int n2 = 0;
        if (iChange != null) {
            n2 = this.countChanges(iChange);
        }
        Assert.assertEquals((int)n, (int)n2);
    }

    private int countChanges(IChange iChange) {
        int n = 0;
        if (iChange instanceof ICompositeChange) {
            IChange[] iChangeArray = ((ICompositeChange)iChange).getChildren();
            int n2 = 0;
            while (n2 < iChangeArray.length) {
                n += this.countChanges(iChangeArray[n2]);
                ++n2;
            }
        } else if (iChange instanceof TranslationUnitChange) {
            n += this.countEdits(((TranslationUnitChange)iChange).getEdit());
        }
        return n;
    }

    private int countEdits(TextEdit textEdit) {
        if (textEdit instanceof MultiTextEdit) {
            return ((MultiTextEdit)textEdit).getChildrenSize();
        }
        return 1;
    }

    protected void assertChange(IChange iChange, IFile iFile, int n, int n2, String string) throws Exception {
        boolean bl = false;
        if (iChange != null && iChange instanceof ICompositeChange) {
            bl = this.checkCompositeChange((ICompositeChange)iChange, iFile, n, n2, string);
        }
        if (!bl) {
            Assert.fail((String)("Rename at offset " + n + " in \"" + iFile.getLocation() + "\" not found."));
            Assert.assertFalse((boolean)true);
        }
    }

    private boolean checkCompositeChange(ICompositeChange iCompositeChange, IFile iFile, int n, int n2, String string) {
        boolean bl = false;
        IChange[] iChangeArray = iCompositeChange.getChildren();
        int n3 = 0;
        while (n3 < iChangeArray.length) {
            TranslationUnitChange translationUnitChange;
            if (iChangeArray[n3] instanceof ICompositeChange) {
                bl = this.checkCompositeChange((ICompositeChange)iChangeArray[n3], iFile, n, n2, string);
            } else if (iChangeArray[n3] instanceof TranslationUnitChange && (translationUnitChange = (TranslationUnitChange)iChangeArray[n3]).getFile().toString().equals(iFile.toString())) {
                bl = this.checkTranslationUnitChange(translationUnitChange, n, n2, string);
            }
            if (bl) {
                return bl;
            }
            ++n3;
        }
        return bl;
    }

    private boolean checkTranslationUnitChange(TranslationUnitChange translationUnitChange, int n, int n2, String string) {
        TextEdit textEdit = translationUnitChange.getEdit();
        if (textEdit instanceof MultiTextEdit) {
            MultiTextEdit multiTextEdit = (MultiTextEdit)textEdit;
            TextEdit[] textEditArray = multiTextEdit.getChildren();
            int n3 = 0;
            while (n3 < textEditArray.length) {
                if (textEditArray[n3] instanceof ReplaceEdit && this.checkReplaceEdit((ReplaceEdit)textEditArray[n3], n, n2, string)) {
                    return true;
                }
                ++n3;
            }
        } else if (textEdit instanceof ReplaceEdit) {
            return this.checkReplaceEdit((ReplaceEdit)textEdit, n, n2, string);
        }
        return false;
    }

    private boolean checkReplaceEdit(ReplaceEdit replaceEdit, int n, int n2, String string) {
        return replaceEdit.getOffset() == n && replaceEdit.getLength() == n2 && replaceEdit.getText().equals(string);
    }

    public void testSimpleRename() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("int boo;            \n");
        stringWriter.write("void f() {          \n");
        stringWriter.write("   boo++;           \n");
        stringWriter.write("}                   \n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("t.cpp", string);
        ISourceReference iSourceReference = this.findElementAtOffset(iFile, string.indexOf("boo"));
        IChange iChange = this.getRefactorChanges(iSourceReference, "ooga");
        this.assertTotalChanges(2, iChange);
        this.assertChange(iChange, iFile, string.indexOf("boo"), 3, "ooga");
        this.assertChange(iChange, iFile, string.indexOf("boo++"), 3, "ooga");
    }

    public void testClass_1() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("class Boo/*vp1*/{}; \n");
        stringWriter.write("void f() {          \n");
        stringWriter.write("   Boo a;           \n");
        stringWriter.write("}                   \n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("t.cpp", string);
        ISourceReference iSourceReference = this.findElementAtOffset(iFile, string.indexOf("Boo/*vp1*/"));
        IChange iChange = this.getRefactorChanges(iSourceReference, "Ooga");
        this.assertTotalChanges(2, iChange);
        this.assertChange(iChange, iFile, string.indexOf("Boo/*vp1*/"), 3, "Ooga");
        this.assertChange(iChange, iFile, string.indexOf("Boo a"), 3, "Ooga");
    }

    public void testAttribute_2() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("class Boo{ \t\t   \n");
        stringWriter.write("  int att1;//vp1,res1   \n");
        stringWriter.write("};                  \n");
        stringWriter.write("void f() {          \n");
        stringWriter.write("   Boo a;           \n");
        stringWriter.write("   a.att1;//res2     \n");
        stringWriter.write("}                   \n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("t.cpp", string);
        ISourceReference iSourceReference = this.findElementAtOffset(iFile, string.indexOf("att1;//vp1"));
        IChange iChange = this.getRefactorChanges(iSourceReference, "ooga");
        this.assertTotalChanges(2, iChange);
        this.assertChange(iChange, iFile, string.indexOf("att1;//vp1,res1"), 4, "ooga");
        this.assertChange(iChange, iFile, string.indexOf("att1;//res2"), 4, "ooga");
    }

    public void testMethod_3() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("class Boo{ \t\t   \t\t\t\n");
        stringWriter.write("  int method1(){}//vp1,res1  \n");
        stringWriter.write("};                  \t\t\t\n");
        stringWriter.write("void f() {          \t\t\t\n");
        stringWriter.write("   Boo a;           \t\t\t\n");
        stringWriter.write("   a.method1();//res2    \t\n");
        stringWriter.write("}                   \t\t\t\n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("t.cpp", string);
        ISourceReference iSourceReference = this.findElementAtOffset(iFile, string.indexOf("method1(){}//vp1"));
        IChange iChange = this.getRefactorChanges(iSourceReference, "ooga");
        this.assertTotalChanges(2, iChange);
        this.assertChange(iChange, iFile, string.indexOf("method1(){}//vp1,res1"), 7, "ooga");
        this.assertChange(iChange, iFile, string.indexOf("method1();//res2"), 7, "ooga");
    }

    public void testConstructor_26() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("class Boo{ \t\t   \t\t\t\n");
        stringWriter.write("  Boo(){}//vp1,res1  \n");
        stringWriter.write("};                  \t\t\t\n");
        stringWriter.write("void f() {          \t\t\t\n");
        stringWriter.write("   Boo a = new Boo();           \t\t\t\n");
        stringWriter.write("}                   \t\t\t\n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("t.cpp", string);
        ISourceReference iSourceReference = this.findElementAtOffset(iFile, string.indexOf("Boo(){}"));
        try {
            this.getRefactorChanges(iSourceReference, "ooga");
        }
        catch (AssertionFailedError assertionFailedError) {
            Assert.assertTrue((boolean)assertionFailedError.getMessage().startsWith("Input check on ooga failed."));
            return;
        }
        Assert.fail((String)"An error should have occurred in the input check.");
    }

    public void testConstructor_27() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("class Boo{ \t\t   \t\n");
        stringWriter.write("  int foo(){}//vp1\t\n");
        stringWriter.write("};                  \t\n");
        stringWriter.write("void f() {          \t\n");
        stringWriter.write("   Boo a;           \t\n");
        stringWriter.write("   a.foo();          \n");
        stringWriter.write("}                   \t\n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("t.cpp", string);
        ISourceReference iSourceReference = this.findElementAtOffset(iFile, string.indexOf("foo(){}"));
        try {
            this.getRefactorChanges(iSourceReference, "Boo");
        }
        catch (AssertionFailedError assertionFailedError) {
            Assert.assertTrue((boolean)assertionFailedError.getMessage().startsWith("Input check on Boo failed."));
            return;
        }
        Assert.fail((String)"An error should have occurred in the input check.");
    }

    public void testDestructor_28() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("class Boo{ \t\t   \t\n");
        stringWriter.write("  ~Boo(){}//vp1\t\t\n");
        stringWriter.write("};                  \t\n");
        stringWriter.write("void f() {          \t\n");
        stringWriter.write("   Boo a ;           \n");
        stringWriter.write("   a.~Boo();         \n");
        stringWriter.write("}                   \t\n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("t.cpp", string);
        ISourceReference iSourceReference = this.findElementAtOffset(iFile, string.indexOf("~Boo(){}"));
        try {
            this.getRefactorChanges(iSourceReference, "ooga");
        }
        catch (AssertionFailedError assertionFailedError) {
            Assert.assertTrue((boolean)assertionFailedError.getMessage().startsWith("Input check on ooga failed."));
            return;
        }
        Assert.fail((String)"An error should have occurred in the input check.");
    }

    public void testDestructor_29_72612() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("class Boo{ \t\t   \t\n");
        stringWriter.write("  int foo(){}//vp1\t\n");
        stringWriter.write("};                  \t\n");
        stringWriter.write("void f() {          \t\n");
        stringWriter.write("   Boo a;           \t\n");
        stringWriter.write("   a.foo();          \n");
        stringWriter.write("}                   \t\n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("t.cpp", string);
        ISourceReference iSourceReference = this.findElementAtOffset(iFile, string.indexOf("foo(){}"));
        try {
            this.getRefactorChanges(iSourceReference, "~Boo");
        }
        catch (AssertionFailedError assertionFailedError) {
            Assert.assertTrue((boolean)assertionFailedError.getMessage().startsWith("Input check on Boo failed."));
            return;
        }
        Assert.fail((String)"An error should have occurred in the input check.");
    }

    public void testMethod_32_72717() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("class Base { \t\t    \t\n");
        stringWriter.write(" virtual void foo()=0;\t\t\n");
        stringWriter.write("};\t\t\t\t\t\t\t\n");
        stringWriter.write("class Derived: public Base { \n");
        stringWriter.write(" virtual void foo();\t\t\t\n");
        stringWriter.write(" void moon/*vp1*/(int i);   \t\n");
        stringWriter.write("};\t\t\t\t \t\t    \n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("t.cpp", string);
        ISourceReference iSourceReference = this.findElementAtOffset(iFile, string.indexOf("moon/*vp1*/"));
        IChange iChange = this.getRefactorChanges(iSourceReference, "foo");
        this.assertTotalChanges(1, iChange);
        this.assertChange(iChange, iFile, string.indexOf("moon/*vp1*/"), 4, "foo");
    }

    public void testMethod_33_72605() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("class Foo { \t\t    \t\t\n");
        stringWriter.write(" void aMethod/*vp1*/(int x=0);\t\t\n");
        stringWriter.write("};\t\t\t\t\t\t\t\n");
        stringWriter.write("void Foo::aMethod(int x){}\t\n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("t.cpp", string);
        ISourceReference iSourceReference = this.findElementAtOffset(iFile, string.indexOf("aMethod/*vp1*/"));
        IChange iChange = this.getRefactorChanges(iSourceReference, "ooga");
        this.assertTotalChanges(2, iChange);
        this.assertChange(iChange, iFile, string.indexOf("aMethod/*vp1*/"), 7, "ooga");
        this.assertChange(iChange, iFile, string.indexOf("aMethod(int x)"), 7, "ooga");
    }

    public void testMethod_34() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("class Base{\t    \t\t\n");
        stringWriter.write("  virtual void v/*vp1*/()=0;\t\t\n");
        stringWriter.write("};\t\t\t\t\t\t\n");
        stringWriter.write("class Derived: Base { \t\n");
        stringWriter.write("  void v(){};    \t\t\n");
        stringWriter.write("};\t\t\t\t\t\t\n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("t.cpp", string);
        ISourceReference iSourceReference = this.findElementAtOffset(iFile, string.indexOf("v/*vp1*/"));
        IChange iChange = this.getRefactorChanges(iSourceReference, "ooga");
        this.assertTotalChanges(1, iChange);
        this.assertChange(iChange, iFile, string.indexOf("v/*vp1*/"), 1, "ooga");
    }

    public void testMethod_35_72726() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("class Foo{\t    \t\t\t\t\t\t\n");
        stringWriter.write("  Foo& operator *=/*vp1*/(const Foo &rhs);\n");
        stringWriter.write("  Foo& operator==/*vp2*/(const Foo &rhs);\n");
        stringWriter.write("};\t\t\t\t\t\t\t\t\t\t\n");
        stringWriter.write("Foo& Foo::operator *=(const Foo &rhs){ \t\n");
        stringWriter.write("  return *this;   \t\t\t\t\t\t\n");
        stringWriter.write("};\t\t\t\t\t\t\t\t\t\t\n");
        stringWriter.write("Foo& Foo::operator==(const Foo &rhs){ \t\n");
        stringWriter.write("  return *this;   \t\t\t\t\t\t\n");
        stringWriter.write("};\t\t\t\t\t\t\t\t\t\t\n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("t.cpp", string);
        ISourceReference iSourceReference = this.findElementAtOffset(iFile, string.indexOf("operator *=/*vp1*/"));
        IChange iChange = this.getRefactorChanges(iSourceReference, "operator +=");
        this.assertTotalChanges(2, iChange);
        this.assertChange(iChange, iFile, string.indexOf("operator *=/*vp1*/"), 11, "operator +=");
        this.assertChange(iChange, iFile, string.indexOf("operator *=(const"), 11, "operator +=");
        iSourceReference = this.findElementAtOffset(iFile, string.indexOf("operator==/*vp2*/"));
        iChange = this.getRefactorChanges(iSourceReference, "operator=");
        this.assertTotalChanges(2, iChange);
        this.assertChange(iChange, iFile, string.indexOf("operator==/*vp2*/"), 11, "operator=");
        this.assertChange(iChange, iFile, string.indexOf("operator==(const"), 11, "operator=");
    }

    public void testMethod_39() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("class Foo{\t    \t\t\t\t\t\t\t\n");
        stringWriter.write("  const void*   method1/*vp1*/(char*); \t\t\n");
        stringWriter.write("  const int   method2/*vp1*/(int j); \t\t\n");
        stringWriter.write("};\t\t\t\t\t\t\t\t\t\t\t\n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("t.h", string);
        stringWriter = new StringWriter();
        stringWriter.write("#include \"t.h\"\t\t\t\t\t\t\t\t\t\t\t\n");
        stringWriter.write("const void* Foo::method1(char* x){return ((void*) x;}\t\n");
        stringWriter.write("const int Foo::method2(int){return 5;}  \t\t\t\t\t\n");
        stringWriter.write("void test() {\t\t\t\t\t\t\t\t\t\t\t\n");
        stringWriter.write("\t\tFoo d;\t\t\t\t\t\t\t\t\t\t\t\t\n");
        stringWriter.write(" \td.method1(\"hello\");\t\t\t\t\t\t\t\t\n");
        stringWriter.write(" \tint i =d.method2(3);\t\t\t\t\t\t\t\t\n");
        stringWriter.write("}\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        String string2 = stringWriter.toString();
        IFile iFile2 = this.importFile("t.cpp", string2);
        ISourceReference iSourceReference = this.findElementAtOffset(iFile, string.indexOf("method1/*vp1*/"));
        IChange iChange = this.getRefactorChanges(iSourceReference, "m1");
        this.assertChange(iChange, iFile, string.indexOf("method1/*vp1*/"), 7, "m1");
        this.assertChange(iChange, iFile2, string2.indexOf("method1(char"), 7, "m1");
        this.assertChange(iChange, iFile2, string2.indexOf("method1(\"hello"), 7, "m1");
        iSourceReference = this.findElementAtOffset(iFile2, string2.indexOf("Foo::method2"));
        iChange = this.getRefactorChanges(iSourceReference, "m2");
        this.assertTotalChanges(3, iChange);
        this.assertChange(iChange, iFile, string.indexOf("method2/*vp1*/"), 7, "m2");
        this.assertChange(iChange, iFile2, string2.indexOf("method2(int"), 7, "m2");
        this.assertChange(iChange, iFile2, string2.indexOf("method2(3"), 7, "m2");
    }

    public void testMethod_40() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("class Foo{\t    \t\t\t\t\t\t\t\n");
        stringWriter.write("  static int method1/*vp1*/(char* x);\t\t\n");
        stringWriter.write("  static int method2/*vp2*/(int);\t\t    \n");
        stringWriter.write("};\t\t\t\t\t\t\t\t\t\t\t\n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("t.h", string);
        stringWriter = new StringWriter();
        stringWriter.write("#include \"t.h\"\t\t\t\t\t\t\t\t\n");
        stringWriter.write("static int Foo::method1(char* x){return 5;}  \n");
        stringWriter.write("static int Foo::method2(int x){return (2);};\t\n");
        stringWriter.write("void test() {\t\t\t\t\t\t\t\t\n");
        stringWriter.write("\t\tFoo::method1(\"hello\");\t\t\t\t\n");
        stringWriter.write("\t\tint i =Foo::method2(3);\t\t\t\t\t\n");
        stringWriter.write("}\t\t\t\t\t\t\t\t\t\t\t\n");
        String string2 = stringWriter.toString();
        IFile iFile2 = this.importFile("t.cpp", string2);
        ISourceReference iSourceReference = this.findElementAtOffset(iFile, string.indexOf("method1/*vp1*/"));
        IChange iChange = this.getRefactorChanges(iSourceReference, "m1");
        this.assertTotalChanges(3, iChange);
        this.assertChange(iChange, iFile, string.indexOf("method1/*vp1*/"), 7, "m1");
        this.assertChange(iChange, iFile2, string2.indexOf("method1(char"), 7, "m1");
        this.assertChange(iChange, iFile2, string2.indexOf("method1(\"hello"), 7, "m1");
        iSourceReference = this.findElementAtOffset(iFile2, string2.indexOf("Foo::method2"));
        iChange = this.getRefactorChanges(iSourceReference, "m2");
        this.assertTotalChanges(3, iChange);
        this.assertChange(iChange, iFile, string.indexOf("method2/*vp2*/"), 7, "m2");
        this.assertChange(iChange, iFile2, string2.indexOf("method2(int x"), 7, "m2");
        this.assertChange(iChange, iFile2, string2.indexOf("method2(3"), 7, "m2");
    }

    public void testMethod_41() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("class Foo{\t    \t\t\t\t\t\t\t\n");
        stringWriter.write("public: \t\t    \t\t\t\t\t\t\t\n");
        stringWriter.write("  volatile int  method1/*vp1*/(int);\t\t\t\n");
        stringWriter.write("private:\t\t\t\t\t\t\t\t \t\t\n");
        stringWriter.write("  int b;\t\t\t\t\t\t\t\t\t\t\n");
        stringWriter.write("};\t\t\t\t\t\t\t\t\t\t\t\n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("t.h", string);
        stringWriter = new StringWriter();
        stringWriter.write("#include \"t.h\"\t\t\t\t\t\t\t\t\n");
        stringWriter.write("volatile int Foo::method1(int x){return (2);};\t\t\t\t\n");
        stringWriter.write("void test() {\t\t\t\t\t\t\t\t\n");
        stringWriter.write("  Foo d;\t\t\t\t\t\t\t\t\n");
        stringWriter.write("  int i =d.method1(1);\t\t\t\t\t\t\n");
        stringWriter.write("}\t\t\t\t\t\t\t\t\t\t\t\n");
        String string2 = stringWriter.toString();
        IFile iFile2 = this.importFile("t.cpp", string2);
        ISourceReference iSourceReference = this.findElementAtOffset(iFile, string.indexOf("method1/*vp1*/"));
        IChange iChange = this.getRefactorChanges(iSourceReference, "m1");
        this.assertTotalChanges(3, iChange);
        this.assertChange(iChange, iFile, string.indexOf("method1/*vp1*/"), 7, "m1");
        this.assertChange(iChange, iFile2, string2.indexOf("method1(int x"), 7, "m1");
        this.assertChange(iChange, iFile2, string2.indexOf("method1(1"), 7, "m1");
    }

    public void testMethod_43() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("class Foo{\t    \t\t\t\t\t\t\t\n");
        stringWriter.write("public: \t\t    \t\t\t\t\t\t\t\n");
        stringWriter.write("  inline void  method1/*vp1*/(int i) {b=i;}\t\n");
        stringWriter.write("private:\t\t\t\t\t\t\t\t \t\t\n");
        stringWriter.write("  int b;\t\t\t\t\t\t\t\t\t\t\n");
        stringWriter.write("};\t\t\t\t\t\t\t\t\t\t\t\n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("t.h", string);
        stringWriter = new StringWriter();
        stringWriter.write("#include \"t.h\"\t\t\t\t\t\t\t\t\n");
        stringWriter.write("void test() {\t\t\t\t\t\t\t\t\n");
        stringWriter.write("  Foo *d;\t\t\t\t\t\t\t\t\t\n");
        stringWriter.write("  d->method1(1);\t\t\t\t\t\t\t\t\n");
        stringWriter.write("}\t\t\t\t\t\t\t\t\t\t\t\n");
        String string2 = stringWriter.toString();
        IFile iFile2 = this.importFile("t.cpp", string2);
        ISourceReference iSourceReference = this.findElementAtOffset(iFile, string.indexOf("method1/*vp1*/"));
        IChange iChange = this.getRefactorChanges(iSourceReference, "m1");
        this.assertTotalChanges(2, iChange);
        this.assertChange(iChange, iFile, string.indexOf("method1/*vp1*/"), 7, "m1");
        this.assertChange(iChange, iFile2, string2.indexOf("method1(1"), 7, "m1");
    }

    public void testMethod_44() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("class Base{\t    \t\t\n");
        stringWriter.write("  virtual void v();\t\t\n");
        stringWriter.write("  int i; \t\t\t\t\n");
        stringWriter.write("};\t\t\t\t\t\t\n");
        stringWriter.write("void Base::v(){}\t\t\t\n");
        stringWriter.write("class Derived: Base { \t\n");
        stringWriter.write("  virtual void v/*vp1*/(){}//explicitly virtual    \t\t\n");
        stringWriter.write("};\t\t\t\t\t\t\n");
        stringWriter.write("class Derived2: Derived {\n");
        stringWriter.write("  void v(){i++;}    \t\t\n");
        stringWriter.write("};\t\t\t\t\t\t\n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("t.cpp", string);
        ISourceReference iSourceReference = this.findElementAtOffset(iFile, string.indexOf("v/*vp1*/"));
        String[] stringArray = this.getRefactorMessages(iSourceReference, "v2");
        Assert.assertEquals((int)1, (int)stringArray.length);
        Assert.assertEquals((String)"Renaming a virtual method. Consider renaming the base and derived class methods (if any).", (String)stringArray[0]);
    }

    public void testMethod_45_72732() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("class Base{\t    \t\t\n");
        stringWriter.write("  virtual void v();\t\t\n");
        stringWriter.write("  int i; \t\t\t\t\n");
        stringWriter.write("};\t\t\t\t\t\t\n");
        stringWriter.write("void Base::v(){}\t\t\t\n");
        stringWriter.write("class Derived: Base { \t\n");
        stringWriter.write("  void v/*vp1*/(){}//implicitly virtual    \t\t\n");
        stringWriter.write("};\t\t\t\t\t\t\n");
        stringWriter.write("class Derived2: Derived {\n");
        stringWriter.write("  void v(){i++;}    \t\t\n");
        stringWriter.write("};\t\t\t\t\t\t\n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("t.cpp", string);
        ISourceReference iSourceReference = this.findElementAtOffset(iFile, string.indexOf("v/*vp1*/"));
        String[] stringArray = this.getRefactorMessages(iSourceReference, "v2");
        Assert.assertEquals((int)1, (int)stringArray.length);
        Assert.assertEquals((String)"Renaming a virtual method. Consider renaming the base and derived class methods (if any).", (String)stringArray[0]);
    }

    public void testStruct_46() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("struct st1/*vp1*/{};\t\t\t\t\n");
        stringWriter.write("class c1/*vp1*/{ \t\t\t\t\n");
        stringWriter.write("  public: struct st2/*vp2*/{} s; \n");
        stringWriter.write("};\t\t\t\t          \t\t\n");
        stringWriter.write("namespace N{   \t\t        \t\n");
        stringWriter.write(" struct st3/*vp3*/{};\t        \n");
        stringWriter.write(" class c2/*vp1*/{ \t\t\t\t\n");
        stringWriter.write("   st1 s;\t\t\t    \t\t\n");
        stringWriter.write("   st3 ss;\t\t\t    \t\t\n");
        stringWriter.write("   c2() {\t\t\t    \t\t\n");
        stringWriter.write("     c1::st2 s;\t\t\t    \t\n");
        stringWriter.write("   }\t\t\t\t          \t\t\n");
        stringWriter.write(" };\t\t\t\t          \t\t\n");
        stringWriter.write("}\t\t\t                \t\n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("t.cpp", string);
        ISourceReference iSourceReference = this.findElementAtOffset(iFile, string.indexOf("st1/*vp1*/"));
        IChange iChange = this.getRefactorChanges(iSourceReference, "Ooga1");
        this.assertTotalChanges(2, iChange);
        this.assertChange(iChange, iFile, string.indexOf("st1/*vp1*/"), 3, "Ooga1");
        this.assertChange(iChange, iFile, string.indexOf("st1 s"), 3, "Ooga1");
        iSourceReference = this.findElementAtOffset(iFile, string.indexOf("st2/*vp2*/"));
        iChange = this.getRefactorChanges(iSourceReference, "Ooga2");
        this.assertTotalChanges(2, iChange);
        this.assertChange(iChange, iFile, string.indexOf("st2/*vp2*/"), 3, "Ooga2");
        this.assertChange(iChange, iFile, string.indexOf("st2 s"), 3, "Ooga2");
        iSourceReference = this.findElementAtOffset(iFile, string.indexOf("st3/*vp3*/"));
        iChange = this.getRefactorChanges(iSourceReference, "Ooga3");
        this.assertTotalChanges(2, iChange);
        this.assertChange(iChange, iFile, string.indexOf("st3/*vp3*/"), 3, "Ooga3");
        this.assertChange(iChange, iFile, string.indexOf("st3 ss"), 3, "Ooga3");
    }

    public void testUnion_47() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("union st1/*vp1*/{};\t\t\t\t\n");
        stringWriter.write("class c1/*vp1*/{ \t\t\t\t\n");
        stringWriter.write("  public: union st2/*vp2*/{} s; \t\n");
        stringWriter.write("};\t\t\t\t          \t\t\n");
        stringWriter.write("namespace N{   \t\t        \t\n");
        stringWriter.write(" union st3/*vp3*/{};\t        \t\n");
        stringWriter.write(" class c2/*vp1*/{ \t\t\t\t\n");
        stringWriter.write("   st1 s;\t\t\t    \t\t\n");
        stringWriter.write("   st3 ss;\t\t\t    \t\t\n");
        stringWriter.write("   c2() {\t\t\t    \t\t\n");
        stringWriter.write("     c1::st2 s;\t\t\t    \t\n");
        stringWriter.write("   }\t\t\t\t          \t\t\n");
        stringWriter.write(" };\t\t\t\t          \t\t\n");
        stringWriter.write("}\t\t\t                \t\n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("t.cpp", string);
        ISourceReference iSourceReference = this.findElementAtOffset(iFile, string.indexOf("st1/*vp1*/"));
        IChange iChange = this.getRefactorChanges(iSourceReference, "Ooga1");
        this.assertTotalChanges(2, iChange);
        this.assertChange(iChange, iFile, string.indexOf("st1/*vp1*/"), 3, "Ooga1");
        this.assertChange(iChange, iFile, string.indexOf("st1 s"), 3, "Ooga1");
        iSourceReference = this.findElementAtOffset(iFile, string.indexOf("st2/*vp2*/"));
        iChange = this.getRefactorChanges(iSourceReference, "Ooga2");
        this.assertTotalChanges(2, iChange);
        this.assertChange(iChange, iFile, string.indexOf("st2/*vp2*/"), 3, "Ooga2");
        this.assertChange(iChange, iFile, string.indexOf("st2 s"), 3, "Ooga2");
        iSourceReference = this.findElementAtOffset(iFile, string.indexOf("st3/*vp3*/"));
        iChange = this.getRefactorChanges(iSourceReference, "Ooga3");
        this.assertTotalChanges(2, iChange);
        this.assertChange(iChange, iFile, string.indexOf("st3/*vp3*/"), 3, "Ooga3");
        this.assertChange(iChange, iFile, string.indexOf("st3 ss"), 3, "Ooga3");
    }

    public void testEnumeration_48() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("enum e1/*vp1*/{E0};\t\t\t\t\n");
        stringWriter.write("class c1\t{\t\t\t\t\t\t\n");
        stringWriter.write("  public: enum e2/*vp2*/{E1} s; \t\n");
        stringWriter.write("};\t\t\t\t          \t\t\n");
        stringWriter.write("namespace N{   \t\t        \t\n");
        stringWriter.write(" enum e3/*vp3*/{};\t   \t\t\t\n");
        stringWriter.write(" class c2/*vp1*/{ \t\t\t\t\n");
        stringWriter.write("   e1 s;\t\t\t    \t\t\t\n");
        stringWriter.write("   e3 ss;\t\t\t    \t\t\n");
        stringWriter.write("   c2() {\t\t\t    \t\t\n");
        stringWriter.write("     c1::e2 s;\t\t\t    \t\n");
        stringWriter.write("   }\t\t\t\t          \t\t\n");
        stringWriter.write(" };\t\t\t\t          \t\t\n");
        stringWriter.write("}\t\t\t                \t\n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("t.cpp", string);
        ISourceReference iSourceReference = this.findElementAtOffset(iFile, string.indexOf("e1/*vp1*/"));
        IChange iChange = this.getRefactorChanges(iSourceReference, "Ooga1");
        this.assertTotalChanges(2, iChange);
        this.assertChange(iChange, iFile, string.indexOf("e1/*vp1*/"), 2, "Ooga1");
        this.assertChange(iChange, iFile, string.indexOf("e1 s"), 2, "Ooga1");
        iSourceReference = this.findElementAtOffset(iFile, string.indexOf("e2/*vp2*/"));
        iChange = this.getRefactorChanges(iSourceReference, "Ooga2");
        this.assertTotalChanges(2, iChange);
        this.assertChange(iChange, iFile, string.indexOf("e2/*vp2*/"), 2, "Ooga2");
        this.assertChange(iChange, iFile, string.indexOf("e2 s"), 2, "Ooga2");
        iSourceReference = this.findElementAtOffset(iFile, string.indexOf("e3/*vp3*/"));
        iChange = this.getRefactorChanges(iSourceReference, "Ooga3");
        this.assertTotalChanges(2, iChange);
        this.assertChange(iChange, iFile, string.indexOf("e3/*vp3*/"), 2, "Ooga3");
        this.assertChange(iChange, iFile, string.indexOf("e3 ss"), 2, "Ooga3");
    }

    public void testTemplate_49_72626() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("template <class Type>\t\t\t\n");
        stringWriter.write("class Array/*vp1*/\t{\t\t\t\n");
        stringWriter.write("  public:\tArray(){ \t\t\t\n");
        stringWriter.write("   a=new Type[10];          \t\t\n");
        stringWriter.write("  }\t\t\t\t          \t\t\n");
        stringWriter.write("  virtual Type& operator[](int i){return a[i];}  \n");
        stringWriter.write("  protected:\tType *a;\t   \t\t\n");
        stringWriter.write("};\t\t\t\t          \t\t\n");
        stringWriter.write("void f(){ \t\t\t\t\t\t\n");
        stringWriter.write("   Array<int> a;\t\t\t    \t\n");
        stringWriter.write("}\t\t\t                \t\n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("t.cpp", string);
        ISourceReference iSourceReference = this.findElementAtOffset(iFile, string.indexOf("Array"));
        String[] stringArray = this.getRefactorMessages(iSourceReference, "Arr2");
        Assert.assertEquals((int)1, (int)stringArray.length);
        Assert.assertEquals((String)"Renaming a template class. Parsing templates are not fully functional. Check the results if you continue.", (String)stringArray[0]);
    }

    public void testClass_52() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("namespace N1 { \t\t\t\n");
        stringWriter.write("class Boo{};        \t\t\n");
        stringWriter.write("}                   \t\t\n");
        stringWriter.write("namespace N2  {\t\t\t\n");
        stringWriter.write("class Boo/*vp1*/{};      \n");
        stringWriter.write("}                   \t\t\n");
        stringWriter.write("void f() {          \t\t\n");
        stringWriter.write("   N1::Boo c1;           \n");
        stringWriter.write("   N2::Boo c2;           \n");
        stringWriter.write("}                   \t\t\n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("t.cpp", string);
        ISourceReference iSourceReference = this.findElementAtOffset(iFile, string.indexOf("Boo/*vp1*/"));
        IChange iChange = this.getRefactorChanges(iSourceReference, "Ooga");
        this.assertTotalChanges(2, iChange);
        this.assertChange(iChange, iFile, string.indexOf("Boo/*vp1*/"), 3, "Ooga");
        this.assertChange(iChange, iFile, string.indexOf("Boo c2"), 3, "Ooga");
    }

    public void testClass_53() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("class Foo/*vp1*/ {//ren1\t\t\n");
        stringWriter.write("  Foo();//ren2        \t\t\n");
        stringWriter.write("  virtual ~Foo();//ren3      \n");
        stringWriter.write("};                   \t\t\n");
        stringWriter.write("Foo::Foo() {}//ren4,5\t\t\n");
        stringWriter.write("Foo::~Foo() {}//ren6,7\t\t\n");
        stringWriter.write("void f() {          \t\t\t\n");
        stringWriter.write("   Foo *f=new Foo();//ren8,9 \n");
        stringWriter.write("   f->~Foo();//ren10         \n");
        stringWriter.write("}                   \t\t\t\n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("t.cpp", string);
        ISourceReference iSourceReference = this.findElementAtOffset(iFile, string.indexOf("Foo/*vp1*/"));
        IChange iChange = this.getRefactorChanges(iSourceReference, "Ooga");
        this.assertTotalChanges(10, iChange);
        this.assertChange(iChange, iFile, string.indexOf("Foo/*vp1*/"), 3, "Ooga");
        this.assertChange(iChange, iFile, string.indexOf("Foo();//ren2"), 3, "Ooga");
        this.assertChange(iChange, iFile, string.indexOf("Foo();//ren3"), 3, "Ooga");
        this.assertChange(iChange, iFile, string.indexOf("Foo::Foo() {}//ren4,5"), 3, "Ooga");
        this.assertChange(iChange, iFile, string.indexOf("Foo() {}//ren4,5"), 3, "Ooga");
        this.assertChange(iChange, iFile, string.indexOf("Foo::~Foo() {}//ren6,7"), 3, "Ooga");
        this.assertChange(iChange, iFile, string.indexOf("Foo() {}//ren6,7"), 3, "Ooga");
        this.assertChange(iChange, iFile, string.indexOf("Foo *f=new Foo();//ren8,9"), 3, "Ooga");
        this.assertChange(iChange, iFile, string.indexOf("Foo();//ren8,9"), 3, "Ooga");
        this.assertChange(iChange, iFile, string.indexOf("Foo();//ren10"), 3, "Ooga");
    }

    public void testAttribute_54() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("class Boo{ \t\t   \t\t\t\n");
        stringWriter.write("  static int att;//vp1,rn1  \t\n");
        stringWriter.write("};                  \t\t\t\n");
        stringWriter.write("void f() {          \t\t\t\n");
        stringWriter.write("   Boo a;           \t\t\t\n");
        stringWriter.write("   a.att;//rn2     \t\t\t\n");
        stringWriter.write("   Boo::att;//rn3     \t\t\n");
        stringWriter.write("}                   \t\t\t\n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("t.cpp", string);
        ISourceReference iSourceReference = this.findElementAtOffset(iFile, string.indexOf("att;//vp1"));
        IChange iChange = this.getRefactorChanges(iSourceReference, "ooga");
        this.assertTotalChanges(3, iChange);
        this.assertChange(iChange, iFile, string.indexOf("att;//vp1"), 3, "ooga");
        this.assertChange(iChange, iFile, string.indexOf("att;//rn2"), 3, "ooga");
        this.assertChange(iChange, iFile, string.indexOf("att;//rn3"), 3, "ooga");
    }

    public void testClass_55() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("class Foo{\t\t   \t\n");
        stringWriter.write("  class Hoo{//vp1    \n");
        stringWriter.write("     public: Hoo();  \n");
        stringWriter.write("  };                 \n");
        stringWriter.write("  Foo(){             \n");
        stringWriter.write("\t \tFoo::Hoo h;     \n");
        stringWriter.write("  }           \t\t\n");
        stringWriter.write("};    \t\t\t\t\n");
        stringWriter.write("Foo::Hoo::Hoo(){}    \n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("t.cpp", string);
        ISourceReference iSourceReference = this.findElementAtOffset(iFile, string.indexOf("Hoo{"));
        IChange iChange = this.getRefactorChanges(iSourceReference, "ooga");
        this.assertTotalChanges(5, iChange);
        this.assertChange(iChange, iFile, string.indexOf("Hoo{//vp1"), 3, "ooga");
        this.assertChange(iChange, iFile, string.indexOf("Hoo();"), 3, "ooga");
        this.assertChange(iChange, iFile, string.indexOf("Hoo h;"), 3, "ooga");
        this.assertChange(iChange, iFile, string.indexOf("Hoo::Hoo(){}"), 3, "ooga");
        this.assertChange(iChange, iFile, string.indexOf("Hoo(){}"), 3, "ooga");
    }

    public void testClass_55_79231() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("class Boo{};//vp1\t\t   \t\n");
        stringWriter.write("class Foo{          \t\t\n");
        stringWriter.write("   Foo() {          \t\t\n");
        stringWriter.write("     class Boo{};   \t\t\n");
        stringWriter.write("     Boo t;    \t\t\t\n");
        stringWriter.write("};                  \t\t\n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("t.cpp", string);
        ISourceReference iSourceReference = this.findElementAtOffset(iFile, string.indexOf("Boo{};//vp1"));
        IChange iChange = this.getRefactorChanges(iSourceReference, "Ooga");
        this.assertTotalChanges(1, iChange);
        this.assertChange(iChange, iFile, string.indexOf("Boo{};//vp1"), 3, "Ooga");
    }

    public void testClass_55_72748() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("class Foo{};//vp1\t\t   \t\n");
        stringWriter.write("void f(){          \t\t\n");
        stringWriter.write("  Foo *somePtr;          \t\t\n");
        stringWriter.write("  if (somePtr == reinterpret_cast<Foo*>(0)){}         \t\t\n");
        stringWriter.write("}                  \t\t\n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("t.cpp", string);
        ISourceReference iSourceReference = this.findElementAtOffset(iFile, string.indexOf("Foo{};//vp1"));
        IChange iChange = this.getRefactorChanges(iSourceReference, "Ooga");
        this.assertTotalChanges(3, iChange);
        this.assertChange(iChange, iFile, string.indexOf("Foo{};//vp1"), 3, "Ooga");
        this.assertChange(iChange, iFile, string.indexOf("Foo *somePtr"), 3, "Ooga");
        this.assertChange(iChange, iFile, string.indexOf("Foo*>(0)"), 3, "Ooga");
    }

    public void testClass_56() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("class Foo{};//vp1,rn1\t\t   \t\n");
        stringWriter.write("class Derived: public Foo{//rn2  \n");
        stringWriter.write("  Derived():Foo(){}//rn3         \n");
        stringWriter.write("};                  \t\t\t\t\n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("t.cpp", string);
        ISourceReference iSourceReference = this.findElementAtOffset(iFile, string.indexOf("Foo{};//vp1"));
        IChange iChange = this.getRefactorChanges(iSourceReference, "Ooga");
        this.assertTotalChanges(3, iChange);
        this.assertChange(iChange, iFile, string.indexOf("Foo{};//vp1"), 3, "Ooga");
        this.assertChange(iChange, iFile, string.indexOf("Foo{//rn2"), 3, "Ooga");
        this.assertChange(iChange, iFile, string.indexOf("Foo(){}//rn3"), 3, "Ooga");
    }

    public void testClass_60() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("class Foo{public: Foo();};//vp1\t\t\n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("Foo.h", string);
        stringWriter = new StringWriter();
        stringWriter.write("#include \"Foo.h\"\t\t   \t\t\t\n");
        stringWriter.write("Foo::Foo{};\t\t   \t\t\t\t    \n");
        String string2 = stringWriter.toString();
        this.importFile("Foo.cpp", string2);
        ISourceReference iSourceReference = this.findElementAtOffset(iFile, string.indexOf("Foo{"));
        this.getRefactorChanges(iSourceReference, "Ooga");
        IResource[] iResourceArray = BaseTestFramework.project.members();
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        while (n < iResourceArray.length) {
            if (iResourceArray[n].getName().equals("Foo.h")) {
                bl = true;
            }
            if (iResourceArray[n].getName().equals("Foo.cpp")) {
                bl2 = true;
            }
            ++n;
        }
        if (!bl || !bl2) {
            Assert.fail((String)"At least one of Foo.h and Foo.cpp was incorrectly renamed.");
        }
    }

    public void testAttribute_61() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("class Foo{\t\t\n");
        stringWriter.write(" private: static int count;//vp1\t\t\n");
        stringWriter.write("};\t\t\n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("Foo.h", string);
        stringWriter = new StringWriter();
        stringWriter.write("#include \"Foo.h\"\t\t   \t\t\t\n");
        stringWriter.write("int Foo::count=10;\t\t   \t\t\t\t    \n");
        String string2 = stringWriter.toString();
        IFile iFile2 = this.importFile("Foo.cpp", string2);
        ISourceReference iSourceReference = this.findElementAtOffset(iFile, string.indexOf("count"));
        IChange iChange = this.getRefactorChanges(iSourceReference, "ooga");
        this.assertTotalChanges(2, iChange);
        this.assertChange(iChange, iFile, string.indexOf("count"), 5, "ooga");
        this.assertChange(iChange, iFile2, string2.indexOf("count"), 5, "ooga");
    }

    public void testEnumerator_62() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("enum Foo{E0, E1};//vp1\t\t\n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("Foo.h", string);
        stringWriter = new StringWriter();
        stringWriter.write("#include \"Foo.h\"\t\t   \t\t\t\n");
        stringWriter.write("void f() {\t\t   \t\t\t\t    \n");
        stringWriter.write(" int i=E1;\t\t   \t\t\t\n");
        stringWriter.write("}\t\t   \t\t\t\t    \n");
        String string2 = stringWriter.toString();
        IFile iFile2 = this.importFile("Foo.cpp", string2);
        ISourceReference iSourceReference = this.findElementAtOffset(iFile, string.indexOf("E1"));
        this.getRefactorChanges(iSourceReference, "Ooga");
        IChange iChange = this.getRefactorChanges(iSourceReference, "ooga");
        this.assertTotalChanges(2, iChange);
        this.assertChange(iChange, iFile, string.indexOf("E1"), 2, "ooga");
        this.assertChange(iChange, iFile2, string2.indexOf("E1"), 2, "ooga");
    }

    public void testAttribute_63() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("class Foo{\t\t\n");
        stringWriter.write(" int att;\t\t\n");
        stringWriter.write(" Foo(int i);\t\t\n");
        stringWriter.write("};\t\t\n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("Foo.h", string);
        stringWriter = new StringWriter();
        stringWriter.write("#include \"Foo.h\"\t\t   \t\t\t\n");
        stringWriter.write("Foo::Foo(int i): att(i) {}\t\t   \t\t\t\t    \n");
        String string2 = stringWriter.toString();
        IFile iFile2 = this.importFile("Foo.cpp", string2);
        ISourceReference iSourceReference = this.findElementAtOffset(iFile, string.indexOf("att"));
        IChange iChange = this.getRefactorChanges(iSourceReference, "ooga");
        this.assertTotalChanges(2, iChange);
        this.assertChange(iChange, iFile, string.indexOf("att"), 3, "ooga");
        this.assertChange(iChange, iFile2, string2.indexOf("att"), 3, "ooga");
    }

    public void testAttribute_64() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("class Foo{\t\t\t\t\n");
        stringWriter.write("   private: \t\t\t\t\n");
        stringWriter.write("   int b;//vp1,rn1\t\t\n");
        stringWriter.write("   int m(int b) {\t\t\n");
        stringWriter.write("   \t\treturn b;\t\t\n");
        stringWriter.write("   }\t\t\t\t\t\t\n");
        stringWriter.write("   int n() {\t\t\t\t\n");
        stringWriter.write("    \t\treturn b;//rn2\t\n");
        stringWriter.write("   }\t\t\t\t\t\t\n");
        stringWriter.write("   int o() {\t\t\t\t\n");
        stringWriter.write("   \t\tint b=2;\t\t\n");
        stringWriter.write("   return b;\t\t\t\t\n");
        stringWriter.write("\t}\t\t\t\t\t\t\n");
        stringWriter.write("};\t\t\t\t\t\t\n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("Foo.h", string);
        ISourceReference iSourceReference = this.findElementAtOffset(iFile, string.indexOf("b;//vp1"));
        IChange iChange = this.getRefactorChanges(iSourceReference, "ooga");
        this.assertTotalChanges(2, iChange);
        this.assertChange(iChange, iFile, string.indexOf("b;//vp1"), 1, "ooga");
        this.assertChange(iChange, iFile, string.indexOf("b;//rn2"), 1, "ooga");
    }

    public void testAttribute_65() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("class A{\t\t\t\t\n");
        stringWriter.write("    int x();\t\t\t\n");
        stringWriter.write("};\t\t\t\t\t\n");
        stringWriter.write("class B{\t\t\t\t\n");
        stringWriter.write("    friend class A;\t\n");
        stringWriter.write("    private: \t\t\n");
        stringWriter.write("    int att;\t\t\t\n");
        stringWriter.write("};\t\t\t\t\t\n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("Foo.h", string);
        stringWriter = new StringWriter();
        stringWriter.write("#include \"Foo.h\"\t\n");
        stringWriter.write("int A::x() {\t\t\t\n");
        stringWriter.write("\tB b;\t\t\t\t\n");
        stringWriter.write("\tint att=b.att;\t\t\n");
        stringWriter.write("} \t\t\t\t\t\n");
        String string2 = stringWriter.toString();
        IFile iFile2 = this.importFile("Foo.cpp", string2);
        ISourceReference iSourceReference = this.findElementAtOffset(iFile, string.indexOf("att"));
        IChange iChange = this.getRefactorChanges(iSourceReference, "ooga");
        this.assertTotalChanges(2, iChange);
        this.assertChange(iChange, iFile, string.indexOf("att"), 3, "ooga");
        this.assertChange(iChange, iFile2, string2.indexOf("att;"), 3, "ooga");
    }

    public void testNamespace_66() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("namespace Foo/*vp1*/{ \t\t\t\n");
        stringWriter.write(" namespace Baz/*vp2*/ {\t\t\t\n");
        stringWriter.write("   int i;   \t\t\t\t\n");
        stringWriter.write(" }\t\t\t\t\t\t\n");
        stringWriter.write(" using namespace Baz;\t\n");
        stringWriter.write("}\t\t\t\t\t\t\n");
        stringWriter.write("void f() {\t\t\t\t\n");
        stringWriter.write("\t Foo::i = 1;\t\t\t\n");
        stringWriter.write("}  \t\t\t\t        \n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("t.cpp", string);
        ISourceReference iSourceReference = this.findElementAtOffset(iFile, string.indexOf("Foo/*vp1*/"));
        IChange iChange = this.getRefactorChanges(iSourceReference, "Ooga");
        this.assertTotalChanges(2, iChange);
        this.assertChange(iChange, iFile, string.indexOf("Foo/*vp1*/"), 3, "Ooga");
        this.assertChange(iChange, iFile, string.indexOf("Foo::"), 3, "Ooga");
        iSourceReference = this.findElementAtOffset(iFile, string.indexOf("Baz/*vp2*/"));
        iChange = this.getRefactorChanges(iSourceReference, "Wooga");
        this.assertTotalChanges(2, iChange);
        this.assertChange(iChange, iFile, string.indexOf("Baz/*vp2*/"), 3, "Wooga");
        this.assertChange(iChange, iFile, string.indexOf("Baz;"), 3, "Wooga");
    }

    public void testNamespace_66_79281() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("namespace Foo{ \t\t\t\n");
        stringWriter.write(" int i; \t\t\t\t\t\n");
        stringWriter.write("} \t\t\t\t\t\t\n");
        stringWriter.write("namespace Bar/*vp1*/ = Foo;\t\t\n");
        stringWriter.write("void f() {\t\t\t\t\n");
        stringWriter.write("  Bar::i = 1;\t\t\t\n");
        stringWriter.write("}  \t\t\t\t        \n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("t.cpp", string);
        ISourceReference iSourceReference = this.findElementAtOffset(iFile, string.indexOf("Bar/*vp1*/"));
        IChange iChange = this.getRefactorChanges(iSourceReference, "Ooga");
        this.assertTotalChanges(2, iChange);
        this.assertChange(iChange, iFile, string.indexOf("Bar/*vp1*/"), 3, "Ooga");
        this.assertChange(iChange, iFile, string.indexOf("Bar::"), 3, "Ooga");
    }

    public void testNamespace_66_79282() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("namespace Foo/*vp1*/{} \t\t\t\n");
        stringWriter.write("namespace Bar = Foo;\t\t\n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("t.cpp", string);
        ISourceReference iSourceReference = this.findElementAtOffset(iFile, string.indexOf("Foo/*vp1*/"));
        IChange iChange = this.getRefactorChanges(iSourceReference, "Ooga");
        this.assertTotalChanges(2, iChange);
        this.assertChange(iChange, iFile, string.indexOf("Foo/*vp1*/"), 3, "Ooga");
        this.assertChange(iChange, iFile, string.indexOf("Foo;"), 3, "Ooga");
    }

    public void testFunction_67() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("void foo/*vp1*/(){}//rn1\t\t\n");
        stringWriter.write("void bar(){\t\t\t\t\t\n");
        stringWriter.write("  foo();//rn2\t\t\t\t\n");
        stringWriter.write("}\t\t\t\t\t\t\t\n");
        stringWriter.write("namespace N{\t\t\t\t\t\n");
        stringWriter.write("  class A{\t\t\t\t\t\n");
        stringWriter.write("  A() {foo();}//rn3\t\t\t\n");
        stringWriter.write("  };\t\t\t\t\t\t\t\n");
        stringWriter.write("}\t\t\t\t\t\t\t\n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("t.cpp", string);
        ISourceReference iSourceReference = this.findElementAtOffset(iFile, string.indexOf("foo/*vp1*/"));
        IChange iChange = this.getRefactorChanges(iSourceReference, "ooga");
        this.assertTotalChanges(3, iChange);
        this.assertChange(iChange, iFile, string.indexOf("foo/*vp1*/"), 3, "ooga");
        this.assertChange(iChange, iFile, string.indexOf("foo();//rn2"), 3, "ooga");
        this.assertChange(iChange, iFile, string.indexOf("foo();}//rn3"), 3, "ooga");
    }

    public void testVariable_68() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("class A{\t\t\t\t\t\n");
        stringWriter.write("  public: int i;\t\t\t\n");
        stringWriter.write("};\t\t\t\t\t\t\n");
        stringWriter.write("A var;//vp1,rn1\t\t\t\n");
        stringWriter.write("void f(){\t\t\t\t\n");
        stringWriter.write("  int j = ::var.i;//rn2\t\n");
        stringWriter.write("}\t\t\t\t\t\t\n");
        stringWriter.write("class B{\t\t\t\t\t\n");
        stringWriter.write("  void g(){\t\t\t\t\n");
        stringWriter.write("    var.i=3;//rn3\t\t\n");
        stringWriter.write("  }\t\t\t\t\t\t\n");
        stringWriter.write("};\t\t\t\t\t\t\n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("t.cpp", string);
        ISourceReference iSourceReference = this.findElementAtOffset(iFile, string.indexOf("var;//vp1"));
        IChange iChange = this.getRefactorChanges(iSourceReference, "ooga");
        this.assertTotalChanges(3, iChange);
        this.assertChange(iChange, iFile, string.indexOf("var;//vp1"), 3, "ooga");
        this.assertChange(iChange, iFile, string.indexOf("var.i;//rn2"), 3, "ooga");
        this.assertChange(iChange, iFile, string.indexOf("var.i=3;//rn3"), 3, "ooga");
    }

    public void testVariable_68_79295() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("int var;//vp1\t\t\t\n");
        stringWriter.write("void f(int var){\t\t\t\n");
        stringWriter.write("  int i = var;\t\t\t\n");
        stringWriter.write("}\t\t\t\t\t\t\n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("t.cpp", string);
        ISourceReference iSourceReference = this.findElementAtOffset(iFile, string.indexOf("var;//vp1"));
        IChange iChange = this.getRefactorChanges(iSourceReference, "ooga");
        this.assertTotalChanges(1, iChange);
        this.assertChange(iChange, iFile, string.indexOf("var;//vp1"), 3, "ooga");
    }

    public void testVariable_69() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("int i;//vp1\t\t\t\n");
        stringWriter.write("in t j;\t\t\t\t\n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("t.cpp", string);
        ISourceReference iSourceReference = this.findElementAtOffset(iFile, string.indexOf("i;//vp1"));
        String[] stringArray = this.getRefactorMessages(iSourceReference, "ooga");
        Assert.assertEquals((int)1, (int)stringArray.length);
        Assert.assertEquals((String)"Code modification may not be accurate as affected resoure 'RegressionTestProject/t.cpp' has compile errors.", (String)stringArray[0]);
    }

    public void testClass_81_72620() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("union u_haul{};\t\t\n");
        stringWriter.write("struct s_haul{};    \t\n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("t.cpp", string);
        ISourceReference iSourceReference = this.findElementAtOffset(iFile, string.indexOf("s_haul"));
        try {
            this.getRefactorChanges(iSourceReference, "u_haul");
        }
        catch (AssertionFailedError assertionFailedError) {
            Assert.assertTrue((boolean)assertionFailedError.getMessage().startsWith("Input check on u_haul failed."));
            return;
        }
        Assert.fail((String)"An error should have occurred in the input check.");
    }

    public void testVariable_88_72617() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("class A{};\t\t\t\t\n");
        stringWriter.write("A a;//vp1\t\t\t\t\n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("Foo.h", string);
        stringWriter = new StringWriter();
        stringWriter.write("#include \"Foo.h\"\t\n");
        stringWriter.write("void f() {\t\t\t\n");
        stringWriter.write("\tA a;\t\t\t\t\n");
        stringWriter.write("} \t\t\t\t\t\n");
        String string2 = stringWriter.toString();
        this.importFile("Foo.cpp", string2);
        ISourceReference iSourceReference = this.findElementAtOffset(iFile, string.indexOf("a;//vp1"));
        IChange iChange = this.getRefactorChanges(iSourceReference, "ooga");
        this.assertTotalChanges(1, iChange);
        this.assertChange(iChange, iFile, string.indexOf("a;//vp1"), 1, "ooga");
    }

    public void testClass_92A() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("class Boo{}; \t\t\n");
        stringWriter.write("  void f() {}    \t\n");
        stringWriter.write("};               \t\n");
        stringWriter.write("class Foo/*vp1*/{}; \t\n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("t.cpp", string);
        ISourceReference iSourceReference = this.findElementAtOffset(iFile, string.indexOf("Foo/*vp1*/"));
        try {
            this.getRefactorChanges(iSourceReference, "Boo");
        }
        catch (AssertionFailedError assertionFailedError) {
            Assert.assertTrue((boolean)assertionFailedError.getMessage().startsWith("Input check on Boo failed."));
            return;
        }
        Assert.fail((String)"An error or warning should have occurred in the input check.");
    }

    public void testClass_92B() throws Exception {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("class A{};\t\t\t\n");
        stringWriter.write("class B{};//vp1\t\t\n");
        String string = stringWriter.toString();
        IFile iFile = this.importFile("t.cpp", string);
        ISourceReference iSourceReference = this.findElementAtOffset(iFile, string.indexOf("B{};//vp1"));
        String[] stringArray = this.getRefactorMessages(iSourceReference, "A");
        Assert.assertEquals((int)1, (int)stringArray.length);
        Assert.assertEquals((String)"Another element named 'A' already exists in 't.cpp'", (String)stringArray[0]);
        int n = this.getRefactorSeverity(iSourceReference, "A");
        Assert.assertEquals((int)4, (int)n);
    }
}

