/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.tests.text.selectiontests;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.core.ICDescriptorOperation;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.index.IIndexDelta;
import org.eclipse.cdt.core.index.IndexChangeEvent;
import org.eclipse.cdt.core.search.DOMSearchUtil;
import org.eclipse.cdt.core.testplugin.FileManager;
import org.eclipse.cdt.internal.core.parser.ParserException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.AbstractTextEditor;

public class BaseSelectionTestsIndexer
extends TestCase {
    public static final int TIMEOUT = 50;
    protected boolean fileIndexed;
    protected IProject project;
    static FileManager fileManager = new FileManager();
    IProgressMonitor monitor = new NullProgressMonitor();

    public BaseSelectionTestsIndexer(String string) {
        super(string);
    }

    public void waitForIndex(int n) throws Exception {
        int n2 = 0;
        while (!this.fileIndexed && n2 < n * 1000) {
            Thread.sleep(50L);
            n2 += 50;
        }
    }

    public void indexChanged(IndexChangeEvent indexChangeEvent) {
        IIndexDelta iIndexDelta = indexChangeEvent.getDelta();
        if (iIndexDelta.getDeltaType() == IIndexDelta.MERGE_DELTA) {
            this.fileIndexed = true;
        }
    }

    protected String getMessage(IStatus iStatus) {
        StringBuffer stringBuffer = new StringBuffer("[");
        stringBuffer.append(iStatus.getMessage());
        if (iStatus.isMultiStatus()) {
            IStatus[] iStatusArray = iStatus.getChildren();
            int n = 0;
            while (n < iStatusArray.length) {
                stringBuffer.append(this.getMessage(iStatusArray[n]));
                ++n;
            }
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    protected IFile importFile(String string, String string2) throws Exception {
        this.resetIndexState();
        IFile iFile = this.project.getProject().getFile(string);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string2.getBytes());
        if (iFile.exists()) {
            iFile.setContents((InputStream)byteArrayInputStream, false, false, this.monitor);
        } else {
            iFile.create((InputStream)byteArrayInputStream, false, this.monitor);
        }
        fileManager.addFile(iFile);
        this.waitForIndex(20);
        return iFile;
    }

    protected IFile importFileWithLink(String string, String string2) throws Exception {
        IFile iFile = this.project.getProject().getFile(string);
        Path path = new Path(String.valueOf(this.project.getLocation().removeLastSegments(1).toOSString()) + File.separator + string);
        File file = new File(path.toOSString());
        if (!file.exists()) {
            file.createNewFile();
        }
        iFile.createLink((IPath)path, 16, null);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string2.getBytes());
        if (iFile.exists()) {
            iFile.setContents((InputStream)byteArrayInputStream, false, false, this.monitor);
        } else {
            iFile.create((InputStream)byteArrayInputStream, false, this.monitor);
        }
        fileManager.addFile(iFile);
        return iFile;
    }

    protected IFile importFileInsideLinkedFolder(String string, String string2, String string3) throws Exception {
        IFolder iFolder = this.project.getFolder(string3);
        Path path = new Path(String.valueOf(this.project.getLocation().toOSString()) + File.separator + string3 + "_this_is_linked");
        IFolder iFolder2 = this.project.getFolder(String.valueOf(string3) + "_this_is_linked");
        if (!iFolder2.exists()) {
            iFolder2.create(true, true, this.monitor);
        }
        iFolder.createLink((IPath)path, 0, this.monitor);
        iFolder2.delete(true, false, this.monitor);
        IFile iFile = iFolder.getFile(string);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string2.getBytes());
        if (iFile.exists()) {
            iFile.setContents((InputStream)byteArrayInputStream, false, false, this.monitor);
        } else {
            iFile.create((InputStream)byteArrayInputStream, false, this.monitor);
        }
        fileManager.addFile(iFile);
        return iFile;
    }

    protected IFolder importFolder(String string) throws Exception {
        IFolder iFolder = this.project.getProject().getFolder(string);
        if (!iFolder.exists()) {
            iFolder.create(false, false, this.monitor);
        }
        return iFolder;
    }

    public void resetIndexState() {
        this.fileIndexed = false;
    }

    protected IASTNode testF3(IFile iFile, int n) throws ParserException {
        return this.testF3(iFile, n, 0);
    }

    protected IASTNode testF3(IFile iFile, int n, int n2) throws ParserException {
        if (n < 0) {
            throw new ParserException("offset can not be less than 0 and was " + n);
        }
        IWorkbenchPage iWorkbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorPart iEditorPart = null;
        try {
            iEditorPart = iWorkbenchPage.openEditor((IEditorInput)new FileEditorInput(iFile), "org.eclipse.cdt.ui.editor.CEditor");
        }
        catch (PartInitException partInitException) {
            Assert.assertFalse((boolean)true);
        }
        if (iEditorPart instanceof AbstractTextEditor) {
            ((AbstractTextEditor)iEditorPart).getSelectionProvider().setSelection((ISelection)new TextSelection(n, n2));
            IAction iAction = ((AbstractTextEditor)iEditorPart).getAction("OpenDeclarations");
            iAction.run();
            iEditorPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
            IEditorInput iEditorInput = iEditorPart.getEditorInput();
            if (iEditorInput instanceof FileEditorInput) {
                iFile = ((FileEditorInput)iEditorInput).getFile();
            } else {
                Assert.assertFalse((boolean)true);
            }
            ISelection iSelection = ((AbstractTextEditor)iEditorPart).getSelectionProvider().getSelection();
            if (iSelection instanceof TextSelection) {
                IASTName[] iASTNameArray = DOMSearchUtil.getSelectedNamesFrom((IFile)iFile, (int)((TextSelection)iSelection).getOffset(), (int)((TextSelection)iSelection).getLength());
                if (iASTNameArray == null || iASTNameArray.length == 0) {
                    return null;
                }
                return iASTNameArray[0];
            }
        }
        return null;
    }

    protected ISelection testF3Selection(IFile iFile, int n) throws ParserException {
        return this.testF3Selection(iFile, n, 0);
    }

    protected ISelection testF3Selection(IFile iFile, int n, int n2) throws ParserException {
        if (n < 0) {
            throw new ParserException("offset can not be less than 0 and was " + n);
        }
        IWorkbenchPage iWorkbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorPart iEditorPart = null;
        try {
            iEditorPart = iWorkbenchPage.openEditor((IEditorInput)new FileEditorInput(iFile), "org.eclipse.cdt.ui.editor.CEditor");
        }
        catch (PartInitException partInitException) {
            Assert.assertFalse((boolean)true);
        }
        if (iEditorPart instanceof AbstractTextEditor) {
            ((AbstractTextEditor)iEditorPart).getSelectionProvider().setSelection((ISelection)new TextSelection(n, n2));
            IAction iAction = ((AbstractTextEditor)iEditorPart).getAction("OpenDeclarations");
            iAction.run();
            iEditorPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
            IEditorInput iEditorInput = iEditorPart.getEditorInput();
            if (iEditorInput instanceof FileEditorInput) {
                iFile = ((FileEditorInput)iEditorInput).getFile();
            } else {
                Assert.assertFalse((boolean)true);
            }
            return ((AbstractTextEditor)iEditorPart).getSelectionProvider().getSelection();
        }
        return null;
    }

    protected IASTNode testCtrl_F3(IFile iFile, int n) throws ParserException {
        return this.testCtrl_F3(iFile, n, 0);
    }

    protected IASTNode testCtrl_F3(IFile iFile, int n, int n2) throws ParserException {
        if (n < 0) {
            throw new ParserException("offset can not be less than 0 and was " + n);
        }
        IWorkbenchPage iWorkbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorPart iEditorPart = null;
        try {
            iEditorPart = iWorkbenchPage.openEditor((IEditorInput)new FileEditorInput(iFile), "org.eclipse.cdt.ui.editor.CEditor");
        }
        catch (PartInitException partInitException) {
            Assert.assertFalse((boolean)true);
        }
        if (iEditorPart instanceof AbstractTextEditor) {
            ((AbstractTextEditor)iEditorPart).getSelectionProvider().setSelection((ISelection)new TextSelection(n, n2));
            IAction iAction = ((AbstractTextEditor)iEditorPart).getAction("OpenDefinition");
            iAction.run();
            iEditorPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
            IEditorInput iEditorInput = iEditorPart.getEditorInput();
            if (iEditorInput instanceof FileEditorInput) {
                iFile = ((FileEditorInput)iEditorInput).getFile();
            } else {
                Assert.assertFalse((boolean)true);
            }
            ISelection iSelection = ((AbstractTextEditor)iEditorPart).getSelectionProvider().getSelection();
            if (iSelection instanceof TextSelection) {
                IASTName[] iASTNameArray = DOMSearchUtil.getSelectedNamesFrom((IFile)iFile, (int)((TextSelection)iSelection).getOffset(), (int)((TextSelection)iSelection).getLength());
                if (iASTNameArray == null || iASTNameArray.length == 0) {
                    return null;
                }
                return iASTNameArray[0];
            }
        }
        return null;
    }

    protected ISelection testCtrl_F3Selection(IFile iFile, int n) throws ParserException {
        return this.testCtrl_F3Selection(iFile, n, 0);
    }

    protected ISelection testCtrl_F3Selection(IFile iFile, int n, int n2) throws ParserException {
        if (n < 0) {
            throw new ParserException("offset can not be less than 0 and was " + n);
        }
        IWorkbenchPage iWorkbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorPart iEditorPart = null;
        try {
            iEditorPart = iWorkbenchPage.openEditor((IEditorInput)new FileEditorInput(iFile), "org.eclipse.cdt.ui.editor.CEditor");
        }
        catch (PartInitException partInitException) {
            Assert.assertFalse((boolean)true);
        }
        if (iEditorPart instanceof AbstractTextEditor) {
            ((AbstractTextEditor)iEditorPart).getSelectionProvider().setSelection((ISelection)new TextSelection(n, n2));
            IAction iAction = ((AbstractTextEditor)iEditorPart).getAction("OpenDefinition");
            iAction.run();
            iEditorPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
            IEditorInput iEditorInput = iEditorPart.getEditorInput();
            if (iEditorInput instanceof FileEditorInput) {
                iFile = ((FileEditorInput)iEditorInput).getFile();
            } else {
                Assert.assertFalse((boolean)true);
            }
            return ((AbstractTextEditor)iEditorPart).getSelectionProvider().getSelection();
        }
        return null;
    }

    protected void testSimple_Ctrl_G_Selection(IFile iFile, int n, int n2, int n3) throws ParserException {
        if (n < 0) {
            throw new ParserException("offset can not be less than 0 and was " + n);
        }
        IWorkbenchPage iWorkbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorPart iEditorPart = null;
        try {
            iEditorPart = iWorkbenchPage.openEditor((IEditorInput)new FileEditorInput(iFile), "org.eclipse.cdt.ui.editor.CEditor");
        }
        catch (PartInitException partInitException) {
            Assert.assertFalse((boolean)true);
        }
        if (iEditorPart instanceof AbstractTextEditor) {
            ((AbstractTextEditor)iEditorPart).getSelectionProvider().setSelection((ISelection)new TextSelection(n, n2));
            IAction iAction = ((AbstractTextEditor)iEditorPart).getAction("org.eclipse.cdt.ui.search.finddecl");
            iAction.run();
        }
    }

    public void resetIndexer(final String string) {
        if (this.project != null) {
            ICDescriptorOperation iCDescriptorOperation = new ICDescriptorOperation(){

                public void execute(ICDescriptor iCDescriptor, IProgressMonitor iProgressMonitor) throws CoreException {
                    iCDescriptor.remove("org.eclipse.cdt.core.CIndexer");
                    iCDescriptor.create("org.eclipse.cdt.core.CIndexer", string);
                }
            };
            try {
                CCorePlugin.getDefault().getCDescriptorManager().runDescriptorOperation(this.project, iCDescriptorOperation, (IProgressMonitor)new NullProgressMonitor());
                CCorePlugin.getDefault().getCoreModel().getIndexManager().indexerChangeNotification(this.project);
            }
            catch (CoreException coreException) {}
        }
    }
}

