/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.core.tests;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IProjectType;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.ManagedCProjectNature;
import org.eclipse.cdt.managedbuilder.core.tests.ManagedBuildEnvironmentTests;
import org.eclipse.cdt.managedbuilder.envvar.IBuildEnvironmentVariable;
import org.eclipse.cdt.managedbuilder.internal.envvar.EnvironmentVariableProvider;
import org.eclipse.cdt.managedbuilder.internal.envvar.UserDefinedEnvironmentSupplier;
import org.eclipse.cdt.managedbuilder.internal.macros.FileContextData;
import org.eclipse.cdt.managedbuilder.internal.macros.OptionContextData;
import org.eclipse.cdt.managedbuilder.internal.macros.UserDefinedMacroSupplier;
import org.eclipse.cdt.managedbuilder.macros.BuildMacroException;
import org.eclipse.cdt.managedbuilder.macros.IBuildMacro;
import org.eclipse.cdt.managedbuilder.macros.IBuildMacroProvider;
import org.eclipse.cdt.managedbuilder.macros.IBuildMacroSupplier;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;

public class ManagedBuildMacrosTests
extends TestCase {
    static IProject proj = null;
    static IManagedProject mproj = null;
    IConfiguration[] cfgs = null;
    IBuildMacroProvider mp = null;
    IWorkspace worksp = null;
    boolean windows = false;
    boolean print = false;
    boolean flag = false;
    IBuildMacroSupplier[] ms = null;
    public static int functionCalled = 0;
    public static final int GET_ONE_PROJECT = 1;
    public static final int GET_MANY_PROJECT = 2;
    public static final int GET_ONE_CONFIG = 4;
    public static final int GET_MANY_CONFIG = 8;
    public static final int RESERVED_NAME = 16;
    static final String UNKNOWN = "<HZ>";
    static final String LISTSEP = "|";
    static final String TEST = "TEST";
    static final String[] TST = new String[]{"DUMMY", "FILETEST", "OPTTEST", "CFGTEST", "PRJTEST", "WSPTEST", "INSTEST", "ENVTEST"};
    final String OPT_IDS = "macro.test.string";
    final String OPT_IDL = "macro.test.list";
    final String INC_DEF = "${IncludeDefaults}";
    static /* synthetic */ Class class$0;

    public ManagedBuildMacrosTests() {
    }

    public ManagedBuildMacrosTests(String string) {
        super(string);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.managedbuilder.core.tests.ManagedBuildMacrosTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite testSuite = new TestSuite(clazz.getName());
        testSuite.addTest((Test)new ManagedBuildMacrosTests("testMacroConf"));
        testSuite.addTest((Test)new ManagedBuildMacrosTests("testMacroEEnv"));
        testSuite.addTest((Test)new ManagedBuildMacrosTests("testMacroInst"));
        testSuite.addTest((Test)new ManagedBuildMacrosTests("testMacroProj"));
        testSuite.addTest((Test)new ManagedBuildMacrosTests("testMacroWrks"));
        testSuite.addTest((Test)new ManagedBuildMacrosTests("testMacroOptS"));
        testSuite.addTest((Test)new ManagedBuildMacrosTests("testMacroOptL"));
        testSuite.addTest((Test)new ManagedBuildMacrosTests("testMacroFile"));
        testSuite.addTest((Test)new ManagedBuildMacrosTests("testMacroContext"));
        testSuite.addTest((Test)new ManagedBuildMacrosTests("testMacroResolve"));
        testSuite.addTest((Test)new ManagedBuildMacrosTests("testMacroResolveExceptions"));
        testSuite.addTest((Test)new ManagedBuildMacrosTests("testMacroResolveLoop"));
        testSuite.addTest((Test)new ManagedBuildMacrosTests("testMacroResolveMake"));
        testSuite.addTest((Test)new ManagedBuildMacrosTests("testMacroResolveCase"));
        testSuite.addTest((Test)new ManagedBuildMacrosTests("testMacroSave"));
        return testSuite;
    }

    public void testMacroConf() {
        this.doInit();
        this.ms = this.mp.getSuppliers(3, (Object)this.cfgs[0]);
        Assert.assertNotNull((Object)this.ms);
        Assert.assertEquals((int)this.ms.length, (int)4);
        Assert.assertTrue((boolean)this.addMacro(TEST, 1, TST[3], 3, (Object)this.cfgs[0]));
        functionCalled = 0;
        String[] stringArray = this.printMacros(this.mp.getMacros(3, (Object)this.cfgs[0], this.flag), "Configuration");
        Assert.assertEquals((int)8, (int)functionCalled);
        String[] stringArray2 = new String[]{"ConfigName", "BuildArtifactFileExt", "BuildArtifactFileBaseName", "TargetArchList", "TargetOsList", "BuildArtifactFileName", "PWD", "CWD", "ConfigDescription", TEST, "NEW_FOR_CFG"};
        Assert.assertTrue((boolean)this.arrayContains(stringArray2, stringArray));
    }

    public void testMacroEEnv() {
        this.doInit();
        this.ms = this.mp.getSuppliers(7, null);
        Assert.assertNotNull((Object)this.ms);
        Assert.assertEquals((int)this.ms.length, (int)1);
        Assert.assertFalse((boolean)this.addMacro(TEST, 1, TST[7], 7, null));
        this.printMacros(this.mp.getMacros(7, null, this.flag), "EclipseEnv");
    }

    public void testMacroInst() {
        this.doInit();
        this.ms = this.mp.getSuppliers(6, null);
        Assert.assertNotNull((Object)this.ms);
        Assert.assertEquals((int)this.ms.length, (int)1);
        Assert.assertFalse((boolean)this.addMacro(TEST, 1, TST[6], 6, null));
        String[] stringArray = this.printMacros(this.mp.getMacros(6, null, this.flag), "Installations ");
        String[] stringArray2 = new String[]{"HostArchName", "MBSVersion", "EclipseVersion", "HostOsName", "CDTVersion"};
        Assert.assertTrue((boolean)this.arrayContains(stringArray2, stringArray));
    }

    public void testMacroProj() {
        this.doInit();
        this.ms = this.mp.getSuppliers(4, (Object)mproj);
        Assert.assertNotNull((Object)this.ms);
        Assert.assertEquals((int)this.ms.length, (int)4);
        Assert.assertTrue((boolean)this.addMacro(TEST, 1, TST[4], 4, (Object)mproj));
        functionCalled = 0;
        String[] stringArray = this.printMacros(this.mp.getMacros(4, (Object)mproj, this.flag), "Project ");
        Assert.assertEquals((int)2, (int)functionCalled);
        String[] stringArray2 = new String[]{"ProjDirPath", "ProjName", TEST, "NEW_FOR_PRJ"};
        Assert.assertTrue((boolean)this.arrayContains(stringArray2, stringArray));
    }

    public void testMacroWrks() {
        this.doInit();
        this.ms = this.mp.getSuppliers(5, (Object)this.worksp);
        Assert.assertNotNull((Object)this.ms);
        Assert.assertEquals((int)this.ms.length, (int)5);
        Assert.assertTrue((boolean)this.addMacro(TEST, 1, TST[5], 5, (Object)this.worksp));
        String[] stringArray = this.printMacros(this.mp.getMacros(5, (Object)this.worksp, this.flag), "Workspace ");
        String[] stringArray2 = new String[]{"DirectoryDelimiter", "WorkspaceDirPath", "PathDelimiter", TEST};
        Assert.assertTrue((boolean)this.arrayContains(stringArray2, stringArray));
    }

    public void testMacroOptS() {
        Object object;
        this.doInit();
        this.cfgs[0].getToolChain();
        ITool iTool = this.cfgs[0].getTools()[0];
        IOption iOption = iTool.getOptionById("macro.test.string");
        Assert.assertNotNull((Object)iOption);
        this.ms = this.mp.getSuppliers(2, (Object)new OptionContextData(iOption, (IBuildObject)iTool));
        Assert.assertNotNull((Object)this.ms);
        Assert.assertEquals((int)this.ms.length, (int)1);
        Assert.assertFalse((boolean)this.addMacro(TEST, 1, TST[2], 2, (Object)new OptionContextData(iOption, (IBuildObject)iTool)));
        try {
            iOption = this.cfgs[0].setOption((IHoldsOptions)iTool, iOption, "222 ${IncludeDefaults}");
            object = this.mp.resolveValue(iOption.getStringValue(), UNKNOWN, LISTSEP, 2, (Object)new OptionContextData(iOption, (IBuildObject)iTool));
            Assert.assertEquals((String)object, (String)"222 111");
        }
        catch (BuildMacroException buildMacroException) {
            Assert.fail((String)buildMacroException.getLocalizedMessage());
        }
        catch (BuildException buildException) {
            Assert.fail((String)buildException.getLocalizedMessage());
        }
        object = this.cfgs[0].createResourceConfiguration(this.getFile());
        Assert.assertNotNull((Object)object);
        IOption iOption2 = object.getTools()[0].getOptionById("macro.test.string");
        try {
            iOption2 = object.setOption((IHoldsOptions)object.getTools()[0], iOption2, "333 ${IncludeDefaults}");
            String string = this.mp.resolveValue(iOption2.getStringValue(), UNKNOWN, LISTSEP, 2, (Object)new OptionContextData(iOption, (IBuildObject)iTool));
            Assert.assertEquals((String)string, (String)"333 111");
        }
        catch (Exception exception) {
            Assert.fail((String)exception.getLocalizedMessage());
        }
    }

    public void testMacroOptL() {
        this.doInit();
        this.cfgs[0].getToolChain();
        ITool iTool = this.cfgs[0].getTools()[0];
        IOption iOption = iTool.getOptionById("macro.test.list");
        OptionContextData optionContextData = new OptionContextData(iOption, (IBuildObject)iTool);
        Assert.assertNotNull((Object)iOption);
        this.ms = this.mp.getSuppliers(2, (Object)optionContextData);
        Assert.assertNotNull((Object)this.ms);
        Assert.assertEquals((int)this.ms.length, (int)1);
        try {
            String[] stringArray = iOption.getStringListValue();
            Assert.assertNotNull((Object)stringArray);
            String[] stringArray2 = new String[]{"new a", "test=${TEST}", "${IncludeDefaults}", "${PATH}", "PRJ=${NEW_FOR_PRJ}", "LIST=${IncludeDefaults}"};
            String[] stringArray3 = new String[]{"new a", "test=CFGTEST", "x", "y", "z", ":", "PRJ=<HZ>", "LIST=x|y|z"};
            try {
                stringArray3[5] = this.mp.resolveValue("${PATH}", UNKNOWN, LISTSEP, 2, (Object)optionContextData);
            }
            catch (BuildMacroException buildMacroException) {
                Assert.fail((String)buildMacroException.getLocalizedMessage());
            }
            iOption = this.cfgs[0].setOption((IHoldsOptions)iTool, iOption, stringArray2);
            Assert.assertNotNull((Object)iOption);
            ArrayList<String> arrayList = new ArrayList<String>(1);
            int n = 0;
            while (n < stringArray2.length) {
                try {
                    String[] stringArray4 = this.mp.resolveStringListValue(stringArray2[n], UNKNOWN, LISTSEP, 2, (Object)new OptionContextData(iOption, (IBuildObject)iTool));
                    if (stringArray4 != null) {
                        int n2 = 0;
                        while (n2 < stringArray4.length) {
                            arrayList.add(stringArray4[n2]);
                            ++n2;
                        }
                    }
                }
                catch (BuildMacroException buildMacroException) {
                    Assert.fail((String)buildMacroException.getLocalizedMessage());
                }
                ++n;
            }
            String[] stringArray5 = arrayList.toArray(new String[0]);
            Assert.assertEquals((int)stringArray5.length, (int)stringArray3.length);
            int n3 = 0;
            while (n3 < stringArray5.length) {
                Assert.assertEquals((String)stringArray5[n3], (String)stringArray3[n3]);
                ++n3;
            }
        }
        catch (BuildException buildException) {
            Assert.fail((String)buildException.getLocalizedMessage());
        }
    }

    public void testMacroFile() {
        String[] stringArray = new String[]{"InputFileName", "InputFileExt", "InputFileBaseName", "InputFileRelPath", "InputDirRelPath", "OutputFileName", "OutputFileExt", "OutputFileBaseName", "OutputFileRelPath", "OutputDirRelPath"};
        String[] stringArray2 = new String[]{"a.f77", "f77", "a", "\\xz\\a.f77", "\\xz\\", "b.exe", "exe", "b", "\\tmp\\b.exe", "\\tmp\\"};
        String[] stringArray3 = new String[]{"ein.c", "c", "ein", "..\\..\\ein.c", "..\\..\\", "aus.o", "o", "aus", "..\\..\\aus.o", "..\\..\\"};
        String[] stringArray4 = new String[]{"ein.c", "c", "ein", "../../ein.c", "../../", "aus.o", "o", "aus", "../../aus.o", "../../"};
        String[] stringArray5 = new String[]{"$(notdir $<)", "$(suffix $(notdir $<))", "$(basename $(notdir $<))", "$<", "$(dir $<)", "$(notdir $@)", "$(suffix $(notdir $@))", "$(basename $(notdir $@))", "$@", "$(dir $@)"};
        FileContextData fileContextData = null;
        this.doInit();
        ITool iTool = this.cfgs[0].getTools()[0];
        Assert.assertNotNull((Object)iTool);
        IOption iOption = iTool.getOptionById("macro.test.string");
        String string = null;
        try {
            string = this.mp.getMacro("WorkspaceDirPath", 5, (Object)this.worksp, this.flag).getStringValue();
        }
        catch (BuildMacroException buildMacroException) {
            Assert.fail((String)buildMacroException.getLocalizedMessage());
        }
        IPath iPath = new Path(string).addTrailingSeparator();
        if (this.windows) {
            IBuildEnvironmentVariable iBuildEnvironmentVariable = ManagedBuildManager.getEnvironmentVariableProvider().getVariable("CWD", (Object)this.cfgs[0], false, true);
            String string2 = Path.fromOSString((String)iBuildEnvironmentVariable.getValue()).getDevice().toUpperCase();
            String string3 = string2.startsWith("C") ? "D:" : "C:";
            stringArray2[3] = String.valueOf(string3) + stringArray2[3];
            stringArray2[4] = String.valueOf(string3) + stringArray2[4];
            stringArray2[8] = String.valueOf(string3) + stringArray2[8];
            stringArray2[9] = String.valueOf(string3) + stringArray2[9];
            fileContextData = new FileContextData((IPath)new Path(stringArray2[3]), (IPath)new Path(stringArray2[8]), iOption, (IBuildObject)iTool);
            int n = 0;
            while (n < stringArray.length) {
                try {
                    Assert.assertEquals((String)stringArray2[n], (String)this.mp.getMacro(stringArray[n], 1, (Object)fileContextData, this.flag).getStringValue());
                }
                catch (BuildMacroException buildMacroException) {
                    Assert.fail((String)buildMacroException.getLocalizedMessage());
                }
                ++n;
            }
            fileContextData = new FileContextData(iPath.append("ein.c"), iPath.append("aus.o"), iOption, (IBuildObject)iTool);
            n = 0;
            while (n < stringArray.length) {
                try {
                    Assert.assertEquals((String)stringArray3[n], (String)this.mp.getMacro(stringArray[n], 1, (Object)fileContextData, this.flag).getStringValue());
                }
                catch (BuildMacroException buildMacroException) {
                    Assert.fail((String)buildMacroException.getLocalizedMessage());
                }
                ++n;
            }
        } else {
            fileContextData = new FileContextData(iPath.append("ein.c"), iPath.append("aus.o"), iOption, (IBuildObject)iTool);
            int n = 0;
            while (n < stringArray.length) {
                try {
                    Assert.assertEquals((String)stringArray4[n], (String)this.mp.getMacro(stringArray[n], 1, (Object)fileContextData, this.flag).getStringValue());
                }
                catch (BuildMacroException buildMacroException) {
                    Assert.fail((String)buildMacroException.getLocalizedMessage());
                }
                ++n;
            }
        }
        Assert.assertNotNull((Object)fileContextData);
        this.ms = this.mp.getSuppliers(1, (Object)fileContextData);
        Assert.assertNotNull((Object)this.ms);
        Assert.assertEquals((int)this.ms.length, (int)1);
        Assert.assertFalse((boolean)this.addMacro(TEST, 1, TST[1], 1, (Object)fileContextData));
        iOption = this.cfgs[1].getTools()[0].getOptions()[0];
        fileContextData = new FileContextData(iPath.append("ein.c"), iPath.append("aus.o"), iOption, (IBuildObject)this.cfgs[1].getTools()[0]);
        int n = 0;
        while (n < stringArray.length) {
            try {
                Assert.assertEquals((String)stringArray5[n], (String)this.mp.getMacro(stringArray[n], 1, (Object)fileContextData, this.flag).getStringValue());
            }
            catch (BuildMacroException buildMacroException) {
                Assert.fail((String)buildMacroException.getLocalizedMessage());
            }
            ++n;
        }
    }

    public void testMacroContext() {
        this.doInit();
        IBuildMacro iBuildMacro = this.mp.getMacro(TEST, 3, (Object)this.cfgs[0], true);
        IBuildMacro iBuildMacro2 = this.mp.getMacro(TEST, 4, (Object)mproj, true);
        IBuildMacro iBuildMacro3 = this.mp.getMacro(TEST, 5, (Object)this.worksp, true);
        Assert.assertNotNull((Object)iBuildMacro);
        Assert.assertNotNull((Object)iBuildMacro2);
        Assert.assertNotNull((Object)iBuildMacro3);
        try {
            Assert.assertEquals((String)iBuildMacro.getStringValue(), (String)TST[3]);
            Assert.assertEquals((String)iBuildMacro2.getStringValue(), (String)TST[4]);
            Assert.assertEquals((String)iBuildMacro3.getStringValue(), (String)TST[5]);
        }
        catch (BuildMacroException buildMacroException) {
            Assert.fail((String)buildMacroException.getLocalizedMessage());
        }
    }

    public void testMacroResolve() {
        this.doInit();
        this.ms = this.mp.getSuppliers(5, (Object)this.worksp);
        Assert.assertNotNull((Object)this.ms);
        String[] stringArray = new String[]{"SCHEISE", "MERDE", "SHIT"};
        Assert.assertTrue((boolean)this.addMacro("LST", 2, stringArray, 5, (Object)this.worksp));
        Assert.assertTrue((boolean)this.addMacro("ONE", 1, "EIN", 5, (Object)this.worksp));
        Assert.assertTrue((boolean)this.addMacro("L1", 1, "nested L1-${L2}-L1", 5, (Object)this.worksp));
        Assert.assertTrue((boolean)this.addMacro("L2", 1, "L2-${L3}-L2", 5, (Object)this.worksp));
        Assert.assertTrue((boolean)this.addMacro("L3", 1, "L3-${L4}-L3", 5, (Object)this.worksp));
        Assert.assertTrue((boolean)this.addMacro("L4", 1, "L4", 5, (Object)this.worksp));
        this.ms = this.mp.getSuppliers(4, (Object)mproj);
        Assert.assertNotNull((Object)this.ms);
        Assert.assertTrue((boolean)this.addMacro("TWO", 1, "ZWEI", 4, (Object)mproj));
        this.ms = this.mp.getSuppliers(3, (Object)this.cfgs[0]);
        Assert.assertNotNull((Object)this.ms);
        Assert.assertTrue((boolean)this.addMacro("three", 1, "DREI", 3, (Object)this.cfgs[0]));
        try {
            String string = this.mp.resolveValue("${ONE} - ${TWO} - ${three} -> ${LST}", UNKNOWN, LISTSEP, 3, (Object)this.cfgs[0]);
            String string2 = this.mp.resolveValue("${ONE} - ${TWO} - ${three} -> ${LST}", UNKNOWN, LISTSEP, 4, (Object)mproj);
            String string3 = this.mp.resolveValue("${ONE} - ${TWO} - ${three} -> ${LST}", UNKNOWN, LISTSEP, 5, (Object)this.worksp);
            String string4 = this.mp.resolveValue("${L1}", UNKNOWN, LISTSEP, 5, (Object)this.worksp);
            String string5 = this.mp.resolveValue("${one} - ${Two} - ${THREE} -> ${lst}", UNKNOWN, LISTSEP, 3, (Object)this.cfgs[0]);
            Assert.assertEquals((String)string, (String)"EIN - ZWEI - DREI -> SCHEISE|MERDE|SHIT");
            Assert.assertEquals((String)string2, (String)"EIN - ZWEI - <HZ> -> SCHEISE|MERDE|SHIT");
            Assert.assertEquals((String)string3, (String)"EIN - <HZ> - <HZ> -> SCHEISE|MERDE|SHIT");
            Assert.assertEquals((String)string4, (String)"nested L1-L2-L3-L4-L3-L2-L1");
            Assert.assertEquals((String)string5, (String)"<HZ> - <HZ> - <HZ> -> <HZ>");
        }
        catch (BuildMacroException buildMacroException) {
            Assert.fail((String)("Exception while resolving: " + buildMacroException.getLocalizedMessage()));
        }
    }

    public void testMacroResolveExceptions() {
        this.doInit();
        boolean bl = false;
        try {
            this.mp.resolveValue("${ONE} - ${ZERO}", null, null, 3, (Object)this.cfgs[0]);
        }
        catch (BuildMacroException buildMacroException) {
            bl = true;
        }
        Assert.assertTrue((String)"Exception not raised for undefined macro", (boolean)bl);
        bl = false;
        try {
            this.mp.resolveValue("${LST}", null, null, 3, (Object)this.cfgs[0]);
        }
        catch (BuildMacroException buildMacroException) {
            bl = true;
        }
        Assert.assertTrue((String)"Exception not raised for undefined delimiter", (boolean)bl);
    }

    public void testMacroResolveLoop() {
        this.doInit();
        int n = 5;
        IWorkspace iWorkspace = this.worksp;
        this.ms = this.mp.getSuppliers(n, (Object)iWorkspace);
        Assert.assertNotNull((Object)this.ms);
        try {
            this.mp.checkIntegrity(n, (Object)iWorkspace);
        }
        catch (BuildMacroException buildMacroException) {
            Assert.fail((String)"Macros integrity check is failed");
        }
        Assert.assertTrue((boolean)this.addMacro("B1", 1, "B1-${B2}", n, (Object)iWorkspace));
        this.rmMacro("B2", n, iWorkspace);
        try {
            this.mp.checkIntegrity(n, (Object)iWorkspace);
            Assert.fail((String)"Macros misintegrity (ref to undefined) is not detected");
        }
        catch (BuildMacroException buildMacroException) {}
        Assert.assertTrue((boolean)this.addMacro("B2", 1, "B2-${B3}", n, (Object)iWorkspace));
        Assert.assertTrue((boolean)this.addMacro("B3", 1, "B3-${B1}", n, (Object)iWorkspace));
        try {
            this.mp.checkIntegrity(n, (Object)iWorkspace);
            Assert.fail((String)"Macros misintegrity (dead loop) is not detected");
        }
        catch (BuildMacroException buildMacroException) {}
        Assert.assertTrue((boolean)this.rmMacro("B1", n, iWorkspace));
        Assert.assertTrue((boolean)this.rmMacro("B2", n, iWorkspace));
        Assert.assertTrue((boolean)this.rmMacro("B3", n, iWorkspace));
        try {
            this.mp.checkIntegrity(n, (Object)iWorkspace);
        }
        catch (BuildMacroException buildMacroException) {
            Assert.fail((String)("Macros integrity check is failed " + buildMacroException.getLocalizedMessage()));
        }
    }

    public void testMacroResolveMake() {
        String string;
        Object object;
        this.doInit();
        try {
            object = EnvironmentVariableProvider.fUserSupplier;
            object.createVariable("PATH", "", 3, null, (Object)this.worksp);
            object.createVariable("USERNAME", "", 3, null, (Object)this.worksp);
            functionCalled = 0;
            string = this.mp.resolveValueToMakefileFormat("USERNAME: ${USERNAME} PATH: ${PATH} HostOsName: ${HostOsName} WorkspaceDirPath: ${WorkspaceDirPath}", UNKNOWN, LISTSEP, 3, (Object)this.cfgs[0]);
            String string2 = "USERNAME: @USERNAME PATH: " + this.mp.resolveValue("${PATH} HostOsName: ${HostOsName} WorkspaceDirPath: ${WorkspaceDirPath}", UNKNOWN, LISTSEP, 3, (Object)this.cfgs[0]);
            Assert.assertEquals((String)string, (String)string2);
            string = this.mp.resolveValueToMakefileFormat("USERNAME: ${USERNAME} PATH: ${PATH} HostOsName: ${HostOsName} WorkspaceDirPath: ${WorkspaceDirPath}", UNKNOWN, LISTSEP, 4, (Object)mproj);
            Assert.assertEquals((String)string, (String)string2);
        }
        catch (BuildMacroException buildMacroException) {
            Assert.fail((String)buildMacroException.getLocalizedMessage());
        }
        try {
            object = this.mp.resolveValue("USERNAME: ${USERNAME} PATH: ${PATH} HostOsName: ${HostOsName} WorkspaceDirPath: ${WorkspaceDirPath}", UNKNOWN, LISTSEP, 3, (Object)this.cfgs[1]);
            string = this.mp.resolveValueToMakefileFormat("USERNAME: ${USERNAME} PATH: ${PATH} HostOsName: ${HostOsName} WorkspaceDirPath: ${WorkspaceDirPath}", UNKNOWN, LISTSEP, 3, (Object)this.cfgs[1]);
            Assert.assertEquals((String)object, (String)string);
        }
        catch (BuildMacroException buildMacroException) {
            Assert.fail((String)buildMacroException.getLocalizedMessage());
        }
        Assert.assertEquals((int)(functionCalled & 0x10), (int)0);
        try {
            object = this.mp.resolveValue("USERNAME: ${USERNAME} ", UNKNOWN, LISTSEP, 3, (Object)this.cfgs[2]);
            string = this.mp.resolveValue("HostOsName: ${HostOsName} WorkspaceDirPath: ${WorkspaceDirPath}", UNKNOWN, LISTSEP, 3, (Object)this.cfgs[2]);
            object = String.valueOf(object) + "PATH: " + "@PATH " + string;
            string = this.mp.resolveValueToMakefileFormat("USERNAME: ${USERNAME} PATH: ${PATH} HostOsName: ${HostOsName} WorkspaceDirPath: ${WorkspaceDirPath}", UNKNOWN, LISTSEP, 3, (Object)this.cfgs[2]);
            Assert.assertEquals((String)object, (String)string);
            Assert.assertEquals((int)(functionCalled & 0x10), (int)16);
        }
        catch (BuildMacroException buildMacroException) {
            Assert.fail((String)buildMacroException.getLocalizedMessage());
        }
    }

    public void testMacroResolveCase() {
        this.doInit();
        this.addVars();
        String string = null;
        String string2 = null;
        try {
            string = this.mp.resolveValueToMakefileFormat("${CASETEST} ${CaseTest} ${casetest} ${CaSeTeSt}", UNKNOWN, LISTSEP, 3, (Object)this.cfgs[0]);
            string2 = this.mp.resolveValueToMakefileFormat("${CASETEST} ${CaseTest} ${casetest} ${CaSeTeSt}", UNKNOWN, LISTSEP, 3, (Object)this.cfgs[3]);
        }
        catch (BuildMacroException buildMacroException) {
            Assert.fail((String)buildMacroException.getLocalizedMessage());
        }
        if (this.windows) {
            Assert.assertEquals(string, (String)"@CASETEST uppercase uppercase uppercase");
            Assert.assertEquals(string2, (String)"@CASETEST @CASETEST @CASETEST @CASETEST");
        } else {
            Assert.assertEquals(string, (String)"@CASETEST capitalize lowercase upper2low");
            Assert.assertEquals(string2, (String)"@CASETEST @CaseTest @casetest @CaSeTeSt");
        }
    }

    public void testMacroSave() {
        this.doInit();
        this.ms = this.mp.getSuppliers(4, (Object)mproj);
        Assert.assertNotNull((Object)this.ms);
        Assert.assertTrue((boolean)this.addMacro("TO_SAVE_P", 1, "TO_SAVE_P", 4, (Object)mproj));
        this.ms = this.mp.getSuppliers(5, (Object)this.worksp);
        Assert.assertNotNull((Object)this.ms);
        Assert.assertTrue((boolean)this.addMacro("TO_SAVE_W", 1, "TO_SAVE_W", 5, (Object)this.worksp));
        try {
            ManagedBuildManager.saveBuildInfo((IProject)proj, (boolean)true);
            ManagedBuildManager.removeBuildInfo((IResource)proj);
            proj.close(null);
            proj.open(null);
        }
        catch (CoreException coreException) {
            Assert.fail((String)("Failed on project close/open: " + coreException.getLocalizedMessage()));
        }
        this.ms = this.mp.getSuppliers(4, (Object)mproj);
        Assert.assertNotNull((Object)this.ms);
        String[] stringArray = this.printMacros(this.mp.getMacros(4, (Object)mproj, this.flag), "TO_SAVE_P");
        String[] stringArray2 = new String[]{"TO_SAVE_P"};
        Assert.assertTrue((boolean)this.arrayContains(stringArray2, stringArray));
        this.ms = this.mp.getSuppliers(5, (Object)this.worksp);
        Assert.assertNotNull((Object)this.ms);
        stringArray = this.printMacros(this.mp.getMacros(5, (Object)this.worksp, this.flag), "TO_SAVE_W");
        String[] stringArray3 = new String[]{"TO_SAVE_W"};
        Assert.assertTrue((boolean)this.arrayContains(stringArray3, stringArray));
    }

    private String[] printMacros(IBuildMacro[] iBuildMacroArray, String string) {
        ArrayList<String> arrayList = new ArrayList<String>(0);
        if (iBuildMacroArray != null) {
            if (iBuildMacroArray.length > 0) {
                int n = 0;
                while (n < iBuildMacroArray.length) {
                    try {
                        arrayList.add(iBuildMacroArray[n].getName());
                        if (this.print) {
                            if (iBuildMacroArray[n].getMacroValueType() % 2 == 1) {
                                if (iBuildMacroArray[n].getName().endsWith("prompt")) {
                                    System.out.println(String.valueOf(string) + "[" + n + "] " + iBuildMacroArray[n].getName() + " = <UNREACHABLE>");
                                } else {
                                    System.out.println(String.valueOf(string) + "[" + n + "] " + iBuildMacroArray[n].getName() + " = " + iBuildMacroArray[n].getStringValue());
                                }
                            } else {
                                System.out.println(String.valueOf(string) + "[" + n + "] " + iBuildMacroArray[n].getName() + ":");
                                String[] stringArray = iBuildMacroArray[n].getStringListValue();
                                this.printStrings(stringArray, "    ");
                            }
                        }
                    }
                    catch (Exception exception) {}
                    ++n;
                }
            } else if (this.print) {
                System.out.println(String.valueOf(string) + ": array is empty");
            }
        } else if (this.print) {
            System.out.println(String.valueOf(string) + ": array is null");
        }
        return arrayList.toArray(new String[0]);
    }

    private void printStrings(String[] stringArray, String string) {
        if (!this.print) {
            return;
        }
        if (stringArray != null) {
            if (stringArray.length > 0) {
                int n = 0;
                while (n < stringArray.length) {
                    System.out.println(String.valueOf(string) + stringArray[n]);
                    ++n;
                }
            } else {
                System.out.println(String.valueOf(string) + ": array is empty");
            }
        } else {
            System.out.println(String.valueOf(string) + ": array is null");
        }
    }

    static void createManagedProject(String string) {
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        proj = iWorkspaceRoot.getProject(string);
        if (proj.exists()) {
            mproj = ManagedBuildManager.getBuildInfo((IResource)proj).getManagedProject();
        } else {
            ICDescriptor iCDescriptor;
            IProjectType iProjectType;
            IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
            IWorkspaceDescription iWorkspaceDescription = iWorkspace.getDescription();
            iWorkspaceDescription.setAutoBuilding(false);
            try {
                iWorkspace.setDescription(iWorkspaceDescription);
                proj = CCorePlugin.getDefault().createCProject(iWorkspace.newProjectDescription(proj.getName()), proj, (IProgressMonitor)new NullProgressMonitor(), MakeCorePlugin.MAKE_PROJECT_ID);
                iProjectType = ManagedBuildManager.createBuildInfo((IResource)proj);
                iProjectType.setValid(true);
                ManagedCProjectNature.addManagedNature((IProject)proj, null);
                ManagedCProjectNature.addManagedBuilder((IProject)proj, null);
                iCDescriptor = CCorePlugin.getDefault().getCProjectDescription(proj, true);
                iCDescriptor.remove("org.eclipse.cdt.core.ScannerInfoProvider");
                iCDescriptor.create("org.eclipse.cdt.core.ScannerInfoProvider", ManagedBuildManager.INTERFACE_IDENTITY);
                iCDescriptor.saveProjectData();
            }
            catch (CoreException coreException) {
                Assert.fail((String)("Cannot create project: " + coreException.getLocalizedMessage()));
            }
            ManagedBuildManager.getDefinedProjectTypes();
            iProjectType = ManagedBuildManager.getProjectType((String)"cdt.managedbuild.target.testenv.exe");
            Assert.assertNotNull((Object)iProjectType);
            try {
                mproj = ManagedBuildManager.createManagedProject((IResource)proj, (IProjectType)iProjectType);
            }
            catch (BuildException buildException) {}
            ManagedBuildManager.setNewProjectVersion((IProject)proj);
            iCDescriptor = iProjectType.getConfigurations();
            IConfiguration iConfiguration = ((IConfiguration[])iCDescriptor).length > 0 ? mproj.createConfiguration((IConfiguration)iCDescriptor[0], String.valueOf(iProjectType.getId()) + ".0") : null;
            int n = 1;
            while (n < ((ICDescriptor)iCDescriptor).length) {
                mproj.createConfiguration((IConfiguration)iCDescriptor[n], String.valueOf(iProjectType.getId()) + "." + n);
                ++n;
            }
            ManagedBuildManager.setDefaultConfiguration((IProject)proj, iConfiguration);
        }
        try {
            proj.open(null);
        }
        catch (CoreException coreException) {}
    }

    private void doInit() {
        ManagedBuildMacrosTests.createManagedProject("Test");
        Assert.assertNotNull((Object)proj);
        Assert.assertNotNull((Object)mproj);
        this.worksp = proj.getWorkspace();
        Assert.assertNotNull((Object)this.worksp);
        this.mp = ManagedBuildManager.getBuildMacroProvider();
        Assert.assertNotNull((Object)this.mp);
        this.cfgs = mproj.getConfigurations();
        Assert.assertNotNull((Object)this.cfgs);
        this.windows = System.getProperty("os.name").toLowerCase().startsWith("windows");
    }

    private boolean arrayContains(String[] stringArray, String[] stringArray2) {
        Assert.assertNotNull((Object)stringArray);
        Assert.assertNotNull((Object)stringArray2);
        int n = 0;
        while (n < stringArray.length) {
            boolean bl = false;
            int n2 = 0;
            while (n2 < stringArray2.length) {
                if (stringArray[n].equals(stringArray2[n2])) {
                    bl = true;
                    break;
                }
                ++n2;
            }
            if (!bl) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private boolean addMacro(String string, int n, String string2, int n2, Object object) {
        Assert.assertNotNull((Object)this.ms);
        int n3 = 0;
        while (n3 < this.ms.length) {
            if (this.ms[n3] instanceof UserDefinedMacroSupplier) {
                return ((UserDefinedMacroSupplier)this.ms[n3]).createMacro(string, n, string2, n2, object) != null;
            }
            ++n3;
        }
        return false;
    }

    private boolean addMacro(String string, int n, String[] stringArray, int n2, Object object) {
        Assert.assertNotNull((Object)this.ms);
        int n3 = 0;
        while (n3 < this.ms.length) {
            if (this.ms[n3] instanceof UserDefinedMacroSupplier) {
                return ((UserDefinedMacroSupplier)this.ms[n3]).createMacro(string, n, stringArray, n2, object) != null;
            }
            ++n3;
        }
        return false;
    }

    private boolean rmMacro(String string, int n, Object object) {
        Assert.assertNotNull((Object)this.ms);
        int n2 = 0;
        while (n2 < this.ms.length) {
            if (this.ms[n2] instanceof UserDefinedMacroSupplier) {
                return ((UserDefinedMacroSupplier)this.ms[n2]).deleteMacro(string, n, object) != null;
            }
            ++n2;
        }
        return false;
    }

    private void addVars() {
        int n = 4;
        String string = "";
        UserDefinedEnvironmentSupplier userDefinedEnvironmentSupplier = null;
        userDefinedEnvironmentSupplier = ManagedBuildEnvironmentTests.getSupplier(this.worksp, "Workspace");
        if (userDefinedEnvironmentSupplier != null) {
            try {
                userDefinedEnvironmentSupplier.createVariable("casetest", "lowercase", n, string, (Object)this.worksp);
                userDefinedEnvironmentSupplier.createVariable("CaseTest", "capitalize", n, string, (Object)this.worksp);
                userDefinedEnvironmentSupplier.createVariable("CaSeTeSt", "upper2low", n, string, (Object)this.worksp);
                userDefinedEnvironmentSupplier.createVariable("CASETEST", "uppercase", n, string, (Object)this.worksp);
            }
            catch (Exception exception) {
                Assert.fail((String)("Failed to create workspace vars " + exception.getLocalizedMessage()));
            }
        }
    }

    private IFile getFile() {
        IFile iFile = proj.getProject().getFile("main.c");
        if (!iFile.exists()) {
            try {
                iFile.create((InputStream)new ByteArrayInputStream("int main(){\n return 0;\n}".getBytes()), false, null);
            }
            catch (CoreException coreException) {
                Assert.fail((String)coreException.getLocalizedMessage());
            }
        }
        return iFile;
    }
}

