/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.core.tests;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.projectconverter.UpdateManagedProjectManager;
import org.eclipse.cdt.managedbuilder.testplugin.CTestPlugin;
import org.eclipse.cdt.managedbuilder.testplugin.ManagedBuildTestHelper;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.dialogs.IOverwriteQuery;

public class ManagedProjectUpdateTests
extends TestCase {
    static /* synthetic */ Class class$0;

    public ManagedProjectUpdateTests(String string) {
        super(string);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.managedbuilder.core.tests.ManagedProjectUpdateTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite testSuite = new TestSuite(clazz.getName());
        testSuite.addTest((Test)new ManagedProjectUpdateTests("testProjectUpdate12_Update"));
        testSuite.addTest((Test)new ManagedProjectUpdateTests("testProjectUpdate20_Update"));
        testSuite.addTest((Test)new ManagedProjectUpdateTests("testProjectUpdate21_Update"));
        testSuite.addTest((Test)new ManagedProjectUpdateTests("testProjectUpdate12_NoUpdate"));
        testSuite.addTest((Test)new ManagedProjectUpdateTests("testProjectUpdate20_NoUpdate"));
        testSuite.addTest((Test)new ManagedProjectUpdateTests("testProjectUpdate21_NoUpdate"));
        testSuite.addTest((Test)new ManagedProjectUpdateTests("testProjectUpdate21CPP_Update"));
        return testSuite;
    }

    private File getVersionProjectsDir(String string) {
        return CTestPlugin.getFileInPlugin((IPath)new Path("resources/oldTypeProjects/" + string));
    }

    private IProject[] createVersionProjects(String string) {
        File file = this.getVersionProjectsDir(string);
        if (file == null) {
            Assert.fail((String)("Test project directory " + file.getName() + " is missing."));
            return null;
        }
        File[] fileArray = file.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return !file.isDirectory();
            }
        });
        ArrayList<IProject> arrayList = new ArrayList<IProject>(fileArray.length);
        int n = 0;
        while (n < fileArray.length) {
            try {
                IProject iProject;
                String string2 = fileArray[n].getName();
                if (string2.endsWith(".zip") && (string2 = string2.substring(0, string2.length() - ".zip".length())).length() != 0 && (iProject = ManagedBuildTestHelper.createProject(string2, fileArray[n], null, null)) != null) {
                    arrayList.add(iProject);
                }
            }
            catch (Exception exception) {}
            ++n;
        }
        if (arrayList.size() == 0) {
            Assert.fail((String)("No projects found in test project directory " + file.getName() + ".  The .zip file may be missing or corrupt."));
            return null;
        }
        return arrayList.toArray(new IProject[arrayList.size()]);
    }

    private void doTestProjectUpdate(String string, boolean bl, boolean bl2, IPath[] iPathArray) {
        IOverwriteQuery iOverwriteQuery = new IOverwriteQuery(){

            public String queryOverwrite(String string) {
                return "ALL";
            }
        };
        IOverwriteQuery iOverwriteQuery2 = new IOverwriteQuery(){

            public String queryOverwrite(String string) {
                return "NOALL";
            }
        };
        UpdateManagedProjectManager.setBackupFileOverwriteQuery((IOverwriteQuery)(bl2 ? iOverwriteQuery : iOverwriteQuery2));
        UpdateManagedProjectManager.setUpdateProjectQuery((IOverwriteQuery)(bl ? iOverwriteQuery : iOverwriteQuery2));
        IProject[] iProjectArray = this.createVersionProjects(string);
        if (iProjectArray == null || iProjectArray.length == 0) {
            return;
        }
        int n = 0;
        while (n < iProjectArray.length) {
            final IProject iProject = iProjectArray[n];
            IManagedBuildInfo iManagedBuildInfo = ManagedBuildManager.getBuildInfo((IResource)iProject);
            boolean bl3 = UpdateManagedProjectManager.isCompatibleProject((IManagedBuildInfo)iManagedBuildInfo);
            Assert.assertTrue((boolean)bl3);
            if (bl3) {
                if (bl && (iManagedBuildInfo == null || iManagedBuildInfo.getManagedProject() == null || !iManagedBuildInfo.getManagedProject().isValid())) {
                    Assert.fail((String)("the project \"" + iProject.getName() + "\" was not properly converted"));
                }
                IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
                ISchedulingRule iSchedulingRule = iWorkspace.getRuleFactory().buildRule();
                Job job = new Job("project build job"){

                    protected IStatus run(IProgressMonitor iProgressMonitor) {
                        try {
                            iProject.build(10, null);
                        }
                        catch (CoreException coreException) {
                            Assert.fail((String)coreException.getStatus().getMessage());
                        }
                        catch (OperationCanceledException operationCanceledException) {
                            Assert.fail((String)("the project \"" + iProject.getName() + "\" build was cancelled, exception message: " + operationCanceledException.getMessage()));
                        }
                        return new Status(0, "org.eclipse.cdt.managedbuilder.core.tests", 0, new String(), null);
                    }
                };
                job.setRule(iSchedulingRule);
                job.schedule();
                try {
                    job.join();
                }
                catch (InterruptedException interruptedException) {
                    Assert.fail((String)("the build job for the project \"" + iProject.getName() + "\" was interrupted, exception message: " + interruptedException.getMessage()));
                }
                IStatus iStatus = job.getResult();
                if (iStatus.getCode() != 0) {
                    Assert.fail((String)("the build job for the project \"" + iProject.getName() + "\" failed, status message: " + iStatus.getMessage()));
                }
                if (iPathArray != null && iPathArray.length > 0 && n == 0) {
                    String string2 = iManagedBuildInfo.getDefaultConfiguration().getName();
                    IPath iPath = Path.fromOSString((String)string2);
                    ManagedBuildTestHelper.compareBenchmarks(iProject, iPath, iPathArray);
                }
            }
            ++n;
        }
        n = 0;
        while (n < iProjectArray.length) {
            ManagedBuildTestHelper.removeProject(iProjectArray[n].getName());
            ++n;
        }
    }

    public void testProjectUpdate12_Update() {
        IPath[] iPathArray = new IPath[]{Path.fromOSString((String)"makefile"), Path.fromOSString((String)"objects.mk"), Path.fromOSString((String)"sources.mk"), Path.fromOSString((String)"subdir.mk")};
        this.doTestProjectUpdate("1.2", true, true, iPathArray);
    }

    public void testProjectUpdate20_Update() {
        IPath[] iPathArray = new IPath[]{Path.fromOSString((String)"makefile"), Path.fromOSString((String)"objects.mk"), Path.fromOSString((String)"sources.mk"), Path.fromOSString((String)"subdir.mk")};
        this.doTestProjectUpdate("2.0", true, true, iPathArray);
    }

    public void testProjectUpdate21_Update() {
        IPath[] iPathArray = new IPath[]{Path.fromOSString((String)"makefile"), Path.fromOSString((String)"objects.mk"), Path.fromOSString((String)"sources.mk"), Path.fromOSString((String)"subdir.mk"), Path.fromOSString((String)"Functions/subdir.mk")};
        this.doTestProjectUpdate("2.1", true, true, iPathArray);
    }

    public void testProjectUpdate21CPP_Update() {
        IPath[] iPathArray = new IPath[]{Path.fromOSString((String)"makefile"), Path.fromOSString((String)"objects.mk"), Path.fromOSString((String)"sources.mk"), Path.fromOSString((String)"subdir.mk"), Path.fromOSString((String)"Functions/subdir.mk")};
        this.doTestProjectUpdate("2.1CPP", true, true, iPathArray);
    }

    public void testProjectUpdate12_NoUpdate() {
        this.doTestProjectUpdate("1.2", false, true, null);
    }

    public void testProjectUpdate20_NoUpdate() {
        this.doTestProjectUpdate("2.0", false, true, null);
    }

    public void testProjectUpdate21_NoUpdate() {
        this.doTestProjectUpdate("2.1", false, true, null);
    }
}

