/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.core.tests;

import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedOptionValueHandler;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IOptionApplicability;
import org.eclipse.cdt.managedbuilder.core.IResourceConfiguration;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.testplugin.ManagedBuildTestHelper;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;

public class OptionEnablementTests
extends TestCase
implements IManagedOptionValueHandler,
IOptionApplicability {
    private static boolean fEnUiVisible;
    private static boolean fEnUiEnabled;
    private static boolean fEnCmdUsed;
    private static boolean fHandleValueCalled;
    private static final String[] thisEnumIds;
    private static final String[] thisStrings;
    static /* synthetic */ Class class$0;

    static {
        thisEnumIds = new String[]{"testgnu.enablement.c.optimization.level.optimize", "testgnu.enablement.c.optimization.level.more"};
        thisStrings = new String[]{"start 1.2.3 stop"};
    }

    public boolean handleValue(IBuildObject iBuildObject, IHoldsOptions iHoldsOptions, IOption iOption, String string, int n) {
        return false;
    }

    public boolean isDefaultValue(IBuildObject iBuildObject, IHoldsOptions iHoldsOptions, IOption iOption, String string) {
        return false;
    }

    public boolean isEnumValueAppropriate(IBuildObject iBuildObject, IHoldsOptions iHoldsOptions, IOption iOption, String string, String string2) {
        return false;
    }

    public boolean isOptionUsedInCommandLine(IBuildObject iBuildObject, IHoldsOptions iHoldsOptions, IOption iOption) {
        return fEnCmdUsed;
    }

    public boolean isOptionVisible(IBuildObject iBuildObject, IHoldsOptions iHoldsOptions, IOption iOption) {
        return fEnUiVisible;
    }

    public boolean isOptionEnabled(IBuildObject iBuildObject, IHoldsOptions iHoldsOptions, IOption iOption) {
        return fEnUiEnabled;
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.managedbuilder.core.tests.OptionEnablementTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    private void resetValueHandler() {
        fHandleValueCalled = false;
    }

    private void setEnablement(boolean bl, boolean bl2, boolean bl3) {
        fEnUiVisible = bl2;
        fEnUiEnabled = bl3;
        fEnCmdUsed = bl;
    }

    public void testEnablement() {
        this.resetValueHandler();
        IProject iProject = ManagedBuildTestHelper.createProject("en", "cdt.managedbuild.target.enablement.exe");
        ManagedBuildTestHelper.createFile(iProject, "a.c");
        ManagedBuildTestHelper.createFile(iProject, "b.c");
        IManagedBuildInfo iManagedBuildInfo = ManagedBuildManager.getBuildInfo((IResource)iProject);
        IConfiguration iConfiguration = iManagedBuildInfo.getManagedProject().getConfigurations()[0];
        Assert.assertFalse((boolean)fHandleValueCalled);
        this.doTestEnablement((IBuildObject)iConfiguration);
        this.doEnumAllValues((IBuildObject)iConfiguration);
        ManagedBuildTestHelper.removeProject("en");
    }

    private void doEnumAllValues(IBuildObject iBuildObject) {
        ITool iTool = this.getTool(iBuildObject, "enablement.this.child_1.2.3");
        ITool iTool2 = this.getTool(iBuildObject, "enablement.other");
        iTool.getParent();
        iTool2.getParent();
        int n = 0;
        while (n < thisStrings.length) {
            String string = thisStrings[n];
            this.setOption(iBuildObject, (IHoldsOptions)iTool, "this.string", string);
            this.doTestEnablement(iBuildObject);
            ++n;
        }
        this.setOption(iBuildObject, (IHoldsOptions)iTool, "this.boolean", false);
        this.doTestEnablement(iBuildObject);
        this.setOption(iBuildObject, (IHoldsOptions)iTool, "this.boolean", true);
        this.doTestEnablement(iBuildObject);
    }

    private ITool getTool(IBuildObject iBuildObject, String string) {
        Object var3_3 = null;
        IConfiguration iConfiguration = null;
        ITool iTool = null;
        if (iBuildObject instanceof IResourceConfiguration) {
            iConfiguration = var3_3.getParent();
            ITool[] iToolArray = var3_3.getTools();
            int n = 0;
            while (n < iToolArray.length) {
                ITool iTool2 = iToolArray[n];
                while (iTool2 != null) {
                    if (iTool2.getId().equals(string)) {
                        iTool = iToolArray[n];
                        break;
                    }
                    iTool2 = iTool2.getSuperClass();
                }
                ++n;
            }
        } else if (iBuildObject instanceof IConfiguration) {
            iConfiguration = (IConfiguration)iBuildObject;
            iTool = iConfiguration.getToolsBySuperClassId(string)[0];
        } else {
            Assert.fail((String)"wrong argument");
        }
        return iTool;
    }

    private IOption setOption(IBuildObject iBuildObject, IHoldsOptions iHoldsOptions, String string, boolean bl) {
        return this.setOption(iBuildObject, iHoldsOptions, iHoldsOptions.getOptionBySuperClassId(string), bl);
    }

    private IOption setOption(IBuildObject iBuildObject, IHoldsOptions iHoldsOptions, IOption iOption, boolean bl) {
        try {
            if (iBuildObject instanceof IConfiguration) {
                return ((IConfiguration)iBuildObject).setOption(iHoldsOptions, iOption, bl);
            }
            if (iBuildObject instanceof IResourceConfiguration) {
                return ((IResourceConfiguration)iBuildObject).setOption(iHoldsOptions, iOption, bl);
            }
        }
        catch (BuildException buildException) {
            Assert.fail((String)buildException.getLocalizedMessage());
        }
        Assert.fail((String)"wrong arg");
        return null;
    }

    private IOption setOption(IBuildObject iBuildObject, IHoldsOptions iHoldsOptions, String string, String string2) {
        return this.setOption(iBuildObject, iHoldsOptions, iHoldsOptions.getOptionBySuperClassId(string), string2);
    }

    private IOption setOption(IBuildObject iBuildObject, IHoldsOptions iHoldsOptions, IOption iOption, String string) {
        try {
            if (iBuildObject instanceof IConfiguration) {
                return ((IConfiguration)iBuildObject).setOption(iHoldsOptions, iOption, string);
            }
            if (iBuildObject instanceof IResourceConfiguration) {
                return ((IResourceConfiguration)iBuildObject).setOption(iHoldsOptions, iOption, string);
            }
        }
        catch (BuildException buildException) {
            Assert.fail((String)buildException.getLocalizedMessage());
        }
        Assert.fail((String)"wrong arg");
        return null;
    }

    private IOption setOption(IBuildObject iBuildObject, IHoldsOptions iHoldsOptions, String string, String[] stringArray) {
        return this.setOption(iBuildObject, iHoldsOptions, iHoldsOptions.getOptionBySuperClassId(string), stringArray);
    }

    private IOption setOption(IBuildObject iBuildObject, IHoldsOptions iHoldsOptions, IOption iOption, String[] stringArray) {
        try {
            if (iBuildObject instanceof IConfiguration) {
                return ((IConfiguration)iBuildObject).setOption(iHoldsOptions, iOption, stringArray);
            }
            if (iBuildObject instanceof IResourceConfiguration) {
                return ((IResourceConfiguration)iBuildObject).setOption(iHoldsOptions, iOption, stringArray);
            }
        }
        catch (BuildException buildException) {
            Assert.fail((String)buildException.getLocalizedMessage());
        }
        Assert.fail((String)"wrong arg");
        return null;
    }

    private void doTestEnablement(IBuildObject iBuildObject) {
        ITool iTool = this.getTool(iBuildObject, "enablement.this.child_1.2.3");
        ITool iTool2 = this.getTool(iBuildObject, "enablement.other");
        ITool iTool3 = this.getTool(iBuildObject, "enablement.this.child.2_1.2.3");
        IOption iOption = iTool.getOptionBySuperClassId("this.boolean");
        IOption iOption2 = iTool.getOptionBySuperClassId("this.string");
        IOption iOption3 = iTool.getOptionBySuperClassId("this.enum");
        IOption iOption4 = iTool2.getOptionBySuperClassId("other.string");
        iTool2.getOptionBySuperClassId("other.boolean");
        try {
            IOption iOption5 = iTool.getOptionBySuperClassId("enablement.command.c1");
            Assert.assertEquals((String)iOption5.getCommand(), (String)"c1");
            Assert.assertEquals((String)iOption5.getCommandFalse(), (String)"cmdF");
            Assert.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionEnabled(iBuildObject, (IHoldsOptions)iTool, iOption5));
            Assert.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionUsedInCommandLine(iBuildObject, (IHoldsOptions)iTool, iOption5));
            Assert.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionVisible(iBuildObject, (IHoldsOptions)iTool, iOption5));
            iOption5 = iTool.getOptionBySuperClassId("enablement.command.c2");
            Assert.assertEquals((String)iOption5.getCommand(), (String)"c2");
            Assert.assertEquals((String)iOption5.getCommandFalse(), (String)"cmdF");
            Assert.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionEnabled(iBuildObject, (IHoldsOptions)iTool, iOption5));
            Assert.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionUsedInCommandLine(iBuildObject, (IHoldsOptions)iTool, iOption5));
            Assert.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionVisible(iBuildObject, (IHoldsOptions)iTool, iOption5));
            iOption5 = iTool.getOptionBySuperClassId("enablement.commandFalse.c1");
            Assert.assertEquals((String)iOption5.getCommand(), (String)"cmd");
            Assert.assertEquals((String)iOption5.getCommandFalse(), (String)"c1");
            Assert.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionEnabled(iBuildObject, (IHoldsOptions)iTool, iOption5));
            Assert.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionUsedInCommandLine(iBuildObject, (IHoldsOptions)iTool, iOption5));
            Assert.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionVisible(iBuildObject, (IHoldsOptions)iTool, iOption5));
            iOption5 = iTool.getOptionBySuperClassId("enablement.commandFalse.c2");
            Assert.assertEquals((String)iOption5.getCommand(), (String)"cmd");
            Assert.assertEquals((String)iOption5.getCommandFalse(), (String)"c2");
            Assert.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionEnabled(iBuildObject, (IHoldsOptions)iTool, iOption5));
            Assert.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionUsedInCommandLine(iBuildObject, (IHoldsOptions)iTool, iOption5));
            Assert.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionVisible(iBuildObject, (IHoldsOptions)iTool, iOption5));
            iOption5 = iTool.getOptionBySuperClassId("enablement.command.c1.commandFalse.cF1");
            Assert.assertEquals((String)iOption5.getCommand(), (String)"c1");
            Assert.assertEquals((String)iOption5.getCommandFalse(), (String)"cF1");
            Assert.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionEnabled(iBuildObject, (IHoldsOptions)iTool, iOption5));
            Assert.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionUsedInCommandLine(iBuildObject, (IHoldsOptions)iTool, iOption5));
            Assert.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionVisible(iBuildObject, (IHoldsOptions)iTool, iOption5));
            iOption5 = iTool.getOptionBySuperClassId("enablement.command.cmd.commandFalse.cmdF");
            Assert.assertEquals((String)iOption5.getCommand(), (String)"cmd");
            Assert.assertEquals((String)iOption5.getCommandFalse(), (String)"cmdF");
            Assert.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionEnabled(iBuildObject, (IHoldsOptions)iTool, iOption5));
            Assert.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionUsedInCommandLine(iBuildObject, (IHoldsOptions)iTool, iOption5));
            Assert.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionVisible(iBuildObject, (IHoldsOptions)iTool, iOption5));
            iOption5 = iTool.getOptionBySuperClassId("enablement.command.c1.commandFalse.cmdF");
            Assert.assertEquals((String)iOption5.getCommand(), (String)"c1");
            Assert.assertEquals((String)iOption5.getCommandFalse(), (String)"cmdF");
            Assert.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionEnabled(iBuildObject, (IHoldsOptions)iTool, iOption5));
            Assert.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionUsedInCommandLine(iBuildObject, (IHoldsOptions)iTool, iOption5));
            Assert.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionVisible(iBuildObject, (IHoldsOptions)iTool, iOption5));
            iOption5 = iTool.getOptionBySuperClassId("enablement.command.cmd.commandFalse.cF1");
            Assert.assertEquals((String)iOption5.getCommand(), (String)"cmd");
            Assert.assertEquals((String)iOption5.getCommandFalse(), (String)"cF1");
            Assert.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionEnabled(iBuildObject, (IHoldsOptions)iTool, iOption5));
            Assert.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionUsedInCommandLine(iBuildObject, (IHoldsOptions)iTool, iOption5));
            Assert.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionVisible(iBuildObject, (IHoldsOptions)iTool, iOption5));
            iOption5 = iTool.getOptionBySuperClassId("enablement.ui.en");
            Assert.assertEquals((String)iOption5.getCommand(), (String)"cmd");
            Assert.assertEquals((String)iOption5.getCommandFalse(), (String)"cF1");
            Assert.assertFalse((boolean)iOption5.getApplicabilityCalculator().isOptionEnabled(iBuildObject, (IHoldsOptions)iTool, iOption5));
            Assert.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionUsedInCommandLine(iBuildObject, (IHoldsOptions)iTool, iOption5));
            Assert.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionVisible(iBuildObject, (IHoldsOptions)iTool, iOption5));
            iOption5 = iTool.getOptionBySuperClassId("enablement.ui.vis");
            Assert.assertEquals((String)iOption5.getCommand(), (String)"cmd");
            Assert.assertEquals((String)iOption5.getCommandFalse(), (String)"cF1");
            Assert.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionEnabled(iBuildObject, (IHoldsOptions)iTool, iOption5));
            Assert.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionUsedInCommandLine(iBuildObject, (IHoldsOptions)iTool, iOption5));
            Assert.assertFalse((boolean)iOption5.getApplicabilityCalculator().isOptionVisible(iBuildObject, (IHoldsOptions)iTool, iOption5));
            iOption5 = iTool.getOptionBySuperClassId("enablement.cmd.us");
            Assert.assertEquals((String)iOption5.getCommand(), (String)"cmd");
            Assert.assertEquals((String)iOption5.getCommandFalse(), (String)"cmdF");
            Assert.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionEnabled(iBuildObject, (IHoldsOptions)iTool, iOption5));
            Assert.assertFalse((boolean)iOption5.getApplicabilityCalculator().isOptionUsedInCommandLine(iBuildObject, (IHoldsOptions)iTool, iOption5));
            Assert.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionVisible(iBuildObject, (IHoldsOptions)iTool, iOption5));
            iOption5 = iTool.getOptionBySuperClassId("enablement.cmdUs.or.uiVis");
            Assert.assertEquals((String)iOption5.getCommand(), (String)"cmd");
            Assert.assertEquals((String)iOption5.getCommandFalse(), (String)"cF1");
            Assert.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionEnabled(iBuildObject, (IHoldsOptions)iTool, iOption5));
            Assert.assertFalse((boolean)iOption5.getApplicabilityCalculator().isOptionUsedInCommandLine(iBuildObject, (IHoldsOptions)iTool, iOption5));
            Assert.assertFalse((boolean)iOption5.getApplicabilityCalculator().isOptionVisible(iBuildObject, (IHoldsOptions)iTool, iOption5));
            iOption5 = iTool.getOptionBySuperClassId("enablement.uiEn.or.uiVis");
            Assert.assertEquals((String)iOption5.getCommand(), (String)"cmd");
            Assert.assertEquals((String)iOption5.getCommandFalse(), (String)"cF1");
            Assert.assertFalse((boolean)iOption5.getApplicabilityCalculator().isOptionEnabled(iBuildObject, (IHoldsOptions)iTool, iOption5));
            Assert.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionUsedInCommandLine(iBuildObject, (IHoldsOptions)iTool, iOption5));
            Assert.assertFalse((boolean)iOption5.getApplicabilityCalculator().isOptionVisible(iBuildObject, (IHoldsOptions)iTool, iOption5));
            iOption5 = iTool.getOptionBySuperClassId("enablement.all");
            Assert.assertEquals((String)iOption5.getCommand(), (String)"cmd");
            Assert.assertEquals((String)iOption5.getCommandFalse(), (String)"cF1");
            Assert.assertFalse((boolean)iOption5.getApplicabilityCalculator().isOptionEnabled(iBuildObject, (IHoldsOptions)iTool, iOption5));
            Assert.assertFalse((boolean)iOption5.getApplicabilityCalculator().isOptionUsedInCommandLine(iBuildObject, (IHoldsOptions)iTool, iOption5));
            Assert.assertFalse((boolean)iOption5.getApplicabilityCalculator().isOptionVisible(iBuildObject, (IHoldsOptions)iTool, iOption5));
            iOption5 = iTool.getOptionBySuperClassId("enablement.all.ac.vh");
            Assert.assertEquals((String)iOption5.getCommand(), (String)"cmd");
            Assert.assertEquals((String)iOption5.getCommandFalse(), (String)"cF1");
            this.setEnablement(false, false, false);
            Assert.assertFalse((boolean)iOption5.getApplicabilityCalculator().isOptionUsedInCommandLine(iBuildObject, (IHoldsOptions)iTool, iOption5));
            Assert.assertFalse((boolean)iOption5.getApplicabilityCalculator().isOptionVisible(iBuildObject, (IHoldsOptions)iTool, iOption5));
            Assert.assertFalse((boolean)iOption5.getApplicabilityCalculator().isOptionEnabled(iBuildObject, (IHoldsOptions)iTool, iOption5));
            this.setEnablement(false, true, false);
            Assert.assertFalse((boolean)iOption5.getApplicabilityCalculator().isOptionUsedInCommandLine(iBuildObject, (IHoldsOptions)iTool, iOption5));
            Assert.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionVisible(iBuildObject, (IHoldsOptions)iTool, iOption5));
            Assert.assertFalse((boolean)iOption5.getApplicabilityCalculator().isOptionEnabled(iBuildObject, (IHoldsOptions)iTool, iOption5));
            this.setEnablement(false, false, true);
            Assert.assertFalse((boolean)iOption5.getApplicabilityCalculator().isOptionUsedInCommandLine(iBuildObject, (IHoldsOptions)iTool, iOption5));
            Assert.assertFalse((boolean)iOption5.getApplicabilityCalculator().isOptionVisible(iBuildObject, (IHoldsOptions)iTool, iOption5));
            Assert.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionEnabled(iBuildObject, (IHoldsOptions)iTool, iOption5));
            this.setEnablement(true, false, false);
            Assert.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionUsedInCommandLine(iBuildObject, (IHoldsOptions)iTool, iOption5));
            Assert.assertFalse((boolean)iOption5.getApplicabilityCalculator().isOptionVisible(iBuildObject, (IHoldsOptions)iTool, iOption5));
            Assert.assertFalse((boolean)iOption5.getApplicabilityCalculator().isOptionEnabled(iBuildObject, (IHoldsOptions)iTool, iOption5));
            this.setEnablement(false, false, false);
            iOption5 = iTool.getOptionBySuperClassId("enablement.all.cF1.ac.vh");
            Assert.assertEquals((String)iOption5.getCommand(), (String)"cmd");
            Assert.assertEquals((String)iOption5.getCommandFalse(), (String)"cF1");
            Assert.assertFalse((boolean)iOption5.getApplicabilityCalculator().isOptionUsedInCommandLine(iBuildObject, (IHoldsOptions)iTool, iOption5));
            Assert.assertFalse((boolean)iOption5.getApplicabilityCalculator().isOptionVisible(iBuildObject, (IHoldsOptions)iTool, iOption5));
            Assert.assertFalse((boolean)iOption5.getApplicabilityCalculator().isOptionEnabled(iBuildObject, (IHoldsOptions)iTool, iOption5));
            this.setEnablement(true, false, true);
            iOption5 = iTool.getOptionBySuperClassId("enablement.all.cF.cmdF");
            Assert.assertEquals((String)iOption5.getCommand(), (String)"cmd");
            Assert.assertEquals((String)iOption5.getCommandFalse(), (String)"cmdF");
            Assert.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionUsedInCommandLine(iBuildObject, (IHoldsOptions)iTool, iOption5));
            Assert.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionVisible(iBuildObject, (IHoldsOptions)iTool, iOption5));
            Assert.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionEnabled(iBuildObject, (IHoldsOptions)iTool, iOption5));
            iOption5 = iTool.getOptionBySuperClassId("enablement.all.cF.cF1");
            Assert.assertEquals((String)iOption5.getCommand(), (String)"cmd");
            Assert.assertEquals((String)iOption5.getCommandFalse(), (String)"cF1");
            Assert.assertFalse((boolean)iOption5.getApplicabilityCalculator().isOptionUsedInCommandLine(iBuildObject, (IHoldsOptions)iTool, iOption5));
            Assert.assertFalse((boolean)iOption5.getApplicabilityCalculator().isOptionVisible(iBuildObject, (IHoldsOptions)iTool, iOption5));
            Assert.assertFalse((boolean)iOption5.getApplicabilityCalculator().isOptionEnabled(iBuildObject, (IHoldsOptions)iTool, iOption5));
            iOption5 = iTool.getOptionBySuperClassId("this.boolean");
            Assert.assertEquals((String)iOption5.getCommand(), (String)"cmd");
            Assert.assertEquals((String)iOption5.getCommandFalse(), (String)"cmdF");
            Assert.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionUsedInCommandLine(iBuildObject, (IHoldsOptions)iTool, iOption5));
            Assert.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionVisible(iBuildObject, (IHoldsOptions)iTool, iOption5));
            Assert.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionEnabled(iBuildObject, (IHoldsOptions)iTool, iOption5));
            iOption5 = iTool.getOptionBySuperClassId("enablement.checkOpt.all.Q.this.boolean.True");
            Assert.assertEquals((String)iOption5.getCommand(), (String)"cmd");
            Assert.assertEquals((String)iOption5.getCommandFalse(), (String)"cmdF");
            Assert.assertEquals((iOption.getBooleanValue() ? 1 : 0) != 0, (boolean)iOption5.getApplicabilityCalculator().isOptionUsedInCommandLine(iBuildObject, (IHoldsOptions)iTool, iOption5));
            Assert.assertEquals((iOption.getBooleanValue() ? 1 : 0) != 0, (boolean)iOption5.getApplicabilityCalculator().isOptionVisible(iBuildObject, (IHoldsOptions)iTool, iOption5));
            Assert.assertEquals((iOption.getBooleanValue() ? 1 : 0) != 0, (boolean)iOption5.getApplicabilityCalculator().isOptionEnabled(iBuildObject, (IHoldsOptions)iTool, iOption5));
            iOption5 = iTool.getOptionBySuperClassId("enablement.checkOpt.all.Q.this.boolean.False");
            Assert.assertEquals((String)iOption5.getCommand(), (String)"cmd");
            Assert.assertEquals((String)iOption5.getCommandFalse(), (String)"cmdF");
            Assert.assertEquals((!iOption.getBooleanValue() ? 1 : 0) != 0, (boolean)iOption5.getApplicabilityCalculator().isOptionUsedInCommandLine(iBuildObject, (IHoldsOptions)iTool, iOption5));
            Assert.assertEquals((!iOption.getBooleanValue() ? 1 : 0) != 0, (boolean)iOption5.getApplicabilityCalculator().isOptionVisible(iBuildObject, (IHoldsOptions)iTool, iOption5));
            Assert.assertEquals((!iOption.getBooleanValue() ? 1 : 0) != 0, (boolean)iOption5.getApplicabilityCalculator().isOptionEnabled(iBuildObject, (IHoldsOptions)iTool, iOption5));
            iOption5 = iTool.getOptionBySuperClassId("enablement.checkOpt.all.Q.this.string.Q.empty");
            Assert.assertEquals((String)iOption5.getCommand(), (String)"cmd");
            Assert.assertEquals((String)iOption5.getCommandFalse(), (String)"cmdF");
            Assert.assertEquals((boolean)iOption2.getStringValue().equals(""), (boolean)iOption5.getApplicabilityCalculator().isOptionUsedInCommandLine(iBuildObject, (IHoldsOptions)iTool, iOption5));
            Assert.assertEquals((boolean)iOption2.getStringValue().equals(""), (boolean)iOption5.getApplicabilityCalculator().isOptionVisible(iBuildObject, (IHoldsOptions)iTool, iOption5));
            Assert.assertEquals((boolean)iOption2.getStringValue().equals(""), (boolean)iOption5.getApplicabilityCalculator().isOptionEnabled(iBuildObject, (IHoldsOptions)iTool, iOption5));
            iOption5 = iTool.getOptionBySuperClassId("enablement.checkOpt.all.Q.this.string.Q.test a b c");
            Assert.assertEquals((String)iOption5.getCommand(), (String)"cmd");
            Assert.assertEquals((String)iOption5.getCommandFalse(), (String)"cmdF");
            Assert.assertEquals((boolean)iOption2.getStringValue().equals("test a b c"), (boolean)iOption5.getApplicabilityCalculator().isOptionUsedInCommandLine(iBuildObject, (IHoldsOptions)iTool, iOption5));
            Assert.assertEquals((boolean)iOption2.getStringValue().equals("test a b c"), (boolean)iOption5.getApplicabilityCalculator().isOptionVisible(iBuildObject, (IHoldsOptions)iTool, iOption5));
            Assert.assertEquals((boolean)iOption2.getStringValue().equals("test a b c"), (boolean)iOption5.getApplicabilityCalculator().isOptionEnabled(iBuildObject, (IHoldsOptions)iTool, iOption5));
            iOption5 = iTool.getOptionBySuperClassId("enablement.checkOpt.all.Q.this.enum.Q.testgnu.enablement.c.optimization.level.optimize");
            Assert.assertEquals((String)iOption5.getCommand(), (String)"cmd");
            Assert.assertEquals((String)iOption5.getCommandFalse(), (String)"cmdF");
            String string = iOption3.getEnumeratedId(iOption3.getStringValue());
            if (string == null) {
                string = "";
            }
            Assert.assertEquals((boolean)string.equals("testgnu.enablement.c.optimization.level.optimize"), (boolean)iOption5.getApplicabilityCalculator().isOptionUsedInCommandLine(iBuildObject, (IHoldsOptions)iTool, iOption5));
            Assert.assertEquals((boolean)string.equals("testgnu.enablement.c.optimization.level.optimize"), (boolean)iOption5.getApplicabilityCalculator().isOptionVisible(iBuildObject, (IHoldsOptions)iTool, iOption5));
            Assert.assertEquals((boolean)string.equals("testgnu.enablement.c.optimization.level.optimize"), (boolean)iOption5.getApplicabilityCalculator().isOptionEnabled(iBuildObject, (IHoldsOptions)iTool, iOption5));
            iOption5 = iTool.getOptionBySuperClassId("enablement.checkOpt.all.Q.this.Q.true");
            Assert.assertEquals((String)iOption5.getCommand(), (String)"cmd");
            Assert.assertEquals((String)iOption5.getCommandFalse(), (String)"cmdF");
            Assert.assertEquals((iOption5.getBooleanValue() ? 1 : 0) != 0, (boolean)iOption5.getApplicabilityCalculator().isOptionUsedInCommandLine(iBuildObject, (IHoldsOptions)iTool, iOption5));
            Assert.assertEquals((iOption5.getBooleanValue() ? 1 : 0) != 0, (boolean)iOption5.getApplicabilityCalculator().isOptionVisible(iBuildObject, (IHoldsOptions)iTool, iOption5));
            Assert.assertEquals((iOption5.getBooleanValue() ? 1 : 0) != 0, (boolean)iOption5.getApplicabilityCalculator().isOptionEnabled(iBuildObject, (IHoldsOptions)iTool, iOption5));
            iOption5 = iTool.getOptionBySuperClassId("enablement.checkOpt.all.Q.this.string.Q.start ${ParentVersion} stop");
            Assert.assertEquals((String)iOption5.getCommand(), (String)"cmd");
            Assert.assertEquals((String)iOption5.getCommandFalse(), (String)"cmdF");
            Assert.assertEquals((boolean)iOption2.getStringValue().equals("start 1.2.3 stop"), (boolean)iOption5.getApplicabilityCalculator().isOptionUsedInCommandLine(iBuildObject, (IHoldsOptions)iTool, iOption5));
            Assert.assertEquals((boolean)iOption2.getStringValue().equals("start 1.2.3 stop"), (boolean)iOption5.getApplicabilityCalculator().isOptionVisible(iBuildObject, (IHoldsOptions)iTool, iOption5));
            Assert.assertEquals((boolean)iOption2.getStringValue().equals("start 1.2.3 stop"), (boolean)iOption5.getApplicabilityCalculator().isOptionEnabled(iBuildObject, (IHoldsOptions)iTool, iOption5));
            iOption5 = iTool.getOptionBySuperClassId("enablement.checkOpt.all.Q.this.string.Q.other.string");
            Assert.assertEquals((String)iOption5.getCommand(), (String)"cmd");
            Assert.assertEquals((String)iOption5.getCommandFalse(), (String)"cmdF");
            Assert.assertEquals((boolean)iOption2.getStringValue().equals(iOption4.getStringValue()), (boolean)iOption5.getApplicabilityCalculator().isOptionUsedInCommandLine(iBuildObject, (IHoldsOptions)iTool, iOption5));
            Assert.assertEquals((boolean)iOption2.getStringValue().equals(iOption4.getStringValue()), (boolean)iOption5.getApplicabilityCalculator().isOptionVisible(iBuildObject, (IHoldsOptions)iTool, iOption5));
            Assert.assertEquals((boolean)iOption2.getStringValue().equals(iOption4.getStringValue()), (boolean)iOption5.getApplicabilityCalculator().isOptionEnabled(iBuildObject, (IHoldsOptions)iTool, iOption5));
            iOption5 = iTool.getOptionBySuperClassId("enablement.checkOpt.all.Q.this.string.Q.other.string");
            Assert.assertEquals((String)iOption5.getCommand(), (String)"cmd");
            Assert.assertEquals((String)iOption5.getCommandFalse(), (String)"cmdF");
            Assert.assertEquals((boolean)iOption2.getStringValue().equals(iOption4.getStringValue()), (boolean)iOption5.getApplicabilityCalculator().isOptionUsedInCommandLine(iBuildObject, (IHoldsOptions)iTool, iOption5));
            Assert.assertEquals((boolean)iOption2.getStringValue().equals(iOption4.getStringValue()), (boolean)iOption5.getApplicabilityCalculator().isOptionVisible(iBuildObject, (IHoldsOptions)iTool, iOption5));
            Assert.assertEquals((boolean)iOption2.getStringValue().equals(iOption4.getStringValue()), (boolean)iOption5.getApplicabilityCalculator().isOptionEnabled(iBuildObject, (IHoldsOptions)iTool, iOption5));
            iOption5 = iTool.getOptionBySuperClassId("enablement.checkString");
            Assert.assertEquals((String)iOption5.getCommand(), (String)"cmd");
            Assert.assertEquals((String)iOption5.getCommandFalse(), (String)"cmdF");
            Assert.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionUsedInCommandLine(iBuildObject, (IHoldsOptions)iTool, iOption5));
            Assert.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionVisible(iBuildObject, (IHoldsOptions)iTool, iOption5));
            Assert.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionEnabled(iBuildObject, (IHoldsOptions)iTool, iOption5));
            iOption5 = iTool.getOptionBySuperClassId("enablement.checkString.2");
            Assert.assertEquals((String)iOption5.getCommand(), (String)"cmd");
            Assert.assertEquals((String)iOption5.getCommandFalse(), (String)"cmdF");
            Assert.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionUsedInCommandLine(iBuildObject, (IHoldsOptions)iTool, iOption5));
            Assert.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionVisible(iBuildObject, (IHoldsOptions)iTool, iOption5));
            Assert.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionEnabled(iBuildObject, (IHoldsOptions)iTool, iOption5));
            iOption5 = iTool.getOptionBySuperClassId("enablement.checkString.3");
            Assert.assertEquals((String)iOption5.getCommand(), (String)"cmd");
            Assert.assertEquals((String)iOption5.getCommandFalse(), (String)"cmdF");
            Assert.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionUsedInCommandLine(iBuildObject, (IHoldsOptions)iTool, iOption5));
            Assert.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionVisible(iBuildObject, (IHoldsOptions)iTool, iOption5));
            Assert.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionEnabled(iBuildObject, (IHoldsOptions)iTool, iOption5));
            iOption5 = iTool.getOptionBySuperClassId("enablement.checkFalse.false");
            Assert.assertEquals((String)iOption5.getCommand(), (String)"cmd");
            Assert.assertEquals((String)iOption5.getCommandFalse(), (String)"cmdF");
            Assert.assertFalse((boolean)iOption5.getApplicabilityCalculator().isOptionUsedInCommandLine(iBuildObject, (IHoldsOptions)iTool, iOption5));
            Assert.assertFalse((boolean)iOption5.getApplicabilityCalculator().isOptionVisible(iBuildObject, (IHoldsOptions)iTool, iOption5));
            Assert.assertFalse((boolean)iOption5.getApplicabilityCalculator().isOptionEnabled(iBuildObject, (IHoldsOptions)iTool, iOption5));
            iOption5 = iTool.getOptionBySuperClassId("enablement.checkNot.false");
            Assert.assertEquals((String)iOption5.getCommand(), (String)"cmd");
            Assert.assertEquals((String)iOption5.getCommandFalse(), (String)"cmdF");
            Assert.assertFalse((boolean)iOption5.getApplicabilityCalculator().isOptionUsedInCommandLine(iBuildObject, (IHoldsOptions)iTool, iOption5));
            Assert.assertFalse((boolean)iOption5.getApplicabilityCalculator().isOptionVisible(iBuildObject, (IHoldsOptions)iTool, iOption5));
            Assert.assertFalse((boolean)iOption5.getApplicabilityCalculator().isOptionEnabled(iBuildObject, (IHoldsOptions)iTool, iOption5));
            iOption5 = iTool.getOptionBySuperClassId("enablement.checkOr.true");
            Assert.assertEquals((String)iOption5.getCommand(), (String)"cmd");
            Assert.assertEquals((String)iOption5.getCommandFalse(), (String)"cmdF");
            Assert.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionUsedInCommandLine(iBuildObject, (IHoldsOptions)iTool, iOption5));
            Assert.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionVisible(iBuildObject, (IHoldsOptions)iTool, iOption5));
            Assert.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionEnabled(iBuildObject, (IHoldsOptions)iTool, iOption5));
            iOption5 = iTool.getOptionBySuperClassId("enablement.checkAnd.false");
            Assert.assertEquals((String)iOption5.getCommand(), (String)"cmd");
            Assert.assertEquals((String)iOption5.getCommandFalse(), (String)"cmdF");
            Assert.assertFalse((boolean)iOption5.getApplicabilityCalculator().isOptionUsedInCommandLine(iBuildObject, (IHoldsOptions)iTool, iOption5));
            Assert.assertFalse((boolean)iOption5.getApplicabilityCalculator().isOptionVisible(iBuildObject, (IHoldsOptions)iTool, iOption5));
            Assert.assertFalse((boolean)iOption5.getApplicabilityCalculator().isOptionEnabled(iBuildObject, (IHoldsOptions)iTool, iOption5));
            iOption5 = iTool.getOptionBySuperClassId("enablement.checkHolder.true.1.false.2");
            Assert.assertEquals((String)iOption5.getCommand(), (String)"cmd");
            Assert.assertEquals((String)iOption5.getCommandFalse(), (String)"cmdF");
            Assert.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionUsedInCommandLine(iBuildObject, (IHoldsOptions)iTool, iOption5));
            Assert.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionVisible(iBuildObject, (IHoldsOptions)iTool, iOption5));
            Assert.assertTrue((boolean)iOption5.getApplicabilityCalculator().isOptionEnabled(iBuildObject, (IHoldsOptions)iTool, iOption5));
            iOption5 = iTool3.getOptionBySuperClassId("enablement.checkHolder.true.1.false.2");
            Assert.assertEquals((String)iOption5.getCommand(), (String)"cmd");
            Assert.assertEquals((String)iOption5.getCommandFalse(), (String)"cmdF");
            Assert.assertFalse((boolean)iOption5.getApplicabilityCalculator().isOptionUsedInCommandLine(iBuildObject, (IHoldsOptions)iTool3, iOption5));
            Assert.assertFalse((boolean)iOption5.getApplicabilityCalculator().isOptionVisible(iBuildObject, (IHoldsOptions)iTool3, iOption5));
            Assert.assertFalse((boolean)iOption5.getApplicabilityCalculator().isOptionEnabled(iBuildObject, (IHoldsOptions)iTool3, iOption5));
        }
        catch (BuildException buildException) {
            Assert.fail((String)buildException.getLocalizedMessage());
        }
    }
}

