/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.core.tests;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IOptionCategory;
import org.eclipse.cdt.managedbuilder.core.IProjectType;
import org.eclipse.cdt.managedbuilder.core.IResourceConfiguration;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.ManagedCProjectNature;
import org.eclipse.cdt.managedbuilder.internal.core.Tool;
import org.eclipse.cdt.managedbuilder.testplugin.ManagedBuildTestHelper;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

public class ResourceBuildCoreTests
extends TestCase {
    private static final boolean boolVal = true;
    private static IProjectType exeType;
    private static IProjectType libType;
    private static IProjectType dllType;
    private static final String projectName = "T1";
    private static final String renamedProjectName1 = "T1_1";
    private static final String renamedProjectName2 = "T1_2";
    static /* synthetic */ Class class$0;

    public ResourceBuildCoreTests(String string) {
        super(string);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.managedbuilder.core.tests.ResourceBuildCoreTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite testSuite = new TestSuite(clazz.getName());
        testSuite.addTest((Test)new ResourceBuildCoreTests("testResourceConfigurations"));
        testSuite.addTest((Test)new ResourceBuildCoreTests("testResourceConfigurationReset"));
        testSuite.addTest((Test)new ResourceBuildCoreTests("testResourceConfigurationBuildInfo"));
        testSuite.addTest((Test)new ResourceBuildCoreTests("testResourceRename"));
        return testSuite;
    }

    public void testResourceConfigurations() throws Exception {
        IOption iOption;
        IFile iFile;
        IProjectDescription iProjectDescription;
        IProject iProject = null;
        try {
            iProject = this.createProject(projectName);
            ManagedBuildTestHelper.addManagedBuildNature(iProject);
            iProjectDescription = iProject.getDescription();
            if (iProjectDescription != null) {
                Assert.assertTrue((boolean)iProjectDescription.hasNature(ManagedCProjectNature.MNG_NATURE_ID));
            }
        }
        catch (CoreException coreException) {
            Assert.fail((String)("Test failed on project creation: " + coreException.getLocalizedMessage()));
        }
        ManagedBuildManager.getDefinedProjectTypes();
        iProjectDescription = ManagedBuildManager.getProjectType((String)"cdt.managedbuild.target.testgnu21.exe");
        Assert.assertNotNull((Object)iProjectDescription);
        IManagedProject iManagedProject = ManagedBuildManager.createManagedProject((IResource)iProject, (IProjectType)iProjectDescription);
        Assert.assertEquals((String)iManagedProject.getName(), (String)iProjectDescription.getName());
        Assert.assertFalse((boolean)iManagedProject.equals(iProjectDescription));
        ManagedBuildManager.setNewProjectVersion((IProject)iProject);
        IFile iFile2 = iProject.getProject().getFile("main.c");
        if (!iFile2.exists()) {
            iFile2.create((InputStream)new ByteArrayInputStream("#include <stdio.h>\n extern void bar(); \n int main() { \nprintf(\"Hello, World!!\"); \n bar();\n return 0; }".getBytes()), false, null);
        }
        if (!(iFile = iProject.getProject().getFile("bar.c")).exists()) {
            iFile.create((InputStream)new ByteArrayInputStream("#include <stdio.h>\n void bar() { \nprintf(\"Hello, bar()!!\");\n return; }".getBytes()), false, null);
        }
        IConfiguration iConfiguration = null;
        IConfiguration[] iConfigurationArray = iProjectDescription.getConfigurations();
        int n = 0;
        while (n < iConfigurationArray.length) {
            if (n == 0) {
                iConfiguration = iManagedProject.createConfiguration(iConfigurationArray[n], String.valueOf(iProjectDescription.getId()) + "." + n);
            } else {
                iManagedProject.createConfiguration(iConfigurationArray[n], String.valueOf(iProjectDescription.getId()) + "." + n);
            }
            ++n;
        }
        ManagedBuildManager.setDefaultConfiguration((IProject)iProject, iConfiguration);
        IResourceConfiguration iResourceConfiguration = iConfiguration.createResourceConfiguration(iFile2);
        IResourceConfiguration iResourceConfiguration2 = iConfiguration.createResourceConfiguration(iFile);
        IResourceConfiguration[] iResourceConfigurationArray = iConfiguration.getResourceConfigurations();
        Assert.assertEquals((int)2, (int)iResourceConfigurationArray.length);
        ITool[] iToolArray = iResourceConfiguration.getTools();
        Assert.assertNotNull((Object)iToolArray);
        Assert.assertEquals((int)1, (int)iToolArray.length);
        ITool[] iToolArray2 = iResourceConfiguration2.getTools();
        Assert.assertNotNull((Object)iToolArray2);
        Assert.assertEquals((int)1, (int)iToolArray2.length);
        ITool iTool = iToolArray[0];
        String string = iTool.getToolFlags();
        ITool iTool2 = iToolArray2[0];
        String string2 = iTool2.getToolFlags();
        String string3 = iFile2.getFileExtension();
        ITool[] iToolArray3 = iConfiguration.getFilteredTools();
        Tool tool = null;
        String string4 = new String();
        int n2 = 0;
        while (n2 < iToolArray3.length) {
            if (iToolArray3[n2].buildsFileType(string3)) {
                tool = (Tool)iToolArray3[n2];
                string4 = tool.getToolFlags();
                break;
            }
            ++n2;
        }
        Assert.assertEquals((String)string, (String)string4);
        Assert.assertEquals((String)string, (String)string2);
        IOption iOption2 = tool.getOptionById("testgnu.c.compiler.exe.debug.option.debugging.level");
        Assert.assertNotNull((Object)iOption2);
        IOption iOption3 = ManagedBuildManager.setOption((IConfiguration)iConfiguration, (IHoldsOptions)tool, (IOption)iOption2, (String)"testgnu.c.debugging.level.default");
        String string5 = iOption3.getId();
        String string6 = iOption3.getStringValue();
        Assert.assertNotSame((Object)iOption2.getStringValue(), (Object)string6);
        IOption iOption4 = null;
        IOption[] iOptionArray = iTool.getOptions();
        int n3 = 0;
        while (n3 < iOptionArray.length) {
            iOption = iOptionArray[n3];
            if (iOption != null) {
                if (iOption.getId().equals(string5)) {
                    iOption4 = iOption;
                    break;
                }
                if (iOption.getSuperClass() != null && iOption.getSuperClass().getId().equals(string5)) {
                    iOption4 = iOption;
                    break;
                }
            }
            ++n3;
        }
        String string7 = iOption4.getStringValue();
        Assert.assertEquals((String)string6, (String)string7);
        iOption = ManagedBuildManager.setOption((IResourceConfiguration)iResourceConfiguration, (IHoldsOptions)iTool, iOption4, (String)"gnu.c.debugging.level.minimal");
        iToolArray3 = iConfiguration.getFilteredTools();
        tool = null;
        int n4 = 0;
        while (n4 < iToolArray3.length) {
            if (iToolArray3[n4].buildsFileType(string3)) {
                tool = (Tool)iToolArray3[n4];
                break;
            }
            ++n4;
        }
        iOption2 = tool.getOptionById(string5);
        String string8 = iOption2.getStringValue();
        String string9 = iOption.getStringValue();
        Assert.assertNotSame((Object)string8, (Object)string9);
        iProject.close(null);
        this.removeProject(projectName);
    }

    public void testResourceConfigurationReset() throws Exception {
        IProjectDescription iProjectDescription;
        IProject iProject = null;
        try {
            iProject = this.createProject(projectName);
            ManagedBuildTestHelper.addManagedBuildNature(iProject);
            iProjectDescription = iProject.getDescription();
            if (iProjectDescription != null) {
                Assert.assertTrue((boolean)iProjectDescription.hasNature(ManagedCProjectNature.MNG_NATURE_ID));
            }
        }
        catch (CoreException coreException) {
            Assert.fail((String)("Test failed on project creation: " + coreException.getLocalizedMessage()));
        }
        ManagedBuildManager.getDefinedProjectTypes();
        iProjectDescription = ManagedBuildManager.getProjectType((String)"cdt.managedbuild.target.testgnu21.exe");
        Assert.assertNotNull((Object)iProjectDescription);
        IManagedProject iManagedProject = ManagedBuildManager.createManagedProject((IResource)iProject, (IProjectType)iProjectDescription);
        Assert.assertEquals((String)iManagedProject.getName(), (String)iProjectDescription.getName());
        Assert.assertFalse((boolean)iManagedProject.equals(iProjectDescription));
        ManagedBuildManager.setNewProjectVersion((IProject)iProject);
        IFile iFile = iProject.getProject().getFile("hello.c");
        if (!iFile.exists()) {
            iFile.create((InputStream)new ByteArrayInputStream("#include <stdio.h>\n\n int main() { \nprintf(\"Hello, World!!\"); \n bar();\n return 0; }".getBytes()), false, null);
        }
        IConfiguration iConfiguration = null;
        IConfiguration[] iConfigurationArray = iProjectDescription.getConfigurations();
        int n = 0;
        while (n < iConfigurationArray.length) {
            if (n == 0) {
                iConfiguration = iManagedProject.createConfiguration(iConfigurationArray[n], String.valueOf(iProjectDescription.getId()) + "." + n);
            } else {
                iManagedProject.createConfiguration(iConfigurationArray[n], String.valueOf(iProjectDescription.getId()) + "." + n);
            }
            ++n;
        }
        ManagedBuildManager.setDefaultConfiguration((IProject)iProject, iConfiguration);
        IResourceConfiguration iResourceConfiguration = iConfiguration.createResourceConfiguration(iFile);
        IResourceConfiguration[] iResourceConfigurationArray = iConfiguration.getResourceConfigurations();
        Assert.assertEquals((int)1, (int)iResourceConfigurationArray.length);
        ITool[] iToolArray = iResourceConfiguration.getTools();
        Assert.assertNotNull((Object)iToolArray);
        Assert.assertEquals((int)1, (int)iToolArray.length);
        ITool iTool = iToolArray[0];
        String string = iTool.getToolFlags();
        IOption iOption = iTool.getOptionById("testgnu.c.compiler.exe.debug.option.debugging.level");
        String string2 = iOption.getStringValue();
        IOption iOption2 = ManagedBuildManager.setOption((IResourceConfiguration)iResourceConfiguration, (IHoldsOptions)iTool, (IOption)iOption, (String)"gnu.c.debugging.level.minimal");
        String string3 = iOption2.getStringValue();
        String string4 = iTool.getToolFlags();
        Assert.assertNotSame((Object)string2, (Object)string3);
        ManagedBuildManager.resetResourceConfiguration((IProject)iProject, (IResourceConfiguration)iResourceConfiguration);
        String string5 = iTool.getToolFlags();
        Assert.assertNotSame((Object)string5, (Object)string4);
        Assert.assertEquals((String)string, (String)string5);
        iProject.close(null);
        this.removeProject(projectName);
    }

    public void testResourceConfigurationBuildInfo() throws Exception {
        IFile iFile;
        IProjectDescription iProjectDescription;
        IProject iProject = null;
        try {
            iProject = this.createProject(projectName);
            ManagedBuildTestHelper.addManagedBuildNature(iProject);
            iProjectDescription = iProject.getDescription();
            if (iProjectDescription != null) {
                Assert.assertTrue((boolean)iProjectDescription.hasNature(ManagedCProjectNature.MNG_NATURE_ID));
            }
        }
        catch (CoreException coreException) {
            Assert.fail((String)("Test failed on project creation: " + coreException.getLocalizedMessage()));
        }
        ManagedBuildManager.getDefinedProjectTypes();
        iProjectDescription = ManagedBuildManager.getProjectType((String)"cdt.managedbuild.target.testgnu21.exe");
        Assert.assertNotNull((Object)iProjectDescription);
        IManagedProject iManagedProject = ManagedBuildManager.createManagedProject((IResource)iProject, (IProjectType)iProjectDescription);
        Assert.assertEquals((String)iManagedProject.getName(), (String)iProjectDescription.getName());
        Assert.assertFalse((boolean)iManagedProject.equals(iProjectDescription));
        ManagedBuildManager.setNewProjectVersion((IProject)iProject);
        IFile iFile2 = iProject.getProject().getFile("main.c");
        if (!iFile2.exists()) {
            iFile2.create((InputStream)new ByteArrayInputStream("#include <stdio.h>\n extern void bar(); \n int main() { \nprintf(\"Hello, World!!\"); \n bar();\n return 0; }".getBytes()), false, null);
        }
        if (!(iFile = iProject.getProject().getFile("bar.c")).exists()) {
            iFile.create((InputStream)new ByteArrayInputStream("#include <stdio.h>\n void bar() { \nprintf(\"Hello, bar()!!\");\n return; }".getBytes()), false, null);
        }
        IConfiguration iConfiguration = null;
        IConfiguration[] iConfigurationArray = iProjectDescription.getConfigurations();
        int n = 0;
        while (n < iConfigurationArray.length) {
            if (n == 0) {
                iConfiguration = iManagedProject.createConfiguration(iConfigurationArray[n], String.valueOf(iProjectDescription.getId()) + "." + n);
            } else {
                iManagedProject.createConfiguration(iConfigurationArray[n], String.valueOf(iProjectDescription.getId()) + "." + n);
            }
            ++n;
        }
        ManagedBuildManager.setDefaultConfiguration((IProject)iProject, iConfiguration);
        String string = iConfiguration.getId();
        IResourceConfiguration iResourceConfiguration = iConfiguration.createResourceConfiguration(iFile2);
        IResourceConfiguration iResourceConfiguration2 = iConfiguration.createResourceConfiguration(iFile);
        IResourceConfiguration[] iResourceConfigurationArray = iConfiguration.getResourceConfigurations();
        Assert.assertEquals((int)2, (int)iResourceConfigurationArray.length);
        String string2 = iResourceConfiguration.getResourcePath();
        String string3 = iResourceConfiguration2.getResourcePath();
        ITool[] iToolArray = iResourceConfiguration.getTools();
        Assert.assertNotNull((Object)iToolArray);
        Assert.assertEquals((int)1, (int)iToolArray.length);
        ITool[] iToolArray2 = iResourceConfiguration2.getTools();
        Assert.assertNotNull((Object)iToolArray2);
        Assert.assertEquals((int)1, (int)iToolArray2.length);
        ITool iTool = iToolArray[0];
        iTool.getToolFlags();
        ITool iTool2 = iToolArray2[0];
        iTool2.getToolFlags();
        IOption iOption = iTool.getOptionById("testgnu.c.compiler.exe.debug.option.optimization.level");
        String string4 = iOption.getStringValue();
        IOption iOption2 = ManagedBuildManager.setOption((IResourceConfiguration)iResourceConfiguration, (IHoldsOptions)iTool, (IOption)iOption, (String)"gnu.c.optimization.level.optimize");
        String string5 = iOption2.getStringValue();
        IOption iOption3 = iTool.getOptionById("testgnu.c.compiler.exe.debug.option.debugging.level");
        String string6 = iOption3.getStringValue();
        IOption iOption4 = ManagedBuildManager.setOption((IResourceConfiguration)iResourceConfiguration, (IHoldsOptions)iTool, (IOption)iOption3, (String)"gnu.c.debugging.level.minimal");
        String string7 = iOption4.getStringValue();
        IOption iOption5 = iTool2.getOptionById("testgnu.c.compiler.exe.debug.option.optimization.level");
        String string8 = iOption5.getStringValue();
        IOption iOption6 = ManagedBuildManager.setOption((IResourceConfiguration)iResourceConfiguration2, (IHoldsOptions)iTool2, (IOption)iOption5, (String)"gnu.c.optimization.level.more");
        String string9 = iOption6.getStringValue();
        IOption iOption7 = iTool2.getOptionById("testgnu.c.compiler.exe.debug.option.debugging.level");
        String string10 = iOption7.getStringValue();
        IOption iOption8 = ManagedBuildManager.setOption((IResourceConfiguration)iResourceConfiguration2, (IHoldsOptions)iTool2, (IOption)iOption7, (String)"gnu.c.debugging.level.default");
        String string11 = iOption8.getStringValue();
        Assert.assertNotSame((Object)string4, (Object)string5);
        Assert.assertNotSame((Object)string6, (Object)string7);
        Assert.assertNotSame((Object)string8, (Object)string9);
        Assert.assertNotSame((Object)string10, (Object)string11);
        ManagedBuildManager.saveBuildInfo((IProject)iProject, (boolean)false);
        ManagedBuildManager.removeBuildInfo((IResource)iProject);
        iProject.close(null);
        iProject.open(null);
        IManagedBuildInfo iManagedBuildInfo = ManagedBuildManager.getBuildInfo((IResource)iProject);
        IManagedProject iManagedProject2 = iManagedBuildInfo.getManagedProject();
        IConfiguration[] iConfigurationArray2 = iManagedProject2.getConfigurations();
        Assert.assertEquals((int)2, (int)iConfigurationArray2.length);
        IConfiguration iConfiguration2 = iManagedBuildInfo.getDefaultConfiguration();
        Assert.assertEquals((String)string, (String)iConfiguration2.getId());
        IResourceConfiguration[] iResourceConfigurationArray2 = iConfiguration2.getResourceConfigurations();
        Assert.assertEquals((int)2, (int)iResourceConfigurationArray2.length);
        IResourceConfiguration iResourceConfiguration3 = iConfiguration2.getResourceConfiguration(string2);
        Assert.assertNotNull((Object)iResourceConfiguration3);
        ITool[] iToolArray3 = iResourceConfiguration3.getTools();
        Assert.assertEquals((int)1, (int)iToolArray3.length);
        ITool iTool3 = iToolArray3[0];
        IOption iOption9 = iTool3.getOptionById(iOption2.getId());
        Assert.assertNotNull((Object)iOption9);
        String string12 = iOption9.getStringValue();
        IOption iOption10 = iTool3.getOptionById(iOption4.getId());
        Assert.assertNotNull((Object)iOption10);
        String string13 = iOption10.getStringValue();
        Assert.assertEquals((String)string5, (String)string12);
        Assert.assertEquals((String)string7, (String)string13);
        IResourceConfiguration iResourceConfiguration4 = iConfiguration2.getResourceConfiguration(string3);
        Assert.assertNotNull((Object)iResourceConfiguration4);
        ITool[] iToolArray4 = iResourceConfiguration4.getTools();
        Assert.assertEquals((int)1, (int)iToolArray4.length);
        ITool iTool4 = iToolArray4[0];
        IOption iOption11 = iTool4.getOptionById(iOption6.getId());
        Assert.assertNotNull((Object)iOption11);
        String string14 = iOption11.getStringValue();
        IOption iOption12 = iTool4.getOptionById(iOption8.getId());
        Assert.assertNotNull((Object)iOption12);
        String string15 = iOption12.getStringValue();
        Assert.assertEquals((String)string9, (String)string14);
        Assert.assertEquals((String)string11, (String)string15);
        iProject.close(null);
        this.removeProject(projectName);
    }

    private IProject createProject(String string) throws CoreException {
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        final IProject iProject = iWorkspaceRoot.getProject(string);
        IProject iProject2 = null;
        if (!iProject.exists()) {
            IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
            IWorkspaceDescription iWorkspaceDescription = iWorkspace.getDescription();
            iWorkspaceDescription.setAutoBuilding(false);
            iWorkspace.setDescription(iWorkspaceDescription);
            IProjectDescription iProjectDescription = iWorkspace.newProjectDescription(iProject.getName());
            iProject2 = CCorePlugin.getDefault().createCProject(iProjectDescription, iProject, (IProgressMonitor)new NullProgressMonitor(), MakeCorePlugin.MAKE_PROJECT_ID);
        } else {
            IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
            IWorkspaceRunnable iWorkspaceRunnable = new IWorkspaceRunnable(){

                public void run(IProgressMonitor iProgressMonitor) throws CoreException {
                    iProject.refreshLocal(2, iProgressMonitor);
                }
            };
            NullProgressMonitor nullProgressMonitor = new NullProgressMonitor();
            iWorkspace.run(iWorkspaceRunnable, (ISchedulingRule)iWorkspaceRoot, 1, (IProgressMonitor)nullProgressMonitor);
            iProject2 = iProject;
        }
        if (!iProject2.isOpen()) {
            iProject2.open((IProgressMonitor)new NullProgressMonitor());
        }
        return iProject2;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void removeProject(String string) {
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject iProject = iWorkspaceRoot.getProject(string);
        if (!iProject.exists()) return;
        try {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            try {
                System.gc();
                System.runFinalization();
                iProject.delete(true, true, null);
                throw throwable;
            }
            catch (CoreException coreException) {
                Assert.assertTrue((boolean)false);
            }
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        try {}
        catch (CoreException coreException) {
            Assert.assertTrue((boolean)false);
            return;
        }
        System.gc();
        System.runFinalization();
        iProject.delete(true, true, null);
    }

    public void testProjectCreation() throws BuildException {
        IProjectDescription iProjectDescription;
        IProject iProject = null;
        try {
            iProject = this.createProject(projectName);
            ManagedBuildTestHelper.addManagedBuildNature(iProject);
            iProjectDescription = iProject.getDescription();
            if (iProjectDescription != null) {
                Assert.assertTrue((boolean)iProjectDescription.hasNature(ManagedCProjectNature.MNG_NATURE_ID));
            }
        }
        catch (CoreException coreException) {
            Assert.fail((String)("Test failed on project creation: " + coreException.getLocalizedMessage()));
        }
        ManagedBuildManager.getDefinedProjectTypes();
        iProjectDescription = ManagedBuildManager.getProjectType((String)"cdt.managedbuild.target.testgnu21.exe");
        Assert.assertNotNull((Object)iProjectDescription);
        IManagedProject iManagedProject = ManagedBuildManager.createManagedProject((IResource)iProject, (IProjectType)iProjectDescription);
        Assert.assertEquals((String)iManagedProject.getName(), (String)iProjectDescription.getName());
        Assert.assertFalse((boolean)iManagedProject.equals(iProjectDescription));
        ManagedBuildManager.setNewProjectVersion((IProject)iProject);
        IConfiguration iConfiguration = null;
        IConfiguration[] iConfigurationArray = iProjectDescription.getConfigurations();
        int n = 0;
        while (n < iConfigurationArray.length) {
            if (n == 0) {
                iConfiguration = iManagedProject.createConfiguration(iConfigurationArray[n], String.valueOf(iProjectDescription.getId()) + "." + n);
            } else {
                iManagedProject.createConfiguration(iConfigurationArray[n], String.valueOf(iProjectDescription.getId()) + "." + n);
            }
            ++n;
        }
        ManagedBuildManager.setDefaultConfiguration((IProject)iProject, iConfiguration);
        IStatus iStatus = ManagedBuildManager.initBuildInfoContainer((IResource)iProject);
        if (iStatus.getCode() != 0) {
            Assert.fail((String)("Initializing build information failed for: " + iProject.getName() + " because: " + iStatus.getMessage()));
        }
        iConfigurationArray = iManagedProject.getConfigurations();
        ITool[] iToolArray = iConfigurationArray[0].getTools();
        IOptionCategory iOptionCategory = iToolArray[0].getTopOptionCategory();
        IOptionCategory[] iOptionCategoryArray = iOptionCategory.getChildCategories();
        Object[][] objectArray = iOptionCategoryArray[0].getOptions(iConfigurationArray[0]);
        ITool iTool = (ITool)objectArray[0][0];
        IOption iOption = (IOption)objectArray[0][1];
        iConfigurationArray[0].setOption((IHoldsOptions)iTool, iOption, "1");
        objectArray = iOptionCategoryArray[0].getOptions(null);
        iTool = (ITool)objectArray[0][0];
        iOption = (IOption)objectArray[0][1];
        Assert.assertEquals((String)"x", (String)iOption.getStringValue());
        objectArray = iOptionCategoryArray[0].getOptions(iConfigurationArray[0]);
        iTool = (ITool)objectArray[0][0];
        iOption = (IOption)objectArray[0][1];
        Assert.assertEquals((String)"z", (String)iOption.getStringValue());
        ManagedBuildManager.saveBuildInfo((IProject)iProject, (boolean)true);
        ManagedBuildManager.removeBuildInfo((IResource)iProject);
        try {
            iProject.close(null);
        }
        catch (CoreException coreException) {
            Assert.fail((String)("Failed on project close: " + coreException.getLocalizedMessage()));
        }
        try {
            iProject.open(null);
        }
        catch (CoreException coreException) {
            Assert.fail((String)("Failed on project open: " + coreException.getLocalizedMessage()));
        }
        IManagedBuildInfo iManagedBuildInfo = ManagedBuildManager.getBuildInfo((IResource)iProject);
        Assert.assertEquals((String)iConfiguration.getId(), (String)iManagedBuildInfo.getDefaultConfiguration().getId());
        ManagedBuildManager.removeBuildInfo((IResource)iProject);
    }

    public void testResourceRename() throws Exception {
        IFile iFile;
        IFolder iFolder;
        IFile iFile2;
        IProjectDescription iProjectDescription;
        IProject iProject = null;
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        try {
            iProject = this.createProject(projectName);
            ManagedBuildTestHelper.addManagedBuildNature(iProject);
            iProjectDescription = iProject.getDescription();
            if (iProjectDescription != null) {
                Assert.assertTrue((boolean)iProjectDescription.hasNature(ManagedCProjectNature.MNG_NATURE_ID));
            }
        }
        catch (CoreException coreException) {
            Assert.fail((String)("Test failed on project creation: " + coreException.getLocalizedMessage()));
        }
        ManagedBuildManager.getDefinedProjectTypes();
        iProjectDescription = ManagedBuildManager.getProjectType((String)"cdt.managedbuild.target.testgnu21.exe");
        Assert.assertNotNull((Object)iProjectDescription);
        IManagedProject iManagedProject = ManagedBuildManager.createManagedProject((IResource)iProject, (IProjectType)iProjectDescription);
        Assert.assertEquals((String)iManagedProject.getName(), (String)iProjectDescription.getName());
        Assert.assertFalse((boolean)iManagedProject.equals(iProjectDescription));
        ManagedBuildManager.setNewProjectVersion((IProject)iProject);
        IFile iFile3 = iProject.getProject().getFile("main.c");
        if (!iFile3.exists()) {
            iFile3.create((InputStream)new ByteArrayInputStream("#include <stdio.h>\n extern void bar(); \n int main() { \nprintf(\"Hello, World!!\"); \n bar();\n return 0; }".getBytes()), false, null);
        }
        if (!(iFile2 = iProject.getProject().getFile("a.c")).exists()) {
            iFile2.create((InputStream)new ByteArrayInputStream("#include <stdio.h>\n void bar() { \nprintf(\"Hello, bar()!!\");\n return; }".getBytes()), false, null);
        }
        if (!(iFolder = iProject.getProject().getFolder("dir")).exists()) {
            iFolder.create(true, true, null);
        }
        if (!(iFile = iFolder.getFile("b.c")).exists()) {
            iFile.create((InputStream)new ByteArrayInputStream("#include <stdio.h>\n void bar1() { \nprintf(\"Hello, bar1()!!\");\n return; }".getBytes()), false, null);
        }
        IConfiguration iConfiguration = null;
        IConfiguration[] iConfigurationArray = iProjectDescription.getConfigurations();
        int n = 0;
        while (n < iConfigurationArray.length) {
            if (n == 0) {
                iConfiguration = iManagedProject.createConfiguration(iConfigurationArray[n], String.valueOf(iProjectDescription.getId()) + "." + n);
            } else {
                iManagedProject.createConfiguration(iConfigurationArray[n], String.valueOf(iProjectDescription.getId()) + "." + n);
            }
            ++n;
        }
        ManagedBuildManager.setDefaultConfiguration((IProject)iProject, iConfiguration);
        IResourceConfiguration iResourceConfiguration = iConfiguration.createResourceConfiguration(iFile3);
        IResourceConfiguration iResourceConfiguration2 = iConfiguration.createResourceConfiguration(iFile2);
        IResourceConfiguration iResourceConfiguration3 = iConfiguration.createResourceConfiguration(iFile);
        IResourceConfiguration[] iResourceConfigurationArray = iConfiguration.getResourceConfigurations();
        Assert.assertEquals((Object)iResourceConfiguration, (Object)iConfiguration.getResourceConfiguration(iFile3.getFullPath().toString()));
        Assert.assertEquals((Object)iResourceConfiguration2, (Object)iConfiguration.getResourceConfiguration(iFile2.getFullPath().toString()));
        Assert.assertEquals((Object)iResourceConfiguration3, (Object)iConfiguration.getResourceConfiguration(iFile.getFullPath().toString()));
        Assert.assertEquals((int)3, (int)iResourceConfigurationArray.length);
        iFile3.move(iFile3.getFullPath().removeLastSegments(1).append("main1.c"), true, false, null);
        iFile3 = (IFile)iProject.findMember("main1.c");
        Assert.assertEquals((Object)iResourceConfiguration, (Object)iConfiguration.getResourceConfiguration(iFile3.getFullPath().toString()));
        Assert.assertEquals((Object)iResourceConfiguration2, (Object)iConfiguration.getResourceConfiguration(iFile2.getFullPath().toString()));
        Assert.assertEquals((Object)iResourceConfiguration3, (Object)iConfiguration.getResourceConfiguration(iFile.getFullPath().toString()));
        iResourceConfigurationArray = iConfiguration.getResourceConfigurations();
        Assert.assertEquals((int)3, (int)iResourceConfigurationArray.length);
        iFolder.move(iFolder.getFullPath().removeLastSegments(1).append("dir1"), true, false, null);
        iFolder = (IFolder)iProject.findMember("dir1");
        iFile = (IFile)iFolder.findMember("b.c");
        Assert.assertEquals((Object)iResourceConfiguration, (Object)iConfiguration.getResourceConfiguration(iFile3.getFullPath().toString()));
        Assert.assertEquals((Object)iResourceConfiguration2, (Object)iConfiguration.getResourceConfiguration(iFile2.getFullPath().toString()));
        Assert.assertEquals((Object)iResourceConfiguration3, (Object)iConfiguration.getResourceConfiguration(iFile.getFullPath().toString()));
        iResourceConfigurationArray = iConfiguration.getResourceConfigurations();
        Assert.assertEquals((int)3, (int)iResourceConfigurationArray.length);
        iFile.move(iFile.getFullPath().removeLastSegments(1).append("b1.c"), true, false, null);
        iFile = (IFile)iFolder.findMember("b1.c");
        Assert.assertEquals((Object)iResourceConfiguration, (Object)iConfiguration.getResourceConfiguration(iFile3.getFullPath().toString()));
        Assert.assertEquals((Object)iResourceConfiguration2, (Object)iConfiguration.getResourceConfiguration(iFile2.getFullPath().toString()));
        Assert.assertEquals((Object)iResourceConfiguration3, (Object)iConfiguration.getResourceConfiguration(iFile.getFullPath().toString()));
        iResourceConfigurationArray = iConfiguration.getResourceConfigurations();
        Assert.assertEquals((int)3, (int)iResourceConfigurationArray.length);
        IProjectDescription iProjectDescription2 = iProject.getDescription();
        iProjectDescription2.setName(renamedProjectName1);
        iProject.move(iProjectDescription2, true, null);
        iProject = (IProject)iWorkspaceRoot.findMember(renamedProjectName1);
        iFile3 = (IFile)iProject.findMember("main1.c");
        iFile2 = (IFile)iProject.findMember("a.c");
        iFolder = (IFolder)iProject.findMember("dir1");
        iFile = (IFile)iFolder.findMember("b1.c");
        Assert.assertEquals((Object)iResourceConfiguration, (Object)iConfiguration.getResourceConfiguration(iFile3.getFullPath().toString()));
        Assert.assertEquals((Object)iResourceConfiguration2, (Object)iConfiguration.getResourceConfiguration(iFile2.getFullPath().toString()));
        Assert.assertEquals((Object)iResourceConfiguration3, (Object)iConfiguration.getResourceConfiguration(iFile.getFullPath().toString()));
        iResourceConfigurationArray = iConfiguration.getResourceConfigurations();
        Assert.assertEquals((int)3, (int)iResourceConfigurationArray.length);
        final IResource[] iResourceArray = new IResource[]{iProject, iFile3, iFile2, iFolder, iFile};
        ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

            public void run(IProgressMonitor iProgressMonitor) throws CoreException {
                IProject iProject = (IProject)iResourceArray[0];
                IFile iFile = (IFile)iResourceArray[1];
                IFile iFile2 = (IFile)iResourceArray[2];
                IFolder iFolder = (IFolder)iResourceArray[3];
                IFile iFile3 = (IFile)iResourceArray[4];
                iFile.move(iFile.getFullPath().removeLastSegments(1).append("main2.c"), true, false, null);
                iFile = (IFile)iProject.findMember("main2.c");
                iFolder.move(iFolder.getFullPath().removeLastSegments(1).append("dir2"), true, false, null);
                iFolder = (IFolder)iProject.findMember("dir2");
                iFile3 = (IFile)iFolder.findMember("b1.c");
                iFile3.move(iFile3.getFullPath().removeLastSegments(1).append("b2.c"), true, false, null);
                iFile3 = (IFile)iFolder.findMember("b2.c");
                IProjectDescription iProjectDescription = iProject.getDescription();
                iProjectDescription.setName(ResourceBuildCoreTests.renamedProjectName2);
                iProject.move(iProjectDescription, true, null);
                iProject = (IProject)ResourcesPlugin.getWorkspace().getRoot().findMember(ResourceBuildCoreTests.renamedProjectName2);
                iFile = (IFile)iProject.findMember("main2.c");
                iFile2 = (IFile)iProject.findMember("a.c");
                iFolder = (IFolder)iProject.findMember("dir2");
                iFile3 = (IFile)iFolder.findMember("b2.c");
                iResourceArray[0] = iProject;
                iResourceArray[1] = iFile;
                iResourceArray[2] = iFile2;
                iResourceArray[3] = iFolder;
                iResourceArray[4] = iFile3;
            }
        }, (ISchedulingRule)iWorkspaceRoot, 1, null);
        iProject = (IProject)iResourceArray[0];
        iFile3 = (IFile)iResourceArray[1];
        iFile2 = (IFile)iResourceArray[2];
        iFolder = (IFolder)iResourceArray[3];
        iFile = (IFile)iResourceArray[4];
        Assert.assertEquals((Object)iResourceConfiguration, (Object)iConfiguration.getResourceConfiguration(iFile3.getFullPath().toString()));
        Assert.assertEquals((Object)iResourceConfiguration2, (Object)iConfiguration.getResourceConfiguration(iFile2.getFullPath().toString()));
        Assert.assertEquals((Object)iResourceConfiguration3, (Object)iConfiguration.getResourceConfiguration(iFile.getFullPath().toString()));
        iResourceConfigurationArray = iConfiguration.getResourceConfigurations();
        Assert.assertEquals((int)3, (int)iResourceConfigurationArray.length);
        iFile2.delete(true, null);
        Assert.assertEquals((Object)iResourceConfiguration, (Object)iConfiguration.getResourceConfiguration(iFile3.getFullPath().toString()));
        Assert.assertEquals(null, (Object)iConfiguration.getResourceConfiguration(iFile2.getFullPath().toString()));
        Assert.assertEquals((Object)iResourceConfiguration3, (Object)iConfiguration.getResourceConfiguration(iFile.getFullPath().toString()));
        iResourceConfigurationArray = iConfiguration.getResourceConfigurations();
        Assert.assertEquals((int)2, (int)iResourceConfigurationArray.length);
        iFolder.delete(true, null);
        Assert.assertEquals((Object)iResourceConfiguration, (Object)iConfiguration.getResourceConfiguration(iFile3.getFullPath().toString()));
        Assert.assertEquals(null, (Object)iConfiguration.getResourceConfiguration(iFile2.getFullPath().toString()));
        Assert.assertEquals(null, (Object)iConfiguration.getResourceConfiguration(iFile.getFullPath().toString()));
        iResourceConfigurationArray = iConfiguration.getResourceConfigurations();
        Assert.assertEquals((int)1, (int)iResourceConfigurationArray.length);
        iProject.close(null);
        this.removeProject(renamedProjectName2);
    }
}

