/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.standardbuilder.core.tests;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoCollector;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoConsoleParser;
import org.eclipse.cdt.make.core.scannerconfig.ScannerInfoTypes;
import org.eclipse.cdt.make.internal.core.scannerconfig.gnu.GCCScannerInfoConsoleParser;

public class ScannerConfigConsoleParserTests
extends TestCase {
    private IScannerInfoConsoleParser clParser;

    public ScannerConfigConsoleParserTests(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.clParser = new GCCScannerInfoConsoleParser();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.clParser.shutdown();
        this.clParser = null;
    }

    public void testParsingIncludePaths() {
        IScannerInfoCollector iScannerInfoCollector = new IScannerInfoCollector(){
            private List sumIncludes = new ArrayList();

            public void contributeToScannerConfig(Object object, Map map) {
                this.sumIncludes.addAll((List)map.get(ScannerInfoTypes.INCLUDE_PATHS));
            }

            public List getCollectedScannerInfo(Object object, ScannerInfoTypes scannerInfoTypes) {
                if (scannerInfoTypes.equals(ScannerInfoTypes.INCLUDE_PATHS)) {
                    return this.sumIncludes;
                }
                return new ArrayList();
            }
        };
        this.clParser.startup(null, null, iScannerInfoCollector, null);
        this.clParser.processLine("gcc -I /dir/include -I C:\\dir\\include -ID:/dir/include -c test.c");
        this.clParser.processLine("gcc -I -I /dir2/include -c test.c");
        this.clParser.processLine("gcc -I../back_dir/include -I./cur_dir/include -c test.c");
        this.clParser.processLine("gcc '-I /squoted/dir1' -I '/squoted/dir2' -I'/squoted/dir3' -c test.c");
        this.clParser.processLine("gcc \"-I /dquoted/dir1\" -I \"/dquoted/dir2\" -I\"/dquoted/dir3\" -c test.c");
        this.clParser.processLine("gcc '-I /with spaces 1' -I'/with spaces 2' -c test.c");
        this.clParser.processLine("gcc \"-I /with spaces 3\" -I \"/with spaces 4\" -c test.c");
        this.clParser.processLine("gcc -I /with\\ spaces\\ 5 -c test.c");
        this.clParser.processLine("gcc -I '\\\\server1\\include' '-I\\\\server2\\include' -I \"\\\\server3\\include\" -c test.c");
        this.clParser.processLine("gcc -I //server4/include -I '//server5/include' '-I//server6/include' -c test.c");
        this.clParser.processLine("gcc -I \\");
        this.clParser.processLine("/multiline\\");
        this.clParser.processLine("/dir -c test.c");
        List list = iScannerInfoCollector.getCollectedScannerInfo(null, ScannerInfoTypes.INCLUDE_PATHS);
        Assert.assertTrue((boolean)list.contains("/dir/include"));
        Assert.assertTrue((boolean)list.contains("C:\\dir\\include"));
        Assert.assertTrue((boolean)list.contains("D:/dir/include"));
        Assert.assertTrue((boolean)list.contains("/dir2/include"));
        Assert.assertTrue((boolean)list.contains("../back_dir/include"));
        Assert.assertTrue((boolean)list.contains("./cur_dir/include"));
        Assert.assertTrue((boolean)list.contains("/squoted/dir1"));
        Assert.assertTrue((boolean)list.contains("/squoted/dir2"));
        Assert.assertTrue((boolean)list.contains("/squoted/dir3"));
        Assert.assertTrue((boolean)list.contains("/dquoted/dir1"));
        Assert.assertTrue((boolean)list.contains("/dquoted/dir2"));
        Assert.assertTrue((boolean)list.contains("/dquoted/dir3"));
        Assert.assertTrue((boolean)list.contains("/with spaces 1"));
        Assert.assertTrue((boolean)list.contains("/with spaces 2"));
        Assert.assertTrue((boolean)list.contains("/with spaces 3"));
        Assert.assertTrue((boolean)list.contains("/with spaces 4"));
        Assert.assertTrue((boolean)list.contains("/with spaces 5"));
        Assert.assertTrue((boolean)list.contains("\\\\server1\\include"));
        Assert.assertTrue((boolean)list.contains("\\\\server2\\include"));
        Assert.assertTrue((boolean)list.contains("\\\\server3\\include"));
        Assert.assertTrue((boolean)list.contains("//server4/include"));
        Assert.assertTrue((boolean)list.contains("//server5/include"));
        Assert.assertTrue((boolean)list.contains("//server6/include"));
        Assert.assertTrue((boolean)list.contains("/multiline/dir"));
        Assert.assertTrue((list.size() == 24 ? 1 : 0) != 0);
    }

    public void testParsingSymbolDefinitions() {
        IScannerInfoCollector iScannerInfoCollector = new IScannerInfoCollector(){
            private List sumSymbols = new ArrayList();

            public void contributeToScannerConfig(Object object, Map map) {
                this.sumSymbols.addAll((List)map.get(ScannerInfoTypes.SYMBOL_DEFINITIONS));
            }

            public List getCollectedScannerInfo(Object object, ScannerInfoTypes scannerInfoTypes) {
                if (scannerInfoTypes.equals(ScannerInfoTypes.SYMBOL_DEFINITIONS)) {
                    return this.sumSymbols;
                }
                return new ArrayList();
            }
        };
        this.clParser.startup(null, null, iScannerInfoCollector, null);
        this.clParser.processLine("gcc -DMACRO1 -D MACRO2=value2 -c test.c");
        this.clParser.processLine("gcc -D -DMACRO3 -c test.c");
        this.clParser.processLine("gcc -D MACRO4='value4' -D 'MACRO5=value5' '-D MACRO6 = value6' -c test.c");
        this.clParser.processLine("gcc -D'MACRO7=\"value 7\"' -D MACRO8='\"value 8\"' -c test.c");
        this.clParser.processLine("gcc -DMACRO9=\"value9\" -D \"MACRO10=value10\" \"-D MACRO11 = value11\" -c test.c");
        this.clParser.processLine("gcc -D\"MACRO12=\\\"value 12\\\"\" -D MACRO13=\"\\\"value 13\\\"\" -c test.c");
        this.clParser.processLine("gcc -D \\");
        this.clParser.processLine("MULTILINE=TRUE\t\\");
        this.clParser.processLine("-c test.c");
        this.clParser.processLine("gcc -D 'SUM(x, y) = (x) + (y)' -c test.c");
        List list = iScannerInfoCollector.getCollectedScannerInfo(null, ScannerInfoTypes.SYMBOL_DEFINITIONS);
        Assert.assertTrue((boolean)list.contains("MACRO1"));
        Assert.assertTrue((boolean)list.contains("MACRO2=value2"));
        Assert.assertTrue((boolean)list.contains("MACRO3"));
        Assert.assertTrue((boolean)list.contains("MACRO4=value4"));
        Assert.assertTrue((boolean)list.contains("MACRO5=value5"));
        Assert.assertTrue((boolean)list.contains("MACRO6 = value6"));
        Assert.assertTrue((boolean)list.contains("MACRO7=\"value 7\""));
        Assert.assertTrue((boolean)list.contains("MACRO8=\"value 8\""));
        Assert.assertTrue((boolean)list.contains("MACRO9=value9"));
        Assert.assertTrue((boolean)list.contains("MACRO10=value10"));
        Assert.assertTrue((boolean)list.contains("MACRO11 = value11"));
        Assert.assertTrue((boolean)list.contains("MACRO12=\"value 12\""));
        Assert.assertTrue((boolean)list.contains("MACRO13=\"value 13\""));
        Assert.assertTrue((boolean)list.contains("MULTILINE=TRUE"));
        Assert.assertTrue((boolean)list.contains("SUM(x, y) = (x) + (y)"));
        Assert.assertTrue((list.size() == 15 ? 1 : 0) != 0);
    }

    public void testParsingSymbolDefinitions_bug80271() {
        IScannerInfoCollector iScannerInfoCollector = new IScannerInfoCollector(){
            private List sumSymbols = new ArrayList();

            public void contributeToScannerConfig(Object object, Map map) {
                this.sumSymbols.addAll((List)map.get(ScannerInfoTypes.SYMBOL_DEFINITIONS));
            }

            public List getCollectedScannerInfo(Object object, ScannerInfoTypes scannerInfoTypes) {
                if (scannerInfoTypes.equals(ScannerInfoTypes.SYMBOL_DEFINITIONS)) {
                    return this.sumSymbols;
                }
                return new ArrayList();
            }
        };
        this.clParser.startup(null, null, iScannerInfoCollector, null);
        this.clParser.processLine("gcc -DMACRO1 -I ..\\inc -c ..\\source\\source.c");
        List list = iScannerInfoCollector.getCollectedScannerInfo(null, ScannerInfoTypes.SYMBOL_DEFINITIONS);
        Assert.assertTrue((boolean)list.contains("MACRO1"));
        Assert.assertTrue((list.size() == 1 ? 1 : 0) != 0);
    }
}

