/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core.scannerconfig2;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IContainerEntry;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.core.scannerconfig.IDiscoveredPathManager;
import org.eclipse.cdt.make.core.scannerconfig.IExternalScannerInfoProvider;
import org.eclipse.cdt.make.core.scannerconfig.IScannerConfigBuilderInfo2;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoCollector;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoCollector2;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoCollector3;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoCollectorCleaner;
import org.eclipse.cdt.make.core.scannerconfig.InfoContext;
import org.eclipse.cdt.make.core.scannerconfig.ScannerInfoTypes;
import org.eclipse.cdt.make.internal.core.MakeMessages;
import org.eclipse.cdt.make.internal.core.scannerconfig.DiscoveredPathContainer;
import org.eclipse.cdt.make.internal.core.scannerconfig.DiscoveredPathInfo;
import org.eclipse.cdt.make.internal.core.scannerconfig.DiscoveredScannerInfoStore;
import org.eclipse.cdt.make.internal.core.scannerconfig.ScannerConfigUtil;
import org.eclipse.cdt.make.internal.core.scannerconfig.util.CygpathTranslator;
import org.eclipse.cdt.make.internal.core.scannerconfig.util.TraceUtil;
import org.eclipse.cdt.make.internal.core.scannerconfig2.SCProfileInstance;
import org.eclipse.cdt.make.internal.core.scannerconfig2.ScannerConfigProfileManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.w3c.dom.Element;

public class PerProjectSICollector
implements IScannerInfoCollector3,
IScannerInfoCollectorCleaner {
    public static final String COLLECTOR_ID = String.valueOf(MakeCorePlugin.getUniqueIdentifier()) + ".PerProjectSICollector";
    private IProject project;
    private InfoContext context;
    private Map discoveredSI = new HashMap();
    private List sumDiscoveredIncludes = new ArrayList();
    private Map sumDiscoveredSymbols = new LinkedHashMap();
    private boolean scPersisted = false;

    public void setProject(IProject project) {
        this.project = project;
        this.context = new InfoContext(project);
    }

    public synchronized void contributeToScannerConfig(Object resource, Map scannerInfo) {
        String errorMessage = null;
        if (resource == null) {
            errorMessage = "resource is null";
        } else if (!(resource instanceof IResource)) {
            errorMessage = "resource is not an IResource";
        } else if (((IResource)resource).getProject() == null) {
            errorMessage = "project is null";
        } else if (((IResource)resource).getProject() != this.project) {
            errorMessage = "wrong project";
        }
        if (errorMessage != null) {
            TraceUtil.outputError("PerProjectSICollector.contributeToScannerConfig : ", errorMessage);
            return;
        }
        if (this.scPersisted) {
            this.discoveredSI.clear();
            this.scPersisted = false;
        }
        try {
            if (this.project.hasNature("org.eclipse.cdt.core.cnature") || this.project.hasNature("org.eclipse.cdt.core.ccnature")) {
                Iterator I = scannerInfo.keySet().iterator();
                while (I.hasNext()) {
                    ScannerInfoTypes siType = (ScannerInfoTypes)I.next();
                    List delta = (List)scannerInfo.get(siType);
                    ArrayList discovered = (ArrayList)this.discoveredSI.get(siType);
                    if (discovered == null) {
                        discovered = new ArrayList(delta);
                        this.discoveredSI.put(siType, discovered);
                        continue;
                    }
                    if (siType.equals(ScannerInfoTypes.INCLUDE_PATHS)) {
                        this.contribute(discovered, delta, true);
                        continue;
                    }
                    this.contribute(discovered, delta, false);
                }
            }
        }
        catch (CoreException e) {
            MakeCorePlugin.log(e);
        }
    }

    private boolean contribute(List discovered, List delta, boolean ordered) {
        if (delta == null || delta.isEmpty()) {
            return false;
        }
        return this.addItemsWithOrder(discovered, delta, ordered);
    }

    private boolean addItemsWithOrder(List sumIncludes, List includes, boolean ordered) {
        boolean addedIncludes = false;
        int prev = sumIncludes.size() - 1;
        Iterator i = includes.iterator();
        while (i.hasNext()) {
            String item = (String)i.next();
            if (!sumIncludes.contains(item)) {
                sumIncludes.add(prev + 1, item);
                addedIncludes = true;
            }
            int n = prev = ordered ? sumIncludes.indexOf(item) : sumIncludes.size() - 1;
        }
        return addedIncludes;
    }

    public synchronized void updateScannerConfiguration(IProgressMonitor monitor) throws CoreException {
        IDiscoveredPathManager.IDiscoveredPathInfo pathInfo;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if ((pathInfo = MakeCorePlugin.getDefault().getDiscoveryManager().getDiscoveredInfo(this.project, this.context)) instanceof IDiscoveredPathManager.IPerProjectDiscoveredPathInfo) {
            IDiscoveredPathManager.IPerProjectDiscoveredPathInfo projectPathInfo = (IDiscoveredPathManager.IPerProjectDiscoveredPathInfo)pathInfo;
            monitor.beginTask(MakeMessages.getString("ScannerInfoCollector.Processing"), 100);
            if (pathInfo != null) {
                monitor.subTask(MakeMessages.getString("ScannerInfoCollector.Processing"));
                if (this.scannerConfigNeedsUpdate(projectPathInfo)) {
                    monitor.worked(50);
                    monitor.subTask(String.valueOf(MakeMessages.getString("ScannerInfoCollector.Updating")) + this.project.getName());
                    try {
                        ArrayList<IProject> resourceDelta = new ArrayList<IProject>(1);
                        resourceDelta.add(this.project);
                        MakeCorePlugin.getDefault().getDiscoveryManager().updateDiscoveredInfo(this.context, pathInfo, this.context.isDefaultContext(), resourceDelta);
                        monitor.worked(50);
                    }
                    catch (CoreException e) {
                        MakeCorePlugin.log(e);
                    }
                }
            }
            monitor.done();
            this.scPersisted = true;
        }
    }

    private boolean scannerConfigNeedsUpdate(IDiscoveredPathManager.IPerProjectDiscoveredPathInfo discPathInfo) {
        boolean addedIncludes = this.includePathsNeedUpdate(discPathInfo);
        boolean addedSymbols = this.definedSymbolsNeedUpdate(discPathInfo);
        return addedIncludes | addedSymbols;
    }

    private boolean includePathsNeedUpdate(IDiscoveredPathManager.IPerProjectDiscoveredPathInfo discPathInfo) {
        boolean addedIncludes = false;
        List discoveredIncludes = (List)this.discoveredSI.get(ScannerInfoTypes.INCLUDE_PATHS);
        if (discoveredIncludes != null) {
            LinkedHashMap newPersistedIncludes;
            addedIncludes = this.addItemsWithOrder(this.sumDiscoveredIncludes, discoveredIncludes, true);
            List finalSumIncludes = CygpathTranslator.translateIncludePaths(this.project, this.sumDiscoveredIncludes);
            LinkedHashMap persistedIncludes = discPathInfo.getIncludeMap();
            ArrayList persistedKeyList = new ArrayList(persistedIncludes.keySet());
            addedIncludes = this.addItemsWithOrder(persistedKeyList, finalSumIncludes, true);
            if (addedIncludes) {
                newPersistedIncludes = new LinkedHashMap(persistedKeyList.size());
                Iterator i = persistedKeyList.iterator();
                while (i.hasNext()) {
                    String include = (String)i.next();
                    if (persistedIncludes.containsKey(include)) {
                        newPersistedIncludes.put(include, persistedIncludes.get(include));
                        continue;
                    }
                    newPersistedIncludes.put(include, new Path(include).toFile().exists() ? Boolean.FALSE : Boolean.TRUE);
                }
            } else {
                newPersistedIncludes = persistedIncludes;
            }
            discPathInfo.setIncludeMap(newPersistedIncludes);
        }
        return addedIncludes;
    }

    private Map translateDiscoveredIncludes(List list) {
        int baseSize = list.size();
        LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>(baseSize);
        List translated = CygpathTranslator.translateIncludePaths(this.project, list);
        if (baseSize == translated.size()) {
            int i = 0;
            while (i < baseSize) {
                map.put(translated.get(i), list.get(i));
                ++i;
            }
        } else {
            ArrayList<String> tmpList = new ArrayList<String>(1);
            int i = 0;
            while (i < baseSize) {
                String basePath = (String)list.get(i);
                tmpList.add(0, basePath);
                List tr = CygpathTranslator.translateIncludePaths(this.project, tmpList);
                if (tr.size() != 0) {
                    String translatedPath = (String)tr.get(0);
                    map.put(translatedPath, basePath);
                }
                ++i;
            }
        }
        return map;
    }

    private boolean definedSymbolsNeedUpdate(IDiscoveredPathManager.IPerProjectDiscoveredPathInfo discPathInfo) {
        boolean addedSymbols = false;
        List discoveredSymbols = (List)this.discoveredSI.get(ScannerInfoTypes.SYMBOL_DEFINITIONS);
        if (discoveredSymbols != null) {
            addedSymbols = ScannerConfigUtil.scAddSymbolsList2SymbolEntryMap(this.sumDiscoveredSymbols, discoveredSymbols, false);
            LinkedHashMap persistedSymbols = discPathInfo.getSymbolMap();
            LinkedHashMap candidateSymbols = new LinkedHashMap(persistedSymbols);
            addedSymbols |= ScannerConfigUtil.scAddSymbolEntryMap2SymbolEntryMap(candidateSymbols, this.sumDiscoveredSymbols);
            discPathInfo.setSymbolMap(candidateSymbols);
        }
        return addedSymbols;
    }

    public List getCollectedScannerInfo(Object resource, ScannerInfoTypes type) {
        List rv = null;
        String errorMessage = null;
        if (resource == null) {
            errorMessage = "resource is null";
        } else if (!(resource instanceof IResource)) {
            errorMessage = "resource is not an IResource";
        } else if (((IResource)resource).getProject() == null) {
            errorMessage = "project is null";
        } else if (((IResource)resource).getProject() != this.project) {
            errorMessage = "wrong project";
        }
        if (errorMessage != null) {
            TraceUtil.outputError("PerProjectSICollector.getCollectedScannerInfo : ", errorMessage);
        } else if (this.project.equals((Object)((IResource)resource).getProject())) {
            rv = (List)this.discoveredSI.get(type);
        }
        return rv;
    }

    public Map getDefinedSymbols() {
        Map definedSymbols = ScannerConfigUtil.scSymbolEntryMap2Map(this.sumDiscoveredSymbols);
        return definedSymbols;
    }

    public List getIncludePaths() {
        return this.sumDiscoveredIncludes;
    }

    public void serialize(Element root) {
    }

    public void deserialize(Element root) {
    }

    public void deleteAllPaths(IResource resource) {
        IProject project = resource.getProject();
        if (project != null && project.equals((Object)this.project)) {
            this.sumDiscoveredIncludes.clear();
        }
    }

    public void deleteAllSymbols(IResource resource) {
        IProject project = resource.getProject();
        if (project != null && project.equals((Object)this.project)) {
            this.sumDiscoveredSymbols.clear();
        }
    }

    public void deletePath(IResource resource, String path) {
        IProject project = resource.getProject();
        if (project != null && project.equals((Object)this.project)) {
            this.sumDiscoveredIncludes.remove(path);
        }
    }

    public void deleteSymbol(IResource resource, String symbol) {
        IProject project = resource.getProject();
        if (project != null && project.equals((Object)this.project)) {
            ScannerConfigUtil.removeSymbolEntryValue(symbol, this.sumDiscoveredSymbols);
        }
    }

    public void deleteAll(IResource resource) {
        this.deleteAllPaths(resource);
        this.deleteAllSymbols(resource);
    }

    public IDiscoveredPathManager.IDiscoveredPathInfo createPathInfoObject() {
        DiscoveredPathInfo pathInfo = new DiscoveredPathInfo(this.project);
        try {
            DiscoveredScannerInfoStore.getInstance().loadDiscoveredScannerInfoFromState(this.project, this.context, pathInfo);
        }
        catch (CoreException e) {
            MakeCorePlugin.log(e);
        }
        return pathInfo;
    }

    public static void calculateCompilerBuiltins(final IProject project) throws CModelException {
        PerProjectSICollector.createDiscoveredPathContainer(project, (IProgressMonitor)new NullProgressMonitor());
        String scdProfileId = ScannerConfigProfileManager.PER_PROJECT_PROFILE_ID;
        SCProfileInstance profileInstance = ScannerConfigProfileManager.getInstance().getSCProfileInstance(project, scdProfileId);
        final IScannerConfigBuilderInfo2 buildInfo = ScannerConfigProfileManager.createScannerConfigBuildInfo2(MakeCorePlugin.getDefault().getPluginPreferences(), scdProfileId, true);
        final IScannerInfoCollector collector = profileInstance.getScannerInfoCollector();
        if (collector instanceof IScannerInfoCollectorCleaner) {
            ((IScannerInfoCollectorCleaner)((Object)collector)).deleteAll((IResource)project);
        }
        final IExternalScannerInfoProvider esiProvider = profileInstance.createExternalScannerInfoProvider("specsFile");
        ISafeRunnable runnable = new ISafeRunnable(){

            public void run() throws CoreException {
                NullProgressMonitor monitor = new NullProgressMonitor();
                esiProvider.invokeProvider((IProgressMonitor)monitor, (IResource)project, "specsFile", buildInfo, collector);
                if (collector instanceof IScannerInfoCollector2) {
                    IScannerInfoCollector2 collector2 = (IScannerInfoCollector2)collector;
                    collector2.updateScannerConfiguration((IProgressMonitor)monitor);
                }
            }

            public void handleException(Throwable exception) {
                if (exception instanceof OperationCanceledException) {
                    throw (OperationCanceledException)exception;
                }
            }
        };
        Platform.run((ISafeRunnable)runnable);
    }

    private static void createDiscoveredPathContainer(IProject project, IProgressMonitor monitor) throws CModelException {
        IPathEntry[] entries;
        ArrayList<IPathEntry> newEntries;
        IContainerEntry container = CoreModel.newContainerEntry((IPath)DiscoveredPathContainer.CONTAINER_ID);
        ICProject cProject = CoreModel.getDefault().create(project);
        if (cProject != null && !(newEntries = new ArrayList<IPathEntry>(Arrays.asList(entries = cProject.getRawPathEntries()))).contains(container)) {
            newEntries.add((IPathEntry)container);
            cProject.setRawPathEntries(newEntries.toArray(new IPathEntry[newEntries.size()]), monitor);
        }
        MakeCorePlugin.getDefault().getDiscoveryManager().removeDiscoveredInfo(project);
    }

    public void setInfoContext(InfoContext context) {
        this.context = context;
        this.project = context.getProject();
    }
}

